/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task.flow;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.ow2.proactive.scheduler.common.task.flow.FlowActionType;
import org.ow2.proactive.scheduler.common.task.flow.FlowScript;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlowAction
implements Serializable {
    private String type;
    private int dupNumber = 1;
    private String target = "";
    private String targetContinuation = "";
    private String targetElse = "";
    private String cronExpr = "";
    private static final long serialVersionUID = 84L;

    public FlowAction() {
        this.type = FlowActionType.CONTINUE.toString();
    }

    public FlowAction(FlowActionType type) {
        this.type = type.toString();
    }

    public static FlowAction getDefaultAction(FlowScript script) {
        FlowAction ret = null;
        switch (FlowActionType.parse(script.getActionType())) {
            case REPLICATE: {
                ret = new FlowAction(FlowActionType.CONTINUE);
                break;
            }
            case LOOP: {
                ret = new FlowAction(FlowActionType.CONTINUE);
                break;
            }
            case IF: {
                ret = new FlowAction(FlowActionType.IF);
                ret.setTarget(script.getActionTarget());
                ret.setTargetElse(script.getActionTargetElse());
                ret.setTargetContinuation(script.getActionContinuation());
                break;
            }
            case CONTINUE: {
                ret = new FlowAction(FlowActionType.CONTINUE);
            }
        }
        return ret;
    }

    public FlowActionType getType() {
        return FlowActionType.parse(this.type);
    }

    public int getDupNumber() {
        return this.dupNumber;
    }

    public String getTarget() {
        return this.target;
    }

    public void setType(FlowActionType type) {
        if (type != null) {
            this.type = type.toString();
        }
    }

    public void setDupNumber(int args) {
        this.dupNumber = args;
    }

    public void setTarget(String t) {
        if (t != null) {
            this.target = t;
        }
    }

    public String getTargetElse() {
        return this.targetElse;
    }

    public void setTargetElse(String s) {
        if (s != null) {
            this.targetElse = s;
        }
    }

    public void setTargetContinuation(String t) {
        if (t != null) {
            this.targetContinuation = t;
        }
    }

    public String getTargetContinuation() {
        return this.targetContinuation;
    }

    public void setCronExpr(String cronExpr) {
        this.cronExpr = cronExpr;
    }

    public String getCronExpr() {
        return this.cronExpr;
    }
}

