/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import com.google.common.base.Strings;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BooleanParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.CRONParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.CatalogObjectParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.DateTimeParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.DoubleParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.FloatParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.IntegerParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ListParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.LongParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelFromURLParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.RegexpParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.SPELParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ShortParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.URIParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.URLParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class ModelValidator
implements Validator<String> {
    private String model;
    public static final String PREFIX = "PA:";

    public ModelValidator(String model) {
        if (Strings.isNullOrEmpty((String)model)) {
            throw new IllegalArgumentException("Model cannot be empty");
        }
        this.model = model.trim();
    }

    @Override
    public String validate(String parameterValue, ModelValidatorContext context) throws ValidationException {
        try {
            ParserValidator validator = this.createParserValidator();
            if (validator != null) {
                validator.parseAndValidate(parameterValue, context);
            }
            return parameterValue;
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    protected ParserValidator createParserValidator() throws ModelSyntaxException {
        String uppercaseModel = this.model.toUpperCase();
        if (uppercaseModel.startsWith(PREFIX)) {
            if ((uppercaseModel = this.removePrefix(uppercaseModel)).startsWith("INTEGER")) {
                return new IntegerParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("LONG")) {
                return new LongParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("DOUBLE")) {
                return new DoubleParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("FLOAT")) {
                return new FloatParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("SHORT")) {
                return new ShortParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("BOOLEAN")) {
                return new BooleanParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("URL")) {
                return new URLParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("URI")) {
                return new URIParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("DATETIME")) {
                return new DateTimeParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("LIST")) {
                return new ListParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("REGEXP")) {
                return new RegexpParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("MODEL_FROM_URL")) {
                return new ModelFromURLParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("CRON")) {
                return new CRONParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("SPEL")) {
                return new SPELParserValidator(this.removePrefix(this.model));
            }
            if (uppercaseModel.startsWith("CATALOG_OBJECT")) {
                return new CatalogObjectParserValidator(this.removePrefix(this.model));
            }
            throw new ModelSyntaxException("Unrecognized type in model '" + this.model + "'");
        }
        return null;
    }

    private String removePrefix(String model) {
        return model.substring(PREFIX.length());
    }
}

