/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import java.net.URL;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.URLConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.AcceptAllValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class URLParserValidator
extends BaseParserValidator<URL> {
    public static final String URL_TYPE = "URL";
    protected static final String URL_TYPE_REGEXP = "[Uu][Rr][Ll]";

    public URLParserValidator(String model) throws ModelSyntaxException {
        super(model);
        if (!model.matches("^[Uu][Rr][Ll]$")) {
            throw new ModelSyntaxException("URL expression in model does not match [Uu][Rr][Ll]$");
        }
    }

    @Override
    public String getType() {
        return URL_TYPE;
    }

    @Override
    public String getTypeRegexp() {
        return URL_TYPE_REGEXP;
    }

    @Override
    public Class getClassType() {
        return URL.class;
    }

    @Override
    protected Converter<URL> createConverter(String model) throws ModelSyntaxException {
        return new URLConverter();
    }

    @Override
    protected Validator<URL> createValidator(String model, Converter<URL> converter) throws ModelSyntaxException {
        return new AcceptAllValidator<URL>();
    }
}

