/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public enum XMLTags {
    JOB("job"),
    JOB_CLASSPATHES("jobClasspath"),
    JOB_PATH_ELEMENT("pathElement"),
    TASK_FLOW("taskFlow"),
    COMMON_DESCRIPTION("description"),
    COMMON_GENERIC_INFORMATION("genericInformation"),
    COMMON_INFO("info"),
    VARIABLE("variable"),
    VARIABLES("variables"),
    JAVA_EXECUTABLE("javaExecutable"),
    NATIVE_EXECUTABLE("nativeExecutable"),
    NATIVE_TASK_ARGUMENT("argument"),
    NATIVE_TASK_ARGUMENTS("arguments"),
    NATIVE_TASK_STATIC_COMMAND("staticCommand"),
    SCRIPT_EXECUTABLE("scriptExecutable"),
    TASK("task"),
    TASK_DEPENDENCES("depends"),
    TASK_DEPENDENCES_TASK("task"),
    TASK_PARAMETER("parameter"),
    TASK_PARAMETERS("parameters"),
    PARALLEL_ENV("parallel"),
    TOPOLOGY("topology"),
    TOPOLOGY_ARBITRARY("arbitrary"),
    TOPOLOGY_BEST_PROXIMITY("bestProximity"),
    TOPOLOGY_DIFFERENT_HOSTS_EXCLUSIVE("differentHostsExclusive"),
    TOPOLOGY_MULTIPLE_HOSTS_EXCLUSIVE("multipleHostsExclusive"),
    TOPOLOGY_SINGLE_HOST("singleHost"),
    TOPOLOGY_SINGLE_HOST_EXCLUSIVE("singleHostExclusive"),
    TOPOLOGY_THRESHOLD_PROXIMITY("thresholdProximity"),
    SCRIPT_ARGUMENT("argument"),
    SCRIPT_ARGUMENTS("arguments"),
    SCRIPT_CLEANING("cleaning"),
    SCRIPT_CODE("code"),
    SCRIPT_FILE("file"),
    SCRIPT_PRE("pre"),
    SCRIPT_POST("post"),
    SCRIPT_SCRIPT("script"),
    SCRIPT_SELECTION("selection"),
    FORK_ADDITIONAL_CLASSPATH("additionalClasspath"),
    FORK_ENVIRONMENT("forkEnvironment"),
    FORK_JVM_ARG("jvmArg"),
    FORK_JVM_ARGS("jvmArgs"),
    FORK_PATH_ELEMENT("pathElement"),
    FORK_SYSTEM_PROPERTIES("SystemEnvironment"),
    FORK_SYSTEM_PROPERTY("variable"),
    SCRIPT_ENV("envScript"),
    FLOW("controlFlow"),
    FLOW_IF("if"),
    FLOW_LOOP("loop"),
    FLOW_REPLICATE("replicate"),
    DS_FILES("files"),
    DS_GLOBAL_SPACE("globalSpace"),
    DS_INPUT_FILES("inputFiles"),
    DS_INPUT_SPACE("inputSpace"),
    DS_OUTPUT_FILES("outputFiles"),
    DS_OUTPUT_SPACE("outputSpace"),
    DS_USER_SPACE("userSpace"),
    METADATA("metadata"),
    METADATA_VISUALIZATION("visualization");

    public static final String OPEN_TAG_PATTERN = "<[ ]*%s[ ]*>";
    public static final String CLOSE_TAG_PATTERN = "<[ ]*/[ ]*%s[ ]*>";
    private String xmlName;
    private static Map<String, XMLTags> namesToEnum;

    private XMLTags(String xmlName) {
        this.xmlName = xmlName;
    }

    public String getXMLName() {
        return this.xmlName;
    }

    public String getOpenTagPattern() {
        return String.format(OPEN_TAG_PATTERN, this.xmlName);
    }

    public String getCloseTagPattern() {
        return String.format(CLOSE_TAG_PATTERN, this.xmlName);
    }

    public static XMLTags getFromXMLName(String xmlName) {
        XMLTags tag;
        Preconditions.checkNotNull((Object)xmlName);
        String toCheck = xmlName.toUpperCase();
        if (namesToEnum == null) {
            XMLTags[] values = XMLTags.values();
            HashMap<String, XMLTags> result = new HashMap<String, XMLTags>(values.length);
            for (XMLTags tag2 : values) {
                result.put(tag2.getXMLName().toUpperCase(), tag2);
            }
            namesToEnum = result;
        }
        if ((tag = namesToEnum.get(toCheck)) == null) {
            throw new IllegalArgumentException("XML tag name '" + xmlName + "' does not exist");
        }
        return tag;
    }

    public boolean matches(String xmlName) {
        return xmlName.equalsIgnoreCase(this.xmlName);
    }

    public String toString() {
        return this.getXMLName();
    }

    static {
        namesToEnum = null;
    }
}

