/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.JobValidationException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobType;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.GetJobContentFactory;
import org.ow2.proactive.scheduler.common.job.factories.JobFactory;
import org.ow2.proactive.scheduler.common.job.factories.ValidationUtil;
import org.ow2.proactive.scheduler.common.job.factories.XMLAttributes;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorRegistry;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorService;
import org.ow2.proactive.scheduler.common.task.CommonAttribute;
import org.ow2.proactive.scheduler.common.task.ForkEnvironment;
import org.ow2.proactive.scheduler.common.task.JavaTask;
import org.ow2.proactive.scheduler.common.task.NativeTask;
import org.ow2.proactive.scheduler.common.task.OnTaskError;
import org.ow2.proactive.scheduler.common.task.ParallelEnvironment;
import org.ow2.proactive.scheduler.common.task.RestartMode;
import org.ow2.proactive.scheduler.common.task.ScriptTask;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.ow2.proactive.scheduler.common.task.dataspaces.InputAccessMode;
import org.ow2.proactive.scheduler.common.task.dataspaces.OutputAccessMode;
import org.ow2.proactive.scheduler.common.task.flow.FlowActionType;
import org.ow2.proactive.scheduler.common.task.flow.FlowBlock;
import org.ow2.proactive.scheduler.common.task.flow.FlowScript;
import org.ow2.proactive.scheduler.common.util.VariableSubstitutor;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;
import org.ow2.proactive.scheduler.task.SchedulerVars;
import org.ow2.proactive.scripting.ForkEnvironmentScript;
import org.ow2.proactive.scripting.Script;
import org.ow2.proactive.scripting.SelectionScript;
import org.ow2.proactive.scripting.SimpleScript;
import org.ow2.proactive.scripting.TaskScript;
import org.ow2.proactive.topology.descriptor.ThresholdProximityDescriptor;
import org.ow2.proactive.topology.descriptor.TopologyDescriptor;
import org.ow2.proactive.utils.Tools;

public class StaxJobFactory
extends JobFactory {
    public static final Logger logger = Logger.getLogger(StaxJobFactory.class);
    private static final String FILE_ENCODING = PASchedulerProperties.FILE_ENCODING.getValueAsString();
    public static final String MSG_UNABLE_TO_INSTANCIATE_JOB_VALIDATION_FACTORIES = "Unable to instanciate job validation factories";
    private XMLInputFactory xmlInputFactory = null;
    private String relativePathRoot = "./";
    private GetJobContentFactory getJobContentFactory = new GetJobContentFactory();

    StaxJobFactory() {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    @Override
    public Job createJob(String filePath) throws JobCreationException {
        return this.createJob(filePath, null, null);
    }

    @Override
    public Job createJob(String filePath, Map<String, String> replacementVariables, Map<String, String> replacementGenericInfos) throws JobCreationException {
        try {
            return this.createJob(new File(filePath), replacementVariables, replacementGenericInfos);
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
    }

    @Override
    public Job createJob(URI filePath) throws JobCreationException {
        return this.createJob(filePath, null, null);
    }

    @Override
    public Job createJob(URI filePath, Map<String, String> replacementVariables, Map<String, String> replacementGenericInfos) throws JobCreationException {
        try {
            return this.createJob(new File(filePath), replacementVariables, replacementGenericInfos);
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
    }

    @Override
    public Job createJob(InputStream workflowStream) throws JobCreationException {
        return this.createJob(workflowStream, null, null);
    }

    @Override
    public Job createJob(InputStream workflowStream, Map<String, String> replacementVariables, Map<String, String> replacementGenericInfos) throws JobCreationException {
        try {
            return this.createJobFromInputStream(workflowStream, replacementVariables, replacementGenericInfos);
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Job createJob(File file, Map<String, String> replacementVariables, Map<String, String> replacementGenericInfos) throws JobCreationException {
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("This file has not been found: " + file.getAbsolutePath());
            }
            this.relativePathRoot = file.getParentFile().getAbsolutePath();
            try (FileInputStream inputStream = new FileInputStream(file);){
                Job job = this.createJobFromInputStream(inputStream, replacementVariables, replacementGenericInfos);
                return job;
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(XMLTags.JOB.getXMLName());
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(e);
        }
    }

    private Job createJobFromInputStream(InputStream jobInputStream, Map<String, String> replacementVariables, Map<String, String> replacementGenericInfos) throws JobCreationException, VerifierConfigurationException, IOException, XMLStreamException {
        Job job;
        byte[] bytes = ValidationUtil.getInputStreamBytes(jobInputStream);
        try (ByteArrayInputStream jobInputStreamForValidation = new ByteArrayInputStream(bytes);){
            this.validate(jobInputStreamForValidation);
        }
        HashMap<String, ArrayList<String>> dependencies = new HashMap<String, ArrayList<String>>();
        try (ByteArrayInputStream jobInpoutStreamForParsing = new ByteArrayInputStream(bytes);){
            XMLStreamReader xmlsr = this.xmlInputFactory.createXMLStreamReader(jobInpoutStreamForParsing, FILE_ENCODING);
            job = this.createJob(xmlsr, replacementVariables, replacementGenericInfos, dependencies, new String(bytes));
            xmlsr.close();
        }
        this.makeDependences(job, dependencies);
        this.validate((TaskFlowJob)job);
        logger.debug((Object)"Job successfully created!");
        this.displayJobInfo(job);
        return job;
    }

    private void validate(InputStream jobInputStream) throws VerifierConfigurationException, JobCreationException {
        ImmutableMap<String, JobValidatorService> factories;
        try {
            factories = JobValidatorRegistry.getInstance().getRegisteredFactories();
        }
        catch (Exception e) {
            logger.error((Object)MSG_UNABLE_TO_INSTANCIATE_JOB_VALIDATION_FACTORIES, (Throwable)e);
            throw new VerifierConfigurationException(MSG_UNABLE_TO_INSTANCIATE_JOB_VALIDATION_FACTORIES, e);
        }
        try {
            for (JobValidatorService factory : factories.values()) {
                factory.validateJob(jobInputStream);
            }
        }
        catch (JobValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobValidationException(true, (Throwable)e);
        }
    }

    private TaskFlowJob validate(TaskFlowJob job) throws VerifierConfigurationException, JobCreationException {
        ImmutableMap<String, JobValidatorService> factories;
        try {
            factories = JobValidatorRegistry.getInstance().getRegisteredFactories();
        }
        catch (Exception e) {
            throw new VerifierConfigurationException(MSG_UNABLE_TO_INSTANCIATE_JOB_VALIDATION_FACTORIES, e);
        }
        TaskFlowJob updatedJob = job;
        try {
            for (JobValidatorService factory : factories.values()) {
                updatedJob = factory.validateJob(updatedJob);
            }
        }
        catch (JobValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobValidationException(e);
        }
        return updatedJob;
    }

    private Job createJob(XMLStreamReader cursorRoot, Map<String, String> replacementVariables, Map<String, String> replacementGenericInfos, Map<String, ArrayList<String>> dependencies, String jobContent) throws JobCreationException {
        String current = null;
        try {
            Job job = null;
            while (cursorRoot.hasNext()) {
                int eventType = cursorRoot.next();
                if (eventType != 1) continue;
                current = cursorRoot.getLocalName();
                if (XMLTags.JOB.matches(current)) {
                    job = this.createAndFillJob(cursorRoot, replacementVariables, replacementGenericInfos, jobContent);
                    continue;
                }
                if (XMLTags.TASK.matches(current)) {
                    this.fillJobWithTasks(cursorRoot, job, dependencies);
                    continue;
                }
                if (!XMLTags.METADATA_VISUALIZATION.matches(current) || job == null) continue;
                job.setVisualization(this.getJobVisualization(cursorRoot));
                break;
            }
            if (job != null) {
                StaxJobFactory.resolveCleaningScripts((TaskFlowJob)job, job.getVariablesAsReplacementMap());
            }
            return job;
        }
        catch (JobCreationException jce) {
            if (XMLTags.TASK.matches(current)) {
                jce.pushTag(XMLTags.TASK_FLOW.getXMLName());
            }
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(current, null, e);
        }
    }

    private JobVariable newJobVariable(Map.Entry<String, String> entry) {
        return new JobVariable(entry.getKey(), entry.getValue(), null);
    }

    private Job createAndFillJob(XMLStreamReader cursorJob, Map<String, String> replacementVariables, Map<String, String> replacementGenericInfos, String jobContent) throws JobCreationException {
        int i;
        Job commonPropertiesHolder = new Job(){
            private static final long serialVersionUID = 84L;

            @Override
            public JobId getId() {
                throw new RuntimeException("Not Available!");
            }

            @Override
            public JobType getType() {
                throw new RuntimeException("Not Available!");
            }
        };
        HashMap<String, String> delayedJobAttributes = new HashMap<String, String>();
        int attrLen = cursorJob.getAttributeCount();
        for (i = 0; i < attrLen; ++i) {
            String attributeName = cursorJob.getAttributeLocalName(i);
            String attributeValue = cursorJob.getAttributeValue(i);
            delayedJobAttributes.put(attributeName, attributeValue);
        }
        Job job = commonPropertiesHolder;
        try {
            if (replacementVariables != null) {
                commonPropertiesHolder.getVariables().putAll(replacementVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::newJobVariable)));
            }
            if (replacementGenericInfos != null) {
                commonPropertiesHolder.addGenericInformations(this.getResolvedGenericInformations(replacementGenericInfos, replacementVariables));
            }
            while (cursorJob.hasNext()) {
                int eventType = cursorJob.next();
                if (eventType != 1) continue;
                String current = cursorJob.getLocalName();
                if (XMLTags.VARIABLES.matches(current)) {
                    Map<String, JobVariable> unresolvedJobVariablesMap = this.createUnresolvedJobVariables(cursorJob);
                    commonPropertiesHolder.getUnresolvedVariables().putAll(unresolvedJobVariablesMap);
                    Map<String, JobVariable> jobVariablesMap = this.replaceVariablesInJobVariablesMap(unresolvedJobVariablesMap, replacementVariables);
                    commonPropertiesHolder.getVariables().putAll(jobVariablesMap);
                    continue;
                }
                if (XMLTags.COMMON_GENERIC_INFORMATION.matches(current)) {
                    Map<String, String> resolvedJobVariables = commonPropertiesHolder.getVariablesAsReplacementMap();
                    HashMap<String, String> unresolvedGenericInformationsDefinedInWorkflow = this.getUnresolvedGenericInformations(cursorJob);
                    HashMap<String, String> resolvedGenericInformationsDefinedInWorkflow = this.getResolvedGenericInformations(unresolvedGenericInformationsDefinedInWorkflow, resolvedJobVariables);
                    Map<String, String> submittedGenericInformations = commonPropertiesHolder.getGenericInformation();
                    resolvedGenericInformationsDefinedInWorkflow.putAll(submittedGenericInformations);
                    commonPropertiesHolder.setGenericInformation(resolvedGenericInformationsDefinedInWorkflow);
                    commonPropertiesHolder.setUnresolvedGenericInformation(unresolvedGenericInformationsDefinedInWorkflow);
                    continue;
                }
                if (XMLTags.JOB_CLASSPATHES.matches(current)) {
                    logger.warn((Object)("Element " + XMLTags.JOB_CLASSPATHES.getXMLName() + " is no longer supported. Please define a " + XMLTags.FORK_ENVIRONMENT.getXMLName() + " per task if needed."));
                    continue;
                }
                if (XMLTags.COMMON_DESCRIPTION.matches(current)) {
                    commonPropertiesHolder.setDescription(this.getDescription(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                    continue;
                }
                if (XMLTags.DS_INPUT_SPACE.matches(current)) {
                    commonPropertiesHolder.setInputSpace(this.getIOSpace(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                    continue;
                }
                if (XMLTags.DS_OUTPUT_SPACE.matches(current)) {
                    commonPropertiesHolder.setOutputSpace(this.getIOSpace(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                    continue;
                }
                if (XMLTags.DS_GLOBAL_SPACE.matches(current)) {
                    commonPropertiesHolder.setGlobalSpace(this.getIOSpace(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                    continue;
                }
                if (XMLTags.DS_USER_SPACE.matches(current)) {
                    commonPropertiesHolder.setUserSpace(this.getIOSpace(cursorJob, commonPropertiesHolder.getVariablesAsReplacementMap()));
                    continue;
                }
                if (!XMLTags.TASK_FLOW.matches(current)) continue;
                job = new TaskFlowJob();
                break;
            }
            this.handleJobAttributes(commonPropertiesHolder, delayedJobAttributes);
            if (job != commonPropertiesHolder) {
                job.setDescription(commonPropertiesHolder.getDescription());
                job.setName(commonPropertiesHolder.getName());
                job.setPriority(commonPropertiesHolder.getPriority());
                job.setProjectName(commonPropertiesHolder.getProjectName());
                job.setOnTaskError(commonPropertiesHolder.getOnTaskErrorProperty().getValue());
                job.setRestartTaskOnError(commonPropertiesHolder.getRestartTaskOnError());
                job.setMaxNumberOfExecution(commonPropertiesHolder.getMaxNumberOfExecution());
                job.setGenericInformation(commonPropertiesHolder.getGenericInformation());
                job.setUnresolvedGenericInformation(commonPropertiesHolder.getUnresolvedGenericInformation());
                job.setInputSpace(commonPropertiesHolder.getInputSpace());
                job.setOutputSpace(commonPropertiesHolder.getOutputSpace());
                job.setGlobalSpace(commonPropertiesHolder.getGlobalSpace());
                job.setUserSpace(commonPropertiesHolder.getUserSpace());
                job.setVariables(commonPropertiesHolder.getVariables());
                job.setUnresolvedVariables(commonPropertiesHolder.getUnresolvedVariables());
                job.setVisualization(commonPropertiesHolder.getVisualization());
                String updatedJobContent = this.getJobContentFactory.replaceVarsAndGenericInfo(jobContent, commonPropertiesHolder.getVariables(), commonPropertiesHolder.getGenericInformation());
                job.setJobContent(updatedJobContent);
            }
            return job;
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorJob.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String temporaryAttribute = null;
            if (cursorJob.isStartElement() && cursorJob.getAttributeCount() > i) {
                temporaryAttribute = cursorJob.getAttributeLocalName(i);
            }
            throw new JobCreationException(cursorJob.getLocalName(), temporaryAttribute, e);
        }
    }

    private void handleJobAttributes(Job commonPropertiesHolder, Map<String, String> delayedJobAttributes) throws JobCreationException {
        for (Map.Entry<String, String> delayedAttribute : delayedJobAttributes.entrySet()) {
            String attributeName = delayedAttribute.getKey();
            String attributeValue = delayedAttribute.getValue();
            if (XMLAttributes.COMMON_NAME.matches(attributeName)) {
                commonPropertiesHolder.setName(StaxJobFactory.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap()));
                continue;
            }
            if (XMLAttributes.JOB_PRIORITY.matches(attributeName)) {
                commonPropertiesHolder.setPriority(JobPriority.findPriority(StaxJobFactory.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap())));
                continue;
            }
            if (XMLAttributes.COMMON_CANCEL_JOB_ON_ERROR.matches(attributeName)) {
                this.handleCancelJobOnErrorAttribute(commonPropertiesHolder, StaxJobFactory.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap()));
                continue;
            }
            if (XMLAttributes.COMMON_RESTART_TASK_ON_ERROR.matches(attributeName)) {
                commonPropertiesHolder.setRestartTaskOnError(RestartMode.getMode(StaxJobFactory.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap())));
                continue;
            }
            if (XMLAttributes.COMMON_ON_TASK_ERROR.matches(attributeName)) {
                commonPropertiesHolder.setOnTaskError(OnTaskError.getInstance(StaxJobFactory.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap())));
                continue;
            }
            if (XMLAttributes.COMMON_MAX_NUMBER_OF_EXECUTION.matches(attributeName)) {
                commonPropertiesHolder.setMaxNumberOfExecution(Integer.parseInt(StaxJobFactory.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap())));
                continue;
            }
            if (!XMLAttributes.JOB_PROJECT_NAME.matches(attributeName)) continue;
            commonPropertiesHolder.setProjectName(StaxJobFactory.replace(attributeValue, commonPropertiesHolder.getVariablesAsReplacementMap()));
        }
    }

    private void handleCancelJobOnErrorAttribute(CommonAttribute commonPropertiesHolder, String attributeValue) {
        logger.warn((Object)(XMLAttributes.COMMON_CANCEL_JOB_ON_ERROR.getXMLName() + " attribute is deprecated and no longer supported from schema 3.4+. Please use on task error policy to define task error behaviour. The attribute 'cancelJobOnError=\"true\"' is translated into 'onTaskError=\"cancelJob\"'."));
        if (attributeValue != null && attributeValue.equalsIgnoreCase("true")) {
            commonPropertiesHolder.setOnTaskError(OnTaskError.CANCEL_JOB);
        }
    }

    private Map<String, JobVariable> createUnresolvedJobVariables(XMLStreamReader cursorVariables) throws JobCreationException {
        LinkedHashMap<String, JobVariable> unresolvedVariablesMap = new LinkedHashMap<String, JobVariable>();
        try {
            block7: while (cursorVariables.hasNext()) {
                int eventType = cursorVariables.next();
                switch (eventType) {
                    case 1: {
                        if (!XMLTags.VARIABLE.matches(cursorVariables.getLocalName())) continue block7;
                        Map<String, String> unresolvedAttributesAsMap = this.getUnresolvedAttributesAsMap(cursorVariables);
                        String name = unresolvedAttributesAsMap.get(XMLAttributes.VARIABLE_NAME.getXMLName());
                        String value = unresolvedAttributesAsMap.get(XMLAttributes.VARIABLE_VALUE.getXMLName());
                        String model = unresolvedAttributesAsMap.get(XMLAttributes.VARIABLE_MODEL.getXMLName());
                        unresolvedVariablesMap.put(name, new JobVariable(name, value, model));
                        continue block7;
                    }
                    case 2: {
                        if (!XMLTags.VARIABLES.matches(cursorVariables.getLocalName())) continue block7;
                        return unresolvedVariablesMap;
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorVariables.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorVariables.isStartElement() && cursorVariables.getAttributeCount() == 1) {
                attrtmp = cursorVariables.getAttributeLocalName(0);
            }
            throw new JobCreationException(cursorVariables.getLocalName(), attrtmp, e);
        }
        return unresolvedVariablesMap;
    }

    protected Map<String, JobVariable> replaceVariablesInJobVariablesMap(Map<String, JobVariable> variablesMap, Map<String, String> replacementVariables) throws JobCreationException {
        HashMap<String, String> updatedReplacementVariables = new HashMap<String, String>();
        HashMap<String, JobVariable> updatedVariablesMap = new HashMap<String, JobVariable>(variablesMap);
        for (JobVariable jobVariable : updatedVariablesMap.values()) {
            updatedReplacementVariables.put(jobVariable.getName(), jobVariable.getValue());
        }
        if (replacementVariables != null) {
            updatedReplacementVariables.putAll(replacementVariables);
        }
        for (Map.Entry entry : updatedReplacementVariables.entrySet()) {
            String replacementVariableKey = (String)entry.getKey();
            if (updatedVariablesMap.containsKey(replacementVariableKey)) {
                JobVariable jobVariable = updatedVariablesMap.get(replacementVariableKey);
                JobVariable replacedJobVariable = new JobVariable(jobVariable.getName(), jobVariable.getValue(), jobVariable.getModel());
                replacedJobVariable.setValue(StaxJobFactory.replace((String)entry.getValue(), updatedReplacementVariables));
                if (replacedJobVariable.getModel() != null) {
                    replacedJobVariable.setModel(StaxJobFactory.replace(replacedJobVariable.getModel(), updatedReplacementVariables));
                }
                updatedVariablesMap.put(replacementVariableKey, replacedJobVariable);
                continue;
            }
            updatedVariablesMap.put(replacementVariableKey, new JobVariable(replacementVariableKey, StaxJobFactory.replace((String)entry.getValue(), updatedReplacementVariables), null));
        }
        return updatedVariablesMap;
    }

    private Map<String, TaskVariable> createTaskVariables(XMLStreamReader cursorVariables, Map<String, String> variables) throws JobCreationException {
        HashMap<String, TaskVariable> variablesMap = new HashMap<String, TaskVariable>();
        try {
            while (cursorVariables.hasNext()) {
                int eventType = cursorVariables.next();
                if (eventType == 1 && XMLTags.VARIABLE.matches(cursorVariables.getLocalName())) {
                    TaskVariable taskVariable = this.getTaskVariable(cursorVariables, variables);
                    variablesMap.put(taskVariable.getName(), taskVariable);
                    continue;
                }
                if (eventType != 2 || !XMLTags.VARIABLES.matches(cursorVariables.getLocalName())) continue;
                return variablesMap;
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorVariables.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorVariables.isStartElement() && cursorVariables.getAttributeCount() == 1) {
                attrtmp = cursorVariables.getAttributeLocalName(0);
            }
            throw new JobCreationException(cursorVariables.getLocalName(), attrtmp, e);
        }
        return variablesMap;
    }

    private TaskVariable getTaskVariable(XMLStreamReader cursorVariables, Map<String, String> variables) throws JobCreationException {
        TaskVariable taskVariable = new TaskVariable();
        Map<String, String> attributesAsMap = this.getAttributesAsMap(cursorVariables, variables);
        taskVariable.setName(attributesAsMap.get(XMLAttributes.VARIABLE_NAME.getXMLName()));
        taskVariable.setValue(attributesAsMap.get(XMLAttributes.VARIABLE_VALUE.getXMLName()));
        taskVariable.setModel(attributesAsMap.get(XMLAttributes.VARIABLE_MODEL.getXMLName()));
        if (attributesAsMap.containsKey(XMLAttributes.VARIABLE_JOB_INHERITED.getXMLName())) {
            taskVariable.setJobInherited(Boolean.valueOf(attributesAsMap.get(XMLAttributes.VARIABLE_JOB_INHERITED.getXMLName())));
        }
        return taskVariable;
    }

    private Map<String, String> getAttributesAsMap(XMLStreamReader cursorVariables, Map<String, String> replacementVariables) throws JobCreationException {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < cursorVariables.getAttributeCount(); ++i) {
            result.put((Object)cursorVariables.getAttributeLocalName(i), (Object)StaxJobFactory.replace(cursorVariables.getAttributeValue(i), replacementVariables));
        }
        return result.build();
    }

    private Map<String, String> getUnresolvedAttributesAsMap(XMLStreamReader cursorVariables) throws JobCreationException {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < cursorVariables.getAttributeCount(); ++i) {
            result.put((Object)cursorVariables.getAttributeLocalName(i), (Object)cursorVariables.getAttributeValue(i));
        }
        return result.build();
    }

    private HashMap<String, String> getUnresolvedGenericInformations(XMLStreamReader cursorInfo) throws JobCreationException {
        HashMap<String, String> infos = new HashMap<String, String>();
        try {
            block7: while (cursorInfo.hasNext()) {
                int eventType = cursorInfo.next();
                switch (eventType) {
                    case 1: {
                        if (!XMLTags.COMMON_INFO.matches(cursorInfo.getLocalName())) continue block7;
                        Map<String, String> attributesAsMap = this.getUnresolvedAttributesAsMap(cursorInfo);
                        String name = attributesAsMap.get(XMLAttributes.COMMON_NAME.getXMLName());
                        String value = attributesAsMap.get(XMLAttributes.COMMON_VALUE.getXMLName());
                        infos.put(name, value);
                        continue block7;
                    }
                    case 2: {
                        if (!XMLTags.COMMON_GENERIC_INFORMATION.matches(cursorInfo.getLocalName())) continue block7;
                        return infos;
                    }
                }
            }
            return infos;
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorInfo.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorInfo.isStartElement() && cursorInfo.getAttributeCount() == 1) {
                attrtmp = cursorInfo.getAttributeLocalName(0);
            }
            throw new JobCreationException(cursorInfo.getLocalName(), attrtmp, e);
        }
    }

    private HashMap<String, String> getResolvedGenericInformations(Map<String, String> unresolvedGenericInformations, Map<String, String> variables) throws JobCreationException {
        HashMap<String, String> infos = new HashMap<String, String>();
        for (Map.Entry<String, String> unresolvedGenericInformationValue : unresolvedGenericInformations.entrySet()) {
            infos.put(unresolvedGenericInformationValue.getKey(), StaxJobFactory.replace(unresolvedGenericInformationValue.getValue(), variables));
        }
        return infos;
    }

    private String getDescription(XMLStreamReader cursorVariables, Map<String, String> variables) throws JobCreationException {
        try {
            String description = "";
            int eventType = cursorVariables.next();
            if (eventType == 4) {
                description = StaxJobFactory.replace(cursorVariables.getText(), variables);
            } else if (eventType == 2) {
                return description;
            }
            while (cursorVariables.next() != 2) {
            }
            return description;
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException((String)null, null, e);
        }
    }

    private String getJobVisualization(XMLStreamReader cursorMetadata) throws JobCreationException {
        try {
            String visualization = "";
            int eventType = cursorMetadata.next();
            if (eventType == 4) {
                visualization = cursorMetadata.getText();
            } else if (eventType == 2) {
                return visualization;
            }
            while (cursorMetadata.next() != 2) {
            }
            return visualization;
        }
        catch (Exception e) {
            throw new JobCreationException((String)null, null, e);
        }
    }

    private String getIOSpace(XMLStreamReader cursorVariables, Map<String, String> variables) throws JobCreationException {
        try {
            String url = StaxJobFactory.replace(cursorVariables.getAttributeValue(0), variables);
            while (cursorVariables.next() != 2) {
            }
            return url;
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            String temporaryAttribute = null;
            if (cursorVariables.isStartElement() && cursorVariables.getAttributeCount() == 1) {
                temporaryAttribute = cursorVariables.getAttributeLocalName(0);
            }
            throw new JobCreationException((String)null, temporaryAttribute, e);
        }
    }

    private void fillJobWithTasks(XMLStreamReader cursorTask, Job job, Map<String, ArrayList<String>> dependencies) throws JobCreationException {
        if (job == null) {
            throw new JobCreationException(XMLTags.JOB.getXMLName(), null, null);
        }
        XMLTags current = null;
        try {
            int eventType = -1;
            block7: while (cursorTask.hasNext() && (eventType = eventType == -1 ? cursorTask.getEventType() : cursorTask.next()) == 1 && XMLTags.TASK.matches(cursorTask.getLocalName())) {
                switch (job.getType()) {
                    case TASKSFLOW: {
                        current = XMLTags.TASK;
                        Task t = this.createTask(cursorTask, job, dependencies);
                        ((TaskFlowJob)job).addTask(t);
                        continue block7;
                    }
                    case PARAMETER_SWEEPING: {
                        current = XMLTags.TASK;
                        throw new RuntimeException("Job parameter sweeping is not yet implemented!");
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(current, null, e);
        }
    }

    private Task createTask(XMLStreamReader cursorTask, Job job, Map<String, ArrayList<String>> dependencies) throws JobCreationException {
        int i = 0;
        XMLTags currentTag = null;
        String current = null;
        String taskName = null;
        try {
            CommonAttribute toReturn = null;
            Task tmpTask = new Task(){
                private static final long serialVersionUID = 84L;
            };
            int attrLen = cursorTask.getAttributeCount();
            for (i = 0; i < attrLen; ++i) {
                String attributeName = cursorTask.getAttributeLocalName(i);
                String attributeValue = cursorTask.getAttributeValue(i);
                if (XMLAttributes.COMMON_NAME.matches(attributeName)) {
                    tmpTask.setName(attributeValue);
                    taskName = attributeValue;
                    continue;
                }
                if (XMLAttributes.TASK_NB_NODES.matches(attributeName)) {
                    int numberOfNodesNeeded = Integer.parseInt(StaxJobFactory.replace(attributeValue, tmpTask.getVariablesOverriden(job)));
                    tmpTask.setParallelEnvironment(new ParallelEnvironment(numberOfNodesNeeded));
                    continue;
                }
                if (XMLAttributes.COMMON_CANCEL_JOB_ON_ERROR.matches(attributeName)) {
                    this.handleCancelJobOnErrorAttribute(tmpTask, attributeValue);
                    continue;
                }
                if (XMLAttributes.COMMON_ON_TASK_ERROR.matches(attributeName)) {
                    tmpTask.setOnTaskError(OnTaskError.getInstance(StaxJobFactory.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.COMMON_RESTART_TASK_ON_ERROR.matches(attributeName)) {
                    tmpTask.setRestartTaskOnError(RestartMode.getMode(StaxJobFactory.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.COMMON_MAX_NUMBER_OF_EXECUTION.matches(attributeName)) {
                    tmpTask.setMaxNumberOfExecution(Integer.parseInt(StaxJobFactory.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.TASK_PRECIOUS_RESULT.matches(attributeName)) {
                    tmpTask.setPreciousResult(Boolean.parseBoolean(StaxJobFactory.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.TASK_PRECIOUS_LOGS.matches(attributeName)) {
                    tmpTask.setPreciousLogs(Boolean.parseBoolean(StaxJobFactory.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (XMLAttributes.TASK_WALLTIME.matches(attributeName)) {
                    tmpTask.setWallTime(Tools.formatDate((String)StaxJobFactory.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
                    continue;
                }
                if (!XMLAttributes.TASK_RUN_AS_ME.matches(attributeName)) continue;
                tmpTask.setRunAsMe(Boolean.parseBoolean(StaxJobFactory.replace(attributeValue, tmpTask.getVariablesOverriden(job))));
            }
            boolean shouldContinue = true;
            block8: while (shouldContinue && cursorTask.hasNext()) {
                int eventType = cursorTask.next();
                switch (eventType) {
                    case 1: {
                        current = cursorTask.getLocalName();
                        currentTag = null;
                        if (XMLTags.COMMON_GENERIC_INFORMATION.matches(current)) {
                            Map<String, String> jobVariablesWithGenericInfos = tmpTask.getVariablesOverriden(job);
                            if (job.getGenericInformation() != null) {
                                jobVariablesWithGenericInfos.putAll(job.getGenericInformation());
                            }
                            HashMap<String, String> unresolvedGenericInformationDefinedInWorkflow = this.getUnresolvedGenericInformations(cursorTask);
                            tmpTask.setUnresolvedGenericInformation(unresolvedGenericInformationDefinedInWorkflow);
                            tmpTask.setGenericInformation(this.getResolvedGenericInformations(unresolvedGenericInformationDefinedInWorkflow, jobVariablesWithGenericInfos));
                            continue block8;
                        }
                        if (XMLTags.VARIABLES.matches(current)) {
                            Map<String, TaskVariable> taskVariablesMap = this.createTaskVariables(cursorTask, tmpTask.getVariablesOverriden(job));
                            tmpTask.setVariables(taskVariablesMap);
                            continue block8;
                        }
                        if (XMLTags.COMMON_DESCRIPTION.matches(current)) {
                            tmpTask.setDescription(this.getDescription(cursorTask, tmpTask.getVariablesOverriden(job)));
                            continue block8;
                        }
                        if (XMLTags.DS_INPUT_FILES.matches(current)) {
                            this.setIOFIles(cursorTask, XMLTags.DS_INPUT_FILES.getXMLName(), tmpTask, tmpTask.getVariablesOverriden(job));
                            continue block8;
                        }
                        if (XMLTags.DS_OUTPUT_FILES.matches(current)) {
                            this.setIOFIles(cursorTask, XMLTags.DS_OUTPUT_FILES.getXMLName(), tmpTask, tmpTask.getVariablesOverriden(job));
                            continue block8;
                        }
                        if (XMLTags.PARALLEL_ENV.matches(current)) {
                            tmpTask.setParallelEnvironment(this.createParallelEnvironment(cursorTask, tmpTask.getVariablesOverriden(job)));
                            continue block8;
                        }
                        if (XMLTags.SCRIPT_SELECTION.matches(current)) {
                            tmpTask.setSelectionScripts(this.createSelectionScript(cursorTask, tmpTask.getVariablesOverriden(job)));
                            continue block8;
                        }
                        if (XMLTags.FORK_ENVIRONMENT.matches(current)) {
                            tmpTask.setForkEnvironment(this.createForkEnvironment(cursorTask, tmpTask.getVariablesOverriden(job)));
                            continue block8;
                        }
                        if (XMLTags.SCRIPT_PRE.matches(current)) {
                            tmpTask.setPreScript(this.createScript(cursorTask, tmpTask.getVariablesOverriden(job)));
                            continue block8;
                        }
                        if (XMLTags.SCRIPT_POST.matches(current)) {
                            tmpTask.setPostScript(this.createScript(cursorTask, tmpTask.getVariablesOverriden(job)));
                            continue block8;
                        }
                        if (XMLTags.SCRIPT_CLEANING.matches(current)) {
                            tmpTask.setCleaningScript(this.createScript(cursorTask, tmpTask.getVariablesOverriden(job)));
                            continue block8;
                        }
                        if (XMLTags.FLOW.matches(current)) {
                            tmpTask.setFlowScript(this.createControlFlowScript(cursorTask, tmpTask, tmpTask.getVariablesOverriden(job)));
                            continue block8;
                        }
                        if (XMLTags.TASK_DEPENDENCES.matches(current)) {
                            currentTag = XMLTags.TASK_DEPENDENCES;
                            dependencies.putAll(this.createDependences(cursorTask, tmpTask));
                            continue block8;
                        }
                        if (XMLTags.JAVA_EXECUTABLE.matches(current)) {
                            toReturn = new JavaTask();
                            this.setJavaExecutable((JavaTask)toReturn, cursorTask, tmpTask.getVariablesOverriden(job));
                            continue block8;
                        }
                        if (XMLTags.NATIVE_EXECUTABLE.matches(current)) {
                            toReturn = new NativeTask();
                            this.setNativeExecutable((NativeTask)toReturn, cursorTask);
                            continue block8;
                        }
                        if (!XMLTags.SCRIPT_EXECUTABLE.matches(current)) continue block8;
                        toReturn = new ScriptTask();
                        ((ScriptTask)toReturn).setScript(new TaskScript(this.createScript(cursorTask, tmpTask.getVariablesOverriden(job))));
                        continue block8;
                    }
                    case 2: {
                        current = cursorTask.getLocalName();
                        if (!XMLTags.TASK.matches(cursorTask.getLocalName())) continue block8;
                        shouldContinue = false;
                        continue block8;
                    }
                }
            }
            StaxJobFactory.autoCopyfields(CommonAttribute.class, tmpTask, toReturn);
            StaxJobFactory.autoCopyfields(Task.class, tmpTask, toReturn);
            if (toReturn != null) {
                if (toReturn.getRestartTaskOnErrorProperty().isSet()) {
                    toReturn.setRestartTaskOnError(toReturn.getRestartTaskOnError());
                }
                if (toReturn.getMaxNumberOfExecutionProperty().isSet()) {
                    toReturn.setMaxNumberOfExecution(toReturn.getMaxNumberOfExecution());
                }
            }
            return toReturn;
        }
        catch (JobCreationException jce) {
            jce.setTaskName(taskName);
            if (currentTag != null) {
                jce.pushTag(currentTag);
            } else {
                jce.pushTag(current);
            }
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorTask.isStartElement() && cursorTask.getAttributeCount() > i) {
                attrtmp = cursorTask.getAttributeLocalName(i);
            }
            if (currentTag != null) {
                throw new JobCreationException(currentTag, attrtmp, e);
            }
            throw new JobCreationException(current, attrtmp, e);
        }
    }

    private void setIOFIles(XMLStreamReader cursorTask, String endTag, Task task, Map<String, String> variables) throws JobCreationException {
        int i = 0;
        try {
            boolean shouldContinue = true;
            block7: while (shouldContinue && cursorTask.hasNext()) {
                int eventType = cursorTask.next();
                switch (eventType) {
                    case 1: {
                        String current = cursorTask.getLocalName();
                        if (!XMLTags.DS_FILES.matches(current)) continue block7;
                        int attrLen = cursorTask.getAttributeCount();
                        FileSelector selector = null;
                        String accessMode = null;
                        for (i = 0; i < attrLen; ++i) {
                            String attrName = cursorTask.getAttributeLocalName(i);
                            if (XMLAttributes.DS_INCLUDES.matches(attrName)) {
                                if (selector == null) {
                                    selector = new FileSelector();
                                }
                                selector.setIncludes(new String[]{cursorTask.getAttributeValue(i)});
                            } else if (XMLAttributes.DS_EXCLUDES.matches(attrName)) {
                                if (selector == null) {
                                    selector = new FileSelector();
                                }
                                selector.setExcludes(new String[]{StaxJobFactory.replace(cursorTask.getAttributeValue(i), variables)});
                            } else if (XMLAttributes.DS_ACCESS_MODE.matches(attrName)) {
                                accessMode = cursorTask.getAttributeValue(i);
                            }
                            if (selector == null || accessMode == null) continue;
                            if (XMLTags.DS_INPUT_FILES.matches(endTag)) {
                                task.addInputFiles(selector, InputAccessMode.getAccessMode(accessMode));
                                continue;
                            }
                            task.addOutputFiles(selector, OutputAccessMode.getAccessMode(accessMode));
                        }
                        continue block7;
                    }
                    case 2: {
                        if (!cursorTask.getLocalName().equals(endTag)) continue block7;
                        shouldContinue = false;
                        continue block7;
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(cursorTask.getLocalName());
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorTask.isStartElement() && cursorTask.getAttributeCount() > i) {
                attrtmp = cursorTask.getAttributeLocalName(i);
            }
            throw new JobCreationException(cursorTask.getLocalName(), attrtmp, e);
        }
    }

    private Map<String, ArrayList<String>> createDependences(XMLStreamReader cursorDepends, Task t) throws JobCreationException {
        try {
            HashMap<String, ArrayList<String>> dependencies = new HashMap<String, ArrayList<String>>();
            ArrayList<String> depends = new ArrayList<String>(0);
            block6: while (cursorDepends.hasNext()) {
                int eventType = cursorDepends.next();
                switch (eventType) {
                    case 1: {
                        if (!XMLTags.TASK_DEPENDENCES_TASK.matches(cursorDepends.getLocalName())) continue block6;
                        depends.add(cursorDepends.getAttributeValue(0));
                        continue block6;
                    }
                    case 2: {
                        if (!XMLTags.TASK_DEPENDENCES.matches(cursorDepends.getLocalName())) continue block6;
                        dependencies.put(t.getName(), depends);
                        return dependencies;
                    }
                }
            }
            return dependencies;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorDepends.isStartElement() && cursorDepends.getAttributeCount() == 1) {
                attrtmp = cursorDepends.getAttributeLocalName(0);
            }
            throw new JobCreationException(cursorDepends.getLocalName(), attrtmp, e);
        }
    }

    private FlowScript createControlFlowScript(XMLStreamReader cursorTask, Task tmpTask, Map<String, String> variables) throws JobCreationException {
        String attrName;
        String type = null;
        String target = null;
        String targetElse = null;
        String targetJoin = null;
        int event = -1;
        for (int i = 0; i < cursorTask.getAttributeCount(); ++i) {
            String attrName2 = cursorTask.getAttributeLocalName(i);
            if (!XMLAttributes.FLOW_BLOCK.matches(attrName2)) continue;
            tmpTask.setFlowBlock(FlowBlock.parse(StaxJobFactory.replace(cursorTask.getAttributeValue(i), variables)));
        }
        try {
            while (cursorTask.hasNext() && (event = cursorTask.next()) != 1) {
                if (event != 2 || !XMLTags.FLOW.matches(cursorTask.getLocalName())) continue;
                return null;
            }
        }
        catch (Exception e) {
            throw new JobCreationException(XMLTags.FLOW.getXMLName(), null, e);
        }
        if (event != 1) {
            throw new JobCreationException(XMLTags.FLOW.getXMLName(), null, null);
        }
        String tag = null;
        if (XMLTags.FLOW_REPLICATE.matches(cursorTask.getLocalName())) {
            type = FlowActionType.REPLICATE.toString();
            tag = XMLTags.FLOW_REPLICATE.getXMLName();
        } else if (XMLTags.FLOW_IF.matches(cursorTask.getLocalName())) {
            type = FlowActionType.IF.toString();
            tag = XMLTags.FLOW_IF.getXMLName();
            for (int i = 0; i < cursorTask.getAttributeCount(); ++i) {
                attrName = cursorTask.getAttributeLocalName(i);
                if (XMLAttributes.FLOW_TARGET.matches(attrName)) {
                    target = cursorTask.getAttributeValue(i);
                    continue;
                }
                if (XMLAttributes.FLOW_ELSE.matches(attrName)) {
                    targetElse = cursorTask.getAttributeValue(i);
                    continue;
                }
                if (!XMLAttributes.FLOW_CONTINUATION.matches(attrName)) continue;
                targetJoin = cursorTask.getAttributeValue(i);
            }
        } else if (XMLTags.FLOW_LOOP.matches(cursorTask.getLocalName())) {
            type = FlowActionType.LOOP.toString();
            tag = XMLTags.FLOW_LOOP.getXMLName();
            for (int i = 0; i < cursorTask.getAttributeCount(); ++i) {
                attrName = cursorTask.getAttributeLocalName(i);
                if (!XMLAttributes.FLOW_TARGET.matches(attrName)) continue;
                target = cursorTask.getAttributeValue(i);
            }
        }
        FlowScript sc = null;
        try {
            Script<?> internalScript = this.createScript(cursorTask, ScriptType.FLOW, variables);
            switch (FlowActionType.parse(type)) {
                case IF: {
                    sc = FlowScript.createIfFlowScript(internalScript, target, targetElse, targetJoin);
                    break;
                }
                case REPLICATE: {
                    sc = FlowScript.createReplicateFlowScript(internalScript);
                    break;
                }
                case LOOP: {
                    sc = FlowScript.createLoopFlowScript(internalScript, target);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new JobCreationException(tag, null, e);
        }
        try {
            while (cursorTask.hasNext() && (event = cursorTask.next()) != 2) {
            }
        }
        catch (XMLStreamException e) {
            throw new JobCreationException(tag, null, (Exception)e);
        }
        if (event != 2) {
            throw new JobCreationException(tag, null, null);
        }
        return sc;
    }

    private ParallelEnvironment createParallelEnvironment(XMLStreamReader cursorTask, Map<String, String> variables) throws JobCreationException {
        int event = -1;
        int nodesNumber = 0;
        TopologyDescriptor topologyDescriptor = null;
        try {
            String value;
            String attrName;
            int i;
            for (i = 0; i < cursorTask.getAttributeCount(); ++i) {
                attrName = cursorTask.getAttributeLocalName(i);
                if (!XMLAttributes.TASK_NB_NODES.matches(attrName)) continue;
                value = StaxJobFactory.replace(cursorTask.getAttributeValue(i), variables);
                nodesNumber = Integer.parseInt(value);
            }
            while (cursorTask.hasNext() && (event = cursorTask.next()) != 1) {
                if (event != 2 || !XMLTags.PARALLEL_ENV.matches(cursorTask.getLocalName())) continue;
                return new ParallelEnvironment(nodesNumber, TopologyDescriptor.ARBITRARY);
            }
            if (XMLTags.TOPOLOGY.matches(cursorTask.getLocalName())) {
                while (cursorTask.hasNext() && (event = cursorTask.next()) != 1) {
                    if (event != 2 || !XMLTags.TOPOLOGY.matches(cursorTask.getLocalName())) continue;
                    throw new RuntimeException("Incorrect topology description");
                }
                if (XMLTags.TOPOLOGY_ARBITRARY.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.ARBITRARY;
                } else if (XMLTags.TOPOLOGY_BEST_PROXIMITY.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.BEST_PROXIMITY;
                } else if (XMLTags.TOPOLOGY_THRESHOLD_PROXIMITY.matches(cursorTask.getLocalName())) {
                    for (i = 0; i < cursorTask.getAttributeCount(); ++i) {
                        attrName = cursorTask.getAttributeLocalName(i);
                        if (!XMLAttributes.TOPOLOGY_THRESHOLD.matches(attrName)) continue;
                        value = StaxJobFactory.replace(cursorTask.getAttributeValue(i), variables);
                        long threshold = Long.parseLong(value);
                        topologyDescriptor = new ThresholdProximityDescriptor(threshold);
                    }
                } else if (XMLTags.TOPOLOGY_SINGLE_HOST.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.SINGLE_HOST;
                } else if (XMLTags.TOPOLOGY_SINGLE_HOST_EXCLUSIVE.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.SINGLE_HOST_EXCLUSIVE;
                } else if (XMLTags.TOPOLOGY_MULTIPLE_HOSTS_EXCLUSIVE.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.MULTIPLE_HOSTS_EXCLUSIVE;
                } else if (XMLTags.TOPOLOGY_DIFFERENT_HOSTS_EXCLUSIVE.matches(cursorTask.getLocalName())) {
                    topologyDescriptor = TopologyDescriptor.DIFFERENT_HOSTS_EXCLUSIVE;
                }
            }
        }
        catch (Exception e) {
            throw new JobCreationException(XMLTags.TOPOLOGY.getXMLName(), null, e);
        }
        return new ParallelEnvironment(nodesNumber, topologyDescriptor);
    }

    private Script<?> createScript(XMLStreamReader cursorScript, ScriptType type, Map<String, String> variables) throws JobCreationException {
        String attrtmp = null;
        String currentScriptTag = cursorScript.getLocalName();
        String current = null;
        try {
            boolean isDynamic = true;
            SimpleScript toReturn = null;
            int eventType = -1;
            block7: while (cursorScript.hasNext()) {
                eventType = type == ScriptType.SELECTION && eventType == -1 ? cursorScript.getEventType() : cursorScript.next();
                switch (eventType) {
                    case 1: {
                        current = cursorScript.getLocalName();
                        if (XMLTags.SCRIPT_CODE.matches(current)) {
                            int ev;
                            String language = null;
                            String content = "";
                            if (cursorScript.getAttributeCount() > 0) {
                                language = cursorScript.getAttributeValue(0);
                                attrtmp = cursorScript.getAttributeLocalName(0);
                            }
                            if (cursorScript.next() == 4) {
                                content = cursorScript.getText();
                            }
                            toReturn = new SimpleScript(content, language);
                            do {
                                ev = cursorScript.next();
                            } while (!XMLTags.SCRIPT_CODE.matches(current) || ev != 2);
                            continue block7;
                        }
                        if (XMLTags.SCRIPT_FILE.matches(current)) {
                            int ev;
                            String path = null;
                            String url = null;
                            String language = null;
                            for (int i = 0; i < cursorScript.getAttributeCount(); ++i) {
                                attrtmp = cursorScript.getAttributeLocalName(i);
                                if (XMLAttributes.SCRIPT_URL.matches(attrtmp)) {
                                    url = StaxJobFactory.replace(cursorScript.getAttributeValue(i), variables);
                                    continue;
                                }
                                if (XMLAttributes.LANGUAGE.matches(attrtmp)) {
                                    language = StaxJobFactory.replace(cursorScript.getAttributeValue(i), variables);
                                    continue;
                                }
                                if (XMLAttributes.PATH.matches(attrtmp)) {
                                    path = this.checkPath(cursorScript.getAttributeValue(i), variables);
                                    continue;
                                }
                                throw new JobCreationException("Unrecognized attribute : " + attrtmp);
                            }
                            while (!((ev = cursorScript.next()) == 1 && XMLTags.SCRIPT_ARGUMENTS.matches(cursorScript.getLocalName()) || ev == 2)) {
                            }
                            if (url != null) {
                                if (language != null) {
                                    toReturn = new SimpleScript(new URL(url), language, (Serializable[])this.getArguments(cursorScript));
                                    continue block7;
                                }
                                toReturn = new SimpleScript(new URL(url), (Serializable[])this.getArguments(cursorScript));
                                continue block7;
                            }
                            if (path != null) {
                                toReturn = new SimpleScript(new File(path), (Serializable[])this.getArguments(cursorScript));
                                continue block7;
                            }
                            attrtmp = null;
                            throw new JobCreationException("Invalid script file definition, one of path/url attributes must be declared");
                        }
                        if (XMLTags.SCRIPT_ARGUMENTS.matches(current)) {
                            toReturn = new SimpleScript(toReturn.getScript(), toReturn.getEngineName(), (Serializable[])this.getArguments(cursorScript));
                            continue block7;
                        }
                        if (!XMLTags.SCRIPT_SCRIPT.matches(current) || cursorScript.getAttributeCount() <= 0) continue block7;
                        isDynamic = !"static".equals(cursorScript.getAttributeValue(0));
                        continue block7;
                    }
                    case 2: {
                        if (!cursorScript.getLocalName().equals(currentScriptTag)) continue block7;
                        if (type == ScriptType.SELECTION) {
                            return new SelectionScript(toReturn, isDynamic);
                        }
                        return toReturn;
                    }
                }
            }
            return toReturn;
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(current, attrtmp, e);
        }
    }

    private List<SelectionScript> createSelectionScript(XMLStreamReader cursorScript, Map<String, String> variables) throws JobCreationException {
        ArrayList<SelectionScript> scripts = new ArrayList<SelectionScript>(0);
        String selectionTag = cursorScript.getLocalName();
        String current = null;
        try {
            block7: while (cursorScript.hasNext()) {
                int eventType = cursorScript.next();
                switch (eventType) {
                    case 1: {
                        current = cursorScript.getLocalName();
                        if (!XMLTags.SCRIPT_SCRIPT.matches(current)) continue block7;
                        SelectionScript newOne = (SelectionScript)this.createScript(cursorScript, ScriptType.SELECTION, variables);
                        scripts.add(newOne);
                        continue block7;
                    }
                    case 2: {
                        current = cursorScript.getLocalName();
                        if (!current.equals(selectionTag)) continue block7;
                        return scripts.isEmpty() ? null : scripts;
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            throw new JobCreationException(current, null, e);
        }
        return scripts;
    }

    private Script<?> createScript(XMLStreamReader cursorScript, Map<String, String> variables) throws JobCreationException {
        try {
            return this.createScript(cursorScript, ScriptType.OTHER, variables);
        }
        catch (JobCreationException jce) {
            jce.pushTag(XMLTags.SCRIPT_SCRIPT.getXMLName());
            throw jce;
        }
    }

    private String[] getArguments(XMLStreamReader cursorArgs) throws JobCreationException {
        if (XMLTags.SCRIPT_ARGUMENTS.matches(cursorArgs.getLocalName())) {
            ArrayList<String> args = new ArrayList<String>(0);
            try {
                block6: while (cursorArgs.hasNext()) {
                    int eventType = cursorArgs.next();
                    switch (eventType) {
                        case 1: {
                            if (!XMLTags.SCRIPT_ARGUMENT.matches(cursorArgs.getLocalName())) continue block6;
                            args.add(cursorArgs.getAttributeValue(0));
                            continue block6;
                        }
                        case 2: {
                            if (!XMLTags.SCRIPT_ARGUMENTS.matches(cursorArgs.getLocalName())) continue block6;
                            return args.toArray(new String[args.size()]);
                        }
                    }
                }
                return args.toArray(new String[args.size()]);
            }
            catch (Exception e) {
                String temporaryAttribute = null;
                if (cursorArgs.isStartElement() && cursorArgs.getAttributeCount() == 1) {
                    temporaryAttribute = cursorArgs.getAttributeLocalName(0);
                }
                throw new JobCreationException(cursorArgs.getLocalName(), temporaryAttribute, e);
            }
        }
        return null;
    }

    private void setNativeExecutable(NativeTask nativeTask, XMLStreamReader cursorExec) throws JobCreationException {
        block15: {
            int i = 0;
            String current = null;
            try {
                while (cursorExec.next() != 1) {
                }
                current = cursorExec.getLocalName();
                ArrayList<String> command = new ArrayList<String>(0);
                if (XMLTags.NATIVE_TASK_STATIC_COMMAND.matches(cursorExec.getLocalName())) {
                    String attr_ = null;
                    String current_ = null;
                    try {
                        for (i = 0; i < cursorExec.getAttributeCount(); ++i) {
                            String attrName;
                            attr_ = attrName = cursorExec.getAttributeLocalName(i);
                            if (XMLAttributes.TASK_COMMAND_VALUE.matches(attrName)) {
                                command.add(cursorExec.getAttributeValue(i));
                            }
                            if (!XMLAttributes.TASK_WORKDING_DIR.matches(attrName)) continue;
                            logger.warn((Object)(XMLAttributes.TASK_WORKDING_DIR.getXMLName() + " attribute no longer supported. Please use a forkEnvironment for defining a working directory."));
                        }
                        block11: while (cursorExec.hasNext()) {
                            int eventType = cursorExec.next();
                            switch (eventType) {
                                case 1: {
                                    current_ = cursorExec.getLocalName();
                                    if (!XMLTags.SCRIPT_ARGUMENT.matches(cursorExec.getLocalName())) continue block11;
                                    command.add(cursorExec.getAttributeValue(0));
                                    continue block11;
                                }
                                case 2: {
                                    if (!XMLTags.NATIVE_EXECUTABLE.matches(cursorExec.getLocalName())) continue block11;
                                    nativeTask.setCommandLine(command.toArray(new String[command.size()]));
                                    return;
                                }
                            }
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        throw new JobCreationException(current_, attr_, e);
                    }
                }
                throw new RuntimeException("Unknown command type: " + cursorExec.getLocalName());
            }
            catch (JobCreationException jce) {
                jce.pushTag(current);
                throw jce;
            }
            catch (Exception e) {
                String temporaryAttribute = null;
                if (cursorExec.isStartElement() && cursorExec.getAttributeCount() > 0) {
                    temporaryAttribute = cursorExec.getAttributeLocalName(i);
                }
                throw new JobCreationException(current, temporaryAttribute, e);
            }
        }
    }

    private void setJavaExecutable(JavaTask javaTask, XMLStreamReader cursorExec, Map<String, String> variables) throws JobCreationException {
        int i = 0;
        String current = cursorExec.getLocalName();
        try {
            int attrCount = cursorExec.getAttributeCount();
            for (i = 0; i < attrCount; ++i) {
                String attrName = cursorExec.getAttributeLocalName(i);
                if (!XMLAttributes.TASK_CLASS_NAME.matches(attrName)) continue;
                javaTask.setExecutableClassName(cursorExec.getAttributeValue(i));
            }
            block8: while (cursorExec.hasNext()) {
                int eventType = cursorExec.next();
                switch (eventType) {
                    case 1: {
                        current = cursorExec.getLocalName();
                        if (XMLTags.FORK_ENVIRONMENT.matches(current)) {
                            ForkEnvironment forkEnv = this.createForkEnvironment(cursorExec, variables);
                            javaTask.setForkEnvironment(forkEnv);
                            continue block8;
                        }
                        if (!XMLTags.TASK_PARAMETER.matches(current)) continue block8;
                        Map<String, String> attributesAsMap = this.getAttributesAsMap(cursorExec, variables);
                        String name = attributesAsMap.get(XMLAttributes.VARIABLE_NAME.getXMLName());
                        String value = attributesAsMap.get(XMLAttributes.VARIABLE_VALUE.getXMLName());
                        javaTask.addArgument(StaxJobFactory.replace(name, variables), (Serializable)((Object)value));
                        continue block8;
                    }
                    case 2: {
                        if (!XMLTags.JAVA_EXECUTABLE.matches(cursorExec.getLocalName())) continue block8;
                        return;
                    }
                }
            }
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorExec.isStartElement() && cursorExec.getAttributeCount() > 0) {
                attrtmp = cursorExec.getAttributeLocalName(i);
            }
            throw new JobCreationException(current, attrtmp, e);
        }
    }

    private ForkEnvironment createForkEnvironment(XMLStreamReader cursorExec, Map<String, String> variables) throws JobCreationException {
        ForkEnvironment forkEnv = new ForkEnvironment();
        int i = 0;
        String current = cursorExec.getLocalName();
        try {
            int attrCount = cursorExec.getAttributeCount();
            for (i = 0; i < attrCount; ++i) {
                String attrName = cursorExec.getAttributeLocalName(i);
                if (XMLAttributes.FORK_JAVA_HOME.matches(attrName)) {
                    forkEnv.setJavaHome(StaxJobFactory.replace(cursorExec.getAttributeValue(i), variables));
                }
                if (!XMLAttributes.TASK_WORKDING_DIR.matches(attrName)) continue;
                forkEnv.setWorkingDir(StaxJobFactory.replace(cursorExec.getAttributeValue(i), variables));
            }
            block8: while (cursorExec.hasNext()) {
                int eventType = cursorExec.next();
                switch (eventType) {
                    case 1: {
                        current = cursorExec.getLocalName();
                        if (XMLTags.FORK_SYSTEM_PROPERTY.matches(current)) {
                            attrCount = cursorExec.getAttributeCount();
                            String name = null;
                            String value = null;
                            for (i = 0; i < attrCount; ++i) {
                                String attrName = cursorExec.getAttributeLocalName(i);
                                if (XMLAttributes.COMMON_NAME.matches(attrName)) {
                                    name = StaxJobFactory.replace(cursorExec.getAttributeValue(i), variables);
                                }
                                if (!XMLAttributes.COMMON_VALUE.matches(attrName)) continue;
                                value = StaxJobFactory.replace(cursorExec.getAttributeValue(i), variables);
                            }
                            forkEnv.addSystemEnvironmentVariable(name, value);
                            continue block8;
                        }
                        if (XMLTags.FORK_JVM_ARG.matches(current)) {
                            forkEnv.addJVMArgument(StaxJobFactory.replace(cursorExec.getAttributeValue(0), variables));
                            continue block8;
                        }
                        if (XMLTags.JOB_PATH_ELEMENT.matches(current)) {
                            forkEnv.addAdditionalClasspath(StaxJobFactory.replace(cursorExec.getAttributeValue(0), variables));
                            continue block8;
                        }
                        if (!XMLTags.SCRIPT_ENV.matches(current)) continue block8;
                        forkEnv.setEnvScript((Script<?>)new ForkEnvironmentScript(this.createScript(cursorExec, variables)));
                        continue block8;
                    }
                    case 2: {
                        if (!XMLTags.FORK_ENVIRONMENT.matches(cursorExec.getLocalName())) continue block8;
                        return forkEnv;
                    }
                }
            }
            return forkEnv;
        }
        catch (JobCreationException jce) {
            jce.pushTag(current);
            throw jce;
        }
        catch (Exception e) {
            String attrtmp = null;
            if (cursorExec.isStartElement() && cursorExec.getAttributeCount() > 0) {
                attrtmp = cursorExec.getAttributeLocalName(i);
            }
            throw new JobCreationException(current, attrtmp, e);
        }
    }

    private void makeDependences(Job job, Map<String, ArrayList<String>> dependencies) throws JobCreationException {
        if (dependencies != null && !dependencies.isEmpty() && job.getType() == JobType.TASKSFLOW) {
            TaskFlowJob tfj = (TaskFlowJob)job;
            for (Task t : tfj.getTasks()) {
                ArrayList<String> names = dependencies.get(t.getName());
                this.createTaskDependencies(tfj, t, names);
            }
        }
    }

    private void createTaskDependencies(TaskFlowJob tfj, Task t, ArrayList<String> dependencies) throws JobCreationException {
        if (dependencies != null) {
            for (String name : dependencies) {
                t.addDependence(Optional.ofNullable(tfj.getTask(name)).orElseThrow(() -> new JobCreationException("Unknown dependence: " + name)));
            }
        }
    }

    private static String replace(String str, Map<String, String> variables) throws JobCreationException {
        HashMap<Object, Object> replacements = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            replacements.put(entry.getKey().toString(), entry.getValue().toString());
        }
        replacements.put(SchedulerVars.PA_CATALOG_REST_URL.toString(), PASchedulerProperties.CATALOG_REST_URL.getValueAsString());
        replacements.put(SchedulerVars.PA_SCHEDULER_REST_URL.toString(), PASchedulerProperties.SCHEDULER_REST_URL.getValueAsString());
        if (variables != null) {
            for (Map.Entry<Object, Object> entry : variables.entrySet()) {
                String syspropWithVariableName = System.getProperty((String)entry.getKey());
                if (syspropWithVariableName != null) {
                    replacements.put(entry.getKey(), syspropWithVariableName);
                    continue;
                }
                replacements.put(entry.getKey(), entry.getValue());
            }
        }
        return VariableSubstitutor.filterAndUpdate(str, replacements);
    }

    private String checkPath(String path, Map<String, String> variables) throws JobCreationException {
        if (path == null || "".equals(path)) {
            return path;
        }
        File f = new File(path = StaxJobFactory.replace(path, variables));
        return f.isAbsolute() ? path : this.relativePathRoot + File.separator + path;
    }

    private void displayJobInfo(Job job) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("type: " + job.getType()));
            logger.debug((Object)("name: " + job.getName()));
            logger.debug((Object)("description: " + job.getDescription()));
            logger.debug((Object)("projectName: " + job.getProjectName()));
            logger.debug((Object)("variables: " + job.getVariables()));
            logger.debug((Object)("priority: " + job.getPriority()));
            logger.debug((Object)("onTaskError: " + job.getOnTaskErrorProperty().getValue().toString()));
            logger.debug((Object)("restartTaskOnError: " + job.getRestartTaskOnError()));
            logger.debug((Object)("maxNumberOfExecution: " + job.getMaxNumberOfExecution()));
            logger.debug((Object)("inputSpace: " + job.getInputSpace()));
            logger.debug((Object)("outputSpace: " + job.getOutputSpace()));
            logger.debug((Object)("genericInformation: " + job.getGenericInformation()));
            logger.debug((Object)("visualization: " + job.getVisualization()));
            logger.debug((Object)"TASKS ------------------------------------------------");
            ArrayList<Task> tasks = job.getType().equals(JobType.TASKSFLOW) ? ((TaskFlowJob)job).getTasks() : new ArrayList<Task>();
            for (Task t : tasks) {
                logger.debug((Object)("name: " + t.getName()));
                logger.debug((Object)("description: " + t.getDescription()));
                logger.debug((Object)("parallel: " + t.isParallel()));
                logger.debug((Object)("nbNodes: " + (t.getParallelEnvironment() == null ? "1" : Integer.valueOf(t.getParallelEnvironment().getNodesNumber()))));
                logger.debug((Object)("onTaskError: " + t.getOnTaskErrorProperty().getValue().toString()));
                logger.debug((Object)("preciousResult: " + t.isPreciousResult()));
                logger.debug((Object)("preciousLogs: " + t.isPreciousLogs()));
                logger.debug((Object)("restartTaskOnError: " + t.getRestartTaskOnError()));
                logger.debug((Object)("maxNumberOfExecution: " + t.getMaxNumberOfExecution()));
                logger.debug((Object)("walltime: " + t.getWallTime()));
                logger.debug((Object)("selectionScripts: " + t.getSelectionScripts()));
                logger.debug((Object)("preScript: " + t.getPreScript()));
                logger.debug((Object)("postScript: " + t.getPostScript()));
                logger.debug((Object)("cleaningScript: " + t.getCleaningScript()));
                try {
                    logger.debug((Object)("inputFileList: length=" + t.getInputFilesList().size()));
                    logger.debug((Object)("outputFileList: length=" + t.getOutputFilesList().size()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (t.getDependencesList() != null) {
                    StringBuilder dep = new StringBuilder("dependence: ");
                    t.getDependencesList().forEach(tdep -> dep.append(tdep.getName() + " "));
                    logger.debug((Object)dep);
                } else {
                    logger.debug((Object)"dependence: null");
                }
                logger.debug((Object)("genericInformation: " + t.getGenericInformation()));
                logger.debug((Object)("variables: " + t.getVariables()));
                if (t instanceof JavaTask) {
                    logger.debug((Object)("class: " + ((JavaTask)t).getExecutableClassName()));
                    try {
                        logger.debug((Object)("args: " + ((JavaTask)t).getArguments()));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Cannot get args: " + e.getMessage()), (Throwable)e);
                    }
                    logger.debug((Object)("fork: " + ((JavaTask)t).isFork()));
                } else if (t instanceof NativeTask) {
                    logger.debug((Object)("commandLine: " + Arrays.toString(((NativeTask)t).getCommandLine())));
                } else if (t instanceof ScriptTask) {
                    logger.debug((Object)("script: " + ((ScriptTask)t).getScript()));
                }
                ForkEnvironment forkEnvironment = t.getForkEnvironment();
                if (forkEnvironment != null) {
                    logger.debug((Object)("javaHome: " + forkEnvironment.getJavaHome()));
                    logger.debug((Object)("systemEnvironment: " + forkEnvironment.getSystemEnvironment()));
                    logger.debug((Object)("jvmArguments: " + forkEnvironment.getJVMArguments()));
                    logger.debug((Object)("classpath: " + forkEnvironment.getAdditionalClasspath()));
                    logger.debug((Object)("envScript: " + forkEnvironment.getEnvScript()));
                }
                logger.debug((Object)"--------------------------------------------------");
            }
        }
    }

    private static <T> void autoCopyfields(Class<T> klass, T from, T to) throws IllegalArgumentException, IllegalAccessException {
        for (Field f : klass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            Object newValue = f.get(from);
            if (newValue == null && f.get(to) != null) continue;
            f.set(to, newValue);
        }
    }

    private static void resolveCleaningScripts(TaskFlowJob job, Map<String, String> replacementVariables) {
        for (Task task : job.getTasks()) {
            Script<?> cScript = task.getCleaningScript();
            if (cScript == null) continue;
            VariableSubstitutor.filterAndUpdate(cScript, replacementVariables);
        }
    }

    private static enum ScriptType {
        SELECTION,
        FLOW,
        OTHER;

    }
}

