/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.factories.XMLAttributes;
import org.ow2.proactive.scheduler.common.job.factories.XMLTags;

public class GetJobContentFactory {
    private static final String FOUR_SPACES_INDENT = "    ";
    private static final String TWO_SPACES_INDENT = "  ";
    private static final String TAG_WITH_TWO_ATTRIBUTES = "<%s %s=\"%s\" %s=\"%s\" />";
    private static final String TAG_WITH_THREE_ATTRIBUTES = "<%s %s=\"%s\" %s=\"%s\" %s=\"%s\" />";

    public String replaceVarsAndGenericInfo(String jobContent, Map<String, JobVariable> variables, Map<String, String> genericInformation) {
        int end = jobContent.indexOf(XMLTags.TASK_FLOW.getXMLName());
        String replacedJobContent = this.replaceTagContent(jobContent, XMLTags.VARIABLES, this.newVariablesContent(variables), end);
        replacedJobContent = this.replaceTagContent(replacedJobContent, XMLTags.COMMON_GENERIC_INFORMATION, this.newGenericInfoContent(genericInformation), end);
        return replacedJobContent;
    }

    private String newGenericInfoContent(Map<String, String> genericInformation) {
        return genericInformation.entrySet().stream().map(this::genericInfoContent).map(s -> s + System.lineSeparator()).reduce("", String::concat);
    }

    private String genericInfoContent(Map.Entry<String, String> pair) {
        return String.format("    <%s %s=\"%s\" %s=\"%s\" />", new Object[]{XMLTags.COMMON_INFO, XMLAttributes.COMMON_NAME, pair.getKey(), XMLAttributes.COMMON_VALUE, pair.getValue()});
    }

    private String replaceTagContent(String jobContent, XMLTags tag, String newContent, int end) {
        String firstHalf = jobContent.substring(0, end);
        String untouchablePart = jobContent.substring(end);
        Optional<Matcher> openMatcher = this.indexOfPattern(firstHalf, tag.getOpenTagPattern());
        if (!openMatcher.isPresent()) {
            return jobContent;
        }
        int afterOpenTag = openMatcher.get().end();
        Optional<Matcher> closeMatcher = this.indexOfPattern(firstHalf, tag.getCloseTagPattern());
        if (!closeMatcher.isPresent()) {
            return jobContent;
        }
        int beforeCloseTag = closeMatcher.get().start();
        String beforeNewContent = firstHalf.substring(0, afterOpenTag) + System.lineSeparator();
        String afterNewContent = TWO_SPACES_INDENT + firstHalf.substring(beforeCloseTag);
        return beforeNewContent + newContent + afterNewContent + untouchablePart;
    }

    private Optional<Matcher> indexOfPattern(String content, String pattern) {
        Pattern aPattern = Pattern.compile(pattern);
        Matcher matcher = aPattern.matcher(content);
        if (matcher.find()) {
            return Optional.of(matcher);
        }
        return Optional.empty();
    }

    private String newVariablesContent(Map<String, JobVariable> variables) {
        return variables.values().stream().map(this::variableContent).map(s -> s + System.lineSeparator()).reduce("", String::concat);
    }

    private String variableContent(JobVariable jobVariable) {
        if (jobVariable.getModel() != null && !jobVariable.getModel().trim().isEmpty()) {
            return String.format("    <%s %s=\"%s\" %s=\"%s\" %s=\"%s\" />", new Object[]{XMLTags.VARIABLE.getXMLName(), XMLAttributes.VARIABLE_NAME, jobVariable.getName(), XMLAttributes.VARIABLE_VALUE, jobVariable.getValue(), XMLAttributes.VARIABLE_MODEL, jobVariable.getModel()});
        }
        return String.format("    <%s %s=\"%s\" %s=\"%s\" />", new Object[]{XMLTags.VARIABLE.getXMLName(), XMLAttributes.VARIABLE_NAME, jobVariable.getName(), XMLAttributes.VARIABLE_VALUE, jobVariable.getValue()});
    }
}

