/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.GUIDGenerator;
import it.sauronsoftware.cron4j.SchedulingPattern;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskCollector;
import it.sauronsoftware.cron4j.TaskTable;
import java.util.ArrayList;

class MemoryTaskCollector
implements TaskCollector {
    private int size = 0;
    private ArrayList patterns = new ArrayList();
    private ArrayList tasks = new ArrayList();
    private ArrayList ids = new ArrayList();

    MemoryTaskCollector() {
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized String add(SchedulingPattern schedulingPattern, Task task) {
        String string = GUIDGenerator.generate();
        this.patterns.add(schedulingPattern);
        this.tasks.add(task);
        this.ids.add(string);
        return string;
    }

    public synchronized void update(String string, SchedulingPattern schedulingPattern) {
        int n = this.ids.indexOf(string);
        if (n > -1) {
            this.patterns.set(n, schedulingPattern);
        }
    }

    public synchronized void remove(String string) throws IndexOutOfBoundsException {
        int n = this.ids.indexOf(string);
        if (n > -1) {
            this.tasks.remove(n);
            this.patterns.remove(n);
            this.ids.remove(n);
        }
    }

    public synchronized Task getTask(String string) {
        int n = this.ids.indexOf(string);
        if (n > -1) {
            return (Task)this.tasks.get(n);
        }
        return null;
    }

    public synchronized SchedulingPattern getSchedulingPattern(String string) {
        int n = this.ids.indexOf(string);
        if (n > -1) {
            return (SchedulingPattern)this.patterns.get(n);
        }
        return null;
    }

    public synchronized TaskTable getTasks() {
        TaskTable taskTable = new TaskTable();
        int n = this.tasks.size();
        for (int i = 0; i < n; ++i) {
            Task task = (Task)this.tasks.get(i);
            SchedulingPattern schedulingPattern = (SchedulingPattern)this.patterns.get(i);
            taskTable.add(schedulingPattern, task);
        }
        return taskTable;
    }
}

