/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import junit.framework.TestCase;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.RemoteControlConfiguration;

public class FrameGroupCommandQueueUnitTest
extends TestCase {
    private static String firstSessionId = "session 1";
    private static String firstQueueId = "queue 1";
    private static String secondSessionId = "session 2";
    private static int defaultSpeed = CommandQueue.getSpeed();
    private static int newSpeed = defaultSpeed + 42;

    public void testGetGlobalQueueSpeed() {
        FrameGroupCommandQueueUnitTest.assertEquals((int)defaultSpeed, (int)CommandQueue.getSpeed());
        FrameGroupCommandQueueSet session1 = FrameGroupCommandQueueSet.makeQueueSet((String)firstSessionId, (int)4444, (RemoteControlConfiguration)new RemoteControlConfiguration());
        int sessionSpeedOnInit = session1.getSpeed();
        FrameGroupCommandQueueUnitTest.assertEquals((int)defaultSpeed, (int)sessionSpeedOnInit);
        FrameGroupCommandQueueSet.clearQueueSet((String)firstSessionId);
    }

    public void testSetGlobalQueueSpeed() {
        FrameGroupCommandQueueUnitTest.assertEquals((int)defaultSpeed, (int)CommandQueue.getSpeed());
        CommandQueue.setSpeed((int)newSpeed);
        FrameGroupCommandQueueSet session1 = FrameGroupCommandQueueSet.makeQueueSet((String)firstSessionId, (int)4444, (RemoteControlConfiguration)new RemoteControlConfiguration());
        int sessionSpeedOnInit = session1.getSpeed();
        FrameGroupCommandQueueUnitTest.assertEquals((int)newSpeed, (int)sessionSpeedOnInit);
        CommandQueue.setSpeed((int)defaultSpeed);
        FrameGroupCommandQueueSet.clearQueueSet((String)firstSessionId);
    }

    public void testSetSessionSpeedNotGlobalSpeed() {
        FrameGroupCommandQueueUnitTest.assertEquals((int)defaultSpeed, (int)CommandQueue.getSpeed());
        FrameGroupCommandQueueSet session1 = FrameGroupCommandQueueSet.makeQueueSet((String)firstSessionId, (int)4444, (RemoteControlConfiguration)new RemoteControlConfiguration());
        session1.setSpeed(newSpeed);
        int sessionSpeedOnInit = session1.getSpeed();
        FrameGroupCommandQueueUnitTest.assertEquals((int)newSpeed, (int)sessionSpeedOnInit);
        FrameGroupCommandQueueSet session2 = FrameGroupCommandQueueSet.makeQueueSet((String)secondSessionId, (int)4444, (RemoteControlConfiguration)new RemoteControlConfiguration());
        int session2SpeedOnInit = session2.getSpeed();
        FrameGroupCommandQueueUnitTest.assertEquals((int)defaultSpeed, (int)session2SpeedOnInit);
        FrameGroupCommandQueueSet.clearQueueSet((String)firstSessionId);
        FrameGroupCommandQueueSet.clearQueueSet((String)secondSessionId);
    }

    public void testCommandQueueInitSpeedMatchesSessionSpeed() {
        FrameGroupCommandQueueUnitTest.assertEquals((int)defaultSpeed, (int)CommandQueue.getSpeed());
        FrameGroupCommandQueueSet session1 = FrameGroupCommandQueueSet.makeQueueSet((String)firstSessionId, (int)4444, (RemoteControlConfiguration)new RemoteControlConfiguration());
        session1.setSpeed(newSpeed);
        CommandQueue queue1 = session1.getCommandQueue(firstQueueId);
        FrameGroupCommandQueueUnitTest.assertEquals((int)newSpeed, (int)queue1.getQueueDelay());
        FrameGroupCommandQueueUnitTest.assertEquals((int)defaultSpeed, (int)CommandQueue.getSpeed());
        FrameGroupCommandQueueSet.clearQueueSet((String)firstSessionId);
    }
}

