# -*- coding: utf-8 -*-

# django-security-txt
# security_txt/migrations/0003_auto_20210322_1857.py

# Generated by Django 3.1.7 on 2021-03-22 18:57


from typing import List, Tuple  # pylint: disable=W0611

import phonenumber_field.modelfields
from django.db import models, migrations
from django.core.validators import URLValidator
from django.db.migrations.operations.base import Operation


class Migration(migrations.Migration):

    dependencies = [
        ("security_txt", "0002_canonical"),
    ]  # type: List[Tuple[str, str]]

    operations = [
        migrations.AlterField(
            model_name="acknowledgment",
            name="url",
            field=models.URLField(
                db_index=True,
                help_text="link to page where security researchers are recognized",
                max_length=512,
                unique=True,
                validators=[URLValidator(schemes=["https"])],
                verbose_name="URL",
            ),
        ),
        migrations.AlterField(
            model_name="canonical",
            name="url",
            field=models.URLField(
                db_index=True,
                help_text="indicates the canonical URIs where the security.txt file is located",  # noqa: E501
                max_length=512,
                unique=True,
                validators=[URLValidator(schemes=["https"])],
                verbose_name="URL",
            ),
        ),
        migrations.CreateModel(
            name="Contact",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "type",
                    models.PositiveIntegerField(
                        choices=[(1, "E-mail"), (2, "Phone"), (3, "URL")],
                        db_index=True,
                        default=1,
                        help_text="contact type, possible variants: E-mail, Phone, URL",
                        verbose_name="type",
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True,
                        db_index=True,
                        help_text="contact e-mail",
                        max_length=512,
                        null=True,
                        verbose_name="e-mail",
                    ),
                ),
                (
                    "phone",
                    phonenumber_field.modelfields.PhoneNumberField(
                        blank=True,
                        db_index=True,
                        help_text="contact phone number",
                        max_length=128,
                        null=True,
                        region=None,
                        verbose_name="phone",
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        blank=True,
                        db_index=True,
                        help_text="contact page URL",
                        max_length=512,
                        null=True,
                        validators=[URLValidator(schemes=["https"])],
                        verbose_name="URL",
                    ),
                ),
            ],
            options={
                "verbose_name": "contact",
                "verbose_name_plural": "contacts",
                "ordering": ["type"],
                "unique_together": {("type", "email", "phone", "url")},
            },
        ),
    ]  # type: List[Operation]
