# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ErrorDetail(Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error's code.
    :type code: str
    :param message: Required. A human readable error message.
    :type message: str
    :param target: Indicates which property in the request is responsible for
     the error.
    :type target: str
    :param details: Additional error details.
    :type details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ErrorResponse(Model):
    """Error response.

    Contains details when the response code indicates an error.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. The error details.
    :type error: ~azure.mgmt.hybridcompute.models.ErrorDetail
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class Resource(Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param type1: The identity type.
    :type type1: str
    :ivar principal_id: The identity's principal id.
    :vartype principal_id: str
    :ivar tenant_id: The identity's tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type1': {'key': 'identity.type', 'type': 'str'},
        'principal_id': {'key': 'identity.principalId', 'type': 'str'},
        'tenant_id': {'key': 'identity.tenantId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.type1 = kwargs.get('type1', None)
        self.principal_id = None
        self.tenant_id = None


class Machine(Resource):
    """Describes a hybrid machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param type1: The identity type.
    :type type1: str
    :ivar principal_id: The identity's principal id.
    :vartype principal_id: str
    :ivar tenant_id: The identity's tenant id.
    :vartype tenant_id: str
    :param os_profile: Specifies the operating system settings for the hybrid
     machine.
    :type os_profile: ~azure.mgmt.hybridcompute.models.OSProfile
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar status: The status of the hybrid machine agent. Possible values
     include: 'Connected', 'Disconnected', 'Error'
    :vartype status: str or ~azure.mgmt.hybridcompute.models.StatusTypes
    :ivar last_status_change: The time of the last status change.
    :vartype last_status_change: datetime
    :ivar error_details: Details about the error state.
    :vartype error_details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    :ivar agent_version: The hybrid machine agent full version.
    :vartype agent_version: str
    :ivar vm_id: Specifies the hybrid machine unique ID.
    :vartype vm_id: str
    :ivar display_name: Specifies the hybrid machine display name.
    :vartype display_name: str
    :ivar machine_fqdn: Specifies the hybrid machine FQDN.
    :vartype machine_fqdn: str
    :param physical_location: Resource's Physical Location
    :type physical_location: str
    :param client_public_key: Public Key that the client provides to be used
     during initial resource onboarding
    :type client_public_key: str
    :ivar os_name: The Operating System running on the hybrid machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the hybrid
     machine.
    :vartype os_version: str
    :param extensions: Machine Extensions information
    :type extensions:
     list[~azure.mgmt.hybridcompute.models.MachineExtensionInstanceView]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'last_status_change': {'readonly': True},
        'error_details': {'readonly': True},
        'agent_version': {'readonly': True},
        'vm_id': {'readonly': True},
        'display_name': {'readonly': True},
        'machine_fqdn': {'readonly': True},
        'os_name': {'readonly': True},
        'os_version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type1': {'key': 'identity.type', 'type': 'str'},
        'principal_id': {'key': 'identity.principalId', 'type': 'str'},
        'tenant_id': {'key': 'identity.tenantId', 'type': 'str'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'StatusTypes'},
        'last_status_change': {'key': 'properties.lastStatusChange', 'type': 'iso-8601'},
        'error_details': {'key': 'properties.errorDetails', 'type': '[ErrorDetail]'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'machine_fqdn': {'key': 'properties.machineFqdn', 'type': 'str'},
        'physical_location': {'key': 'properties.physicalLocation', 'type': 'str'},
        'client_public_key': {'key': 'properties.clientPublicKey', 'type': 'str'},
        'os_name': {'key': 'properties.osName', 'type': 'str'},
        'os_version': {'key': 'properties.osVersion', 'type': 'str'},
        'extensions': {'key': 'properties.extensions', 'type': '[MachineExtensionInstanceView]'},
    }

    def __init__(self, **kwargs):
        super(Machine, self).__init__(**kwargs)
        self.os_profile = kwargs.get('os_profile', None)
        self.provisioning_state = None
        self.status = None
        self.last_status_change = None
        self.error_details = None
        self.agent_version = None
        self.vm_id = None
        self.display_name = None
        self.machine_fqdn = None
        self.physical_location = kwargs.get('physical_location', None)
        self.client_public_key = kwargs.get('client_public_key', None)
        self.os_name = None
        self.os_version = None
        self.extensions = kwargs.get('extensions', None)


class MachineExtension(Resource):
    """Describes a Machine Extension.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param type1: The identity type.
    :type type1: str
    :ivar principal_id: The identity's principal id.
    :vartype principal_id: str
    :ivar tenant_id: The identity's tenant id.
    :vartype tenant_id: str
    :param force_update_tag: How the extension handler should be forced to
     update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param machine_extension_type: Specifies the type of the extension; an
     example is "CustomScriptExtension".
    :type machine_extension_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should
     use a newer minor version if one is available at deployment time. Once
     deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either
     protectedSettings or protectedSettingsFromKeyVault or no protected
     settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param instance_view: The machine extension instance view.
    :type instance_view:
     ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type1': {'key': 'identity.type', 'type': 'str'},
        'principal_id': {'key': 'identity.principalId', 'type': 'str'},
        'tenant_id': {'key': 'identity.tenantId', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'machine_extension_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'MachineExtensionInstanceView'},
    }

    def __init__(self, **kwargs):
        super(MachineExtension, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.machine_extension_type = kwargs.get('machine_extension_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.instance_view = kwargs.get('instance_view', None)


class MachineExtensionInstanceView(Model):
    """Describes the Machine Extension Instance View.

    :param name: The machine extension name.
    :type name: str
    :param type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param status: Instance view status.
    :type status:
     ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceViewStatus
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'MachineExtensionInstanceViewStatus'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionInstanceView, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.status = kwargs.get('status', None)


class MachineExtensionInstanceViewStatus(Model):
    """Instance view status.

    :param code: The status code.
    :type code: str
    :param level: The level code. Possible values include: 'Info', 'Warning',
     'Error'
    :type level: str or ~azure.mgmt.hybridcompute.models.StatusLevelTypes
    :param display_status: The short localizable label for the status.
    :type display_status: str
    :param message: The detailed status message, including for alerts and
     error messages.
    :type message: str
    :param time: The time of the status.
    :type time: datetime
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'StatusLevelTypes'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionInstanceViewStatus, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.level = kwargs.get('level', None)
        self.display_status = kwargs.get('display_status', None)
        self.message = kwargs.get('message', None)
        self.time = kwargs.get('time', None)


class UpdateResource(Model):
    """The Update Resource model definition.

    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class MachineExtensionUpdate(UpdateResource):
    """Describes a Machine Extension Update.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to
     update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should
     use a newer minor version if one is available at deployment time. Once
     deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either
     protectedSettings or protectedSettingsFromKeyVault or no protected
     settings at all.
    :type protected_settings: object
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionUpdate, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)


class MachineReconnect(Model):
    """Describes a hybrid machine reconnect.

    :param vm_id: Specifies the hybrid machine unique ID.
    :type vm_id: str
    :param client_public_key: Public Key that the client provides to be used
     during initial resource onboarding.
    :type client_public_key: str
    """

    _attribute_map = {
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'client_public_key': {'key': 'properties.clientPublicKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MachineReconnect, self).__init__(**kwargs)
        self.vm_id = kwargs.get('vm_id', None)
        self.client_public_key = kwargs.get('client_public_key', None)


class MachineUpdate(UpdateResource):
    """Describes a hybrid machine Update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param type: The identity type.
    :type type: str
    :ivar principal_id: The identity's principal id.
    :vartype principal_id: str
    :ivar tenant_id: The identity's tenant id.
    :vartype tenant_id: str
    :param physical_location: Resource's Physical Location
    :type physical_location: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'identity.type', 'type': 'str'},
        'principal_id': {'key': 'identity.principalId', 'type': 'str'},
        'tenant_id': {'key': 'identity.tenantId', 'type': 'str'},
        'physical_location': {'key': 'properties.physicalLocation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MachineUpdate, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.principal_id = None
        self.tenant_id = None
        self.physical_location = kwargs.get('physical_location', None)


class OperationValue(Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class OSProfile(Model):
    """Specifies the operating system settings for the hybrid machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar computer_name: Specifies the host OS name of the hybrid machine.
    :vartype computer_name: str
    """

    _validation = {
        'computer_name': {'readonly': True},
    }

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OSProfile, self).__init__(**kwargs)
        self.computer_name = None
