      SUBROUTINE DAXPY(N,DA,DX,INCX,DY,INCY)                                    
C                                                                               
C     CONSTANT TIMES A VECTOR PLUS A VECTOR.                                    
C     USES UNROLLED LOOPS FOR INCREMENTS EQUAL TO ONE.                          
C     JACK DONGARRA, LINPACK, 3/11/78.                                          
C                                                                               
      DOUBLE PRECISION DX(1),DY(1),DA                                           
      INTEGER I,INCX,INCY,IXIY,M,MP1,N                                          
C                                                                               
      IF(N.LE.0)RETURN                                                          
      IF (DA .EQ. 0.0D0) RETURN                                                 
      IF(INCX.EQ.1.AND.INCY.EQ.1)GO TO 20                                       
C                                                                               
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS                        
C          NOT EQUAL TO 1                                                       
C                                                                               
      IX = 1                                                                    
      IY = 1                                                                    
      IF(INCX.LT.0)IX = (-N+1)*INCX + 1                                         
      IF(INCY.LT.0)IY = (-N+1)*INCY + 1                                         
      DO 10 I = 1,N                                                             
        DY(IY) = DY(IY) + DA*DX(IX)                                             
        IX = IX + INCX                                                          
        IY = IY + INCY                                                          
   10 CONTINUE                                                                  
      RETURN                                                                    
C                                                                               
C        CODE FOR BOTH INCREMENTS EQUAL TO 1                                    
C                                                                               
C                                                                               
C        CLEAN-UP LOOP                                                          
C                                                                               
   20 M = MOD(N,4)                                                              
      IF( M .EQ. 0 ) GO TO 40                                                   
      DO 30 I = 1,M                                                             
        DY(I) = DY(I) + DA*DX(I)                                                
   30 CONTINUE                                                                  
      IF( N .LT. 4 ) RETURN                                                     
   40 MP1 = M + 1                                                               
      DO 50 I = MP1,N,4                                                         
        DY(I) = DY(I) + DA*DX(I)                                                
        DY(I + 1) = DY(I + 1) + DA*DX(I + 1)                                    
        DY(I + 2) = DY(I + 2) + DA*DX(I + 2)                                    
        DY(I + 3) = DY(I + 3) + DA*DX(I + 3)                                    
   50 CONTINUE                                                                  
      RETURN                                                                    
      END                                                                       
