# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessPolicy(msrest.serialization.Model):
    """AccessPolicy.

    :param start: Start time of the access policy.
    :type start: ~datetime.datetime
    :param expiry: Expiry time of the access policy.
    :type expiry: ~datetime.datetime
    :param permission: List of abbreviated permissions.
    :type permission: str
    """

    _attribute_map = {
        'start': {'key': 'start', 'type': 'iso-8601'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'permission': {'key': 'permission', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessPolicy, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.expiry = kwargs.get('expiry', None)
        self.permission = kwargs.get('permission', None)


class AccountSasParameters(msrest.serialization.Model):
    """The parameters to list SAS credentials of a storage account.

    All required parameters must be populated in order to send to Azure.

    :param services: Required. The signed services accessible with the account SAS. Possible values
     include: Blob (b), Queue (q), Table (t), File (f). Possible values include: "b", "q", "t", "f".
    :type services: str or ~azure.mgmt.storage.v2021_04_01.models.Services
    :param resource_types: Required. The signed resource types that are accessible with the account
     SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs;
     Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     Possible values include: "s", "c", "o".
    :type resource_types: str or ~azure.mgmt.storage.v2021_04_01.models.SignedResourceTypes
    :param permissions: Required. The signed permissions for the account SAS. Possible values
     include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process
     (p). Possible values include: "r", "d", "w", "l", "a", "c", "u", "p".
    :type permissions: str or ~azure.mgmt.storage.v2021_04_01.models.Permissions
    :param ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :type ip_address_or_range: str
    :param protocols: The protocol permitted for a request made with the account SAS. Possible
     values include: "https,http", "https".
    :type protocols: str or ~azure.mgmt.storage.v2021_04_01.models.HttpProtocol
    :param shared_access_start_time: The time at which the SAS becomes valid.
    :type shared_access_start_time: ~datetime.datetime
    :param shared_access_expiry_time: Required. The time at which the shared access signature
     becomes invalid.
    :type shared_access_expiry_time: ~datetime.datetime
    :param key_to_sign: The key to sign the account SAS token with.
    :type key_to_sign: str
    """

    _validation = {
        'services': {'required': True},
        'resource_types': {'required': True},
        'permissions': {'required': True},
        'shared_access_expiry_time': {'required': True},
    }

    _attribute_map = {
        'services': {'key': 'signedServices', 'type': 'str'},
        'resource_types': {'key': 'signedResourceTypes', 'type': 'str'},
        'permissions': {'key': 'signedPermission', 'type': 'str'},
        'ip_address_or_range': {'key': 'signedIp', 'type': 'str'},
        'protocols': {'key': 'signedProtocol', 'type': 'str'},
        'shared_access_start_time': {'key': 'signedStart', 'type': 'iso-8601'},
        'shared_access_expiry_time': {'key': 'signedExpiry', 'type': 'iso-8601'},
        'key_to_sign': {'key': 'keyToSign', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountSasParameters, self).__init__(**kwargs)
        self.services = kwargs['services']
        self.resource_types = kwargs['resource_types']
        self.permissions = kwargs['permissions']
        self.ip_address_or_range = kwargs.get('ip_address_or_range', None)
        self.protocols = kwargs.get('protocols', None)
        self.shared_access_start_time = kwargs.get('shared_access_start_time', None)
        self.shared_access_expiry_time = kwargs['shared_access_expiry_time']
        self.key_to_sign = kwargs.get('key_to_sign', None)


class ActiveDirectoryProperties(msrest.serialization.Model):
    """Settings properties for Active Directory (AD).

    All required parameters must be populated in order to send to Azure.

    :param domain_name: Required. Specifies the primary domain that the AD DNS server is
     authoritative for.
    :type domain_name: str
    :param net_bios_domain_name: Required. Specifies the NetBIOS domain name.
    :type net_bios_domain_name: str
    :param forest_name: Required. Specifies the Active Directory forest to get.
    :type forest_name: str
    :param domain_guid: Required. Specifies the domain GUID.
    :type domain_guid: str
    :param domain_sid: Required. Specifies the security identifier (SID).
    :type domain_sid: str
    :param azure_storage_sid: Required. Specifies the security identifier (SID) for Azure Storage.
    :type azure_storage_sid: str
    """

    _validation = {
        'domain_name': {'required': True},
        'net_bios_domain_name': {'required': True},
        'forest_name': {'required': True},
        'domain_guid': {'required': True},
        'domain_sid': {'required': True},
        'azure_storage_sid': {'required': True},
    }

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'net_bios_domain_name': {'key': 'netBiosDomainName', 'type': 'str'},
        'forest_name': {'key': 'forestName', 'type': 'str'},
        'domain_guid': {'key': 'domainGuid', 'type': 'str'},
        'domain_sid': {'key': 'domainSid', 'type': 'str'},
        'azure_storage_sid': {'key': 'azureStorageSid', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActiveDirectoryProperties, self).__init__(**kwargs)
        self.domain_name = kwargs['domain_name']
        self.net_bios_domain_name = kwargs['net_bios_domain_name']
        self.forest_name = kwargs['forest_name']
        self.domain_guid = kwargs['domain_guid']
        self.domain_sid = kwargs['domain_sid']
        self.azure_storage_sid = kwargs['azure_storage_sid']


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for an Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class AzureFilesIdentityBasedAuthentication(msrest.serialization.Model):
    """Settings for Azure Files identity based authentication.

    All required parameters must be populated in order to send to Azure.

    :param directory_service_options: Required. Indicates the directory service used. Possible
     values include: "None", "AADDS", "AD".
    :type directory_service_options: str or
     ~azure.mgmt.storage.v2021_04_01.models.DirectoryServiceOptions
    :param active_directory_properties: Required if choose AD.
    :type active_directory_properties:
     ~azure.mgmt.storage.v2021_04_01.models.ActiveDirectoryProperties
    :param default_share_permission: Default share permission for users using Kerberos
     authentication if RBAC role is not assigned. Possible values include: "None",
     "StorageFileDataSmbShareReader", "StorageFileDataSmbShareContributor",
     "StorageFileDataSmbShareElevatedContributor", "StorageFileDataSmbShareOwner".
    :type default_share_permission: str or
     ~azure.mgmt.storage.v2021_04_01.models.DefaultSharePermission
    """

    _validation = {
        'directory_service_options': {'required': True},
    }

    _attribute_map = {
        'directory_service_options': {'key': 'directoryServiceOptions', 'type': 'str'},
        'active_directory_properties': {'key': 'activeDirectoryProperties', 'type': 'ActiveDirectoryProperties'},
        'default_share_permission': {'key': 'defaultSharePermission', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureFilesIdentityBasedAuthentication, self).__init__(**kwargs)
        self.directory_service_options = kwargs['directory_service_options']
        self.active_directory_properties = kwargs.get('active_directory_properties', None)
        self.default_share_permission = kwargs.get('default_share_permission', None)


class BlobContainer(AzureEntityResource):
    """Properties of the blob container, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar version: The version of the deleted blob container.
    :vartype version: str
    :ivar deleted: Indicates whether the blob container was deleted.
    :vartype deleted: bool
    :ivar deleted_time: Blob container deletion time.
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days: Remaining retention days for soft deleted blob container.
    :vartype remaining_retention_days: int
    :param default_encryption_scope: Default the container to use specified encryption scope for
     all writes.
    :type default_encryption_scope: str
    :param deny_encryption_scope_override: Block override of encryption scope from the container
     default.
    :type deny_encryption_scope_override: bool
    :param public_access: Specifies whether data in the container may be accessed publicly and the
     level of access. Possible values include: "Container", "Blob", "None".
    :type public_access: str or ~azure.mgmt.storage.v2021_04_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar lease_status: The lease status of the container. Possible values include: "Locked",
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Possible values include: "Available",
     "Leased", "Expired", "Breaking", "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of infinite or fixed
     duration, only when the container is leased. Possible values include: "Infinite", "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseDuration
    :param metadata: A name-value pair to associate with the container as metadata.
    :type metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2021_04_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold: ~azure.mgmt.storage.v2021_04_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property is set to true by SRP
     if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public
     property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    :param immutable_storage_with_versioning: The object level immutability property of the
     container. The property is immutable and can only be set to true at the container creation
     time. Existing containers must undergo a migration process.
    :type immutable_storage_with_versioning:
     ~azure.mgmt.storage.v2021_04_01.models.ImmutableStorageWithVersioning
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'version': {'readonly': True},
        'deleted': {'readonly': True},
        'deleted_time': {'readonly': True},
        'remaining_retention_days': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'lease_status': {'readonly': True},
        'lease_state': {'readonly': True},
        'lease_duration': {'readonly': True},
        'immutability_policy': {'readonly': True},
        'legal_hold': {'readonly': True},
        'has_legal_hold': {'readonly': True},
        'has_immutability_policy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'deleted': {'key': 'properties.deleted', 'type': 'bool'},
        'deleted_time': {'key': 'properties.deletedTime', 'type': 'iso-8601'},
        'remaining_retention_days': {'key': 'properties.remainingRetentionDays', 'type': 'int'},
        'default_encryption_scope': {'key': 'properties.defaultEncryptionScope', 'type': 'str'},
        'deny_encryption_scope_override': {'key': 'properties.denyEncryptionScopeOverride', 'type': 'bool'},
        'public_access': {'key': 'properties.publicAccess', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'lease_status': {'key': 'properties.leaseStatus', 'type': 'str'},
        'lease_state': {'key': 'properties.leaseState', 'type': 'str'},
        'lease_duration': {'key': 'properties.leaseDuration', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'immutability_policy': {'key': 'properties.immutabilityPolicy', 'type': 'ImmutabilityPolicyProperties'},
        'legal_hold': {'key': 'properties.legalHold', 'type': 'LegalHoldProperties'},
        'has_legal_hold': {'key': 'properties.hasLegalHold', 'type': 'bool'},
        'has_immutability_policy': {'key': 'properties.hasImmutabilityPolicy', 'type': 'bool'},
        'immutable_storage_with_versioning': {'key': 'properties.immutableStorageWithVersioning', 'type': 'ImmutableStorageWithVersioning'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobContainer, self).__init__(**kwargs)
        self.version = None
        self.deleted = None
        self.deleted_time = None
        self.remaining_retention_days = None
        self.default_encryption_scope = kwargs.get('default_encryption_scope', None)
        self.deny_encryption_scope_override = kwargs.get('deny_encryption_scope_override', None)
        self.public_access = kwargs.get('public_access', None)
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = kwargs.get('metadata', None)
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None
        self.immutable_storage_with_versioning = kwargs.get('immutable_storage_with_versioning', None)


class BlobInventoryPolicy(Resource):
    """The storage account blob inventory policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.storage.v2021_04_01.models.SystemData
    :ivar last_modified_time: Returns the last modified date and time of the blob inventory policy.
    :vartype last_modified_time: ~datetime.datetime
    :param policy: The storage account blob inventory policy object. It is composed of policy
     rules.
    :type policy: ~azure.mgmt.storage.v2021_04_01.models.BlobInventoryPolicySchema
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'policy': {'key': 'properties.policy', 'type': 'BlobInventoryPolicySchema'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobInventoryPolicy, self).__init__(**kwargs)
        self.system_data = None
        self.last_modified_time = None
        self.policy = kwargs.get('policy', None)


class BlobInventoryPolicyDefinition(msrest.serialization.Model):
    """An object that defines the blob inventory rule.

    All required parameters must be populated in order to send to Azure.

    :param filters: An object that defines the filter set.
    :type filters: ~azure.mgmt.storage.v2021_04_01.models.BlobInventoryPolicyFilter
    :param format: Required. This is a required field, it specifies the format for the inventory
     files. Possible values include: "Csv", "Parquet".
    :type format: str or ~azure.mgmt.storage.v2021_04_01.models.Format
    :param schedule: Required. This is a required field. This field is used to schedule an
     inventory formation. Possible values include: "Daily", "Weekly".
    :type schedule: str or ~azure.mgmt.storage.v2021_04_01.models.Schedule
    :param object_type: Required. This is a required field. This field specifies the scope of the
     inventory created either at the blob or container level. Possible values include: "Blob",
     "Container".
    :type object_type: str or ~azure.mgmt.storage.v2021_04_01.models.ObjectType
    :param schema_fields: Required. This is a required field. This field specifies the fields and
     properties of the object to be included in the inventory. The Schema field value 'Name' is
     always required. The valid values for this field for the 'Blob' definition.objectType include
     'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier,
     AccessTierChangeTime, Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot,
     VersionId, IsCurrentVersion, Metadata, LastAccessTime'. The valid values for 'Container'
     definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState,
     LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold'. Schema field values
     'Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl' are valid only for Hns enabled
     accounts.
    :type schema_fields: list[str]
    """

    _validation = {
        'format': {'required': True},
        'schedule': {'required': True},
        'object_type': {'required': True},
        'schema_fields': {'required': True},
    }

    _attribute_map = {
        'filters': {'key': 'filters', 'type': 'BlobInventoryPolicyFilter'},
        'format': {'key': 'format', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'schema_fields': {'key': 'schemaFields', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobInventoryPolicyDefinition, self).__init__(**kwargs)
        self.filters = kwargs.get('filters', None)
        self.format = kwargs['format']
        self.schedule = kwargs['schedule']
        self.object_type = kwargs['object_type']
        self.schema_fields = kwargs['schema_fields']


class BlobInventoryPolicyFilter(msrest.serialization.Model):
    """An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType all filter properties are applicable, 'blobTypes' is required and others are optional. For 'Container' definition.objectType only prefixMatch is applicable and is optional.

    :param prefix_match: An array of strings for blob prefixes to be matched.
    :type prefix_match: list[str]
    :param blob_types: An array of predefined enum values. Valid values include blockBlob,
     appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when
     definition.objectType property is set to 'Blob'.
    :type blob_types: list[str]
    :param include_blob_versions: Includes blob versions in blob inventory when value is set to
     true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this
     property is set to true, else they must be excluded.
    :type include_blob_versions: bool
    :param include_snapshots: Includes blob snapshots in blob inventory when value is set to true.
     The definition.schemaFields value 'Snapshot' is required if this property is set to true, else
     it must be excluded.
    :type include_snapshots: bool
    """

    _attribute_map = {
        'prefix_match': {'key': 'prefixMatch', 'type': '[str]'},
        'blob_types': {'key': 'blobTypes', 'type': '[str]'},
        'include_blob_versions': {'key': 'includeBlobVersions', 'type': 'bool'},
        'include_snapshots': {'key': 'includeSnapshots', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobInventoryPolicyFilter, self).__init__(**kwargs)
        self.prefix_match = kwargs.get('prefix_match', None)
        self.blob_types = kwargs.get('blob_types', None)
        self.include_blob_versions = kwargs.get('include_blob_versions', None)
        self.include_snapshots = kwargs.get('include_snapshots', None)


class BlobInventoryPolicyRule(msrest.serialization.Model):
    """An object that wraps the blob inventory rule. Each rule is uniquely defined by name.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Rule is enabled when set to true.
    :type enabled: bool
    :param name: Required. A rule name can contain any combination of alpha numeric characters.
     Rule name is case-sensitive. It must be unique within a policy.
    :type name: str
    :param destination: Required. Container name where blob inventory files are stored. Must be
     pre-created.
    :type destination: str
    :param definition: Required. An object that defines the blob inventory policy rule.
    :type definition: ~azure.mgmt.storage.v2021_04_01.models.BlobInventoryPolicyDefinition
    """

    _validation = {
        'enabled': {'required': True},
        'name': {'required': True},
        'destination': {'required': True},
        'definition': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
        'definition': {'key': 'definition', 'type': 'BlobInventoryPolicyDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobInventoryPolicyRule, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.name = kwargs['name']
        self.destination = kwargs['destination']
        self.definition = kwargs['definition']


class BlobInventoryPolicySchema(msrest.serialization.Model):
    """The storage account blob inventory policy rules.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Policy is enabled if set to true.
    :type enabled: bool
    :param type: Required. The valid value is Inventory. Possible values include: "Inventory".
    :type type: str or ~azure.mgmt.storage.v2021_04_01.models.InventoryRuleType
    :param rules: Required. The storage account blob inventory policy rules. The rule is applied
     when it is enabled.
    :type rules: list[~azure.mgmt.storage.v2021_04_01.models.BlobInventoryPolicyRule]
    """

    _validation = {
        'enabled': {'required': True},
        'type': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[BlobInventoryPolicyRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobInventoryPolicySchema, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.type = kwargs['type']
        self.rules = kwargs['rules']


class BlobRestoreParameters(msrest.serialization.Model):
    """Blob restore parameters.

    All required parameters must be populated in order to send to Azure.

    :param time_to_restore: Required. Restore blob to the specified time.
    :type time_to_restore: ~datetime.datetime
    :param blob_ranges: Required. Blob ranges to restore.
    :type blob_ranges: list[~azure.mgmt.storage.v2021_04_01.models.BlobRestoreRange]
    """

    _validation = {
        'time_to_restore': {'required': True},
        'blob_ranges': {'required': True},
    }

    _attribute_map = {
        'time_to_restore': {'key': 'timeToRestore', 'type': 'iso-8601'},
        'blob_ranges': {'key': 'blobRanges', 'type': '[BlobRestoreRange]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobRestoreParameters, self).__init__(**kwargs)
        self.time_to_restore = kwargs['time_to_restore']
        self.blob_ranges = kwargs['blob_ranges']


class BlobRestoreRange(msrest.serialization.Model):
    """Blob range.

    All required parameters must be populated in order to send to Azure.

    :param start_range: Required. Blob start range. This is inclusive. Empty means account start.
    :type start_range: str
    :param end_range: Required. Blob end range. This is exclusive. Empty means account end.
    :type end_range: str
    """

    _validation = {
        'start_range': {'required': True},
        'end_range': {'required': True},
    }

    _attribute_map = {
        'start_range': {'key': 'startRange', 'type': 'str'},
        'end_range': {'key': 'endRange', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobRestoreRange, self).__init__(**kwargs)
        self.start_range = kwargs['start_range']
        self.end_range = kwargs['end_range']


class BlobRestoreStatus(msrest.serialization.Model):
    """Blob restore status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of blob restore progress. Possible values are: - InProgress: Indicates
     that blob restore is ongoing. - Complete: Indicates that blob restore has been completed
     successfully. - Failed: Indicates that blob restore is failed. Possible values include:
     "InProgress", "Complete", "Failed".
    :vartype status: str or ~azure.mgmt.storage.v2021_04_01.models.BlobRestoreProgressStatus
    :ivar failure_reason: Failure reason when blob restore is failed.
    :vartype failure_reason: str
    :ivar restore_id: Id for tracking blob restore request.
    :vartype restore_id: str
    :ivar parameters: Blob restore request parameters.
    :vartype parameters: ~azure.mgmt.storage.v2021_04_01.models.BlobRestoreParameters
    """

    _validation = {
        'status': {'readonly': True},
        'failure_reason': {'readonly': True},
        'restore_id': {'readonly': True},
        'parameters': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'restore_id': {'key': 'restoreId', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'BlobRestoreParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobRestoreStatus, self).__init__(**kwargs)
        self.status = None
        self.failure_reason = None
        self.restore_id = None
        self.parameters = None


class BlobServiceItems(msrest.serialization.Model):
    """BlobServiceItems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of blob services returned.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.BlobServiceProperties]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BlobServiceProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobServiceItems, self).__init__(**kwargs)
        self.value = None


class BlobServiceProperties(Resource):
    """The properties of a storage account’s Blob service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar sku: Sku name and tier.
    :vartype sku: ~azure.mgmt.storage.v2021_04_01.models.Sku
    :param cors: Specifies CORS rules for the Blob service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the Blob service.
    :type cors: ~azure.mgmt.storage.v2021_04_01.models.CorsRules
    :param default_service_version: DefaultServiceVersion indicates the default version to use for
     requests to the Blob service if an incoming request’s version is not specified. Possible values
     include version 2008-10-27 and all more recent versions.
    :type default_service_version: str
    :param delete_retention_policy: The blob service properties for blob soft delete.
    :type delete_retention_policy: ~azure.mgmt.storage.v2021_04_01.models.DeleteRetentionPolicy
    :param is_versioning_enabled: Versioning is enabled if set to true.
    :type is_versioning_enabled: bool
    :param automatic_snapshot_policy_enabled: Deprecated in favor of isVersioningEnabled property.
    :type automatic_snapshot_policy_enabled: bool
    :param change_feed: The blob service properties for change feed events.
    :type change_feed: ~azure.mgmt.storage.v2021_04_01.models.ChangeFeed
    :param restore_policy: The blob service properties for blob restore policy.
    :type restore_policy: ~azure.mgmt.storage.v2021_04_01.models.RestorePolicyProperties
    :param container_delete_retention_policy: The blob service properties for container soft
     delete.
    :type container_delete_retention_policy:
     ~azure.mgmt.storage.v2021_04_01.models.DeleteRetentionPolicy
    :param last_access_time_tracking_policy: The blob service property to configure last access
     time based tracking policy.
    :type last_access_time_tracking_policy:
     ~azure.mgmt.storage.v2021_04_01.models.LastAccessTimeTrackingPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'cors': {'key': 'properties.cors', 'type': 'CorsRules'},
        'default_service_version': {'key': 'properties.defaultServiceVersion', 'type': 'str'},
        'delete_retention_policy': {'key': 'properties.deleteRetentionPolicy', 'type': 'DeleteRetentionPolicy'},
        'is_versioning_enabled': {'key': 'properties.isVersioningEnabled', 'type': 'bool'},
        'automatic_snapshot_policy_enabled': {'key': 'properties.automaticSnapshotPolicyEnabled', 'type': 'bool'},
        'change_feed': {'key': 'properties.changeFeed', 'type': 'ChangeFeed'},
        'restore_policy': {'key': 'properties.restorePolicy', 'type': 'RestorePolicyProperties'},
        'container_delete_retention_policy': {'key': 'properties.containerDeleteRetentionPolicy', 'type': 'DeleteRetentionPolicy'},
        'last_access_time_tracking_policy': {'key': 'properties.lastAccessTimeTrackingPolicy', 'type': 'LastAccessTimeTrackingPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobServiceProperties, self).__init__(**kwargs)
        self.sku = None
        self.cors = kwargs.get('cors', None)
        self.default_service_version = kwargs.get('default_service_version', None)
        self.delete_retention_policy = kwargs.get('delete_retention_policy', None)
        self.is_versioning_enabled = kwargs.get('is_versioning_enabled', None)
        self.automatic_snapshot_policy_enabled = kwargs.get('automatic_snapshot_policy_enabled', None)
        self.change_feed = kwargs.get('change_feed', None)
        self.restore_policy = kwargs.get('restore_policy', None)
        self.container_delete_retention_policy = kwargs.get('container_delete_retention_policy', None)
        self.last_access_time_tracking_policy = kwargs.get('last_access_time_tracking_policy', None)


class ChangeFeed(msrest.serialization.Model):
    """The blob service properties for change feed events.

    :param enabled: Indicates whether change feed event logging is enabled for the Blob service.
    :type enabled: bool
    :param retention_in_days: Indicates the duration of changeFeed retention in days. Minimum value
     is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite
     retention of the change feed.
    :type retention_in_days: int
    """

    _validation = {
        'retention_in_days': {'maximum': 146000, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ChangeFeed, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a storage account name could not be used. The Reason element
     is only returned if NameAvailable is false. Possible values include: "AccountNameInvalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.storage.v2021_04_01.models.Reason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CloudErrorAutoGenerated(msrest.serialization.Model):
    """An error response from the Storage service.

    :param error: An error response from the Storage service.
    :type error: ~azure.mgmt.storage.v2021_04_01.models.CloudErrorBodyAutoGenerated
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBodyAutoGenerated'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorAutoGenerated, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the Storage service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.storage.v2021_04_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class CloudErrorBodyAutoGenerated(msrest.serialization.Model):
    """An error response from the Storage service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.storage.v2021_04_01.models.CloudErrorBodyAutoGenerated]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBodyAutoGenerated]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBodyAutoGenerated, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class CorsRule(msrest.serialization.Model):
    """Specifies a CORS rule for the Blob service.

    All required parameters must be populated in order to send to Azure.

    :param allowed_origins: Required. Required if CorsRule element is present. A list of origin
     domains that will be allowed via CORS, or "*" to allow all domains.
    :type allowed_origins: list[str]
    :param allowed_methods: Required. Required if CorsRule element is present. A list of HTTP
     methods that are allowed to be executed by the origin.
    :type allowed_methods: list[str or
     ~azure.mgmt.storage.v2021_04_01.models.CorsRuleAllowedMethodsItem]
    :param max_age_in_seconds: Required. Required if CorsRule element is present. The number of
     seconds that the client/browser should cache a preflight response.
    :type max_age_in_seconds: int
    :param exposed_headers: Required. Required if CorsRule element is present. A list of response
     headers to expose to CORS clients.
    :type exposed_headers: list[str]
    :param allowed_headers: Required. Required if CorsRule element is present. A list of headers
     allowed to be part of the cross-origin request.
    :type allowed_headers: list[str]
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'max_age_in_seconds': {'required': True},
        'exposed_headers': {'required': True},
        'allowed_headers': {'required': True},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'allowed_methods': {'key': 'allowedMethods', 'type': '[str]'},
        'max_age_in_seconds': {'key': 'maxAgeInSeconds', 'type': 'int'},
        'exposed_headers': {'key': 'exposedHeaders', 'type': '[str]'},
        'allowed_headers': {'key': 'allowedHeaders', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = kwargs['allowed_origins']
        self.allowed_methods = kwargs['allowed_methods']
        self.max_age_in_seconds = kwargs['max_age_in_seconds']
        self.exposed_headers = kwargs['exposed_headers']
        self.allowed_headers = kwargs['allowed_headers']


class CorsRules(msrest.serialization.Model):
    """Sets the CORS rules. You can include up to five CorsRule elements in the request.

    :param cors_rules: The List of CORS rules. You can include up to five CorsRule elements in the
     request.
    :type cors_rules: list[~azure.mgmt.storage.v2021_04_01.models.CorsRule]
    """

    _attribute_map = {
        'cors_rules': {'key': 'corsRules', 'type': '[CorsRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorsRules, self).__init__(**kwargs)
        self.cors_rules = kwargs.get('cors_rules', None)


class CustomDomain(msrest.serialization.Model):
    """The custom domain assigned to this storage account. This can be set via Update.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the custom domain name assigned to the storage account.
     Name is the CNAME source.
    :type name: str
    :param use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default
     value is false. This should only be set on updates.
    :type use_sub_domain_name: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'use_sub_domain_name': {'key': 'useSubDomainName', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomDomain, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.use_sub_domain_name = kwargs.get('use_sub_domain_name', None)


class DateAfterCreation(msrest.serialization.Model):
    """Object to define the number of days after creation.

    All required parameters must be populated in order to send to Azure.

    :param days_after_creation_greater_than: Required. Value indicating the age in days after
     creation.
    :type days_after_creation_greater_than: float
    """

    _validation = {
        'days_after_creation_greater_than': {'required': True, 'minimum': 0, 'multiple': 1},
    }

    _attribute_map = {
        'days_after_creation_greater_than': {'key': 'daysAfterCreationGreaterThan', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DateAfterCreation, self).__init__(**kwargs)
        self.days_after_creation_greater_than = kwargs['days_after_creation_greater_than']


class DateAfterModification(msrest.serialization.Model):
    """Object to define the number of days after object last modification Or last access. Properties daysAfterModificationGreaterThan and daysAfterLastAccessTimeGreaterThan are mutually exclusive.

    :param days_after_modification_greater_than: Value indicating the age in days after last
     modification.
    :type days_after_modification_greater_than: float
    :param days_after_last_access_time_greater_than: Value indicating the age in days after last
     blob access. This property can only be used in conjunction with last access time tracking
     policy.
    :type days_after_last_access_time_greater_than: float
    """

    _validation = {
        'days_after_modification_greater_than': {'minimum': 0, 'multiple': 1},
        'days_after_last_access_time_greater_than': {'minimum': 0, 'multiple': 1},
    }

    _attribute_map = {
        'days_after_modification_greater_than': {'key': 'daysAfterModificationGreaterThan', 'type': 'float'},
        'days_after_last_access_time_greater_than': {'key': 'daysAfterLastAccessTimeGreaterThan', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DateAfterModification, self).__init__(**kwargs)
        self.days_after_modification_greater_than = kwargs.get('days_after_modification_greater_than', None)
        self.days_after_last_access_time_greater_than = kwargs.get('days_after_last_access_time_greater_than', None)


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class DeletedAccount(ProxyResource):
    """Deleted storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar storage_account_resource_id: Full resource id of the original storage account.
    :vartype storage_account_resource_id: str
    :ivar location: Location of the deleted account.
    :vartype location: str
    :ivar restore_reference: Can be used to attempt recovering this deleted account via
     PutStorageAccount API.
    :vartype restore_reference: str
    :ivar creation_time: Creation time of the deleted account.
    :vartype creation_time: str
    :ivar deletion_time: Deletion time of the deleted account.
    :vartype deletion_time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'storage_account_resource_id': {'readonly': True},
        'location': {'readonly': True},
        'restore_reference': {'readonly': True},
        'creation_time': {'readonly': True},
        'deletion_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'location': {'key': 'properties.location', 'type': 'str'},
        'restore_reference': {'key': 'properties.restoreReference', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'str'},
        'deletion_time': {'key': 'properties.deletionTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedAccount, self).__init__(**kwargs)
        self.storage_account_resource_id = None
        self.location = None
        self.restore_reference = None
        self.creation_time = None
        self.deletion_time = None


class DeletedAccountListResult(msrest.serialization.Model):
    """The response from the List Deleted Accounts operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the list of deleted accounts and their properties.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.DeletedAccount]
    :ivar next_link: Request URL that can be used to query next page of deleted accounts. Returned
     when total number of requested deleted accounts exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedAccountListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DeletedShare(msrest.serialization.Model):
    """The deleted share to be restored.

    All required parameters must be populated in order to send to Azure.

    :param deleted_share_name: Required. Required. Identify the name of the deleted share that will
     be restored.
    :type deleted_share_name: str
    :param deleted_share_version: Required. Required. Identify the version of the deleted share
     that will be restored.
    :type deleted_share_version: str
    """

    _validation = {
        'deleted_share_name': {'required': True},
        'deleted_share_version': {'required': True},
    }

    _attribute_map = {
        'deleted_share_name': {'key': 'deletedShareName', 'type': 'str'},
        'deleted_share_version': {'key': 'deletedShareVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedShare, self).__init__(**kwargs)
        self.deleted_share_name = kwargs['deleted_share_name']
        self.deleted_share_version = kwargs['deleted_share_version']


class DeleteRetentionPolicy(msrest.serialization.Model):
    """The service properties for soft delete.

    :param enabled: Indicates whether DeleteRetentionPolicy is enabled.
    :type enabled: bool
    :param days: Indicates the number of days that the deleted item should be retained. The minimum
     specified value can be 1 and the maximum value can be 365.
    :type days: int
    """

    _validation = {
        'days': {'maximum': 365, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeleteRetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.days = kwargs.get('days', None)


class Dimension(msrest.serialization.Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :param name: Display name of dimension.
    :type name: str
    :param display_name: Display name of dimension.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)


class Encryption(msrest.serialization.Model):
    """The encryption settings on the storage account.

    All required parameters must be populated in order to send to Azure.

    :param services: List of services which support encryption.
    :type services: ~azure.mgmt.storage.v2021_04_01.models.EncryptionServices
    :param key_source: Required. The encryption keySource (provider). Possible values
     (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault. Possible values include:
     "Microsoft.Storage", "Microsoft.Keyvault". Default value: "Microsoft.Storage".
    :type key_source: str or ~azure.mgmt.storage.v2021_04_01.models.KeySource
    :param require_infrastructure_encryption: A boolean indicating whether or not the service
     applies a secondary layer of encryption with platform managed keys for data at rest.
    :type require_infrastructure_encryption: bool
    :param key_vault_properties: Properties provided by key vault.
    :type key_vault_properties: ~azure.mgmt.storage.v2021_04_01.models.KeyVaultProperties
    :param encryption_identity: The identity to be used with service-side encryption at rest.
    :type encryption_identity: ~azure.mgmt.storage.v2021_04_01.models.EncryptionIdentity
    """

    _validation = {
        'key_source': {'required': True},
    }

    _attribute_map = {
        'services': {'key': 'services', 'type': 'EncryptionServices'},
        'key_source': {'key': 'keySource', 'type': 'str'},
        'require_infrastructure_encryption': {'key': 'requireInfrastructureEncryption', 'type': 'bool'},
        'key_vault_properties': {'key': 'keyvaultproperties', 'type': 'KeyVaultProperties'},
        'encryption_identity': {'key': 'identity', 'type': 'EncryptionIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Encryption, self).__init__(**kwargs)
        self.services = kwargs.get('services', None)
        self.key_source = kwargs.get('key_source', "Microsoft.Storage")
        self.require_infrastructure_encryption = kwargs.get('require_infrastructure_encryption', None)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)
        self.encryption_identity = kwargs.get('encryption_identity', None)


class EncryptionIdentity(msrest.serialization.Model):
    """Encryption identity for the storage account.

    :param encryption_user_assigned_identity: Resource identifier of the UserAssigned identity to
     be associated with server-side encryption on the storage account.
    :type encryption_user_assigned_identity: str
    """

    _attribute_map = {
        'encryption_user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionIdentity, self).__init__(**kwargs)
        self.encryption_user_assigned_identity = kwargs.get('encryption_user_assigned_identity', None)


class EncryptionScope(Resource):
    """The Encryption Scope resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param source: The provider for the encryption scope. Possible values (case-insensitive):
     Microsoft.Storage, Microsoft.KeyVault. Possible values include: "Microsoft.Storage",
     "Microsoft.KeyVault".
    :type source: str or ~azure.mgmt.storage.v2021_04_01.models.EncryptionScopeSource
    :param state: The state of the encryption scope. Possible values (case-insensitive):  Enabled,
     Disabled. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.storage.v2021_04_01.models.EncryptionScopeState
    :ivar creation_time: Gets the creation date and time of the encryption scope in UTC.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified_time: Gets the last modification date and time of the encryption scope in
     UTC.
    :vartype last_modified_time: ~datetime.datetime
    :param key_vault_properties: The key vault properties for the encryption scope. This is a
     required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
    :type key_vault_properties:
     ~azure.mgmt.storage.v2021_04_01.models.EncryptionScopeKeyVaultProperties
    :param require_infrastructure_encryption: A boolean indicating whether or not the service
     applies a secondary layer of encryption with platform managed keys for data at rest.
    :type require_infrastructure_encryption: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'EncryptionScopeKeyVaultProperties'},
        'require_infrastructure_encryption': {'key': 'properties.requireInfrastructureEncryption', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionScope, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.state = kwargs.get('state', None)
        self.creation_time = None
        self.last_modified_time = None
        self.key_vault_properties = kwargs.get('key_vault_properties', None)
        self.require_infrastructure_encryption = kwargs.get('require_infrastructure_encryption', None)


class EncryptionScopeKeyVaultProperties(msrest.serialization.Model):
    """The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param key_uri: The object identifier for a key vault key object. When applied, the encryption
     scope will use the key referenced by the identifier to enable customer-managed key support on
     this encryption scope.
    :type key_uri: str
    :ivar current_versioned_key_identifier: The object identifier of the current versioned Key
     Vault Key in use.
    :vartype current_versioned_key_identifier: str
    :ivar last_key_rotation_timestamp: Timestamp of last rotation of the Key Vault Key.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    """

    _validation = {
        'current_versioned_key_identifier': {'readonly': True},
        'last_key_rotation_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'key_uri': {'key': 'keyUri', 'type': 'str'},
        'current_versioned_key_identifier': {'key': 'currentVersionedKeyIdentifier', 'type': 'str'},
        'last_key_rotation_timestamp': {'key': 'lastKeyRotationTimestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionScopeKeyVaultProperties, self).__init__(**kwargs)
        self.key_uri = kwargs.get('key_uri', None)
        self.current_versioned_key_identifier = None
        self.last_key_rotation_timestamp = None


class EncryptionScopeListResult(msrest.serialization.Model):
    """List of encryption scopes requested, and if paging is required, a URL to the next page of encryption scopes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of encryption scopes requested.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.EncryptionScope]
    :ivar next_link: Request URL that can be used to query next page of encryption scopes. Returned
     when total number of requested encryption scopes exceeds the maximum page size.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EncryptionScope]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionScopeListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class EncryptionService(msrest.serialization.Model):
    """A service that allows server-side encryption to be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param enabled: A boolean indicating whether or not the service encrypts the data as it is
     stored.
    :type enabled: bool
    :ivar last_enabled_time: Gets a rough estimate of the date/time when the encryption was last
     enabled by the user. Only returned when encryption is enabled. There might be some unencrypted
     blobs which were written after this time, as it is just a rough estimate.
    :vartype last_enabled_time: ~datetime.datetime
    :param key_type: Encryption key type to be used for the encryption service. 'Account' key type
     implies that an account-scoped encryption key will be used. 'Service' key type implies that a
     default service key is used. Possible values include: "Service", "Account".
    :type key_type: str or ~azure.mgmt.storage.v2021_04_01.models.KeyType
    """

    _validation = {
        'last_enabled_time': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'last_enabled_time': {'key': 'lastEnabledTime', 'type': 'iso-8601'},
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionService, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.last_enabled_time = None
        self.key_type = kwargs.get('key_type', None)


class EncryptionServices(msrest.serialization.Model):
    """A list of services that support encryption.

    :param blob: The encryption function of the blob storage service.
    :type blob: ~azure.mgmt.storage.v2021_04_01.models.EncryptionService
    :param file: The encryption function of the file storage service.
    :type file: ~azure.mgmt.storage.v2021_04_01.models.EncryptionService
    :param table: The encryption function of the table storage service.
    :type table: ~azure.mgmt.storage.v2021_04_01.models.EncryptionService
    :param queue: The encryption function of the queue storage service.
    :type queue: ~azure.mgmt.storage.v2021_04_01.models.EncryptionService
    """

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'EncryptionService'},
        'file': {'key': 'file', 'type': 'EncryptionService'},
        'table': {'key': 'table', 'type': 'EncryptionService'},
        'queue': {'key': 'queue', 'type': 'EncryptionService'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionServices, self).__init__(**kwargs)
        self.blob = kwargs.get('blob', None)
        self.file = kwargs.get('file', None)
        self.table = kwargs.get('table', None)
        self.queue = kwargs.get('queue', None)


class Endpoints(msrest.serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    :param microsoft_endpoints: Gets the microsoft routing storage endpoints.
    :type microsoft_endpoints:
     ~azure.mgmt.storage.v2021_04_01.models.StorageAccountMicrosoftEndpoints
    :param internet_endpoints: Gets the internet routing storage endpoints.
    :type internet_endpoints:
     ~azure.mgmt.storage.v2021_04_01.models.StorageAccountInternetEndpoints
    """

    _validation = {
        'blob': {'readonly': True},
        'queue': {'readonly': True},
        'table': {'readonly': True},
        'file': {'readonly': True},
        'web': {'readonly': True},
        'dfs': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'str'},
        'queue': {'key': 'queue', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'web': {'key': 'web', 'type': 'str'},
        'dfs': {'key': 'dfs', 'type': 'str'},
        'microsoft_endpoints': {'key': 'microsoftEndpoints', 'type': 'StorageAccountMicrosoftEndpoints'},
        'internet_endpoints': {'key': 'internetEndpoints', 'type': 'StorageAccountInternetEndpoints'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Endpoints, self).__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None
        self.web = None
        self.dfs = None
        self.microsoft_endpoints = kwargs.get('microsoft_endpoints', None)
        self.internet_endpoints = kwargs.get('internet_endpoints', None)


class ErrorResponse(msrest.serialization.Model):
    """An error response from the storage resource provider.

    :param error: Azure Storage Resource Provider error response body.
    :type error: ~azure.mgmt.storage.v2021_04_01.models.ErrorResponseBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseBody(msrest.serialization.Model):
    """Error response body contract.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ExtendedLocation(msrest.serialization.Model):
    """The complex type of the extended location.

    :param name: The name of the extended location.
    :type name: str
    :param type: The type of the extended location. Possible values include: "EdgeZone".
    :type type: str or ~azure.mgmt.storage.v2021_04_01.models.ExtendedLocationTypes
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class FileServiceItems(msrest.serialization.Model):
    """FileServiceItems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of file services returned.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.FileServiceProperties]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FileServiceProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileServiceItems, self).__init__(**kwargs)
        self.value = None


class FileServiceProperties(Resource):
    """The properties of File services in storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar sku: Sku name and tier.
    :vartype sku: ~azure.mgmt.storage.v2021_04_01.models.Sku
    :param cors: Specifies CORS rules for the File service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the File service.
    :type cors: ~azure.mgmt.storage.v2021_04_01.models.CorsRules
    :param share_delete_retention_policy: The file service properties for share soft delete.
    :type share_delete_retention_policy:
     ~azure.mgmt.storage.v2021_04_01.models.DeleteRetentionPolicy
    :param protocol_settings: Protocol settings for file service.
    :type protocol_settings: ~azure.mgmt.storage.v2021_04_01.models.ProtocolSettings
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'cors': {'key': 'properties.cors', 'type': 'CorsRules'},
        'share_delete_retention_policy': {'key': 'properties.shareDeleteRetentionPolicy', 'type': 'DeleteRetentionPolicy'},
        'protocol_settings': {'key': 'properties.protocolSettings', 'type': 'ProtocolSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileServiceProperties, self).__init__(**kwargs)
        self.sku = None
        self.cors = kwargs.get('cors', None)
        self.share_delete_retention_policy = kwargs.get('share_delete_retention_policy', None)
        self.protocol_settings = kwargs.get('protocol_settings', None)


class FileShare(AzureEntityResource):
    """Properties of the file share, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar last_modified_time: Returns the date and time the share was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :param metadata: A name-value pair to associate with the share as metadata.
    :type metadata: dict[str, str]
    :param share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
     less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
    :type share_quota: int
    :param enabled_protocols: The authentication protocol that is used for the file share. Can only
     be specified when creating a share. Possible values include: "SMB", "NFS".
    :type enabled_protocols: str or ~azure.mgmt.storage.v2021_04_01.models.EnabledProtocols
    :param root_squash: The property is for NFS share only. The default is NoRootSquash. Possible
     values include: "NoRootSquash", "RootSquash", "AllSquash".
    :type root_squash: str or ~azure.mgmt.storage.v2021_04_01.models.RootSquashType
    :ivar version: The version of the share.
    :vartype version: str
    :ivar deleted: Indicates whether the share was deleted.
    :vartype deleted: bool
    :ivar deleted_time: The deleted time if the share was deleted.
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days: Remaining retention days for share that was soft deleted.
    :vartype remaining_retention_days: int
    :param access_tier: Access tier for specific share. GpV2 account can choose between
     TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. Possible
     values include: "TransactionOptimized", "Hot", "Cool", "Premium".
    :type access_tier: str or ~azure.mgmt.storage.v2021_04_01.models.ShareAccessTier
    :ivar access_tier_change_time: Indicates the last modification time for share access tier.
    :vartype access_tier_change_time: ~datetime.datetime
    :ivar access_tier_status: Indicates if there is a pending transition for access tier.
    :vartype access_tier_status: str
    :ivar share_usage_bytes: The approximate size of the data stored on the share. Note that this
     value may not include all recently created or recently resized files.
    :vartype share_usage_bytes: long
    :ivar lease_status: The lease status of the share. Possible values include: "Locked",
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseStatus
    :ivar lease_state: Lease state of the share. Possible values include: "Available", "Leased",
     "Expired", "Breaking", "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a share is of infinite or fixed duration,
     only when the share is leased. Possible values include: "Infinite", "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseDuration
    :param signed_identifiers: List of stored access policies specified on the share.
    :type signed_identifiers: list[~azure.mgmt.storage.v2021_04_01.models.SignedIdentifier]
    :ivar snapshot_time: Creation time of share snapshot returned in the response of list shares
     with expand param "snapshots".
    :vartype snapshot_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'share_quota': {'maximum': 102400, 'minimum': 1},
        'version': {'readonly': True},
        'deleted': {'readonly': True},
        'deleted_time': {'readonly': True},
        'remaining_retention_days': {'readonly': True},
        'access_tier_change_time': {'readonly': True},
        'access_tier_status': {'readonly': True},
        'share_usage_bytes': {'readonly': True},
        'lease_status': {'readonly': True},
        'lease_state': {'readonly': True},
        'lease_duration': {'readonly': True},
        'snapshot_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'share_quota': {'key': 'properties.shareQuota', 'type': 'int'},
        'enabled_protocols': {'key': 'properties.enabledProtocols', 'type': 'str'},
        'root_squash': {'key': 'properties.rootSquash', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'deleted': {'key': 'properties.deleted', 'type': 'bool'},
        'deleted_time': {'key': 'properties.deletedTime', 'type': 'iso-8601'},
        'remaining_retention_days': {'key': 'properties.remainingRetentionDays', 'type': 'int'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'access_tier_change_time': {'key': 'properties.accessTierChangeTime', 'type': 'iso-8601'},
        'access_tier_status': {'key': 'properties.accessTierStatus', 'type': 'str'},
        'share_usage_bytes': {'key': 'properties.shareUsageBytes', 'type': 'long'},
        'lease_status': {'key': 'properties.leaseStatus', 'type': 'str'},
        'lease_state': {'key': 'properties.leaseState', 'type': 'str'},
        'lease_duration': {'key': 'properties.leaseDuration', 'type': 'str'},
        'signed_identifiers': {'key': 'properties.signedIdentifiers', 'type': '[SignedIdentifier]'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileShare, self).__init__(**kwargs)
        self.last_modified_time = None
        self.metadata = kwargs.get('metadata', None)
        self.share_quota = kwargs.get('share_quota', None)
        self.enabled_protocols = kwargs.get('enabled_protocols', None)
        self.root_squash = kwargs.get('root_squash', None)
        self.version = None
        self.deleted = None
        self.deleted_time = None
        self.remaining_retention_days = None
        self.access_tier = kwargs.get('access_tier', None)
        self.access_tier_change_time = None
        self.access_tier_status = None
        self.share_usage_bytes = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.signed_identifiers = kwargs.get('signed_identifiers', None)
        self.snapshot_time = None


class FileShareItem(AzureEntityResource):
    """The file share properties be listed out.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar last_modified_time: Returns the date and time the share was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :param metadata: A name-value pair to associate with the share as metadata.
    :type metadata: dict[str, str]
    :param share_quota: The maximum size of the share, in gigabytes. Must be greater than 0, and
     less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
    :type share_quota: int
    :param enabled_protocols: The authentication protocol that is used for the file share. Can only
     be specified when creating a share. Possible values include: "SMB", "NFS".
    :type enabled_protocols: str or ~azure.mgmt.storage.v2021_04_01.models.EnabledProtocols
    :param root_squash: The property is for NFS share only. The default is NoRootSquash. Possible
     values include: "NoRootSquash", "RootSquash", "AllSquash".
    :type root_squash: str or ~azure.mgmt.storage.v2021_04_01.models.RootSquashType
    :ivar version: The version of the share.
    :vartype version: str
    :ivar deleted: Indicates whether the share was deleted.
    :vartype deleted: bool
    :ivar deleted_time: The deleted time if the share was deleted.
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days: Remaining retention days for share that was soft deleted.
    :vartype remaining_retention_days: int
    :param access_tier: Access tier for specific share. GpV2 account can choose between
     TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. Possible
     values include: "TransactionOptimized", "Hot", "Cool", "Premium".
    :type access_tier: str or ~azure.mgmt.storage.v2021_04_01.models.ShareAccessTier
    :ivar access_tier_change_time: Indicates the last modification time for share access tier.
    :vartype access_tier_change_time: ~datetime.datetime
    :ivar access_tier_status: Indicates if there is a pending transition for access tier.
    :vartype access_tier_status: str
    :ivar share_usage_bytes: The approximate size of the data stored on the share. Note that this
     value may not include all recently created or recently resized files.
    :vartype share_usage_bytes: long
    :ivar lease_status: The lease status of the share. Possible values include: "Locked",
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseStatus
    :ivar lease_state: Lease state of the share. Possible values include: "Available", "Leased",
     "Expired", "Breaking", "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a share is of infinite or fixed duration,
     only when the share is leased. Possible values include: "Infinite", "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseDuration
    :param signed_identifiers: List of stored access policies specified on the share.
    :type signed_identifiers: list[~azure.mgmt.storage.v2021_04_01.models.SignedIdentifier]
    :ivar snapshot_time: Creation time of share snapshot returned in the response of list shares
     with expand param "snapshots".
    :vartype snapshot_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'share_quota': {'maximum': 102400, 'minimum': 1},
        'version': {'readonly': True},
        'deleted': {'readonly': True},
        'deleted_time': {'readonly': True},
        'remaining_retention_days': {'readonly': True},
        'access_tier_change_time': {'readonly': True},
        'access_tier_status': {'readonly': True},
        'share_usage_bytes': {'readonly': True},
        'lease_status': {'readonly': True},
        'lease_state': {'readonly': True},
        'lease_duration': {'readonly': True},
        'snapshot_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'share_quota': {'key': 'properties.shareQuota', 'type': 'int'},
        'enabled_protocols': {'key': 'properties.enabledProtocols', 'type': 'str'},
        'root_squash': {'key': 'properties.rootSquash', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'deleted': {'key': 'properties.deleted', 'type': 'bool'},
        'deleted_time': {'key': 'properties.deletedTime', 'type': 'iso-8601'},
        'remaining_retention_days': {'key': 'properties.remainingRetentionDays', 'type': 'int'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'access_tier_change_time': {'key': 'properties.accessTierChangeTime', 'type': 'iso-8601'},
        'access_tier_status': {'key': 'properties.accessTierStatus', 'type': 'str'},
        'share_usage_bytes': {'key': 'properties.shareUsageBytes', 'type': 'long'},
        'lease_status': {'key': 'properties.leaseStatus', 'type': 'str'},
        'lease_state': {'key': 'properties.leaseState', 'type': 'str'},
        'lease_duration': {'key': 'properties.leaseDuration', 'type': 'str'},
        'signed_identifiers': {'key': 'properties.signedIdentifiers', 'type': '[SignedIdentifier]'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileShareItem, self).__init__(**kwargs)
        self.last_modified_time = None
        self.metadata = kwargs.get('metadata', None)
        self.share_quota = kwargs.get('share_quota', None)
        self.enabled_protocols = kwargs.get('enabled_protocols', None)
        self.root_squash = kwargs.get('root_squash', None)
        self.version = None
        self.deleted = None
        self.deleted_time = None
        self.remaining_retention_days = None
        self.access_tier = kwargs.get('access_tier', None)
        self.access_tier_change_time = None
        self.access_tier_status = None
        self.share_usage_bytes = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.signed_identifiers = kwargs.get('signed_identifiers', None)
        self.snapshot_time = None


class FileShareItems(msrest.serialization.Model):
    """Response schema. Contains list of shares returned, and if paging is requested or required, a URL to next page of shares.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of file shares returned.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.FileShareItem]
    :ivar next_link: Request URL that can be used to query next page of shares. Returned when total
     number of requested shares exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FileShareItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileShareItems, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GeoReplicationStats(msrest.serialization.Model):
    """Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the secondary location. Possible values are: - Live: Indicates that
     the secondary location is active and operational. - Bootstrap: Indicates initial
     synchronization from the primary location to the secondary location is in progress.This
     typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary
     location is temporarily unavailable. Possible values include: "Live", "Bootstrap",
     "Unavailable".
    :vartype status: str or ~azure.mgmt.storage.v2021_04_01.models.GeoReplicationStatus
    :ivar last_sync_time: All primary writes preceding this UTC date/time value are guaranteed to
     be available for read operations. Primary writes following this point in time may or may not be
     available for reads. Element may be default value if value of LastSyncTime is not available,
     this can happen if secondary is offline or we are in bootstrap.
    :vartype last_sync_time: ~datetime.datetime
    :ivar can_failover: A boolean flag which indicates whether or not account failover is supported
     for the account.
    :vartype can_failover: bool
    """

    _validation = {
        'status': {'readonly': True},
        'last_sync_time': {'readonly': True},
        'can_failover': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'last_sync_time': {'key': 'lastSyncTime', 'type': 'iso-8601'},
        'can_failover': {'key': 'canFailover', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GeoReplicationStats, self).__init__(**kwargs)
        self.status = None
        self.last_sync_time = None
        self.can_failover = None


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: Required. The identity type. Possible values include: "None", "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned".
    :type type: str or ~azure.mgmt.storage.v2021_04_01.models.IdentityType
    :param user_assigned_identities: Gets or sets a list of key value pairs that describe the set
     of User Assigned identities that will be used with this storage account. The key is the ARM
     resource identifier of the identity. Only 1 User Assigned identity is permitted here.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.storage.v2021_04_01.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs['type']
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ImmutabilityPolicy(AzureEntityResource):
    """The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :type immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible values include: Locked
     and Unlocked. Possible values include: "Locked", "Unlocked".
    :vartype state: str or ~azure.mgmt.storage.v2021_04_01.models.ImmutabilityPolicyState
    :param allow_protected_append_writes: This property can only be changed for unlocked time-based
     retention policies. When enabled, new blocks can be written to an append blob while maintaining
     immutability protection and compliance. Only new blocks can be added and any existing blocks
     cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
     API.
    :type allow_protected_append_writes: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'immutability_period_since_creation_in_days': {'key': 'properties.immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'allow_protected_append_writes': {'key': 'properties.allowProtectedAppendWrites', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImmutabilityPolicy, self).__init__(**kwargs)
        self.immutability_period_since_creation_in_days = kwargs.get('immutability_period_since_creation_in_days', None)
        self.state = None
        self.allow_protected_append_writes = kwargs.get('allow_protected_append_writes', None)


class ImmutabilityPolicyProperties(msrest.serialization.Model):
    """The properties of an ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar etag: ImmutabilityPolicy Etag.
    :vartype etag: str
    :ivar update_history: The ImmutabilityPolicy update history of the blob container.
    :vartype update_history: list[~azure.mgmt.storage.v2021_04_01.models.UpdateHistoryProperty]
    :param immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :type immutability_period_since_creation_in_days: int
    :ivar state: The ImmutabilityPolicy state of a blob container, possible values include: Locked
     and Unlocked. Possible values include: "Locked", "Unlocked".
    :vartype state: str or ~azure.mgmt.storage.v2021_04_01.models.ImmutabilityPolicyState
    :param allow_protected_append_writes: This property can only be changed for unlocked time-based
     retention policies. When enabled, new blocks can be written to an append blob while maintaining
     immutability protection and compliance. Only new blocks can be added and any existing blocks
     cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
     API.
    :type allow_protected_append_writes: bool
    """

    _validation = {
        'etag': {'readonly': True},
        'update_history': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'str'},
        'update_history': {'key': 'updateHistory', 'type': '[UpdateHistoryProperty]'},
        'immutability_period_since_creation_in_days': {'key': 'properties.immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'allow_protected_append_writes': {'key': 'properties.allowProtectedAppendWrites', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImmutabilityPolicyProperties, self).__init__(**kwargs)
        self.etag = None
        self.update_history = None
        self.immutability_period_since_creation_in_days = kwargs.get('immutability_period_since_creation_in_days', None)
        self.state = None
        self.allow_protected_append_writes = kwargs.get('allow_protected_append_writes', None)


class ImmutableStorageWithVersioning(msrest.serialization.Model):
    """Object level immutability properties of the container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param enabled: This is an immutable property, when set to true it enables object level
     immutability at the container level.
    :type enabled: bool
    :ivar time_stamp: Returns the date and time the object level immutability was enabled.
    :vartype time_stamp: ~datetime.datetime
    :ivar migration_state: This property denotes the container level immutability to object level
     immutability migration state. Possible values include: "InProgress", "Completed".
    :vartype migration_state: str or ~azure.mgmt.storage.v2021_04_01.models.MigrationState
    """

    _validation = {
        'time_stamp': {'readonly': True},
        'migration_state': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'migration_state': {'key': 'migrationState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImmutableStorageWithVersioning, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.time_stamp = None
        self.migration_state = None


class IPRule(msrest.serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
     address is allowed.
    :type ip_address_or_range: str
    :ivar action: The action of IP ACL rule. Default value: "Allow".
    :vartype action: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
        'action': {'constant': True},
    }

    _attribute_map = {
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    action = "Allow"

    def __init__(
        self,
        **kwargs
    ):
        super(IPRule, self).__init__(**kwargs)
        self.ip_address_or_range = kwargs['ip_address_or_range']


class KeyCreationTime(msrest.serialization.Model):
    """Storage account keys creation time.

    :param key1:
    :type key1: ~datetime.datetime
    :param key2:
    :type key2: ~datetime.datetime
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'iso-8601'},
        'key2': {'key': 'key2', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyCreationTime, self).__init__(**kwargs)
        self.key1 = kwargs.get('key1', None)
        self.key2 = kwargs.get('key2', None)


class KeyPolicy(msrest.serialization.Model):
    """KeyPolicy assigned to the storage account.

    All required parameters must be populated in order to send to Azure.

    :param key_expiration_period_in_days: Required. The key expiration period in days.
    :type key_expiration_period_in_days: int
    """

    _validation = {
        'key_expiration_period_in_days': {'required': True},
    }

    _attribute_map = {
        'key_expiration_period_in_days': {'key': 'keyExpirationPeriodInDays', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyPolicy, self).__init__(**kwargs)
        self.key_expiration_period_in_days = kwargs['key_expiration_period_in_days']


class KeyVaultProperties(msrest.serialization.Model):
    """Properties of key vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param key_name: The name of KeyVault key.
    :type key_name: str
    :param key_version: The version of KeyVault key.
    :type key_version: str
    :param key_vault_uri: The Uri of KeyVault.
    :type key_vault_uri: str
    :ivar current_versioned_key_identifier: The object identifier of the current versioned Key
     Vault Key in use.
    :vartype current_versioned_key_identifier: str
    :ivar last_key_rotation_timestamp: Timestamp of last rotation of the Key Vault Key.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    """

    _validation = {
        'current_versioned_key_identifier': {'readonly': True},
        'last_key_rotation_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyname', 'type': 'str'},
        'key_version': {'key': 'keyversion', 'type': 'str'},
        'key_vault_uri': {'key': 'keyvaulturi', 'type': 'str'},
        'current_versioned_key_identifier': {'key': 'currentVersionedKeyIdentifier', 'type': 'str'},
        'last_key_rotation_timestamp': {'key': 'lastKeyRotationTimestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)
        self.key_vault_uri = kwargs.get('key_vault_uri', None)
        self.current_versioned_key_identifier = None
        self.last_key_rotation_timestamp = None


class LastAccessTimeTrackingPolicy(msrest.serialization.Model):
    """The blob service properties for Last access time based tracking policy.

    All required parameters must be populated in order to send to Azure.

    :param enable: Required. When set to true last access time based tracking is enabled.
    :type enable: bool
    :param name: Name of the policy. The valid value is AccessTimeTracking. This field is currently
     read only. Possible values include: "AccessTimeTracking".
    :type name: str or ~azure.mgmt.storage.v2021_04_01.models.Name
    :param tracking_granularity_in_days: The field specifies blob object tracking granularity in
     days, typically how often the blob object should be tracked.This field is currently read only
     with value as 1.
    :type tracking_granularity_in_days: int
    :param blob_type: An array of predefined supported blob types. Only blockBlob is the supported
     value. This field is currently read only.
    :type blob_type: list[str]
    """

    _validation = {
        'enable': {'required': True},
    }

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'tracking_granularity_in_days': {'key': 'trackingGranularityInDays', 'type': 'int'},
        'blob_type': {'key': 'blobType', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LastAccessTimeTrackingPolicy, self).__init__(**kwargs)
        self.enable = kwargs['enable']
        self.name = kwargs.get('name', None)
        self.tracking_granularity_in_days = kwargs.get('tracking_granularity_in_days', None)
        self.blob_type = kwargs.get('blob_type', None)


class LeaseContainerRequest(msrest.serialization.Model):
    """Lease Container request schema.

    All required parameters must be populated in order to send to Azure.

    :param action: Required. Specifies the lease action. Can be one of the available actions.
     Possible values include: "Acquire", "Renew", "Change", "Release", "Break".
    :type action: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseContainerRequestAction
    :param lease_id: Identifies the lease. Can be specified in any valid GUID string format.
    :type lease_id: str
    :param break_period: Optional. For a break action, proposed duration the lease should continue
     before it is broken, in seconds, between 0 and 60.
    :type break_period: int
    :param lease_duration: Required for acquire. Specifies the duration of the lease, in seconds,
     or negative one (-1) for a lease that never expires.
    :type lease_duration: int
    :param proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
     GUID string format.
    :type proposed_lease_id: str
    """

    _validation = {
        'action': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'lease_id': {'key': 'leaseId', 'type': 'str'},
        'break_period': {'key': 'breakPeriod', 'type': 'int'},
        'lease_duration': {'key': 'leaseDuration', 'type': 'int'},
        'proposed_lease_id': {'key': 'proposedLeaseId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LeaseContainerRequest, self).__init__(**kwargs)
        self.action = kwargs['action']
        self.lease_id = kwargs.get('lease_id', None)
        self.break_period = kwargs.get('break_period', None)
        self.lease_duration = kwargs.get('lease_duration', None)
        self.proposed_lease_id = kwargs.get('proposed_lease_id', None)


class LeaseContainerResponse(msrest.serialization.Model):
    """Lease Container response schema.

    :param lease_id: Returned unique lease ID that must be included with any request to delete the
     container, or to renew, change, or release the lease.
    :type lease_id: str
    :param lease_time_seconds: Approximate time remaining in the lease period, in seconds.
    :type lease_time_seconds: str
    """

    _attribute_map = {
        'lease_id': {'key': 'leaseId', 'type': 'str'},
        'lease_time_seconds': {'key': 'leaseTimeSeconds', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LeaseContainerResponse, self).__init__(**kwargs)
        self.lease_id = kwargs.get('lease_id', None)
        self.lease_time_seconds = kwargs.get('lease_time_seconds', None)


class LeaseShareRequest(msrest.serialization.Model):
    """Lease Share request schema.

    All required parameters must be populated in order to send to Azure.

    :param action: Required. Specifies the lease action. Can be one of the available actions.
     Possible values include: "Acquire", "Renew", "Change", "Release", "Break".
    :type action: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseShareAction
    :param lease_id: Identifies the lease. Can be specified in any valid GUID string format.
    :type lease_id: str
    :param break_period: Optional. For a break action, proposed duration the lease should continue
     before it is broken, in seconds, between 0 and 60.
    :type break_period: int
    :param lease_duration: Required for acquire. Specifies the duration of the lease, in seconds,
     or negative one (-1) for a lease that never expires.
    :type lease_duration: int
    :param proposed_lease_id: Optional for acquire, required for change. Proposed lease ID, in a
     GUID string format.
    :type proposed_lease_id: str
    """

    _validation = {
        'action': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'lease_id': {'key': 'leaseId', 'type': 'str'},
        'break_period': {'key': 'breakPeriod', 'type': 'int'},
        'lease_duration': {'key': 'leaseDuration', 'type': 'int'},
        'proposed_lease_id': {'key': 'proposedLeaseId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LeaseShareRequest, self).__init__(**kwargs)
        self.action = kwargs['action']
        self.lease_id = kwargs.get('lease_id', None)
        self.break_period = kwargs.get('break_period', None)
        self.lease_duration = kwargs.get('lease_duration', None)
        self.proposed_lease_id = kwargs.get('proposed_lease_id', None)


class LeaseShareResponse(msrest.serialization.Model):
    """Lease Share response schema.

    :param lease_id: Returned unique lease ID that must be included with any request to delete the
     share, or to renew, change, or release the lease.
    :type lease_id: str
    :param lease_time_seconds: Approximate time remaining in the lease period, in seconds.
    :type lease_time_seconds: str
    """

    _attribute_map = {
        'lease_id': {'key': 'leaseId', 'type': 'str'},
        'lease_time_seconds': {'key': 'leaseTimeSeconds', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LeaseShareResponse, self).__init__(**kwargs)
        self.lease_id = kwargs.get('lease_id', None)
        self.lease_time_seconds = kwargs.get('lease_time_seconds', None)


class LegalHold(msrest.serialization.Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :param tags: Required. A set of tags. Each tag should be 3 to 23 alphanumeric characters and is
     normalized to lower case at SRP.
    :type tags: list[str]
    """

    _validation = {
        'has_legal_hold': {'readonly': True},
        'tags': {'required': True},
    }

    _attribute_map = {
        'has_legal_hold': {'key': 'hasLegalHold', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LegalHold, self).__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = kwargs['tags']


class LegalHoldProperties(msrest.serialization.Model):
    """The LegalHold property of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :param tags: A set of tags. The list of LegalHold tags of a blob container.
    :type tags: list[~azure.mgmt.storage.v2021_04_01.models.TagProperty]
    """

    _validation = {
        'has_legal_hold': {'readonly': True},
    }

    _attribute_map = {
        'has_legal_hold': {'key': 'hasLegalHold', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '[TagProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LegalHoldProperties, self).__init__(**kwargs)
        self.has_legal_hold = None
        self.tags = kwargs.get('tags', None)


class ListAccountSasResponse(msrest.serialization.Model):
    """The List SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_sas_token: List SAS credentials of storage account.
    :vartype account_sas_token: str
    """

    _validation = {
        'account_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'account_sas_token': {'key': 'accountSasToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListAccountSasResponse, self).__init__(**kwargs)
        self.account_sas_token = None


class ListBlobInventoryPolicy(msrest.serialization.Model):
    """List of blob inventory policies returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of blob inventory policies.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.BlobInventoryPolicy]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BlobInventoryPolicy]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListBlobInventoryPolicy, self).__init__(**kwargs)
        self.value = None


class ListContainerItem(AzureEntityResource):
    """The blob container properties be listed out.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar version: The version of the deleted blob container.
    :vartype version: str
    :ivar deleted: Indicates whether the blob container was deleted.
    :vartype deleted: bool
    :ivar deleted_time: Blob container deletion time.
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days: Remaining retention days for soft deleted blob container.
    :vartype remaining_retention_days: int
    :param default_encryption_scope: Default the container to use specified encryption scope for
     all writes.
    :type default_encryption_scope: str
    :param deny_encryption_scope_override: Block override of encryption scope from the container
     default.
    :type deny_encryption_scope_override: bool
    :param public_access: Specifies whether data in the container may be accessed publicly and the
     level of access. Possible values include: "Container", "Blob", "None".
    :type public_access: str or ~azure.mgmt.storage.v2021_04_01.models.PublicAccess
    :ivar last_modified_time: Returns the date and time the container was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :ivar lease_status: The lease status of the container. Possible values include: "Locked",
     "Unlocked".
    :vartype lease_status: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseStatus
    :ivar lease_state: Lease state of the container. Possible values include: "Available",
     "Leased", "Expired", "Breaking", "Broken".
    :vartype lease_state: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseState
    :ivar lease_duration: Specifies whether the lease on a container is of infinite or fixed
     duration, only when the container is leased. Possible values include: "Infinite", "Fixed".
    :vartype lease_duration: str or ~azure.mgmt.storage.v2021_04_01.models.LeaseDuration
    :param metadata: A name-value pair to associate with the container as metadata.
    :type metadata: dict[str, str]
    :ivar immutability_policy: The ImmutabilityPolicy property of the container.
    :vartype immutability_policy:
     ~azure.mgmt.storage.v2021_04_01.models.ImmutabilityPolicyProperties
    :ivar legal_hold: The LegalHold property of the container.
    :vartype legal_hold: ~azure.mgmt.storage.v2021_04_01.models.LegalHoldProperties
    :ivar has_legal_hold: The hasLegalHold public property is set to true by SRP if there are at
     least one existing tag. The hasLegalHold public property is set to false by SRP if all existing
     legal hold tags are cleared out. There can be a maximum of 1000 blob containers with
     hasLegalHold=true for a given account.
    :vartype has_legal_hold: bool
    :ivar has_immutability_policy: The hasImmutabilityPolicy public property is set to true by SRP
     if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public
     property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
    :vartype has_immutability_policy: bool
    :param immutable_storage_with_versioning: The object level immutability property of the
     container. The property is immutable and can only be set to true at the container creation
     time. Existing containers must undergo a migration process.
    :type immutable_storage_with_versioning:
     ~azure.mgmt.storage.v2021_04_01.models.ImmutableStorageWithVersioning
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'version': {'readonly': True},
        'deleted': {'readonly': True},
        'deleted_time': {'readonly': True},
        'remaining_retention_days': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'lease_status': {'readonly': True},
        'lease_state': {'readonly': True},
        'lease_duration': {'readonly': True},
        'immutability_policy': {'readonly': True},
        'legal_hold': {'readonly': True},
        'has_legal_hold': {'readonly': True},
        'has_immutability_policy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'deleted': {'key': 'properties.deleted', 'type': 'bool'},
        'deleted_time': {'key': 'properties.deletedTime', 'type': 'iso-8601'},
        'remaining_retention_days': {'key': 'properties.remainingRetentionDays', 'type': 'int'},
        'default_encryption_scope': {'key': 'properties.defaultEncryptionScope', 'type': 'str'},
        'deny_encryption_scope_override': {'key': 'properties.denyEncryptionScopeOverride', 'type': 'bool'},
        'public_access': {'key': 'properties.publicAccess', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'lease_status': {'key': 'properties.leaseStatus', 'type': 'str'},
        'lease_state': {'key': 'properties.leaseState', 'type': 'str'},
        'lease_duration': {'key': 'properties.leaseDuration', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'immutability_policy': {'key': 'properties.immutabilityPolicy', 'type': 'ImmutabilityPolicyProperties'},
        'legal_hold': {'key': 'properties.legalHold', 'type': 'LegalHoldProperties'},
        'has_legal_hold': {'key': 'properties.hasLegalHold', 'type': 'bool'},
        'has_immutability_policy': {'key': 'properties.hasImmutabilityPolicy', 'type': 'bool'},
        'immutable_storage_with_versioning': {'key': 'properties.immutableStorageWithVersioning', 'type': 'ImmutableStorageWithVersioning'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListContainerItem, self).__init__(**kwargs)
        self.version = None
        self.deleted = None
        self.deleted_time = None
        self.remaining_retention_days = None
        self.default_encryption_scope = kwargs.get('default_encryption_scope', None)
        self.deny_encryption_scope_override = kwargs.get('deny_encryption_scope_override', None)
        self.public_access = kwargs.get('public_access', None)
        self.last_modified_time = None
        self.lease_status = None
        self.lease_state = None
        self.lease_duration = None
        self.metadata = kwargs.get('metadata', None)
        self.immutability_policy = None
        self.legal_hold = None
        self.has_legal_hold = None
        self.has_immutability_policy = None
        self.immutable_storage_with_versioning = kwargs.get('immutable_storage_with_versioning', None)


class ListContainerItems(msrest.serialization.Model):
    """Response schema. Contains list of blobs returned, and if paging is requested or required, a URL to next page of containers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of blobs containers returned.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.ListContainerItem]
    :ivar next_link: Request URL that can be used to query next page of containers. Returned when
     total number of requested containers exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ListContainerItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListContainerItems, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListQueue(Resource):
    """ListQueue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param metadata: A name-value pair that represents queue metadata.
    :type metadata: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListQueue, self).__init__(**kwargs)
        self.metadata = kwargs.get('metadata', None)


class ListQueueResource(msrest.serialization.Model):
    """Response schema. Contains list of queues returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of queues returned.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.ListQueue]
    :ivar next_link: Request URL that can be used to list next page of queues.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ListQueue]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListQueueResource, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListQueueServices(msrest.serialization.Model):
    """ListQueueServices.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of queue services returned.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.QueueServiceProperties]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QueueServiceProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListQueueServices, self).__init__(**kwargs)
        self.value = None


class ListServiceSasResponse(msrest.serialization.Model):
    """The List service SAS credentials operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_sas_token: List service SAS credentials of specific resource.
    :vartype service_sas_token: str
    """

    _validation = {
        'service_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'service_sas_token': {'key': 'serviceSasToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListServiceSasResponse, self).__init__(**kwargs)
        self.service_sas_token = None


class ListTableResource(msrest.serialization.Model):
    """Response schema. Contains list of tables returned.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of tables returned.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.Table]
    :ivar next_link: Request URL that can be used to query next page of tables.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Table]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListTableResource, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListTableServices(msrest.serialization.Model):
    """ListTableServices.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of table services returned.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.TableServiceProperties]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TableServiceProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListTableServices, self).__init__(**kwargs)
        self.value = None


class ManagementPolicy(Resource):
    """The Get Storage Account ManagementPolicies operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar last_modified_time: Returns the date and time the ManagementPolicies was last modified.
    :vartype last_modified_time: ~datetime.datetime
    :param policy: The Storage Account ManagementPolicy, in JSON format. See more details in:
     https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :type policy: ~azure.mgmt.storage.v2021_04_01.models.ManagementPolicySchema
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'policy': {'key': 'properties.policy', 'type': 'ManagementPolicySchema'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicy, self).__init__(**kwargs)
        self.last_modified_time = None
        self.policy = kwargs.get('policy', None)


class ManagementPolicyAction(msrest.serialization.Model):
    """Actions are applied to the filtered blobs when the execution condition is met.

    :param base_blob: The management policy action for base blob.
    :type base_blob: ~azure.mgmt.storage.v2021_04_01.models.ManagementPolicyBaseBlob
    :param snapshot: The management policy action for snapshot.
    :type snapshot: ~azure.mgmt.storage.v2021_04_01.models.ManagementPolicySnapShot
    :param version: The management policy action for version.
    :type version: ~azure.mgmt.storage.v2021_04_01.models.ManagementPolicyVersion
    """

    _attribute_map = {
        'base_blob': {'key': 'baseBlob', 'type': 'ManagementPolicyBaseBlob'},
        'snapshot': {'key': 'snapshot', 'type': 'ManagementPolicySnapShot'},
        'version': {'key': 'version', 'type': 'ManagementPolicyVersion'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicyAction, self).__init__(**kwargs)
        self.base_blob = kwargs.get('base_blob', None)
        self.snapshot = kwargs.get('snapshot', None)
        self.version = kwargs.get('version', None)


class ManagementPolicyBaseBlob(msrest.serialization.Model):
    """Management policy action for base blob.

    :param tier_to_cool: The function to tier blobs to cool storage. Support blobs currently at Hot
     tier.
    :type tier_to_cool: ~azure.mgmt.storage.v2021_04_01.models.DateAfterModification
    :param tier_to_archive: The function to tier blobs to archive storage. Support blobs currently
     at Hot or Cool tier.
    :type tier_to_archive: ~azure.mgmt.storage.v2021_04_01.models.DateAfterModification
    :param delete: The function to delete the blob.
    :type delete: ~azure.mgmt.storage.v2021_04_01.models.DateAfterModification
    :param enable_auto_tier_to_hot_from_cool: This property enables auto tiering of a blob from
     cool to hot on a blob access. This property requires
     tierToCool.daysAfterLastAccessTimeGreaterThan.
    :type enable_auto_tier_to_hot_from_cool: bool
    """

    _attribute_map = {
        'tier_to_cool': {'key': 'tierToCool', 'type': 'DateAfterModification'},
        'tier_to_archive': {'key': 'tierToArchive', 'type': 'DateAfterModification'},
        'delete': {'key': 'delete', 'type': 'DateAfterModification'},
        'enable_auto_tier_to_hot_from_cool': {'key': 'enableAutoTierToHotFromCool', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicyBaseBlob, self).__init__(**kwargs)
        self.tier_to_cool = kwargs.get('tier_to_cool', None)
        self.tier_to_archive = kwargs.get('tier_to_archive', None)
        self.delete = kwargs.get('delete', None)
        self.enable_auto_tier_to_hot_from_cool = kwargs.get('enable_auto_tier_to_hot_from_cool', None)


class ManagementPolicyDefinition(msrest.serialization.Model):
    """An object that defines the Lifecycle rule. Each definition is made up with a filters set and an actions set.

    All required parameters must be populated in order to send to Azure.

    :param actions: Required. An object that defines the action set.
    :type actions: ~azure.mgmt.storage.v2021_04_01.models.ManagementPolicyAction
    :param filters: An object that defines the filter set.
    :type filters: ~azure.mgmt.storage.v2021_04_01.models.ManagementPolicyFilter
    """

    _validation = {
        'actions': {'required': True},
    }

    _attribute_map = {
        'actions': {'key': 'actions', 'type': 'ManagementPolicyAction'},
        'filters': {'key': 'filters', 'type': 'ManagementPolicyFilter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicyDefinition, self).__init__(**kwargs)
        self.actions = kwargs['actions']
        self.filters = kwargs.get('filters', None)


class ManagementPolicyFilter(msrest.serialization.Model):
    """Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters.

    All required parameters must be populated in order to send to Azure.

    :param prefix_match: An array of strings for prefixes to be match.
    :type prefix_match: list[str]
    :param blob_types: Required. An array of predefined enum values. Currently blockBlob supports
     all tiering and delete actions. Only delete actions are supported for appendBlob.
    :type blob_types: list[str]
    :param blob_index_match: An array of blob index tag based filters, there can be at most 10 tag
     filters.
    :type blob_index_match: list[~azure.mgmt.storage.v2021_04_01.models.TagFilter]
    """

    _validation = {
        'blob_types': {'required': True},
    }

    _attribute_map = {
        'prefix_match': {'key': 'prefixMatch', 'type': '[str]'},
        'blob_types': {'key': 'blobTypes', 'type': '[str]'},
        'blob_index_match': {'key': 'blobIndexMatch', 'type': '[TagFilter]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicyFilter, self).__init__(**kwargs)
        self.prefix_match = kwargs.get('prefix_match', None)
        self.blob_types = kwargs['blob_types']
        self.blob_index_match = kwargs.get('blob_index_match', None)


class ManagementPolicyRule(msrest.serialization.Model):
    """An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Rule is enabled if set to true.
    :type enabled: bool
    :param name: Required. A rule name can contain any combination of alpha numeric characters.
     Rule name is case-sensitive. It must be unique within a policy.
    :type name: str
    :param type: Required. The valid value is Lifecycle. Possible values include: "Lifecycle".
    :type type: str or ~azure.mgmt.storage.v2021_04_01.models.RuleType
    :param definition: Required. An object that defines the Lifecycle rule.
    :type definition: ~azure.mgmt.storage.v2021_04_01.models.ManagementPolicyDefinition
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'definition': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'definition': {'key': 'definition', 'type': 'ManagementPolicyDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicyRule, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.definition = kwargs['definition']


class ManagementPolicySchema(msrest.serialization.Model):
    """The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.

    All required parameters must be populated in order to send to Azure.

    :param rules: Required. The Storage Account ManagementPolicies Rules. See more details in:
     https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
    :type rules: list[~azure.mgmt.storage.v2021_04_01.models.ManagementPolicyRule]
    """

    _validation = {
        'rules': {'required': True},
    }

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ManagementPolicyRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicySchema, self).__init__(**kwargs)
        self.rules = kwargs['rules']


class ManagementPolicySnapShot(msrest.serialization.Model):
    """Management policy action for snapshot.

    :param tier_to_cool: The function to tier blob snapshot to cool storage. Support blob snapshot
     currently at Hot tier.
    :type tier_to_cool: ~azure.mgmt.storage.v2021_04_01.models.DateAfterCreation
    :param tier_to_archive: The function to tier blob snapshot to archive storage. Support blob
     snapshot currently at Hot or Cool tier.
    :type tier_to_archive: ~azure.mgmt.storage.v2021_04_01.models.DateAfterCreation
    :param delete: The function to delete the blob snapshot.
    :type delete: ~azure.mgmt.storage.v2021_04_01.models.DateAfterCreation
    """

    _attribute_map = {
        'tier_to_cool': {'key': 'tierToCool', 'type': 'DateAfterCreation'},
        'tier_to_archive': {'key': 'tierToArchive', 'type': 'DateAfterCreation'},
        'delete': {'key': 'delete', 'type': 'DateAfterCreation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicySnapShot, self).__init__(**kwargs)
        self.tier_to_cool = kwargs.get('tier_to_cool', None)
        self.tier_to_archive = kwargs.get('tier_to_archive', None)
        self.delete = kwargs.get('delete', None)


class ManagementPolicyVersion(msrest.serialization.Model):
    """Management policy action for blob version.

    :param tier_to_cool: The function to tier blob version to cool storage. Support blob version
     currently at Hot tier.
    :type tier_to_cool: ~azure.mgmt.storage.v2021_04_01.models.DateAfterCreation
    :param tier_to_archive: The function to tier blob version to archive storage. Support blob
     version currently at Hot or Cool tier.
    :type tier_to_archive: ~azure.mgmt.storage.v2021_04_01.models.DateAfterCreation
    :param delete: The function to delete the blob version.
    :type delete: ~azure.mgmt.storage.v2021_04_01.models.DateAfterCreation
    """

    _attribute_map = {
        'tier_to_cool': {'key': 'tierToCool', 'type': 'DateAfterCreation'},
        'tier_to_archive': {'key': 'tierToArchive', 'type': 'DateAfterCreation'},
        'delete': {'key': 'delete', 'type': 'DateAfterCreation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementPolicyVersion, self).__init__(**kwargs)
        self.tier_to_cool = kwargs.get('tier_to_cool', None)
        self.tier_to_archive = kwargs.get('tier_to_archive', None)
        self.delete = kwargs.get('delete', None)


class MetricSpecification(msrest.serialization.Model):
    """Metric specification of operation.

    :param name: Name of metric specification.
    :type name: str
    :param display_name: Display name of metric specification.
    :type display_name: str
    :param display_description: Display description of metric specification.
    :type display_description: str
    :param unit: Unit could be Bytes or Count.
    :type unit: str
    :param dimensions: Dimensions of blobs, including blob type and access tier.
    :type dimensions: list[~azure.mgmt.storage.v2021_04_01.models.Dimension]
    :param aggregation_type: Aggregation type could be Average.
    :type aggregation_type: str
    :param fill_gap_with_zero: The property to decide fill gap with zero or not.
    :type fill_gap_with_zero: bool
    :param category: The category this metric specification belong to, could be Capacity.
    :type category: str
    :param resource_id_dimension_name_override: Account Resource Id.
    :type resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.category = kwargs.get('category', None)
        self.resource_id_dimension_name_override = kwargs.get('resource_id_dimension_name_override', None)


class Multichannel(msrest.serialization.Model):
    """Multichannel setting. Applies to Premium FileStorage only.

    :param enabled: Indicates whether multichannel is enabled.
    :type enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Multichannel, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class NetworkRuleSet(msrest.serialization.Model):
    """Network rule set.

    All required parameters must be populated in order to send to Azure.

    :param bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices.
     Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging,
     Metrics"), or None to bypass none of those traffics. Possible values include: "None",
     "Logging", "Metrics", "AzureServices". Default value: "AzureServices".
    :type bypass: str or ~azure.mgmt.storage.v2021_04_01.models.Bypass
    :param resource_access_rules: Sets the resource access rules.
    :type resource_access_rules: list[~azure.mgmt.storage.v2021_04_01.models.ResourceAccessRule]
    :param virtual_network_rules: Sets the virtual network rules.
    :type virtual_network_rules: list[~azure.mgmt.storage.v2021_04_01.models.VirtualNetworkRule]
    :param ip_rules: Sets the IP ACL rules.
    :type ip_rules: list[~azure.mgmt.storage.v2021_04_01.models.IPRule]
    :param default_action: Required. Specifies the default action of allow or deny when no other
     rules match. Possible values include: "Allow", "Deny". Default value: "Allow".
    :type default_action: str or ~azure.mgmt.storage.v2021_04_01.models.DefaultAction
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'bypass': {'key': 'bypass', 'type': 'str'},
        'resource_access_rules': {'key': 'resourceAccessRules', 'type': '[ResourceAccessRule]'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
        'default_action': {'key': 'defaultAction', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.bypass = kwargs.get('bypass', "AzureServices")
        self.resource_access_rules = kwargs.get('resource_access_rules', None)
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.ip_rules = kwargs.get('ip_rules', None)
        self.default_action = kwargs.get('default_action', "Allow")


class ObjectReplicationPolicies(msrest.serialization.Model):
    """List storage account object replication policies.

    :param value: The replication policy between two storage accounts.
    :type value: list[~azure.mgmt.storage.v2021_04_01.models.ObjectReplicationPolicy]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ObjectReplicationPolicy]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ObjectReplicationPolicies, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ObjectReplicationPolicy(Resource):
    """The replication policy between two storage accounts. Multiple rules can be defined in one policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar policy_id: A unique id for object replication policy.
    :vartype policy_id: str
    :ivar enabled_time: Indicates when the policy is enabled on the source account.
    :vartype enabled_time: ~datetime.datetime
    :param source_account: Required. Source account name. It should be full resource id if
     allowCrossTenantReplication set to false.
    :type source_account: str
    :param destination_account: Required. Destination account name. It should be full resource id
     if allowCrossTenantReplication set to false.
    :type destination_account: str
    :param rules: The storage account object replication rules.
    :type rules: list[~azure.mgmt.storage.v2021_04_01.models.ObjectReplicationPolicyRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'policy_id': {'readonly': True},
        'enabled_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'policy_id': {'key': 'properties.policyId', 'type': 'str'},
        'enabled_time': {'key': 'properties.enabledTime', 'type': 'iso-8601'},
        'source_account': {'key': 'properties.sourceAccount', 'type': 'str'},
        'destination_account': {'key': 'properties.destinationAccount', 'type': 'str'},
        'rules': {'key': 'properties.rules', 'type': '[ObjectReplicationPolicyRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ObjectReplicationPolicy, self).__init__(**kwargs)
        self.policy_id = None
        self.enabled_time = None
        self.source_account = kwargs.get('source_account', None)
        self.destination_account = kwargs.get('destination_account', None)
        self.rules = kwargs.get('rules', None)


class ObjectReplicationPolicyFilter(msrest.serialization.Model):
    """Filters limit replication to a subset of blobs within the storage account. A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all filters.

    :param prefix_match: Optional. Filters the results to replicate only blobs whose names begin
     with the specified prefix.
    :type prefix_match: list[str]
    :param min_creation_time: Blobs created after the time will be replicated to the destination.
     It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z.
    :type min_creation_time: str
    """

    _attribute_map = {
        'prefix_match': {'key': 'prefixMatch', 'type': '[str]'},
        'min_creation_time': {'key': 'minCreationTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ObjectReplicationPolicyFilter, self).__init__(**kwargs)
        self.prefix_match = kwargs.get('prefix_match', None)
        self.min_creation_time = kwargs.get('min_creation_time', None)


class ObjectReplicationPolicyRule(msrest.serialization.Model):
    """The replication policy rule between two containers.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Rule Id is auto-generated for each new rule on destination account. It is
     required for put policy on source account.
    :type rule_id: str
    :param source_container: Required. Required. Source container name.
    :type source_container: str
    :param destination_container: Required. Required. Destination container name.
    :type destination_container: str
    :param filters: Optional. An object that defines the filter set.
    :type filters: ~azure.mgmt.storage.v2021_04_01.models.ObjectReplicationPolicyFilter
    """

    _validation = {
        'source_container': {'required': True},
        'destination_container': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'source_container': {'key': 'sourceContainer', 'type': 'str'},
        'destination_container': {'key': 'destinationContainer', 'type': 'str'},
        'filters': {'key': 'filters', 'type': 'ObjectReplicationPolicyFilter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ObjectReplicationPolicyRule, self).__init__(**kwargs)
        self.rule_id = kwargs.get('rule_id', None)
        self.source_container = kwargs['source_container']
        self.destination_container = kwargs['destination_container']
        self.filters = kwargs.get('filters', None)


class Operation(msrest.serialization.Model):
    """Storage REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.storage.v2021_04_01.models.OperationDisplay
    :param origin: The origin of operations.
    :type origin: str
    :param service_specification: One property of operation, include metric specifications.
    :type service_specification: ~azure.mgmt.storage.v2021_04_01.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft Storage.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of Storage operations supported by the Storage resource provider.
    :type value: list[~azure.mgmt.storage.v2021_04_01.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~azure.mgmt.storage.v2021_04_01.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.storage.v2021_04_01.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.storage.v2021_04_01.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :param value: Array of private endpoint connections.
    :type value: list[~azure.mgmt.storage.v2021_04_01.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~azure.mgmt.storage.v2021_04_01.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :type status: str or
     ~azure.mgmt.storage.v2021_04_01.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param action_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type action_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'action_required': {'key': 'actionRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.action_required = kwargs.get('action_required', None)


class ProtocolSettings(msrest.serialization.Model):
    """Protocol settings for file service.

    :param smb: Setting for SMB protocol.
    :type smb: ~azure.mgmt.storage.v2021_04_01.models.SmbSetting
    """

    _attribute_map = {
        'smb': {'key': 'smb', 'type': 'SmbSetting'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProtocolSettings, self).__init__(**kwargs)
        self.smb = kwargs.get('smb', None)


class QueueServiceProperties(Resource):
    """The properties of a storage account’s Queue service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param cors: Specifies CORS rules for the Queue service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the Queue service.
    :type cors: ~azure.mgmt.storage.v2021_04_01.models.CorsRules
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsRules'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueueServiceProperties, self).__init__(**kwargs)
        self.cors = kwargs.get('cors', None)


class ResourceAccessRule(msrest.serialization.Model):
    """Resource Access Rule.

    :param tenant_id: Tenant Id.
    :type tenant_id: str
    :param resource_id: Resource Id.
    :type resource_id: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceAccessRule, self).__init__(**kwargs)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.resource_id = kwargs.get('resource_id', None)


class RestorePolicyProperties(msrest.serialization.Model):
    """The blob service properties for blob restore policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Blob restore is enabled if set to true.
    :type enabled: bool
    :param days: how long this blob can be restored. It should be great than zero and less than
     DeleteRetentionPolicy.days.
    :type days: int
    :ivar last_enabled_time: Deprecated in favor of minRestoreTime property.
    :vartype last_enabled_time: ~datetime.datetime
    :ivar min_restore_time: Returns the minimum date and time that the restore can be started.
    :vartype min_restore_time: ~datetime.datetime
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'maximum': 365, 'minimum': 1},
        'last_enabled_time': {'readonly': True},
        'min_restore_time': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
        'last_enabled_time': {'key': 'lastEnabledTime', 'type': 'iso-8601'},
        'min_restore_time': {'key': 'minRestoreTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorePolicyProperties, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.days = kwargs.get('days', None)
        self.last_enabled_time = None
        self.min_restore_time = None


class Restriction(msrest.serialization.Model):
    """The restriction because of which SKU cannot be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. As of now only possible value for this is location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :param reason_code: The reason for the restriction. As of now this can be "QuotaId" or
     "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the
     subscription does not belong to that quota. The "NotAvailableForSubscription" is related to
     capacity at DC. Possible values include: "QuotaId", "NotAvailableForSubscription".
    :type reason_code: str or ~azure.mgmt.storage.v2021_04_01.models.ReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Restriction, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = kwargs.get('reason_code', None)


class RoutingPreference(msrest.serialization.Model):
    """Routing preference defines the type of network, either microsoft or internet routing to be used to deliver the user data, the default option is microsoft routing.

    :param routing_choice: Routing Choice defines the kind of network routing opted by the user.
     Possible values include: "MicrosoftRouting", "InternetRouting".
    :type routing_choice: str or ~azure.mgmt.storage.v2021_04_01.models.RoutingChoice
    :param publish_microsoft_endpoints: A boolean flag which indicates whether microsoft routing
     storage endpoints are to be published.
    :type publish_microsoft_endpoints: bool
    :param publish_internet_endpoints: A boolean flag which indicates whether internet routing
     storage endpoints are to be published.
    :type publish_internet_endpoints: bool
    """

    _attribute_map = {
        'routing_choice': {'key': 'routingChoice', 'type': 'str'},
        'publish_microsoft_endpoints': {'key': 'publishMicrosoftEndpoints', 'type': 'bool'},
        'publish_internet_endpoints': {'key': 'publishInternetEndpoints', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingPreference, self).__init__(**kwargs)
        self.routing_choice = kwargs.get('routing_choice', None)
        self.publish_microsoft_endpoints = kwargs.get('publish_microsoft_endpoints', None)
        self.publish_internet_endpoints = kwargs.get('publish_internet_endpoints', None)


class SasPolicy(msrest.serialization.Model):
    """SasPolicy assigned to the storage account.

    All required parameters must be populated in order to send to Azure.

    :param sas_expiration_period: Required. The SAS expiration period, DD.HH:MM:SS.
    :type sas_expiration_period: str
    :param expiration_action: Required. The SAS expiration action. Can only be Log. Possible values
     include: "Log". Default value: "Log".
    :type expiration_action: str or ~azure.mgmt.storage.v2021_04_01.models.ExpirationAction
    """

    _validation = {
        'sas_expiration_period': {'required': True},
        'expiration_action': {'required': True},
    }

    _attribute_map = {
        'sas_expiration_period': {'key': 'sasExpirationPeriod', 'type': 'str'},
        'expiration_action': {'key': 'expirationAction', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SasPolicy, self).__init__(**kwargs)
        self.sas_expiration_period = kwargs['sas_expiration_period']
        self.expiration_action = kwargs.get('expiration_action', "Log")


class ServiceSasParameters(msrest.serialization.Model):
    """The parameters to list service SAS credentials of a specific resource.

    All required parameters must be populated in order to send to Azure.

    :param canonicalized_resource: Required. The canonical path to the signed resource.
    :type canonicalized_resource: str
    :param resource: The signed services accessible with the service SAS. Possible values include:
     Blob (b), Container (c), File (f), Share (s). Possible values include: "b", "c", "f", "s".
    :type resource: str or ~azure.mgmt.storage.v2021_04_01.models.SignedResource
    :param permissions: The signed permissions for the service SAS. Possible values include: Read
     (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). Possible
     values include: "r", "d", "w", "l", "a", "c", "u", "p".
    :type permissions: str or ~azure.mgmt.storage.v2021_04_01.models.Permissions
    :param ip_address_or_range: An IP address or a range of IP addresses from which to accept
     requests.
    :type ip_address_or_range: str
    :param protocols: The protocol permitted for a request made with the account SAS. Possible
     values include: "https,http", "https".
    :type protocols: str or ~azure.mgmt.storage.v2021_04_01.models.HttpProtocol
    :param shared_access_start_time: The time at which the SAS becomes valid.
    :type shared_access_start_time: ~datetime.datetime
    :param shared_access_expiry_time: The time at which the shared access signature becomes
     invalid.
    :type shared_access_expiry_time: ~datetime.datetime
    :param identifier: A unique value up to 64 characters in length that correlates to an access
     policy specified for the container, queue, or table.
    :type identifier: str
    :param partition_key_start: The start of partition key.
    :type partition_key_start: str
    :param partition_key_end: The end of partition key.
    :type partition_key_end: str
    :param row_key_start: The start of row key.
    :type row_key_start: str
    :param row_key_end: The end of row key.
    :type row_key_end: str
    :param key_to_sign: The key to sign the account SAS token with.
    :type key_to_sign: str
    :param cache_control: The response header override for cache control.
    :type cache_control: str
    :param content_disposition: The response header override for content disposition.
    :type content_disposition: str
    :param content_encoding: The response header override for content encoding.
    :type content_encoding: str
    :param content_language: The response header override for content language.
    :type content_language: str
    :param content_type: The response header override for content type.
    :type content_type: str
    """

    _validation = {
        'canonicalized_resource': {'required': True},
        'identifier': {'max_length': 64, 'min_length': 0},
    }

    _attribute_map = {
        'canonicalized_resource': {'key': 'canonicalizedResource', 'type': 'str'},
        'resource': {'key': 'signedResource', 'type': 'str'},
        'permissions': {'key': 'signedPermission', 'type': 'str'},
        'ip_address_or_range': {'key': 'signedIp', 'type': 'str'},
        'protocols': {'key': 'signedProtocol', 'type': 'str'},
        'shared_access_start_time': {'key': 'signedStart', 'type': 'iso-8601'},
        'shared_access_expiry_time': {'key': 'signedExpiry', 'type': 'iso-8601'},
        'identifier': {'key': 'signedIdentifier', 'type': 'str'},
        'partition_key_start': {'key': 'startPk', 'type': 'str'},
        'partition_key_end': {'key': 'endPk', 'type': 'str'},
        'row_key_start': {'key': 'startRk', 'type': 'str'},
        'row_key_end': {'key': 'endRk', 'type': 'str'},
        'key_to_sign': {'key': 'keyToSign', 'type': 'str'},
        'cache_control': {'key': 'rscc', 'type': 'str'},
        'content_disposition': {'key': 'rscd', 'type': 'str'},
        'content_encoding': {'key': 'rsce', 'type': 'str'},
        'content_language': {'key': 'rscl', 'type': 'str'},
        'content_type': {'key': 'rsct', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSasParameters, self).__init__(**kwargs)
        self.canonicalized_resource = kwargs['canonicalized_resource']
        self.resource = kwargs.get('resource', None)
        self.permissions = kwargs.get('permissions', None)
        self.ip_address_or_range = kwargs.get('ip_address_or_range', None)
        self.protocols = kwargs.get('protocols', None)
        self.shared_access_start_time = kwargs.get('shared_access_start_time', None)
        self.shared_access_expiry_time = kwargs.get('shared_access_expiry_time', None)
        self.identifier = kwargs.get('identifier', None)
        self.partition_key_start = kwargs.get('partition_key_start', None)
        self.partition_key_end = kwargs.get('partition_key_end', None)
        self.row_key_start = kwargs.get('row_key_start', None)
        self.row_key_end = kwargs.get('row_key_end', None)
        self.key_to_sign = kwargs.get('key_to_sign', None)
        self.cache_control = kwargs.get('cache_control', None)
        self.content_disposition = kwargs.get('content_disposition', None)
        self.content_encoding = kwargs.get('content_encoding', None)
        self.content_language = kwargs.get('content_language', None)
        self.content_type = kwargs.get('content_type', None)


class ServiceSpecification(msrest.serialization.Model):
    """One property of operation, include metric specifications.

    :param metric_specifications: Metric specifications of operation.
    :type metric_specifications: list[~azure.mgmt.storage.v2021_04_01.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class SignedIdentifier(msrest.serialization.Model):
    """SignedIdentifier.

    :param id: An unique identifier of the stored access policy.
    :type id: str
    :param access_policy: Access policy.
    :type access_policy: ~azure.mgmt.storage.v2021_04_01.models.AccessPolicy
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'access_policy': {'key': 'accessPolicy', 'type': 'AccessPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SignedIdentifier, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.access_policy = kwargs.get('access_policy', None)


class Sku(msrest.serialization.Model):
    """The SKU of the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The SKU name. Required for account creation; optional for update. Note
     that in older versions, SKU name was called accountType. Possible values include:
     "Standard_LRS", "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS",
     "Standard_GZRS", "Standard_RAGZRS".
    :type name: str or ~azure.mgmt.storage.v2021_04_01.models.SkuName
    :ivar tier: The SKU tier. This is based on the SKU name. Possible values include: "Standard",
     "Premium".
    :vartype tier: str or ~azure.mgmt.storage.v2021_04_01.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = None


class SKUCapability(msrest.serialization.Model):
    """The capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of capability, The capability information in the specified SKU, including
     file encryption, network ACLs, change notification, etc.
    :vartype name: str
    :ivar value: A string value to indicate states of given capability. Possibly 'true' or 'false'.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SKUCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None


class SkuInformation(msrest.serialization.Model):
    """Storage SKU and its properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The SKU name. Required for account creation; optional for update. Note
     that in older versions, SKU name was called accountType. Possible values include:
     "Standard_LRS", "Standard_GRS", "Standard_RAGRS", "Standard_ZRS", "Premium_LRS", "Premium_ZRS",
     "Standard_GZRS", "Standard_RAGZRS".
    :type name: str or ~azure.mgmt.storage.v2021_04_01.models.SkuName
    :ivar tier: The SKU tier. This is based on the SKU name. Possible values include: "Standard",
     "Premium".
    :vartype tier: str or ~azure.mgmt.storage.v2021_04_01.models.SkuTier
    :ivar resource_type: The type of the resource, usually it is 'storageAccounts'.
    :vartype resource_type: str
    :ivar kind: Indicates the type of storage account. Possible values include: "Storage",
     "StorageV2", "BlobStorage", "FileStorage", "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2021_04_01.models.Kind
    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar capabilities: The capability information in the specified SKU, including file encryption,
     network ACLs, change notification, etc.
    :vartype capabilities: list[~azure.mgmt.storage.v2021_04_01.models.SKUCapability]
    :param restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :type restrictions: list[~azure.mgmt.storage.v2021_04_01.models.Restriction]
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
        'resource_type': {'readonly': True},
        'kind': {'readonly': True},
        'locations': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[SKUCapability]'},
        'restrictions': {'key': 'restrictions', 'type': '[Restriction]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInformation, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = None
        self.resource_type = None
        self.kind = None
        self.locations = None
        self.capabilities = None
        self.restrictions = kwargs.get('restrictions', None)


class SmbSetting(msrest.serialization.Model):
    """Setting for SMB protocol.

    :param multichannel: Multichannel setting. Applies to Premium FileStorage only.
    :type multichannel: ~azure.mgmt.storage.v2021_04_01.models.Multichannel
    :param versions: SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0,
     SMB3.1.1. Should be passed as a string with delimiter ';'.
    :type versions: str
    :param authentication_methods: SMB authentication methods supported by server. Valid values are
     NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
    :type authentication_methods: str
    :param kerberos_ticket_encryption: Kerberos ticket encryption supported by server. Valid values
     are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'.
    :type kerberos_ticket_encryption: str
    :param channel_encryption: SMB channel encryption supported by server. Valid values are
     AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
    :type channel_encryption: str
    """

    _attribute_map = {
        'multichannel': {'key': 'multichannel', 'type': 'Multichannel'},
        'versions': {'key': 'versions', 'type': 'str'},
        'authentication_methods': {'key': 'authenticationMethods', 'type': 'str'},
        'kerberos_ticket_encryption': {'key': 'kerberosTicketEncryption', 'type': 'str'},
        'channel_encryption': {'key': 'channelEncryption', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmbSetting, self).__init__(**kwargs)
        self.multichannel = kwargs.get('multichannel', None)
        self.versions = kwargs.get('versions', None)
        self.authentication_methods = kwargs.get('authentication_methods', None)
        self.kerberos_ticket_encryption = kwargs.get('kerberos_ticket_encryption', None)
        self.channel_encryption = kwargs.get('channel_encryption', None)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class StorageAccount(TrackedResource):
    """The storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar sku: Gets the SKU.
    :vartype sku: ~azure.mgmt.storage.v2021_04_01.models.Sku
    :ivar kind: Gets the Kind. Possible values include: "Storage", "StorageV2", "BlobStorage",
     "FileStorage", "BlockBlobStorage".
    :vartype kind: str or ~azure.mgmt.storage.v2021_04_01.models.Kind
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.storage.v2021_04_01.models.Identity
    :param extended_location: The extendedLocation of the resource.
    :type extended_location: ~azure.mgmt.storage.v2021_04_01.models.ExtendedLocation
    :ivar provisioning_state: Gets the status of the storage account at the time the operation was
     called. Possible values include: "Creating", "ResolvingDNS", "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.storage.v2021_04_01.models.ProvisioningState
    :ivar primary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob
     endpoint.
    :vartype primary_endpoints: ~azure.mgmt.storage.v2021_04_01.models.Endpoints
    :ivar primary_location: Gets the location of the primary data center for the storage account.
    :vartype primary_location: str
    :ivar status_of_primary: Gets the status indicating whether the primary location of the storage
     account is available or unavailable. Possible values include: "available", "unavailable".
    :vartype status_of_primary: str or ~azure.mgmt.storage.v2021_04_01.models.AccountStatus
    :ivar last_geo_failover_time: Gets the timestamp of the most recent instance of a failover to
     the secondary location. Only the most recent timestamp is retained. This element is not
     returned if there has never been a failover instance. Only available if the accountType is
     Standard_GRS or Standard_RAGRS.
    :vartype last_geo_failover_time: ~datetime.datetime
    :ivar secondary_location: Gets the location of the geo-replicated secondary for the storage
     account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
    :vartype secondary_location: str
    :ivar status_of_secondary: Gets the status indicating whether the secondary location of the
     storage account is available or unavailable. Only available if the SKU name is Standard_GRS or
     Standard_RAGRS. Possible values include: "available", "unavailable".
    :vartype status_of_secondary: str or ~azure.mgmt.storage.v2021_04_01.models.AccountStatus
    :ivar creation_time: Gets the creation date and time of the storage account in UTC.
    :vartype creation_time: ~datetime.datetime
    :ivar custom_domain: Gets the custom domain the user assigned to this storage account.
    :vartype custom_domain: ~azure.mgmt.storage.v2021_04_01.models.CustomDomain
    :ivar sas_policy: SasPolicy assigned to the storage account.
    :vartype sas_policy: ~azure.mgmt.storage.v2021_04_01.models.SasPolicy
    :ivar key_policy: KeyPolicy assigned to the storage account.
    :vartype key_policy: ~azure.mgmt.storage.v2021_04_01.models.KeyPolicy
    :ivar key_creation_time: Storage account keys creation time.
    :vartype key_creation_time: ~azure.mgmt.storage.v2021_04_01.models.KeyCreationTime
    :ivar secondary_endpoints: Gets the URLs that are used to perform a retrieval of a public blob,
     queue, or table object from the secondary location of the storage account. Only available if
     the SKU name is Standard_RAGRS.
    :vartype secondary_endpoints: ~azure.mgmt.storage.v2021_04_01.models.Endpoints
    :ivar encryption: Gets the encryption settings on the account. If unspecified, the account is
     unencrypted.
    :vartype encryption: ~azure.mgmt.storage.v2021_04_01.models.Encryption
    :ivar access_tier: Required for storage accounts where kind = BlobStorage. The access tier used
     for billing. Possible values include: "Hot", "Cool".
    :vartype access_tier: str or ~azure.mgmt.storage.v2021_04_01.models.AccessTier
    :param azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :type azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2021_04_01.models.AzureFilesIdentityBasedAuthentication
    :param enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :type enable_https_traffic_only: bool
    :ivar network_rule_set: Network rule set.
    :vartype network_rule_set: ~azure.mgmt.storage.v2021_04_01.models.NetworkRuleSet
    :param is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
    :type is_hns_enabled: bool
    :ivar geo_replication_stats: Geo Replication Stats.
    :vartype geo_replication_stats: ~azure.mgmt.storage.v2021_04_01.models.GeoReplicationStats
    :ivar failover_in_progress: If the failover is in progress, the value will be true, otherwise,
     it will be null.
    :vartype failover_in_progress: bool
    :param large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Possible values include: "Disabled", "Enabled".
    :type large_file_shares_state: str or
     ~azure.mgmt.storage.v2021_04_01.models.LargeFileSharesState
    :ivar private_endpoint_connections: List of private endpoint connection associated with the
     specified storage account.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.storage.v2021_04_01.models.PrivateEndpointConnection]
    :param routing_preference: Maintains information about the network routing choice opted by the
     user for data transfer.
    :type routing_preference: ~azure.mgmt.storage.v2021_04_01.models.RoutingPreference
    :ivar blob_restore_status: Blob restore status.
    :vartype blob_restore_status: ~azure.mgmt.storage.v2021_04_01.models.BlobRestoreStatus
    :param allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :type allow_blob_public_access: bool
    :param minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Possible values include: "TLS1_0",
     "TLS1_1", "TLS1_2".
    :type minimum_tls_version: str or ~azure.mgmt.storage.v2021_04_01.models.MinimumTlsVersion
    :param allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :type allow_shared_key_access: bool
    :param enable_nfs_v3: NFS 3.0 protocol support enabled if set to true.
    :type enable_nfs_v3: bool
    :param allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
     The default interpretation is true for this property.
    :type allow_cross_tenant_replication: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'readonly': True},
        'kind': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'primary_endpoints': {'readonly': True},
        'primary_location': {'readonly': True},
        'status_of_primary': {'readonly': True},
        'last_geo_failover_time': {'readonly': True},
        'secondary_location': {'readonly': True},
        'status_of_secondary': {'readonly': True},
        'creation_time': {'readonly': True},
        'custom_domain': {'readonly': True},
        'sas_policy': {'readonly': True},
        'key_policy': {'readonly': True},
        'key_creation_time': {'readonly': True},
        'secondary_endpoints': {'readonly': True},
        'encryption': {'readonly': True},
        'access_tier': {'readonly': True},
        'network_rule_set': {'readonly': True},
        'geo_replication_stats': {'readonly': True},
        'failover_in_progress': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'blob_restore_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'primary_endpoints': {'key': 'properties.primaryEndpoints', 'type': 'Endpoints'},
        'primary_location': {'key': 'properties.primaryLocation', 'type': 'str'},
        'status_of_primary': {'key': 'properties.statusOfPrimary', 'type': 'str'},
        'last_geo_failover_time': {'key': 'properties.lastGeoFailoverTime', 'type': 'iso-8601'},
        'secondary_location': {'key': 'properties.secondaryLocation', 'type': 'str'},
        'status_of_secondary': {'key': 'properties.statusOfSecondary', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'sas_policy': {'key': 'properties.sasPolicy', 'type': 'SasPolicy'},
        'key_policy': {'key': 'properties.keyPolicy', 'type': 'KeyPolicy'},
        'key_creation_time': {'key': 'properties.keyCreationTime', 'type': 'KeyCreationTime'},
        'secondary_endpoints': {'key': 'properties.secondaryEndpoints', 'type': 'Endpoints'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'is_hns_enabled': {'key': 'properties.isHnsEnabled', 'type': 'bool'},
        'geo_replication_stats': {'key': 'properties.geoReplicationStats', 'type': 'GeoReplicationStats'},
        'failover_in_progress': {'key': 'properties.failoverInProgress', 'type': 'bool'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'routing_preference': {'key': 'properties.routingPreference', 'type': 'RoutingPreference'},
        'blob_restore_status': {'key': 'properties.blobRestoreStatus', 'type': 'BlobRestoreStatus'},
        'allow_blob_public_access': {'key': 'properties.allowBlobPublicAccess', 'type': 'bool'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'allow_shared_key_access': {'key': 'properties.allowSharedKeyAccess', 'type': 'bool'},
        'enable_nfs_v3': {'key': 'properties.isNfsV3Enabled', 'type': 'bool'},
        'allow_cross_tenant_replication': {'key': 'properties.allowCrossTenantReplication', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccount, self).__init__(**kwargs)
        self.sku = None
        self.kind = None
        self.identity = kwargs.get('identity', None)
        self.extended_location = kwargs.get('extended_location', None)
        self.provisioning_state = None
        self.primary_endpoints = None
        self.primary_location = None
        self.status_of_primary = None
        self.last_geo_failover_time = None
        self.secondary_location = None
        self.status_of_secondary = None
        self.creation_time = None
        self.custom_domain = None
        self.sas_policy = None
        self.key_policy = None
        self.key_creation_time = None
        self.secondary_endpoints = None
        self.encryption = None
        self.access_tier = None
        self.azure_files_identity_based_authentication = kwargs.get('azure_files_identity_based_authentication', None)
        self.enable_https_traffic_only = kwargs.get('enable_https_traffic_only', None)
        self.network_rule_set = None
        self.is_hns_enabled = kwargs.get('is_hns_enabled', None)
        self.geo_replication_stats = None
        self.failover_in_progress = None
        self.large_file_shares_state = kwargs.get('large_file_shares_state', None)
        self.private_endpoint_connections = None
        self.routing_preference = kwargs.get('routing_preference', None)
        self.blob_restore_status = None
        self.allow_blob_public_access = kwargs.get('allow_blob_public_access', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.allow_shared_key_access = kwargs.get('allow_shared_key_access', None)
        self.enable_nfs_v3 = kwargs.get('enable_nfs_v3', None)
        self.allow_cross_tenant_replication = kwargs.get('allow_cross_tenant_replication', None)


class StorageAccountCheckNameAvailabilityParameters(msrest.serialization.Model):
    """The parameters used to check the availability of the storage account name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The storage account name.
    :type name: str
    :ivar type: Required. The type of resource, Microsoft.Storage/storageAccounts. Default value:
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Storage/storageAccounts"

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = kwargs['name']


class StorageAccountCreateParameters(msrest.serialization.Model):
    """The parameters used when creating a storage account.

    All required parameters must be populated in order to send to Azure.

    :param sku: Required. Required. Gets or sets the SKU name.
    :type sku: ~azure.mgmt.storage.v2021_04_01.models.Sku
    :param kind: Required. Required. Indicates the type of storage account. Possible values
     include: "Storage", "StorageV2", "BlobStorage", "FileStorage", "BlockBlobStorage".
    :type kind: str or ~azure.mgmt.storage.v2021_04_01.models.Kind
    :param location: Required. Required. Gets or sets the location of the resource. This will be
     one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia,
     etc.). The geo region of a resource cannot be changed once it is created, but if an identical
     geo region is specified on update, the request will succeed.
    :type location: str
    :param extended_location: Optional. Set the extended location of the resource. If not set, the
     storage account will be created in Azure main region. Otherwise it will be created in the
     specified extended location.
    :type extended_location: ~azure.mgmt.storage.v2021_04_01.models.ExtendedLocation
    :param tags: A set of tags. Gets or sets a list of key value pairs that describe the resource.
     These tags can be used for viewing and grouping this resource (across resource groups). A
     maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no
     greater than 128 characters and a value with a length no greater than 256 characters.
    :type tags: dict[str, str]
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.storage.v2021_04_01.models.Identity
    :param sas_policy: SasPolicy assigned to the storage account.
    :type sas_policy: ~azure.mgmt.storage.v2021_04_01.models.SasPolicy
    :param key_policy: KeyPolicy assigned to the storage account.
    :type key_policy: ~azure.mgmt.storage.v2021_04_01.models.KeyPolicy
    :param custom_domain: User domain assigned to the storage account. Name is the CNAME source.
     Only one custom domain is supported per storage account at this time. To clear the existing
     custom domain, use an empty string for the custom domain name property.
    :type custom_domain: ~azure.mgmt.storage.v2021_04_01.models.CustomDomain
    :param encryption: Not applicable. Azure Storage encryption is enabled for all storage accounts
     and cannot be disabled.
    :type encryption: ~azure.mgmt.storage.v2021_04_01.models.Encryption
    :param network_rule_set: Network rule set.
    :type network_rule_set: ~azure.mgmt.storage.v2021_04_01.models.NetworkRuleSet
    :param access_tier: Required for storage accounts where kind = BlobStorage. The access tier
     used for billing. Possible values include: "Hot", "Cool".
    :type access_tier: str or ~azure.mgmt.storage.v2021_04_01.models.AccessTier
    :param azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :type azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2021_04_01.models.AzureFilesIdentityBasedAuthentication
    :param enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
     The default value is true since API version 2019-04-01.
    :type enable_https_traffic_only: bool
    :param is_hns_enabled: Account HierarchicalNamespace enabled if sets to true.
    :type is_hns_enabled: bool
    :param large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Possible values include: "Disabled", "Enabled".
    :type large_file_shares_state: str or
     ~azure.mgmt.storage.v2021_04_01.models.LargeFileSharesState
    :param routing_preference: Maintains information about the network routing choice opted by the
     user for data transfer.
    :type routing_preference: ~azure.mgmt.storage.v2021_04_01.models.RoutingPreference
    :param allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :type allow_blob_public_access: bool
    :param minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Possible values include: "TLS1_0",
     "TLS1_1", "TLS1_2".
    :type minimum_tls_version: str or ~azure.mgmt.storage.v2021_04_01.models.MinimumTlsVersion
    :param allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :type allow_shared_key_access: bool
    :param enable_nfs_v3: NFS 3.0 protocol support enabled if set to true.
    :type enable_nfs_v3: bool
    :param allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
     The default interpretation is true for this property.
    :type allow_cross_tenant_replication: bool
    """

    _validation = {
        'sku': {'required': True},
        'kind': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sas_policy': {'key': 'properties.sasPolicy', 'type': 'SasPolicy'},
        'key_policy': {'key': 'properties.keyPolicy', 'type': 'KeyPolicy'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'is_hns_enabled': {'key': 'properties.isHnsEnabled', 'type': 'bool'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'routing_preference': {'key': 'properties.routingPreference', 'type': 'RoutingPreference'},
        'allow_blob_public_access': {'key': 'properties.allowBlobPublicAccess', 'type': 'bool'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'allow_shared_key_access': {'key': 'properties.allowSharedKeyAccess', 'type': 'bool'},
        'enable_nfs_v3': {'key': 'properties.isNfsV3Enabled', 'type': 'bool'},
        'allow_cross_tenant_replication': {'key': 'properties.allowCrossTenantReplication', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountCreateParameters, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.kind = kwargs['kind']
        self.location = kwargs['location']
        self.extended_location = kwargs.get('extended_location', None)
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.sas_policy = kwargs.get('sas_policy', None)
        self.key_policy = kwargs.get('key_policy', None)
        self.custom_domain = kwargs.get('custom_domain', None)
        self.encryption = kwargs.get('encryption', None)
        self.network_rule_set = kwargs.get('network_rule_set', None)
        self.access_tier = kwargs.get('access_tier', None)
        self.azure_files_identity_based_authentication = kwargs.get('azure_files_identity_based_authentication', None)
        self.enable_https_traffic_only = kwargs.get('enable_https_traffic_only', None)
        self.is_hns_enabled = kwargs.get('is_hns_enabled', None)
        self.large_file_shares_state = kwargs.get('large_file_shares_state', None)
        self.routing_preference = kwargs.get('routing_preference', None)
        self.allow_blob_public_access = kwargs.get('allow_blob_public_access', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.allow_shared_key_access = kwargs.get('allow_shared_key_access', None)
        self.enable_nfs_v3 = kwargs.get('enable_nfs_v3', None)
        self.allow_cross_tenant_replication = kwargs.get('allow_cross_tenant_replication', None)


class StorageAccountInternetEndpoints(msrest.serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via a internet routing endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    """

    _validation = {
        'blob': {'readonly': True},
        'file': {'readonly': True},
        'web': {'readonly': True},
        'dfs': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'web': {'key': 'web', 'type': 'str'},
        'dfs': {'key': 'dfs', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountInternetEndpoints, self).__init__(**kwargs)
        self.blob = None
        self.file = None
        self.web = None
        self.dfs = None


class StorageAccountKey(msrest.serialization.Model):
    """An access key for the storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: Name of the key.
    :vartype key_name: str
    :ivar value: Base 64-encoded value of the key.
    :vartype value: str
    :ivar permissions: Permissions for the key -- read-only or full permissions. Possible values
     include: "Read", "Full".
    :vartype permissions: str or ~azure.mgmt.storage.v2021_04_01.models.KeyPermission
    :ivar creation_time: Creation time of the key, in round trip date format.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'key_name': {'readonly': True},
        'value': {'readonly': True},
        'permissions': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountKey, self).__init__(**kwargs)
        self.key_name = None
        self.value = None
        self.permissions = None
        self.creation_time = None


class StorageAccountListKeysResult(msrest.serialization.Model):
    """The response from the ListKeys operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar keys: Gets the list of storage account keys and their properties for the specified
     storage account.
    :vartype keys: list[~azure.mgmt.storage.v2021_04_01.models.StorageAccountKey]
    """

    _validation = {
        'keys': {'readonly': True},
    }

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[StorageAccountKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountListKeysResult, self).__init__(**kwargs)
        self.keys = None


class StorageAccountListResult(msrest.serialization.Model):
    """The response from the List Storage Accounts operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets the list of storage accounts and their properties.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.StorageAccount]
    :ivar next_link: Request URL that can be used to query next page of storage accounts. Returned
     when total number of requested storage accounts exceed maximum page size.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageAccountMicrosoftEndpoints(msrest.serialization.Model):
    """The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object via a microsoft routing endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob: Gets the blob endpoint.
    :vartype blob: str
    :ivar queue: Gets the queue endpoint.
    :vartype queue: str
    :ivar table: Gets the table endpoint.
    :vartype table: str
    :ivar file: Gets the file endpoint.
    :vartype file: str
    :ivar web: Gets the web endpoint.
    :vartype web: str
    :ivar dfs: Gets the dfs endpoint.
    :vartype dfs: str
    """

    _validation = {
        'blob': {'readonly': True},
        'queue': {'readonly': True},
        'table': {'readonly': True},
        'file': {'readonly': True},
        'web': {'readonly': True},
        'dfs': {'readonly': True},
    }

    _attribute_map = {
        'blob': {'key': 'blob', 'type': 'str'},
        'queue': {'key': 'queue', 'type': 'str'},
        'table': {'key': 'table', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'web': {'key': 'web', 'type': 'str'},
        'dfs': {'key': 'dfs', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountMicrosoftEndpoints, self).__init__(**kwargs)
        self.blob = None
        self.queue = None
        self.table = None
        self.file = None
        self.web = None
        self.dfs = None


class StorageAccountRegenerateKeyParameters(msrest.serialization.Model):
    """The parameters used to regenerate the storage account key.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The name of storage keys that want to be regenerated, possible
     values are key1, key2, kerb1, kerb2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = kwargs['key_name']


class StorageAccountUpdateParameters(msrest.serialization.Model):
    """The parameters that can be provided when updating the storage account properties.

    :param sku: Gets or sets the SKU name. Note that the SKU name cannot be updated to
     Standard_ZRS, Premium_LRS or Premium_ZRS, nor can accounts of those SKU names be updated to any
     other value.
    :type sku: ~azure.mgmt.storage.v2021_04_01.models.Sku
    :param tags: A set of tags. Gets or sets a list of key value pairs that describe the resource.
     These tags can be used in viewing and grouping this resource (across resource groups). A
     maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in
     length than 128 characters and a value no greater in length than 256 characters.
    :type tags: dict[str, str]
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.storage.v2021_04_01.models.Identity
    :param kind: Optional. Indicates the type of storage account. Currently only StorageV2 value
     supported by server. Possible values include: "Storage", "StorageV2", "BlobStorage",
     "FileStorage", "BlockBlobStorage".
    :type kind: str or ~azure.mgmt.storage.v2021_04_01.models.Kind
    :param custom_domain: Custom domain assigned to the storage account by the user. Name is the
     CNAME source. Only one custom domain is supported per storage account at this time. To clear
     the existing custom domain, use an empty string for the custom domain name property.
    :type custom_domain: ~azure.mgmt.storage.v2021_04_01.models.CustomDomain
    :param encryption: Provides the encryption settings on the account. The default setting is
     unencrypted.
    :type encryption: ~azure.mgmt.storage.v2021_04_01.models.Encryption
    :param sas_policy: SasPolicy assigned to the storage account.
    :type sas_policy: ~azure.mgmt.storage.v2021_04_01.models.SasPolicy
    :param key_policy: KeyPolicy assigned to the storage account.
    :type key_policy: ~azure.mgmt.storage.v2021_04_01.models.KeyPolicy
    :param access_tier: Required for storage accounts where kind = BlobStorage. The access tier
     used for billing. Possible values include: "Hot", "Cool".
    :type access_tier: str or ~azure.mgmt.storage.v2021_04_01.models.AccessTier
    :param azure_files_identity_based_authentication: Provides the identity based authentication
     settings for Azure Files.
    :type azure_files_identity_based_authentication:
     ~azure.mgmt.storage.v2021_04_01.models.AzureFilesIdentityBasedAuthentication
    :param enable_https_traffic_only: Allows https traffic only to storage service if sets to true.
    :type enable_https_traffic_only: bool
    :param network_rule_set: Network rule set.
    :type network_rule_set: ~azure.mgmt.storage.v2021_04_01.models.NetworkRuleSet
    :param large_file_shares_state: Allow large file shares if sets to Enabled. It cannot be
     disabled once it is enabled. Possible values include: "Disabled", "Enabled".
    :type large_file_shares_state: str or
     ~azure.mgmt.storage.v2021_04_01.models.LargeFileSharesState
    :param routing_preference: Maintains information about the network routing choice opted by the
     user for data transfer.
    :type routing_preference: ~azure.mgmt.storage.v2021_04_01.models.RoutingPreference
    :param allow_blob_public_access: Allow or disallow public access to all blobs or containers in
     the storage account. The default interpretation is true for this property.
    :type allow_blob_public_access: bool
    :param minimum_tls_version: Set the minimum TLS version to be permitted on requests to storage.
     The default interpretation is TLS 1.0 for this property. Possible values include: "TLS1_0",
     "TLS1_1", "TLS1_2".
    :type minimum_tls_version: str or ~azure.mgmt.storage.v2021_04_01.models.MinimumTlsVersion
    :param allow_shared_key_access: Indicates whether the storage account permits requests to be
     authorized with the account access key via Shared Key. If false, then all requests, including
     shared access signatures, must be authorized with Azure Active Directory (Azure AD). The
     default value is null, which is equivalent to true.
    :type allow_shared_key_access: bool
    :param allow_cross_tenant_replication: Allow or disallow cross AAD tenant object replication.
     The default interpretation is true for this property.
    :type allow_cross_tenant_replication: bool
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'custom_domain': {'key': 'properties.customDomain', 'type': 'CustomDomain'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'sas_policy': {'key': 'properties.sasPolicy', 'type': 'SasPolicy'},
        'key_policy': {'key': 'properties.keyPolicy', 'type': 'KeyPolicy'},
        'access_tier': {'key': 'properties.accessTier', 'type': 'str'},
        'azure_files_identity_based_authentication': {'key': 'properties.azureFilesIdentityBasedAuthentication', 'type': 'AzureFilesIdentityBasedAuthentication'},
        'enable_https_traffic_only': {'key': 'properties.supportsHttpsTrafficOnly', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkAcls', 'type': 'NetworkRuleSet'},
        'large_file_shares_state': {'key': 'properties.largeFileSharesState', 'type': 'str'},
        'routing_preference': {'key': 'properties.routingPreference', 'type': 'RoutingPreference'},
        'allow_blob_public_access': {'key': 'properties.allowBlobPublicAccess', 'type': 'bool'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'allow_shared_key_access': {'key': 'properties.allowSharedKeyAccess', 'type': 'bool'},
        'allow_cross_tenant_replication': {'key': 'properties.allowCrossTenantReplication', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountUpdateParameters, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.custom_domain = kwargs.get('custom_domain', None)
        self.encryption = kwargs.get('encryption', None)
        self.sas_policy = kwargs.get('sas_policy', None)
        self.key_policy = kwargs.get('key_policy', None)
        self.access_tier = kwargs.get('access_tier', None)
        self.azure_files_identity_based_authentication = kwargs.get('azure_files_identity_based_authentication', None)
        self.enable_https_traffic_only = kwargs.get('enable_https_traffic_only', None)
        self.network_rule_set = kwargs.get('network_rule_set', None)
        self.large_file_shares_state = kwargs.get('large_file_shares_state', None)
        self.routing_preference = kwargs.get('routing_preference', None)
        self.allow_blob_public_access = kwargs.get('allow_blob_public_access', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.allow_shared_key_access = kwargs.get('allow_shared_key_access', None)
        self.allow_cross_tenant_replication = kwargs.get('allow_cross_tenant_replication', None)


class StorageQueue(Resource):
    """StorageQueue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param metadata: A name-value pair that represents queue metadata.
    :type metadata: dict[str, str]
    :ivar approximate_message_count: Integer indicating an approximate number of messages in the
     queue. This number is not lower than the actual number of messages in the queue, but could be
     higher.
    :vartype approximate_message_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'approximate_message_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'approximate_message_count': {'key': 'properties.approximateMessageCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageQueue, self).__init__(**kwargs)
        self.metadata = kwargs.get('metadata', None)
        self.approximate_message_count = None


class StorageSkuListResult(msrest.serialization.Model):
    """The response from the List Storage SKUs operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Get the list result of storage SKUs and their properties.
    :vartype value: list[~azure.mgmt.storage.v2021_04_01.models.SkuInformation]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuInformation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageSkuListResult, self).__init__(**kwargs)
        self.value = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.storage.v2021_04_01.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.storage.v2021_04_01.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class Table(Resource):
    """Properties of the table, including Id, resource name, resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar table_name: Table name under the specified account.
    :vartype table_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'table_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Table, self).__init__(**kwargs)
        self.table_name = None


class TableServiceProperties(Resource):
    """The properties of a storage account’s Table service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param cors: Specifies CORS rules for the Table service. You can include up to five CorsRule
     elements in the request. If no CorsRule elements are included in the request body, all CORS
     rules will be deleted, and CORS will be disabled for the Table service.
    :type cors: ~azure.mgmt.storage.v2021_04_01.models.CorsRules
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cors': {'key': 'properties.cors', 'type': 'CorsRules'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TableServiceProperties, self).__init__(**kwargs)
        self.cors = kwargs.get('cors', None)


class TagFilter(msrest.serialization.Model):
    """Blob index tag based filtering for blob objects.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. This is the filter tag name, it can have 1 - 128 characters.
    :type name: str
    :param op: Required. This is the comparison operator which is used for object comparison and
     filtering. Only == (equality operator) is currently supported.
    :type op: str
    :param value: Required. This is the filter tag value field used for tag based filtering, it can
     have 0 - 256 characters.
    :type value: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 128, 'min_length': 1},
        'op': {'required': True},
        'value': {'required': True, 'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'op': {'key': 'op', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagFilter, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.op = kwargs['op']
        self.value = kwargs['value']


class TagProperty(msrest.serialization.Model):
    """A tag of the LegalHold of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tag: The tag value.
    :vartype tag: str
    :ivar timestamp: Returns the date and time the tag was added.
    :vartype timestamp: ~datetime.datetime
    :ivar object_identifier: Returns the Object ID of the user who added the tag.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user who added the tag.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who added the tag.
    :vartype upn: str
    """

    _validation = {
        'tag': {'readonly': True},
        'timestamp': {'readonly': True},
        'object_identifier': {'readonly': True},
        'tenant_id': {'readonly': True},
        'upn': {'readonly': True},
    }

    _attribute_map = {
        'tag': {'key': 'tag', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'object_identifier': {'key': 'objectIdentifier', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagProperty, self).__init__(**kwargs)
        self.tag = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class UpdateHistoryProperty(msrest.serialization.Model):
    """An update history of the ImmutabilityPolicy of a blob container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar update: The ImmutabilityPolicy update type of a blob container, possible values include:
     put, lock and extend. Possible values include: "put", "lock", "extend".
    :vartype update: str or ~azure.mgmt.storage.v2021_04_01.models.ImmutabilityPolicyUpdateType
    :ivar immutability_period_since_creation_in_days: The immutability period for the blobs in the
     container since the policy creation, in days.
    :vartype immutability_period_since_creation_in_days: int
    :ivar timestamp: Returns the date and time the ImmutabilityPolicy was updated.
    :vartype timestamp: ~datetime.datetime
    :ivar object_identifier: Returns the Object ID of the user who updated the ImmutabilityPolicy.
    :vartype object_identifier: str
    :ivar tenant_id: Returns the Tenant ID that issued the token for the user who updated the
     ImmutabilityPolicy.
    :vartype tenant_id: str
    :ivar upn: Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
    :vartype upn: str
    """

    _validation = {
        'update': {'readonly': True},
        'immutability_period_since_creation_in_days': {'readonly': True},
        'timestamp': {'readonly': True},
        'object_identifier': {'readonly': True},
        'tenant_id': {'readonly': True},
        'upn': {'readonly': True},
    }

    _attribute_map = {
        'update': {'key': 'update', 'type': 'str'},
        'immutability_period_since_creation_in_days': {'key': 'immutabilityPeriodSinceCreationInDays', 'type': 'int'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'object_identifier': {'key': 'objectIdentifier', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'upn': {'key': 'upn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateHistoryProperty, self).__init__(**kwargs)
        self.update = None
        self.immutability_period_since_creation_in_days = None
        self.timestamp = None
        self.object_identifier = None
        self.tenant_id = None
        self.upn = None


class Usage(msrest.serialization.Model):
    """Describes Storage Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unit: Gets the unit of measurement. Possible values include: "Count", "Bytes", "Seconds",
     "Percent", "CountsPerSecond", "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.storage.v2021_04_01.models.UsageUnit
    :ivar current_value: Gets the current count of the allocated resources in the subscription.
    :vartype current_value: int
    :ivar limit: Gets the maximum count of the resources that can be allocated in the subscription.
    :vartype limit: int
    :ivar name: Gets the name of the type of usage.
    :vartype name: ~azure.mgmt.storage.v2021_04_01.models.UsageName
    """

    _validation = {
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageListResult(msrest.serialization.Model):
    """The response from the List Usages operation.

    :param value: Gets or sets the list of Storage Resource Usages.
    :type value: list[~azure.mgmt.storage.v2021_04_01.models.Usage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class UsageName(msrest.serialization.Model):
    """The usage names that can be used; currently limited to StorageAccount.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Gets a string describing the resource name.
    :vartype value: str
    :ivar localized_value: Gets a localized string describing the resource name.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class UserAssignedIdentity(msrest.serialization.Model):
    """UserAssignedIdentity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VirtualNetworkRule(msrest.serialization.Model):
    """Virtual Network rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param virtual_network_resource_id: Required. Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_resource_id: str
    :ivar action: The action of virtual network rule. Default value: "Allow".
    :vartype action: str
    :param state: Gets the state of virtual network rule. Possible values include: "Provisioning",
     "Deprovisioning", "Succeeded", "Failed", "NetworkSourceDeleted".
    :type state: str or ~azure.mgmt.storage.v2021_04_01.models.State
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
        'action': {'constant': True},
    }

    _attribute_map = {
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    action = "Allow"

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_resource_id = kwargs['virtual_network_resource_id']
        self.state = kwargs.get('state', None)
