# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VirtualMachineScaleSetUpdateOSProfile(Model):
    """Describes a virtual machine scale set OS profile.

    :param custom_data: A base-64 encoded string of custom data.
    :type custom_data: str
    :param windows_configuration: The Windows Configuration of the OS profile.
    :type windows_configuration: :class:`WindowsConfiguration
     <azure.mgmt.compute.v2017_03_30.models.WindowsConfiguration>`
    :param linux_configuration: The Linux Configuration of the OS profile.
    :type linux_configuration: :class:`LinuxConfiguration
     <azure.mgmt.compute.v2017_03_30.models.LinuxConfiguration>`
    :param secrets: The List of certificates for addition to the VM.
    :type secrets: list of :class:`VaultSecretGroup
     <azure.mgmt.compute.v2017_03_30.models.VaultSecretGroup>`
    """

    _attribute_map = {
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(self, custom_data=None, windows_configuration=None, linux_configuration=None, secrets=None):
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets
