# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OSDisk(Model):
    """Describes an Operating System disk.

    :param os_type: The Operating System type. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or :class:`OperatingSystemTypes
     <azure.mgmt.compute.v2016_04_30_preview.models.OperatingSystemTypes>`
    :param encryption_settings: The disk encryption settings.
    :type encryption_settings: :class:`DiskEncryptionSettings
     <azure.mgmt.compute.v2016_04_30_preview.models.DiskEncryptionSettings>`
    :param name: The disk name.
    :type name: str
    :param vhd: The virtual hard disk.
    :type vhd: :class:`VirtualHardDisk
     <azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk>`
    :param image: The source user image virtual hard disk. The virtual hard
     disk will be copied before using it to attach to the virtual machine. If
     SourceImage is provided, the destination virtual hard disk must not exist.
    :type image: :class:`VirtualHardDisk
     <azure.mgmt.compute.v2016_04_30_preview.models.VirtualHardDisk>`
    :param caching: The caching type. Possible values include: 'None',
     'ReadOnly', 'ReadWrite'
    :type caching: str or :class:`CachingTypes
     <azure.mgmt.compute.v2016_04_30_preview.models.CachingTypes>`
    :param create_option: The create option. Possible values include:
     'fromImage', 'empty', 'attach'
    :type create_option: str or :class:`DiskCreateOptionTypes
     <azure.mgmt.compute.v2016_04_30_preview.models.DiskCreateOptionTypes>`
    :param disk_size_gb: The initial disk size, in GB, for blank data disks,
     and the new desired size for resizing existing OS and data disks.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk: :class:`ManagedDiskParameters
     <azure.mgmt.compute.v2016_04_30_preview.models.ManagedDiskParameters>`
    """

    _validation = {
        'create_option': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'OperatingSystemTypes'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': 'DiskEncryptionSettings'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'CachingTypes'},
        'create_option': {'key': 'createOption', 'type': 'DiskCreateOptionTypes'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
    }

    def __init__(self, create_option, os_type=None, encryption_settings=None, name=None, vhd=None, image=None, caching=None, disk_size_gb=None, managed_disk=None):
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
