# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .http_authentication import HttpAuthentication


class ClientCertAuthentication(HttpAuthentication):
    """ClientCertAuthentication

    :param str type: Gets or sets the http authentication type. Possible
     values include: 'NotSpecified', 'ClientCertificate',
     'ActiveDirectoryOAuth', 'Basic'
    :param str password: Gets or sets the password.
    :param str pfx: Gets or sets the pfx.
    :param str certificate_thumbprint: Gets or sets the certificate
     thumbprint.
    :param datetime certificate_expiration_date: Gets or sets the certificate
     expiration date.
    :param str certificate_subject_name: Gets or sets the certificate subject
     name.
    """

    _required = []

    _attribute_map = {
        'password': {'key': 'password', 'type': 'str'},
        'pfx': {'key': 'pfx', 'type': 'str'},
        'certificate_thumbprint': {'key': 'certificateThumbprint', 'type': 'str'},
        'certificate_expiration_date': {'key': 'certificateExpirationDate', 'type': 'iso-8601'},
        'certificate_subject_name': {'key': 'certificateSubjectName', 'type': 'str'},
    }

    def __init__(self, type=None, password=None, pfx=None, certificate_thumbprint=None, certificate_expiration_date=None, certificate_subject_name=None):
        super(ClientCertAuthentication, self).__init__(type=type)
        self.password = password
        self.pfx = pfx
        self.certificate_thumbprint = certificate_thumbprint
        self.certificate_expiration_date = certificate_expiration_date
        self.certificate_subject_name = certificate_subject_name
