from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

microchip_pic18mcu = SchLib(tool=SKIDL).add_parts(*[
        Part(name='PIC18F13K50-E/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8bit CMOS Microcontroller XLP',description='16K Flash, 768 SRAM, 256 EEPROM, USB, nanoWatt XLP, DIP20',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'PDIP*W7.62mm*'],do_erc=True,aliases=['PIC18F14K50-E/P', 'PIC18LF14K50-E/P', 'PIC18LF13K50-E/P'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RA5/IOCA5/OSC1/CLKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA4/IOCA3/AN3/OSC2/CLKOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA3/IOCA3/~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='T0CKI/CCP1/P1A/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SRQ/C12OUT/P1B/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PGM/C12IN3-/P1C/AN7/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='T1OSCI/T13CKI/SS/AN8/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='T1OSCO/SDO/AN9/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7/IOCB7/TX/CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6/IOCB6/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB5/IOCB5/AN11/RX/DT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB4/IOCB4/AN10/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='INT2/CVREF/C12IN2-/P1D/AN6/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='INT1/C12IN1-/VREF-AN5/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='INT0/C12IN+/VREF+/AN4/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VUSB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='RA1/IOCA1/D-/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/IOCA0/D+/PGD',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F13K50-E/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8bit CMOS Microcontroller XLP',description='16K Flash, 768 SRAM, 256 EEPROM, USB, nanoWatt XLP, SOIC20',ref_prefix='U',num_units=1,fplist=['SOIC*W*7.5x12.8mm*Pitch1.27mm*'],do_erc=True,aliases=['PIC18LF13K50-E/SO', 'PIC18LF14K50-E/SO', 'PIC18F14K50-E/SO'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RA5/IOCA5/OSC1/CLKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA4/IOCA3/AN3/OSC2/CLKOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA3/IOCA3/~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='T0CKI/CCP1/P1A/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SRQ/C12OUT/P1B/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PGM/C12IN3-/P1C/AN7/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='T1OSCI/T13CKI/SS/AN8/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='T1OSCO/SDO/AN9/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7/IOCB7/TX/CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6/IOCB6/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB5/IOCB5/AN11/RX/DT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB4/IOCB4/AN10/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='INT2/CVREF/C12IN2-/P1D/AN6/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='INT1/C12IN1-/VREF-AN5/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='INT0/C12IN+/VREF+/AN4/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VUSB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='RA1/IOCA1/D-/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/IOCA0/D+/PGD',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F13K50-E/SS',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8bit CMOS Microcontroller XLP',description='16K Flash, 768 SRAM, 256 EEPROM, USB, nanoWatt XLP, SSOP20',ref_prefix='U',num_units=1,fplist=['SSOP*5.3x7.2mm*'],do_erc=True,aliases=['PIC18LF13K50-E/SS', 'PIC18LF14K50-E/SS', 'PIC18F14K50-E/SS'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RA5/IOCA5/OSC1/CLKIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA4/IOCA3/AN3/OSC2/CLKOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA3/IOCA3/~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='T0CKI/CCP1/P1A/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SRQ/C12OUT/P1B/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PGM/C12IN3-/P1C/AN7/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='T1OSCI/T13CKI/SS/AN8/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='T1OSCO/SDO/AN9/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7/IOCB7/TX/CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6/IOCB6/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB5/IOCB5/AN11/RX/DT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB4/IOCB4/AN10/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='INT2/CVRef/C12IN2-/P1D/AN6/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='INT1/C12IN1-/VREF-AN5/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='INT0/C12IN+/VREF+/AN4/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VUSB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='RA1/IOCA1/D-/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/IOCA0/D+/PGD',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F2331-I/ML',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 768B SRAM, 256B EEPROM, nanoWatt XLP, ADC, PWM, QFN28',ref_prefix='U',num_units=1,fplist=['QFN*1EP*6x6mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18LF2331-I/ML', 'PIC18LF2431-I/ML', 'PIC18F2431-I/ML'],pins=[
            Pin(num='1',name='RA2/AN2/Vref-/CAP1/INDX',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3/AN3/Vref+/CAP2/QEA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA4/AN4/CAP3/QEB',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='RA7/OSC1/CLKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~FLTA~/T1OSI/CCP2/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~FLTB~/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RB2/PWM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='INT0/T5CKI/T0CKI/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB3/PWM3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='INT1/SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB4/KBI0/PWM5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='INT2/SCK/SCL/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB5/KBI1/PWM4/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TX/~SS~/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RX/SDO/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RB0/PWM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RB1/PWM1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F2331-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 768B SRAM, 256B EEPROM, nanoWatt XLP, ADC, PWM, SOIC28',ref_prefix='U',num_units=1,fplist=['SO*W*7.5x17.9mm*Pitch1.27mm*'],do_erc=True,aliases=['PIC18LF2331-I/SO', 'PIC18LF2431-I/SO', 'PIC18F2431-I/SO'],pins=[
            Pin(num='1',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-/CAP1/INDX',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+/CAP2/QEA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/AN4/CAP3/QEB',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RA7/OSC1/CLKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/PWM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='~FLTA~/T1OSI/CCP2/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/PWM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='~FLTB~/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/PWM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='INT0/T5CKI/T0CKI/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/PWM3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='INT1/SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RB4/KBI0/PWM5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='INT2/SCK/SCL/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RB5/KBI1/PWM4/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TX/~SS~/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RX/SDO/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F2331-I/SP',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 768B SRAM, 256B EEPROM, nanoWatt XLP, ADC, PWM, SPDIP28',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'PDIP*W7.62mm*'],do_erc=True,aliases=['PIC18LF2331-I/SP', 'PIC18LF2431-I/SP', 'PIC18F2431-I/SP'],pins=[
            Pin(num='1',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-/CAP1/INDX',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+/CAP2/QEA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/AN4/CAP3/QEB',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RA7/OSC1/CLKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/PWM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='~FLTA~/T1OSI/CCP2/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/PWM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='~FLTB~/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/PWM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='INT0/T5CKI/T0CKI/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/PWM3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='INT1/SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RB4/KBI0/PWM5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='INT2/SCK/SCL/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RB5/KBI1/PWM4/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TX/~SS~/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RX/SDO/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F2450-I/ML',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 8K SRAM, USB, nanoWatt XLP, QFN28',ref_prefix='U',num_units=1,fplist=['QFN*1EP*6x6mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18LF2450-I/ML'],pins=[
            Pin(num='1',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA4/T0CKI/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA5/AN4/HLVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='OSC1/CLKI',do_erc=True),
            Pin(num='7',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~UOE~/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB3/AN9/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB4/AN11/KBI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RB0/AN12/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RB1/AN10/INT1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F2450-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 8K SRAM, USB, nanoWatt XLP, SOIC28',ref_prefix='U',num_units=1,fplist=['SOIC*W*7.5x12.8mm*Pitch1.27mm*'],do_erc=True,aliases=['PIC18LF2450-I/SO'],pins=[
            Pin(num='1',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/T0CKI/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/HLVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='OSC1/CLKI',do_erc=True),
            Pin(num='10',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/AN12/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='~UOE~/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/AN10/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/AN9/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RB4/AN11/KBI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F2450-I/SP',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 8K SRAM, USB, nanoWatt XLP, SPDIP28',ref_prefix='U',num_units=1,fplist=['SPDIP*W7.62mm*', 'DIP*W7.62mm*', 'PDIP*W7.62mm*'],do_erc=True,aliases=['PIC18LF2450-I/SP'],pins=[
            Pin(num='1',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/T0CKI/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/HLVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='OSC1/CLKI',do_erc=True),
            Pin(num='10',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/AN12/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='~UOE~/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/AN10/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/AN9/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RB4/AN11/KBI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F2455-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='32K Flash, 2K SRAM, 256 EEPROM, USB, nanoWatt XLP, SOIC28',ref_prefix='U',num_units=1,fplist=['SO*W*7.5x17.9mm_Pitch1.27mm*'],do_erc=True,aliases=['PIC18LF2455-I/SO', 'PIC18LF2550-I/SO', 'PIC18F2550-I/SO'],pins=[
            Pin(num='1',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/T0CKI/C1OUT/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/~SS~/HLVDIN/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='OSC1/CLKI',do_erc=True),
            Pin(num='10',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='T1OSO/T13CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/AN12/INT0/FLT0/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='~UOE~/CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/AN10/INT1/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/AN9/CCP2/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RB4/AN11/KBI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SDO/RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F2455-I/SP',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='32K Flash, 2K SRAM, 256 EEPROM, USB, nanoWatt XLP, SPDIP28',ref_prefix='U',num_units=1,fplist=['SPDIP*28_W7.62mm*', 'DIP*28_W7.62mm*', 'PDIP*28_W7.62mm*'],do_erc=True,aliases=['PIC18LF2455-I/SP', 'PIC18LF2550-I/SP', 'PIC18F2550-I/SP'],pins=[
            Pin(num='1',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/T0CKI/C1OUT/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/~SS~/HLVDIN/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='OSC1/CLKI',do_erc=True),
            Pin(num='10',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='T1OSO/T13CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RB0/AN12/INT0/FLT0/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='~UOE~/CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RB1/AN10/INT1/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RB3/AN9/CCP2/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RB4/AN11/KBI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SDO/RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F4331-I/ML',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 768B SRAM, 256B EEPROM, nanoWatt XLP, ADC, PWM, QFN44',ref_prefix='U',num_units=1,fplist=['QFN*1EP*8x8mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18LF4331-I/ML', 'PIC18LF4431-I/ML', 'PIC18F4431-I/ML'],pins=[
            Pin(num='1',name='RX/SDO/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='~FLTA~/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PWM4/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PWM6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PWM7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RB0/PWM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB1/PWM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='40',name='SDA/SDI/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB2/PWM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-/CAP1/INDX',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='SCL/SCK/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB3/PWM3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+/CAP2/QEA',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RA7/OSC1/CLKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='INT1/SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RA4/AN4/CAP3/QEB',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='INT2/SCK/SCL/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/KBI0/PWM5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN5/LVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TX/~SS~/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/KBI1/PWM4/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~FLTA~/T1OSI/CCP2/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='AN7/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='~FLTB~/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AN8/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='INT0/T5CKI/T0CKI/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='T5CKI/T0CKI/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='SDO/RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4331-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 768B SRAM, 256B EEPROM, nanoWatt XLP, ADC, PWM, DIP40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24*', 'PDIP*W15.24*'],do_erc=True,aliases=['PIC18LF4331-I/P', 'PIC18LF4431-I/P', 'PIC18F4431-I/P'],pins=[
            Pin(num='1',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-/CAP1/INDX',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+/CAP2/QEA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/AN4/CAP3/QEB',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN5/LVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='AN6/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AN7/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AN8/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SDO/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PWM7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='SDA/SDI/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='SCL/SCK/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='RA7/OSC1/CLKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='INT1/SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RB0/PWM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='INT2/SCK/SCL/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='RB1/PWM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TX/~SS~/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RB2/PWM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~FLTA~/T1OSI/CCP2/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RX/SDO/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RB3/PWM3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='~FLTB~/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='~FLTA~/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RB4/KBI0/PWM5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='INT0/T5CKI/T0CKI/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PWM4/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='RB5/KBI1/PWM4/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='T5CKI/T0CKI/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PWM6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4331-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 768B SRAM, 256B EEPROM, nanoWatt XLP, ADC, PWM, TQFP44',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,aliases=['PIC18LF4331-I/PT', 'PIC18LF4431-I/PT', 'PIC18F4431-I/PT'],pins=[
            Pin(num='1',name='RX/SDO/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='~FLTA~/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PWM4/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PWM6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PWM7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RB0/PWM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB1/PWM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB2/PWM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='RA7/OSC1/CLKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='SDA/SDI/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB3/PWM3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-/CAP1/INDX',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='SCL/SCK/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+/CAP2/QEA',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='INT1/SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RA4/AN4/CAP3/QEB',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='INT2/SCK/SCL/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/KBI0/PWM5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN5/LVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TX/~SS~/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/KBI1/PWM4/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN6/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~FLTA~/T1OSI/CCP2/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='AN7/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='~FLTB~/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AN8/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='INT0/T5CKI/T0CKI/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='T5CKI/T0CKI/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='33',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='34',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='39',name='SDO/RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F442-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller',description='32K Flash, 1536B SRAM, 256 EEPROM, ADC, DIP40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['PIC18LF442-I/P', 'PIC18LF452-I/P', 'PIC18F452-I/P'],pins=[
            Pin(num='1',name='~MCLR~/VPP',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/TOCKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/~SS~/LVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='~RD~/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~WR~/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~CS~/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PSP1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PSP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RB7/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='PSP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='PSP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='OSC1/CLKIN',do_erc=True),
            Pin(num='23',name='SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RB0/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='SDO/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='RB1/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='T10S0/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RB2/INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RB3/CCP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PSP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SCK/SCL/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PSP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='RB5/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='PSP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PSP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='RB6/PGC',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F442-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller',description='32K Flash, 1536B SRAM, 256 EEPROM, ADC, TQFP-44',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,aliases=['PIC18LF442-I/PT', 'PIC18LF452-I/PT', 'PIC18F452-I/PT'],pins=[
            Pin(num='1',name='DT/RX/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PSP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PSP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PSP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PSP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='33',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='34',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RB0/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB1/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB2/INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI',do_erc=True),
            Pin(num='40',name='PSP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB3/CCP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PSP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RA4/T0CKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='SDO/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN4/~SS~/LVDin',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='CK/TX/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='~RD~/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='T1OSI/CCP2/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB6/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~WR~/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='~CS~/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SCK/SCL/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PSP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='PSP1/RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4450-I/ML',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 8K SRAM, USB, nanoWatt XLP, QFN44',ref_prefix='U',num_units=1,fplist=['QFN*1EP*8x8mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18LF4450-I/ML'],pins=[
            Pin(num='1',name='RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RB0/AN12/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB1/AN10/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='40',name='RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB3/AN9/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='OSC1/CLKI',do_erc=True),
            Pin(num='42',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RA4/T0CKI/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/AN11/KBI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN4/HLVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~UOE~/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4450-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 8K SRAM, USB, nanoWatt XLP, PDIP40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['PIC18LF4450-I/P'],pins=[
            Pin(num='1',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/T0CKI/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/HLVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='OSC1/CLKI',do_erc=True),
            Pin(num='23',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RB0/AN12/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='RB1/AN10/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~UOE~/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RB3/AN9/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RB4/AN11/KBI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4450-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='16K Flash, 8K SRAM, USB, nanoWatt XLP, TQFP44',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,aliases=['PIC18LF4450-I/PT'],pins=[
            Pin(num='1',name='RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RB0/AN12/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB1/AN10/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI',do_erc=True),
            Pin(num='40',name='RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB3/AN9/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='41',name='RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ICCK/ICPGC)',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='T1OSO/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ICDT/ICPGD)',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RA4/T0CKI/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(~ICRST~/ICVpp)',do_erc=True),
            Pin(num='43',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/AN11/KBI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN4/HLVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ICPORTS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~UOE~/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4455-I/ML',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='32K Flash, 2K SRAM, 256 EEPROM, USB, nanoWatt XLP, QFN44',ref_prefix='U',num_units=1,fplist=['QFN*1EP*8x8mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18LF4455-I/ML', 'PIC18LF4550-I/ML', 'PIC18F4550-I/ML'],pins=[
            Pin(num='1',name='SDO/RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SPP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P1B/SPP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P1C/SPP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1D/SPP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RB0/AN12/INT0/FLT0/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB1/AN10/INT1/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='SPP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='SPP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB3/AN9/CCP2/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='OSC1/CLKI',do_erc=True),
            Pin(num='42',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RA4/T0CKI/C1OUT/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/AN11/KBI0/CSSPP',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN4/~SS~/HLVDIN/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='T1OSO/T13CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='CK1SPP/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~UOE~/CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='CK2SPP/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1A/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='OESPP/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='SPP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='SPP1/RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4455-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='32K Flash, 2K SRAM, 256 EEPROM, USB, nanoWatt XLP, DIP40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['PIC18LF4455-I/P', 'PIC18LF4550-I/P', 'PIC18F4550-I/P'],pins=[
            Pin(num='1',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/T0CKI/C1OUT/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/~SS~/HLVDIN/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CK1SPP/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CK2SPP/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='OESPP/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SPP1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P1D/SPP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='SPP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='SPP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='OSC1/CLKI',do_erc=True),
            Pin(num='23',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RB0/AN12/INT0/FLT0/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='RB1/AN10/INT1/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='T1OSO/T13CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~UOE~/CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='SDO/RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RB3/AN9/CCP2/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P1A/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='SPP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RB4/AN11/KBI0/CSSPP',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P1B/SPP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SPP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P1C/SPP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4455-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='32K Flash, 2K SRAM, 256 EEPROM, USB, nanoWatt XLP, TQFP44',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,aliases=['PIC18LF4455-I/PT', 'PIC18LF4550-I/PT', 'PIC18F4550-I/PT'],pins=[
            Pin(num='1',name='SDO/RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SPP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P1B/SPP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P1C/SPP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1D/SPP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RB0/AN12/INT0/FLT0/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB1/AN10/INT1/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI',do_erc=True),
            Pin(num='40',name='SPP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB3/AN9/CCP2/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='41',name='SPP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ICCK/ICPGC)',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='T1OSO/T13CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ICDT/ICPGD)',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RA4/T0CKI/C1OUT/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(~ICRST~/ICVpp)',do_erc=True),
            Pin(num='43',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/AN11/KBI0/CSSPP',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN4/~SS~/HLVDIN/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ICPORTS)',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='CK1SPP/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~UOE~/CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='CK2SPP/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1A/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='OESPP/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='SPP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='SPP1/RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4458-I/ML',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='32K Flash, 2K SRAM, 256 EEPROM, USB, 12-Bit A/D, nanoWatt XLP, QFN44',ref_prefix='U',num_units=1,fplist=['QFN*1EP*8x8mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18LF4458-I/ML', 'PIC18F4553-I/ML', 'PIC18LF4553-I/ML'],pins=[
            Pin(num='1',name='SDO/RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SPP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P1B/SPP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P1C/SPP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1D/SPP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RB0/AN12/INT0/FLT0/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB1/AN10/INT1/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='SPP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='SPP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB3/AN9/CCP2/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='OSC1/CLKI',do_erc=True),
            Pin(num='42',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='23',name='RA4/T0CKI/C1OUT/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/AN11/KBI0/CSSPP',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN4/~SS~/HLVDIN/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='T1OSO/T13CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='CK1SPP/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~UOE~/CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PAD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='CK2SPP/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1A/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='OESPP/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='SPP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='SPP1/RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4458-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='32K Flash, 2K SRAM, 256 EEPROM, USB, 12-Bit A/D, nanoWatt XLP, DIP40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['PIC18LF4458-I/P', 'PIC18F4553-I/P', 'PIC18LF4553-I/P'],pins=[
            Pin(num='1',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/T0CKI/C1OUT/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/~SS~/HLVDIN/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CK1SPP/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CK2SPP/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='OESPP/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='SPP1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P1D/SPP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='SPP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='SPP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='OSC1/CLKI',do_erc=True),
            Pin(num='23',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RB0/AN12/INT0/FLT0/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='RB1/AN10/INT1/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='T1OSO/T13CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~UOE~/CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='SDO/RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RB3/AN9/CCP2/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P1A/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='SPP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RB4/AN11/KBI0/CSSPP',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P1B/SPP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SPP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P1C/SPP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F4458-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller XLP',description='32K Flash, 2K SRAM, 256 EEPROM, USB, 12-Bit A/D, nanoWatt XLP, TQFP44',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,aliases=['PIC18LF4458-I/PT', 'PIC18F4553-I/PT', 'PIC18LF4553-I/PT'],pins=[
            Pin(num='1',name='SDO/RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SPP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P1B/SPP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P1C/SPP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1D/SPP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RB0/AN12/INT0/FLT0/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB1/AN10/INT1/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB2/AN8/INT2/VMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKI',do_erc=True),
            Pin(num='40',name='SPP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB3/AN9/CCP2/VPO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/AN2/Vref-/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='RA6/OSC2/CLKO',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='SPP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='(ICCK/ICPGC)',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='T1OSO/T13CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VM/D-/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='(ICDT/ICPGD)',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='RA4/T0CKI/C1OUT/RCV',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='(~ICRST~/ICVpp)',do_erc=True),
            Pin(num='43',name='VP/D+/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/AN11/KBI0/CSSPP',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN4/~SS~/HLVDIN/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='(ICPORTS)',do_erc=True),
            Pin(num='44',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='CK1SPP/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='~UOE~/CCP2/T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='CK2SPP/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P1A/CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='OESPP/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='Vpp/~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='SPP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='SPP1/RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F448-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller CAN',description='32K Flash, 1536B SRAM, 256 EEPROM, CAN, DIP40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['PIC18LF448-I/P', 'PIC18LF458-I/P', 'PIC18F458-I/P'],pins=[
            Pin(num='1',name='~MCLR~/VPP',do_erc=True),
            Pin(num='2',name='RA0/AN0/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/TOCKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/AN4/~SS~/LVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='~RD~/AN5/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='C1OUT/~WR~/AN6/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='C2OUT/~CS~/AN7/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='C1IN-/PSP1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P1D/PSP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RB7/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='C2IN+/PSP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='C2IN-/PSP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='OSC1/CLKIN',do_erc=True),
            Pin(num='23',name='SDI/SDA/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RB0/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RA6/OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='SDO/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='RB1/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='T10S0/T1CKI/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TX/CK/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RB2/INT2/CANTX',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RX/DT/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RB3/CANRX',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P1A/ECCP1/PSP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SCK/SCL/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P1B/PSP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='RB5/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/PSP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P1C/PSP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='RB6/PGC',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F44J10-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller',description='32K Flash, 1K SRAM, ADC, DIP40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['PIC18LF44J10-I/P', 'PIC18LF45J10-I/P', 'PIC18F45J10-I/P'],pins=[
            Pin(num='1',name='~MCLR~',do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-/CVref',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='VDDCORE/VCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='RA5/AN4/~SS1~/C2OUT',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='~RD~/AN5/RE0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='~WR~/AN6/RE1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='~CS~/AN7/RE2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='PSP1/SDI2/SDA2/RD1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='PSP7/P1D/RD7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='40',name='RB7/KBI3/PGD',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='PSP2/SDO2/RD2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='PSP3/~SS2~/RD3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='OSC1/CLKI',do_erc=True),
            Pin(num='23',name='SDI1/SDA1/RC4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='33',name='RB0/INT0/FLT0/AN12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='OSC2/CLK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='SDO1/RC5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='34',name='RB1/INT1/AN10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='T1OSO/T1CKI/RC0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='TX/CK/RC6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='35',name='RB2/INT2/AN8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='T1OSI/CCP2/RC1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='RX/DT/RC7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='36',name='RB3/CCP2/AN9',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='P1A/CCP1/RC2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='PSP4/RD4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='37',name='RB4/KBI0/AN11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='SCK1/SCL1/RC3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='PSP5/P1B/RD5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='38',name='RB5/KBI1/T0CKI/C1OUT',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='PSP0/SCK2/SCL2/RD0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='PSP6/P1C/RD6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='39',name='RB6/KBI2/PGC',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='PIC18F4580-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller CAN',description='32K Flash, 768B SRAM, 256 EEPROM, ECAN, DIP40',ref_prefix='U',num_units=1,fplist=['DIP*W15.24mm*', 'PDIP*W15.24mm*'],do_erc=True,aliases=['PIC18LF4580-I/P', 'PIC18LF4480-I/P', 'PIC18F4480-I/P'],pins=[
            Pin(num='1',name='~MCLR~/VPP/RE3',do_erc=True),
            Pin(num='2',name='RA0/AN0/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/AN2/Vref-',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/AN3/Vref+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4/TOCKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RA5/ANA4/~SS~/HLVDIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='AN5/~RD~/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='C1OUT/AN6/~WR~/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='C2OUT/AN7/~CS~/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='C1IN-/PSP1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P1D/PSP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RB7/KBI3/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='C2IN+/PSP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='C2IN-/PSP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='OSC1/CLKI/RA7',do_erc=True),
            Pin(num='23',name='SDA/SDI/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='RB0/INT0/FLT0/AN10',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='OSC2/CLKO/RA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='SDO/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='RB1/INT1/AN8',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='T13CKI/T1OSO/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='CK/TX/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RB2/INT2/CANTX',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='T1OSI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='DT/RX/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RB3/CANRX',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P1A/ECCP1/PSP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='RB4/KBI0/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SCL/SCK/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P1B/PSP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='RB5/KBI1/PGM',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/PSP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P1C/PSP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='RB6/KBI2/PGC',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F45K80-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='microchip microcontroller PIC18 flash ECAN XLP nanoWatt',description='64K Flash, 3.5K RAM, 1K EEPROM PIC18 Microcontroller ADC PWM CAN SPI I2C USART in TQFP44 package',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.8mm*'],do_erc=True,aliases=['PIC18LF45K80-I/PT', 'PIC18LF46K80-I/PT', 'PIC18F46K80-I/PT'],pins=[
            Pin(num='1',name='RC7/CANRX/RX1/DT1/CCP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RD4/ECCP1/P1A/PSP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RD5/P1B/PSP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RD6/TX2/CK2/P1C/PSP6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RD7/RX2/DT2/P1D/PSP7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='AN10/FLT0/INT0/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AN8/CTDIN/INT1/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='CANTX/CTED1/INT2/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/C1INC/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKIN/RA7',do_erc=True),
            Pin(num='40',name='RD2/C2INA/PSP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='CANRX/CTED2/INT3/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VREF-/AN2/C2INC/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKOUT/RA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='41',name='RD3/C2INB/CTMUI/PSP3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='N/C',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='Vref+/AN3/RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RC0/SOSCO/SCLKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='RC4/SDA/SDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='N/C',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VDDCORE/VCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='N/C',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='RC5/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AN9/CTPLS/KBI0/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN4/HLVDIN/T1CKI/~SS~/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='N/C',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='RC6/CANTX/TX1/CK1/CCP3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='T0CKI/T3CKI/CCP5/KBI1/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RE0/AN5/~RD~',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RC1/SOSCI',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PGC/KBI2/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RE1/AN6/C1OUT/~WR~',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='RC2/T1G/CCP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='PGD/T3G/KBI3/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RE2/AN7/C2OUT/~CS~',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='RC3/REFO/SCL/SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='~MCLR~/RE3',do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='RD0/C1INA/PSP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='CVref/AN0/ULPWU/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='RD1/C1INB/PSP1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F1220-SO',dest=TEMPLATE,tool=SKIDL,keywords='RAM ADC UART PWM',description='18-Pin Flash Microcontroller 8K Flash 256byte RAM',ref_prefix='U',num_units=1,fplist=['SOIC*W*7.5x11.6mm*Pitch1.27mm*'],do_erc=True,aliases=['PIC18LF1220-SO', 'PIC18LF1320-SO', 'PIC18F1320-SO'],pins=[
            Pin(num='1',name='RA0/AN0',do_erc=True),
            Pin(num='2',name='RA1/AN1/LVDIN',do_erc=True),
            Pin(num='3',name='RA4/TOCKI',do_erc=True),
            Pin(num='4',name='~MCLR~/Vpp/RA5',do_erc=True),
            Pin(num='5',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='RA2/AN2/Vref-',do_erc=True),
            Pin(num='7',name='RA3/AN3/Vref+',do_erc=True),
            Pin(num='8',name='INT0/AN4/RB0',do_erc=True),
            Pin(num='9',name='INT1/CK/TX/AN5/RB1',do_erc=True),
            Pin(num='10',name='KBI0/DT/RX/AN6/RB4',do_erc=True),
            Pin(num='11',name='KBI1/PGM/RB5',do_erc=True),
            Pin(num='12',name='KBI2/P1C/T13CKI/T1OSO/PGC/RB6',do_erc=True),
            Pin(num='13',name='KBI3/P1D/T1OSI/PGD/RB7',do_erc=True),
            Pin(num='14',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='OSC2/CLKO/RA6',do_erc=True),
            Pin(num='16',name='OSC1/CLKI/RA7',do_erc=True),
            Pin(num='17',name='INT2/P1B/RB2',do_erc=True),
            Pin(num='18',name='P1A/CCP1/RB3',do_erc=True)]),
        Part(name='PIC18F23K20_I/SS',dest=TEMPLATE,tool=SKIDL,keywords='microcontroller PIC18F flash XLP',description='64K Flash, 3936Byte RAM, 1KByte EEPROM, PIC18 Microcontroller ADC PWM SPI I2C USART in SSOP28 package',ref_prefix='U',num_units=1,fplist=['SSOP*5.3x10.2mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18F24K20_I/SS', 'PIC18F25K20_I/SS', 'PIC18F26K20_I/SS'],pins=[
            Pin(num='1',name='~MCLR~/RE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/Vref-AN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/Vref+AN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RA4',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='RA5/AN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RA7/OSC1/CLKIN',do_erc=True),
            Pin(num='10',name='RA6/OSC2/CLKOUT',do_erc=True),
            Pin(num='20',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AN12/INT0/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='CCP2/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='AN10/INT1/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='CCP1/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='AN8/INT2/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SCL/SCK/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='AN9/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='SDA/SDI/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN11/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDO/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PGM/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TX/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PGC/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RX/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PGD/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='Vss',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F25K80_I/ML',dest=TEMPLATE,tool=SKIDL,keywords='microchip microcontroller PIC18 flash ECAN XLP nanoWatt',description='64K Flash, 3.5K RAM, 1K EEPROM PIC18 Microcontroller ADC PWM CAN SPI I2C USART in QFN28 package',ref_prefix='U',num_units=1,fplist=['QFN*1EP*6x6mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18F26K80_I/ML', 'PIC18LF25K80_I/ML', 'PIC18LF26K80_I/ML'],pins=[
            Pin(num='1',name='RA2/Vref-/AN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3/Vref+/AN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='Vcap',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RA5/AN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='OSC1/CLKIN',do_erc=True),
            Pin(num='7',name='OSC2/CLKOUT',do_erc=True),
            Pin(num='8',name='SOSCO/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SOSCI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='CCP2/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='CANTX/INT2/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SCL/SCK/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CANRX/INT3/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='SDA/SDI/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='AN9/ECCP1/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDO/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='CCP5/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='CANTX/TX1/CCP3/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PGC/TX2/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CANRX/RX1/CCP4/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PGD/RX2/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='~MCLR~/RE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AN10/INT0/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='AN8/INT1/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F25K80_I/SS',dest=TEMPLATE,tool=SKIDL,keywords='microchip microcontroller PIC18 flash ECAN XLP nanoWatt',description='64K Flash, 3.5K RAM, 1K EEPROM PIC18 Microcontroller ADC PWM CAN SPI I2C USART in SSOP28 package',ref_prefix='U',num_units=1,fplist=['SSOP*5.3x10.2mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18F26K80_I/SS', 'PIC18LF25K80_I/SS', 'PIC18LF26K80_I/SS'],pins=[
            Pin(num='1',name='~MCLR~/RE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA0/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA2/Vref-/AN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RA3/Vref+/AN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='Vcap',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='RA5/AN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='OSC1/CLKIN',do_erc=True),
            Pin(num='10',name='OSC2/CLKOUT',do_erc=True),
            Pin(num='11',name='SOSCO/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='AN10/INT0/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='SOSCI/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='AN8/INT1/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='CCP2/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='CANTX/INT2/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SCL/SCK/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='CANRX/INT3/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='SDA/SDI/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AN9/ECCP1/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SDO/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='CCP5/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='CANTX/TX1/CCP3/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='PGC/TX2/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='CANRX/RX1/CCP4/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PGD/RX2/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='Vss',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC18F45K80-I/ML',dest=TEMPLATE,tool=SKIDL,keywords='microchip microcontroller PIC18 flash ECAN XLP nanoWatt',description='64K Flash, 3.5K RAM, 1K EEPROM PIC18 Microcontroller ADC PWM CAN SPI I2C USART in QFN44 package',ref_prefix='U',num_units=1,fplist=['QFN*1EP*8x8mm*Pitch0.65mm*'],do_erc=True,aliases=['PIC18F46K80-I/ML', 'PIC18LF45K80-I/ML', 'PIC18LF46K80-I/ML'],pins=[
            Pin(num='1',name='CANRX/RX1/CCP4/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='ECCP1/PSP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PSP5/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TX2/PSP6/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RX2/PSP7/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='33',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='34',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RB0/AN10/INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB1/AN8/INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB2/CANTX/INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1/AN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OSC1/CLKIN/RA7',do_erc=True),
            Pin(num='40',name='C2INA/PSP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB3/CANRX/INT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RA2/Vref-/AN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OSC2/CLKOUT/RA6',do_erc=True),
            Pin(num='41',name='C2INB/PSP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RA3/Vref+/AN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='SDA/SDI/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='Vddcore/Vcap',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='SDO/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB4/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RA5/AN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='CANTX/TX1/CCP3/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RB5/CCP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='RE0/AN5',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PAD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='RB6/PGC',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RE1/AN6',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='CCP2/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RB7/PGD',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RE2/AN7',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SCL/SCK/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='~MLCR~/RE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='C1INA/PSP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/CVref/AN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='C1INB/PSP1/RD1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F66J60-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Flash Based 8-Bit Microcontroller Ethernet Controller PHY',description='128K Flash, 3.7K SRAM, Ethernet Controller with PHY, 8K Buffer, TQFP64',ref_prefix='U',num_units=1,fplist=['TQFP*10x10mm*Pitch0.5mm*'],do_erc=True,aliases=['PIC18F66J65-I/PT', 'PIC18F67J60-I/PT'],pins=[
            Pin(num='1',name='RE1/P2C',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RE0/P2D',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='INT0/FLT0/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='INT1/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='INT2/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='INT3/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~MCLR~',do_erc=True),
            Pin(num='8',name='RG4/CCP5/P1D',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VDDCORE/VCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='T13CKI/T1OSO/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='OSC2/CLK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='TPOUT-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='RD0/P1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RF7/~SS1~',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='Vref+/AN3/RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TX1/CK1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='TPOUT+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='RE5/P1C',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RF6/AN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='Vref-/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RX1/DT1/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PGC/KBI2/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VSSTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='RE4/P3B',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RF5/AN10/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='LEDB/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ECCP1/P1A/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='KBI1/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='RBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='RE3/P3C',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RF4/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='LEDA/AN0/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='SCK1/SCL1/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='KBI0/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VDDPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='RE2/P2B',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RF3/AN8',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='SDI1/SDA1/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='VSSRX',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='VSSPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='RF2/AN7/C1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='SDO1/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='TPIN-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='RF1/AN6/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AN4/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PGD/KBI3/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='TPIN+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='ENVREG',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='T0CKI/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='VDDRX',func=Pin.PWRIN,do_erc=True),
            Pin(num='58',name='RD2/CCP4/P3D',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='T1OSI/ECCP2/P2A/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='OSC1/CLKI',do_erc=True),
            Pin(num='49',name='VDDTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='RD1/ECCP3/P3A',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC18F96J60-I/PT',dest=TEMPLATE,tool=SKIDL,keywords='Flash Based 8-Bit Microcontroller Ethernet Controller PHY',description='128K Flash, 3.7K SRAM, Ethernet Controller with PHY, 8K Buffer, TQFP100',ref_prefix='U',num_units=1,fplist=['TQFP*12x12mm*Pitch0.4mm*', 'TQFP*14x14mm*Pitch0.5mm*'],do_erc=True,aliases=['PIC18F96J65-I/PT', 'PIC18F97J60-I/PT', 'PIC18F96J60-I/PF', 'PIC18F96J65-I/PF', 'PIC18F97J60-I/PF'],pins=[
            Pin(num='1',name='RH2/A18',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RH3/A19',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~WR~/AD9/P2C/RE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~RD~/AD8/P2D/RE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='INT0/FLT0/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='INT1/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='INT2/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='INT3/ECCP2/P2A/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RG6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RF5/AN10/CVref',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='RJ1/~OE~',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='70',name='RG1/TX2/CK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='RBIAS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='90',name='AD2/PSP2/RD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RG5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RF4/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='31',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='AN4/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='RG3/CCP4/P3D',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='RJ3/~WRH~',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='RG0/ECCP3/P3A',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='VDDPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='AD1/PSP1/RD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RF0/AN5',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='RF3/AN8',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='Vref+/AN3/RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TOCKI/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='RG2/RX2/DT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VSSRX',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='VSSPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='AD0/PSP0/RD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='~MCLR~',do_erc=True),
            Pin(num='23',name='RF2/AN7/C1OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='Vref-/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='T1OSI/ECCP2/P2A/RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='ECCP1/P1A/RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='OSC1/CLKI',do_erc=True),
            Pin(num='73',name='TPIN-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='83',name='AD7/PSP7/~SS2~/RD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='ECCP2/AD15/P2A/RE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RG4/CCP5/P1D',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='RH7/AN15/P1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='LEDB/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='T13CKI/T1OSO/RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='SCK1/SCL1/RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='OSC2/CLK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='74',name='TPIN+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='84',name='AD6/PSP6/SCK2/SCL2/RD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='AD14/P1B/RE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='RH6/AN14/P1C',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='LEDA/AN0/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TX1/CK1/RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='SDI1/SDA1/RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='VDDRX',func=Pin.PWRIN,do_erc=True),
            Pin(num='85',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='AD13/P1C/RE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDDCORE/VCAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='RH5/AN13/P3B',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='RX1/DT1/RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='SDO1/RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='RJ2/~WRL~',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='VDDTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='86',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='96',name='AD12/P3B/RE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='RH4/AN12/P3C',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='RJ4/BA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='PGD/KBI3/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PGC/KBI2/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='TPOUT-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='87',name='AD5/PSP5/SDI2/SDA2/RD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='AD11/P3C/RE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RF7/~SS1~',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RF1/AN6/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='RG7',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='RJ5/~CE~',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='RJ6/~LB~',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='KBI1/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='TP0UT+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='88',name='SD02/AD4/PSP4/RD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='~CS~/AD10/P2B/RE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RF6/AN11',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ENVREG',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='RJ7/~UB~',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='RJ0/ALE',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='69',name='KBI0/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='VSSTX',func=Pin.PWRIN,do_erc=True),
            Pin(num='89',name='AD3/PSP3/RD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='RH0/A16',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='RH1/A17',func=Pin.BIDIR,do_erc=True)])])