from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

memory = SchLib(tool=SKIDL).add_parts(*[
        Part(name='2130',dest=TEMPLATE,tool=SKIDL,keywords='RAM BiPort 1KO',description='biPort RAM (1Ko)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CE',do_erc=True),
            Pin(num='2',name='R/W',do_erc=True),
            Pin(num='3',name='BUSY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='INTL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='OE',do_erc=True),
            Pin(num='6',name='A0L',do_erc=True),
            Pin(num='7',name='A1L',do_erc=True),
            Pin(num='8',name='A2L',do_erc=True),
            Pin(num='9',name='A3L',do_erc=True),
            Pin(num='10',name='A4L',do_erc=True),
            Pin(num='20',name='I/O4L',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='I/O5R',func=Pin.TRISTATE,do_erc=True),
            Pin(num='40',name='A2R',do_erc=True),
            Pin(num='11',name='A5L',do_erc=True),
            Pin(num='21',name='I/O5L',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='I/O6R',func=Pin.TRISTATE,do_erc=True),
            Pin(num='41',name='A1R',do_erc=True),
            Pin(num='12',name='A6L',do_erc=True),
            Pin(num='22',name='I/O6L',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='I/O7R',func=Pin.TRISTATE,do_erc=True),
            Pin(num='42',name='A0R',do_erc=True),
            Pin(num='13',name='A7L',do_erc=True),
            Pin(num='23',name='I/O7L',func=Pin.TRISTATE,do_erc=True),
            Pin(num='33',name='A9R',do_erc=True),
            Pin(num='43',name='OE',do_erc=True),
            Pin(num='14',name='A8L',do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='A8R',do_erc=True),
            Pin(num='44',name='INTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='A9L',do_erc=True),
            Pin(num='25',name='I/O0R',func=Pin.TRISTATE,do_erc=True),
            Pin(num='35',name='A7R',do_erc=True),
            Pin(num='45',name='BUSY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='I/O0L',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='I/O1R',func=Pin.TRISTATE,do_erc=True),
            Pin(num='36',name='A6R',do_erc=True),
            Pin(num='46',name='R/W',do_erc=True),
            Pin(num='17',name='I/O1L',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='I/O2R',func=Pin.TRISTATE,do_erc=True),
            Pin(num='37',name='A5R',do_erc=True),
            Pin(num='47',name='CE',do_erc=True),
            Pin(num='18',name='I/O2L',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='I/O3R',func=Pin.TRISTATE,do_erc=True),
            Pin(num='38',name='A4R',do_erc=True),
            Pin(num='48',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='I/O3L',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='I/O4R',func=Pin.TRISTATE,do_erc=True),
            Pin(num='39',name='A3R',do_erc=True)]),
        Part(name='24AA02',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM',description='I2C Serial EEPROM, 2kb',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='SCL',do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='24LC16',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM',description='I2C Serial EEPROM, 64kb',ref_prefix='U',num_units=1,fplist=['SOIC*'],do_erc=True,aliases=['24LC00', '24LC01', '24LC02', '24LC04', '24LC08', '24LC32', '24LC64', '24LC128', '24LC256', '24LC512', '24LC1025'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True)]),
        Part(name='25LC_EEPROM',dest=TEMPLATE,tool=SKIDL,keywords='serial EEPROM SPI interface memory external',description='ON Semiconductor serial EEPROM with SPI interface in 8-pin package',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT25_EEPROM', 'BR25S_EEPROM', 'CAT250_EEPROM'],pins=[
            Pin(num='1',name='~CS',do_erc=True),
            Pin(num='2',name='MISO',do_erc=True),
            Pin(num='3',name='~WP',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='MOSI',do_erc=True),
            Pin(num='6',name='SCK',do_erc=True),
            Pin(num='7',name='~HOLD',do_erc=True),
            Pin(num='8',name='Vcc',func=Pin.PWRIN,do_erc=True)]),
        Part(name='2716',dest=TEMPLATE,tool=SKIDL,keywords='REPTOM 2KO',description='REPROM 2KO',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A7',do_erc=True),
            Pin(num='2',name='A6',do_erc=True),
            Pin(num='3',name='A5',do_erc=True),
            Pin(num='4',name='A4',do_erc=True),
            Pin(num='5',name='A3',do_erc=True),
            Pin(num='6',name='A2',do_erc=True),
            Pin(num='7',name='A1',do_erc=True),
            Pin(num='8',name='A0',do_erc=True),
            Pin(num='9',name='Q0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='G',do_erc=True),
            Pin(num='11',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='Vpp',do_erc=True),
            Pin(num='22',name='A9',do_erc=True),
            Pin(num='13',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A8',do_erc=True),
            Pin(num='14',name='Q4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Q5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Q6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Q7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='E',do_erc=True),
            Pin(num='19',name='A10',do_erc=True)]),
        Part(name='2732',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 4KO',description='REPROM 4 Ko',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A7',do_erc=True),
            Pin(num='2',name='A6',do_erc=True),
            Pin(num='3',name='A5',do_erc=True),
            Pin(num='4',name='A4',do_erc=True),
            Pin(num='5',name='A3',do_erc=True),
            Pin(num='6',name='A2',do_erc=True),
            Pin(num='7',name='A1',do_erc=True),
            Pin(num='8',name='A0',do_erc=True),
            Pin(num='9',name='Q0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='~G',do_erc=True),
            Pin(num='11',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A11',do_erc=True),
            Pin(num='22',name='A9',do_erc=True),
            Pin(num='13',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A8',do_erc=True),
            Pin(num='14',name='Q4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Q5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Q6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Q7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='~E',do_erc=True),
            Pin(num='19',name='A10',do_erc=True)]),
        Part(name='27C010',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 128KO',description='REPROM 128K x 8 bits (32 pins DIP or PLCC)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='VPP',do_erc=True),
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A15',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='PGM',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='A14',do_erc=True)]),
        Part(name='27C020',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 256KO',description='REPROM 256K x 8 bits (32 pins DIP or PLCC)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='VPP',do_erc=True),
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A15',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='A17',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='PGM',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='A14',do_erc=True)]),
        Part(name='27C040',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 512KO',description='REPROM 512 K x 8 bits (32 pins DIP or PLCC)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='VPP',do_erc=True),
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A15',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='A17',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A18',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='A14',do_erc=True)]),
        Part(name='27C080',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 1M x 8 bits',description='REPROM 1024 K x 8 bits (32 pins DIP or PLCC)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A19',do_erc=True),
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A15',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='A17',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A18',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='A14',do_erc=True)]),
        Part(name='27C128',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 128KO',description='REPROM 128KO',ref_prefix='U',num_units=1,do_erc=True,aliases=['27128'],pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='VPP',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='CE',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='~PGM',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='27C256',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 32KO',description='REPROM 32 KO',ref_prefix='U',num_units=1,do_erc=True,aliases=['27256'],pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='VPP',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='CE',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A14',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='27C512',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 64KO',description='REPROM 64 Ko',ref_prefix='U',num_units=1,do_erc=True,aliases=['27512'],pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A15',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='CE',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A14',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='27C512PLCC',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 64KO CMS',description='REPROM 64 Ko Plcc',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='NU1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A15',do_erc=True),
            Pin(num='3',name='A12',do_erc=True),
            Pin(num='4',name='A7',do_erc=True),
            Pin(num='5',name='A6',do_erc=True),
            Pin(num='6',name='A5',do_erc=True),
            Pin(num='7',name='A4',do_erc=True),
            Pin(num='8',name='A3',do_erc=True),
            Pin(num='9',name='A2',do_erc=True),
            Pin(num='10',name='A1',do_erc=True),
            Pin(num='20',name='O5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='A13',do_erc=True),
            Pin(num='11',name='A0',do_erc=True),
            Pin(num='21',name='O6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A14',do_erc=True),
            Pin(num='12',name='NC1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='O7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='O0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='CE',do_erc=True),
            Pin(num='14',name='O1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='A10',do_erc=True),
            Pin(num='15',name='O2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='OE/VPP',do_erc=True),
            Pin(num='26',name='NC2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='NU2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='A11',do_erc=True),
            Pin(num='18',name='O3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A9',do_erc=True),
            Pin(num='19',name='O4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='A8',do_erc=True)]),
        Part(name='27C64',dest=TEMPLATE,tool=SKIDL,keywords='REPROM 8KO',description='REPROM 8Ko',ref_prefix='U',num_units=1,do_erc=True,aliases=['2764'],pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='VPP',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='CE',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='NC',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='~PGM',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='28C256',dest=TEMPLATE,tool=SKIDL,keywords='EEROM ROM',description='EEROM 32Kx8bits',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A14',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='CS',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='WE',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='28F400',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM FLASH 4MO',description='PA28F400BX-T/B Flash EEProm 4-MBIT (256Kx16bits, 512Kx8bits) 5V, 12V Prog',ref_prefix='U',num_units=1,fplist=['PSOP*'],do_erc=True,pins=[
            Pin(num='1',name='VPP',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DU',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='A17',do_erc=True),
            Pin(num='4',name='A7',do_erc=True),
            Pin(num='5',name='A6',do_erc=True),
            Pin(num='6',name='A5',do_erc=True),
            Pin(num='7',name='A4',do_erc=True),
            Pin(num='8',name='A3',do_erc=True),
            Pin(num='9',name='A2',do_erc=True),
            Pin(num='10',name='A1',do_erc=True),
            Pin(num='20',name='D10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='40',name='A10',do_erc=True),
            Pin(num='11',name='A0',do_erc=True),
            Pin(num='21',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A-1/D15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='41',name='A9',do_erc=True),
            Pin(num='12',name='CE',do_erc=True),
            Pin(num='22',name='D11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='A8',do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='BYTE',do_erc=True),
            Pin(num='43',name='WE',do_erc=True),
            Pin(num='14',name='OE',do_erc=True),
            Pin(num='24',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='34',name='A16',do_erc=True),
            Pin(num='44',name='PR',do_erc=True),
            Pin(num='15',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='D12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='35',name='A15',do_erc=True),
            Pin(num='16',name='D8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='36',name='A14',do_erc=True),
            Pin(num='17',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='D13',func=Pin.TRISTATE,do_erc=True),
            Pin(num='37',name='A13',do_erc=True),
            Pin(num='18',name='D9',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='38',name='A12',do_erc=True),
            Pin(num='19',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='D14',func=Pin.TRISTATE,do_erc=True),
            Pin(num='39',name='A11',do_erc=True)]),
        Part(name='29F010-TSOP-SP',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM FLASH 128KO',description='Flash EEProm 128Ko (TSOP 32 pack.) 5V prog',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='A11',do_erc=True),
            Pin(num='2',name='A9',do_erc=True),
            Pin(num='3',name='A8',do_erc=True),
            Pin(num='4',name='A13',do_erc=True),
            Pin(num='5',name='A14',do_erc=True),
            Pin(num='7',name='WE',do_erc=True),
            Pin(num='8',name='VCC',do_erc=True),
            Pin(num='10',name='A16',do_erc=True),
            Pin(num='20',name='A0',do_erc=True),
            Pin(num='30',name='CE',do_erc=True),
            Pin(num='11',name='A15',do_erc=True),
            Pin(num='21',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A10',do_erc=True),
            Pin(num='12',name='A12',do_erc=True),
            Pin(num='22',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='OE',do_erc=True),
            Pin(num='13',name='A7',do_erc=True),
            Pin(num='23',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='A6',do_erc=True),
            Pin(num='24',name='GND',do_erc=True),
            Pin(num='15',name='A5',do_erc=True),
            Pin(num='25',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='A4',do_erc=True),
            Pin(num='26',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='A3',do_erc=True),
            Pin(num='27',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='A2',do_erc=True),
            Pin(num='28',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='A1',do_erc=True),
            Pin(num='29',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='29W040',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM FLASH 512KO',description='Flash EEProm 512PP (TSOP 32) 3,3V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='A11',do_erc=True),
            Pin(num='2',name='A9',do_erc=True),
            Pin(num='3',name='A8',do_erc=True),
            Pin(num='4',name='A13',do_erc=True),
            Pin(num='5',name='A14',do_erc=True),
            Pin(num='6',name='A17',do_erc=True),
            Pin(num='7',name='WE',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='A18',do_erc=True),
            Pin(num='10',name='A16',do_erc=True),
            Pin(num='20',name='A0',do_erc=True),
            Pin(num='30',name='CE',do_erc=True),
            Pin(num='11',name='A15',do_erc=True),
            Pin(num='21',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A10',do_erc=True),
            Pin(num='12',name='A12',do_erc=True),
            Pin(num='22',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='OE',do_erc=True),
            Pin(num='13',name='A7',do_erc=True),
            Pin(num='23',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='A6',do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='A5',do_erc=True),
            Pin(num='25',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='A4',do_erc=True),
            Pin(num='26',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='A3',do_erc=True),
            Pin(num='27',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='A2',do_erc=True),
            Pin(num='28',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='A1',do_erc=True),
            Pin(num='29',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='4C1024',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='4C4001',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='6116',dest=TEMPLATE,tool=SKIDL,keywords='SRAM Static RAM Random Access Memory',description='HT6116-70, CMOS Static RAM 2KB, DIP24',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A7',do_erc=True),
            Pin(num='2',name='A6',do_erc=True),
            Pin(num='3',name='A5',do_erc=True),
            Pin(num='4',name='A4',do_erc=True),
            Pin(num='5',name='A3',do_erc=True),
            Pin(num='6',name='A2',do_erc=True),
            Pin(num='7',name='A1',do_erc=True),
            Pin(num='8',name='A0',do_erc=True),
            Pin(num='9',name='Q0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='~OE',do_erc=True),
            Pin(num='11',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='~WE',do_erc=True),
            Pin(num='22',name='A9',do_erc=True),
            Pin(num='13',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A8',do_erc=True),
            Pin(num='14',name='Q4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='Q5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='Q6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='Q7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='~CS',do_erc=True),
            Pin(num='19',name='A10',do_erc=True)]),
        Part(name='628128',dest=TEMPLATE,tool=SKIDL,keywords='RAM 128KO',description='RAM 128 Ko',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A14',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='Q6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='CS2',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='Q7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A15',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CS1',do_erc=True),
            Pin(num='13',name='Q0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='Q1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='Q2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='Q3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='Q4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='Q5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='WR',do_erc=True)]),
        Part(name='93AAxxA',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM memory SPI microwire',description='Serial EEPROM, 93 series in 8-pin package, 1.8V',ref_prefix='U',num_units=1,do_erc=True,aliases=['93AAxxB'],pins=[
            Pin(num='1',name='CS',do_erc=True),
            Pin(num='2',name='SCLK',do_erc=True),
            Pin(num='3',name='DI',do_erc=True),
            Pin(num='4',name='DO',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='NC',do_erc=True),
            Pin(num='7',name='NC',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='93AAxxC',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM memory SPI microwire',description='Serial EEPROM, 93 series in 8-pin package with ORG pin, 1.8V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CS',do_erc=True),
            Pin(num='2',name='SCLK',do_erc=True),
            Pin(num='3',name='DI',do_erc=True),
            Pin(num='4',name='DO',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='ORG',do_erc=True),
            Pin(num='7',name='NC',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='93CxxA',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM memory SPI microwire',description='Serial EEPROM, 93 series in 8-pin package, 5.0V',ref_prefix='U',num_units=1,do_erc=True,aliases=['93CxxB'],pins=[
            Pin(num='1',name='CS',do_erc=True),
            Pin(num='2',name='SCLK',do_erc=True),
            Pin(num='3',name='DI',do_erc=True),
            Pin(num='4',name='DO',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='NC',do_erc=True),
            Pin(num='7',name='NC',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='93CxxC',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM memory SPI microwire',description='Serial EEPROM, 93 series in 8-pin package with ORG pin, 5.0V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CS',do_erc=True),
            Pin(num='2',name='SCLK',do_erc=True),
            Pin(num='3',name='DI',do_erc=True),
            Pin(num='4',name='DO',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='ORG',do_erc=True),
            Pin(num='7',name='NC',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='93LCxxA',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM memory SPI microwire',description='Serial EEPROM, 93 series in 8-pin package, 2.5V',ref_prefix='U',num_units=1,do_erc=True,aliases=['93LCxxB'],pins=[
            Pin(num='1',name='CS',do_erc=True),
            Pin(num='2',name='SCLK',do_erc=True),
            Pin(num='3',name='DI',do_erc=True),
            Pin(num='4',name='DO',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='NC',do_erc=True),
            Pin(num='7',name='NC',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='93LCxxC',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM memory SPI microwire',description='Serial EEPROM, 93 series in 8-pin package with ORG pin, 2.5V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CS',do_erc=True),
            Pin(num='2',name='SCLK',do_erc=True),
            Pin(num='3',name='DI',do_erc=True),
            Pin(num='4',name='DO',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='ORG',do_erc=True),
            Pin(num='7',name='NC',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AM29PDL128G',dest=TEMPLATE,tool=SKIDL,description='128 Megabit (8 M x 16-Bit/4 M x 32-Bit), Simultaneous Operation Flash Memory with VersatileIO™ Control',ref_prefix='U',num_units=1,fplist=['BGA80_1mm_15X10'],do_erc=True,pins=[
            Pin(num='A1',name='A5',do_erc=True),
            Pin(num='B1',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='DQ17',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='DQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='DQ19',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='DQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='VIO',do_erc=True),
            Pin(num='H1',name='DQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='A6',do_erc=True),
            Pin(num='K1',name='A8',do_erc=True),
            Pin(num='A2',name='A4',do_erc=True),
            Pin(num='B2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VIO',do_erc=True),
            Pin(num='E2',name='DQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='DQ21',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='DQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='DQ23',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='A7',do_erc=True),
            Pin(num='K2',name='A9',do_erc=True),
            Pin(num='A3',name='A2',do_erc=True),
            Pin(num='B3',name='A3',do_erc=True),
            Pin(num='C3',name='DQ16',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E3',name='DQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='DQ20',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='DQ22',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='J3',name='A10',do_erc=True),
            Pin(num='K3',name='A11',do_erc=True),
            Pin(num='A4',name='RY/BY#',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B4',name='A0',do_erc=True),
            Pin(num='C4',name='A1',do_erc=True),
            Pin(num='D4',name='DQ18',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='RST#',do_erc=True),
            Pin(num='G4',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='H4',name='A12',do_erc=True),
            Pin(num='B5',name='WP#',do_erc=True),
            Pin(num='C5',name='WE#',do_erc=True),
            Pin(num='D5',name='DQ29',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='ACC',do_erc=True),
            Pin(num='G5',name='DQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='A14',do_erc=True),
            Pin(num='J5',name='A13',do_erc=True),
            Pin(num='A6',name='A21',do_erc=True),
            Pin(num='B6',name='A20',do_erc=True),
            Pin(num='C6',name='DQ31/A-1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='DQ14',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='DQ12',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='DQ27',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='DQ25',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='DQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='A16',do_erc=True),
            Pin(num='K6',name='A15',do_erc=True),
            Pin(num='A7',name='WORD#',do_erc=True),
            Pin(num='B7',name='CE#',do_erc=True),
            Pin(num='C7',name='DQ15',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='DQ13',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='DQ26',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='VIO',do_erc=True),
            Pin(num='H7',name='DQ24',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='A19',do_erc=True),
            Pin(num='K7',name='A17',do_erc=True),
            Pin(num='A8',name='OE#',do_erc=True),
            Pin(num='B8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C8',name='DQ30',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='VIO',do_erc=True),
            Pin(num='E8',name='DQ28',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='DQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='DQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='K8',name='A18',do_erc=True)]),
        Part(name='AS6C1616',dest=TEMPLATE,tool=SKIDL,keywords='memory SRAM',description='1024k x 16 bit low power CMOS SRAM',ref_prefix='U',num_units=1,fplist=['TSOP*12x18.4mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='A15',do_erc=True),
            Pin(num='2',name='A14',do_erc=True),
            Pin(num='3',name='A13',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A11',do_erc=True),
            Pin(num='6',name='A10',do_erc=True),
            Pin(num='7',name='A9',do_erc=True),
            Pin(num='8',name='A8',do_erc=True),
            Pin(num='9',name='A19',do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='20',name='A5',do_erc=True),
            Pin(num='30',name='DQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='DQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='WE#',do_erc=True),
            Pin(num='21',name='A4',do_erc=True),
            Pin(num='31',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='DQ13',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='CE2',do_erc=True),
            Pin(num='22',name='A3',do_erc=True),
            Pin(num='32',name='DQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='23',name='A2',do_erc=True),
            Pin(num='33',name='DQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='DQ14',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='UB#',do_erc=True),
            Pin(num='24',name='A1',do_erc=True),
            Pin(num='34',name='DQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='DQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='LB#',do_erc=True),
            Pin(num='25',name='A0',do_erc=True),
            Pin(num='35',name='DQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='DQ15',do_erc=True),
            Pin(num='16',name='A18',do_erc=True),
            Pin(num='26',name='CE#',do_erc=True),
            Pin(num='36',name='DQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='A17',do_erc=True),
            Pin(num='27',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='18',name='A7',do_erc=True),
            Pin(num='28',name='OE#',do_erc=True),
            Pin(num='38',name='DQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='A16',do_erc=True),
            Pin(num='19',name='A6',do_erc=True),
            Pin(num='29',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DQ12',func=Pin.BIDIR,do_erc=True)]),
        Part(name='AT24CS01-MAHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='2Kb (256x8) Serial EEPROM with Unique Serial Number, UDFN8',ref_prefix='U',num_units=1,fplist=['UDFN*'],do_erc=True,aliases=['AT24CS02-MAHM'],pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS01-SSHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='2Kb (256x8) Serial EEPROM with Unique Serial Number, SO8',ref_prefix='U',num_units=1,fplist=['SO8*'],do_erc=True,aliases=['AT24CS02-SSHM'],pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS01-STUM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='2Kb (256x8) Serial EEPROM with Unique Serial Number, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOT-23*'],do_erc=True,aliases=['AT24CS02-STUM'],pins=[
            Pin(num='1',name='SCL',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='WP',do_erc=True)]),
        Part(name='AT24CS01-XHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='2Kb (256x8) Serial EEPROM with Unique Serial Number, TSSOP8',ref_prefix='U',num_units=1,fplist=['TSSOP8*'],do_erc=True,aliases=['AT24CS02-XHM'],pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS04-MAHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='4Kb (512x8) Serial EEPROM with Unique Serial Number, UDFN8',ref_prefix='U',num_units=1,fplist=['UDFN*'],do_erc=True,pins=[
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS04-SSHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='4Kb (512x8) Serial EEPROM with Unique Serial Number, SO8',ref_prefix='U',num_units=1,fplist=['SO8*'],do_erc=True,pins=[
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS04-STUM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='4Kb (512x8) Serial EEPROM with Unique Serial Number, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='SCL',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='WP',do_erc=True)]),
        Part(name='AT24CS04-XHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='4Kb (512x8) Serial EEPROM with Unique Serial Number, TSSOP8',ref_prefix='U',num_units=1,fplist=['TSSOP8*'],do_erc=True,pins=[
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS08-MAHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='8Kb (1024x8) Serial EEPROM with Unique Serial Number, UDFN8',ref_prefix='U',num_units=1,fplist=['UDFN*'],do_erc=True,pins=[
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS08-SSHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='8Kb (1024x8) Serial EEPROM with Unique Serial Number, SO8',ref_prefix='U',num_units=1,fplist=['SO8*'],do_erc=True,pins=[
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS08-STUM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='8Kb (1024x8) Serial EEPROM with Unique Serial Number, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='SCL',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='WP',do_erc=True)]),
        Part(name='AT24CS08-XHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='8Kb (1024x8) Serial EEPROM with Unique Serial Number, TSSOP8',ref_prefix='U',num_units=1,fplist=['TSSOP8*'],do_erc=True,pins=[
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS16-MAHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='16Kb (2048x8) Serial EEPROM with Unique Serial Number, UDFN8',ref_prefix='U',num_units=1,fplist=['UDFN*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS16-SSHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='16Kb (2048x8) Serial EEPROM with Unique Serial Number, SO8',ref_prefix='U',num_units=1,fplist=['SO8*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS16-STUM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='16Kb (2048x8) Serial EEPROM with Unique Serial Number, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='SCL',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='WP',do_erc=True)]),
        Part(name='AT24CS16-XHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='16Kb (2048x8) Serial EEPROM with Unique Serial Number, TSSOP8',ref_prefix='U',num_units=1,fplist=['TSSOP8*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS32-MAHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='32Kb (4096x8) Serial EEPROM with Unique Serial Number, UDFN8',ref_prefix='U',num_units=1,fplist=['UDFN*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS32-SSHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='32Kb (4096x8) Serial EEPROM with Unique Serial Number, SO8',ref_prefix='U',num_units=1,fplist=['SO8*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS32-STUM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='32Kb (4096x8) Serial EEPROM with Unique Serial Number, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='SCL',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='WP',do_erc=True)]),
        Part(name='AT24CS32-XHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='32Kb (4096x8) Serial EEPROM with Unique Serial Number, TSSOP8',ref_prefix='U',num_units=1,fplist=['TSSOP8*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS64-MAHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='64Kb (8192x8) Serial EEPROM with Unique Serial Number, UDFN8',ref_prefix='U',num_units=1,fplist=['UDFN*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS64-SSHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='64Kb (8192x8) Serial EEPROM with Unique Serial Number, SO8',ref_prefix='U',num_units=1,fplist=['SO8*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT24CS64-XHM',dest=TEMPLATE,tool=SKIDL,keywords='I2C Serial EEPROM Nonvolatile Memory',description='64Kb (8192x8) Serial EEPROM with Unique Serial Number, TSSOP8',ref_prefix='U',num_units=1,fplist=['TSSOP8*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT45DB161-JC',dest=TEMPLATE,tool=SKIDL,keywords='Atmel DataFlash',description='16Mb Serial DataFlash, PLCC32, Vcc=2.7V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~CS',do_erc=True),
            Pin(num='5',name='SCK',do_erc=True),
            Pin(num='6',name='SI',do_erc=True),
            Pin(num='7',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='RDY/~BSY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='~RESET',do_erc=True),
            Pin(num='29',name='~WP',do_erc=True)]),
        Part(name='AT45DB161-RC',dest=TEMPLATE,tool=SKIDL,keywords='Atmel DataFlash',description='16Mb Serial DataFlash, SOIC28, Vcc=2.5V',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT45DB161B-RC', 'AT45DB161B-RC-2.5'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~CS',do_erc=True),
            Pin(num='5',name='SCK',do_erc=True),
            Pin(num='6',name='SI',do_erc=True),
            Pin(num='7',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='RDY/~BSY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='~RESET',do_erc=True),
            Pin(num='25',name='~WP',do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='AT45DB161-TC',dest=TEMPLATE,tool=SKIDL,keywords='Atmel DataFlash',description='16Mb Serial DataFlash, TSSOP28, Vcc=2.5V',ref_prefix='U',num_units=1,do_erc=True,aliases=['AT45DB161B-TC', 'AT45DB161B-TC-2.5'],pins=[
            Pin(num='1',name='RDY/~BSY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~RESET',do_erc=True),
            Pin(num='3',name='~WP',do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~CS',do_erc=True),
            Pin(num='12',name='SCK',do_erc=True),
            Pin(num='13',name='SI',do_erc=True),
            Pin(num='14',name='SO',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='DRAM_1MX16_SOJ',dest=TEMPLATE,tool=SKIDL,keywords='DRAM 2MO',description='DRAM 16 MBits (1M x 16bits)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='DQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='A3',do_erc=True),
            Pin(num='30',name='UCAS',do_erc=True),
            Pin(num='40',name='DQ14',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='LCAS',do_erc=True),
            Pin(num='41',name='DQ15',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='WE',do_erc=True),
            Pin(num='23',name='A4',do_erc=True),
            Pin(num='33',name='DQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RAS',do_erc=True),
            Pin(num='24',name='A5',do_erc=True),
            Pin(num='34',name='DQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='A11',do_erc=True),
            Pin(num='25',name='A6',do_erc=True),
            Pin(num='35',name='DQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='A10',do_erc=True),
            Pin(num='26',name='A7',do_erc=True),
            Pin(num='36',name='DQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='A0',do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='A1',do_erc=True),
            Pin(num='28',name='A9',do_erc=True),
            Pin(num='38',name='DQ12',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='A2',do_erc=True),
            Pin(num='29',name='OE',do_erc=True),
            Pin(num='39',name='DQ13',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FM16W08-SG',dest=TEMPLATE,tool=SKIDL,keywords='FRAM Nonvolatile Memory 8K 8bit',description='FRAM Nonvolatile Memory 8Kx8 (64Kb), SOIC28',ref_prefix='U',num_units=1,fplist=['SO*28*'],do_erc=True,aliases=['FM1608B-SG'],pins=[
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='~CE~',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='~OE~',do_erc=True),
            Pin(num='13',name='DQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='DQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='DQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='DQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='~WE~',do_erc=True),
            Pin(num='18',name='DQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='DQ7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FM18W08-SG',dest=TEMPLATE,tool=SKIDL,keywords='FRAM Nonvolatile Memory 32K 8bit',description='FRAM Nonvolatile Memory 32Kx8 (256Kb), SOIC28',ref_prefix='U',num_units=1,fplist=['SO*28*'],do_erc=True,aliases=['FM1808B-SG'],pins=[
            Pin(num='1',name='A14',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='~CE~',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='~OE~',do_erc=True),
            Pin(num='13',name='DQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='DQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='DQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='DQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='~WE~',do_erc=True),
            Pin(num='18',name='DQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='DQ7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FM24C64B',dest=TEMPLATE,tool=SKIDL,keywords='FRAM I2C Serial 5V FRAM Nonvolatile Memory',description='FM24C64C-G, 64Kb Serial 5V FRAM Nonvolatile Memory I2C Interface',ref_prefix='U',num_units=1,fplist=['SO8*'],do_erc=True,aliases=['FM24C64C'],pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='WP',do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='HM53461',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['HM53462']),
        Part(name='HM62256BLFP-7T',dest=TEMPLATE,tool=SKIDL,keywords='SRAM 32KB High Speed CMOS Static RAM',description='SRAM 32K x 8 bits, SOP28 450mil, 70ns',ref_prefix='U',num_units=1,fplist=['SO*28*'],do_erc=True,aliases=['HM62256BLFP-4SLT', 'HM62256BLFP-5SLT', 'HM62256BLFP-7SLT', 'HM62256BLFP-7ULT'],pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A14',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='~CS',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='~OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='~WE',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='HM62256BLP-7',dest=TEMPLATE,tool=SKIDL,keywords='SRAM 32KB High Speed CMOS Static RAM',description='SRAM 32K x 8 bits, DIP28 600mil, 70ns',ref_prefix='U',num_units=1,fplist=['DIP28*'],do_erc=True,aliases=['HM62256BLP-7SL'],pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A14',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='~CS',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='~OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='~WE',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='HM62256BLSP-7',dest=TEMPLATE,tool=SKIDL,keywords='SRAM 32KB High Speed CMOS Static RAM',description='SRAM 32K x 8 bits, DIP28 300mil, 70ns',ref_prefix='U',num_units=1,fplist=['DIP28*'],do_erc=True,aliases=['HM62256BLSP-7SL'],pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A14',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='~CS',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='~OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='~WE',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='HM62256BLT-7SL',dest=TEMPLATE,tool=SKIDL,keywords='SRAM 32KB High Speed CMOS Static RAM',description='SRAM 32K x 8 bits, TSOP32 8x14mm, 85ns',ref_prefix='U',num_units=1,fplist=['TSSOP32*'],do_erc=True,aliases=['HM62256BLT-8'],pins=[
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~OE',do_erc=True),
            Pin(num='2',name='A11',do_erc=True),
            Pin(num='4',name='A9',do_erc=True),
            Pin(num='5',name='A8',do_erc=True),
            Pin(num='6',name='A13',do_erc=True),
            Pin(num='7',name='~WE',do_erc=True),
            Pin(num='9',name='A14',do_erc=True),
            Pin(num='10',name='A12',do_erc=True),
            Pin(num='20',name='A0',do_erc=True),
            Pin(num='11',name='A7',do_erc=True),
            Pin(num='21',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='~CS',do_erc=True),
            Pin(num='12',name='A6',do_erc=True),
            Pin(num='22',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='A10',do_erc=True),
            Pin(num='13',name='A5',do_erc=True),
            Pin(num='23',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='A4',do_erc=True),
            Pin(num='25',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='A3',do_erc=True),
            Pin(num='26',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='A2',do_erc=True),
            Pin(num='27',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='A1',do_erc=True),
            Pin(num='28',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='HM62256BLTM-8',dest=TEMPLATE,tool=SKIDL,keywords='SRAM 32KB High Speed CMOS Static RAM',description='SRAM 32K x 8 bits, TSOP28 8x13.4mm, 85ns',ref_prefix='U',num_units=1,fplist=['TSSOP28'],do_erc=True,aliases=['HM62256BLTM-4SL', 'HM62256BLTM-5SL', 'HM62256BLTM-7SL', 'HM62256BLTM-7UL'],pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A14',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='~CS',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='~OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='~WE',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='HM628512BFP-7',dest=TEMPLATE,tool=SKIDL,keywords='4Mb SRAM (512K x 8-bit) High Speed CMOS Static RAM',description='SRAM 512K x 8-bit, 525mil SOP32, 70ns',ref_prefix='U',num_units=1,fplist=['SO32*'],do_erc=True,aliases=['HM628512BFP-5'],pins=[
            Pin(num='1',name='A18',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A16',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='A17',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='A15',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='A14',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='~CS',do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='~OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='~WE',do_erc=True)]),
        Part(name='IDT7027_TQ100',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='IDT7132',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='IDT71V65903S',dest=TEMPLATE,tool=SKIDL,description='165 pins BGA 3.3V high-speed 9 Megabit synchronous SRAMs 512K x 18 (or 256K x 36)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='H1',name='VSSx',func=Pin.PASSIVE,do_erc=True),
            Pin(num='J1',name='IO12',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='IO13',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='IO14',func=Pin.BIDIR,do_erc=True),
            Pin(num='M1',name='IO15',func=Pin.BIDIR,do_erc=True),
            Pin(num='N1',name='IOP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='R1',name='/LBO',do_erc=True),
            Pin(num='A2',name='A7',do_erc=True),
            Pin(num='B2',name='A6',do_erc=True),
            Pin(num='D2',name='IO8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='IO9',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='IO10',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='IO11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='VDDx',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A3',name='/CE1',do_erc=True),
            Pin(num='B3',name='CE2',do_erc=True),
            Pin(num='C3',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='G3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='J3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='K3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='L3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='M3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='N3',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='P3',name='A5',do_erc=True),
            Pin(num='R3',name='A4',do_erc=True),
            Pin(num='A4',name='/BW2',do_erc=True),
            Pin(num='C4',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='G4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='H4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='J4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='K4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='L4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='M4',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='N4',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='P4',name='A2',do_erc=True),
            Pin(num='R4',name='A3',do_erc=True),
            Pin(num='B5',name='/BW1',do_erc=True),
            Pin(num='C5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='G5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='H5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='J5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='K5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='L5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='M5',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A6',name='/CE2',do_erc=True),
            Pin(num='B6',name='CLK',do_erc=True),
            Pin(num='C6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='G6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='H6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='J6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='K6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='L6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='M6',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='P6',name='A1',do_erc=True),
            Pin(num='R6',name='A0',do_erc=True),
            Pin(num='A7',name='/CEN',do_erc=True),
            Pin(num='B7',name='R/W',do_erc=True),
            Pin(num='C7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='G7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='H7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='J7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='K7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='L7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='M7',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='N7',name='VSSx',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A8',name='ADV/LD',do_erc=True),
            Pin(num='B8',name='/OE',do_erc=True),
            Pin(num='C8',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='G8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='H8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='J8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='K8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='L8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='M8',name='VDD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='N8',name='VSS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='P8',name='A11',do_erc=True),
            Pin(num='R8',name='A12',do_erc=True),
            Pin(num='A9',name='A18',do_erc=True),
            Pin(num='C9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='G9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='J9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='K9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='L9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='M9',name='VDDQ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='N9',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='P9',name='A14',do_erc=True),
            Pin(num='R9',name='A13',do_erc=True),
            Pin(num='A10',name='A8',do_erc=True),
            Pin(num='B10',name='A9',do_erc=True),
            Pin(num='J10',name='IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K10',name='IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='IO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='P10',name='A15',do_erc=True),
            Pin(num='R10',name='A16',do_erc=True),
            Pin(num='A11',name='A10',do_erc=True),
            Pin(num='C11',name='IOP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='IO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='IO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='IO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='IO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='ZZ',do_erc=True),
            Pin(num='R11',name='A17',do_erc=True)]),
        Part(name='IDT7201',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['IDT7202']),
        Part(name='M25PX32-VMP',dest=TEMPLATE,tool=SKIDL,keywords='NOR Serial Flash Embedded Memory',description='32Mb, Dual I/O, 4KB Subsector Erase, 3V Serial Flash Memory with 75 MHz SPI Bus Interface, QFN package',ref_prefix='U',num_units=1,fplist=['DFN*6x5mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='S#',do_erc=True),
            Pin(num='2',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='W#/VPP',do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='C',do_erc=True),
            Pin(num='7',name='HOLD#',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PAD/VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='M25PX32-VMW',dest=TEMPLATE,tool=SKIDL,keywords='NOR Serial Flash Embedded Memory',description='32Mb, Dual I/O, 4KB Subsector Erase, 3V Serial Flash Memory with 75 MHz SPI Bus Interface, SOIJ package',ref_prefix='U',num_units=1,fplist=['SOIJ*5.3x5.3mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='S#',do_erc=True),
            Pin(num='2',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='W#/VPP',do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='C',do_erc=True),
            Pin(num='7',name='HOLD#',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='M29W004',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM FLASH 512KO',description='Flash EEProm 512Ko (TSOP 40 pack.) 3,3V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='A16',do_erc=True),
            Pin(num='2',name='A15',do_erc=True),
            Pin(num='3',name='A14',do_erc=True),
            Pin(num='4',name='A13',do_erc=True),
            Pin(num='5',name='A12',do_erc=True),
            Pin(num='6',name='A11',do_erc=True),
            Pin(num='8',name='A8',do_erc=True),
            Pin(num='9',name='A9',do_erc=True),
            Pin(num='9',name='WE',do_erc=True),
            Pin(num='10',name='Rst/B',do_erc=True),
            Pin(num='20',name='A1',do_erc=True),
            Pin(num='30',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='A17',do_erc=True),
            Pin(num='21',name='A0',do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='Busy',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='32',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='A18',do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='A7',do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='34',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='A6',do_erc=True),
            Pin(num='25',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='35',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='A5',do_erc=True),
            Pin(num='26',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='36',name='A10',do_erc=True),
            Pin(num='17',name='A4',do_erc=True),
            Pin(num='27',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='A3',do_erc=True),
            Pin(num='28',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='A2',do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='M29W008',dest=TEMPLATE,tool=SKIDL,keywords='EEPROM FLASH 1MO',description='Flash EEProm 1MO (TSOP 40 pack.) 3,3V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='A16',do_erc=True),
            Pin(num='2',name='A15',do_erc=True),
            Pin(num='3',name='A14',do_erc=True),
            Pin(num='4',name='A13',do_erc=True),
            Pin(num='5',name='A12',do_erc=True),
            Pin(num='6',name='A11',do_erc=True),
            Pin(num='7',name='A9',do_erc=True),
            Pin(num='8',name='A8',do_erc=True),
            Pin(num='9',name='WE',do_erc=True),
            Pin(num='10',name='Rst/B',do_erc=True),
            Pin(num='20',name='A1',do_erc=True),
            Pin(num='30',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='A17',do_erc=True),
            Pin(num='21',name='A0',do_erc=True),
            Pin(num='31',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='Busy',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='32',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='A18',do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='A7',do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='34',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='A6',do_erc=True),
            Pin(num='25',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='35',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='A5',do_erc=True),
            Pin(num='26',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='36',name='A10',do_erc=True),
            Pin(num='17',name='A4',do_erc=True),
            Pin(num='27',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='37',name='A19',do_erc=True),
            Pin(num='18',name='A3',do_erc=True),
            Pin(num='28',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='A2',do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MB81461ZIP',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MB85RS16',dest=TEMPLATE,tool=SKIDL,keywords='FRAM, SPI',description='FRAM memory (EEPROM compatible) with SPI interface in 8-pin package',ref_prefix='U',num_units=1,do_erc=True,aliases=['MB85RS64', 'MB85RS128B', 'MB85RS256B', 'MB85RS512T', 'MB85RS1MT', 'MB85RS2MT'],pins=[
            Pin(num='1',name='~CS',do_erc=True),
            Pin(num='2',name='MISO',do_erc=True),
            Pin(num='3',name='~WP',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='MOSI',do_erc=True),
            Pin(num='6',name='SCK',do_erc=True),
            Pin(num='7',name='~HOLD',do_erc=True),
            Pin(num='8',name='Vcc',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MK4501',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MK4511',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MR20H40',dest=TEMPLATE,tool=SKIDL,keywords='memory MRAM external SPI',description='4KBit MRAM with SPI interface in DFN-8 package',ref_prefix='U',num_units=1,do_erc=True,aliases=['MR25H40'],pins=[
            Pin(num='1',name='~CS',do_erc=True),
            Pin(num='2',name='MISO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~WP',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='MOSI',do_erc=True),
            Pin(num='6',name='SCK',do_erc=True),
            Pin(num='7',name='~HOLD',do_erc=True),
            Pin(num='8',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PAD',do_erc=True)]),
        Part(name='MS628128',dest=TEMPLATE,tool=SKIDL,keywords='RAM SRAM',description='SRAM 128K x 8 bits',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A14',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='CS2',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A15',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CS1',do_erc=True),
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='WE',do_erc=True)]),
        Part(name='MT48LC16M4A2TG',dest=TEMPLATE,tool=SKIDL,keywords='SDRAM Synchronus DRAM PC133 PC100 64Mb 16Mbx4',description='PC100/PC133 Compliant SDRAM, 64Mb (16Mb x 4), TSOP II 54pin',ref_prefix='U',num_units=1,do_erc=True,aliases=['MT48LC16M4A2P'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='BA0',do_erc=True),
            Pin(num='30',name='A5',do_erc=True),
            Pin(num='50',name='DQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='BA1',do_erc=True),
            Pin(num='31',name='A6',do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='A10',do_erc=True),
            Pin(num='32',name='A7',do_erc=True),
            Pin(num='52',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='A0',do_erc=True),
            Pin(num='33',name='A8',do_erc=True),
            Pin(num='43',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='A1',do_erc=True),
            Pin(num='34',name='A9',do_erc=True),
            Pin(num='44',name='DQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='A2',do_erc=True),
            Pin(num='35',name='A11',do_erc=True),
            Pin(num='16',name='~WE~',do_erc=True),
            Pin(num='26',name='A3',do_erc=True),
            Pin(num='46',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~CAS~',do_erc=True),
            Pin(num='27',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='CKE',do_erc=True),
            Pin(num='18',name='~RAS~',do_erc=True),
            Pin(num='28',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='CLK',do_erc=True),
            Pin(num='19',name='~CS~',do_erc=True),
            Pin(num='29',name='A4',do_erc=True),
            Pin(num='39',name='DQM',do_erc=True),
            Pin(num='49',name='VDDQ',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MT48LC4M16A2TG',dest=TEMPLATE,tool=SKIDL,keywords='SDRAM Synchronus DRAM PC133 PC100 64Mb 4Mbx16',description='PC100/PC133 Compliant SDRAM, 64Mb (4Mb x 16), TSOP II 54pin',ref_prefix='U',num_units=1,do_erc=True,aliases=['MT48LC4M16A2P'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='DQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='BA0',do_erc=True),
            Pin(num='30',name='A5',do_erc=True),
            Pin(num='50',name='DQ13',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='BA1',do_erc=True),
            Pin(num='31',name='A6',do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='DQ14',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='A10',do_erc=True),
            Pin(num='32',name='A7',do_erc=True),
            Pin(num='42',name='DQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='A0',do_erc=True),
            Pin(num='33',name='A8',do_erc=True),
            Pin(num='43',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='DQ15',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='A1',do_erc=True),
            Pin(num='34',name='A9',do_erc=True),
            Pin(num='44',name='DQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='DQML',do_erc=True),
            Pin(num='25',name='A2',do_erc=True),
            Pin(num='35',name='A11',do_erc=True),
            Pin(num='45',name='DQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~WE~',do_erc=True),
            Pin(num='26',name='A3',do_erc=True),
            Pin(num='46',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~CAS~',do_erc=True),
            Pin(num='27',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='CKE',do_erc=True),
            Pin(num='47',name='DQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='~RAS~',do_erc=True),
            Pin(num='28',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='CLK',do_erc=True),
            Pin(num='48',name='DQ12',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='~CS~',do_erc=True),
            Pin(num='29',name='A4',do_erc=True),
            Pin(num='39',name='DQMH',do_erc=True),
            Pin(num='49',name='VDDQ',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MT48LC8M8A2TG',dest=TEMPLATE,tool=SKIDL,keywords='SDRAM Synchronus DRAM PC133 PC100 64Mb 8Mbx8',description='PC100/PC133 Compliant SDRAM, 64Mb (8Mb x 8), TSOP II 54pin',ref_prefix='U',num_units=1,do_erc=True,aliases=['MT48LC8M8A2P'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='DQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='DQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='BA0',do_erc=True),
            Pin(num='30',name='A5',do_erc=True),
            Pin(num='50',name='DQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='BA1',do_erc=True),
            Pin(num='31',name='A6',do_erc=True),
            Pin(num='41',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='A10',do_erc=True),
            Pin(num='32',name='A7',do_erc=True),
            Pin(num='52',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='A0',do_erc=True),
            Pin(num='33',name='A8',do_erc=True),
            Pin(num='43',name='VDDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='DQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='A1',do_erc=True),
            Pin(num='34',name='A9',do_erc=True),
            Pin(num='44',name='DQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='A2',do_erc=True),
            Pin(num='35',name='A11',do_erc=True),
            Pin(num='16',name='~WE~',do_erc=True),
            Pin(num='26',name='A3',do_erc=True),
            Pin(num='46',name='VSSQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~CAS~',do_erc=True),
            Pin(num='27',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='CKE',do_erc=True),
            Pin(num='47',name='DQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='~RAS~',do_erc=True),
            Pin(num='28',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='CLK',do_erc=True),
            Pin(num='19',name='~CS~',do_erc=True),
            Pin(num='29',name='A4',do_erc=True),
            Pin(num='39',name='DQM',do_erc=True),
            Pin(num='49',name='VDDQ',func=Pin.PWRIN,do_erc=True)]),
        Part(name='RAM_32KO',dest=TEMPLATE,tool=SKIDL,keywords='RAM 32KO',description='RAM 32 Ko',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A14',do_erc=True),
            Pin(num='2',name='A12',do_erc=True),
            Pin(num='3',name='A7',do_erc=True),
            Pin(num='4',name='A6',do_erc=True),
            Pin(num='5',name='A5',do_erc=True),
            Pin(num='6',name='A4',do_erc=True),
            Pin(num='7',name='A3',do_erc=True),
            Pin(num='8',name='A2',do_erc=True),
            Pin(num='9',name='A1',do_erc=True),
            Pin(num='10',name='A0',do_erc=True),
            Pin(num='20',name='CS',do_erc=True),
            Pin(num='11',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='A10',do_erc=True),
            Pin(num='12',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='OE',do_erc=True),
            Pin(num='13',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A11',do_erc=True),
            Pin(num='24',name='A9',do_erc=True),
            Pin(num='15',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A8',do_erc=True),
            Pin(num='16',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='A13',do_erc=True),
            Pin(num='17',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='WE',do_erc=True),
            Pin(num='18',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='SIM4X32',dest=TEMPLATE,tool=SKIDL,keywords='DRAM 4MO',description='Barrette SIMM 4Mo (1M x 32bits)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='DQ0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='DQ16',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='DQ1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='DQ17',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='DQ2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='DQ18',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='DQ3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='DQ19',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='DQ4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='CAS0',do_erc=True),
            Pin(num='50',name='DQ24',func=Pin.TRISTATE,do_erc=True),
            Pin(num='60',name='DQ29',func=Pin.TRISTATE,do_erc=True),
            Pin(num='70',name='PRD3',do_erc=True),
            Pin(num='21',name='DQ20',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='A8',do_erc=True),
            Pin(num='41',name='CAS1',do_erc=True),
            Pin(num='51',name='DQ9',func=Pin.TRISTATE,do_erc=True),
            Pin(num='61',name='DQ13',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='DQ5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='A9',do_erc=True),
            Pin(num='42',name='CAS2',do_erc=True),
            Pin(num='52',name='DQ25',func=Pin.TRISTATE,do_erc=True),
            Pin(num='62',name='DQ30',func=Pin.TRISTATE,do_erc=True),
            Pin(num='72',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='A1',do_erc=True),
            Pin(num='23',name='DQ21',func=Pin.TRISTATE,do_erc=True),
            Pin(num='43',name='CAS3',do_erc=True),
            Pin(num='53',name='DQ10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='63',name='DQ14',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='A2',do_erc=True),
            Pin(num='24',name='DQ6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='34',name='RAS2',do_erc=True),
            Pin(num='44',name='RAS0',do_erc=True),
            Pin(num='54',name='DQ26',func=Pin.TRISTATE,do_erc=True),
            Pin(num='64',name='DQ31',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='A3',do_erc=True),
            Pin(num='25',name='DQ22',func=Pin.TRISTATE,do_erc=True),
            Pin(num='55',name='DQ11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='65',name='DQ15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='A4',do_erc=True),
            Pin(num='26',name='DQ7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='56',name='DQ27',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='A5',do_erc=True),
            Pin(num='27',name='DQ23',func=Pin.TRISTATE,do_erc=True),
            Pin(num='47',name='R/W',do_erc=True),
            Pin(num='57',name='DQ12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='67',name='PRD0',do_erc=True),
            Pin(num='18',name='A6',do_erc=True),
            Pin(num='28',name='A7',do_erc=True),
            Pin(num='58',name='DQ28',func=Pin.TRISTATE,do_erc=True),
            Pin(num='68',name='PRD1',do_erc=True),
            Pin(num='19',name='A10',do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='DQ8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='59',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='69',name='PRD2',do_erc=True)]),
        Part(name='SIMM',dest=TEMPLATE,tool=SKIDL,keywords='DRAM 1MO',description='Barrette SIMM 1 Mo ( 1M x 9 bits)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CAS',do_erc=True),
            Pin(num='3',name='DQ0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='A0',do_erc=True),
            Pin(num='5',name='A1',do_erc=True),
            Pin(num='6',name='DQ1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='A2',do_erc=True),
            Pin(num='8',name='A3',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='DQ2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='DQ5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='A4',do_erc=True),
            Pin(num='21',name='WR',do_erc=True),
            Pin(num='12',name='A5',do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DQ3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='DQ6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='A6',do_erc=True),
            Pin(num='15',name='A7',do_erc=True),
            Pin(num='25',name='DQ7',do_erc=True),
            Pin(num='16',name='DQ4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='QP',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='A8',do_erc=True),
            Pin(num='27',name='RAS',do_erc=True),
            Pin(num='18',name='A9',do_erc=True),
            Pin(num='28',name='CASP',do_erc=True),
            Pin(num='19',name='A10',do_erc=True),
            Pin(num='29',name='DP',do_erc=True)]),
        Part(name='SRAM_512Ko',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SST39SF010',dest=TEMPLATE,tool=SKIDL,keywords='128k flash rom',description='Silicon Storage Technology (SSF) 128k x 8 Flash ROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='NC',do_erc=True),
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A15',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='NC',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='PGM',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='A14',do_erc=True)]),
        Part(name='SST39SF020',dest=TEMPLATE,tool=SKIDL,keywords='256k flash rom',description='Silicon Storage Technology (SSF) 256k x 8 Flash ROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='NC',do_erc=True),
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A15',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='A17',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='PGM',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='A14',do_erc=True)]),
        Part(name='SST39SF040',dest=TEMPLATE,tool=SKIDL,keywords='512k flash rom',description='Silicon Storage Technology (SSF) 512k x 8 Flash ROM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='A18',do_erc=True),
            Pin(num='2',name='A16',do_erc=True),
            Pin(num='3',name='A15',do_erc=True),
            Pin(num='4',name='A12',do_erc=True),
            Pin(num='5',name='A7',do_erc=True),
            Pin(num='6',name='A6',do_erc=True),
            Pin(num='7',name='A5',do_erc=True),
            Pin(num='8',name='A4',do_erc=True),
            Pin(num='9',name='A3',do_erc=True),
            Pin(num='10',name='A2',do_erc=True),
            Pin(num='20',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='A17',do_erc=True),
            Pin(num='11',name='A1',do_erc=True),
            Pin(num='21',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='PGM',do_erc=True),
            Pin(num='12',name='A0',do_erc=True),
            Pin(num='22',name='CE',do_erc=True),
            Pin(num='13',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='A10',do_erc=True),
            Pin(num='14',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='OE',do_erc=True),
            Pin(num='15',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='A11',do_erc=True),
            Pin(num='26',name='A9',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='A8',do_erc=True),
            Pin(num='18',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='A13',do_erc=True),
            Pin(num='19',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='A14',do_erc=True)]),
        Part(name='TC524256Z',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='TMS4C1050N',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='UPD42280V',dest=TEMPLATE,tool=SKIDL,do_erc=True)])