from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

ESD_Protection = SchLib(tool=SKIDL).add_parts(*[
        Part(name='IP3319CX6',dest=TEMPLATE,tool=SKIDL,keywords='common mode filter ESD protection',description='Single channel common mode filter with integrated ESD protection network',ref_prefix='U',num_units=1,fplist=['WLCSP*1.4x1.0mm*Pitch0.4mm*'],do_erc=True,pins=[
            Pin(num='A1',name='D+_OUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B1',name='D-_OUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C1',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='A2',name='D+_IN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B2',name='D-_IN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C2',name='ID',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='NUP2105L',dest=TEMPLATE,tool=SKIDL,keywords='can esd protection suppression transient automotive',description='Dual Line CAN Bus Protector, 24Vrwm, Automotive Grade',ref_prefix='D',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['SZNUP2105L'],pins=[
            Pin(num='3',name='A',do_erc=True),
            Pin(num='1',name='K',do_erc=True),
            Pin(num='2',name='K',do_erc=True)]),
        Part(name='PESD3V3L4UF',dest=TEMPLATE,tool=SKIDL,keywords='diode',description='Low capacitance unidirectional quadruple ESD protection diode array, 5.0V, Common Anode, SOT-665',ref_prefix='D',num_units=4,fplist=['SOT*'],do_erc=True,aliases=['PESD3V3L4UG', 'PESD3V3L4UW', 'PESD5V0L4UF', 'PESD5V0L4UG', 'PESD5V0L4UW'],pins=[
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='K1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='K2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='K3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='K4',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PESD3V3L5UF',dest=TEMPLATE,tool=SKIDL,keywords='diode',description='Low capacitance unidirectional fivefold ESD protection diode array, 5.0V, Common Anode, SOT-363',ref_prefix='D',num_units=5,fplist=['SOT*'],do_erc=True,aliases=['PESD3V3L5UV', 'PESD3V3L5UY', 'PESD5V0L5UF', 'PESD5V0L5UV', 'PESD5V0L5UY'],pins=[
            Pin(num='2',name='A',func=Pin.PASSIVE,do_erc=True),
            Pin(num='1',name='K1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='K2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='K3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='K4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='K5',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='PRTR5V0U2X',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='SN65220',dest=TEMPLATE,tool=SKIDL,keywords='USB suppressor',description='USB port transient suppressors',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='B',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='A',do_erc=True)]),
        Part(name='SN75240',dest=TEMPLATE,tool=SKIDL,keywords='USB suppressor',description='USB port transient suppressors',ref_prefix='U',num_units=2,fplist=['DIP*7.62mm*', 'TSSOP*4.4x3mm*0.65mm*'],do_erc=True,aliases=['SN65240'],pins=[
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='B',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='A',do_erc=True),
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='C',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='D',do_erc=True)]),
        Part(name='SP0502BAHT',dest=TEMPLATE,tool=SKIDL,keywords='usb esd protection suppression transient',description='TVS Diode Array, 5.5V Standoff, 2 Channels, SOT-23 package',ref_prefix='D',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='3',name='A',do_erc=True),
            Pin(num='1',name='K',do_erc=True),
            Pin(num='2',name='K',do_erc=True)]),
        Part(name='SP0502BAJT',dest=TEMPLATE,tool=SKIDL,keywords='usb esd protection suppression transient',description='TVS Diode Array, 5.5V Standoff, 2 Channels, SC-70 package',ref_prefix='D',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='3',name='A',do_erc=True),
            Pin(num='1',name='K',do_erc=True),
            Pin(num='2',name='K',do_erc=True)]),
        Part(name='SP0503BAHT',dest=TEMPLATE,tool=SKIDL,keywords='usb esd protection suppression transient',description='TVS Diode Array, 5.5V Standoff, 3 Channels, SOT-143 package',ref_prefix='D',num_units=1,fplist=['SOT-143*'],do_erc=True,pins=[
            Pin(num='1',name='A',do_erc=True),
            Pin(num='2',name='K',do_erc=True),
            Pin(num='3',name='K',do_erc=True),
            Pin(num='4',name='K',do_erc=True)]),
        Part(name='SP0504BAHT',dest=TEMPLATE,tool=SKIDL,keywords='usb esd protection suppression transient',description='TVS Diode Array, 5.5V Standoff, 4 Channels, SOT-23-5 package',ref_prefix='D',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='2',name='A',do_erc=True),
            Pin(num='1',name='K',do_erc=True),
            Pin(num='3',name='K',do_erc=True),
            Pin(num='4',name='K',do_erc=True),
            Pin(num='5',name='K',do_erc=True)]),
        Part(name='SP0504BAJT',dest=TEMPLATE,tool=SKIDL,keywords='usb esd protection suppression transient',description='TVS Diode Array, 5.5V Standoff, 4 Channels, SC-70-5 package',ref_prefix='D',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='2',name='A',do_erc=True),
            Pin(num='1',name='K',do_erc=True),
            Pin(num='3',name='K',do_erc=True),
            Pin(num='4',name='K',do_erc=True),
            Pin(num='5',name='K',do_erc=True)]),
        Part(name='SP0505BAHT',dest=TEMPLATE,tool=SKIDL,keywords='usb esd protection suppression transient',description='TVS Diode Array, 5.5V Standoff, 5 Channels, SOT-23-6 package',ref_prefix='D',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='2',name='A',do_erc=True),
            Pin(num='1',name='K',do_erc=True),
            Pin(num='3',name='K',do_erc=True),
            Pin(num='4',name='K',do_erc=True),
            Pin(num='5',name='K',do_erc=True),
            Pin(num='6',name='K',do_erc=True)]),
        Part(name='SP0505BAJT',dest=TEMPLATE,tool=SKIDL,keywords='usb esd protection suppression transient',description='TVS Diode Array, 5.5V Standoff, 5 Channels, SC-70-6 package',ref_prefix='D',num_units=1,fplist=['SC-70*'],do_erc=True,pins=[
            Pin(num='2',name='A',do_erc=True),
            Pin(num='1',name='K',do_erc=True),
            Pin(num='3',name='K',do_erc=True),
            Pin(num='4',name='K',do_erc=True),
            Pin(num='5',name='K',do_erc=True),
            Pin(num='6',name='K',do_erc=True)]),
        Part(name='SRV05',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='TPD2EUSB30',dest=TEMPLATE,tool=SKIDL,keywords='ESD protection USB 3.0',description='2 channel ESD protection for super-speed USB 3.0',ref_prefix='U',num_units=1,fplist=['DRT*'],do_erc=True,pins=[
            Pin(num='1',name='D+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='D-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPD2S017',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='TPD4EUSB30',dest=TEMPLATE,tool=SKIDL,keywords='ESD protection USB 3.0',description='4 channel ESD protection for super-speed USB 3.0',ref_prefix='U',num_units=1,fplist=['USON*2.5x1.0mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='D1+',do_erc=True),
            Pin(num='2',name='D1-',do_erc=True),
            Pin(num='3',name='GND',do_erc=True),
            Pin(num='4',name='D2+',do_erc=True),
            Pin(num='5',name='D2-',do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='GND',do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='TPD4S1394',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='TPD8F003',dest=TEMPLATE,tool=SKIDL,keywords='EMI, ESD protection',description='8 channel EMI filters with integrated ESD protection',ref_prefix='U',num_units=1,fplist=['WSON*3.3x1.35mm*Pitch0.4mm*'],do_erc=True,pins=[
            Pin(num='1',name='Ch1_In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='Ch2_In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Ch3_In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='Ch4_In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='Ch5_In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='Ch6_In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='Ch7_In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='Ch8_In',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='Ch8_Out',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='Ch7_Out',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='Ch6_Out',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='Ch5_Out',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='Ch4_Out',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='Ch3_Out',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='Ch2_Out',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='Ch1_Out',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='USB6B1',dest=TEMPLATE,tool=SKIDL,keywords='ESD USB',description='5V Data line protection',ref_prefix='U',num_units=1,fplist=['SO*', 'SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='I/O1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='I/O2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Vcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='I/O1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='I/O2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='USBLC6-2SC6',dest=TEMPLATE,tool=SKIDL,keywords='usb ethernet',description='Bidirectional ESD Protection Diode, SOT-23-6',ref_prefix='U',num_units=1,fplist=['SOT-23-*'],do_erc=True,pins=[
            Pin(num='1',name='IO1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IO2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='IO2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='VBUS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='IO1',func=Pin.PASSIVE,do_erc=True)])])