from skidl import Pin, Part, SchLib, SKIDL, TEMPLATE

SKIDL_lib_version = '0.0.1'

_74xgxx = SchLib(tool=SKIDL).add_parts(*[
        Part(name='74AUC1G74',dest=TEMPLATE,tool=SKIDL,keywords='Single D Flip-Flop D CMOS',description='Single D Flip-Flop, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUP1G74'],pins=[
            Pin(num='1',name='C',do_erc=True),
            Pin(num='2',name='D',do_erc=True),
            Pin(num='3',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~CLR',do_erc=True),
            Pin(num='7',name='~PRE',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74CBT1G125',dest=TEMPLATE,tool=SKIDL,keywords='Single FET Bus Switch',description='Single FET Bus Switch',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,aliases=['74CB3T1G125', '74CBTD1G125', '74CBTLV1G125'],pins=[
            Pin(num='1',name='~OE',do_erc=True),
            Pin(num='2',name='A',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='B',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74CBT1G384',dest=TEMPLATE,tool=SKIDL,keywords='Single FET Bus Switch',description='Single FET Bus Switch',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,aliases=['74CBTD1G384'],pins=[
            Pin(num='1',name='A',do_erc=True),
            Pin(num='2',name='B',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~OE',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G00',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate NAND LVC CMOS',description='Single NAND Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AHC1G00', '74AHCT1G00', '74AUC1G00', '74AUP1G00'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G02',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate NOR LVC CMOS',description='Single NOR Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AHC1G02', '74AHCT1G02', '74AUC1G02', '74AUP1G02'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G04',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate NOT LVC CMOS',description='74LVC1G04, Single NOT Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74LVC1GU04', '74AHC1G04', '74AHCT1G04', '74AUC1G04', '74AUP1G04', '74AHC1GU04', '74AHCT1GU04', '74AUC1GU04', '74AUP1GU04'],pins=[
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G06',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate NOT LVC CMOS Open Drain',description='Single NOT Gate w/ Open Drain, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AUC1G06', '74AUP1G06'],pins=[
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G07',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate Buff LVC CMOS Open Drain',description='Single Buffer Gate w/ Open Drain, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AUC1G07', '74AUP1G07'],pins=[
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G08',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate AND LVC CMOS',description='Single AND Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AHC1G08', '74AHCT1G08', '74AUC1G08', '74AUP1G08'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G0832',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate AND-OR LVC CMOS',description='Single AND-OR Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC1G10',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate NAND 3in LVC CMOS',description='Single NAND 3in Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC1G11',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate AND 3in LVC CMOS',description='Single AND 3in Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC1G123',dest=TEMPLATE,tool=SKIDL,keywords='Single Mono Multivibrator CMOS',description='Single Retrigerrable Monostabile Multivibrator, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='~A',do_erc=True),
            Pin(num='2',name='B',do_erc=True),
            Pin(num='3',name='~CLR',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Cext',do_erc=True),
            Pin(num='7',name='Rext',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G125',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate Buff Tri-State LVC CMOS',description='Single Buffer Gate Tri-State, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AHC1G125', '74AHCT1G125', '74AUC1G125', '74AUP1G125'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G126',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate Buff Tri-State LVC CMOS',description='Single Buffer Gate Tri-State, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AHC1G126', '74AHCT1G126', '74AUC1G126', '74AUP1G126'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G139',dest=TEMPLATE,tool=SKIDL,keywords='Single Decoder LVC CMOS',description='2 to 4 Decoder, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='A',do_erc=True),
            Pin(num='2',name='B',do_erc=True),
            Pin(num='3',name='Y3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Y2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Y1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Y0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G14',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate NOT Schmidt LVC CMOS',description='Single Schmidt NOT Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AHC1G14', '74AHCT1G14', '74AUC1G14', '74AUP1G14'],pins=[
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G17',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate Buff Schmidt LVC CMOS',description='Single Schmidt Buffer Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AUC1G17', '74AUP1G17'],pins=[
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G175',dest=TEMPLATE,tool=SKIDL,keywords='Single D Flip-Flop Clear CMOS',description='Single D Flip-Flop w/ Asnynchronus Clear, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,pins=[
            Pin(num='1',name='C',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D',do_erc=True),
            Pin(num='4',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~CLR',do_erc=True)]),
        Part(name='74LVC1G18',dest=TEMPLATE,tool=SKIDL,keywords='Single Demux LVC CMOS',description='Single Demultiplexer, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AUC1G18'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='74LVC1G19',dest=TEMPLATE,tool=SKIDL,keywords='Single Decoder LVC CMOS',description='1 of 2 Decoder, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AUC1G19'],pins=[
            Pin(num='1',name='A',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~E',do_erc=True),
            Pin(num='4',name='Y1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='Y0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LVC1G240',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate Buff/Drv Tri-State LVC CMOS',description='Single Buffer/Driver Gate Tri-State, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AUC1G240', '74AUP1G240'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G27',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate NOR 3in LVC CMOS',description='Single NOR 3in Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC1G29',dest=TEMPLATE,tool=SKIDL,keywords='Single Decoder LVC CMOS',description='2 of 3 Decoder, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='~G',do_erc=True),
            Pin(num='2',name='Y1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Y2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='A1',do_erc=True),
            Pin(num='7',name='Y0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G3157',dest=TEMPLATE,tool=SKIDL,keywords='SPDT Analog Switch CMOS',description='SPDT Analog Swich, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='1',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~',func=Pin.BIDIR,do_erc=True)]),
        Part(name='74LVC1G32',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate OR LVC CMOS',description='Single OR Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AHC1G32', '74AHCT1G32', '74AUC1G32', '74AUP1G32'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G3208',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate OR-AND LVC CMOS',description='Single OR-AND Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC1G332',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate OR 3in LVC CMOS',description='Single OR 3in Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC1G34',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate Buff LVC CMOS',description='Single Buffef Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AUP1G34'],pins=[
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G373',dest=TEMPLATE,tool=SKIDL,keywords='Single D Latch CMOS',description='Single D Latch, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,pins=[
            Pin(num='1',name='LE',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D',do_erc=True),
            Pin(num='4',name='Q',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~OE',do_erc=True)]),
        Part(name='74LVC1G374',dest=TEMPLATE,tool=SKIDL,keywords='Single D Flip-Flop Tri-State CMOS',description='Single D Flip-Flop Tri-State Output, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,pins=[
            Pin(num='1',name='CLK',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='D',do_erc=True),
            Pin(num='4',name='Q',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~OE',do_erc=True)]),
        Part(name='74LVC1G38',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate NAND Open Drain LVC CMOS',description='Single NAND Gate Open Drain, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G386',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate EX-OR 3in LVC CMOS',description='Single EX-OR 3in Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC1G57',dest=TEMPLATE,tool=SKIDL,keywords='Configurable Single Gate LVC CMOS',description='Configurable Multi-Function Single Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,aliases=['74AUP1G57', '74LVC1G97', '74AUP1G97'],pins=[
            Pin(num='1',name='IN1',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN0',do_erc=True),
            Pin(num='4',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='IN2',do_erc=True)]),
        Part(name='74LVC1G58',dest=TEMPLATE,tool=SKIDL,keywords='Configurable Single Gate LVC CMOS',description='Configurable Multi-Function Single Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,aliases=['74AUP1G58', '74LVC1G98', '74AUP1G98'],pins=[
            Pin(num='1',name='IN1',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN0',do_erc=True),
            Pin(num='4',name='~Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='IN2',do_erc=True)]),
        Part(name='74LVC1G66',dest=TEMPLATE,tool=SKIDL,keywords='Single Analog Switch',description='Single Analog Switch',ref_prefix='U',num_units=1,fplist=['SOT*', 'SC*'],do_erc=True,aliases=['74AUC1G66'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G79',dest=TEMPLATE,tool=SKIDL,keywords='Single D Flip-Flop D CMOS',description='Single D Flip-Flop, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG*'],do_erc=True,aliases=['74AUC1G79', '74AUP1G79'],pins=[
            Pin(num='1',name='D',do_erc=True),
            Pin(num='2',name='C',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G80',dest=TEMPLATE,tool=SKIDL,keywords='Single D Flip-Flop CMOS',description='Single D Flip-Flop Iverted Output, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG*'],do_erc=True,aliases=['74AUC1G80', '74AUP1G80'],pins=[
            Pin(num='1',name='D',do_erc=True),
            Pin(num='2',name='C',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G86',dest=TEMPLATE,tool=SKIDL,keywords='Single Gate EX-OR LVC CMOS',description='Single EX-OR Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SOT*', 'SG-*'],do_erc=True,aliases=['74AHC1G86', '74AHCT1G86', '74AUC1G86'],pins=[
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC1G99',dest=TEMPLATE,tool=SKIDL,keywords='Configurable Single Gate LVC CMOS',description='Configurable Multi-Function Single Gate, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUP1G99'],pins=[
            Pin(num='1',name='~OE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='A',do_erc=True),
            Pin(num='3',name='B',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='C',do_erc=True),
            Pin(num='6',name='D',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC2G00',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate NAND LVC CMOS',description='Dual NAND Gate, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G00'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC2G02',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate NOR LVC CMOS',description='Dual NOR Gate, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G02'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC2G04',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate NOT LVC CMOS',description='74LVC2G04, Dual NOT Gate, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SG-*', 'SOT*'],do_erc=True,aliases=['74AUC2G04', '74LVC2GU04', '74AUC2GU04'],pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LVC2G06',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate NOT Open Drain LVC CMOS',description='Dual NOT Gate w/ Open Drain, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SG-*', 'SOT*'],do_erc=True,aliases=['74AUC2G06'],pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LVC2G07',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate Buffer Open Drain LVC CMOS',description='Dual Buffer w/ Open Drain, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SG-*', 'SOT*'],do_erc=True,aliases=['74AUC2G07'],pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LVC2G08',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate AND LVC CMOS',description='Dual AND Gate, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G08'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC2G125',dest=TEMPLATE,tool=SKIDL,keywords='Dual Buff Tri-State LVC CMOS',description='Dual Buffer Tri-State, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['VSSOP*'],do_erc=True,aliases=['74AUC2G125'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='7',name='~',do_erc=True)]),
        Part(name='74LVC2G126',dest=TEMPLATE,tool=SKIDL,keywords='Dual Buff Tri-State LVC CMOS',description='Dual Buffer Tri-State, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['VSSOP*'],do_erc=True,aliases=['74AUC2G126'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='7',name='~',do_erc=True)]),
        Part(name='74LVC2G14',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate NOT Schmidt LVC CMOS',description='Dual NOT Gate Schmidt Triggered, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SG-*', 'SOT*'],do_erc=True,pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LVC2G157',dest=TEMPLATE,tool=SKIDL,keywords='Single Mux CMOS',description='Single 2 to 1 Multiplexer, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='A',do_erc=True),
            Pin(num='2',name='B',do_erc=True),
            Pin(num='3',name='~Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~A~/B',do_erc=True),
            Pin(num='7',name='~G',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC2G17',dest=TEMPLATE,tool=SKIDL,keywords='Dual Buffer Schmidt LVC CMOS',description='Dual Buffer Schmidt Triggered, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SG-*', 'SOT*'],do_erc=True,pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LVC2G240',dest=TEMPLATE,tool=SKIDL,keywords='Dual Inv Buff Tri-State LVC CMOS',description='Dual Inverter Buffer Tri-State, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['VSSOP*'],do_erc=True,aliases=['74AUC2G240'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='7',name='~',do_erc=True)]),
        Part(name='74LVC2G241',dest=TEMPLATE,tool=SKIDL,keywords='Dual Buff Tri-State LVC CMOS',description='Dual Buffer Tri-State, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['VSSOP*'],do_erc=True,aliases=['74AUC2G241'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='7',name='~',do_erc=True)]),
        Part(name='74LVC2G32',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate OR LVC CMOS',description='Dual OR Gate, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G32'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC2G34',dest=TEMPLATE,tool=SKIDL,keywords='Dual Buffer LVC CMOS',description='Dual Buffer, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SG-*', 'SOT*'],do_erc=True,aliases=['74AUC2G34'],pins=[
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LVC2G38',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate NAND Open Drain LVC CMOS',description='Dual NAND Gate w/ Open Drain, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC2G53',dest=TEMPLATE,tool=SKIDL,keywords='Analog Switch 1 to 2 CMOS',description='1 to 2 Analog Swich Mux/Demux, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G53'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~',func=Pin.BIDIR,do_erc=True)]),
        Part(name='74LVC2G66',dest=TEMPLATE,tool=SKIDL,keywords='Dual Analog Switch',description='Dual Analog Switch',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G66'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='74LVC2G74',dest=TEMPLATE,tool=SKIDL,keywords='Single D Flip-Flop D CMOS',description='74AUC1G74, Single D Flip-Flop, Low-Voltage CMOS',ref_prefix='U',num_units=1,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='1',name='C',do_erc=True),
            Pin(num='2',name='D',do_erc=True),
            Pin(num='3',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~CLR',do_erc=True),
            Pin(num='7',name='~PRE',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='74LVC2G79',dest=TEMPLATE,tool=SKIDL,keywords='Dual D Flip-Flop D CMOS',description='Dual D Flip-Flop, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G79'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='C',do_erc=True),
            Pin(num='2',name='D',do_erc=True),
            Pin(num='7',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='C',do_erc=True),
            Pin(num='6',name='D',do_erc=True)]),
        Part(name='74LVC2G80',dest=TEMPLATE,tool=SKIDL,keywords='Dual D Flip-Flop Negative CMOS',description='Dual D Flip-Flop w/ Negative Output, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G80'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='C',do_erc=True),
            Pin(num='2',name='D',do_erc=True),
            Pin(num='7',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='C',do_erc=True),
            Pin(num='6',name='D',do_erc=True)]),
        Part(name='74LVC2G86',dest=TEMPLATE,tool=SKIDL,keywords='Dual Gate EX-OR LVC CMOS',description='Dual EX-OR Gate, Low-Voltage CMOS',ref_prefix='U',num_units=2,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74AUC2G86'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True)]),
        Part(name='74LVC3G04',dest=TEMPLATE,tool=SKIDL,keywords='Triple Gate NOT LVC CMOS',description='74LVC3G04, Triple NOT Gate, Low-Voltage CMOS',ref_prefix='U',num_units=3,fplist=['SSOP*', 'VSSOP*'],do_erc=True,aliases=['74LVC3GU04'],pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='5',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LVC3G06',dest=TEMPLATE,tool=SKIDL,keywords='Triple Gate NOT Open Drain LVC CMOS',description='Triple NOT Gate w/ Open Drain, Low-Voltage CMOS',ref_prefix='U',num_units=3,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='5',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LVC3G07',dest=TEMPLATE,tool=SKIDL,keywords='Triple Buff Open Drain LVC CMOS',description='Triple Buffer w/ Open Drain, Low-Voltage CMOS',ref_prefix='U',num_units=3,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='5',name='~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='74LVC3G14',dest=TEMPLATE,tool=SKIDL,keywords='Triple NOT Schmidt LVC CMOS',description='Triple NOT Gate Schmidt, Low-Voltage CMOS',ref_prefix='U',num_units=3,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='5',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LVC3G17',dest=TEMPLATE,tool=SKIDL,keywords='Triple Buf Schmidt LVC CMOS',description='Triple Buffer Schmidt, Low-Voltage CMOS',ref_prefix='U',num_units=3,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='5',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='74LVC3G34',dest=TEMPLATE,tool=SKIDL,keywords='Triple Buf LVC CMOS',description='Triple Buffer, Low-Voltage CMOS',ref_prefix='U',num_units=3,fplist=['SSOP*', 'VSSOP*'],do_erc=True,pins=[
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='7',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='5',name='~',func=Pin.OUTPUT,do_erc=True)])])