/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.snu.ids.ha.dic.Dictionary;
import org.snu.ids.ha.index.Keyword;
import org.snu.ids.ha.index.KeywordExtractor;
import org.snu.ids.ha.index.KeywordList;
import org.snu.ids.ha.ma.MExpression;
import org.snu.ids.ha.ma.Sentence;
import org.snu.ids.ha.util.Timer;
import org.snu.ids.ha.util.Util;

public class TesterGUI
extends JFrame {
    JTextArea logText = null;
    JPanel statusPanel = null;
    KeywordExtractor ke = null;
    JProgressBar progressBar = null;
    JLabel lineLabel = null;
    JLabel statusLabel = null;

    public static void main(String[] args) {
        TesterGUI gui = new TesterGUI();
        gui.setVisible(true);
    }

    public TesterGUI() {
        this.setSize(1024, 800);
        this.setDefaultCloseOperation(3);
        this.setTitle("Korean Morpheme Analyzer Tester");
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("\uc0c9\uc778\uc5b4 \ucd94\ucd9c\uae30", new KEPanel());
        tabPane.addTab("\ubd84\uc11d\uae30", new MAPanel());
        JSplitPane sp = new JSplitPane(0, tabPane, this.getLogPanel());
        sp.setOneTouchExpandable(true);
        sp.setDividerLocation(600);
        c.add((Component)sp, "Center");
        this.statusPanel = new JPanel(new FlowLayout(2));
        this.statusPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.lineLabel = new JLabel();
        this.statusPanel.add(this.lineLabel);
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(200, 15));
        this.progressBar.setBorderPainted(false);
        this.statusPanel.add(this.progressBar);
        this.statusLabel = new JLabel();
        this.statusPanel.add(this.statusLabel);
        c.add((Component)this.statusPanel, "South");
    }

    void createKE() {
        this.startJob("\uc0ac\uc804 \uc77d\uae30");
        Timer timer = new Timer();
        timer.start();
        this.ke = new KeywordExtractor();
        timer.stop();
        this.endJob(timer.getInterval());
    }

    void startJob(String job) {
        this.progressBar.setIndeterminate(true);
        this.progressBar.setBorderPainted(true);
        this.statusLabel.setText(job);
        this.printlog(job);
    }

    void endJob(double interval) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBorderPainted(false);
        this.statusLabel.setText(String.valueOf(interval) + "\ucd08");
        this.printlog("\uc644\ub8cc: " + interval + "\ucd08");
    }

    public JPanel getLogPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Console"));
        this.logText = new JTextArea();
        this.logText.setTabSize(4);
        this.logText.setEditable(false);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(this.logText);
        panel.add((Component)sp, "Center");
        return panel;
    }

    void printlog(final String log) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                TesterGUI.this.logText.append(String.valueOf(log) + "\n");
            }
        };
        thread.start();
    }

    class KEPanel
    extends JPanel
    implements ActionListener {
        JTextArea srcText;
        JCheckBox onlyNounCheck;
        JTable table;
        KeywordList keywordList;
        File recentDir;

        public KEPanel() {
            super(new BorderLayout());
            this.srcText = null;
            this.onlyNounCheck = null;
            this.table = null;
            this.keywordList = null;
            this.recentDir = null;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JSplitPane sp = new JSplitPane(1, this.getSrcPane(), this.getResultPane());
            sp.setOneTouchExpandable(true);
            sp.setDividerLocation(500);
            this.add((Component)sp, "Center");
        }

        public JPanel getSrcPane() {
            JPanel panel = new JPanel(new BorderLayout());
            JPanel menuPanel = new JPanel(new FlowLayout(2));
            this.onlyNounCheck = new JCheckBox("\uba85\uc0ac\ub9cc \ucd94\ucd9c");
            menuPanel.add(this.onlyNounCheck);
            JButton button = new JButton("\ud30c\uc77c \uc5f4\uae30");
            button.setActionCommand("OPEN_FILE");
            button.addActionListener(this);
            menuPanel.add(button);
            button = new JButton("\ud30c\uc77c\ub85c \uc800\uc7a5");
            button.setActionCommand("SAVE_TO_FILE");
            button.addActionListener(this);
            menuPanel.add(button);
            button = new JButton("\ubd84\uc11d\ud558\uae30");
            button.setActionCommand("ANALYZE");
            button.addActionListener(this);
            menuPanel.add(button);
            panel.add((Component)menuPanel, "North");
            this.srcText = new JTextArea();
            this.srcText.setTabSize(4);
            JScrollPane sp = new JScrollPane();
            sp.getViewport().add(this.srcText);
            JPanel srcPanel = new JPanel(new BorderLayout());
            srcPanel.setBorder(BorderFactory.createTitledBorder("Contents"));
            srcPanel.add(sp);
            panel.add((Component)srcPanel, "Center");
            return panel;
        }

        public JPanel getResultPane() {
            JPanel panel = new JPanel(new BorderLayout());
            this.table = new JTable(new KeywordDataModel());
            this.table.setAutoCreateRowSorter(true);
            JScrollPane sp = new JScrollPane();
            sp.getViewport().add(this.table);
            panel.add((Component)sp, "Center");
            return panel;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (cmd.equals("OPEN_FILE")) {
                JFileChooser jfc = new JFileChooser();
                if (this.recentDir == null) {
                    File curDir = new File("");
                    this.recentDir = curDir.getAbsoluteFile();
                }
                jfc.setCurrentDirectory(this.recentDir);
                if (jfc.showOpenDialog(this) == 0) {
                    File file = jfc.getSelectedFile();
                    this.recentDir = file.getParentFile();
                    this.readFile(file);
                }
            } else if (cmd.equals("SAVE_TO_FILE")) {
                JFileChooser jfc = new JFileChooser();
                File curDir = new File("");
                jfc.setCurrentDirectory(curDir.getAbsoluteFile());
                if (jfc.showSaveDialog(this) == 0) {
                    File file = jfc.getSelectedFile();
                    this.recentDir = file.getParentFile();
                    this.saveToFile(file);
                }
            } else if (cmd.equals("ANALYZE")) {
                this.analyze();
            }
        }

        void readFile(File file) {
            BufferedReader br = null;
            try {
                TesterGUI.this.printlog("READING FILE: " + file.getAbsolutePath());
                br = new BufferedReader(new FileReader(file));
                String line = null;
                this.cleanSrcText();
                while ((line = br.readLine()) != null) {
                    this.srcText.append(String.valueOf(line) + "\n");
                }
                this.srcText.updateUI();
                br.close();
            }
            catch (Exception e) {
                TesterGUI.this.printlog("ERROR: " + e.toString());
            }
        }

        void saveToFile(File file) {
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(file);
                int i = 0;
                int size = this.keywordList == null ? 0 : this.keywordList.size();
                while (i < size) {
                    Keyword keyword = (Keyword)this.keywordList.get(i);
                    pw.println(String.valueOf(keyword.getIndex()) + "\t" + keyword.getString() + "\t" + keyword.getTag() + "\t" + keyword.getCnt());
                    ++i;
                }
                pw.flush();
                pw.close();
            }
            catch (Exception e) {
                TesterGUI.this.printlog("ERROR: " + e.toString());
            }
        }

        void cleanSrcText() {
            this.srcText.setText("");
        }

        void analyze() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    String string = KEPanel.this.srcText.getText();
                    if (!Util.valid(string)) {
                        TesterGUI.this.printlog("\ubd84\uc11d\ud560 \ubb38\uc7a5\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        return;
                    }
                    try {
                        if (((KEPanel)KEPanel.this).TesterGUI.this.ke == null) {
                            TesterGUI.this.createKE();
                        }
                        TesterGUI.this.startJob("\ub2e8\uc5b4 \ucd94\ucd9c");
                        Timer timer = new Timer();
                        timer.start();
                        KEPanel.this.keywordList = ((KEPanel)KEPanel.this).TesterGUI.this.ke.extractKeyword(((KEPanel)KEPanel.this).TesterGUI.this.progressBar, ((KEPanel)KEPanel.this).TesterGUI.this.lineLabel, string, KEPanel.this.onlyNounCheck.isSelected());
                        KEPanel.this.updateTableMode();
                        TesterGUI.this.printlog("\uc804\uccb4 \ub2e8\uc5b4 \uc218: " + KEPanel.this.keywordList.getDocLen());
                        timer.stop();
                        TesterGUI.this.endJob(timer.getInterval());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        }

        void updateTableMode() {
            this.table.setModel(new KeywordDataModel());
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
            Comparator<Integer> intComparator = new Comparator<Integer>(){

                @Override
                public int compare(Integer arg0, Integer arg1) {
                    return arg0 - arg1;
                }
            };
            sorter.setComparator(0, intComparator);
            sorter.setComparator(3, intComparator);
            this.table.setRowSorter(sorter);
            this.table.updateUI();
        }

        class KeywordDataModel
        extends AbstractTableModel {
            KeywordDataModel() {
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public int getRowCount() {
                return KEPanel.this.keywordList == null ? 0 : KEPanel.this.keywordList.size();
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return "\uc704\uce58";
                    }
                    case 1: {
                        return "\ub2e8\uc5b4";
                    }
                    case 2: {
                        return "\ud488\uc0ac";
                    }
                    case 3: {
                        return "\ud69f\uc218";
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (KEPanel.this.keywordList == null || row >= KEPanel.this.keywordList.size()) {
                    return null;
                }
                Keyword keyword = (Keyword)KEPanel.this.keywordList.get(row);
                switch (col) {
                    case 0: {
                        return keyword.getIndex();
                    }
                    case 1: {
                        return keyword.getString();
                    }
                    case 2: {
                        return keyword.getTag();
                    }
                    case 3: {
                        return keyword.getCnt();
                    }
                }
                return null;
            }
        }
    }

    class MAPanel
    extends JPanel
    implements ActionListener {
        JTextField inputText = null;
        JTextArea resultText = null;

        public MAPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel topButtonPanel = new JPanel(new BorderLayout());
            topButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.inputText = new JTextField();
            topButtonPanel.add((Component)this.inputText, "Center");
            JButton button = new JButton("\ubd84\uc11d");
            button.setActionCommand("ANALYZE");
            button.addActionListener(this);
            topButtonPanel.add((Component)button, "East");
            button = new JButton("\uc0ac\uc804 \uc7ac\ub85c\ub529");
            button.setActionCommand("RELOAD");
            button.addActionListener(this);
            topButtonPanel.add((Component)button, "West");
            this.add((Component)topButtonPanel, "North");
            JPanel resultPanel = new JPanel(new BorderLayout());
            resultPanel.setBorder(BorderFactory.createTitledBorder("\ubd84\uc11d \uacb0\uacfc"));
            this.resultText = new JTextArea();
            this.resultText.setTabSize(4);
            this.resultText.setEditable(false);
            JScrollPane sp = new JScrollPane();
            sp.getViewport().add(this.resultText);
            resultPanel.add(sp);
            this.add((Component)resultPanel, "Center");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String cmd = arg0.getActionCommand();
            if (cmd.equals("ANALYZE")) {
                this.analyze();
            } else if (cmd.equals("RELOAD")) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        TesterGUI.this.startJob("\uc0ac\uc804 \ub2e4\uc2dc \uc77d\uae30");
                        Timer timer = new Timer();
                        timer.start();
                        Dictionary.reload();
                        timer.stop();
                        TesterGUI.this.endJob(timer.getInterval());
                    }
                };
                thread.start();
            }
        }

        void analyze() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    String str = MAPanel.this.inputText.getText();
                    StringBuffer sb = new StringBuffer();
                    if (((MAPanel)MAPanel.this).TesterGUI.this.ke == null) {
                        TesterGUI.this.createKE();
                    }
                    try {
                        Timer timer = new Timer();
                        timer.start();
                        List<MExpression> ret = ((MAPanel)MAPanel.this).TesterGUI.this.ke.leaveJustBest(((MAPanel)MAPanel.this).TesterGUI.this.ke.postProcess(((MAPanel)MAPanel.this).TesterGUI.this.ke.analyze(str)));
                        timer.stop();
                        TesterGUI.this.printlog("\ucd1d \ubd84\uc11d \uc2dc\uac04: " + timer.getInterval());
                        List<Sentence> stl = ((MAPanel)MAPanel.this).TesterGUI.this.ke.divideToSentences(ret);
                        int i = 0;
                        while (i < stl.size()) {
                            Sentence st = stl.get(i);
                            sb.append(String.valueOf(st.getSentence()) + "\n");
                            int j = 0;
                            while (j < st.size()) {
                                sb.append("\t" + st.get(j) + "\n");
                                ++j;
                            }
                            sb.append("\n");
                            ++i;
                        }
                        MAPanel.this.resultText.setText(sb.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.run();
        }
    }
}

