/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.ma;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.snu.ids.ha.ma.CharSetType;
import org.snu.ids.ha.ma.MCandidate;
import org.snu.ids.ha.ma.Morpheme;
import org.snu.ids.ha.util.Util;

public class MExpression
extends ArrayList<MCandidate>
implements Comparable<MExpression> {
    String exp = null;
    float lnprOfSpacing = 0.0f;
    private static final int PRUNE_SIZE = 12;

    MExpression(String exp) {
        this.exp = exp;
    }

    public MExpression(String exp, MCandidate mc) throws Exception {
        this(exp);
        this.add(mc);
    }

    MExpression(MCandidate mc) throws Exception {
        this(mc.getExp());
        this.add(mc);
    }

    @Override
    public boolean add(MCandidate mc) {
        if (mc != null && !this.contains(mc)) {
            return super.add(mc);
        }
        return false;
    }

    public boolean add2(MCandidate mc) {
        if (mc != null && !this.contains(mc)) {
            return super.add(mc);
        }
        return false;
    }

    public String getExp() {
        return this.exp;
    }

    void setIndex(int index) {
        int i = 0;
        int size = this.size();
        while (i < size) {
            ((MCandidate)this.get(i)).setIndex(index);
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.exp) + Util.LINE_SEPARATOR);
        sb.append(String.format("\t %4s%4s%4s%4s%10s%10s%10s%10s", "rdl", "cdl", "siz", "dic", "spacing", "tagging", "spacing!", "tagging!"));
        sb.append(Util.LINE_SEPARATOR);
        int i = 0;
        int stop = this.size();
        while (i < stop) {
            sb.append("\t{" + this.get(i) + "};" + Util.LINE_SEPARATOR);
            ++i;
        }
        return sb.toString();
    }

    public String toSmplStr() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.exp) + Util.LINE_SEPARATOR);
        int i = 0;
        int stop = this.size();
        while (i < stop) {
            sb.append("\t{" + ((MCandidate)this.get(i)).toSimpleStr() + "};" + Util.LINE_SEPARATOR);
            ++i;
        }
        return sb.toString();
    }

    String getEncStr() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.exp) + ":");
        int i = 0;
        int stop = this.size();
        while (i < stop) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(((MCandidate)this.get(i)).getEncStr());
            ++i;
        }
        return sb.toString();
    }

    MExpression derive(MExpression meToAppend) {
        MExpression ret = new MExpression(String.valueOf(this.exp) + meToAppend.exp);
        MCandidate mcThis = null;
        MCandidate mcToAppend = null;
        int jStop = meToAppend.size();
        int i = 0;
        int iStop = this.size();
        while (i < iStop) {
            mcThis = (MCandidate)this.get(i);
            int j = 0;
            while (j < jStop) {
                mcToAppend = (MCandidate)meToAppend.get(j);
                ret.add(mcThis.derive(mcToAppend));
                ++j;
            }
            ++i;
        }
        ret.prune();
        return ret;
    }

    void prune() {
        boolean uncomplete;
        int size = this.size();
        if (size < 2) {
            return;
        }
        int maxDicLen = -1;
        int expLen = this.exp.length();
        int tempDicLen = 0;
        this.sort();
        MCandidate mcBest = (MCandidate)this.get(0);
        float bestLnpr = mcBest.getLnpr();
        boolean bl = uncomplete = mcBest.candDicLen > 0 || expLen > mcBest.getDicLenWithCand();
        if (!uncomplete && size < 12) {
            return;
        }
        int pruneIdx = 1;
        int stop = this.size();
        while (pruneIdx < stop) {
            MCandidate mcToPrune = (MCandidate)this.get(pruneIdx);
            tempDicLen = mcToPrune.getDicLenWithCand();
            if (uncomplete && mcToPrune.getDicLenOnlyCand() == 0 && pruneIdx < 12) {
                ++pruneIdx;
                continue;
            }
            if (mcToPrune.getLnpr() < bestLnpr - 5.0f || tempDicLen < maxDicLen) break;
            ++pruneIdx;
        }
        int i = pruneIdx;
        int stop2 = this.size();
        while (i < stop2) {
            if (uncomplete && i == stop2 - 1 && ((MCandidate)this.get((int)pruneIdx)).realDicLen == 0 && ((MCandidate)this.get(pruneIdx)).getExp().length() < 10) break;
            this.remove(pruneIdx);
            ++i;
        }
    }

    void pruneWithPrev(MExpression mePrev) throws Exception {
        if (mePrev == null) {
            return;
        }
        int thisMESize = this.size();
        int preMESize = mePrev.size();
        if (preMESize == 0) {
            return;
        }
        int i = 0;
        while (i < thisMESize) {
            MCandidate mcThis = (MCandidate)this.get(i);
            mcThis.numOfApndblMC = 0;
            int j = 0;
            while (j < preMESize) {
                MCandidate preMC = (MCandidate)mePrev.get(j);
                if (preMC.isApndblWithSpace(mcThis) || preMC.isApndbl(mcThis)) {
                    mcThis.numOfApndblMC = (byte)(mcThis.numOfApndblMC + 1);
                    break;
                }
                ++j;
            }
            if (mcThis.numOfApndblMC == 0) {
                this.remove(i);
                --i;
                --thisMESize;
            }
            ++i;
        }
    }

    void pruneWithNext(MExpression nextME) throws Exception {
        int thisMESize = this.size();
        int nextMESize = nextME.size();
        if (nextMESize == 0) {
            return;
        }
        int i = 0;
        while (i < thisMESize) {
            MCandidate thisMC = (MCandidate)this.get(i);
            thisMC.numOfApndblMC = 0;
            int j = 0;
            while (j < nextMESize) {
                MCandidate nextMC = (MCandidate)nextME.get(j);
                if (thisMC.isApndblWithSpace(nextMC)) {
                    thisMC.numOfApndblMC = (byte)(thisMC.numOfApndblMC + 1);
                    break;
                }
                ++j;
            }
            if (thisMC.numOfApndblMC == 0 && this.size() > 1) {
                this.remove(i);
                --i;
                --thisMESize;
            }
            ++i;
        }
    }

    MExpression[] divideHeadTailAt(String headStr, int headIndex, String tailStr, int tailIndex) throws Exception {
        MExpression[] ret = new MExpression[2];
        MExpression headME = ret[0] = new MExpression(headStr);
        MExpression tailME = ret[1] = new MExpression(tailStr);
        int j = 0;
        int stop = this.size();
        while (j < stop) {
            MCandidate[] mcHeadTail = ((MCandidate)this.get(j)).divideHeadTailAt(headStr, headIndex, tailStr, tailIndex);
            if (mcHeadTail != null) {
                headME.add(mcHeadTail[0]);
                tailME.add(mcHeadTail[1]);
            }
            ++j;
        }
        return ret;
    }

    void merge(MExpression mExp) {
        int i = 0;
        int stop = mExp.size();
        while (i < stop) {
            this.add((MCandidate)mExp.get(i));
            ++i;
        }
        this.prune();
    }

    List<MExpression> split() throws Exception {
        if (this.size() == 0) {
            return null;
        }
        ArrayList<MExpression> ret = new ArrayList<MExpression>();
        MCandidate mc = (MCandidate)this.get(0);
        List<MCandidate> splitedMCList = mc.split();
        int splitedMCSize = splitedMCList.size();
        int i = 0;
        while (i < splitedMCSize) {
            ret.add(new MExpression(splitedMCList.get(i)));
            ++i;
        }
        int size = this.size();
        if (size > 1) {
            String preExpWithSpace = mc.geExpStrWithSpace();
            int i2 = 1;
            while (i2 < size) {
                mc = (MCandidate)this.get(i2);
                String curExpWithSpace = mc.geExpStrWithSpace();
                if (preExpWithSpace.equals(curExpWithSpace)) {
                    splitedMCList = mc.split();
                    int j = 0;
                    while (j < splitedMCSize) {
                        ret.get(j).add(splitedMCList.get(j));
                        ++j;
                    }
                }
                ++i2;
            }
        }
        return ret;
    }

    boolean isOneEojeol() {
        return this.size() > 0 && ((MCandidate)this.get(0)).getSpaceCnt() == 0;
    }

    void sort() {
        Collections.sort(this);
    }

    void sortByLnpr() {
        Collections.sort(this, new Comparator<MCandidate>(){

            @Override
            public int compare(MCandidate mc1, MCandidate mc2) {
                if (mc1.getLnpr() > mc2.getLnpr()) {
                    return -1;
                }
                if (mc1.getLnpr() < mc2.getLnpr()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    void sortByBestLnpr() {
        Collections.sort(this, new Comparator<MCandidate>(){

            @Override
            public int compare(MCandidate mc1, MCandidate mc2) {
                if (mc1.getBestLnpr() > mc1.getBestLnpr()) {
                    return -1;
                }
                if (mc1.getBestLnpr() > mc1.getBestLnpr()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public int compareTo(MExpression comp) {
        return this.exp.compareTo(comp.exp);
    }

    String getCommonHead() {
        MCandidate mc = (MCandidate)this.get(0);
        int spaceCnt = mc.getSpaceCnt();
        if (spaceCnt < 1) {
            return null;
        }
        int size = this.size();
        int i = spaceCnt - 1;
        while (i >= 0) {
            String maxCommonHead = mc.getExp(i);
            if (this.getExp().length() - maxCommonHead.length() >= 2) {
                int j = 1;
                while (j < size) {
                    if (((MCandidate)this.get(j)).getHead(maxCommonHead) == null) {
                        maxCommonHead = null;
                        break;
                    }
                    ++j;
                }
                if (maxCommonHead != null && maxCommonHead.length() > 1) {
                    if (mc.isUNBfrOrAftrIthSpace(i)) {
                        maxCommonHead = null;
                    } else {
                        return maxCommonHead;
                    }
                }
            }
            --i;
        }
        return null;
    }

    boolean isComplete() throws Exception {
        return this.size() > 0 && ((MCandidate)this.get(0)).isComplete();
    }

    boolean isOneEojeolCheckable() {
        if (this.size() == 1) {
            MCandidate mc = (MCandidate)this.get(0);
            Morpheme mp = mc.firstMorp;
            if (mc.size() == 1 && (mp.isCharSetOf(CharSetType.NUMBER) || mp.isCharSetOf(CharSetType.ENGLISH) || mp.isCharSetOf(CharSetType.COMBINED))) {
                return true;
            }
        }
        return false;
    }

    public MExpression copy() {
        MExpression copy = new MExpression(this.exp);
        int i = 0;
        int stop = this.size();
        while (i < stop) {
            copy.add(((MCandidate)this.get(i)).copy());
            ++i;
        }
        return copy;
    }

    public void leaveJustBest() {
        int i = this.size() - 1;
        while (i > 0) {
            this.remove(i);
            --i;
        }
    }

    public void setBestPrevMC(MExpression mePrev) {
        int i = 0;
        int size = this.size();
        while (i < size) {
            MCandidate mcCur = (MCandidate)this.get(i);
            if (mePrev == null) {
                mcCur.setBestPrevMC(null);
            } else {
                int j = 0;
                int jSize = mePrev.size();
                while (j < jSize) {
                    MCandidate mcPrev = (MCandidate)mePrev.get(j);
                    mcCur.setBestPrevMC(mcPrev);
                    ++j;
                }
            }
            ++i;
        }
    }

    public boolean isNotHangul() {
        return this.size() == 1 && ((MCandidate)this.get(0)).isNotHangul();
    }

    public MCandidate getBest() {
        return (MCandidate)this.get(0);
    }

    public float getLnprOfSpacing() {
        return this.lnprOfSpacing;
    }

    public void setLnprOfSpacing(float lnprOfSpacing) {
        this.lnprOfSpacing = lnprOfSpacing;
    }
}

