/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.penguin.korean;

import com.twitter.penguin.korean.TwitterKoreanProcessor;
import com.twitter.penguin.korean.stemmer.KoreanStemmer;
import com.twitter.penguin.korean.tokenizer.KoreanTokenizer;
import java.util.List;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class TwitterKoreanProcessorJava {
    private boolean stemmerEnabled;
    private boolean normalizerEnabled;
    private boolean keepSpaceEnabled;
    private boolean phraseExtractorSpamFilterEnabled;

    private TwitterKoreanProcessorJava(boolean normalizerEnabled, boolean stemmerEnabled, boolean keepSpaceEnabled, boolean phraseExtractorSpamFilterEnabled) {
        this.stemmerEnabled = stemmerEnabled;
        this.normalizerEnabled = normalizerEnabled;
        this.keepSpaceEnabled = keepSpaceEnabled;
        this.phraseExtractorSpamFilterEnabled = phraseExtractorSpamFilterEnabled;
    }

    public CharSequence normalize(CharSequence text) {
        return TwitterKoreanProcessor.normalize(text);
    }

    public KoreanStemmer.StemmedTextWithTokens stem(CharSequence text) {
        return TwitterKoreanProcessor.stem(text);
    }

    public List<KoreanTokenizer.KoreanToken> tokenize(CharSequence text) {
        Seq<KoreanTokenizer.KoreanToken> tokenized = TwitterKoreanProcessor.tokenize(text, this.normalizerEnabled, this.stemmerEnabled, this.keepSpaceEnabled);
        return JavaConversions.seqAsJavaList(tokenized);
    }

    public List<String> tokenizeToStrings(CharSequence text) {
        Seq<String> tokenized = TwitterKoreanProcessor.tokenizeToStrings(text, this.normalizerEnabled, this.stemmerEnabled, this.keepSpaceEnabled);
        return JavaConversions.seqAsJavaList(tokenized);
    }

    public List<TwitterKoreanProcessor.KoreanSegment> tokenizeWithIndex(CharSequence text) {
        return JavaConversions.seqAsJavaList(TwitterKoreanProcessor.tokenizeWithIndex(text));
    }

    public TwitterKoreanProcessor.KoreanSegmentWithText tokenizeWithIndexWithStemmer(CharSequence text) {
        return TwitterKoreanProcessor.tokenizeWithIndexWithStemmer(text);
    }

    public List<CharSequence> extractPhrases(CharSequence text) {
        return JavaConversions.seqAsJavaList(TwitterKoreanProcessor.extractPhrases(text, this.phraseExtractorSpamFilterEnabled));
    }

    public static final class Builder {
        private boolean normalizerEnabled = true;
        private boolean stemmerEnabled = true;
        private boolean keepSpaceEnabled = false;
        private boolean phraseExtractorSpamFilterEnabled = false;

        public Builder disableNormalizer() {
            this.normalizerEnabled = false;
            return this;
        }

        public Builder disableStemmer() {
            this.stemmerEnabled = false;
            return this;
        }

        public Builder enableKeepSpace() {
            this.keepSpaceEnabled = true;
            return this;
        }

        public Builder enablePhraseExtractorSpamFilter() {
            this.phraseExtractorSpamFilterEnabled = true;
            return this;
        }

        public TwitterKoreanProcessorJava build() {
            return new TwitterKoreanProcessorJava(this.normalizerEnabled, this.stemmerEnabled, this.keepSpaceEnabled, this.phraseExtractorSpamFilterEnabled);
        }
    }
}

