# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._cdn_management_client_enums import *


class Resource(msrest.serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.system_data = None


class AFDDomain(ProxyResource):
    """Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :type tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :param azure_dns_zone: Resource reference to the Azure DNS zone.
    :type azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar domain_validation_state: Provisioning substate shows the progress of custom HTTPS
     enabling/disabling process step by step. DCV stands for DomainControlValidation. Possible
     values include: "Unknown", "Submitting", "Pending", "TimedOut", "PendingRevalidation",
     "Approved".
    :vartype domain_validation_state: str or ~azure.mgmt.cdn.models.DomainValidationState
    :param host_name: The host name of the domain. Must be a domain name.
    :type host_name: str
    :ivar validation_properties: Values the customer needs to validate domain ownership.
    :vartype validation_properties: ~azure.mgmt.cdn.models.DomainValidationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'domain_validation_state': {'readonly': True},
        'validation_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tls_settings': {'key': 'properties.tlsSettings', 'type': 'AFDDomainHttpsParameters'},
        'azure_dns_zone': {'key': 'properties.azureDnsZone', 'type': 'ResourceReference'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'domain_validation_state': {'key': 'properties.domainValidationState', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'validation_properties': {'key': 'properties.validationProperties', 'type': 'DomainValidationProperties'},
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        **kwargs
    ):
        super(AFDDomain, self).__init__(**kwargs)
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.provisioning_state = None
        self.deployment_status = None
        self.domain_validation_state = None
        self.host_name = host_name
        self.validation_properties = None


class AFDDomainHttpsParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to secure a domain.

    All required parameters must be populated in order to send to Azure.

    :param certificate_type: Required. Defines the source of the SSL certificate. Possible values
     include: "CustomerCertificate", "ManagedCertificate".
    :type certificate_type: str or ~azure.mgmt.cdn.models.AfdCertificateType
    :param minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "TLS10", "TLS12".
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.AfdMinimumTlsVersion
    :param secret: Resource reference to the secret. ie. subs/rg/profile/secret.
    :type secret: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        'certificate_type': {'required': True},
    }

    _attribute_map = {
        'certificate_type': {'key': 'certificateType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        certificate_type: Union[str, "AfdCertificateType"],
        minimum_tls_version: Optional[Union[str, "AfdMinimumTlsVersion"]] = None,
        secret: Optional["ResourceReference"] = None,
        **kwargs
    ):
        super(AFDDomainHttpsParameters, self).__init__(**kwargs)
        self.certificate_type = certificate_type
        self.minimum_tls_version = minimum_tls_version
        self.secret = secret


class AFDDomainListResult(msrest.serialization.Model):
    """Result of the request to list domains. It contains a list of domain objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor domains within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.AFDDomain]
    :param next_link: URL to get the next set of domain objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AFDDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AFDDomainListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDStateProperties(msrest.serialization.Model):
    """The tracking states for afd resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AFDStateProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None


class AFDDomainUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the domain to create.

    :param tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :type tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :param azure_dns_zone: Resource reference to the Azure DNS zone.
    :type azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    """

    _attribute_map = {
        'tls_settings': {'key': 'tlsSettings', 'type': 'AFDDomainHttpsParameters'},
        'azure_dns_zone': {'key': 'azureDnsZone', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["ResourceReference"] = None,
        **kwargs
    ):
        super(AFDDomainUpdatePropertiesParameters, self).__init__(**kwargs)
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone


class AFDDomainProperties(AFDDomainUpdatePropertiesParameters, AFDStateProperties):
    """The JSON object that contains the properties of the domain to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :param tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :type tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :param azure_dns_zone: Resource reference to the Azure DNS zone.
    :type azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    :ivar domain_validation_state: Provisioning substate shows the progress of custom HTTPS
     enabling/disabling process step by step. DCV stands for DomainControlValidation. Possible
     values include: "Unknown", "Submitting", "Pending", "TimedOut", "PendingRevalidation",
     "Approved".
    :vartype domain_validation_state: str or ~azure.mgmt.cdn.models.DomainValidationState
    :param host_name: Required. The host name of the domain. Must be a domain name.
    :type host_name: str
    :ivar validation_properties: Values the customer needs to validate domain ownership.
    :vartype validation_properties: ~azure.mgmt.cdn.models.DomainValidationProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'domain_validation_state': {'readonly': True},
        'host_name': {'required': True},
        'validation_properties': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'tls_settings': {'key': 'tlsSettings', 'type': 'AFDDomainHttpsParameters'},
        'azure_dns_zone': {'key': 'azureDnsZone', 'type': 'ResourceReference'},
        'domain_validation_state': {'key': 'domainValidationState', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'validation_properties': {'key': 'validationProperties', 'type': 'DomainValidationProperties'},
    }

    def __init__(
        self,
        *,
        host_name: str,
        tls_settings: Optional["AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["ResourceReference"] = None,
        **kwargs
    ):
        super(AFDDomainProperties, self).__init__(tls_settings=tls_settings, azure_dns_zone=azure_dns_zone, **kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.domain_validation_state = None
        self.host_name = host_name
        self.validation_properties = None
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone
        self.domain_validation_state = None
        self.host_name = host_name
        self.validation_properties = None


class AFDDomainUpdateParameters(msrest.serialization.Model):
    """The domain JSON object required for domain creation or update.

    :param tls_settings: The configuration specifying how to enable HTTPS for the domain - using
     AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl
     uses AzureFrontDoor managed certificate by default.
    :type tls_settings: ~azure.mgmt.cdn.models.AFDDomainHttpsParameters
    :param azure_dns_zone: Resource reference to the Azure DNS zone.
    :type azure_dns_zone: ~azure.mgmt.cdn.models.ResourceReference
    """

    _attribute_map = {
        'tls_settings': {'key': 'properties.tlsSettings', 'type': 'AFDDomainHttpsParameters'},
        'azure_dns_zone': {'key': 'properties.azureDnsZone', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        *,
        tls_settings: Optional["AFDDomainHttpsParameters"] = None,
        azure_dns_zone: Optional["ResourceReference"] = None,
        **kwargs
    ):
        super(AFDDomainUpdateParameters, self).__init__(**kwargs)
        self.tls_settings = tls_settings
        self.azure_dns_zone = azure_dns_zone


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.system_data = None


class AFDEndpoint(TrackedResource):
    """CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format :code:`<endpointname>`.azureedge.net.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
     origin. When timeout is reached, the request fails and returns.
    :type origin_response_timeout_seconds: int
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'origin_response_timeout_seconds': {'minimum': 16},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'host_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'origin_response_timeout_seconds': {'key': 'properties.originResponseTimeoutSeconds', 'type': 'int'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        origin_response_timeout_seconds: Optional[int] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDEndpoint, self).__init__(location=location, tags=tags, **kwargs)
        self.origin_response_timeout_seconds = origin_response_timeout_seconds
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None
        self.host_name = None


class AFDEndpointListResult(msrest.serialization.Model):
    """Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor endpoints within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.AFDEndpoint]
    :param next_link: URL to get the next set of endpoint objects if there is any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AFDEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AFDEndpointListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDEndpointPropertiesUpdateParameters(msrest.serialization.Model):
    """The JSON object containing endpoint update parameters.

    :param origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
     origin. When timeout is reached, the request fails and returns.
    :type origin_response_timeout_seconds: int
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'origin_response_timeout_seconds': {'minimum': 16},
    }

    _attribute_map = {
        'origin_response_timeout_seconds': {'key': 'originResponseTimeoutSeconds', 'type': 'int'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        origin_response_timeout_seconds: Optional[int] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDEndpointPropertiesUpdateParameters, self).__init__(**kwargs)
        self.origin_response_timeout_seconds = origin_response_timeout_seconds
        self.enabled_state = enabled_state


class AFDEndpointProperties(AFDStateProperties, AFDEndpointPropertiesUpdateParameters):
    """The JSON object that contains the properties required to create an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
     origin. When timeout is reached, the request fails and returns.
    :type origin_response_timeout_seconds: int
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    """

    _validation = {
        'origin_response_timeout_seconds': {'minimum': 16},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
        'host_name': {'readonly': True},
    }

    _attribute_map = {
        'origin_response_timeout_seconds': {'key': 'originResponseTimeoutSeconds', 'type': 'int'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        origin_response_timeout_seconds: Optional[int] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDEndpointProperties, self).__init__(origin_response_timeout_seconds=origin_response_timeout_seconds, enabled_state=enabled_state, **kwargs)
        self.origin_response_timeout_seconds = origin_response_timeout_seconds
        self.enabled_state = enabled_state
        self.host_name = None
        self.provisioning_state = None
        self.deployment_status = None
        self.host_name = None


class AFDEndpointUpdateParameters(msrest.serialization.Model):
    """Properties required to create or update an endpoint.

    :param tags: A set of tags. Endpoint tags.
    :type tags: dict[str, str]
    :param origin_response_timeout_seconds: Send and receive timeout on forwarding request to the
     origin. When timeout is reached, the request fails and returns.
    :type origin_response_timeout_seconds: int
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'origin_response_timeout_seconds': {'minimum': 16},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_response_timeout_seconds': {'key': 'properties.originResponseTimeoutSeconds', 'type': 'int'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        origin_response_timeout_seconds: Optional[int] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDEndpointUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.origin_response_timeout_seconds = origin_response_timeout_seconds
        self.enabled_state = enabled_state


class AfdErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.cdn.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        super(AfdErrorResponse, self).__init__(**kwargs)
        self.error = error


class AFDOrigin(ProxyResource):
    """CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param azure_origin: Resource reference to the Azure origin resource.
    :type azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param shared_private_link_resource: The properties of the private link resource for private
     origin.
    :type shared_private_link_resource: object
    :param enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'azure_origin': {'key': 'properties.azureOrigin', 'type': 'ResourceReference'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'shared_private_link_resource': {'key': 'properties.sharedPrivateLinkResource', 'type': 'object'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional[object] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDOrigin, self).__init__(**kwargs)
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginGroup(ProxyResource):
    """AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param load_balancing_settings: Load balancing settings for a backend pool.
    :type load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_afd_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_afd_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :param session_affinity_state: Whether to allow session affinity on this host. Valid options
     are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': 'LoadBalancingSettingsParameters'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_afd_origin_error_detection_settings': {'key': 'properties.responseBasedAfdOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'session_affinity_state': {'key': 'properties.sessionAffinityState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_afd_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        session_affinity_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDOriginGroup, self).__init__(**kwargs)
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_afd_origin_error_detection_settings = response_based_afd_origin_error_detection_settings
        self.session_affinity_state = session_affinity_state
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginGroupListResult(msrest.serialization.Model):
    """Result of the request to list origin groups. It contains a list of origin groups objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origin groups within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.AFDOriginGroup]
    :param next_link: URL to get the next set of origin objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AFDOriginGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AFDOriginGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDOriginGroupUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin group.

    :param load_balancing_settings: Load balancing settings for a backend pool.
    :type load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_afd_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_afd_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :param session_affinity_state: Whether to allow session affinity on this host. Valid options
     are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': 'LoadBalancingSettingsParameters'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_afd_origin_error_detection_settings': {'key': 'responseBasedAfdOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'session_affinity_state': {'key': 'sessionAffinityState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_afd_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        session_affinity_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDOriginGroupUpdatePropertiesParameters, self).__init__(**kwargs)
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_afd_origin_error_detection_settings = response_based_afd_origin_error_detection_settings
        self.session_affinity_state = session_affinity_state


class AFDOriginGroupProperties(AFDStateProperties, AFDOriginGroupUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param load_balancing_settings: Load balancing settings for a backend pool.
    :type load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_afd_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_afd_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :param session_affinity_state: Whether to allow session affinity on this host. Valid options
     are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': 'LoadBalancingSettingsParameters'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_afd_origin_error_detection_settings': {'key': 'responseBasedAfdOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'session_affinity_state': {'key': 'sessionAffinityState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_afd_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        session_affinity_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDOriginGroupProperties, self).__init__(load_balancing_settings=load_balancing_settings, health_probe_settings=health_probe_settings, traffic_restoration_time_to_healed_or_new_endpoints_in_minutes=traffic_restoration_time_to_healed_or_new_endpoints_in_minutes, response_based_afd_origin_error_detection_settings=response_based_afd_origin_error_detection_settings, session_affinity_state=session_affinity_state, **kwargs)
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_afd_origin_error_detection_settings = response_based_afd_origin_error_detection_settings
        self.session_affinity_state = session_affinity_state
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginGroupUpdateParameters(msrest.serialization.Model):
    """AFDOrigin group properties needed for origin group creation or update.

    :param load_balancing_settings: Load balancing settings for a backend pool.
    :type load_balancing_settings: ~azure.mgmt.cdn.models.LoadBalancingSettingsParameters
    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_afd_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_afd_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :param session_affinity_state: Whether to allow session affinity on this host. Valid options
     are 'Enabled' or 'Disabled'. Possible values include: "Enabled", "Disabled".
    :type session_affinity_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': 'LoadBalancingSettingsParameters'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_afd_origin_error_detection_settings': {'key': 'properties.responseBasedAfdOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'session_affinity_state': {'key': 'properties.sessionAffinityState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        load_balancing_settings: Optional["LoadBalancingSettingsParameters"] = None,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_afd_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        session_affinity_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDOriginGroupUpdateParameters, self).__init__(**kwargs)
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_afd_origin_error_detection_settings = response_based_afd_origin_error_detection_settings
        self.session_affinity_state = session_affinity_state


class AFDOriginListResult(msrest.serialization.Model):
    """Result of the request to list origins. It contains a list of origin objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origins within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.AFDOrigin]
    :param next_link: URL to get the next set of origin objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AFDOrigin]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AFDOriginListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AFDOriginUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin.

    :param azure_origin: Resource reference to the Azure origin resource.
    :type azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param shared_private_link_resource: The properties of the private link resource for private
     origin.
    :type shared_private_link_resource: object
    :param enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'azure_origin': {'key': 'azureOrigin', 'type': 'ResourceReference'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'shared_private_link_resource': {'key': 'sharedPrivateLinkResource', 'type': 'object'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional[object] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDOriginUpdatePropertiesParameters, self).__init__(**kwargs)
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state


class AFDOriginProperties(AFDStateProperties, AFDOriginUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param azure_origin: Resource reference to the Azure origin resource.
    :type azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param shared_private_link_resource: The properties of the private link resource for private
     origin.
    :type shared_private_link_resource: object
    :param enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'azure_origin': {'key': 'azureOrigin', 'type': 'ResourceReference'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'shared_private_link_resource': {'key': 'sharedPrivateLinkResource', 'type': 'object'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional[object] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDOriginProperties, self).__init__(azure_origin=azure_origin, host_name=host_name, http_port=http_port, https_port=https_port, origin_host_header=origin_host_header, priority=priority, weight=weight, shared_private_link_resource=shared_private_link_resource, enabled_state=enabled_state, **kwargs)
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None


class AFDOriginUpdateParameters(msrest.serialization.Model):
    """AFDOrigin properties needed for origin update.

    :param azure_origin: Resource reference to the Azure origin resource.
    :type azure_origin: ~azure.mgmt.cdn.models.ResourceReference
    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param shared_private_link_resource: The properties of the private link resource for private
     origin.
    :type shared_private_link_resource: object
    :param enabled_state: Whether to enable health probes to be made against backends defined under
     backendPools. Health probes can only be disabled if there is a single enabled backend in single
     enabled backend pool. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'azure_origin': {'key': 'properties.azureOrigin', 'type': 'ResourceReference'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'shared_private_link_resource': {'key': 'properties.sharedPrivateLinkResource', 'type': 'object'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_origin: Optional["ResourceReference"] = None,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        shared_private_link_resource: Optional[object] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(AFDOriginUpdateParameters, self).__init__(**kwargs)
        self.azure_origin = azure_origin
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.shared_private_link_resource = shared_private_link_resource
        self.enabled_state = enabled_state


class AfdPurgeParameters(msrest.serialization.Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be purged. Can describe a file path
     or a wild card directory.
    :type content_paths: list[str]
    :param domains: List of domains.
    :type domains: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
        'domains': {'key': 'domains', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        content_paths: List[str],
        domains: Optional[List[str]] = None,
        **kwargs
    ):
        super(AfdPurgeParameters, self).__init__(**kwargs)
        self.content_paths = content_paths
        self.domains = domains


class CacheExpirationActionParameters(msrest.serialization.Model):
    """Defines the parameters for the cache expiration action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheExpirationActionParameters".
    :vartype odata_type: str
    :param cache_behavior: Required. Caching behavior for the requests. Possible values include:
     "BypassCache", "Override", "SetIfMissing".
    :type cache_behavior: str or ~azure.mgmt.cdn.models.CacheBehavior
    :param cache_type: Required. The level at which the content needs to be cached. Possible values
     include: "All".
    :type cache_type: str or ~azure.mgmt.cdn.models.CacheType
    :param cache_duration: The duration for which the content needs to be cached. Allowed format is
     [d.]hh:mm:ss.
    :type cache_duration: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'cache_behavior': {'required': True},
        'cache_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'cache_behavior': {'key': 'cacheBehavior', 'type': 'str'},
        'cache_type': {'key': 'cacheType', 'type': 'str'},
        'cache_duration': {'key': 'cacheDuration', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheExpirationActionParameters"

    def __init__(
        self,
        *,
        cache_behavior: Union[str, "CacheBehavior"],
        cache_type: Union[str, "CacheType"],
        cache_duration: Optional[str] = None,
        **kwargs
    ):
        super(CacheExpirationActionParameters, self).__init__(**kwargs)
        self.cache_behavior = cache_behavior
        self.cache_type = cache_type
        self.cache_duration = cache_duration


class CacheKeyQueryStringActionParameters(msrest.serialization.Model):
    """Defines the parameters for the cache-key query string action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheKeyQueryStringBehaviorActionParameters".
    :vartype odata_type: str
    :param query_string_behavior: Required. Caching behavior for the requests. Possible values
     include: "Include", "IncludeAll", "Exclude", "ExcludeAll".
    :type query_string_behavior: str or ~azure.mgmt.cdn.models.QueryStringBehavior
    :param query_parameters: query parameters to include or exclude (comma separated).
    :type query_parameters: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'query_string_behavior': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'query_string_behavior': {'key': 'queryStringBehavior', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCacheKeyQueryStringBehaviorActionParameters"

    def __init__(
        self,
        *,
        query_string_behavior: Union[str, "QueryStringBehavior"],
        query_parameters: Optional[str] = None,
        **kwargs
    ):
        super(CacheKeyQueryStringActionParameters, self).__init__(**kwargs)
        self.query_string_behavior = query_string_behavior
        self.query_parameters = query_parameters


class CdnCertificateSourceParameters(msrest.serialization.Model):
    """Defines the parameters for using CDN managed certificate for securing custom domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters".
    :vartype odata_type: str
    :param certificate_type: Required. Type of certificate used. Possible values include: "Shared",
     "Dedicated".
    :type certificate_type: str or ~azure.mgmt.cdn.models.CertificateType
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'certificate_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'certificate_type': {'key': 'certificateType', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.CdnCertificateSourceParameters"

    def __init__(
        self,
        *,
        certificate_type: Union[str, "CertificateType"],
        **kwargs
    ):
        super(CdnCertificateSourceParameters, self).__init__(**kwargs)
        self.certificate_type = certificate_type


class CdnEndpoint(msrest.serialization.Model):
    """Defines the ARM Resource ID for the linked endpoints.

    :param id: ARM Resource ID string.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(CdnEndpoint, self).__init__(**kwargs)
        self.id = id


class CustomDomainHttpsParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to secure a custom domain.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: UserManagedHttpsParameters, CdnManagedHttpsParameters.

    All required parameters must be populated in order to send to Azure.

    :param certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server.  Possible values include: "AzureKeyVault", "Cdn".
    :type certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :param protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
    }

    _subtype_map = {
        'certificate_source': {'AzureKeyVault': 'UserManagedHttpsParameters', 'Cdn': 'CdnManagedHttpsParameters'}
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        super(CustomDomainHttpsParameters, self).__init__(**kwargs)
        self.certificate_source = None  # type: Optional[str]
        self.protocol_type = protocol_type
        self.minimum_tls_version = minimum_tls_version


class CdnManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using CDN managed certificate for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :param certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server.  Possible values include: "AzureKeyVault", "Cdn".
    :type certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :param protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :param certificate_source_parameters: Required. Defines the certificate source parameters using
     CDN managed certificate for enabling SSL.
    :type certificate_source_parameters: ~azure.mgmt.cdn.models.CdnCertificateSourceParameters
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
        'certificate_source_parameters': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'certificate_source_parameters': {'key': 'certificateSourceParameters', 'type': 'CdnCertificateSourceParameters'},
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        certificate_source_parameters: "CdnCertificateSourceParameters",
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        super(CdnManagedHttpsParameters, self).__init__(protocol_type=protocol_type, minimum_tls_version=minimum_tls_version, **kwargs)
        self.certificate_source = 'Cdn'  # type: str
        self.certificate_source_parameters = certificate_source_parameters


class CdnWebApplicationFirewallPolicy(TrackedResource):
    """Defines web application firewall policy for Azure CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param etag: Gets a unique read-only string that changes whenever the resource is updated.
    :type etag: str
    :param sku: Required. The pricing tier (defines a CDN provider, feature list and rate) of the
     CdnWebApplicationFirewallPolicy.
    :type sku: ~azure.mgmt.cdn.models.Sku
    :param policy_settings: Describes  policySettings for policy.
    :type policy_settings: ~azure.mgmt.cdn.models.PolicySettings
    :param rate_limit_rules: Describes rate limit rules inside the policy.
    :type rate_limit_rules: ~azure.mgmt.cdn.models.RateLimitRuleList
    :param custom_rules: Describes custom rules inside the policy.
    :type custom_rules: ~azure.mgmt.cdn.models.CustomRuleList
    :param managed_rules: Describes managed rules inside the policy.
    :type managed_rules: ~azure.mgmt.cdn.models.ManagedRuleSetList
    :ivar endpoint_links: Describes Azure CDN endpoints associated with this Web Application
     Firewall policy.
    :vartype endpoint_links: list[~azure.mgmt.cdn.models.CdnEndpoint]
    :ivar provisioning_state: Provisioning state of the WebApplicationFirewallPolicy. Possible
     values include: "Creating", "Succeeded", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.ProvisioningState
    :ivar resource_state: Resource status of the policy. Possible values include: "Creating",
     "Enabling", "Enabled", "Disabling", "Disabled", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.PolicyResourceState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'sku': {'required': True},
        'endpoint_links': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'policy_settings': {'key': 'properties.policySettings', 'type': 'PolicySettings'},
        'rate_limit_rules': {'key': 'properties.rateLimitRules', 'type': 'RateLimitRuleList'},
        'custom_rules': {'key': 'properties.customRules', 'type': 'CustomRuleList'},
        'managed_rules': {'key': 'properties.managedRules', 'type': 'ManagedRuleSetList'},
        'endpoint_links': {'key': 'properties.endpointLinks', 'type': '[CdnEndpoint]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        policy_settings: Optional["PolicySettings"] = None,
        rate_limit_rules: Optional["RateLimitRuleList"] = None,
        custom_rules: Optional["CustomRuleList"] = None,
        managed_rules: Optional["ManagedRuleSetList"] = None,
        **kwargs
    ):
        super(CdnWebApplicationFirewallPolicy, self).__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.sku = sku
        self.policy_settings = policy_settings
        self.rate_limit_rules = rate_limit_rules
        self.custom_rules = custom_rules
        self.managed_rules = managed_rules
        self.endpoint_links = None
        self.provisioning_state = None
        self.resource_state = None


class CdnWebApplicationFirewallPolicyList(msrest.serialization.Model):
    """Defines a list of WebApplicationFirewallPolicies for Azure CDN. It contains a list of WebApplicationFirewallPolicy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Azure CDN WebApplicationFirewallPolicies within a resource group.
    :vartype value: list[~azure.mgmt.cdn.models.CdnWebApplicationFirewallPolicy]
    :param next_link: URL to get the next set of WebApplicationFirewallPolicy objects if there are
     any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CdnWebApplicationFirewallPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CdnWebApplicationFirewallPolicyList, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CdnWebApplicationFirewallPolicyPatchParameters(msrest.serialization.Model):
    """Properties required to update a CdnWebApplicationFirewallPolicy.

    :param tags: A set of tags. CdnWebApplicationFirewallPolicy tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(CdnWebApplicationFirewallPolicyPatchParameters, self).__init__(**kwargs)
        self.tags = tags


class Certificate(msrest.serialization.Model):
    """Certificate used for https.

    :param subject: Subject name in the certificate.
    :type subject: str
    :param expiration_date: Certificate expiration date.
    :type expiration_date: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    """

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        expiration_date: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(Certificate, self).__init__(**kwargs)
        self.subject = subject
        self.expiration_date = expiration_date
        self.thumbprint = thumbprint


class CheckNameAvailabilityInput(msrest.serialization.Model):
    """Input of CheckNameAvailability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The resource name to validate.
    :type name: str
    :ivar type: Required. The type of the resource whose name is to be validated. Default value:
     "Microsoft.Cdn/Profiles/Endpoints".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Cdn/Profiles/Endpoints"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(CheckNameAvailabilityInput, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityOutput(msrest.serialization.Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not available.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityOutput, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CidrIpAddress(msrest.serialization.Model):
    """CIDR Ip address.

    :param base_ip_address: Ip address itself.
    :type base_ip_address: str
    :param prefix_length: The length of the prefix of the ip address.
    :type prefix_length: int
    """

    _attribute_map = {
        'base_ip_address': {'key': 'baseIpAddress', 'type': 'str'},
        'prefix_length': {'key': 'prefixLength', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        base_ip_address: Optional[str] = None,
        prefix_length: Optional[int] = None,
        **kwargs
    ):
        super(CidrIpAddress, self).__init__(**kwargs)
        self.base_ip_address = base_ip_address
        self.prefix_length = prefix_length


class Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems(msrest.serialization.Model):
    """Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems.

    :param date_time:
    :type date_time: ~datetime.datetime
    :param value:
    :type value: float
    """

    _attribute_map = {
        'date_time': {'key': 'dateTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        date_time: Optional[datetime.datetime] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems, self).__init__(**kwargs)
        self.date_time = date_time
        self.value = value


class Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems(msrest.serialization.Model):
    """Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems.

    :param date_time:
    :type date_time: ~datetime.datetime
    :param value:
    :type value: float
    """

    _attribute_map = {
        'date_time': {'key': 'dateTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        date_time: Optional[datetime.datetime] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems, self).__init__(**kwargs)
        self.date_time = date_time
        self.value = value


class ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems(msrest.serialization.Model):
    """ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems.

    :param metric:
    :type metric: str
    :param value:
    :type value: long
    :param percentage:
    :type percentage: float
    """

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'value': {'key': 'value', 'type': 'long'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        value: Optional[int] = None,
        percentage: Optional[float] = None,
        **kwargs
    ):
        super(ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems, self).__init__(**kwargs)
        self.metric = metric
        self.value = value
        self.percentage = percentage


class CompressionSettings(msrest.serialization.Model):
    """settings for compression.

    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param is_compression_enabled: Indicates whether content compression is enabled on
     AzureFrontDoor. Default value is false. If compression is enabled, content will be served as
     compressed if user requests for a compressed version. Content won't be compressed on
     AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    """

    _attribute_map = {
        'content_types_to_compress': {'key': 'contentTypesToCompress', 'type': '[str]'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        content_types_to_compress: Optional[List[str]] = None,
        is_compression_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(CompressionSettings, self).__init__(**kwargs)
        self.content_types_to_compress = content_types_to_compress
        self.is_compression_enabled = is_compression_enabled


class ContinentsResponse(msrest.serialization.Model):
    """Continents Response.

    :param continents:
    :type continents: list[~azure.mgmt.cdn.models.ContinentsResponseContinentsItem]
    :param country_or_regions:
    :type country_or_regions: list[~azure.mgmt.cdn.models.ContinentsResponseCountryOrRegionsItem]
    """

    _attribute_map = {
        'continents': {'key': 'continents', 'type': '[ContinentsResponseContinentsItem]'},
        'country_or_regions': {'key': 'countryOrRegions', 'type': '[ContinentsResponseCountryOrRegionsItem]'},
    }

    def __init__(
        self,
        *,
        continents: Optional[List["ContinentsResponseContinentsItem"]] = None,
        country_or_regions: Optional[List["ContinentsResponseCountryOrRegionsItem"]] = None,
        **kwargs
    ):
        super(ContinentsResponse, self).__init__(**kwargs)
        self.continents = continents
        self.country_or_regions = country_or_regions


class ContinentsResponseContinentsItem(msrest.serialization.Model):
    """ContinentsResponseContinentsItem.

    :param id:
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ContinentsResponseContinentsItem, self).__init__(**kwargs)
        self.id = id


class ContinentsResponseCountryOrRegionsItem(msrest.serialization.Model):
    """ContinentsResponseCountryOrRegionsItem.

    :param id:
    :type id: str
    :param continent_id:
    :type continent_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'continent_id': {'key': 'continentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        continent_id: Optional[str] = None,
        **kwargs
    ):
        super(ContinentsResponseCountryOrRegionsItem, self).__init__(**kwargs)
        self.id = id
        self.continent_id = continent_id


class CookiesMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for Cookies match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleCookiesConditionParameters".
    :vartype odata_type: str
    :param selector: Name of Cookies to be matched.
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.CookiesOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleCookiesConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "CookiesOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(CookiesMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class CustomDomain(ProxyResource):
    """Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g. www.contoso.com.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param host_name: The host name of the custom domain. Must be a domain name.
    :type host_name: str
    :ivar resource_state: Resource status of the custom domain. Possible values include:
     "Creating", "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.CustomDomainResourceState
    :ivar custom_https_provisioning_state: Provisioning status of Custom Https of the custom
     domain. Possible values include: "Enabling", "Enabled", "Disabling", "Disabled", "Failed".
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the progress of custom
     HTTPS enabling/disabling process step by step. Possible values include:
     "SubmittingDomainControlValidationRequest", "PendingDomainControlValidationREquestApproval",
     "DomainControlValidationRequestApproved", "DomainControlValidationRequestRejected",
     "DomainControlValidationRequestTimedOut", "IssuingCertificate", "DeployingCertificate",
     "CertificateDeployed", "DeletingCertificate", "CertificateDeleted".
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.cdn.models.CustomHttpsProvisioningSubstate
    :param validation_data: Special validation or data may be required when delivering CDN to some
     regions due to local compliance reasons. E.g. ICP license number of a custom domain is required
     to deliver content in China.
    :type validation_data: str
    :ivar provisioning_state: Provisioning status of the custom domain.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'resource_state': {'readonly': True},
        'custom_https_provisioning_state': {'readonly': True},
        'custom_https_provisioning_substate': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'custom_https_provisioning_state': {'key': 'properties.customHttpsProvisioningState', 'type': 'str'},
        'custom_https_provisioning_substate': {'key': 'properties.customHttpsProvisioningSubstate', 'type': 'str'},
        'validation_data': {'key': 'properties.validationData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        validation_data: Optional[str] = None,
        **kwargs
    ):
        super(CustomDomain, self).__init__(**kwargs)
        self.host_name = host_name
        self.resource_state = None
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.validation_data = validation_data
        self.provisioning_state = None


class CustomDomainListResult(msrest.serialization.Model):
    """Result of the request to list custom domains. It contains a list of custom domain objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN CustomDomains within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.CustomDomain]
    :param next_link: URL to get the next set of custom domain objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CustomDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CustomDomainListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class CustomDomainParameters(msrest.serialization.Model):
    """The customDomain JSON object required for custom domain creation or update.

    :param host_name: The host name of the custom domain. Must be a domain name.
    :type host_name: str
    """

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        **kwargs
    ):
        super(CustomDomainParameters, self).__init__(**kwargs)
        self.host_name = host_name


class CustomerCertificate(Certificate):
    """Customer Certificate used for https.

    All required parameters must be populated in order to send to Azure.

    :param subject: Subject name in the certificate.
    :type subject: str
    :param expiration_date: Certificate expiration date.
    :type expiration_date: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param version: Certificate version.
    :type version: str
    :param certificate_authority: Certificate issuing authority.
    :type certificate_authority: str
    :param certificate_url: Required. Complete Url to the certificate.
    :type certificate_url: str
    :param use_latest_version: Whether to use the latest version for the certificate.
    :type use_latest_version: bool
    :param subject_alternative_names: The list of SANs.
    :type subject_alternative_names: list[str]
    """

    _validation = {
        'certificate_url': {'required': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'certificate_authority': {'key': 'certificateAuthority', 'type': 'str'},
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
        'use_latest_version': {'key': 'useLatestVersion', 'type': 'bool'},
        'subject_alternative_names': {'key': 'subjectAlternativeNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        certificate_url: str,
        subject: Optional[str] = None,
        expiration_date: Optional[str] = None,
        thumbprint: Optional[str] = None,
        version: Optional[str] = None,
        certificate_authority: Optional[str] = None,
        use_latest_version: Optional[bool] = None,
        subject_alternative_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(CustomerCertificate, self).__init__(subject=subject, expiration_date=expiration_date, thumbprint=thumbprint, **kwargs)
        self.version = version
        self.certificate_authority = certificate_authority
        self.certificate_url = certificate_url
        self.use_latest_version = use_latest_version
        self.subject_alternative_names = subject_alternative_names


class SecretParameters(msrest.serialization.Model):
    """The json object containing secret parameters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomerCertificateParameters, ManagedCertificateParameters, UrlSigningKeyParameters.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the Secret to create.Constant filled by server.  Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate".
    :type type: str or ~azure.mgmt.cdn.models.SecretType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'CustomerCertificate': 'CustomerCertificateParameters', 'ManagedCertificate': 'ManagedCertificateParameters', 'UrlSigningKey': 'UrlSigningKeyParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretParameters, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class CustomerCertificateParameters(SecretParameters, Certificate):
    """Customer Certificate used for https.

    All required parameters must be populated in order to send to Azure.

    :param subject: Subject name in the certificate.
    :type subject: str
    :param expiration_date: Certificate expiration date.
    :type expiration_date: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param type: Required. The type of the Secret to create.Constant filled by server.  Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate".
    :type type: str or ~azure.mgmt.cdn.models.SecretType
    :param secret_source: Required. Resource reference to the KV secret.
    :type secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :param secret_version: Version of the secret to be used.
    :type secret_version: str
    :param certificate_authority: Certificate issuing authority.
    :type certificate_authority: str
    :param use_latest_version: Whether to use the latest version for the certificate.
    :type use_latest_version: bool
    :param subject_alternative_names: The list of SANs.
    :type subject_alternative_names: list[str]
    """

    _validation = {
        'type': {'required': True},
        'secret_source': {'required': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'secret_source': {'key': 'secretSource', 'type': 'ResourceReference'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
        'certificate_authority': {'key': 'certificateAuthority', 'type': 'str'},
        'use_latest_version': {'key': 'useLatestVersion', 'type': 'bool'},
        'subject_alternative_names': {'key': 'subjectAlternativeNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        secret_source: "ResourceReference",
        subject: Optional[str] = None,
        expiration_date: Optional[str] = None,
        thumbprint: Optional[str] = None,
        secret_version: Optional[str] = None,
        certificate_authority: Optional[str] = None,
        use_latest_version: Optional[bool] = None,
        subject_alternative_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(CustomerCertificateParameters, self).__init__(subject=subject, expiration_date=expiration_date, thumbprint=thumbprint, **kwargs)
        self.subject = subject
        self.expiration_date = expiration_date
        self.thumbprint = thumbprint
        self.type = 'CustomerCertificate'  # type: str
        self.secret_source = secret_source
        self.secret_version = secret_version
        self.certificate_authority = certificate_authority
        self.use_latest_version = use_latest_version
        self.subject_alternative_names = subject_alternative_names
        self.type = 'CustomerCertificate'  # type: str
        self.secret_source = secret_source
        self.secret_version = secret_version
        self.certificate_authority = certificate_authority
        self.use_latest_version = use_latest_version
        self.subject_alternative_names = subject_alternative_names


class CustomRule(msrest.serialization.Model):
    """Defines the common attributes for a custom rule that can be included in a waf policy.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Defines the name of the custom rule.
    :type name: str
    :param enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
    :param priority: Required. Defines in what order this rule be evaluated in the overall list of
     custom rules.
    :type priority: int
    :param match_conditions: Required. List of match conditions.
    :type match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
    :param action: Required. Describes what action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :type action: str or ~azure.mgmt.cdn.models.ActionType
    """

    _validation = {
        'name': {'required': True},
        'priority': {'required': True, 'maximum': 1000, 'minimum': 0},
        'match_conditions': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        priority: int,
        match_conditions: List["MatchCondition"],
        action: Union[str, "ActionType"],
        enabled_state: Optional[Union[str, "CustomRuleEnabledState"]] = None,
        **kwargs
    ):
        super(CustomRule, self).__init__(**kwargs)
        self.name = name
        self.enabled_state = enabled_state
        self.priority = priority
        self.match_conditions = match_conditions
        self.action = action


class CustomRuleList(msrest.serialization.Model):
    """Defines contents of custom rules.

    :param rules: List of rules.
    :type rules: list[~azure.mgmt.cdn.models.CustomRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[CustomRule]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["CustomRule"]] = None,
        **kwargs
    ):
        super(CustomRuleList, self).__init__(**kwargs)
        self.rules = rules


class DeepCreatedOrigin(msrest.serialization.Model):
    """The main origin of CDN content which is added when creating a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Origin name which must be unique within the endpoint.
    :type name: str
    :param host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6
     address. This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not. By default, origin is always
     enabled.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    """

    _validation = {
        'name': {'required': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(DeepCreatedOrigin, self).__init__(**kwargs)
        self.name = name
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class DeepCreatedOriginGroup(msrest.serialization.Model):
    """The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent to the origins within the origin group based on origin health.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Origin group name which must be unique within the endpoint.
    :type name: str
    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses.This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'name': {'required': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        name: str,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(DeepCreatedOriginGroup, self).__init__(**kwargs)
        self.name = name
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class DeliveryRule(msrest.serialization.Model):
    """A rule that specifies a set of actions and conditions.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule.
    :type name: str
    :param order: Required. The order in which the rules are applied for the endpoint. Possible
     values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater
     order. Rule with order 0 is a special rule. It does not require any condition and actions
     listed in it will always be applied.
    :type order: int
    :param conditions: A list of conditions that must be matched for the actions to be executed.
    :type conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :param actions: Required. A list of actions that are executed when all the conditions of a rule
     are satisfied.
    :type actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    """

    _validation = {
        'order': {'required': True},
        'actions': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
    }

    def __init__(
        self,
        *,
        order: int,
        actions: List["DeliveryRuleAction"],
        name: Optional[str] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        **kwargs
    ):
        super(DeliveryRule, self).__init__(**kwargs)
        self.name = name
        self.order = order
        self.conditions = conditions
        self.actions = actions


class DeliveryRuleAction(msrest.serialization.Model):
    """An action for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeliveryRuleCacheExpirationAction, DeliveryRuleCacheKeyQueryStringAction, DeliveryRuleRequestHeaderAction, DeliveryRuleResponseHeaderAction, OriginGroupOverrideAction, UrlRedirectAction, UrlRewriteAction, UrlSigningAction.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'name': {'CacheExpiration': 'DeliveryRuleCacheExpirationAction', 'CacheKeyQueryString': 'DeliveryRuleCacheKeyQueryStringAction', 'ModifyRequestHeader': 'DeliveryRuleRequestHeaderAction', 'ModifyResponseHeader': 'DeliveryRuleResponseHeaderAction', 'OriginGroupOverride': 'OriginGroupOverrideAction', 'UrlRedirect': 'UrlRedirectAction', 'UrlRewrite': 'UrlRewriteAction', 'UrlSigning': 'UrlSigningAction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeliveryRuleAction, self).__init__(**kwargs)
        self.name = None  # type: Optional[str]


class DeliveryRuleCacheExpirationAction(DeliveryRuleAction):
    """Defines the cache expiration action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.CacheExpirationActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CacheExpirationActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CacheExpirationActionParameters",
        **kwargs
    ):
        super(DeliveryRuleCacheExpirationAction, self).__init__(**kwargs)
        self.name = 'CacheExpiration'  # type: str
        self.parameters = parameters


class DeliveryRuleCacheKeyQueryStringAction(DeliveryRuleAction):
    """Defines the cache-key query string action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.CacheKeyQueryStringActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CacheKeyQueryStringActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CacheKeyQueryStringActionParameters",
        **kwargs
    ):
        super(DeliveryRuleCacheKeyQueryStringAction, self).__init__(**kwargs)
        self.name = 'CacheKeyQueryString'  # type: str
        self.parameters = parameters


class DeliveryRuleCondition(msrest.serialization.Model):
    """A condition for the delivery rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DeliveryRuleCookiesCondition, DeliveryRuleHttpVersionCondition, DeliveryRuleIsDeviceCondition, DeliveryRulePostArgsCondition, DeliveryRuleQueryStringCondition, DeliveryRuleRemoteAddressCondition, DeliveryRuleRequestBodyCondition, DeliveryRuleRequestHeaderCondition, DeliveryRuleRequestMethodCondition, DeliveryRuleRequestSchemeCondition, DeliveryRuleRequestUriCondition, DeliveryRuleUrlFileExtensionCondition, DeliveryRuleUrlFileNameCondition, DeliveryRuleUrlPathCondition.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'name': {'Cookies': 'DeliveryRuleCookiesCondition', 'HttpVersion': 'DeliveryRuleHttpVersionCondition', 'IsDevice': 'DeliveryRuleIsDeviceCondition', 'PostArgs': 'DeliveryRulePostArgsCondition', 'QueryString': 'DeliveryRuleQueryStringCondition', 'RemoteAddress': 'DeliveryRuleRemoteAddressCondition', 'RequestBody': 'DeliveryRuleRequestBodyCondition', 'RequestHeader': 'DeliveryRuleRequestHeaderCondition', 'RequestMethod': 'DeliveryRuleRequestMethodCondition', 'RequestScheme': 'DeliveryRuleRequestSchemeCondition', 'RequestUri': 'DeliveryRuleRequestUriCondition', 'UrlFileExtension': 'DeliveryRuleUrlFileExtensionCondition', 'UrlFileName': 'DeliveryRuleUrlFileNameCondition', 'UrlPath': 'DeliveryRuleUrlPathCondition'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeliveryRuleCondition, self).__init__(**kwargs)
        self.name = None  # type: Optional[str]


class DeliveryRuleCookiesCondition(DeliveryRuleCondition):
    """Defines the Cookies condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.CookiesMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'CookiesMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "CookiesMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleCookiesCondition, self).__init__(**kwargs)
        self.name = 'Cookies'  # type: str
        self.parameters = parameters


class DeliveryRuleHttpVersionCondition(DeliveryRuleCondition):
    """Defines the HttpVersion condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.HttpVersionMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HttpVersionMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HttpVersionMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleHttpVersionCondition, self).__init__(**kwargs)
        self.name = 'HttpVersion'  # type: str
        self.parameters = parameters


class DeliveryRuleIsDeviceCondition(DeliveryRuleCondition):
    """Defines the IsDevice condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.IsDeviceMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'IsDeviceMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "IsDeviceMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleIsDeviceCondition, self).__init__(**kwargs)
        self.name = 'IsDevice'  # type: str
        self.parameters = parameters


class DeliveryRulePostArgsCondition(DeliveryRuleCondition):
    """Defines the PostArgs condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.PostArgsMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'PostArgsMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "PostArgsMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRulePostArgsCondition, self).__init__(**kwargs)
        self.name = 'PostArgs'  # type: str
        self.parameters = parameters


class DeliveryRuleQueryStringCondition(DeliveryRuleCondition):
    """Defines the QueryString condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.QueryStringMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'QueryStringMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "QueryStringMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleQueryStringCondition, self).__init__(**kwargs)
        self.name = 'QueryString'  # type: str
        self.parameters = parameters


class DeliveryRuleRemoteAddressCondition(DeliveryRuleCondition):
    """Defines the RemoteAddress condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RemoteAddressMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RemoteAddressMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RemoteAddressMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRemoteAddressCondition, self).__init__(**kwargs)
        self.name = 'RemoteAddress'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestBodyCondition(DeliveryRuleCondition):
    """Defines the RequestBody condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestBodyMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestBodyMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestBodyMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestBodyCondition, self).__init__(**kwargs)
        self.name = 'RequestBody'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestHeaderAction(DeliveryRuleAction):
    """Defines the request header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HeaderActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HeaderActionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestHeaderAction, self).__init__(**kwargs)
        self.name = 'ModifyRequestHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestHeaderCondition(DeliveryRuleCondition):
    """Defines the RequestHeader condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestHeaderMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestHeaderMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestHeaderMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestHeaderCondition, self).__init__(**kwargs)
        self.name = 'RequestHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestMethodCondition(DeliveryRuleCondition):
    """Defines the RequestMethod condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestMethodMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestMethodMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestMethodMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestMethodCondition, self).__init__(**kwargs)
        self.name = 'RequestMethod'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestSchemeCondition(DeliveryRuleCondition):
    """Defines the RequestScheme condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestSchemeMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestSchemeMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestSchemeCondition, self).__init__(**kwargs)
        self.name = 'RequestScheme'  # type: str
        self.parameters = parameters


class DeliveryRuleRequestUriCondition(DeliveryRuleCondition):
    """Defines the RequestUri condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.RequestUriMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'RequestUriMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "RequestUriMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleRequestUriCondition, self).__init__(**kwargs)
        self.name = 'RequestUri'  # type: str
        self.parameters = parameters


class DeliveryRuleResponseHeaderAction(DeliveryRuleAction):
    """Defines the response header action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.HeaderActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'HeaderActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "HeaderActionParameters",
        **kwargs
    ):
        super(DeliveryRuleResponseHeaderAction, self).__init__(**kwargs)
        self.name = 'ModifyResponseHeader'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlFileExtensionCondition(DeliveryRuleCondition):
    """Defines the UrlFileExtension condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.UrlFileExtensionMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlFileExtensionMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlFileExtensionMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleUrlFileExtensionCondition, self).__init__(**kwargs)
        self.name = 'UrlFileExtension'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlFileNameCondition(DeliveryRuleCondition):
    """Defines the UrlFileName condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.UrlFileNameMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlFileNameMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlFileNameMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleUrlFileNameCondition, self).__init__(**kwargs)
        self.name = 'UrlFileName'  # type: str
        self.parameters = parameters


class DeliveryRuleUrlPathCondition(DeliveryRuleCondition):
    """Defines the UrlPath condition for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the condition for the delivery rule.Constant filled by
     server.  Possible values include: "RemoteAddress", "RequestMethod", "QueryString", "PostArgs",
     "RequestUri", "RequestHeader", "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension",
     "UrlFileName", "HttpVersion", "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type name: str or ~azure.mgmt.cdn.models.MatchVariable
    :param parameters: Required. Defines the parameters for the condition.
    :type parameters: ~azure.mgmt.cdn.models.UrlPathMatchConditionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlPathMatchConditionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlPathMatchConditionParameters",
        **kwargs
    ):
        super(DeliveryRuleUrlPathCondition, self).__init__(**kwargs)
        self.name = 'UrlPath'  # type: str
        self.parameters = parameters


class DomainValidationProperties(msrest.serialization.Model):
    """The JSON object that contains the properties to validate a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_token: Challenge used for DNS TXT record or file based validation.
    :vartype validation_token: str
    :ivar expiration_date: The date time that the token expires.
    :vartype expiration_date: str
    """

    _validation = {
        'validation_token': {'readonly': True},
        'expiration_date': {'readonly': True},
    }

    _attribute_map = {
        'validation_token': {'key': 'validationToken', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainValidationProperties, self).__init__(**kwargs)
        self.validation_token = None
        self.expiration_date = None


class EdgeNode(ProxyResource):
    """Edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param ip_address_groups: List of ip address groups.
    :type ip_address_groups: list[~azure.mgmt.cdn.models.IpAddressGroup]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'ip_address_groups': {'key': 'properties.ipAddressGroups', 'type': '[IpAddressGroup]'},
    }

    def __init__(
        self,
        *,
        ip_address_groups: Optional[List["IpAddressGroup"]] = None,
        **kwargs
    ):
        super(EdgeNode, self).__init__(**kwargs)
        self.ip_address_groups = ip_address_groups


class EdgenodeResult(msrest.serialization.Model):
    """Result of the request to list CDN edgenodes. It contains a list of ip address group and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Edge node of CDN service.
    :vartype value: list[~azure.mgmt.cdn.models.EdgeNode]
    :param next_link: URL to get the next set of edgenode list results if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EdgeNode]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EdgenodeResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Endpoint(TrackedResource):
    """CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format :code:`<endpointname>`.azureedge.net.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :type origin_host_header: str
    :param is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
     geo filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param default_origin_group: A reference to the origin group.
    :type default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param url_signing_keys: List of keys used to validate the signed URL hashes.
    :type url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :param delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :type delivery_policy: ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     the endpoint (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :param origins: The source of the content being delivered via CDN.
    :type origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :param origin_groups: The origin groups comprising of origins that are used for load balancing
     the traffic based on availability.
    :type origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
    :ivar resource_state: Resource status of the endpoint. Possible values include: "Creating",
     "Deleting", "Running", "Starting", "Stopped", "Stopping".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'host_name': {'readonly': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'properties.contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'properties.isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'properties.isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'properties.isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'probe_path': {'key': 'properties.probePath', 'type': 'str'},
        'geo_filters': {'key': 'properties.geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'properties.defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'properties.urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'properties.deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'origins': {'key': 'properties.origins', 'type': '[DeepCreatedOrigin]'},
        'origin_groups': {'key': 'properties.originGroups', 'type': '[DeepCreatedOriginGroup]'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        origins: Optional[List["DeepCreatedOrigin"]] = None,
        origin_groups: Optional[List["DeepCreatedOriginGroup"]] = None,
        **kwargs
    ):
        super(Endpoint, self).__init__(location=location, tags=tags, **kwargs)
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link
        self.host_name = None
        self.origins = origins
        self.origin_groups = origin_groups
        self.resource_state = None
        self.provisioning_state = None


class EndpointListResult(msrest.serialization.Model):
    """Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN endpoints within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Endpoint]
    :param next_link: URL to get the next set of endpoint objects if there is any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Endpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EndpointListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class EndpointPropertiesUpdateParameters(msrest.serialization.Model):
    """The JSON object containing endpoint update parameters.

    :param origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :type origin_host_header: str
    :param is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
     geo filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param default_origin_group: A reference to the origin group.
    :type default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param url_signing_keys: List of keys used to validate the signed URL hashes.
    :type url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :param delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :type delivery_policy: ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     the endpoint (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'optimizationType', 'type': 'str'},
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'geo_filters': {'key': 'geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(
        self,
        *,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        **kwargs
    ):
        super(EndpointPropertiesUpdateParameters, self).__init__(**kwargs)
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class EndpointProperties(EndpointPropertiesUpdateParameters):
    """The JSON object that contains the properties required to create an endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :type origin_host_header: str
    :param is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
     geo filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param default_origin_group: A reference to the origin group.
    :type default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param url_signing_keys: List of keys used to validate the signed URL hashes.
    :type url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :param delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :type delivery_policy: ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     the endpoint (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    :ivar host_name: The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g.
     contoso.azureedge.net.
    :vartype host_name: str
    :param origins: Required. The source of the content being delivered via CDN.
    :type origins: list[~azure.mgmt.cdn.models.DeepCreatedOrigin]
    :param origin_groups: The origin groups comprising of origins that are used for load balancing
     the traffic based on availability.
    :type origin_groups: list[~azure.mgmt.cdn.models.DeepCreatedOriginGroup]
    :ivar resource_state: Resource status of the endpoint. Possible values include: "Creating",
     "Deleting", "Running", "Starting", "Stopped", "Stopping".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.EndpointResourceState
    :ivar provisioning_state: Provisioning status of the endpoint.
    :vartype provisioning_state: str
    """

    _validation = {
        'host_name': {'readonly': True},
        'origins': {'required': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'optimizationType', 'type': 'str'},
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'geo_filters': {'key': 'geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'origins': {'key': 'origins', 'type': '[DeepCreatedOrigin]'},
        'origin_groups': {'key': 'originGroups', 'type': '[DeepCreatedOriginGroup]'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        origins: List["DeepCreatedOrigin"],
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        origin_groups: Optional[List["DeepCreatedOriginGroup"]] = None,
        **kwargs
    ):
        super(EndpointProperties, self).__init__(origin_path=origin_path, content_types_to_compress=content_types_to_compress, origin_host_header=origin_host_header, is_compression_enabled=is_compression_enabled, is_http_allowed=is_http_allowed, is_https_allowed=is_https_allowed, query_string_caching_behavior=query_string_caching_behavior, optimization_type=optimization_type, probe_path=probe_path, geo_filters=geo_filters, default_origin_group=default_origin_group, url_signing_keys=url_signing_keys, delivery_policy=delivery_policy, web_application_firewall_policy_link=web_application_firewall_policy_link, **kwargs)
        self.host_name = None
        self.origins = origins
        self.origin_groups = origin_groups
        self.resource_state = None
        self.provisioning_state = None


class EndpointPropertiesUpdateParametersDeliveryPolicy(msrest.serialization.Model):
    """A policy that specifies the delivery rules to be used for an endpoint.

    All required parameters must be populated in order to send to Azure.

    :param description: User-friendly description of the policy.
    :type description: str
    :param rules: Required. A list of the delivery rules.
    :type rules: list[~azure.mgmt.cdn.models.DeliveryRule]
    """

    _validation = {
        'rules': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[DeliveryRule]'},
    }

    def __init__(
        self,
        *,
        rules: List["DeliveryRule"],
        description: Optional[str] = None,
        **kwargs
    ):
        super(EndpointPropertiesUpdateParametersDeliveryPolicy, self).__init__(**kwargs)
        self.description = description
        self.rules = rules


class EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink(msrest.serialization.Model):
    """Defines the Web Application Firewall policy for the endpoint (if applicable).

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink, self).__init__(**kwargs)
        self.id = id


class EndpointUpdateParameters(msrest.serialization.Model):
    """Properties required to create or update an endpoint.

    :param tags: A set of tags. Endpoint tags.
    :type tags: dict[str, str]
    :param origin_path: A directory path on the origin that CDN can use to retrieve content from,
     e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param content_types_to_compress: List of content types on which compression applies. The value
     should be a valid MIME type.
    :type content_types_to_compress: list[str]
    :param origin_host_header: The host header value sent to the origin with each request. This
     property at Endpoint is only allowed when endpoint uses single origin and can be overridden by
     the same property specified at origin.If you leave this blank, the request hostname determines
     this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this
     host header value to match the origin hostname by default.
    :type origin_host_header: str
    :param is_compression_enabled: Indicates whether content compression is enabled on CDN. Default
     value is false. If compression is enabled, content will be served as compressed if user
     requests for a compressed version. Content won't be compressed on CDN when requested content is
     smaller than 1 byte or larger than 1 MB.
    :type is_compression_enabled: bool
    :param is_http_allowed: Indicates whether HTTP traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_http_allowed: bool
    :param is_https_allowed: Indicates whether HTTPS traffic is allowed on the endpoint. Default
     value is true. At least one protocol (HTTP or HTTPS) must be allowed.
    :type is_https_allowed: bool
    :param query_string_caching_behavior: Defines how CDN caches requests that include query
     strings. You can ignore any query strings when caching, bypass caching to prevent requests that
     contain query strings from being cached, or cache every request with a unique URL. Possible
     values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this CDN endpoint to
     optimize for, e.g. Download, Media services. With this information, CDN can apply scenario
     driven optimization. Possible values include: "GeneralWebDelivery", "GeneralMediaStreaming",
     "VideoOnDemandMediaStreaming", "LargeFileDownload", "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param probe_path: Path to a file hosted on the origin which helps accelerate delivery of the
     dynamic content and calculate the most optimal routes for the CDN. This is relative to the
     origin path. This property is only relevant when using a single origin.
    :type probe_path: str
    :param geo_filters: List of rules defining the user's geo access within a CDN endpoint. Each
     geo filter defines an access rule to a specified path or content, e.g. block APAC for path
     /pictures/.
    :type geo_filters: list[~azure.mgmt.cdn.models.GeoFilter]
    :param default_origin_group: A reference to the origin group.
    :type default_origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param url_signing_keys: List of keys used to validate the signed URL hashes.
    :type url_signing_keys: list[~azure.mgmt.cdn.models.UrlSigningKey]
    :param delivery_policy: A policy that specifies the delivery rules to be used for an endpoint.
    :type delivery_policy: ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy
    :param web_application_firewall_policy_link: Defines the Web Application Firewall policy for
     the endpoint (if applicable).
    :type web_application_firewall_policy_link:
     ~azure.mgmt.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'content_types_to_compress': {'key': 'properties.contentTypesToCompress', 'type': '[str]'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'is_compression_enabled': {'key': 'properties.isCompressionEnabled', 'type': 'bool'},
        'is_http_allowed': {'key': 'properties.isHttpAllowed', 'type': 'bool'},
        'is_https_allowed': {'key': 'properties.isHttpsAllowed', 'type': 'bool'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'probe_path': {'key': 'properties.probePath', 'type': 'str'},
        'geo_filters': {'key': 'properties.geoFilters', 'type': '[GeoFilter]'},
        'default_origin_group': {'key': 'properties.defaultOriginGroup', 'type': 'ResourceReference'},
        'url_signing_keys': {'key': 'properties.urlSigningKeys', 'type': '[UrlSigningKey]'},
        'delivery_policy': {'key': 'properties.deliveryPolicy', 'type': 'EndpointPropertiesUpdateParametersDeliveryPolicy'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        origin_path: Optional[str] = None,
        content_types_to_compress: Optional[List[str]] = None,
        origin_host_header: Optional[str] = None,
        is_compression_enabled: Optional[bool] = None,
        is_http_allowed: Optional[bool] = None,
        is_https_allowed: Optional[bool] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        probe_path: Optional[str] = None,
        geo_filters: Optional[List["GeoFilter"]] = None,
        default_origin_group: Optional["ResourceReference"] = None,
        url_signing_keys: Optional[List["UrlSigningKey"]] = None,
        delivery_policy: Optional["EndpointPropertiesUpdateParametersDeliveryPolicy"] = None,
        web_application_firewall_policy_link: Optional["EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink"] = None,
        **kwargs
    ):
        super(EndpointUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.origin_path = origin_path
        self.content_types_to_compress = content_types_to_compress
        self.origin_host_header = origin_host_header
        self.is_compression_enabled = is_compression_enabled
        self.is_http_allowed = is_http_allowed
        self.is_https_allowed = is_https_allowed
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.probe_path = probe_path
        self.geo_filters = geo_filters
        self.default_origin_group = default_origin_group
        self.url_signing_keys = url_signing_keys
        self.delivery_policy = delivery_policy
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates CDN service is not able to process the incoming request. The reason is provided in the error message.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None


class GeoFilter(msrest.serialization.Model):
    """Rules defining user's geo access within a CDN endpoint.

    All required parameters must be populated in order to send to Azure.

    :param relative_path: Required. Relative path applicable to geo filter. (e.g. '/mypictures',
     '/mypicture/kitty.jpg', and etc.).
    :type relative_path: str
    :param action: Required. Action of the geo filter, i.e. allow or block access. Possible values
     include: "Block", "Allow".
    :type action: str or ~azure.mgmt.cdn.models.GeoFilterActions
    :param country_codes: Required. Two letter country codes defining user country access in a geo
     filter, e.g. AU, MX, US.
    :type country_codes: list[str]
    """

    _validation = {
        'relative_path': {'required': True},
        'action': {'required': True},
        'country_codes': {'required': True},
    }

    _attribute_map = {
        'relative_path': {'key': 'relativePath', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'country_codes': {'key': 'countryCodes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        relative_path: str,
        action: Union[str, "GeoFilterActions"],
        country_codes: List[str],
        **kwargs
    ):
        super(GeoFilter, self).__init__(**kwargs)
        self.relative_path = relative_path
        self.action = action
        self.country_codes = country_codes


class HeaderActionParameters(msrest.serialization.Model):
    """Defines the parameters for the request header action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters".
    :vartype odata_type: str
    :param header_action: Required. Action to perform. Possible values include: "Append",
     "Overwrite", "Delete".
    :type header_action: str or ~azure.mgmt.cdn.models.HeaderAction
    :param header_name: Required. Name of the header to modify.
    :type header_name: str
    :param value: Value for the specified action.
    :type value: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'header_action': {'required': True},
        'header_name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'header_action': {'key': 'headerAction', 'type': 'str'},
        'header_name': {'key': 'headerName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters"

    def __init__(
        self,
        *,
        header_action: Union[str, "HeaderAction"],
        header_name: str,
        value: Optional[str] = None,
        **kwargs
    ):
        super(HeaderActionParameters, self).__init__(**kwargs)
        self.header_action = header_action
        self.header_name = header_name
        self.value = value


class HealthProbeParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to send health probes to origin.

    :param probe_path: The path relative to the origin that is used to determine the health of the
     origin.
    :type probe_path: str
    :param probe_request_type: The type of health probe request that is made. Possible values
     include: "NotSet", "GET", "HEAD".
    :type probe_request_type: str or ~azure.mgmt.cdn.models.HealthProbeRequestType
    :param probe_protocol: Protocol to use for health probe. Possible values include: "NotSet",
     "Http", "Https".
    :type probe_protocol: str or ~azure.mgmt.cdn.models.ProbeProtocol
    :param probe_interval_in_seconds: The number of seconds between health probes.Default is
     240sec.
    :type probe_interval_in_seconds: int
    """

    _validation = {
        'probe_interval_in_seconds': {'maximum': 255, 'minimum': 1},
    }

    _attribute_map = {
        'probe_path': {'key': 'probePath', 'type': 'str'},
        'probe_request_type': {'key': 'probeRequestType', 'type': 'str'},
        'probe_protocol': {'key': 'probeProtocol', 'type': 'str'},
        'probe_interval_in_seconds': {'key': 'probeIntervalInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        probe_path: Optional[str] = None,
        probe_request_type: Optional[Union[str, "HealthProbeRequestType"]] = None,
        probe_protocol: Optional[Union[str, "ProbeProtocol"]] = None,
        probe_interval_in_seconds: Optional[int] = None,
        **kwargs
    ):
        super(HealthProbeParameters, self).__init__(**kwargs)
        self.probe_path = probe_path
        self.probe_request_type = probe_request_type
        self.probe_protocol = probe_protocol
        self.probe_interval_in_seconds = probe_interval_in_seconds


class HttpErrorRangeParameters(msrest.serialization.Model):
    """The JSON object that represents the range for http status codes.

    :param begin: The inclusive start of the http status code range.
    :type begin: int
    :param end: The inclusive end of the http status code range.
    :type end: int
    """

    _validation = {
        'begin': {'maximum': 999, 'minimum': 100},
        'end': {'maximum': 999, 'minimum': 100},
    }

    _attribute_map = {
        'begin': {'key': 'begin', 'type': 'int'},
        'end': {'key': 'end', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        begin: Optional[int] = None,
        end: Optional[int] = None,
        **kwargs
    ):
        super(HttpErrorRangeParameters, self).__init__(**kwargs)
        self.begin = begin
        self.end = end


class HttpVersionMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for HttpVersion match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleHttpVersionConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :type operator: str or ~azure.mgmt.cdn.models.HttpVersionOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHttpVersionConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "HttpVersionOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        **kwargs
    ):
        super(HttpVersionMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values


class IpAddressGroup(msrest.serialization.Model):
    """CDN Ip address group.

    :param delivery_region: The delivery region of the ip address group.
    :type delivery_region: str
    :param ipv4_addresses: The list of ip v4 addresses.
    :type ipv4_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    :param ipv6_addresses: The list of ip v6 addresses.
    :type ipv6_addresses: list[~azure.mgmt.cdn.models.CidrIpAddress]
    """

    _attribute_map = {
        'delivery_region': {'key': 'deliveryRegion', 'type': 'str'},
        'ipv4_addresses': {'key': 'ipv4Addresses', 'type': '[CidrIpAddress]'},
        'ipv6_addresses': {'key': 'ipv6Addresses', 'type': '[CidrIpAddress]'},
    }

    def __init__(
        self,
        *,
        delivery_region: Optional[str] = None,
        ipv4_addresses: Optional[List["CidrIpAddress"]] = None,
        ipv6_addresses: Optional[List["CidrIpAddress"]] = None,
        **kwargs
    ):
        super(IpAddressGroup, self).__init__(**kwargs)
        self.delivery_region = delivery_region
        self.ipv4_addresses = ipv4_addresses
        self.ipv6_addresses = ipv6_addresses


class IsDeviceMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for IsDevice match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleIsDeviceConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :type operator: str or ~azure.mgmt.cdn.models.IsDeviceOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str or
     ~azure.mgmt.cdn.models.IsDeviceMatchConditionParametersMatchValuesItem]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleIsDeviceConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "IsDeviceOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "IsDeviceMatchConditionParametersMatchValuesItem"]]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(IsDeviceMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class KeyVaultCertificateSourceParameters(msrest.serialization.Model):
    """Describes the parameters for using a user's KeyVault certificate for securing custom domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.KeyVaultCertificateSourceParameters".
    :vartype odata_type: str
    :param subscription_id: Required. Subscription Id of the user's Key Vault containing the SSL
     certificate.
    :type subscription_id: str
    :param resource_group_name: Required. Resource group of the user's Key Vault containing the SSL
     certificate.
    :type resource_group_name: str
    :param vault_name: Required. The name of the user's Key Vault containing the SSL certificate.
    :type vault_name: str
    :param secret_name: Required. The name of Key Vault Secret (representing the full certificate
     PFX) in Key Vault.
    :type secret_name: str
    :param secret_version: The version(GUID) of Key Vault Secret in Key Vault.
    :type secret_version: str
    :param update_rule: Required. Describes the action that shall be taken when the certificate is
     updated in Key Vault. Possible values include: "NoAction".
    :type update_rule: str or ~azure.mgmt.cdn.models.UpdateRule
    :param delete_rule: Required. Describes the action that shall be taken when the certificate is
     removed from Key Vault. Possible values include: "NoAction".
    :type delete_rule: str or ~azure.mgmt.cdn.models.DeleteRule
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'vault_name': {'required': True},
        'secret_name': {'required': True},
        'update_rule': {'required': True},
        'delete_rule': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
        'update_rule': {'key': 'updateRule', 'type': 'str'},
        'delete_rule': {'key': 'deleteRule', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.KeyVaultCertificateSourceParameters"

    def __init__(
        self,
        *,
        subscription_id: str,
        resource_group_name: str,
        vault_name: str,
        secret_name: str,
        update_rule: Union[str, "UpdateRule"],
        delete_rule: Union[str, "DeleteRule"],
        secret_version: Optional[str] = None,
        **kwargs
    ):
        super(KeyVaultCertificateSourceParameters, self).__init__(**kwargs)
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.update_rule = update_rule
        self.delete_rule = delete_rule


class KeyVaultSigningKeyParameters(msrest.serialization.Model):
    """Describes the parameters for using a user's KeyVault for URL Signing Key.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.KeyVaultSigningKeyParameters".
    :vartype odata_type: str
    :param subscription_id: Required. Subscription Id of the user's Key Vault containing the
     secret.
    :type subscription_id: str
    :param resource_group_name: Required. Resource group of the user's Key Vault containing the
     secret.
    :type resource_group_name: str
    :param vault_name: Required. The name of the user's Key Vault containing the secret.
    :type vault_name: str
    :param secret_name: Required. The name of secret in Key Vault.
    :type secret_name: str
    :param secret_version: Required. The version(GUID) of secret in Key Vault.
    :type secret_version: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'vault_name': {'required': True},
        'secret_name': {'required': True},
        'secret_version': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.KeyVaultSigningKeyParameters"

    def __init__(
        self,
        *,
        subscription_id: str,
        resource_group_name: str,
        vault_name: str,
        secret_name: str,
        secret_version: str,
        **kwargs
    ):
        super(KeyVaultSigningKeyParameters, self).__init__(**kwargs)
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.vault_name = vault_name
        self.secret_name = secret_name
        self.secret_version = secret_version


class LoadBalancingSettingsParameters(msrest.serialization.Model):
    """Round-Robin load balancing settings for a backend pool.

    :param sample_size: The number of samples to consider for load balancing decisions.
    :type sample_size: int
    :param successful_samples_required: The number of samples within the sample period that must
     succeed.
    :type successful_samples_required: int
    :param additional_latency_in_milliseconds: The additional latency in milliseconds for probes to
     fall into the lowest latency bucket.
    :type additional_latency_in_milliseconds: int
    """

    _attribute_map = {
        'sample_size': {'key': 'sampleSize', 'type': 'int'},
        'successful_samples_required': {'key': 'successfulSamplesRequired', 'type': 'int'},
        'additional_latency_in_milliseconds': {'key': 'additionalLatencyInMilliseconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        sample_size: Optional[int] = None,
        successful_samples_required: Optional[int] = None,
        additional_latency_in_milliseconds: Optional[int] = None,
        **kwargs
    ):
        super(LoadBalancingSettingsParameters, self).__init__(**kwargs)
        self.sample_size = sample_size
        self.successful_samples_required = successful_samples_required
        self.additional_latency_in_milliseconds = additional_latency_in_milliseconds


class LoadParameters(msrest.serialization.Model):
    """Parameters required for content load.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be loaded. Path should be a relative
     file URL of the origin.
    :type content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        content_paths: List[str],
        **kwargs
    ):
        super(LoadParameters, self).__init__(**kwargs)
        self.content_paths = content_paths


class ManagedCertificate(Certificate):
    """Managed Certificate used for https.

    :param subject: Subject name in the certificate.
    :type subject: str
    :param expiration_date: Certificate expiration date.
    :type expiration_date: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    """

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        expiration_date: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(ManagedCertificate, self).__init__(subject=subject, expiration_date=expiration_date, thumbprint=thumbprint, **kwargs)


class ManagedCertificateParameters(SecretParameters, Certificate):
    """Managed Certificate used for https.

    All required parameters must be populated in order to send to Azure.

    :param subject: Subject name in the certificate.
    :type subject: str
    :param expiration_date: Certificate expiration date.
    :type expiration_date: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param type: Required. The type of the Secret to create.Constant filled by server.  Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate".
    :type type: str or ~azure.mgmt.cdn.models.SecretType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        expiration_date: Optional[str] = None,
        thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(ManagedCertificateParameters, self).__init__(subject=subject, expiration_date=expiration_date, thumbprint=thumbprint, **kwargs)
        self.subject = subject
        self.expiration_date = expiration_date
        self.thumbprint = thumbprint
        self.type = 'ManagedCertificate'  # type: str
        self.type = 'ManagedCertificate'  # type: str


class ManagedRuleDefinition(msrest.serialization.Model):
    """Describes a managed rule definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_id: Identifier for the managed rule.
    :vartype rule_id: str
    :ivar description: Describes the functionality of the managed rule.
    :vartype description: str
    """

    _validation = {
        'rule_id': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleDefinition, self).__init__(**kwargs)
        self.rule_id = None
        self.description = None


class ManagedRuleGroupDefinition(msrest.serialization.Model):
    """Describes a managed rule group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar rule_group_name: Name of the managed rule group.
    :vartype rule_group_name: str
    :ivar description: Description of the managed rule group.
    :vartype description: str
    :ivar rules: List of rules within the managed rule group.
    :vartype rules: list[~azure.mgmt.cdn.models.ManagedRuleDefinition]
    """

    _validation = {
        'rule_group_name': {'readonly': True},
        'description': {'readonly': True},
        'rules': {'readonly': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedRuleGroupDefinition, self).__init__(**kwargs)
        self.rule_group_name = None
        self.description = None
        self.rules = None


class ManagedRuleGroupOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. Describes the managed rule group within the rule set to
     override.
    :type rule_group_name: str
    :param rules: List of rules that will be disabled. If none specified, all rules in the group
     will be disabled.
    :type rules: list[~azure.mgmt.cdn.models.ManagedRuleOverride]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleOverride]'},
    }

    def __init__(
        self,
        *,
        rule_group_name: str,
        rules: Optional[List["ManagedRuleOverride"]] = None,
        **kwargs
    ):
        super(ManagedRuleGroupOverride, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ManagedRuleOverride(msrest.serialization.Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. Identifier for the managed rule.
    :type rule_id: str
    :param enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults
     to Disabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.ManagedRuleEnabledState
    :param action: Describes the override action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :type action: str or ~azure.mgmt.cdn.models.ActionType
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        rule_id: str,
        enabled_state: Optional[Union[str, "ManagedRuleEnabledState"]] = None,
        action: Optional[Union[str, "ActionType"]] = None,
        **kwargs
    ):
        super(ManagedRuleOverride, self).__init__(**kwargs)
        self.rule_id = rule_id
        self.enabled_state = enabled_state
        self.action = action


class ManagedRuleSet(msrest.serialization.Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :param rule_set_type: Required. Defines the rule set type to use.
    :type rule_set_type: str
    :param rule_set_version: Required. Defines the version of the rule set to use.
    :type rule_set_version: str
    :param anomaly_score: Verizon only : If the rule set supports anomaly detection mode, this
     describes the threshold for blocking requests.
    :type anomaly_score: int
    :param rule_group_overrides: Defines the rule overrides to apply to the rule set.
    :type rule_group_overrides: list[~azure.mgmt.cdn.models.ManagedRuleGroupOverride]
    """

    _validation = {
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
        'anomaly_score': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'anomaly_score': {'key': 'anomalyScore', 'type': 'int'},
        'rule_group_overrides': {'key': 'ruleGroupOverrides', 'type': '[ManagedRuleGroupOverride]'},
    }

    def __init__(
        self,
        *,
        rule_set_type: str,
        rule_set_version: str,
        anomaly_score: Optional[int] = None,
        rule_group_overrides: Optional[List["ManagedRuleGroupOverride"]] = None,
        **kwargs
    ):
        super(ManagedRuleSet, self).__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.anomaly_score = anomaly_score
        self.rule_group_overrides = rule_group_overrides


class ManagedRuleSetDefinition(Resource):
    """Describes a managed rule set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: The pricing tier (defines a CDN provider, feature list and rate) of the
     CdnWebApplicationFirewallPolicy.
    :type sku: ~azure.mgmt.cdn.models.Sku
    :ivar provisioning_state: Provisioning state of the managed rule set.
    :vartype provisioning_state: str
    :ivar rule_set_type: Type of the managed rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: Version of the managed rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: Rule groups of the managed rule set.
    :vartype rule_groups: list[~azure.mgmt.cdn.models.ManagedRuleGroupDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'rule_set_type': {'readonly': True},
        'rule_set_version': {'readonly': True},
        'rule_groups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ManagedRuleGroupDefinition]'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        super(ManagedRuleSetDefinition, self).__init__(**kwargs)
        self.sku = sku
        self.provisioning_state = None
        self.rule_set_type = None
        self.rule_set_version = None
        self.rule_groups = None


class ManagedRuleSetDefinitionList(msrest.serialization.Model):
    """List of managed rule set definitions available for use in a policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of managed rule set definitions.
    :vartype value: list[~azure.mgmt.cdn.models.ManagedRuleSetDefinition]
    :param next_link: URL to retrieve next set of managed rule set definitions.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedRuleSetDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ManagedRuleSetDefinitionList, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ManagedRuleSetList(msrest.serialization.Model):
    """Defines the list of managed rule sets for the policy.

    :param managed_rule_sets: List of rule sets.
    :type managed_rule_sets: list[~azure.mgmt.cdn.models.ManagedRuleSet]
    """

    _attribute_map = {
        'managed_rule_sets': {'key': 'managedRuleSets', 'type': '[ManagedRuleSet]'},
    }

    def __init__(
        self,
        *,
        managed_rule_sets: Optional[List["ManagedRuleSet"]] = None,
        **kwargs
    ):
        super(ManagedRuleSetList, self).__init__(**kwargs)
        self.managed_rule_sets = managed_rule_sets


class MatchCondition(msrest.serialization.Model):
    """Define match conditions.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. Match variable to compare against. Possible values include:
     "RemoteAddress", "RequestMethod", "QueryString", "PostArgs", "RequestUri", "RequestHeader",
     "RequestBody", "RequestScheme", "UrlPath", "UrlFileExtension", "UrlFileName", "HttpVersion",
     "Cookies", "IsDevice", "RemoteAddr", "SocketAddr".
    :type match_variable: str or ~azure.mgmt.cdn.models.MatchVariable
    :param selector: Selector can used to match a specific key for QueryString, Cookies,
     RequestHeader or PostArgs.
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "IPMatch", "GeoMatch", "Equal", "Contains", "LessThan", "GreaterThan", "LessThanOrEqual",
     "GreaterThanOrEqual", "BeginsWith", "EndsWith", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.Operator
    :param negate_condition: Describes if the result of this condition should be negated.
    :type negate_condition: bool
    :param match_value: Required. List of possible match values.
    :type match_value: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.TransformType]
    """

    _validation = {
        'match_variable': {'required': True},
        'operator': {'required': True},
        'match_value': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_value': {'key': 'matchValue', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        match_variable: Union[str, "MatchVariable"],
        operator: Union[str, "Operator"],
        match_value: List[str],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        transforms: Optional[List[Union[str, "TransformType"]]] = None,
        **kwargs
    ):
        super(MatchCondition, self).__init__(**kwargs)
        self.match_variable = match_variable
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_value = match_value
        self.transforms = transforms


class MetricsResponse(msrest.serialization.Model):
    """Metrics Response.

    :param date_time_begin:
    :type date_time_begin: ~datetime.datetime
    :param date_time_end:
    :type date_time_end: ~datetime.datetime
    :param granularity:  Possible values include: "PT5M", "PT1H", "P1D".
    :type granularity: str or ~azure.mgmt.cdn.models.MetricsResponseGranularity
    :param series:
    :type series: list[~azure.mgmt.cdn.models.MetricsResponseSeriesItem]
    """

    _attribute_map = {
        'date_time_begin': {'key': 'dateTimeBegin', 'type': 'iso-8601'},
        'date_time_end': {'key': 'dateTimeEnd', 'type': 'iso-8601'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'series': {'key': 'series', 'type': '[MetricsResponseSeriesItem]'},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        granularity: Optional[Union[str, "MetricsResponseGranularity"]] = None,
        series: Optional[List["MetricsResponseSeriesItem"]] = None,
        **kwargs
    ):
        super(MetricsResponse, self).__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.granularity = granularity
        self.series = series


class MetricsResponseSeriesItem(msrest.serialization.Model):
    """MetricsResponseSeriesItem.

    :param metric:
    :type metric: str
    :param unit:  Possible values include: "count", "bytes", "bitsPerSecond".
    :type unit: str or ~azure.mgmt.cdn.models.MetricsResponseSeriesItemUnit
    :param groups:
    :type groups: list[~azure.mgmt.cdn.models.MetricsResponseSeriesPropertiesItemsItem]
    :param data:
    :type data:
     list[~azure.mgmt.cdn.models.Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems]
    """

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[MetricsResponseSeriesPropertiesItemsItem]'},
        'data': {'key': 'data', 'type': '[Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems]'},
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        unit: Optional[Union[str, "MetricsResponseSeriesItemUnit"]] = None,
        groups: Optional[List["MetricsResponseSeriesPropertiesItemsItem"]] = None,
        data: Optional[List["Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems"]] = None,
        **kwargs
    ):
        super(MetricsResponseSeriesItem, self).__init__(**kwargs)
        self.metric = metric
        self.unit = unit
        self.groups = groups
        self.data = data


class MetricsResponseSeriesPropertiesItemsItem(msrest.serialization.Model):
    """MetricsResponseSeriesPropertiesItemsItem.

    :param name:
    :type name: str
    :param value:
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(MetricsResponseSeriesPropertiesItemsItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class Operation(msrest.serialization.Model):
    """CDN REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.cdn.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.Cdn.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationsListResult(msrest.serialization.Model):
    """Result of the request to list CDN operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN operations supported by the CDN resource provider.
    :vartype value: list[~azure.mgmt.cdn.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Origin(ProxyResource):
    """CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured origins.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    :ivar resource_state: Resource status of the origin. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin.
    :vartype provisioning_state: str
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Possible values include: "Pending", "Approved", "Rejected", "Disconnected", "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_status': {'key': 'properties.privateEndpointStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(Origin, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message
        self.resource_state = None
        self.provisioning_state = None
        self.private_endpoint_status = None


class OriginGroup(ProxyResource):
    """Origin group comprising of origins is used for load balancing to origins when the content cannot be served from CDN.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :ivar resource_state: Resource status of the origin group. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginGroupResourceState
    :ivar provisioning_state: Provisioning status of the origin group.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(OriginGroup, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings
        self.resource_state = None
        self.provisioning_state = None


class OriginGroupListResult(msrest.serialization.Model):
    """Result of the request to list origin groups. It contains a list of origin groups objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origin groups within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.OriginGroup]
    :param next_link: URL to get the next set of origin objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OriginGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OriginGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OriginGroupOverrideAction(DeliveryRuleAction):
    """Defines the origin group override action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.OriginGroupOverrideActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'OriginGroupOverrideActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "OriginGroupOverrideActionParameters",
        **kwargs
    ):
        super(OriginGroupOverrideAction, self).__init__(**kwargs)
        self.name = 'OriginGroupOverride'  # type: str
        self.parameters = parameters


class OriginGroupOverrideActionParameters(msrest.serialization.Model):
    """Defines the parameters for the origin group override action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleOriginGroupOverrideActionParameters".
    :vartype odata_type: str
    :param origin_group: Required. defines the OriginGroup that would override the
     DefaultOriginGroup.
    :type origin_group: ~azure.mgmt.cdn.models.ResourceReference
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'origin_group': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'origin_group': {'key': 'originGroup', 'type': 'ResourceReference'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleOriginGroupOverrideActionParameters"

    def __init__(
        self,
        *,
        origin_group: "ResourceReference",
        **kwargs
    ):
        super(OriginGroupOverrideActionParameters, self).__init__(**kwargs)
        self.origin_group = origin_group


class OriginGroupUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin group.

    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(OriginGroupUpdatePropertiesParameters, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class OriginGroupProperties(OriginGroupUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    :ivar resource_state: Resource status of the origin group. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginGroupResourceState
    :ivar provisioning_state: Provisioning status of the origin group.
    :vartype provisioning_state: str
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(OriginGroupProperties, self).__init__(health_probe_settings=health_probe_settings, origins=origins, traffic_restoration_time_to_healed_or_new_endpoints_in_minutes=traffic_restoration_time_to_healed_or_new_endpoints_in_minutes, response_based_origin_error_detection_settings=response_based_origin_error_detection_settings, **kwargs)
        self.resource_state = None
        self.provisioning_state = None


class OriginGroupUpdateParameters(msrest.serialization.Model):
    """Origin group properties needed for origin group creation or update.

    :param health_probe_settings: Health probe settings to the origin that is used to determine the
     health of the origin.
    :type health_probe_settings: ~azure.mgmt.cdn.models.HealthProbeParameters
    :param origins: The source of the content being delivered via CDN within given origin group.
    :type origins: list[~azure.mgmt.cdn.models.ResourceReference]
    :param traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift
     the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new
     endpoint is added. Default is 10 mins. This property is currently not supported.
    :type traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: int
    :param response_based_origin_error_detection_settings: The JSON object that contains the
     properties to determine origin health using real requests/responses. This property is currently
     not supported.
    :type response_based_origin_error_detection_settings:
     ~azure.mgmt.cdn.models.ResponseBasedOriginErrorDetectionParameters
    """

    _validation = {
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'maximum': 50, 'minimum': 0},
    }

    _attribute_map = {
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'HealthProbeParameters'},
        'origins': {'key': 'properties.origins', 'type': '[ResourceReference]'},
        'traffic_restoration_time_to_healed_or_new_endpoints_in_minutes': {'key': 'properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes', 'type': 'int'},
        'response_based_origin_error_detection_settings': {'key': 'properties.responseBasedOriginErrorDetectionSettings', 'type': 'ResponseBasedOriginErrorDetectionParameters'},
    }

    def __init__(
        self,
        *,
        health_probe_settings: Optional["HealthProbeParameters"] = None,
        origins: Optional[List["ResourceReference"]] = None,
        traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None,
        response_based_origin_error_detection_settings: Optional["ResponseBasedOriginErrorDetectionParameters"] = None,
        **kwargs
    ):
        super(OriginGroupUpdateParameters, self).__init__(**kwargs)
        self.health_probe_settings = health_probe_settings
        self.origins = origins
        self.traffic_restoration_time_to_healed_or_new_endpoints_in_minutes = traffic_restoration_time_to_healed_or_new_endpoints_in_minutes
        self.response_based_origin_error_detection_settings = response_based_origin_error_detection_settings


class OriginListResult(msrest.serialization.Model):
    """Result of the request to list origins. It contains a list of origin objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN origins within an endpoint.
    :vartype value: list[~azure.mgmt.cdn.models.Origin]
    :param next_link: URL to get the next set of origin objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Origin]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OriginListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OriginUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the origin.

    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'privateLinkApprovalMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(OriginUpdatePropertiesParameters, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class OriginProperties(OriginUpdatePropertiesParameters):
    """The JSON object that contains the properties of the origin.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    :ivar resource_state: Resource status of the origin. Possible values include: "Creating",
     "Active", "Deleting".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.OriginResourceState
    :ivar provisioning_state: Provisioning status of the origin.
    :vartype provisioning_state: str
    :ivar private_endpoint_status: The approval status for the connection to the Private Link.
     Possible values include: "Pending", "Approved", "Rejected", "Disconnected", "Timeout".
    :vartype private_endpoint_status: str or ~azure.mgmt.cdn.models.PrivateEndpointStatus
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_status': {'readonly': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'originHostHeader', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'privateLinkApprovalMessage', 'type': 'str'},
        'resource_state': {'key': 'resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint_status': {'key': 'privateEndpointStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(OriginProperties, self).__init__(host_name=host_name, http_port=http_port, https_port=https_port, origin_host_header=origin_host_header, priority=priority, weight=weight, enabled=enabled, private_link_alias=private_link_alias, private_link_resource_id=private_link_resource_id, private_link_location=private_link_location, private_link_approval_message=private_link_approval_message, **kwargs)
        self.resource_state = None
        self.provisioning_state = None
        self.private_endpoint_status = None


class OriginUpdateParameters(msrest.serialization.Model):
    """Origin properties needed for origin update.

    :param host_name: The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses
     are supported.This should be unique across all origins in an endpoint.
    :type host_name: str
    :param http_port: The value of the HTTP port. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The value of the HTTPS port. Must be between 1 and 65535.
    :type https_port: int
    :param origin_host_header: The host header value sent to the origin with each request. If you
     leave this blank, the request hostname determines this value. Azure CDN origins, such as Web
     Apps, Blob Storage, and Cloud Services require this host header value to match the origin
     hostname by default. This overrides the host header defined at Endpoint.
    :type origin_host_header: str
    :param priority: Priority of origin in given origin group for load balancing. Higher priorities
     will not be used for load balancing if any lower priority origin is healthy.Must be between 1
     and 5.
    :type priority: int
    :param weight: Weight of the origin in given origin group for load balancing. Must be between 1
     and 1000.
    :type weight: int
    :param enabled: Origin is enabled for load balancing or not.
    :type enabled: bool
    :param private_link_alias: The Alias of the Private Link resource. Populating this optional
     field indicates that this origin is 'Private'.
    :type private_link_alias: str
    :param private_link_resource_id: The Resource Id of the Private Link resource. Populating this
     optional field indicates that this backend is 'Private'.
    :type private_link_resource_id: str
    :param private_link_location: The location of the Private Link resource. Required only if
     'privateLinkResourceId' is populated.
    :type private_link_location: str
    :param private_link_approval_message: A custom message to be included in the approval request
     to connect to the Private Link.
    :type private_link_approval_message: str
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'http_port': {'key': 'properties.httpPort', 'type': 'int'},
        'https_port': {'key': 'properties.httpsPort', 'type': 'int'},
        'origin_host_header': {'key': 'properties.originHostHeader', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'weight': {'key': 'properties.weight', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'private_link_alias': {'key': 'properties.privateLinkAlias', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'private_link_location': {'key': 'properties.privateLinkLocation', 'type': 'str'},
        'private_link_approval_message': {'key': 'properties.privateLinkApprovalMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: Optional[str] = None,
        http_port: Optional[int] = None,
        https_port: Optional[int] = None,
        origin_host_header: Optional[str] = None,
        priority: Optional[int] = None,
        weight: Optional[int] = None,
        enabled: Optional[bool] = None,
        private_link_alias: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_location: Optional[str] = None,
        private_link_approval_message: Optional[str] = None,
        **kwargs
    ):
        super(OriginUpdateParameters, self).__init__(**kwargs)
        self.host_name = host_name
        self.http_port = http_port
        self.https_port = https_port
        self.origin_host_header = origin_host_header
        self.priority = priority
        self.weight = weight
        self.enabled = enabled
        self.private_link_alias = private_link_alias
        self.private_link_resource_id = private_link_resource_id
        self.private_link_location = private_link_location
        self.private_link_approval_message = private_link_approval_message


class PolicySettings(msrest.serialization.Model):
    """Defines contents of a web application firewall global configuration.

    :param enabled_state: describes if the policy is in enabled state or disabled state. Possible
     values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.PolicyEnabledState
    :param mode: Describes if it is in detection mode or prevention mode at policy level. Possible
     values include: "Prevention", "Detection".
    :type mode: str or ~azure.mgmt.cdn.models.PolicyMode
    :param default_redirect_url: If action type is redirect, this field represents the default
     redirect URL for the client.
    :type default_redirect_url: str
    :param default_custom_block_response_status_code: If the action type is block, this field
     defines the default customer overridable http response status code. Possible values include:
     200, 403, 405, 406, 429.
    :type default_custom_block_response_status_code: str or ~azure.mgmt.cdn.models.Enum47
    :param default_custom_block_response_body: If the action type is block, customer can override
     the response body. The body must be specified in base64 encoding.
    :type default_custom_block_response_body: str
    """

    _validation = {
        'default_custom_block_response_body': {'pattern': r'^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$'},
    }

    _attribute_map = {
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'default_redirect_url': {'key': 'defaultRedirectUrl', 'type': 'str'},
        'default_custom_block_response_status_code': {'key': 'defaultCustomBlockResponseStatusCode', 'type': 'int'},
        'default_custom_block_response_body': {'key': 'defaultCustomBlockResponseBody', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled_state: Optional[Union[str, "PolicyEnabledState"]] = None,
        mode: Optional[Union[str, "PolicyMode"]] = None,
        default_redirect_url: Optional[str] = None,
        default_custom_block_response_status_code: Optional[Union[int, "Enum47"]] = None,
        default_custom_block_response_body: Optional[str] = None,
        **kwargs
    ):
        super(PolicySettings, self).__init__(**kwargs)
        self.enabled_state = enabled_state
        self.mode = mode
        self.default_redirect_url = default_redirect_url
        self.default_custom_block_response_status_code = default_custom_block_response_status_code
        self.default_custom_block_response_body = default_custom_block_response_body


class PostArgsMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for PostArgs match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRulePostArgsConditionParameters".
    :vartype odata_type: str
    :param selector: Name of PostArg to be matched.
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.PostArgsOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRulePostArgsConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "PostArgsOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(PostArgsMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class Profile(TrackedResource):
    """CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and pricing tier.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param sku: Required. The pricing tier (defines a CDN provider, feature list and rate) of the
     CDN profile.
    :type sku: ~azure.mgmt.cdn.models.Sku
    :ivar resource_state: Resource status of the profile. Possible values include: "Creating",
     "Active", "Deleting", "Disabled".
    :vartype resource_state: str or ~azure.mgmt.cdn.models.ProfileResourceState
    :ivar provisioning_state: Provisioning status of the profile.
    :vartype provisioning_state: str
    :ivar frontdoor_id: The Id of the frontdoor.
    :vartype frontdoor_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'sku': {'required': True},
        'resource_state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'frontdoor_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'frontdoor_id': {'key': 'properties.frontdoorId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Profile, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.resource_state = None
        self.provisioning_state = None
        self.frontdoor_id = None


class ProfileListResult(msrest.serialization.Model):
    """Result of the request to list profiles. It contains a list of profile objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of CDN profiles within a resource group.
    :vartype value: list[~azure.mgmt.cdn.models.Profile]
    :param next_link: URL to get the next set of profile objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Profile]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProfileListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ProfileUpdateParameters(msrest.serialization.Model):
    """Properties required to update a profile.

    :param tags: A set of tags. Profile tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ProfileUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class PurgeParameters(msrest.serialization.Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be purged. Can describe a file path
     or a wild card directory.
    :type content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        content_paths: List[str],
        **kwargs
    ):
        super(PurgeParameters, self).__init__(**kwargs)
        self.content_paths = content_paths


class QueryStringMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for QueryString match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleQueryStringConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.QueryStringOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleQueryStringConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "QueryStringOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(QueryStringMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RankingsResponse(msrest.serialization.Model):
    """Rankings Response.

    :param date_time_begin:
    :type date_time_begin: ~datetime.datetime
    :param date_time_end:
    :type date_time_end: ~datetime.datetime
    :param tables:
    :type tables: list[~azure.mgmt.cdn.models.RankingsResponseTablesItem]
    """

    _attribute_map = {
        'date_time_begin': {'key': 'dateTimeBegin', 'type': 'iso-8601'},
        'date_time_end': {'key': 'dateTimeEnd', 'type': 'iso-8601'},
        'tables': {'key': 'tables', 'type': '[RankingsResponseTablesItem]'},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        tables: Optional[List["RankingsResponseTablesItem"]] = None,
        **kwargs
    ):
        super(RankingsResponse, self).__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.tables = tables


class RankingsResponseTablesItem(msrest.serialization.Model):
    """RankingsResponseTablesItem.

    :param ranking:
    :type ranking: str
    :param data:
    :type data: list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsItem]
    """

    _attribute_map = {
        'ranking': {'key': 'ranking', 'type': 'str'},
        'data': {'key': 'data', 'type': '[RankingsResponseTablesPropertiesItemsItem]'},
    }

    def __init__(
        self,
        *,
        ranking: Optional[str] = None,
        data: Optional[List["RankingsResponseTablesPropertiesItemsItem"]] = None,
        **kwargs
    ):
        super(RankingsResponseTablesItem, self).__init__(**kwargs)
        self.ranking = ranking
        self.data = data


class RankingsResponseTablesPropertiesItemsItem(msrest.serialization.Model):
    """RankingsResponseTablesPropertiesItemsItem.

    :param name:
    :type name: str
    :param metrics:
    :type metrics: list[~azure.mgmt.cdn.models.RankingsResponseTablesPropertiesItemsMetricsItem]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'metrics': {'key': 'metrics', 'type': '[RankingsResponseTablesPropertiesItemsMetricsItem]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        metrics: Optional[List["RankingsResponseTablesPropertiesItemsMetricsItem"]] = None,
        **kwargs
    ):
        super(RankingsResponseTablesPropertiesItemsItem, self).__init__(**kwargs)
        self.name = name
        self.metrics = metrics


class RankingsResponseTablesPropertiesItemsMetricsItem(msrest.serialization.Model):
    """RankingsResponseTablesPropertiesItemsMetricsItem.

    :param metric:
    :type metric: str
    :param value:
    :type value: long
    :param percentage:
    :type percentage: float
    """

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'value': {'key': 'value', 'type': 'long'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        value: Optional[int] = None,
        percentage: Optional[float] = None,
        **kwargs
    ):
        super(RankingsResponseTablesPropertiesItemsMetricsItem, self).__init__(**kwargs)
        self.metric = metric
        self.value = value
        self.percentage = percentage


class RateLimitRule(CustomRule):
    """Defines a rate limiting rule that can be included in a waf policy.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Defines the name of the custom rule.
    :type name: str
    :param enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to
     Enabled if not specified. Possible values include: "Disabled", "Enabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.CustomRuleEnabledState
    :param priority: Required. Defines in what order this rule be evaluated in the overall list of
     custom rules.
    :type priority: int
    :param match_conditions: Required. List of match conditions.
    :type match_conditions: list[~azure.mgmt.cdn.models.MatchCondition]
    :param action: Required. Describes what action to be applied when rule matches. Possible values
     include: "Allow", "Block", "Log", "Redirect".
    :type action: str or ~azure.mgmt.cdn.models.ActionType
    :param rate_limit_threshold: Required. Defines rate limit threshold.
    :type rate_limit_threshold: int
    :param rate_limit_duration_in_minutes: Required. Defines rate limit duration. Default is 1
     minute.
    :type rate_limit_duration_in_minutes: int
    """

    _validation = {
        'name': {'required': True},
        'priority': {'required': True, 'maximum': 1000, 'minimum': 0},
        'match_conditions': {'required': True},
        'action': {'required': True},
        'rate_limit_threshold': {'required': True, 'minimum': 0},
        'rate_limit_duration_in_minutes': {'required': True, 'maximum': 60, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
        'rate_limit_threshold': {'key': 'rateLimitThreshold', 'type': 'int'},
        'rate_limit_duration_in_minutes': {'key': 'rateLimitDurationInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        priority: int,
        match_conditions: List["MatchCondition"],
        action: Union[str, "ActionType"],
        rate_limit_threshold: int,
        rate_limit_duration_in_minutes: int,
        enabled_state: Optional[Union[str, "CustomRuleEnabledState"]] = None,
        **kwargs
    ):
        super(RateLimitRule, self).__init__(name=name, enabled_state=enabled_state, priority=priority, match_conditions=match_conditions, action=action, **kwargs)
        self.rate_limit_threshold = rate_limit_threshold
        self.rate_limit_duration_in_minutes = rate_limit_duration_in_minutes


class RateLimitRuleList(msrest.serialization.Model):
    """Defines contents of rate limit rules.

    :param rules: List of rules.
    :type rules: list[~azure.mgmt.cdn.models.RateLimitRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[RateLimitRule]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["RateLimitRule"]] = None,
        **kwargs
    ):
        super(RateLimitRuleList, self).__init__(**kwargs)
        self.rules = rules


class RemoteAddressMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RemoteAddress match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRemoteAddressConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "IPMatch", "GeoMatch".
    :type operator: str or ~azure.mgmt.cdn.models.RemoteAddressOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: Match values to match against. The operator will apply to each value in
     here with OR semantics. If any of them match the variable with the given operator this match
     condition is considered a match.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRemoteAddressConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RemoteAddressOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(RemoteAddressMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestBodyMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestBody match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestBodyConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.RequestBodyOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestBodyConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestBodyOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(RequestBodyMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestHeaderMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestHeader match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestHeaderConditionParameters".
    :vartype odata_type: str
    :param selector: Name of Header to be matched.
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.RequestHeaderOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestHeaderConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestHeaderOperator"],
        selector: Optional[str] = None,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(RequestHeaderMatchConditionParameters, self).__init__(**kwargs)
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class RequestMethodMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestMethod match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestMethodConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Equal".
    :type operator: str or ~azure.mgmt.cdn.models.RequestMethodOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str or
     ~azure.mgmt.cdn.models.RequestMethodMatchConditionParametersMatchValuesItem]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestMethodConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestMethodOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "RequestMethodMatchConditionParametersMatchValuesItem"]]] = None,
        **kwargs
    ):
        super(RequestMethodMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values


class RequestSchemeMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestScheme match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestSchemeConditionParameters".
    :vartype odata_type: str
    :ivar operator: Required. Describes operator to be matched. Default value: "Equal".
    :vartype operator: str
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str or
     ~azure.mgmt.cdn.models.RequestSchemeMatchConditionParametersMatchValuesItem]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestSchemeConditionParameters"
    operator = "Equal"

    def __init__(
        self,
        *,
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[Union[str, "RequestSchemeMatchConditionParametersMatchValuesItem"]]] = None,
        **kwargs
    ):
        super(RequestSchemeMatchConditionParameters, self).__init__(**kwargs)
        self.negate_condition = negate_condition
        self.match_values = match_values


class RequestUriMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for RequestUri match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestUriConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.RequestUriOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleRequestUriConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "RequestUriOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(RequestUriMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class ResourceReference(msrest.serialization.Model):
    """Reference to another resource.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ResourceReference, self).__init__(**kwargs)
        self.id = id


class ResourcesResponse(msrest.serialization.Model):
    """Resources Response.

    :param endpoints:
    :type endpoints: list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsItem]
    :param custom_domains:
    :type custom_domains: list[~azure.mgmt.cdn.models.ResourcesResponseCustomDomainsItem]
    """

    _attribute_map = {
        'endpoints': {'key': 'endpoints', 'type': '[ResourcesResponseEndpointsItem]'},
        'custom_domains': {'key': 'customDomains', 'type': '[ResourcesResponseCustomDomainsItem]'},
    }

    def __init__(
        self,
        *,
        endpoints: Optional[List["ResourcesResponseEndpointsItem"]] = None,
        custom_domains: Optional[List["ResourcesResponseCustomDomainsItem"]] = None,
        **kwargs
    ):
        super(ResourcesResponse, self).__init__(**kwargs)
        self.endpoints = endpoints
        self.custom_domains = custom_domains


class ResourcesResponseCustomDomainsItem(msrest.serialization.Model):
    """ResourcesResponseCustomDomainsItem.

    :param id:
    :type id: str
    :param name:
    :type name: str
    :param endpoint_id:
    :type endpoint_id: str
    :param history:
    :type history: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'endpoint_id': {'key': 'endpointId', 'type': 'str'},
        'history': {'key': 'history', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        endpoint_id: Optional[str] = None,
        history: Optional[bool] = None,
        **kwargs
    ):
        super(ResourcesResponseCustomDomainsItem, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.endpoint_id = endpoint_id
        self.history = history


class ResourcesResponseEndpointsItem(msrest.serialization.Model):
    """ResourcesResponseEndpointsItem.

    :param id:
    :type id: str
    :param name:
    :type name: str
    :param history:
    :type history: bool
    :param custom_domains:
    :type custom_domains:
     list[~azure.mgmt.cdn.models.ResourcesResponseEndpointsPropertiesItemsItem]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'history': {'key': 'history', 'type': 'bool'},
        'custom_domains': {'key': 'customDomains', 'type': '[ResourcesResponseEndpointsPropertiesItemsItem]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        history: Optional[bool] = None,
        custom_domains: Optional[List["ResourcesResponseEndpointsPropertiesItemsItem"]] = None,
        **kwargs
    ):
        super(ResourcesResponseEndpointsItem, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.history = history
        self.custom_domains = custom_domains


class ResourcesResponseEndpointsPropertiesItemsItem(msrest.serialization.Model):
    """ResourcesResponseEndpointsPropertiesItemsItem.

    :param id:
    :type id: str
    :param name:
    :type name: str
    :param endpoint_id:
    :type endpoint_id: str
    :param history:
    :type history: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'endpoint_id': {'key': 'endpointId', 'type': 'str'},
        'history': {'key': 'history', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        endpoint_id: Optional[str] = None,
        history: Optional[bool] = None,
        **kwargs
    ):
        super(ResourcesResponseEndpointsPropertiesItemsItem, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.endpoint_id = endpoint_id
        self.history = history


class ResourceUsage(msrest.serialization.Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: Resource type for which the usage is provided.
    :vartype resource_type: str
    :ivar unit: Unit of the usage. e.g. Count.
    :vartype unit: str
    :ivar current_value: Actual value of usage on the specified resource type.
    :vartype current_value: int
    :ivar limit: Quota of the specified resource type.
    :vartype limit: int
    """

    _validation = {
        'resource_type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceUsage, self).__init__(**kwargs)
        self.resource_type = None
        self.unit = None
        self.current_value = None
        self.limit = None


class ResourceUsageListResult(msrest.serialization.Model):
    """Output of check resource usage API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of resource usages.
    :vartype value: list[~azure.mgmt.cdn.models.ResourceUsage]
    :param next_link: URL to get the next set of custom domain objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ResourceUsageListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ResponseBasedOriginErrorDetectionParameters(msrest.serialization.Model):
    """The JSON object that contains the properties to determine origin health using real requests/responses.

    :param response_based_detected_error_types: Type of response errors for real user requests for
     which origin will be deemed unhealthy. Possible values include: "None", "TcpErrorsOnly",
     "TcpAndHttpErrors".
    :type response_based_detected_error_types: str or
     ~azure.mgmt.cdn.models.ResponseBasedDetectedErrorTypes
    :param response_based_failover_threshold_percentage: The percentage of failed requests in the
     sample where failover should trigger.
    :type response_based_failover_threshold_percentage: int
    :param http_error_ranges: The list of Http status code ranges that are considered as server
     errors for origin and it is marked as unhealthy.
    :type http_error_ranges: list[~azure.mgmt.cdn.models.HttpErrorRangeParameters]
    """

    _validation = {
        'response_based_failover_threshold_percentage': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'response_based_detected_error_types': {'key': 'responseBasedDetectedErrorTypes', 'type': 'str'},
        'response_based_failover_threshold_percentage': {'key': 'responseBasedFailoverThresholdPercentage', 'type': 'int'},
        'http_error_ranges': {'key': 'httpErrorRanges', 'type': '[HttpErrorRangeParameters]'},
    }

    def __init__(
        self,
        *,
        response_based_detected_error_types: Optional[Union[str, "ResponseBasedDetectedErrorTypes"]] = None,
        response_based_failover_threshold_percentage: Optional[int] = None,
        http_error_ranges: Optional[List["HttpErrorRangeParameters"]] = None,
        **kwargs
    ):
        super(ResponseBasedOriginErrorDetectionParameters, self).__init__(**kwargs)
        self.response_based_detected_error_types = response_based_detected_error_types
        self.response_based_failover_threshold_percentage = response_based_failover_threshold_percentage
        self.http_error_ranges = http_error_ranges


class Route(ProxyResource):
    """Friendly Routes name mapping to the any Routes or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param custom_domains: Domains referenced by this endpoint.
    :type custom_domains: list[~azure.mgmt.cdn.models.ResourceReference]
    :param origin_group: A reference to the origin group.
    :type origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param rule_sets: rule sets referenced by this endpoint.
    :type rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :param supported_protocols: List of supported protocols for this route.
    :type supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param compression_settings: compression settings.
    :type compression_settings: object
    :param query_string_caching_behavior: Defines how AzureFrontDoor caches requests that include
     query strings. You can ignore any query strings when caching, bypass caching to prevent
     requests that contain query strings from being cached, or cache every request with a unique
     URL. Possible values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this AzureFrontDoor
     endpoint to optimize for, e.g. Download, Media services. With this information, AzureFrontDoor
     can apply scenario driven optimization. Possible values include: "GeneralWebDelivery",
     "GeneralMediaStreaming", "VideoOnDemandMediaStreaming", "LargeFileDownload",
     "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :type forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :param link_to_default_domain: whether this route will be linked to the default endpoint
     domain. Possible values include: "Enabled", "Disabled".
    :type link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :param https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Possible values include: "Enabled", "Disabled".
    :type https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[ResourceReference]'},
        'origin_group': {'key': 'properties.originGroup', 'type': 'ResourceReference'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'rule_sets': {'key': 'properties.ruleSets', 'type': '[ResourceReference]'},
        'supported_protocols': {'key': 'properties.supportedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'properties.patternsToMatch', 'type': '[str]'},
        'compression_settings': {'key': 'properties.compressionSettings', 'type': 'object'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'forwarding_protocol': {'key': 'properties.forwardingProtocol', 'type': 'str'},
        'link_to_default_domain': {'key': 'properties.linkToDefaultDomain', 'type': 'str'},
        'https_redirect': {'key': 'properties.httpsRedirect', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["ResourceReference"]] = None,
        origin_group: Optional["ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        compression_settings: Optional[object] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(Route, self).__init__(**kwargs)
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.compression_settings = compression_settings
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None


class RouteListResult(msrest.serialization.Model):
    """Result of the request to list routes. It contains a list of route objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor routes within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Route]
    :param next_link: URL to get the next set of route objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Route]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RouteListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RouteUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the domain to create.

    :param custom_domains: Domains referenced by this endpoint.
    :type custom_domains: list[~azure.mgmt.cdn.models.ResourceReference]
    :param origin_group: A reference to the origin group.
    :type origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param rule_sets: rule sets referenced by this endpoint.
    :type rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :param supported_protocols: List of supported protocols for this route.
    :type supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param compression_settings: compression settings.
    :type compression_settings: object
    :param query_string_caching_behavior: Defines how AzureFrontDoor caches requests that include
     query strings. You can ignore any query strings when caching, bypass caching to prevent
     requests that contain query strings from being cached, or cache every request with a unique
     URL. Possible values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this AzureFrontDoor
     endpoint to optimize for, e.g. Download, Media services. With this information, AzureFrontDoor
     can apply scenario driven optimization. Possible values include: "GeneralWebDelivery",
     "GeneralMediaStreaming", "VideoOnDemandMediaStreaming", "LargeFileDownload",
     "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :type forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :param link_to_default_domain: whether this route will be linked to the default endpoint
     domain. Possible values include: "Enabled", "Disabled".
    :type link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :param https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Possible values include: "Enabled", "Disabled".
    :type https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _attribute_map = {
        'custom_domains': {'key': 'customDomains', 'type': '[ResourceReference]'},
        'origin_group': {'key': 'originGroup', 'type': 'ResourceReference'},
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'rule_sets': {'key': 'ruleSets', 'type': '[ResourceReference]'},
        'supported_protocols': {'key': 'supportedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
        'compression_settings': {'key': 'compressionSettings', 'type': 'object'},
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'optimizationType', 'type': 'str'},
        'forwarding_protocol': {'key': 'forwardingProtocol', 'type': 'str'},
        'link_to_default_domain': {'key': 'linkToDefaultDomain', 'type': 'str'},
        'https_redirect': {'key': 'httpsRedirect', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["ResourceReference"]] = None,
        origin_group: Optional["ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        compression_settings: Optional[object] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(RouteUpdatePropertiesParameters, self).__init__(**kwargs)
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.compression_settings = compression_settings
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state


class RouteProperties(AFDStateProperties, RouteUpdatePropertiesParameters):
    """The JSON object that contains the properties of the Routes to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param custom_domains: Domains referenced by this endpoint.
    :type custom_domains: list[~azure.mgmt.cdn.models.ResourceReference]
    :param origin_group: A reference to the origin group.
    :type origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param rule_sets: rule sets referenced by this endpoint.
    :type rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :param supported_protocols: List of supported protocols for this route.
    :type supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param compression_settings: compression settings.
    :type compression_settings: object
    :param query_string_caching_behavior: Defines how AzureFrontDoor caches requests that include
     query strings. You can ignore any query strings when caching, bypass caching to prevent
     requests that contain query strings from being cached, or cache every request with a unique
     URL. Possible values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this AzureFrontDoor
     endpoint to optimize for, e.g. Download, Media services. With this information, AzureFrontDoor
     can apply scenario driven optimization. Possible values include: "GeneralWebDelivery",
     "GeneralMediaStreaming", "VideoOnDemandMediaStreaming", "LargeFileDownload",
     "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :type forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :param link_to_default_domain: whether this route will be linked to the default endpoint
     domain. Possible values include: "Enabled", "Disabled".
    :type link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :param https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Possible values include: "Enabled", "Disabled".
    :type https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'custom_domains': {'key': 'customDomains', 'type': '[ResourceReference]'},
        'origin_group': {'key': 'originGroup', 'type': 'ResourceReference'},
        'origin_path': {'key': 'originPath', 'type': 'str'},
        'rule_sets': {'key': 'ruleSets', 'type': '[ResourceReference]'},
        'supported_protocols': {'key': 'supportedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
        'compression_settings': {'key': 'compressionSettings', 'type': 'object'},
        'query_string_caching_behavior': {'key': 'queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'optimizationType', 'type': 'str'},
        'forwarding_protocol': {'key': 'forwardingProtocol', 'type': 'str'},
        'link_to_default_domain': {'key': 'linkToDefaultDomain', 'type': 'str'},
        'https_redirect': {'key': 'httpsRedirect', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["ResourceReference"]] = None,
        origin_group: Optional["ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        compression_settings: Optional[object] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(RouteProperties, self).__init__(custom_domains=custom_domains, origin_group=origin_group, origin_path=origin_path, rule_sets=rule_sets, supported_protocols=supported_protocols, patterns_to_match=patterns_to_match, compression_settings=compression_settings, query_string_caching_behavior=query_string_caching_behavior, optimization_type=optimization_type, forwarding_protocol=forwarding_protocol, link_to_default_domain=link_to_default_domain, https_redirect=https_redirect, enabled_state=enabled_state, **kwargs)
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.compression_settings = compression_settings
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state
        self.provisioning_state = None
        self.deployment_status = None


class RouteUpdateParameters(msrest.serialization.Model):
    """The domain JSON object required for domain creation or update.

    :param custom_domains: Domains referenced by this endpoint.
    :type custom_domains: list[~azure.mgmt.cdn.models.ResourceReference]
    :param origin_group: A reference to the origin group.
    :type origin_group: ~azure.mgmt.cdn.models.ResourceReference
    :param origin_path: A directory path on the origin that AzureFrontDoor can use to retrieve
     content from, e.g. contoso.cloudapp.net/originpath.
    :type origin_path: str
    :param rule_sets: rule sets referenced by this endpoint.
    :type rule_sets: list[~azure.mgmt.cdn.models.ResourceReference]
    :param supported_protocols: List of supported protocols for this route.
    :type supported_protocols: list[str or ~azure.mgmt.cdn.models.AFDEndpointProtocols]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param compression_settings: compression settings.
    :type compression_settings: object
    :param query_string_caching_behavior: Defines how AzureFrontDoor caches requests that include
     query strings. You can ignore any query strings when caching, bypass caching to prevent
     requests that contain query strings from being cached, or cache every request with a unique
     URL. Possible values include: "IgnoreQueryString", "BypassCaching", "UseQueryString", "NotSet".
    :type query_string_caching_behavior: str or ~azure.mgmt.cdn.models.QueryStringCachingBehavior
    :param optimization_type: Specifies what scenario the customer wants this AzureFrontDoor
     endpoint to optimize for, e.g. Download, Media services. With this information, AzureFrontDoor
     can apply scenario driven optimization. Possible values include: "GeneralWebDelivery",
     "GeneralMediaStreaming", "VideoOnDemandMediaStreaming", "LargeFileDownload",
     "DynamicSiteAcceleration".
    :type optimization_type: str or ~azure.mgmt.cdn.models.OptimizationType
    :param forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
     Possible values include: "HttpOnly", "HttpsOnly", "MatchRequest".
    :type forwarding_protocol: str or ~azure.mgmt.cdn.models.ForwardingProtocol
    :param link_to_default_domain: whether this route will be linked to the default endpoint
     domain. Possible values include: "Enabled", "Disabled".
    :type link_to_default_domain: str or ~azure.mgmt.cdn.models.LinkToDefaultDomain
    :param https_redirect: Whether to automatically redirect HTTP traffic to HTTPS traffic. Note
     that this is a easy way to set up this rule and it will be the first rule that gets executed.
     Possible values include: "Enabled", "Disabled".
    :type https_redirect: str or ~azure.mgmt.cdn.models.HttpsRedirect
    :param enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or
     'Disabled'. Possible values include: "Enabled", "Disabled".
    :type enabled_state: str or ~azure.mgmt.cdn.models.EnabledState
    """

    _attribute_map = {
        'custom_domains': {'key': 'properties.customDomains', 'type': '[ResourceReference]'},
        'origin_group': {'key': 'properties.originGroup', 'type': 'ResourceReference'},
        'origin_path': {'key': 'properties.originPath', 'type': 'str'},
        'rule_sets': {'key': 'properties.ruleSets', 'type': '[ResourceReference]'},
        'supported_protocols': {'key': 'properties.supportedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'properties.patternsToMatch', 'type': '[str]'},
        'compression_settings': {'key': 'properties.compressionSettings', 'type': 'object'},
        'query_string_caching_behavior': {'key': 'properties.queryStringCachingBehavior', 'type': 'str'},
        'optimization_type': {'key': 'properties.optimizationType', 'type': 'str'},
        'forwarding_protocol': {'key': 'properties.forwardingProtocol', 'type': 'str'},
        'link_to_default_domain': {'key': 'properties.linkToDefaultDomain', 'type': 'str'},
        'https_redirect': {'key': 'properties.httpsRedirect', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["ResourceReference"]] = None,
        origin_group: Optional["ResourceReference"] = None,
        origin_path: Optional[str] = None,
        rule_sets: Optional[List["ResourceReference"]] = None,
        supported_protocols: Optional[List[Union[str, "AFDEndpointProtocols"]]] = None,
        patterns_to_match: Optional[List[str]] = None,
        compression_settings: Optional[object] = None,
        query_string_caching_behavior: Optional[Union[str, "QueryStringCachingBehavior"]] = None,
        optimization_type: Optional[Union[str, "OptimizationType"]] = None,
        forwarding_protocol: Optional[Union[str, "ForwardingProtocol"]] = None,
        link_to_default_domain: Optional[Union[str, "LinkToDefaultDomain"]] = None,
        https_redirect: Optional[Union[str, "HttpsRedirect"]] = None,
        enabled_state: Optional[Union[str, "EnabledState"]] = None,
        **kwargs
    ):
        super(RouteUpdateParameters, self).__init__(**kwargs)
        self.custom_domains = custom_domains
        self.origin_group = origin_group
        self.origin_path = origin_path
        self.rule_sets = rule_sets
        self.supported_protocols = supported_protocols
        self.patterns_to_match = patterns_to_match
        self.compression_settings = compression_settings
        self.query_string_caching_behavior = query_string_caching_behavior
        self.optimization_type = optimization_type
        self.forwarding_protocol = forwarding_protocol
        self.link_to_default_domain = link_to_default_domain
        self.https_redirect = https_redirect
        self.enabled_state = enabled_state


class Rule(ProxyResource):
    """Friendly Rules name mapping to the any Rules or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :param order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :type order: int
    :param conditions: A list of conditions that must be matched for the actions to be executed.
    :type conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :param actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :type actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :param match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :type match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'order': {'key': 'properties.order', 'type': 'int'},
        'conditions': {'key': 'properties.conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'properties.actions', 'type': '[DeliveryRuleAction]'},
        'match_processing_behavior': {'key': 'properties.matchProcessingBehavior', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        actions: Optional[List["DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        super(Rule, self).__init__(**kwargs)
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior
        self.provisioning_state = None
        self.deployment_status = None


class RuleListResult(msrest.serialization.Model):
    """Result of the request to list rules. It contains a list of rule objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor rules within a rule set.
    :vartype value: list[~azure.mgmt.cdn.models.Rule]
    :param next_link: URL to get the next set of rule objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Rule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RuleUpdatePropertiesParameters(msrest.serialization.Model):
    """The JSON object that contains the properties of the domain to create.

    :param order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :type order: int
    :param conditions: A list of conditions that must be matched for the actions to be executed.
    :type conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :param actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :type actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :param match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :type match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    """

    _attribute_map = {
        'order': {'key': 'order', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
        'match_processing_behavior': {'key': 'matchProcessingBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        actions: Optional[List["DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        super(RuleUpdatePropertiesParameters, self).__init__(**kwargs)
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior


class RuleProperties(AFDStateProperties, RuleUpdatePropertiesParameters):
    """The JSON object that contains the properties of the Rules to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :type order: int
    :param conditions: A list of conditions that must be matched for the actions to be executed.
    :type conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :param actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :type actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :param match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :type match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'order': {'key': 'order', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
        'match_processing_behavior': {'key': 'matchProcessingBehavior', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        actions: Optional[List["DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        super(RuleProperties, self).__init__(order=order, conditions=conditions, actions=actions, match_processing_behavior=match_processing_behavior, **kwargs)
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior
        self.provisioning_state = None
        self.deployment_status = None


class RuleSet(ProxyResource):
    """Friendly RuleSet name mapping to the any RuleSet or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleSet, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None


class RuleSetListResult(msrest.serialization.Model):
    """Result of the request to list rule sets. It contains a list of rule set objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor rule sets within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.RuleSet]
    :param next_link: URL to get the next set of rule set objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RuleSetListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RuleSetProperties(AFDStateProperties):
    """The JSON object that contains the properties of the Rule Set to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleSetProperties, self).__init__(**kwargs)


class RuleUpdateParameters(msrest.serialization.Model):
    """The domain JSON object required for domain creation or update.

    :param order: The order in which the rules are applied for the endpoint. Possible values
     {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order.
     Rule with order 0 is a special rule. It does not require any condition and actions listed in it
     will always be applied.
    :type order: int
    :param conditions: A list of conditions that must be matched for the actions to be executed.
    :type conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    :param actions: A list of actions that are executed when all the conditions of a rule are
     satisfied.
    :type actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :param match_processing_behavior: If this rule is a match should the rules engine continue
     running the remaining rules or stop. If not present, defaults to Continue. Possible values
     include: "Continue", "Stop".
    :type match_processing_behavior: str or ~azure.mgmt.cdn.models.MatchProcessingBehavior
    """

    _attribute_map = {
        'order': {'key': 'properties.order', 'type': 'int'},
        'conditions': {'key': 'properties.conditions', 'type': '[DeliveryRuleCondition]'},
        'actions': {'key': 'properties.actions', 'type': '[DeliveryRuleAction]'},
        'match_processing_behavior': {'key': 'properties.matchProcessingBehavior', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        order: Optional[int] = None,
        conditions: Optional[List["DeliveryRuleCondition"]] = None,
        actions: Optional[List["DeliveryRuleAction"]] = None,
        match_processing_behavior: Optional[Union[str, "MatchProcessingBehavior"]] = None,
        **kwargs
    ):
        super(RuleUpdateParameters, self).__init__(**kwargs)
        self.order = order
        self.conditions = conditions
        self.actions = actions
        self.match_processing_behavior = match_processing_behavior


class Secret(ProxyResource):
    """Friendly Secret name mapping to the any Secret or secret related information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :param parameters: object which contains secret parameters.
    :type parameters: ~azure.mgmt.cdn.models.SecretParameters
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': 'SecretParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecretParameters"] = None,
        **kwargs
    ):
        super(Secret, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.parameters = parameters


class SecretListResult(msrest.serialization.Model):
    """Result of the request to list secrets. It contains a list of Secret objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of AzureFrontDoor secrets within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.Secret]
    :param next_link: URL to get the next set of Secret objects if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Secret]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SecretListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SecretProperties(AFDStateProperties):
    """The JSON object that contains the properties of the Secret to create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :param parameters: object which contains secret parameters.
    :type parameters: ~azure.mgmt.cdn.models.SecretParameters
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'SecretParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecretParameters"] = None,
        **kwargs
    ):
        super(SecretProperties, self).__init__(**kwargs)
        self.parameters = parameters


class SecurityPolicy(ProxyResource):
    """SecurityPolicy association for AzureFrontDoor profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Read only system data.
    :vartype system_data: ~azure.mgmt.cdn.models.SystemData
    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :param parameters: object which contains security policy parameters.
    :type parameters: ~azure.mgmt.cdn.models.SecurityPolicyWebApplicationFirewallParameters
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': 'SecurityPolicyWebApplicationFirewallParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecurityPolicyWebApplicationFirewallParameters"] = None,
        **kwargs
    ):
        super(SecurityPolicy, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_status = None
        self.parameters = parameters


class SecurityPolicyListResult(msrest.serialization.Model):
    """Result of the request to list security policies. It contains a list of security policy objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Security policies within a profile.
    :vartype value: list[~azure.mgmt.cdn.models.SecurityPolicy]
    :param next_link: URL to get the next set of security policy objects if there is any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SecurityPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SecurityPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SecurityPolicyParameters(msrest.serialization.Model):
    """The json object containing security policy parameters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecurityPolicyWebApplicationFirewallParameters.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the Security policy to create.Constant filled by server.
     Possible values include: "WebApplicationFirewall".
    :type type: str or ~azure.mgmt.cdn.models.SecurityPolicyType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'WebApplicationFirewall': 'SecurityPolicyWebApplicationFirewallParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecurityPolicyParameters, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class SecurityPolicyProperties(AFDStateProperties):
    """The json object that contains properties required to create a security policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning status. Possible values include: "Succeeded", "Failed",
     "Updating", "Deleting", "Creating".
    :vartype provisioning_state: str or ~azure.mgmt.cdn.models.AfdProvisioningState
    :ivar deployment_status:  Possible values include: "NotStarted", "InProgress", "Succeeded",
     "Failed".
    :vartype deployment_status: str or ~azure.mgmt.cdn.models.DeploymentStatus
    :param parameters: object which contains security policy parameters.
    :type parameters: ~azure.mgmt.cdn.models.SecurityPolicyWebApplicationFirewallParameters
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'deployment_status': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'SecurityPolicyWebApplicationFirewallParameters'},
    }

    def __init__(
        self,
        *,
        parameters: Optional["SecurityPolicyWebApplicationFirewallParameters"] = None,
        **kwargs
    ):
        super(SecurityPolicyProperties, self).__init__(**kwargs)
        self.parameters = parameters


class SecurityPolicyWebApplicationFirewallAssociation(msrest.serialization.Model):
    """settings for security policy patterns to match.

    :param domains: List of domains.
    :type domains: list[~azure.mgmt.cdn.models.ResourceReference]
    :param patterns_to_match: List of paths.
    :type patterns_to_match: list[str]
    """

    _attribute_map = {
        'domains': {'key': 'domains', 'type': '[ResourceReference]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        domains: Optional[List["ResourceReference"]] = None,
        patterns_to_match: Optional[List[str]] = None,
        **kwargs
    ):
        super(SecurityPolicyWebApplicationFirewallAssociation, self).__init__(**kwargs)
        self.domains = domains
        self.patterns_to_match = patterns_to_match


class SecurityPolicyWebApplicationFirewallParameters(SecurityPolicyParameters):
    """The json object containing security policy waf parameters.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the Security policy to create.Constant filled by server.
     Possible values include: "WebApplicationFirewall".
    :type type: str or ~azure.mgmt.cdn.models.SecurityPolicyType
    :param waf_policy: Resource ID.
    :type waf_policy: ~azure.mgmt.cdn.models.ResourceReference
    :param associations: Waf associations.
    :type associations:
     list[~azure.mgmt.cdn.models.SecurityPolicyWebApplicationFirewallAssociation]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'waf_policy': {'key': 'wafPolicy', 'type': 'ResourceReference'},
        'associations': {'key': 'associations', 'type': '[SecurityPolicyWebApplicationFirewallAssociation]'},
    }

    def __init__(
        self,
        *,
        waf_policy: Optional["ResourceReference"] = None,
        associations: Optional[List["SecurityPolicyWebApplicationFirewallAssociation"]] = None,
        **kwargs
    ):
        super(SecurityPolicyWebApplicationFirewallParameters, self).__init__(**kwargs)
        self.type = 'WebApplicationFirewall'  # type: str
        self.waf_policy = waf_policy
        self.associations = associations


class SharedPrivateLinkResourceProperties(msrest.serialization.Model):
    """Describes the properties of an existing Shared Private Link Resource to use when connecting to a private origin.

    :param private_link: The resource id of the resource the shared private link resource is for.
    :type private_link: ~azure.mgmt.cdn.models.ResourceReference
    :param private_link_location: The location of the shared private link resource.
    :type private_link_location: str
    :param group_id: The group id from the provider of resource the shared private link resource is
     for.
    :type group_id: str
    :param request_message: The request message for requesting approval of the shared private link
     resource.
    :type request_message: str
    :param status: Status of the shared private link resource. Can be Pending, Approved, Rejected,
     Disconnected, or Timeout. Possible values include: "Pending", "Approved", "Rejected",
     "Disconnected", "Timeout".
    :type status: str or ~azure.mgmt.cdn.models.SharedPrivateLinkResourceStatus
    """

    _attribute_map = {
        'private_link': {'key': 'privateLink', 'type': 'ResourceReference'},
        'private_link_location': {'key': 'privateLinkLocation', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'request_message': {'key': 'requestMessage', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_link: Optional["ResourceReference"] = None,
        private_link_location: Optional[str] = None,
        group_id: Optional[str] = None,
        request_message: Optional[str] = None,
        status: Optional[Union[str, "SharedPrivateLinkResourceStatus"]] = None,
        **kwargs
    ):
        super(SharedPrivateLinkResourceProperties, self).__init__(**kwargs)
        self.private_link = private_link
        self.private_link_location = private_link_location
        self.group_id = group_id
        self.request_message = request_message
        self.status = status


class Sku(msrest.serialization.Model):
    """The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.

    :param name: Name of the pricing tier. Possible values include: "Standard_Verizon",
     "Premium_Verizon", "Custom_Verizon", "Standard_Akamai", "Standard_ChinaCdn",
     "Standard_Microsoft", "Premium_ChinaCdn", "Standard_AzureFrontDoor", "Premium_AzureFrontDoor",
     "Standard_955BandWidth_ChinaCdn", "Standard_AvgBandWidth_ChinaCdn", "StandardPlus_ChinaCdn",
     "StandardPlus_955BandWidth_ChinaCdn", "StandardPlus_AvgBandWidth_ChinaCdn".
    :type name: str or ~azure.mgmt.cdn.models.SkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SkuName"]] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name


class SsoUri(msrest.serialization.Model):
    """The URI required to login to the supplemental portal from the Azure portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sso_uri_value: The URI used to login to the supplemental portal.
    :vartype sso_uri_value: str
    """

    _validation = {
        'sso_uri_value': {'readonly': True},
    }

    _attribute_map = {
        'sso_uri_value': {'key': 'ssoUriValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SsoUri, self).__init__(**kwargs)
        self.sso_uri_value = None


class SupportedOptimizationTypesListResult(msrest.serialization.Model):
    """The result of the GetSupportedOptimizationTypes API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar supported_optimization_types: Supported optimization types for a profile.
    :vartype supported_optimization_types: list[str or ~azure.mgmt.cdn.models.OptimizationType]
    """

    _validation = {
        'supported_optimization_types': {'readonly': True},
    }

    _attribute_map = {
        'supported_optimization_types': {'key': 'supportedOptimizationTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SupportedOptimizationTypesListResult, self).__init__(**kwargs)
        self.supported_optimization_types = None


class SystemData(msrest.serialization.Model):
    """Read only system data.

    :param created_by: An identifier for the identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "user", "application", "managedIdentity", "key".
    :type created_by_type: str or ~azure.mgmt.cdn.models.IdentityType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: An identifier for the identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "user", "application", "managedIdentity", "key".
    :type last_modified_by_type: str or ~azure.mgmt.cdn.models.IdentityType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UrlFileExtensionMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlFileExtension match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionMatchConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.UrlFileExtensionOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFileExtensionMatchConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlFileExtensionOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(UrlFileExtensionMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlFileNameMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlFilename match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFilenameConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.UrlFileNameOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlFilenameConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlFileNameOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(UrlFileNameMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlPathMatchConditionParameters(msrest.serialization.Model):
    """Defines the parameters for UrlPath match conditions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlPathMatchConditionParameters".
    :vartype odata_type: str
    :param operator: Required. Describes operator to be matched. Possible values include: "Any",
     "Equal", "Contains", "BeginsWith", "EndsWith", "LessThan", "LessThanOrEqual", "GreaterThan",
     "GreaterThanOrEqual", "Wildcard", "RegEx".
    :type operator: str or ~azure.mgmt.cdn.models.UrlPathOperator
    :param negate_condition: Describes if this is negate condition or not.
    :type negate_condition: bool
    :param match_values: The match value for the condition of the delivery rule.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.cdn.models.Transform]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'operator': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlPathMatchConditionParameters"

    def __init__(
        self,
        *,
        operator: Union[str, "UrlPathOperator"],
        negate_condition: Optional[bool] = None,
        match_values: Optional[List[str]] = None,
        transforms: Optional[List[Union[str, "Transform"]]] = None,
        **kwargs
    ):
        super(UrlPathMatchConditionParameters, self).__init__(**kwargs)
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_values = match_values
        self.transforms = transforms


class UrlRedirectAction(DeliveryRuleAction):
    """Defines the url redirect action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.UrlRedirectActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlRedirectActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlRedirectActionParameters",
        **kwargs
    ):
        super(UrlRedirectAction, self).__init__(**kwargs)
        self.name = 'UrlRedirect'  # type: str
        self.parameters = parameters


class UrlRedirectActionParameters(msrest.serialization.Model):
    """Defines the parameters for the url redirect action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRedirectActionParameters".
    :vartype odata_type: str
    :param redirect_type: Required. The redirect type the rule will use when redirecting traffic.
     Possible values include: "Moved", "Found", "TemporaryRedirect", "PermanentRedirect".
    :type redirect_type: str or ~azure.mgmt.cdn.models.RedirectType
    :param destination_protocol: Protocol to use for the redirect. The default value is
     MatchRequest. Possible values include: "MatchRequest", "Http", "Https".
    :type destination_protocol: str or ~azure.mgmt.cdn.models.DestinationProtocol
    :param custom_path: The full path to redirect. Path cannot be empty and must start with /.
     Leave empty to use the incoming path as destination path.
    :type custom_path: str
    :param custom_hostname: Host to redirect. Leave empty to use the incoming host as the
     destination host.
    :type custom_hostname: str
    :param custom_query_string: The set of query strings to be placed in the redirect URL. Setting
     this value would replace any existing query string; leave empty to preserve the incoming query
     string. Query string must be in :code:`<key>`=:code:`<value>` format. ? and & will be added
     automatically so do not include them.
    :type custom_query_string: str
    :param custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL
     that comes after #. Do not include the #.
    :type custom_fragment: str
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'redirect_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'redirect_type': {'key': 'redirectType', 'type': 'str'},
        'destination_protocol': {'key': 'destinationProtocol', 'type': 'str'},
        'custom_path': {'key': 'customPath', 'type': 'str'},
        'custom_hostname': {'key': 'customHostname', 'type': 'str'},
        'custom_query_string': {'key': 'customQueryString', 'type': 'str'},
        'custom_fragment': {'key': 'customFragment', 'type': 'str'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRedirectActionParameters"

    def __init__(
        self,
        *,
        redirect_type: Union[str, "RedirectType"],
        destination_protocol: Optional[Union[str, "DestinationProtocol"]] = None,
        custom_path: Optional[str] = None,
        custom_hostname: Optional[str] = None,
        custom_query_string: Optional[str] = None,
        custom_fragment: Optional[str] = None,
        **kwargs
    ):
        super(UrlRedirectActionParameters, self).__init__(**kwargs)
        self.redirect_type = redirect_type
        self.destination_protocol = destination_protocol
        self.custom_path = custom_path
        self.custom_hostname = custom_hostname
        self.custom_query_string = custom_query_string
        self.custom_fragment = custom_fragment


class UrlRewriteAction(DeliveryRuleAction):
    """Defines the url rewrite action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.UrlRewriteActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlRewriteActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlRewriteActionParameters",
        **kwargs
    ):
        super(UrlRewriteAction, self).__init__(**kwargs)
        self.name = 'UrlRewrite'  # type: str
        self.parameters = parameters


class UrlRewriteActionParameters(msrest.serialization.Model):
    """Defines the parameters for the url rewrite action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRewriteActionParameters".
    :vartype odata_type: str
    :param source_pattern: Required. define a request URI pattern that identifies the type of
     requests that may be rewritten. If value is blank, all strings are matched.
    :type source_pattern: str
    :param destination: Required. Define the relative URL to which the above requests will be
     rewritten by.
    :type destination: str
    :param preserve_unmatched_path: Whether to preserve unmatched path. Default value is true.
    :type preserve_unmatched_path: bool
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
        'source_pattern': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'source_pattern': {'key': 'sourcePattern', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
        'preserve_unmatched_path': {'key': 'preserveUnmatchedPath', 'type': 'bool'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlRewriteActionParameters"

    def __init__(
        self,
        *,
        source_pattern: str,
        destination: str,
        preserve_unmatched_path: Optional[bool] = None,
        **kwargs
    ):
        super(UrlRewriteActionParameters, self).__init__(**kwargs)
        self.source_pattern = source_pattern
        self.destination = destination
        self.preserve_unmatched_path = preserve_unmatched_path


class UrlSigningAction(DeliveryRuleAction):
    """Defines the url signing action for the delivery rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the action for the delivery rule.Constant filled by server.
     Possible values include: "CacheExpiration", "CacheKeyQueryString", "ModifyRequestHeader",
     "ModifyResponseHeader", "UrlRedirect", "UrlRewrite", "UrlSigning", "OriginGroupOverride".
    :type name: str or ~azure.mgmt.cdn.models.DeliveryRuleActionEnum
    :param parameters: Required. Defines the parameters for the action.
    :type parameters: ~azure.mgmt.cdn.models.UrlSigningActionParameters
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'UrlSigningActionParameters'},
    }

    def __init__(
        self,
        *,
        parameters: "UrlSigningActionParameters",
        **kwargs
    ):
        super(UrlSigningAction, self).__init__(**kwargs)
        self.name = 'UrlSigning'  # type: str
        self.parameters = parameters


class UrlSigningActionParameters(msrest.serialization.Model):
    """Defines the parameters for the Url Signing action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required.  Default value:
     "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters".
    :vartype odata_type: str
    :param algorithm: Algorithm to use for URL signing. Possible values include: "SHA256".
    :type algorithm: str or ~azure.mgmt.cdn.models.Algorithm
    :param parameter_name_override: Defines which query string parameters in the url to be
     considered for expires, key id etc.
    :type parameter_name_override: list[~azure.mgmt.cdn.models.UrlSigningParamIdentifier]
    """

    _validation = {
        'odata_type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'algorithm': {'key': 'algorithm', 'type': 'str'},
        'parameter_name_override': {'key': 'parameterNameOverride', 'type': '[UrlSigningParamIdentifier]'},
    }

    odata_type = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters"

    def __init__(
        self,
        *,
        algorithm: Optional[Union[str, "Algorithm"]] = None,
        parameter_name_override: Optional[List["UrlSigningParamIdentifier"]] = None,
        **kwargs
    ):
        super(UrlSigningActionParameters, self).__init__(**kwargs)
        self.algorithm = algorithm
        self.parameter_name_override = parameter_name_override


class UrlSigningKey(msrest.serialization.Model):
    """Url signing key.

    All required parameters must be populated in order to send to Azure.

    :param key_id: Required. Defines the customer defined key Id. This id will exist in the
     incoming request to indicate the key used to form the hash.
    :type key_id: str
    :param key_source_parameters: Required. Defines the parameters for using customer key vault for
     Url Signing Key.
    :type key_source_parameters: ~azure.mgmt.cdn.models.KeyVaultSigningKeyParameters
    """

    _validation = {
        'key_id': {'required': True},
        'key_source_parameters': {'required': True},
    }

    _attribute_map = {
        'key_id': {'key': 'keyId', 'type': 'str'},
        'key_source_parameters': {'key': 'keySourceParameters', 'type': 'KeyVaultSigningKeyParameters'},
    }

    def __init__(
        self,
        *,
        key_id: str,
        key_source_parameters: "KeyVaultSigningKeyParameters",
        **kwargs
    ):
        super(UrlSigningKey, self).__init__(**kwargs)
        self.key_id = key_id
        self.key_source_parameters = key_source_parameters


class UrlSigningKeyParameters(SecretParameters):
    """Url signing key parameters.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of the Secret to create.Constant filled by server.  Possible
     values include: "UrlSigningKey", "CustomerCertificate", "ManagedCertificate".
    :type type: str or ~azure.mgmt.cdn.models.SecretType
    :param key_id: Required. Defines the customer defined key Id. This id will exist in the
     incoming request to indicate the key used to form the hash.
    :type key_id: str
    :param secret_source: Required. Resource reference to the KV secret.
    :type secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :param secret_version: Version of the secret to be used.
    :type secret_version: str
    """

    _validation = {
        'type': {'required': True},
        'key_id': {'required': True},
        'secret_source': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'key_id': {'key': 'keyId', 'type': 'str'},
        'secret_source': {'key': 'secretSource', 'type': 'ResourceReference'},
        'secret_version': {'key': 'secretVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_id: str,
        secret_source: "ResourceReference",
        secret_version: Optional[str] = None,
        **kwargs
    ):
        super(UrlSigningKeyParameters, self).__init__(**kwargs)
        self.type = 'UrlSigningKey'  # type: str
        self.key_id = key_id
        self.secret_source = secret_source
        self.secret_version = secret_version


class UrlSigningParamIdentifier(msrest.serialization.Model):
    """Defines how to identify a parameter for a specific purpose e.g. expires.

    All required parameters must be populated in order to send to Azure.

    :param param_indicator: Required. Indicates the purpose of the parameter. Possible values
     include: "Expires", "KeyId", "Signature".
    :type param_indicator: str or ~azure.mgmt.cdn.models.ParamIndicator
    :param param_name: Required. Parameter name.
    :type param_name: str
    """

    _validation = {
        'param_indicator': {'required': True},
        'param_name': {'required': True},
    }

    _attribute_map = {
        'param_indicator': {'key': 'paramIndicator', 'type': 'str'},
        'param_name': {'key': 'paramName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        param_indicator: Union[str, "ParamIndicator"],
        param_name: str,
        **kwargs
    ):
        super(UrlSigningParamIdentifier, self).__init__(**kwargs)
        self.param_indicator = param_indicator
        self.param_name = param_name


class Usage(msrest.serialization.Model):
    """Describes resource usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource identifier.
    :vartype id: str
    :param unit: Required. An enum describing the unit of measurement. Possible values include:
     "Count".
    :type unit: str or ~azure.mgmt.cdn.models.UsageUnit
    :param current_value: Required. The current value of the usage.
    :type current_value: long
    :param limit: Required. The limit of usage.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.cdn.models.UsageName
    """

    _validation = {
        'id': {'readonly': True},
        'unit': {'required': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        *,
        unit: Union[str, "UsageUnit"],
        current_value: int,
        limit: int,
        name: "UsageName",
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(msrest.serialization.Model):
    """The usage names.

    :param value: A string describing the resource name.
    :type value: str
    :param localized_value: A localized string describing the resource name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsagesListResult(msrest.serialization.Model):
    """The list usages operation response.

    :param value: The list of resource usages.
    :type value: list[~azure.mgmt.cdn.models.Usage]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Usage"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(UsagesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UserManagedHttpsParameters(CustomDomainHttpsParameters):
    """Defines the certificate source parameters using user's keyvault certificate for enabling SSL.

    All required parameters must be populated in order to send to Azure.

    :param certificate_source: Required. Defines the source of the SSL certificate.Constant filled
     by server.  Possible values include: "AzureKeyVault", "Cdn".
    :type certificate_source: str or ~azure.mgmt.cdn.models.CertificateSource
    :param protocol_type: Required. Defines the TLS extension protocol that is used for secure
     delivery. Possible values include: "ServerNameIndication", "IPBased".
    :type protocol_type: str or ~azure.mgmt.cdn.models.ProtocolType
    :param minimum_tls_version: TLS protocol version that will be used for Https. Possible values
     include: "None", "TLS10", "TLS12".
    :type minimum_tls_version: str or ~azure.mgmt.cdn.models.MinimumTlsVersion
    :param certificate_source_parameters: Required. Defines the certificate source parameters using
     user's keyvault certificate for enabling SSL.
    :type certificate_source_parameters: ~azure.mgmt.cdn.models.KeyVaultCertificateSourceParameters
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True},
        'certificate_source_parameters': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'certificate_source_parameters': {'key': 'certificateSourceParameters', 'type': 'KeyVaultCertificateSourceParameters'},
    }

    def __init__(
        self,
        *,
        protocol_type: Union[str, "ProtocolType"],
        certificate_source_parameters: "KeyVaultCertificateSourceParameters",
        minimum_tls_version: Optional[Union[str, "MinimumTlsVersion"]] = None,
        **kwargs
    ):
        super(UserManagedHttpsParameters, self).__init__(protocol_type=protocol_type, minimum_tls_version=minimum_tls_version, **kwargs)
        self.certificate_source = 'AzureKeyVault'  # type: str
        self.certificate_source_parameters = certificate_source_parameters


class ValidateCustomDomainInput(msrest.serialization.Model):
    """Input of the custom domain to be validated for DNS mapping.

    All required parameters must be populated in order to send to Azure.

    :param host_name: Required. The host name of the custom domain. Must be a domain name.
    :type host_name: str
    """

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_name: str,
        **kwargs
    ):
        super(ValidateCustomDomainInput, self).__init__(**kwargs)
        self.host_name = host_name


class ValidateCustomDomainOutput(msrest.serialization.Model):
    """Output of custom domain validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar custom_domain_validated: Indicates whether the custom domain is valid or not.
    :vartype custom_domain_validated: bool
    :ivar reason: The reason why the custom domain is not valid.
    :vartype reason: str
    :ivar message: Error message describing why the custom domain is not valid.
    :vartype message: str
    """

    _validation = {
        'custom_domain_validated': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'custom_domain_validated': {'key': 'customDomainValidated', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateCustomDomainOutput, self).__init__(**kwargs)
        self.custom_domain_validated = None
        self.reason = None
        self.message = None


class ValidateProbeInput(msrest.serialization.Model):
    """Input of the validate probe API.

    All required parameters must be populated in order to send to Azure.

    :param probe_url: Required. The probe URL to validate.
    :type probe_url: str
    """

    _validation = {
        'probe_url': {'required': True},
    }

    _attribute_map = {
        'probe_url': {'key': 'probeURL', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        probe_url: str,
        **kwargs
    ):
        super(ValidateProbeInput, self).__init__(**kwargs)
        self.probe_url = probe_url


class ValidateProbeOutput(msrest.serialization.Model):
    """Output of the validate probe API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_valid: Indicates whether the probe URL is accepted or not.
    :vartype is_valid: bool
    :ivar error_code: Specifies the error code when the probe url is not accepted.
    :vartype error_code: str
    :ivar message: The detailed error message describing why the probe URL is not accepted.
    :vartype message: str
    """

    _validation = {
        'is_valid': {'readonly': True},
        'error_code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateProbeOutput, self).__init__(**kwargs)
        self.is_valid = None
        self.error_code = None
        self.message = None


class ValidateSecretInput(msrest.serialization.Model):
    """Input of the secret to be validated.

    All required parameters must be populated in order to send to Azure.

    :param secret_source: Required. The secret source.
    :type secret_source: ~azure.mgmt.cdn.models.ResourceReference
    :param secret_type: Required. The secret type. Possible values include: "UrlSigningKey",
     "ManagedCertificate", "CustomerCertificate".
    :type secret_type: str or ~azure.mgmt.cdn.models.ValidateSecretType
    """

    _validation = {
        'secret_source': {'required': True},
        'secret_type': {'required': True},
    }

    _attribute_map = {
        'secret_source': {'key': 'secretSource', 'type': 'ResourceReference'},
        'secret_type': {'key': 'secretType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        secret_source: "ResourceReference",
        secret_type: Union[str, "ValidateSecretType"],
        **kwargs
    ):
        super(ValidateSecretInput, self).__init__(**kwargs)
        self.secret_source = secret_source
        self.secret_type = secret_type


class ValidateSecretOutput(msrest.serialization.Model):
    """Output of the validated secret.

    :param status: The validation status. Possible values include: "Valid", "Invalid",
     "AccessDenied", "CertificateExpired".
    :type status: str or ~azure.mgmt.cdn.models.Status
    :param message: Detailed error message.
    :type message: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "Status"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ValidateSecretOutput, self).__init__(**kwargs)
        self.status = status
        self.message = message


class ValidationToken(msrest.serialization.Model):
    """The validation token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar token:
    :vartype token: str
    """

    _validation = {
        'token': {'readonly': True},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationToken, self).__init__(**kwargs)
        self.token = None


class WafMetricsResponse(msrest.serialization.Model):
    """Waf Metrics Response.

    :param date_time_begin:
    :type date_time_begin: ~datetime.datetime
    :param date_time_end:
    :type date_time_end: ~datetime.datetime
    :param granularity:  Possible values include: "PT5M", "PT1H", "P1D".
    :type granularity: str or ~azure.mgmt.cdn.models.WafMetricsResponseGranularity
    :param series:
    :type series: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesItem]
    """

    _attribute_map = {
        'date_time_begin': {'key': 'dateTimeBegin', 'type': 'iso-8601'},
        'date_time_end': {'key': 'dateTimeEnd', 'type': 'iso-8601'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'series': {'key': 'series', 'type': '[WafMetricsResponseSeriesItem]'},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        granularity: Optional[Union[str, "WafMetricsResponseGranularity"]] = None,
        series: Optional[List["WafMetricsResponseSeriesItem"]] = None,
        **kwargs
    ):
        super(WafMetricsResponse, self).__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.granularity = granularity
        self.series = series


class WafMetricsResponseSeriesItem(msrest.serialization.Model):
    """WafMetricsResponseSeriesItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param metric:
    :type metric: str
    :ivar unit:  Default value: "count".
    :vartype unit: str
    :param groups:
    :type groups: list[~azure.mgmt.cdn.models.WafMetricsResponseSeriesPropertiesItemsItem]
    :param data:
    :type data:
     list[~azure.mgmt.cdn.models.Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems]
    """

    _validation = {
        'unit': {'constant': True},
    }

    _attribute_map = {
        'metric': {'key': 'metric', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[WafMetricsResponseSeriesPropertiesItemsItem]'},
        'data': {'key': 'data', 'type': '[Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems]'},
    }

    unit = "count"

    def __init__(
        self,
        *,
        metric: Optional[str] = None,
        groups: Optional[List["WafMetricsResponseSeriesPropertiesItemsItem"]] = None,
        data: Optional[List["Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems"]] = None,
        **kwargs
    ):
        super(WafMetricsResponseSeriesItem, self).__init__(**kwargs)
        self.metric = metric
        self.groups = groups
        self.data = data


class WafMetricsResponseSeriesPropertiesItemsItem(msrest.serialization.Model):
    """WafMetricsResponseSeriesPropertiesItemsItem.

    :param name:
    :type name: str
    :param value:
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(WafMetricsResponseSeriesPropertiesItemsItem, self).__init__(**kwargs)
        self.name = name
        self.value = value


class WafRankingsResponse(msrest.serialization.Model):
    """Waf Rankings Response.

    :param date_time_begin:
    :type date_time_begin: ~datetime.datetime
    :param date_time_end:
    :type date_time_end: ~datetime.datetime
    :param groups:
    :type groups: list[str]
    :param data:
    :type data: list[~azure.mgmt.cdn.models.WafRankingsResponseDataItem]
    """

    _attribute_map = {
        'date_time_begin': {'key': 'dateTimeBegin', 'type': 'iso-8601'},
        'date_time_end': {'key': 'dateTimeEnd', 'type': 'iso-8601'},
        'groups': {'key': 'groups', 'type': '[str]'},
        'data': {'key': 'data', 'type': '[WafRankingsResponseDataItem]'},
    }

    def __init__(
        self,
        *,
        date_time_begin: Optional[datetime.datetime] = None,
        date_time_end: Optional[datetime.datetime] = None,
        groups: Optional[List[str]] = None,
        data: Optional[List["WafRankingsResponseDataItem"]] = None,
        **kwargs
    ):
        super(WafRankingsResponse, self).__init__(**kwargs)
        self.date_time_begin = date_time_begin
        self.date_time_end = date_time_end
        self.groups = groups
        self.data = data


class WafRankingsResponseDataItem(msrest.serialization.Model):
    """WafRankingsResponseDataItem.

    :param group_values:
    :type group_values: list[str]
    :param metrics:
    :type metrics:
     list[~azure.mgmt.cdn.models.ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems]
    """

    _attribute_map = {
        'group_values': {'key': 'groupValues', 'type': '[str]'},
        'metrics': {'key': 'metrics', 'type': '[ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems]'},
    }

    def __init__(
        self,
        *,
        group_values: Optional[List[str]] = None,
        metrics: Optional[List["ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems"]] = None,
        **kwargs
    ):
        super(WafRankingsResponseDataItem, self).__init__(**kwargs)
        self.group_values = group_values
        self.metrics = metrics
