# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the action to take on rule match.
    """

    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"
    REDIRECT = "Redirect"

class AfdCertificateType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the source of the SSL certificate.
    """

    CUSTOMER_CERTIFICATE = "CustomerCertificate"
    MANAGED_CERTIFICATE = "ManagedCertificate"

class AFDEndpointProtocols(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Supported protocols for the customer's endpoint.
    """

    HTTP = "Http"
    HTTPS = "Https"

class AfdMinimumTlsVersion(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """TLS protocol version that will be used for Https
    """

    TLS10 = "TLS10"
    TLS12 = "TLS12"

class AfdProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning status
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    DELETING = "Deleting"
    CREATING = "Creating"

class Algorithm(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Algorithm to use for URL signing
    """

    SHA256 = "SHA256"

class CacheBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Caching behavior for the requests
    """

    BYPASS_CACHE = "BypassCache"
    OVERRIDE = "Override"
    SET_IF_MISSING = "SetIfMissing"

class CacheType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The level at which the content needs to be cached.
    """

    ALL = "All"

class CertificateSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the source of the SSL certificate.
    """

    AZURE_KEY_VAULT = "AzureKeyVault"
    CDN = "Cdn"

class CertificateType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of certificate used
    """

    SHARED = "Shared"
    DEDICATED = "Dedicated"

class CookiesOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class CustomDomainResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the custom domain.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class CustomHttpsProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning status of Custom Https of the custom domain.
    """

    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    FAILED = "Failed"

class CustomHttpsProvisioningSubstate(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by
    step.
    """

    SUBMITTING_DOMAIN_CONTROL_VALIDATION_REQUEST = "SubmittingDomainControlValidationRequest"
    PENDING_DOMAIN_CONTROL_VALIDATION_R_EQUEST_APPROVAL = "PendingDomainControlValidationREquestApproval"
    DOMAIN_CONTROL_VALIDATION_REQUEST_APPROVED = "DomainControlValidationRequestApproved"
    DOMAIN_CONTROL_VALIDATION_REQUEST_REJECTED = "DomainControlValidationRequestRejected"
    DOMAIN_CONTROL_VALIDATION_REQUEST_TIMED_OUT = "DomainControlValidationRequestTimedOut"
    ISSUING_CERTIFICATE = "IssuingCertificate"
    DEPLOYING_CERTIFICATE = "DeployingCertificate"
    CERTIFICATE_DEPLOYED = "CertificateDeployed"
    DELETING_CERTIFICATE = "DeletingCertificate"
    CERTIFICATE_DELETED = "CertificateDeleted"

class CustomRuleEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DeleteRule(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes the action that shall be taken when the certificate is removed from Key Vault.
    """

    NO_ACTION = "NoAction"

class DeliveryRuleActionEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the action for the delivery rule.
    """

    CACHE_EXPIRATION = "CacheExpiration"
    CACHE_KEY_QUERY_STRING = "CacheKeyQueryString"
    MODIFY_REQUEST_HEADER = "ModifyRequestHeader"
    MODIFY_RESPONSE_HEADER = "ModifyResponseHeader"
    URL_REDIRECT = "UrlRedirect"
    URL_REWRITE = "UrlRewrite"
    URL_SIGNING = "UrlSigning"
    ORIGIN_GROUP_OVERRIDE = "OriginGroupOverride"

class DeploymentStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class DestinationProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol to use for the redirect. The default value is MatchRequest
    """

    MATCH_REQUEST = "MatchRequest"
    HTTP = "Http"
    HTTPS = "Https"

class DomainValidationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by
    step. DCV stands for DomainControlValidation.
    """

    UNKNOWN = "Unknown"
    SUBMITTING = "Submitting"
    PENDING = "Pending"
    TIMED_OUT = "TimedOut"
    PENDING_REVALIDATION = "PendingRevalidation"
    APPROVED = "Approved"

class EnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EndpointResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the endpoint.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    RUNNING = "Running"
    STARTING = "Starting"
    STOPPED = "Stopped"
    STOPPING = "Stopping"

class Enum31(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"

class Enum35(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    URL = "url"
    REFERRER = "referrer"
    BROWSER = "browser"
    USER_AGENT = "userAgent"
    COUNTRY_OR_REGION = "countryOrRegion"

class Enum37(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"

class Enum38(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALLOW = "allow"
    BLOCK = "block"
    LOG = "log"
    REDIRECT = "redirect"

class Enum39(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HTTP_STATUS_CODE = "httpStatusCode"
    CUSTOM_DOMAIN = "customDomain"

class Enum40(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MANAGED = "managed"
    CUSTOM = "custom"
    BOT = "bot"

class Enum42(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ACTION = "action"
    RULE_GROUP = "ruleGroup"
    RULE_ID = "ruleId"
    USER_AGENT = "userAgent"
    CLIENT_IP = "clientIp"
    URL = "url"
    COUNTRY = "country"
    RULE_TYPE = "ruleType"

class Enum43(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALLOW = "allow"
    BLOCK = "block"
    LOG = "log"
    REDIRECT = "redirect"

class Enum44(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MANAGED = "managed"
    CUSTOM = "custom"
    BOT = "bot"

class Enum47(with_metaclass(_CaseInsensitiveEnumMeta, int, Enum)):
    """If the action type is block, this field defines the default customer overridable http response
    status code.
    """

    TWO_HUNDRED = 200
    FOUR_HUNDRED_THREE = 403
    FOUR_HUNDRED_FIVE = 405
    FOUR_HUNDRED_SIX = 406
    FOUR_HUNDRED_TWENTY_NINE = 429

class ForwardingProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol this rule will use when forwarding traffic to backends.
    """

    HTTP_ONLY = "HttpOnly"
    HTTPS_ONLY = "HttpsOnly"
    MATCH_REQUEST = "MatchRequest"

class GeoFilterActions(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Action of the geo filter, i.e. allow or block access.
    """

    BLOCK = "Block"
    ALLOW = "Allow"

class Get4ItemsItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CLIENT_REQUEST_COUNT = "clientRequestCount"
    CLIENT_REQUEST_TRAFFIC = "clientRequestTraffic"
    CLIENT_REQUEST_BANDWIDTH = "clientRequestBandwidth"
    ORIGIN_REQUEST_TRAFFIC = "originRequestTraffic"
    ORIGIN_REQUEST_BANDWIDTH = "originRequestBandwidth"
    TOTAL_LATENCY = "totalLatency"

class Get5ItemsItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CLIENT_REQUEST_COUNT = "clientRequestCount"
    CLIENT_REQUEST_TRAFFIC = "clientRequestTraffic"
    CLIENT_REQUEST_BANDWIDTH = "clientRequestBandwidth"
    ORIGIN_REQUEST_TRAFFIC = "originRequestTraffic"
    ORIGIN_REQUEST_BANDWIDTH = "originRequestBandwidth"

class Get8ItemsItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HTTP_STATUS_CODE = "httpStatusCode"
    PROTOCOL = "protocol"
    CACHE_STATUS = "cacheStatus"
    COUNTRY = "country"
    CUSTOM_DOMAIN = "customDomain"

class HeaderAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Action to perform
    """

    APPEND = "Append"
    OVERWRITE = "Overwrite"
    DELETE = "Delete"

class HealthProbeRequestType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of health probe request that is made.
    """

    NOT_SET = "NotSet"
    GET = "GET"
    HEAD = "HEAD"

class HttpsRedirect(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way
    to set up this rule and it will be the first rule that gets executed.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class HttpVersionOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class IdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that creates/modifies resources
    """

    USER = "user"
    APPLICATION = "application"
    MANAGED_IDENTITY = "managedIdentity"
    KEY = "key"

class IsDeviceMatchConditionParametersMatchValuesItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MOBILE = "Mobile"
    DESKTOP = "Desktop"

class IsDeviceOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class LinkToDefaultDomain(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """whether this route will be linked to the default endpoint domain.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ManagedRuleEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class MatchProcessingBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """If this rule is a match should the rules engine continue running the remaining rules or stop.
    If not present, defaults to Continue.
    """

    CONTINUE_ENUM = "Continue"
    STOP = "Stop"

class MatchVariable(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the condition for the delivery rule.
    """

    REMOTE_ADDRESS = "RemoteAddress"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_BODY = "RequestBody"
    REQUEST_SCHEME = "RequestScheme"
    URL_PATH = "UrlPath"
    URL_FILE_EXTENSION = "UrlFileExtension"
    URL_FILE_NAME = "UrlFileName"
    HTTP_VERSION = "HttpVersion"
    COOKIES = "Cookies"
    IS_DEVICE = "IsDevice"
    REMOTE_ADDR = "RemoteAddr"
    SOCKET_ADDR = "SocketAddr"

class MetricsResponseGranularity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"

class MetricsResponseSeriesItemUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    COUNT = "count"
    BYTES = "bytes"
    BITS_PER_SECOND = "bitsPerSecond"

class MinimumTlsVersion(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """TLS protocol version that will be used for Https
    """

    NONE = "None"
    TLS10 = "TLS10"
    TLS12 = "TLS12"

class Operator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    REG_EX = "RegEx"

class OptimizationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies what scenario the customer wants this CDN endpoint to optimize, e.g. Download, Media
    services. With this information we can apply scenario driven optimization.
    """

    GENERAL_WEB_DELIVERY = "GeneralWebDelivery"
    GENERAL_MEDIA_STREAMING = "GeneralMediaStreaming"
    VIDEO_ON_DEMAND_MEDIA_STREAMING = "VideoOnDemandMediaStreaming"
    LARGE_FILE_DOWNLOAD = "LargeFileDownload"
    DYNAMIC_SITE_ACCELERATION = "DynamicSiteAcceleration"

class OriginGroupResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the origin group.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class OriginResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the origin.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class ParamIndicator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates the purpose of the parameter
    """

    EXPIRES = "Expires"
    KEY_ID = "KeyId"
    SIGNATURE = "Signature"

class PolicyEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """describes if the policy is in enabled state or disabled state
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class PolicyMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if it is in detection mode or prevention mode at policy level.
    """

    PREVENTION = "Prevention"
    DETECTION = "Detection"

class PolicyResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the policy.
    """

    CREATING = "Creating"
    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    DELETING = "Deleting"

class PostArgsOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class PrivateEndpointStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The approval status for the connection to the Private Link
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class ProbeProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol to use for health probe.
    """

    NOT_SET = "NotSet"
    HTTP = "Http"
    HTTPS = "Https"

class ProfileResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the profile.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"
    DISABLED = "Disabled"

class ProtocolType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the TLS extension protocol that is used for secure delivery.
    """

    SERVER_NAME_INDICATION = "ServerNameIndication"
    IP_BASED = "IPBased"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the WebApplicationFirewallPolicy.
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class QueryStringBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Caching behavior for the requests
    """

    INCLUDE = "Include"
    INCLUDE_ALL = "IncludeAll"
    EXCLUDE = "Exclude"
    EXCLUDE_ALL = "ExcludeAll"

class QueryStringCachingBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines how CDN caches requests that include query strings. You can ignore any query strings
    when caching, bypass caching to prevent requests that contain query strings from being cached,
    or cache every request with a unique URL.
    """

    IGNORE_QUERY_STRING = "IgnoreQueryString"
    BYPASS_CACHING = "BypassCaching"
    USE_QUERY_STRING = "UseQueryString"
    NOT_SET = "NotSet"

class QueryStringOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class RedirectType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The redirect type the rule will use when redirecting traffic.
    """

    MOVED = "Moved"
    FOUND = "Found"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    PERMANENT_REDIRECT = "PermanentRedirect"

class RemoteAddressOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"

class RequestBodyOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class RequestHeaderOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class RequestMethodMatchConditionParametersMatchValuesItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    GET = "GET"
    HEAD = "HEAD"
    POST = "POST"
    PUT = "PUT"
    DELETE = "DELETE"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"

class RequestMethodOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class RequestSchemeMatchConditionParametersMatchValuesItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HTTP = "HTTP"
    HTTPS = "HTTPS"

class RequestUriOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class ResponseBasedDetectedErrorTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of response errors for real user requests for which origin will be deemed unhealthy
    """

    NONE = "None"
    TCP_ERRORS_ONLY = "TcpErrorsOnly"
    TCP_AND_HTTP_ERRORS = "TcpAndHttpErrors"

class SecretType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the Secret to create.
    """

    URL_SIGNING_KEY = "UrlSigningKey"
    CUSTOMER_CERTIFICATE = "CustomerCertificate"
    MANAGED_CERTIFICATE = "ManagedCertificate"

class SecurityPolicyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the Security policy to create.
    """

    WEB_APPLICATION_FIREWALL = "WebApplicationFirewall"

class SharedPrivateLinkResourceStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected,
    or Timeout.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name of the pricing tier.
    """

    STANDARD_VERIZON = "Standard_Verizon"
    PREMIUM_VERIZON = "Premium_Verizon"
    CUSTOM_VERIZON = "Custom_Verizon"
    STANDARD_AKAMAI = "Standard_Akamai"
    STANDARD_CHINA_CDN = "Standard_ChinaCdn"
    STANDARD_MICROSOFT = "Standard_Microsoft"
    PREMIUM_CHINA_CDN = "Premium_ChinaCdn"
    STANDARD_AZURE_FRONT_DOOR = "Standard_AzureFrontDoor"
    PREMIUM_AZURE_FRONT_DOOR = "Premium_AzureFrontDoor"
    STANDARD955_BAND_WIDTH_CHINA_CDN = "Standard_955BandWidth_ChinaCdn"
    STANDARD_AVG_BAND_WIDTH_CHINA_CDN = "Standard_AvgBandWidth_ChinaCdn"
    STANDARD_PLUS_CHINA_CDN = "StandardPlus_ChinaCdn"
    STANDARD_PLUS955_BAND_WIDTH_CHINA_CDN = "StandardPlus_955BandWidth_ChinaCdn"
    STANDARD_PLUS_AVG_BAND_WIDTH_CHINA_CDN = "StandardPlus_AvgBandWidth_ChinaCdn"

class Status(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The validation status.
    """

    VALID = "Valid"
    INVALID = "Invalid"
    ACCESS_DENIED = "AccessDenied"
    CERTIFICATE_EXPIRED = "CertificateExpired"

class Transform(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what transforms are applied before matching
    """

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"

class TransformType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what transforms were applied before matching.
    """

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"

class UpdateRule(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes the action that shall be taken when the certificate is updated in Key Vault.
    """

    NO_ACTION = "NoAction"

class UrlFileExtensionOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class UrlFileNameOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class UrlPathOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    WILDCARD = "Wildcard"
    REG_EX = "RegEx"

class UsageUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enum describing the unit of measurement.
    """

    COUNT = "Count"

class ValidateSecretType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The secret type.
    """

    URL_SIGNING_KEY = "UrlSigningKey"
    MANAGED_CERTIFICATE = "ManagedCertificate"
    CUSTOMER_CERTIFICATE = "CustomerCertificate"

class WafMetricsResponseGranularity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"
