# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Dict, IO, List, Optional, TYPE_CHECKING, Union

from azure.core.pipeline.transport._base import _format_url_section
from azure.purview.catalog.core.rest import HttpRequest
from msrest import Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any

_SERIALIZER = Serializer()


def build_get_classification_def_by_guid_request(
    guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the classification definition for the given GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the classification.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "entityTypes": [
                    "str (optional)"
                ],
                "subTypes": [
                    "str (optional)"
                ],
                "superTypes": [
                    "str (optional)"
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/classificationdef/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_classification_def_by_name_request(
    name: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the classification definition by its name (unique).

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param name: The name of the classification.
    :type name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "entityTypes": [
                    "str (optional)"
                ],
                "subTypes": [
                    "str (optional)"
                ],
                "superTypes": [
                    "str (optional)"
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/classificationdef/name/{name}')
    path_format_arguments = {
        'name': _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_entity_definition_by_guid_request(
    guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the Entity definition for the given GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "relationshipAttributeDefs": [
                    {
                        "isLegacyAttribute": "bool (optional)",
                        "relationshipTypeName": "str (optional)"
                    }
                ],
                "subTypes": [
                    "str (optional)"
                ],
                "superTypes": [
                    "str (optional)"
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/entitydef/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_entity_definition_by_name_request(
    name: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the entity definition by its name (unique).

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param name: The name of the entity.
    :type name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "relationshipAttributeDefs": [
                    {
                        "isLegacyAttribute": "bool (optional)",
                        "relationshipTypeName": "str (optional)"
                    }
                ],
                "subTypes": [
                    "str (optional)"
                ],
                "superTypes": [
                    "str (optional)"
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/entitydef/name/{name}')
    path_format_arguments = {
        'name': _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_enum_def_by_guid_request(
    guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the enum definition for the given GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the enum.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "defaultValue": "str (optional)",
                "elementDefs": [
                    {
                        "description": "str (optional)",
                        "ordinal": "float (optional)",
                        "value": "str (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/enumdef/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_enum_def_by_name_request(
    name: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the enum definition by its name (unique).

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param name: The name of the enum.
    :type name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "defaultValue": "str (optional)",
                "elementDefs": [
                    {
                        "description": "str (optional)",
                        "ordinal": "float (optional)",
                        "value": "str (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/enumdef/name/{name}')
    path_format_arguments = {
        'name': _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_relationship_def_by_guid_request(
    guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the relationship definition for the given GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the relationship.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "endDef1": {
                    "cardinality": "str (optional)",
                    "description": "str (optional)",
                    "isContainer": "bool (optional)",
                    "isLegacyAttribute": "bool (optional)",
                    "name": "str (optional)",
                    "type": "str (optional)"
                },
                "endDef2": {
                    "cardinality": "str (optional)",
                    "description": "str (optional)",
                    "isContainer": "bool (optional)",
                    "isLegacyAttribute": "bool (optional)",
                    "name": "str (optional)",
                    "type": "str (optional)"
                },
                "relationshipCategory": "str (optional)",
                "relationshipLabel": "str (optional)"
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/relationshipdef/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_relationship_def_by_name_request(
    name: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the relationship definition by its name (unique).

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param name: The name of the relationship.
    :type name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "endDef1": {
                    "cardinality": "str (optional)",
                    "description": "str (optional)",
                    "isContainer": "bool (optional)",
                    "isLegacyAttribute": "bool (optional)",
                    "name": "str (optional)",
                    "type": "str (optional)"
                },
                "endDef2": {
                    "cardinality": "str (optional)",
                    "description": "str (optional)",
                    "isContainer": "bool (optional)",
                    "isLegacyAttribute": "bool (optional)",
                    "name": "str (optional)",
                    "type": "str (optional)"
                },
                "relationshipCategory": "str (optional)",
                "relationshipLabel": "str (optional)"
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/relationshipdef/name/{name}')
    path_format_arguments = {
        'name': _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_struct_def_by_guid_request(
    guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the struct definition for the given GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the struct.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "attributeDefs": [
                    {
                        "cardinality": "str (optional)",
                        "constraints": [
                            {
                                "params": {
                                    "str": "object (optional)"
                                },
                                "type": "str (optional)"
                            }
                        ],
                        "defaultValue": "str (optional)",
                        "description": "str (optional)",
                        "includeInNotification": "bool (optional)",
                        "isIndexable": "bool (optional)",
                        "isOptional": "bool (optional)",
                        "isUnique": "bool (optional)",
                        "name": "str (optional)",
                        "options": {
                            "str": "str (optional)"
                        },
                        "typeName": "str (optional)",
                        "valuesMaxCount": "int (optional)",
                        "valuesMinCount": "int (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/structdef/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_struct_def_by_name_request(
    name: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the struct definition by its name (unique).

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param name: The name of the struct.
    :type name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "attributeDefs": [
                    {
                        "cardinality": "str (optional)",
                        "constraints": [
                            {
                                "params": {
                                    "str": "object (optional)"
                                },
                                "type": "str (optional)"
                            }
                        ],
                        "defaultValue": "str (optional)",
                        "description": "str (optional)",
                        "includeInNotification": "bool (optional)",
                        "isIndexable": "bool (optional)",
                        "isOptional": "bool (optional)",
                        "isUnique": "bool (optional)",
                        "name": "str (optional)",
                        "options": {
                            "str": "str (optional)"
                        },
                        "typeName": "str (optional)",
                        "valuesMaxCount": "int (optional)",
                        "valuesMinCount": "int (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/structdef/name/{name}')
    path_format_arguments = {
        'name': _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_type_definition_by_guid_request(
    guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the type definition for the given GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the type.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {}

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedef/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_type_definition_by_name_request(
    name: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the type definition by its name (unique).

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param name: The name of the type.
    :type name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {}

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedef/name/{name}')
    path_format_arguments = {
        'name': _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_delete_type_by_name_request(
    name: str,
    **kwargs: Any
) -> HttpRequest:
    """Delete API for type identified by its name.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param name: The name of the type.
    :type name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest
    """

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedef/name/{name}')
    path_format_arguments = {
        'name': _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    return HttpRequest(
        method="DELETE",
        url=url,
        **kwargs
    )


def build_get_all_type_definitions_request(
    *,
    include_term_template: Optional[bool] = False,
    type: Optional[Union[str, "_models.Type"]] = None,
    **kwargs: Any
) -> HttpRequest:
    """Get all type definitions in Atlas in bulk.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword include_term_template: Whether include termtemplatedef when return all typedefs.
     This is always true when search filter type=term_template.
    :paramtype include_term_template: bool
    :keyword type: Typedef name as search filter when get typedefs.
    :paramtype type: str or ~azure.purview.catalog.models.Type
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "classificationDefs": [
                    {
                        "entityTypes": [
                            "str (optional)"
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "entityDefs": [
                    {
                        "relationshipAttributeDefs": [
                            {
                                "isLegacyAttribute": "bool (optional)",
                                "relationshipTypeName": "str (optional)"
                            }
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "enumDefs": [
                    {
                        "defaultValue": "str (optional)",
                        "elementDefs": [
                            {
                                "description": "str (optional)",
                                "ordinal": "float (optional)",
                                "value": "str (optional)"
                            }
                        ]
                    }
                ],
                "relationshipDefs": [
                    {
                        "endDef1": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "endDef2": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "relationshipCategory": "str (optional)",
                        "relationshipLabel": "str (optional)"
                    }
                ],
                "structDefs": [
                    {
                        "attributeDefs": [
                            {
                                "cardinality": "str (optional)",
                                "constraints": [
                                    {
                                        "params": {
                                            "str": "object (optional)"
                                        },
                                        "type": "str (optional)"
                                    }
                                ],
                                "defaultValue": "str (optional)",
                                "description": "str (optional)",
                                "includeInNotification": "bool (optional)",
                                "isIndexable": "bool (optional)",
                                "isOptional": "bool (optional)",
                                "isUnique": "bool (optional)",
                                "name": "str (optional)",
                                "options": {
                                    "str": "str (optional)"
                                },
                                "typeName": "str (optional)",
                                "valuesMaxCount": "int (optional)",
                                "valuesMinCount": "int (optional)"
                            }
                        ]
                    }
                ],
                "termTemplateDefs": [
                    {}
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_template is not None:
        query_parameters['includeTermTemplate'] = _SERIALIZER.query("include_term_template", include_term_template, 'bool')
    if type is not None:
        query_parameters['type'] = _SERIALIZER.query("type", type, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_type_definitions_request(
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Create all atlas type definitions in bulk, only new definitions will be created.
    Any changes to the existing definitions will be discarded.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: A composite wrapper object with corresponding lists of the type definition.
    :paramtype json: Any
    :keyword content: A composite wrapper object with corresponding lists of the type definition.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "classificationDefs": [
                    {
                        "entityTypes": [
                            "str (optional)"
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "entityDefs": [
                    {
                        "relationshipAttributeDefs": [
                            {
                                "isLegacyAttribute": "bool (optional)",
                                "relationshipTypeName": "str (optional)"
                            }
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "enumDefs": [
                    {
                        "defaultValue": "str (optional)",
                        "elementDefs": [
                            {
                                "description": "str (optional)",
                                "ordinal": "float (optional)",
                                "value": "str (optional)"
                            }
                        ]
                    }
                ],
                "relationshipDefs": [
                    {
                        "endDef1": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "endDef2": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "relationshipCategory": "str (optional)",
                        "relationshipLabel": "str (optional)"
                    }
                ],
                "structDefs": [
                    {
                        "attributeDefs": [
                            {
                                "cardinality": "str (optional)",
                                "constraints": [
                                    {
                                        "params": {
                                            "str": "object (optional)"
                                        },
                                        "type": "str (optional)"
                                    }
                                ],
                                "defaultValue": "str (optional)",
                                "description": "str (optional)",
                                "includeInNotification": "bool (optional)",
                                "isIndexable": "bool (optional)",
                                "isOptional": "bool (optional)",
                                "isUnique": "bool (optional)",
                                "name": "str (optional)",
                                "options": {
                                    "str": "str (optional)"
                                },
                                "typeName": "str (optional)",
                                "valuesMaxCount": "int (optional)",
                                "valuesMinCount": "int (optional)"
                            }
                        ]
                    }
                ],
                "termTemplateDefs": [
                    {}
                ]
            }


            # response body for status code(s): 200
            response_body == {
                "classificationDefs": [
                    {
                        "entityTypes": [
                            "str (optional)"
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "entityDefs": [
                    {
                        "relationshipAttributeDefs": [
                            {
                                "isLegacyAttribute": "bool (optional)",
                                "relationshipTypeName": "str (optional)"
                            }
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "enumDefs": [
                    {
                        "defaultValue": "str (optional)",
                        "elementDefs": [
                            {
                                "description": "str (optional)",
                                "ordinal": "float (optional)",
                                "value": "str (optional)"
                            }
                        ]
                    }
                ],
                "relationshipDefs": [
                    {
                        "endDef1": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "endDef2": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "relationshipCategory": "str (optional)",
                        "relationshipLabel": "str (optional)"
                    }
                ],
                "structDefs": [
                    {
                        "attributeDefs": [
                            {
                                "cardinality": "str (optional)",
                                "constraints": [
                                    {
                                        "params": {
                                            "str": "object (optional)"
                                        },
                                        "type": "str (optional)"
                                    }
                                ],
                                "defaultValue": "str (optional)",
                                "description": "str (optional)",
                                "includeInNotification": "bool (optional)",
                                "isIndexable": "bool (optional)",
                                "isOptional": "bool (optional)",
                                "isUnique": "bool (optional)",
                                "name": "str (optional)",
                                "options": {
                                    "str": "str (optional)"
                                },
                                "typeName": "str (optional)",
                                "valuesMaxCount": "int (optional)",
                                "valuesMinCount": "int (optional)"
                            }
                        ]
                    }
                ],
                "termTemplateDefs": [
                    {}
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_update_atlas_type_definitions_request(
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Update all types in bulk, changes detected in the type definitions would be persisted.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: A composite object that captures all type definition changes.
    :paramtype json: Any
    :keyword content: A composite object that captures all type definition changes.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "classificationDefs": [
                    {
                        "entityTypes": [
                            "str (optional)"
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "entityDefs": [
                    {
                        "relationshipAttributeDefs": [
                            {
                                "isLegacyAttribute": "bool (optional)",
                                "relationshipTypeName": "str (optional)"
                            }
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "enumDefs": [
                    {
                        "defaultValue": "str (optional)",
                        "elementDefs": [
                            {
                                "description": "str (optional)",
                                "ordinal": "float (optional)",
                                "value": "str (optional)"
                            }
                        ]
                    }
                ],
                "relationshipDefs": [
                    {
                        "endDef1": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "endDef2": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "relationshipCategory": "str (optional)",
                        "relationshipLabel": "str (optional)"
                    }
                ],
                "structDefs": [
                    {
                        "attributeDefs": [
                            {
                                "cardinality": "str (optional)",
                                "constraints": [
                                    {
                                        "params": {
                                            "str": "object (optional)"
                                        },
                                        "type": "str (optional)"
                                    }
                                ],
                                "defaultValue": "str (optional)",
                                "description": "str (optional)",
                                "includeInNotification": "bool (optional)",
                                "isIndexable": "bool (optional)",
                                "isOptional": "bool (optional)",
                                "isUnique": "bool (optional)",
                                "name": "str (optional)",
                                "options": {
                                    "str": "str (optional)"
                                },
                                "typeName": "str (optional)",
                                "valuesMaxCount": "int (optional)",
                                "valuesMinCount": "int (optional)"
                            }
                        ]
                    }
                ],
                "termTemplateDefs": [
                    {}
                ]
            }


            # response body for status code(s): 200
            response_body == {
                "classificationDefs": [
                    {
                        "entityTypes": [
                            "str (optional)"
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "entityDefs": [
                    {
                        "relationshipAttributeDefs": [
                            {
                                "isLegacyAttribute": "bool (optional)",
                                "relationshipTypeName": "str (optional)"
                            }
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "enumDefs": [
                    {
                        "defaultValue": "str (optional)",
                        "elementDefs": [
                            {
                                "description": "str (optional)",
                                "ordinal": "float (optional)",
                                "value": "str (optional)"
                            }
                        ]
                    }
                ],
                "relationshipDefs": [
                    {
                        "endDef1": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "endDef2": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "relationshipCategory": "str (optional)",
                        "relationshipLabel": "str (optional)"
                    }
                ],
                "structDefs": [
                    {
                        "attributeDefs": [
                            {
                                "cardinality": "str (optional)",
                                "constraints": [
                                    {
                                        "params": {
                                            "str": "object (optional)"
                                        },
                                        "type": "str (optional)"
                                    }
                                ],
                                "defaultValue": "str (optional)",
                                "description": "str (optional)",
                                "includeInNotification": "bool (optional)",
                                "isIndexable": "bool (optional)",
                                "isOptional": "bool (optional)",
                                "isUnique": "bool (optional)",
                                "name": "str (optional)",
                                "options": {
                                    "str": "str (optional)"
                                },
                                "typeName": "str (optional)",
                                "valuesMaxCount": "int (optional)",
                                "valuesMinCount": "int (optional)"
                            }
                        ]
                    }
                ],
                "termTemplateDefs": [
                    {}
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_delete_type_definitions_request(
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Delete API for all types in bulk.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: A composite object that captures all types to be deleted.
    :paramtype json: Any
    :keyword content: A composite object that captures all types to be deleted.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "classificationDefs": [
                    {
                        "entityTypes": [
                            "str (optional)"
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "entityDefs": [
                    {
                        "relationshipAttributeDefs": [
                            {
                                "isLegacyAttribute": "bool (optional)",
                                "relationshipTypeName": "str (optional)"
                            }
                        ],
                        "subTypes": [
                            "str (optional)"
                        ],
                        "superTypes": [
                            "str (optional)"
                        ]
                    }
                ],
                "enumDefs": [
                    {
                        "defaultValue": "str (optional)",
                        "elementDefs": [
                            {
                                "description": "str (optional)",
                                "ordinal": "float (optional)",
                                "value": "str (optional)"
                            }
                        ]
                    }
                ],
                "relationshipDefs": [
                    {
                        "endDef1": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "endDef2": {
                            "cardinality": "str (optional)",
                            "description": "str (optional)",
                            "isContainer": "bool (optional)",
                            "isLegacyAttribute": "bool (optional)",
                            "name": "str (optional)",
                            "type": "str (optional)"
                        },
                        "relationshipCategory": "str (optional)",
                        "relationshipLabel": "str (optional)"
                    }
                ],
                "structDefs": [
                    {
                        "attributeDefs": [
                            {
                                "cardinality": "str (optional)",
                                "constraints": [
                                    {
                                        "params": {
                                            "str": "object (optional)"
                                        },
                                        "type": "str (optional)"
                                    }
                                ],
                                "defaultValue": "str (optional)",
                                "description": "str (optional)",
                                "includeInNotification": "bool (optional)",
                                "isIndexable": "bool (optional)",
                                "isOptional": "bool (optional)",
                                "isUnique": "bool (optional)",
                                "name": "str (optional)",
                                "options": {
                                    "str": "str (optional)"
                                },
                                "typeName": "str (optional)",
                                "valuesMaxCount": "int (optional)",
                                "valuesMinCount": "int (optional)"
                            }
                        ]
                    }
                ],
                "termTemplateDefs": [
                    {}
                ]
            }
    """
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_list_type_definition_headers_request(
    *,
    include_term_template: Optional[bool] = False,
    type: Optional[Union[str, "_models.Type"]] = None,
    **kwargs: Any
) -> HttpRequest:
    """List all type definitions returned as a list of minimal information header.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword include_term_template: Whether include termtemplatedef when return all typedefs.
     This is always true when search filter type=term_template.
    :paramtype include_term_template: bool
    :keyword type: Typedef name as search filter when get typedefs.
    :paramtype type: str or ~azure.purview.catalog.models.Type
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "category": "str (optional)",
                    "guid": "str (optional)",
                    "name": "str (optional)"
                }
            ]

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/types/typedefs/headers')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_template is not None:
        query_parameters['includeTermTemplate'] = _SERIALIZER.query("include_term_template", include_term_template, 'bool')
    if type is not None:
        query_parameters['type'] = _SERIALIZER.query("type", type, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_term_template_def_by_guid_request(
    guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the term template definition for the given GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the term template.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {}

    """
    api_version = "2021-05-01-preview"
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/types/termtemplatedef/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_term_template_def_by_name_request(
    name: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the term template definition by its name (unique).

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param name: The name of the term template.
    :type name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {}

    """
    api_version = "2021-05-01-preview"
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/types/termtemplatedef/name/{name}')
    path_format_arguments = {
        'name': _SERIALIZER.url("name", name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

