# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.pipeline.transport._base import _format_url_section
from azure.purview.catalog.core.rest import HttpRequest
from msrest import Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any

_SERIALIZER = Serializer()


def build_list_glossaries_request(
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get all glossaries registered with Atlas.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "categories": [
                        {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "parentCategoryGuid": "str (optional)",
                            "relationGuid": "str (optional)"
                        }
                    ],
                    "language": "str (optional)",
                    "terms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "usage": "str (optional)"
                }
            ]

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_glossary_request(
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Create a glossary.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: Glossary definition, terms & categories can be anchored to a glossary.
     Using the anchor attribute when creating the Term/Category.
    :paramtype json: Any
    :keyword content: Glossary definition, terms & categories can be anchored to a glossary.
     Using the anchor attribute when creating the Term/Category.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "language": "str (optional)",
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "usage": "str (optional)"
            }


            # response body for status code(s): 200
            response_body == {
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "language": "str (optional)",
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "usage": "str (optional)"
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_create_glossary_categories_request(
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Create glossary category in bulk.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: An array of glossary category definitions to be created.
    :paramtype json: Any
    :keyword content: An array of glossary category definitions to be created.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "anchor": {
                        "displayText": "str (optional)",
                        "glossaryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "parentCategoryGuid": "str (optional)",
                            "relationGuid": "str (optional)"
                        }
                    ],
                    "parentCategory": {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "terms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ]
                }
            ]


            # response body for status code(s): 200
            response_body == [
                {
                    "anchor": {
                        "displayText": "str (optional)",
                        "glossaryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "parentCategoryGuid": "str (optional)",
                            "relationGuid": "str (optional)"
                        }
                    ],
                    "parentCategory": {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "terms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ]
                }
            ]

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/categories')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_create_glossary_category_request(
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Create a glossary category.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: The glossary category definition. A category must be anchored to a Glossary when
     creating.
     Optionally, terms belonging to the category and the hierarchy can also be defined during
     creation.
    :paramtype json: Any
    :keyword content: The glossary category definition. A category must be anchored to a Glossary
     when creating.
     Optionally, terms belonging to the category and the hierarchy can also be defined during
     creation.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "childrenCategories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "parentCategory": {
                    "categoryGuid": "str (optional)",
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "parentCategoryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }


            # response body for status code(s): 200
            response_body == {
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "childrenCategories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "parentCategory": {
                    "categoryGuid": "str (optional)",
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "parentCategoryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_get_glossary_category_request(
    category_guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get specific glossary category by its GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param category_guid: The globally unique identifier of the category.
    :type category_guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "childrenCategories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "parentCategory": {
                    "categoryGuid": "str (optional)",
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "parentCategoryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}')
    path_format_arguments = {
        'categoryGuid': _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_update_glossary_category_request(
    category_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Update the given glossary category by its GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param category_guid: The globally unique identifier of the category.
    :type category_guid: str
    :keyword json: The glossary category to be updated.
    :paramtype json: Any
    :keyword content: The glossary category to be updated.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "childrenCategories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "parentCategory": {
                    "categoryGuid": "str (optional)",
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "parentCategoryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }


            # response body for status code(s): 200
            response_body == {
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "childrenCategories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "parentCategory": {
                    "categoryGuid": "str (optional)",
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "parentCategoryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}')
    path_format_arguments = {
        'categoryGuid': _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_delete_glossary_category_request(
    category_guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Delete a glossary category.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param category_guid: The globally unique identifier of the category.
    :type category_guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest
    """

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}')
    path_format_arguments = {
        'categoryGuid': _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    return HttpRequest(
        method="DELETE",
        url=url,
        **kwargs
    )


def build_partial_update_glossary_category_request(
    category_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Update the glossary category partially.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param category_guid: The globally unique identifier of the category.
    :type category_guid: str
    :keyword json: A map containing keys as attribute names and values as corresponding attribute
     values for partial update.
    :paramtype json: Any
    :keyword content: A map containing keys as attribute names and values as corresponding
     attribute values for partial update.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "str": "str (optional)"
            }


            # response body for status code(s): 200
            response_body == {
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "childrenCategories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "parentCategory": {
                    "categoryGuid": "str (optional)",
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "parentCategoryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}/partial')
    path_format_arguments = {
        'categoryGuid': _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_list_related_categories_request(
    category_guid: str,
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get all related categories (parent and children). Limit, offset, and sort parameters are
    currently not being enabled and won't work even they are passed.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param category_guid: The globally unique identifier of the category.
    :type category_guid: str
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "str": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}/related')
    path_format_arguments = {
        'categoryGuid': _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_list_category_terms_request(
    category_guid: str,
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get all terms associated with the specific category.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param category_guid: The globally unique identifier of the category.
    :type category_guid: str
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "expression": "str (optional)",
                    "relationGuid": "str (optional)",
                    "source": "str (optional)",
                    "status": "str (optional)",
                    "steward": "str (optional)",
                    "termGuid": "str (optional)"
                }
            ]

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/category/{categoryGuid}/terms')
    path_format_arguments = {
        'categoryGuid': _SERIALIZER.url("category_guid", category_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_glossary_term_request(
    *,
    json: Any = None,
    content: Any = None,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Create a glossary term.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: The glossary term definition. A term must be anchored to a Glossary at the time
     of creation.
     Optionally it can be categorized as well.
    :paramtype json: Any
    :keyword content: The glossary term definition. A term must be anchored to a Glossary at the
     time of creation.
     Optionally it can be categorized as well.
    :paramtype content: Any
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "abbreviation": "str (optional)",
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "antonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "assignedEntities": [
                    {
                        "displayText": "str (optional)",
                        "entityStatus": "str (optional)",
                        "relationshipAttributes": {
                            "attributes": {
                                "str": "object (optional)"
                            },
                            "lastModifiedTS": "str (optional)",
                            "typeName": "str (optional)"
                        },
                        "relationshipGuid": "str (optional)",
                        "relationshipStatus": "str (optional)",
                        "relationshipType": "str (optional)"
                    }
                ],
                "attributes": {
                    "str": {
                        "str": "object (optional)"
                    }
                },
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "relationGuid": "str (optional)",
                        "status": "str (optional)"
                    }
                ],
                "classifies": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "contacts": {
                    "str": [
                        {
                            "id": "str (optional)",
                            "info": "str (optional)"
                        }
                    ]
                },
                "createTime": "float (optional)",
                "createdBy": "str (optional)",
                "examples": [
                    "str (optional)"
                ],
                "isA": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredToTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacedBy": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacementTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "resources": [
                    {
                        "displayName": "str (optional)",
                        "url": "str (optional)"
                    }
                ],
                "seeAlso": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "status": "str (optional)",
                "synonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "templateName": [
                    "object (optional)"
                ],
                "translatedTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "translationTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "updateTime": "float (optional)",
                "updatedBy": "str (optional)",
                "usage": "str (optional)",
                "validValues": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "validValuesFor": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }


            # response body for status code(s): 200
            response_body == {
                "abbreviation": "str (optional)",
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "antonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "assignedEntities": [
                    {
                        "displayText": "str (optional)",
                        "entityStatus": "str (optional)",
                        "relationshipAttributes": {
                            "attributes": {
                                "str": "object (optional)"
                            },
                            "lastModifiedTS": "str (optional)",
                            "typeName": "str (optional)"
                        },
                        "relationshipGuid": "str (optional)",
                        "relationshipStatus": "str (optional)",
                        "relationshipType": "str (optional)"
                    }
                ],
                "attributes": {
                    "str": {
                        "str": "object (optional)"
                    }
                },
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "relationGuid": "str (optional)",
                        "status": "str (optional)"
                    }
                ],
                "classifies": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "contacts": {
                    "str": [
                        {
                            "id": "str (optional)",
                            "info": "str (optional)"
                        }
                    ]
                },
                "createTime": "float (optional)",
                "createdBy": "str (optional)",
                "examples": [
                    "str (optional)"
                ],
                "isA": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredToTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacedBy": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacementTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "resources": [
                    {
                        "displayName": "str (optional)",
                        "url": "str (optional)"
                    }
                ],
                "seeAlso": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "status": "str (optional)",
                "synonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "templateName": [
                    "object (optional)"
                ],
                "translatedTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "translationTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "updateTime": "float (optional)",
                "updatedBy": "str (optional)",
                "usage": "str (optional)",
                "validValues": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "validValuesFor": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_get_glossary_term_request(
    term_guid: str,
    *,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Get a specific glossary term by its GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "abbreviation": "str (optional)",
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "antonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "assignedEntities": [
                    {
                        "displayText": "str (optional)",
                        "entityStatus": "str (optional)",
                        "relationshipAttributes": {
                            "attributes": {
                                "str": "object (optional)"
                            },
                            "lastModifiedTS": "str (optional)",
                            "typeName": "str (optional)"
                        },
                        "relationshipGuid": "str (optional)",
                        "relationshipStatus": "str (optional)",
                        "relationshipType": "str (optional)"
                    }
                ],
                "attributes": {
                    "str": {
                        "str": "object (optional)"
                    }
                },
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "relationGuid": "str (optional)",
                        "status": "str (optional)"
                    }
                ],
                "classifies": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "contacts": {
                    "str": [
                        {
                            "id": "str (optional)",
                            "info": "str (optional)"
                        }
                    ]
                },
                "createTime": "float (optional)",
                "createdBy": "str (optional)",
                "examples": [
                    "str (optional)"
                ],
                "isA": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredToTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacedBy": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacementTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "resources": [
                    {
                        "displayName": "str (optional)",
                        "url": "str (optional)"
                    }
                ],
                "seeAlso": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "status": "str (optional)",
                "synonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "templateName": [
                    "object (optional)"
                ],
                "translatedTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "translationTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "updateTime": "float (optional)",
                "updatedBy": "str (optional)",
                "usage": "str (optional)",
                "validValues": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "validValuesFor": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term/{termGuid}')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_update_glossary_term_request(
    term_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Update the given glossary term by its GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :keyword json: The glossary term to be updated.
    :paramtype json: Any
    :keyword content: The glossary term to be updated.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "abbreviation": "str (optional)",
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "antonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "assignedEntities": [
                    {
                        "displayText": "str (optional)",
                        "entityStatus": "str (optional)",
                        "relationshipAttributes": {
                            "attributes": {
                                "str": "object (optional)"
                            },
                            "lastModifiedTS": "str (optional)",
                            "typeName": "str (optional)"
                        },
                        "relationshipGuid": "str (optional)",
                        "relationshipStatus": "str (optional)",
                        "relationshipType": "str (optional)"
                    }
                ],
                "attributes": {
                    "str": {
                        "str": "object (optional)"
                    }
                },
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "relationGuid": "str (optional)",
                        "status": "str (optional)"
                    }
                ],
                "classifies": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "contacts": {
                    "str": [
                        {
                            "id": "str (optional)",
                            "info": "str (optional)"
                        }
                    ]
                },
                "createTime": "float (optional)",
                "createdBy": "str (optional)",
                "examples": [
                    "str (optional)"
                ],
                "isA": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredToTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacedBy": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacementTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "resources": [
                    {
                        "displayName": "str (optional)",
                        "url": "str (optional)"
                    }
                ],
                "seeAlso": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "status": "str (optional)",
                "synonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "templateName": [
                    "object (optional)"
                ],
                "translatedTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "translationTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "updateTime": "float (optional)",
                "updatedBy": "str (optional)",
                "usage": "str (optional)",
                "validValues": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "validValuesFor": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }


            # response body for status code(s): 200
            response_body == {
                "abbreviation": "str (optional)",
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "antonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "assignedEntities": [
                    {
                        "displayText": "str (optional)",
                        "entityStatus": "str (optional)",
                        "relationshipAttributes": {
                            "attributes": {
                                "str": "object (optional)"
                            },
                            "lastModifiedTS": "str (optional)",
                            "typeName": "str (optional)"
                        },
                        "relationshipGuid": "str (optional)",
                        "relationshipStatus": "str (optional)",
                        "relationshipType": "str (optional)"
                    }
                ],
                "attributes": {
                    "str": {
                        "str": "object (optional)"
                    }
                },
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "relationGuid": "str (optional)",
                        "status": "str (optional)"
                    }
                ],
                "classifies": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "contacts": {
                    "str": [
                        {
                            "id": "str (optional)",
                            "info": "str (optional)"
                        }
                    ]
                },
                "createTime": "float (optional)",
                "createdBy": "str (optional)",
                "examples": [
                    "str (optional)"
                ],
                "isA": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredToTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacedBy": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacementTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "resources": [
                    {
                        "displayName": "str (optional)",
                        "url": "str (optional)"
                    }
                ],
                "seeAlso": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "status": "str (optional)",
                "synonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "templateName": [
                    "object (optional)"
                ],
                "translatedTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "translationTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "updateTime": "float (optional)",
                "updatedBy": "str (optional)",
                "usage": "str (optional)",
                "validValues": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "validValuesFor": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term/{termGuid}')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_delete_glossary_term_request(
    term_guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Delete a glossary term.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest
    """

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term/{termGuid}')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    return HttpRequest(
        method="DELETE",
        url=url,
        **kwargs
    )


def build_partial_update_glossary_term_request(
    term_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Update the glossary term partially.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :keyword json: A map containing keys as attribute names and values as corresponding attribute
     values to be updated.
    :paramtype json: Any
    :keyword content: A map containing keys as attribute names and values as corresponding
     attribute values to be updated.
    :paramtype content: Any
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "str": "str (optional)"
            }


            # response body for status code(s): 200
            response_body == {
                "abbreviation": "str (optional)",
                "anchor": {
                    "displayText": "str (optional)",
                    "glossaryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                },
                "antonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "assignedEntities": [
                    {
                        "displayText": "str (optional)",
                        "entityStatus": "str (optional)",
                        "relationshipAttributes": {
                            "attributes": {
                                "str": "object (optional)"
                            },
                            "lastModifiedTS": "str (optional)",
                            "typeName": "str (optional)"
                        },
                        "relationshipGuid": "str (optional)",
                        "relationshipStatus": "str (optional)",
                        "relationshipType": "str (optional)"
                    }
                ],
                "attributes": {
                    "str": {
                        "str": "object (optional)"
                    }
                },
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "relationGuid": "str (optional)",
                        "status": "str (optional)"
                    }
                ],
                "classifies": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "contacts": {
                    "str": [
                        {
                            "id": "str (optional)",
                            "info": "str (optional)"
                        }
                    ]
                },
                "createTime": "float (optional)",
                "createdBy": "str (optional)",
                "examples": [
                    "str (optional)"
                ],
                "isA": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "preferredToTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacedBy": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "replacementTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "resources": [
                    {
                        "displayName": "str (optional)",
                        "url": "str (optional)"
                    }
                ],
                "seeAlso": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "status": "str (optional)",
                "synonyms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "templateName": [
                    "object (optional)"
                ],
                "translatedTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "translationTerms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "updateTime": "float (optional)",
                "updatedBy": "str (optional)",
                "usage": "str (optional)",
                "validValues": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "validValuesFor": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/term/{termGuid}/partial')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_create_glossary_terms_request(
    *,
    json: Any = None,
    content: Any = None,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Create glossary terms in bulk.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: An array of glossary term definitions to be created in bulk.
    :paramtype json: Any
    :keyword content: An array of glossary term definitions to be created in bulk.
    :paramtype content: Any
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "abbreviation": "str (optional)",
                    "anchor": {
                        "displayText": "str (optional)",
                        "glossaryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "antonyms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str (optional)",
                            "entityStatus": "str (optional)",
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": "object (optional)"
                                },
                                "lastModifiedTS": "str (optional)",
                                "typeName": "str (optional)"
                            },
                            "relationshipGuid": "str (optional)",
                            "relationshipStatus": "str (optional)",
                            "relationshipType": "str (optional)"
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": "object (optional)"
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "relationGuid": "str (optional)",
                            "status": "str (optional)"
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str (optional)",
                                "info": "str (optional)"
                            }
                        ]
                    },
                    "createTime": "float (optional)",
                    "createdBy": "str (optional)",
                    "examples": [
                        "str (optional)"
                    ],
                    "isA": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "preferredTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "replacedBy": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str (optional)",
                            "url": "str (optional)"
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "status": "str (optional)",
                    "synonyms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "templateName": [
                        "object (optional)"
                    ],
                    "translatedTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "updateTime": "float (optional)",
                    "updatedBy": "str (optional)",
                    "usage": "str (optional)",
                    "validValues": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ]
                }
            ]


            # response body for status code(s): 200
            response_body == [
                {
                    "abbreviation": "str (optional)",
                    "anchor": {
                        "displayText": "str (optional)",
                        "glossaryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "antonyms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str (optional)",
                            "entityStatus": "str (optional)",
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": "object (optional)"
                                },
                                "lastModifiedTS": "str (optional)",
                                "typeName": "str (optional)"
                            },
                            "relationshipGuid": "str (optional)",
                            "relationshipStatus": "str (optional)",
                            "relationshipType": "str (optional)"
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": "object (optional)"
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "relationGuid": "str (optional)",
                            "status": "str (optional)"
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str (optional)",
                                "info": "str (optional)"
                            }
                        ]
                    },
                    "createTime": "float (optional)",
                    "createdBy": "str (optional)",
                    "examples": [
                        "str (optional)"
                    ],
                    "isA": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "preferredTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "replacedBy": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str (optional)",
                            "url": "str (optional)"
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "status": "str (optional)",
                    "synonyms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "templateName": [
                        "object (optional)"
                    ],
                    "translatedTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "updateTime": "float (optional)",
                    "updatedBy": "str (optional)",
                    "usage": "str (optional)",
                    "validValues": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ]
                }
            ]

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_get_entities_assigned_with_term_request(
    term_guid: str,
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get all related objects assigned with the specified term.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "displayText": "str (optional)",
                    "entityStatus": "str (optional)",
                    "relationshipAttributes": {
                        "attributes": {
                            "str": "object (optional)"
                        },
                        "lastModifiedTS": "str (optional)",
                        "typeName": "str (optional)"
                    },
                    "relationshipGuid": "str (optional)",
                    "relationshipStatus": "str (optional)",
                    "relationshipType": "str (optional)"
                }
            ]

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/assignedEntities')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_assign_term_to_entities_request(
    term_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Assign the given term to the provided list of related objects.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :keyword json: An array of related object IDs to which the term has to be associated.
    :paramtype json: Any
    :keyword content: An array of related object IDs to which the term has to be associated.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "displayText": "str (optional)",
                    "entityStatus": "str (optional)",
                    "relationshipAttributes": {
                        "attributes": {
                            "str": "object (optional)"
                        },
                        "lastModifiedTS": "str (optional)",
                        "typeName": "str (optional)"
                    },
                    "relationshipGuid": "str (optional)",
                    "relationshipStatus": "str (optional)",
                    "relationshipType": "str (optional)"
                }
            ]
    """
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/assignedEntities')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_remove_term_assignment_from_entities_request(
    term_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Delete the term assignment for the given list of related objects.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :keyword json: An array of related object IDs from which the term has to be dissociated.
    :paramtype json: Any
    :keyword content: An array of related object IDs from which the term has to be dissociated.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "displayText": "str (optional)",
                    "entityStatus": "str (optional)",
                    "relationshipAttributes": {
                        "attributes": {
                            "str": "object (optional)"
                        },
                        "lastModifiedTS": "str (optional)",
                        "typeName": "str (optional)"
                    },
                    "relationshipGuid": "str (optional)",
                    "relationshipStatus": "str (optional)",
                    "relationshipType": "str (optional)"
                }
            ]
    """
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/assignedEntities')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_delete_term_assignment_from_entities_request(
    term_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Delete the term assignment for the given list of related objects.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :keyword json: An array of related object IDs from which the term has to be dissociated.
    :paramtype json: Any
    :keyword content: An array of related object IDs from which the term has to be dissociated.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "displayText": "str (optional)",
                    "entityStatus": "str (optional)",
                    "relationshipAttributes": {
                        "attributes": {
                            "str": "object (optional)"
                        },
                        "lastModifiedTS": "str (optional)",
                        "typeName": "str (optional)"
                    },
                    "relationshipGuid": "str (optional)",
                    "relationshipStatus": "str (optional)",
                    "relationshipType": "str (optional)"
                }
            ]
    """
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/assignedEntities')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_list_related_terms_request(
    term_guid: str,
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get all related terms for a specific term by its GUID. Limit, offset, and sort parameters are
    currently not being enabled and won't work even they are passed.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param term_guid: The globally unique identifier for glossary term.
    :type term_guid: str
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "str": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/terms/{termGuid}/related')
    path_format_arguments = {
        'termGuid': _SERIALIZER.url("term_guid", term_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_glossary_request(
    glossary_guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get a specific Glossary by its GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "language": "str (optional)",
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "usage": "str (optional)"
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_update_glossary_request(
    glossary_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    """Update the given glossary.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword json: The glossary definition to be updated.
    :paramtype json: Any
    :keyword content: The glossary definition to be updated.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "language": "str (optional)",
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "usage": "str (optional)"
            }


            # response body for status code(s): 200
            response_body == {
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "language": "str (optional)",
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "usage": "str (optional)"
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_delete_glossary_request(
    glossary_guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Delete a glossary.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest
    """

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    return HttpRequest(
        method="DELETE",
        url=url,
        **kwargs
    )


def build_list_glossary_categories_request(
    glossary_guid: str,
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get the categories belonging to a specific glossary.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "anchor": {
                        "displayText": "str (optional)",
                        "glossaryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "parentCategoryGuid": "str (optional)",
                            "relationGuid": "str (optional)"
                        }
                    ],
                    "parentCategory": {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "terms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ]
                }
            ]

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/categories')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_list_glossary_categories_headers_request(
    glossary_guid: str,
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get the category headers belonging to a specific glossary.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "categoryGuid": "str (optional)",
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "parentCategoryGuid": "str (optional)",
                    "relationGuid": "str (optional)"
                }
            ]

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/categories/headers')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_detailed_glossary_request(
    glossary_guid: str,
    *,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Get a specific glossary with detailed information.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "categoryInfo": {
                    "str": {
                        "anchor": {
                            "displayText": "str (optional)",
                            "glossaryGuid": "str (optional)",
                            "relationGuid": "str (optional)"
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "parentCategoryGuid": "str (optional)",
                                "relationGuid": "str (optional)"
                            }
                        ],
                        "parentCategory": {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "parentCategoryGuid": "str (optional)",
                            "relationGuid": "str (optional)"
                        },
                        "terms": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ]
                    }
                },
                "termInfo": {
                    "str": {
                        "abbreviation": "str (optional)",
                        "anchor": {
                            "displayText": "str (optional)",
                            "glossaryGuid": "str (optional)",
                            "relationGuid": "str (optional)"
                        },
                        "antonyms": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str (optional)",
                                "entityStatus": "str (optional)",
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": "object (optional)"
                                    },
                                    "lastModifiedTS": "str (optional)",
                                    "typeName": "str (optional)"
                                },
                                "relationshipGuid": "str (optional)",
                                "relationshipStatus": "str (optional)",
                                "relationshipType": "str (optional)"
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": "object (optional)"
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "relationGuid": "str (optional)",
                                "status": "str (optional)"
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str (optional)",
                                    "info": "str (optional)"
                                }
                            ]
                        },
                        "createTime": "float (optional)",
                        "createdBy": "str (optional)",
                        "examples": [
                            "str (optional)"
                        ],
                        "isA": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "preferredTerms": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "replacedBy": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str (optional)",
                                "url": "str (optional)"
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)",
                        "synonyms": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "templateName": [
                            "object (optional)"
                        ],
                        "translatedTerms": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "updateTime": "float (optional)",
                        "updatedBy": "str (optional)",
                        "usage": "str (optional)",
                        "validValues": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ]
                    }
                }
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/detailed')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_partial_update_glossary_request(
    glossary_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Update the glossary partially. Some properties such as qualifiedName are not allowed to be
    updated.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword json: A map containing keys as attribute names and values as corresponding attribute
     values.
    :paramtype json: Any
    :keyword content: A map containing keys as attribute names and values as corresponding
     attribute values.
    :paramtype content: Any
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "str": "str (optional)"
            }


            # response body for status code(s): 200
            response_body == {
                "categories": [
                    {
                        "categoryGuid": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "parentCategoryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    }
                ],
                "language": "str (optional)",
                "terms": [
                    {
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "usage": "str (optional)"
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/partial')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_list_glossary_terms_request(
    glossary_guid: str,
    *,
    include_term_hierarchy: Optional[bool] = False,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get terms belonging to a specific glossary.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "abbreviation": "str (optional)",
                    "anchor": {
                        "displayText": "str (optional)",
                        "glossaryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "antonyms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str (optional)",
                            "entityStatus": "str (optional)",
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": "object (optional)"
                                },
                                "lastModifiedTS": "str (optional)",
                                "typeName": "str (optional)"
                            },
                            "relationshipGuid": "str (optional)",
                            "relationshipStatus": "str (optional)",
                            "relationshipType": "str (optional)"
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": "object (optional)"
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "relationGuid": "str (optional)",
                            "status": "str (optional)"
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str (optional)",
                                "info": "str (optional)"
                            }
                        ]
                    },
                    "createTime": "float (optional)",
                    "createdBy": "str (optional)",
                    "examples": [
                        "str (optional)"
                    ],
                    "isA": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "preferredTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "replacedBy": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str (optional)",
                            "url": "str (optional)"
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "status": "str (optional)",
                    "synonyms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "templateName": [
                        "object (optional)"
                    ],
                    "translatedTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "updateTime": "float (optional)",
                    "updatedBy": "str (optional)",
                    "usage": "str (optional)",
                    "validValues": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ]
                }
            ]

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/terms')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_list_glossary_term_headers_request(
    glossary_guid: str,
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    sort: Optional[str] = "ASC",
    **kwargs: Any
) -> HttpRequest:
    """Get term headers belonging to a specific glossary.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword sort: The sort order, ASC (default) or DESC.
    :paramtype sort: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "description": "str (optional)",
                    "displayText": "str (optional)",
                    "expression": "str (optional)",
                    "relationGuid": "str (optional)",
                    "source": "str (optional)",
                    "status": "str (optional)",
                    "steward": "str (optional)",
                    "termGuid": "str (optional)"
                }
            ]

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/glossary/{glossaryGuid}/terms/headers')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if sort is not None:
        query_parameters['sort'] = _SERIALIZER.query("sort", sort, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_import_glossary_terms_via_csv_request(
    glossary_guid: str,
    *,
    files: Optional[Dict[str, Any]] = None,
    content: Any = None,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Import Glossary Terms from local csv file.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword files: Multipart input for files. See the template in our example to find the input
     shape.
    :paramtype files: dict[str, Any]
    :keyword content: Multipart input for files. See the template in our example to find the input
     shape.
    :paramtype content: Any
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # multipart input template you can fill out and use as your `files` input.
            files = {
                "file": "IO. The csv file to import glossary terms from."
            }


            # response body for status code(s): 202
            response_body == {
                "createTime": "str (optional)",
                "errorCode": "int (optional)",
                "errorMessage": "str (optional)",
                "id": "str (optional)",
                "importedTerms": "str (optional)",
                "lastUpdateTime": "str (optional)",
                "status": "str (optional)",
                "totalTermsDetected": "str (optional)"
            }

    """
    content_type = kwargs.pop("content_type", None)
    api_version = "2021-05-01-preview"
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/glossary/{glossaryGuid}/terms/import')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        files=files,
        content=content,
        **kwargs
    )


def build_import_glossary_terms_via_csv_by_glossary_name_request(
    glossary_name: str,
    *,
    files: Optional[Dict[str, Any]] = None,
    content: Any = None,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Import Glossary Terms from local csv file by glossaryName.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_name: The name of the glossary.
    :type glossary_name: str
    :keyword files: Multipart input for files. See the template in our example to find the input
     shape.
    :paramtype files: dict[str, Any]
    :keyword content: Multipart input for files. See the template in our example to find the input
     shape.
    :paramtype content: Any
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # multipart input template you can fill out and use as your `files` input.
            files = {
                "file": "IO. The csv file to import glossary terms from."
            }


            # response body for status code(s): 202
            response_body == {
                "createTime": "str (optional)",
                "errorCode": "int (optional)",
                "errorMessage": "str (optional)",
                "id": "str (optional)",
                "importedTerms": "str (optional)",
                "lastUpdateTime": "str (optional)",
                "status": "str (optional)",
                "totalTermsDetected": "str (optional)"
            }

    """
    content_type = kwargs.pop("content_type", None)
    api_version = "2021-05-01-preview"
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/glossary/name/{glossaryName}/terms/import')
    path_format_arguments = {
        'glossaryName': _SERIALIZER.url("glossary_name", glossary_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        files=files,
        content=content,
        **kwargs
    )


def build_get_import_csv_operation_status_request(
    operation_guid: str,
    **kwargs: Any
) -> HttpRequest:
    """Get the status of import csv operation.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param operation_guid: The globally unique identifier for async operation/job.
    :type operation_guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "createTime": "str (optional)",
                "errorCode": "int (optional)",
                "errorMessage": "str (optional)",
                "id": "str (optional)",
                "importedTerms": "str (optional)",
                "lastUpdateTime": "str (optional)",
                "status": "str (optional)",
                "totalTermsDetected": "str (optional)"
            }

    """
    api_version = "2021-05-01-preview"
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/glossary/terms/import/{operationGuid}')
    path_format_arguments = {
        'operationGuid': _SERIALIZER.url("operation_guid", operation_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_export_glossary_terms_as_csv_request(
    glossary_guid: str,
    *,
    json: Any = None,
    content: Any = None,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Export Glossary Terms as csv file.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_guid: The globally unique identifier for glossary.
    :type glossary_guid: str
    :keyword json: An array of term guids.
    :paramtype json: Any
    :keyword content: An array of term guids.
    :paramtype content: Any
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                "str (optional)"
            ]
    """
    content_type = kwargs.pop("content_type", None)
    api_version = "2021-05-01-preview"
    accept = "text/csv"

    # Construct URL
    url = kwargs.pop("template_url", '/glossary/{glossaryGuid}/terms/export')
    path_format_arguments = {
        'glossaryGuid': _SERIALIZER.url("glossary_guid", glossary_guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_list_terms_by_glossary_name_request(
    glossary_name: str,
    *,
    limit: Optional[int] = None,
    offset: Optional[int] = None,
    include_term_hierarchy: Optional[bool] = False,
    **kwargs: Any
) -> HttpRequest:
    """Get terms by glossary name.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param glossary_name: The name of the glossary.
    :type glossary_name: str
    :keyword limit: The page size - by default there is no paging.
    :paramtype limit: int
    :keyword offset: The offset for pagination purpose.
    :paramtype offset: int
    :keyword include_term_hierarchy: Whether include term hierarchy.
    :paramtype include_term_hierarchy: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == [
                {
                    "abbreviation": "str (optional)",
                    "anchor": {
                        "displayText": "str (optional)",
                        "glossaryGuid": "str (optional)",
                        "relationGuid": "str (optional)"
                    },
                    "antonyms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str (optional)",
                            "entityStatus": "str (optional)",
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": "object (optional)"
                                },
                                "lastModifiedTS": "str (optional)",
                                "typeName": "str (optional)"
                            },
                            "relationshipGuid": "str (optional)",
                            "relationshipStatus": "str (optional)",
                            "relationshipType": "str (optional)"
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": "object (optional)"
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "relationGuid": "str (optional)",
                            "status": "str (optional)"
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str (optional)",
                                "info": "str (optional)"
                            }
                        ]
                    },
                    "createTime": "float (optional)",
                    "createdBy": "str (optional)",
                    "examples": [
                        "str (optional)"
                    ],
                    "isA": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "preferredTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "replacedBy": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str (optional)",
                            "url": "str (optional)"
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "status": "str (optional)",
                    "synonyms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "templateName": [
                        "object (optional)"
                    ],
                    "translatedTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "updateTime": "float (optional)",
                    "updatedBy": "str (optional)",
                    "usage": "str (optional)",
                    "validValues": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ]
                }
            ]

    """
    api_version = "2021-05-01-preview"
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/glossary/name/{glossaryName}/terms')
    path_format_arguments = {
        'glossaryName': _SERIALIZER.url("glossary_name", glossary_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int')
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int')
    if include_term_hierarchy is not None:
        query_parameters['includeTermHierarchy'] = _SERIALIZER.query("include_term_hierarchy", include_term_hierarchy, 'bool')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

