# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING

from azure.core.pipeline.transport._base import _format_url_section
from azure.purview.catalog.core.rest import HttpRequest
from msrest import Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Dict, List, Optional, Union

_SERIALIZER = Serializer()


def build_create_or_update_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Create or update an entity in Atlas.
    Existing entity is matched using its unique guid if supplied or by its unique attributes eg:
    qualifiedName.
    Map and array of collections are not well supported. E.g., array<array:code:`<int>`>,
    array<map<string, int>>.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: Atlas entity with extended information.
    :paramtype json: Any
    :keyword content: Atlas entity with extended information.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "entity": {
                    "classifications": [
                        {
                            "entityGuid": "str (optional)",
                            "entityStatus": "str (optional)",
                            "removePropagationsOnEntityDelete": "bool (optional)",
                            "source": "str (optional)",
                            "sourceDetails": {
                                "str": "object (optional)"
                            },
                            "validityPeriods": [
                                {
                                    "endTime": "str (optional)",
                                    "startTime": "str (optional)",
                                    "timeZone": "str (optional)"
                                }
                            ]
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str (optional)",
                                "info": "str (optional)"
                            }
                        ]
                    },
                    "createTime": "float (optional)",
                    "createdBy": "str (optional)",
                    "guid": "str (optional)",
                    "homeId": "str (optional)",
                    "meanings": [
                        {
                            "confidence": "int (optional)",
                            "createdBy": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "provenanceType": "float (optional)",
                    "proxy": "bool (optional)",
                    "relationshipAttributes": {
                        "str": "object (optional)"
                    },
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "status": "str (optional)",
                    "updateTime": "float (optional)",
                    "updatedBy": "str (optional)",
                    "version": "float (optional)"
                }
            }


            # response body for status code(s): 200
            response_body == {
                "guidAssignments": {
                    "str": "str (optional)"
                },
                "mutatedEntities": {
                    "str": [
                        {
                            "classificationNames": [
                                "str (optional)"
                            ],
                            "classifications": [
                                {
                                    "entityGuid": "str (optional)",
                                    "entityStatus": "str (optional)",
                                    "removePropagationsOnEntityDelete": "bool (optional)",
                                    "source": "str (optional)",
                                    "sourceDetails": {
                                        "str": "object (optional)"
                                    },
                                    "validityPeriods": [
                                        {
                                            "endTime": "str (optional)",
                                            "startTime": "str (optional)",
                                            "timeZone": "str (optional)"
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str (optional)",
                            "guid": "str (optional)",
                            "meaningNames": [
                                "str (optional)"
                            ],
                            "meanings": [
                                {
                                    "confidence": "int (optional)",
                                    "createdBy": "str (optional)",
                                    "description": "str (optional)",
                                    "displayText": "str (optional)",
                                    "expression": "str (optional)",
                                    "relationGuid": "str (optional)",
                                    "source": "str (optional)",
                                    "status": "str (optional)",
                                    "steward": "str (optional)",
                                    "termGuid": "str (optional)"
                                }
                            ],
                            "status": "str (optional)"
                        }
                    ]
                },
                "partialUpdatedEntities": [
                    {
                        "classificationNames": [
                            "str (optional)"
                        ],
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "displayText": "str (optional)",
                        "guid": "str (optional)",
                        "meaningNames": [
                            "str (optional)"
                        ],
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)"
                    }
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_list_by_guids_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """List entities in bulk identified by its GUIDs.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword guids: An array of GUIDs of entities to create.
    :paramtype guids: list[str]
    :keyword min_ext_info: Whether to return minimal information for referred entities.
    :paramtype min_ext_info: bool
    :keyword ignore_relationships: Whether to ignore relationship attributes.
    :paramtype ignore_relationships: bool
    :keyword exclude_relationship_types: An array of the relationship types need to be excluded
     from the response.
    :paramtype exclude_relationship_types: list[str]
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "entities": [
                    {
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str (optional)",
                                    "info": "str (optional)"
                                }
                            ]
                        },
                        "createTime": "float (optional)",
                        "createdBy": "str (optional)",
                        "guid": "str (optional)",
                        "homeId": "str (optional)",
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "provenanceType": "float (optional)",
                        "proxy": "bool (optional)",
                        "relationshipAttributes": {
                            "str": "object (optional)"
                        },
                        "source": "str (optional)",
                        "sourceDetails": {
                            "str": "object (optional)"
                        },
                        "status": "str (optional)",
                        "updateTime": "float (optional)",
                        "updatedBy": "str (optional)",
                        "version": "float (optional)"
                    }
                ]
            }

    """
    guids = kwargs.pop('guids')  # type: List[str]
    min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
    ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
    exclude_relationship_types = kwargs.pop('exclude_relationship_types', None)  # type: Optional[List[str]]
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['guids'] = [_SERIALIZER.query("guids", q, 'str') if q is not None else '' for q in guids]
    if min_ext_info is not None:
        query_parameters['minExtInfo'] = _SERIALIZER.query("min_ext_info", min_ext_info, 'bool')
    if ignore_relationships is not None:
        query_parameters['ignoreRelationships'] = _SERIALIZER.query("ignore_relationships", ignore_relationships, 'bool')
    if exclude_relationship_types is not None:
        query_parameters['excludeRelationshipTypes'] = [_SERIALIZER.query("exclude_relationship_types", q, 'str') if q is not None else '' for q in exclude_relationship_types]

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_or_update_entities_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Create or update entities in Atlas in bulk.
    Existing entity is matched using its unique guid if supplied or by its unique attributes eg:
    qualifiedName.
    Map and array of collections are not well supported. E.g., array<array:code:`<int>`>,
    array<map<string, int>>.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: An array of entities to create or update.
    :paramtype json: Any
    :keyword content: An array of entities to create or update.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "entities": [
                    {
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str (optional)",
                                    "info": "str (optional)"
                                }
                            ]
                        },
                        "createTime": "float (optional)",
                        "createdBy": "str (optional)",
                        "guid": "str (optional)",
                        "homeId": "str (optional)",
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "provenanceType": "float (optional)",
                        "proxy": "bool (optional)",
                        "relationshipAttributes": {
                            "str": "object (optional)"
                        },
                        "source": "str (optional)",
                        "sourceDetails": {
                            "str": "object (optional)"
                        },
                        "status": "str (optional)",
                        "updateTime": "float (optional)",
                        "updatedBy": "str (optional)",
                        "version": "float (optional)"
                    }
                ]
            }


            # response body for status code(s): 200
            response_body == {
                "guidAssignments": {
                    "str": "str (optional)"
                },
                "mutatedEntities": {
                    "str": [
                        {
                            "classificationNames": [
                                "str (optional)"
                            ],
                            "classifications": [
                                {
                                    "entityGuid": "str (optional)",
                                    "entityStatus": "str (optional)",
                                    "removePropagationsOnEntityDelete": "bool (optional)",
                                    "source": "str (optional)",
                                    "sourceDetails": {
                                        "str": "object (optional)"
                                    },
                                    "validityPeriods": [
                                        {
                                            "endTime": "str (optional)",
                                            "startTime": "str (optional)",
                                            "timeZone": "str (optional)"
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str (optional)",
                            "guid": "str (optional)",
                            "meaningNames": [
                                "str (optional)"
                            ],
                            "meanings": [
                                {
                                    "confidence": "int (optional)",
                                    "createdBy": "str (optional)",
                                    "description": "str (optional)",
                                    "displayText": "str (optional)",
                                    "expression": "str (optional)",
                                    "relationGuid": "str (optional)",
                                    "source": "str (optional)",
                                    "status": "str (optional)",
                                    "steward": "str (optional)",
                                    "termGuid": "str (optional)"
                                }
                            ],
                            "status": "str (optional)"
                        }
                    ]
                },
                "partialUpdatedEntities": [
                    {
                        "classificationNames": [
                            "str (optional)"
                        ],
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "displayText": "str (optional)",
                        "guid": "str (optional)",
                        "meaningNames": [
                            "str (optional)"
                        ],
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)"
                    }
                ]
            }

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_delete_by_guids_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Delete a list of entities in bulk identified by their GUIDs or unique attributes.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword guids: An array of GUIDs of entities to delete.
    :paramtype guids: list[str]
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "guidAssignments": {
                    "str": "str (optional)"
                },
                "mutatedEntities": {
                    "str": [
                        {
                            "classificationNames": [
                                "str (optional)"
                            ],
                            "classifications": [
                                {
                                    "entityGuid": "str (optional)",
                                    "entityStatus": "str (optional)",
                                    "removePropagationsOnEntityDelete": "bool (optional)",
                                    "source": "str (optional)",
                                    "sourceDetails": {
                                        "str": "object (optional)"
                                    },
                                    "validityPeriods": [
                                        {
                                            "endTime": "str (optional)",
                                            "startTime": "str (optional)",
                                            "timeZone": "str (optional)"
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str (optional)",
                            "guid": "str (optional)",
                            "meaningNames": [
                                "str (optional)"
                            ],
                            "meanings": [
                                {
                                    "confidence": "int (optional)",
                                    "createdBy": "str (optional)",
                                    "description": "str (optional)",
                                    "displayText": "str (optional)",
                                    "expression": "str (optional)",
                                    "relationGuid": "str (optional)",
                                    "source": "str (optional)",
                                    "status": "str (optional)",
                                    "steward": "str (optional)",
                                    "termGuid": "str (optional)"
                                }
                            ],
                            "status": "str (optional)"
                        }
                    ]
                },
                "partialUpdatedEntities": [
                    {
                        "classificationNames": [
                            "str (optional)"
                        ],
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "displayText": "str (optional)",
                        "guid": "str (optional)",
                        "meaningNames": [
                            "str (optional)"
                        ],
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)"
                    }
                ]
            }

    """
    guids = kwargs.pop('guids')  # type: List[str]
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['guids'] = [_SERIALIZER.query("guids", q, 'str') if q is not None else '' for q in guids]

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_add_classification_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Associate a classification to multiple entities in bulk.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: The request to associate a classification to multiple entities.
    :paramtype json: Any
    :keyword content: The request to associate a classification to multiple entities.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "classification": {
                    "entityGuid": "str (optional)",
                    "entityStatus": "str (optional)",
                    "removePropagationsOnEntityDelete": "bool (optional)",
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "validityPeriods": [
                        {
                            "endTime": "str (optional)",
                            "startTime": "str (optional)",
                            "timeZone": "str (optional)"
                        }
                    ]
                },
                "entityGuids": [
                    "str (optional)"
                ]
            }
    """
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk/classification')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Get complete definition of an entity given its GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :keyword min_ext_info: Whether to return minimal information for referred entities.
    :paramtype min_ext_info: bool
    :keyword ignore_relationships: Whether to ignore relationship attributes.
    :paramtype ignore_relationships: bool
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "entity": {
                    "classifications": [
                        {
                            "entityGuid": "str (optional)",
                            "entityStatus": "str (optional)",
                            "removePropagationsOnEntityDelete": "bool (optional)",
                            "source": "str (optional)",
                            "sourceDetails": {
                                "str": "object (optional)"
                            },
                            "validityPeriods": [
                                {
                                    "endTime": "str (optional)",
                                    "startTime": "str (optional)",
                                    "timeZone": "str (optional)"
                                }
                            ]
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str (optional)",
                                "info": "str (optional)"
                            }
                        ]
                    },
                    "createTime": "float (optional)",
                    "createdBy": "str (optional)",
                    "guid": "str (optional)",
                    "homeId": "str (optional)",
                    "meanings": [
                        {
                            "confidence": "int (optional)",
                            "createdBy": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "provenanceType": "float (optional)",
                    "proxy": "bool (optional)",
                    "relationshipAttributes": {
                        "str": "object (optional)"
                    },
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "status": "str (optional)",
                    "updateTime": "float (optional)",
                    "updatedBy": "str (optional)",
                    "version": "float (optional)"
                }
            }

    """
    min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
    ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if min_ext_info is not None:
        query_parameters['minExtInfo'] = _SERIALIZER.query("min_ext_info", min_ext_info, 'bool')
    if ignore_relationships is not None:
        query_parameters['ignoreRelationships'] = _SERIALIZER.query("ignore_relationships", ignore_relationships, 'bool')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_partial_update_entity_attribute_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Update entity partially - create or update entity attribute identified by its GUID.
    Supports only primitive attribute type and entity references.
    It does not support updating complex types like arrays, and maps.
    Null updates are not possible.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :keyword json: The value of the attribute.
    :paramtype json: Any
    :keyword content: The value of the attribute.
    :paramtype content: Any
    :keyword name: The name of the attribute.
    :paramtype name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = "object (optional)"


            # response body for status code(s): 200
            response_body == {
                "guidAssignments": {
                    "str": "str (optional)"
                },
                "mutatedEntities": {
                    "str": [
                        {
                            "classificationNames": [
                                "str (optional)"
                            ],
                            "classifications": [
                                {
                                    "entityGuid": "str (optional)",
                                    "entityStatus": "str (optional)",
                                    "removePropagationsOnEntityDelete": "bool (optional)",
                                    "source": "str (optional)",
                                    "sourceDetails": {
                                        "str": "object (optional)"
                                    },
                                    "validityPeriods": [
                                        {
                                            "endTime": "str (optional)",
                                            "startTime": "str (optional)",
                                            "timeZone": "str (optional)"
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str (optional)",
                            "guid": "str (optional)",
                            "meaningNames": [
                                "str (optional)"
                            ],
                            "meanings": [
                                {
                                    "confidence": "int (optional)",
                                    "createdBy": "str (optional)",
                                    "description": "str (optional)",
                                    "displayText": "str (optional)",
                                    "expression": "str (optional)",
                                    "relationGuid": "str (optional)",
                                    "source": "str (optional)",
                                    "status": "str (optional)",
                                    "steward": "str (optional)",
                                    "termGuid": "str (optional)"
                                }
                            ],
                            "status": "str (optional)"
                        }
                    ]
                },
                "partialUpdatedEntities": [
                    {
                        "classificationNames": [
                            "str (optional)"
                        ],
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "displayText": "str (optional)",
                        "guid": "str (optional)",
                        "meaningNames": [
                            "str (optional)"
                        ],
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)"
                    }
                ]
            }

    """
    name = kwargs.pop('name')  # type: str
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['name'] = _SERIALIZER.query("name", name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_delete_by_guid_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Delete an entity identified by its GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "guidAssignments": {
                    "str": "str (optional)"
                },
                "mutatedEntities": {
                    "str": [
                        {
                            "classificationNames": [
                                "str (optional)"
                            ],
                            "classifications": [
                                {
                                    "entityGuid": "str (optional)",
                                    "entityStatus": "str (optional)",
                                    "removePropagationsOnEntityDelete": "bool (optional)",
                                    "source": "str (optional)",
                                    "sourceDetails": {
                                        "str": "object (optional)"
                                    },
                                    "validityPeriods": [
                                        {
                                            "endTime": "str (optional)",
                                            "startTime": "str (optional)",
                                            "timeZone": "str (optional)"
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str (optional)",
                            "guid": "str (optional)",
                            "meaningNames": [
                                "str (optional)"
                            ],
                            "meanings": [
                                {
                                    "confidence": "int (optional)",
                                    "createdBy": "str (optional)",
                                    "description": "str (optional)",
                                    "displayText": "str (optional)",
                                    "expression": "str (optional)",
                                    "relationGuid": "str (optional)",
                                    "source": "str (optional)",
                                    "status": "str (optional)",
                                    "steward": "str (optional)",
                                    "termGuid": "str (optional)"
                                }
                            ],
                            "status": "str (optional)"
                        }
                    ]
                },
                "partialUpdatedEntities": [
                    {
                        "classificationNames": [
                            "str (optional)"
                        ],
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "displayText": "str (optional)",
                        "guid": "str (optional)",
                        "meaningNames": [
                            "str (optional)"
                        ],
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_classification_request(
    guid,  # type: str
    classification_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """List classifications for a given entity represented by a GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :param classification_name: The name of the classification.
    :type classification_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "entityGuid": "str (optional)",
                "entityStatus": "str (optional)",
                "removePropagationsOnEntityDelete": "bool (optional)",
                "source": "str (optional)",
                "sourceDetails": {
                    "str": "object (optional)"
                },
                "validityPeriods": [
                    {
                        "endTime": "str (optional)",
                        "startTime": "str (optional)",
                        "timeZone": "str (optional)"
                    }
                ]
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classification/{classificationName}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
        'classificationName': _SERIALIZER.url("classification_name", classification_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_delete_classification_request(
    guid,  # type: str
    classification_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Delete a given classification from an existing entity represented by a GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :param classification_name: The name of the classification.
    :type classification_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest
    """

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classification/{classificationName}')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
        'classificationName': _SERIALIZER.url("classification_name", classification_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    return HttpRequest(
        method="DELETE",
        url=url,
        **kwargs
    )


def build_get_classifications_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """List classifications for a given entity represented by a GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {}

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classifications')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_add_classifications_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Add classifications to an existing entity represented by a GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :keyword json: An array of classifications to be added.
    :paramtype json: Any
    :keyword content: An array of classifications to be added.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "entityGuid": "str (optional)",
                    "entityStatus": "str (optional)",
                    "removePropagationsOnEntityDelete": "bool (optional)",
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "validityPeriods": [
                        {
                            "endTime": "str (optional)",
                            "startTime": "str (optional)",
                            "timeZone": "str (optional)"
                        }
                    ]
                }
            ]
    """
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classifications')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_update_classifications_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Update classifications to an existing entity represented by a guid.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :keyword json: An array of classifications to be updated.
    :paramtype json: Any
    :keyword content: An array of classifications to be updated.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "entityGuid": "str (optional)",
                    "entityStatus": "str (optional)",
                    "removePropagationsOnEntityDelete": "bool (optional)",
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "validityPeriods": [
                        {
                            "endTime": "str (optional)",
                            "startTime": "str (optional)",
                            "timeZone": "str (optional)"
                        }
                    ]
                }
            ]
    """
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/classifications')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_by_unique_attributes_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Get complete definition of an entity given its type and unique attribute.
    In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
    following format:
    attr:\:code:`<attrName>`=:code:`<attrValue>`.
    NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
    The REST request would look something like this:
    GET /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param type_name: The name of the type.
    :type type_name: str
    :keyword min_ext_info: Whether to return minimal information for referred entities.
    :paramtype min_ext_info: bool
    :keyword ignore_relationships: Whether to ignore relationship attributes.
    :paramtype ignore_relationships: bool
    :keyword attr_qualified_name: The qualified name of the entity.
    :paramtype attr_qualified_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "entity": {
                    "classifications": [
                        {
                            "entityGuid": "str (optional)",
                            "entityStatus": "str (optional)",
                            "removePropagationsOnEntityDelete": "bool (optional)",
                            "source": "str (optional)",
                            "sourceDetails": {
                                "str": "object (optional)"
                            },
                            "validityPeriods": [
                                {
                                    "endTime": "str (optional)",
                                    "startTime": "str (optional)",
                                    "timeZone": "str (optional)"
                                }
                            ]
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str (optional)",
                                "info": "str (optional)"
                            }
                        ]
                    },
                    "createTime": "float (optional)",
                    "createdBy": "str (optional)",
                    "guid": "str (optional)",
                    "homeId": "str (optional)",
                    "meanings": [
                        {
                            "confidence": "int (optional)",
                            "createdBy": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "provenanceType": "float (optional)",
                    "proxy": "bool (optional)",
                    "relationshipAttributes": {
                        "str": "object (optional)"
                    },
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "status": "str (optional)",
                    "updateTime": "float (optional)",
                    "updatedBy": "str (optional)",
                    "version": "float (optional)"
                }
            }

    """
    min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
    ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}')
    path_format_arguments = {
        'typeName': _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if min_ext_info is not None:
        query_parameters['minExtInfo'] = _SERIALIZER.query("min_ext_info", min_ext_info, 'bool')
    if ignore_relationships is not None:
        query_parameters['ignoreRelationships'] = _SERIALIZER.query("ignore_relationships", ignore_relationships, 'bool')
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_partial_update_entity_by_unique_attributes_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Update entity partially - Allow a subset of attributes to be updated on
    an entity which is identified by its type and unique attribute  eg:
    Referenceable.qualifiedName.
    Null updates are not possible.
    In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
    following format:
    attr::code:`<attrName>`=:code:`<attrValue>`.
    NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
    The REST request would look something like this:
    PUT /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param type_name: The name of the type.
    :type type_name: str
    :keyword json: Atlas entity with extended information.
    :paramtype json: Any
    :keyword content: Atlas entity with extended information.
    :paramtype content: Any
    :keyword attr_qualified_name: The qualified name of the entity.
    :paramtype attr_qualified_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "entity": {
                    "classifications": [
                        {
                            "entityGuid": "str (optional)",
                            "entityStatus": "str (optional)",
                            "removePropagationsOnEntityDelete": "bool (optional)",
                            "source": "str (optional)",
                            "sourceDetails": {
                                "str": "object (optional)"
                            },
                            "validityPeriods": [
                                {
                                    "endTime": "str (optional)",
                                    "startTime": "str (optional)",
                                    "timeZone": "str (optional)"
                                }
                            ]
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str (optional)",
                                "info": "str (optional)"
                            }
                        ]
                    },
                    "createTime": "float (optional)",
                    "createdBy": "str (optional)",
                    "guid": "str (optional)",
                    "homeId": "str (optional)",
                    "meanings": [
                        {
                            "confidence": "int (optional)",
                            "createdBy": "str (optional)",
                            "description": "str (optional)",
                            "displayText": "str (optional)",
                            "expression": "str (optional)",
                            "relationGuid": "str (optional)",
                            "source": "str (optional)",
                            "status": "str (optional)",
                            "steward": "str (optional)",
                            "termGuid": "str (optional)"
                        }
                    ],
                    "provenanceType": "float (optional)",
                    "proxy": "bool (optional)",
                    "relationshipAttributes": {
                        "str": "object (optional)"
                    },
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "status": "str (optional)",
                    "updateTime": "float (optional)",
                    "updatedBy": "str (optional)",
                    "version": "float (optional)"
                }
            }


            # response body for status code(s): 200
            response_body == {
                "guidAssignments": {
                    "str": "str (optional)"
                },
                "mutatedEntities": {
                    "str": [
                        {
                            "classificationNames": [
                                "str (optional)"
                            ],
                            "classifications": [
                                {
                                    "entityGuid": "str (optional)",
                                    "entityStatus": "str (optional)",
                                    "removePropagationsOnEntityDelete": "bool (optional)",
                                    "source": "str (optional)",
                                    "sourceDetails": {
                                        "str": "object (optional)"
                                    },
                                    "validityPeriods": [
                                        {
                                            "endTime": "str (optional)",
                                            "startTime": "str (optional)",
                                            "timeZone": "str (optional)"
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str (optional)",
                            "guid": "str (optional)",
                            "meaningNames": [
                                "str (optional)"
                            ],
                            "meanings": [
                                {
                                    "confidence": "int (optional)",
                                    "createdBy": "str (optional)",
                                    "description": "str (optional)",
                                    "displayText": "str (optional)",
                                    "expression": "str (optional)",
                                    "relationGuid": "str (optional)",
                                    "source": "str (optional)",
                                    "status": "str (optional)",
                                    "steward": "str (optional)",
                                    "termGuid": "str (optional)"
                                }
                            ],
                            "status": "str (optional)"
                        }
                    ]
                },
                "partialUpdatedEntities": [
                    {
                        "classificationNames": [
                            "str (optional)"
                        ],
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "displayText": "str (optional)",
                        "guid": "str (optional)",
                        "meaningNames": [
                            "str (optional)"
                        ],
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)"
                    }
                ]
            }

    """
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}')
    path_format_arguments = {
        'typeName': _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_delete_by_unique_attribute_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Delete an entity identified by its type and unique attributes.
    In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
    following format:
    attr:\:code:`<attrName>`=\:code:`<attrValue>`.
    NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
    The REST request would look something like this:
    DELETE /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param type_name: The name of the type.
    :type type_name: str
    :keyword attr_qualified_name: The qualified name of the entity.
    :paramtype attr_qualified_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "guidAssignments": {
                    "str": "str (optional)"
                },
                "mutatedEntities": {
                    "str": [
                        {
                            "classificationNames": [
                                "str (optional)"
                            ],
                            "classifications": [
                                {
                                    "entityGuid": "str (optional)",
                                    "entityStatus": "str (optional)",
                                    "removePropagationsOnEntityDelete": "bool (optional)",
                                    "source": "str (optional)",
                                    "sourceDetails": {
                                        "str": "object (optional)"
                                    },
                                    "validityPeriods": [
                                        {
                                            "endTime": "str (optional)",
                                            "startTime": "str (optional)",
                                            "timeZone": "str (optional)"
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str (optional)",
                            "guid": "str (optional)",
                            "meaningNames": [
                                "str (optional)"
                            ],
                            "meanings": [
                                {
                                    "confidence": "int (optional)",
                                    "createdBy": "str (optional)",
                                    "description": "str (optional)",
                                    "displayText": "str (optional)",
                                    "expression": "str (optional)",
                                    "relationGuid": "str (optional)",
                                    "source": "str (optional)",
                                    "status": "str (optional)",
                                    "steward": "str (optional)",
                                    "termGuid": "str (optional)"
                                }
                            ],
                            "status": "str (optional)"
                        }
                    ]
                },
                "partialUpdatedEntities": [
                    {
                        "classificationNames": [
                            "str (optional)"
                        ],
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "displayText": "str (optional)",
                        "guid": "str (optional)",
                        "meaningNames": [
                            "str (optional)"
                        ],
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)"
                    }
                ]
            }

    """
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}')
    path_format_arguments = {
        'typeName': _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_delete_classification_by_unique_attribute_request(
    type_name,  # type: str
    classification_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Delete a given classification from an entity identified by its type and unique attributes.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param type_name: The name of the type.
    :type type_name: str
    :param classification_name: The name of the classification.
    :type classification_name: str
    :keyword attr_qualified_name: The qualified name of the entity.
    :paramtype attr_qualified_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest
    """
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classification/{classificationName}')
    path_format_arguments = {
        'typeName': _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
        'classificationName': _SERIALIZER.url("classification_name", classification_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_add_classifications_by_unique_attribute_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Add classification to the entity identified by its type and unique attributes.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param type_name: The name of the type.
    :type type_name: str
    :keyword json: An array of classification to be added.
    :paramtype json: Any
    :keyword content: An array of classification to be added.
    :paramtype content: Any
    :keyword attr_qualified_name: The qualified name of the entity.
    :paramtype attr_qualified_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "entityGuid": "str (optional)",
                    "entityStatus": "str (optional)",
                    "removePropagationsOnEntityDelete": "bool (optional)",
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "validityPeriods": [
                        {
                            "endTime": "str (optional)",
                            "startTime": "str (optional)",
                            "timeZone": "str (optional)"
                        }
                    ]
                }
            ]
    """
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications')
    path_format_arguments = {
        'typeName': _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_update_classifications_by_unique_attribute_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Update classification on an entity identified by its type and unique attributes.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param type_name: The name of the type.
    :type type_name: str
    :keyword json: An array of classification to be updated.
    :paramtype json: Any
    :keyword content: An array of classification to be updated.
    :paramtype content: Any
    :keyword attr_qualified_name: The qualified name of the entity.
    :paramtype attr_qualified_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = [
                {
                    "entityGuid": "str (optional)",
                    "entityStatus": "str (optional)",
                    "removePropagationsOnEntityDelete": "bool (optional)",
                    "source": "str (optional)",
                    "sourceDetails": {
                        "str": "object (optional)"
                    },
                    "validityPeriods": [
                        {
                            "endTime": "str (optional)",
                            "startTime": "str (optional)",
                            "timeZone": "str (optional)"
                        }
                    ]
                }
            ]
    """
    attr_qualified_name = kwargs.pop('attr_qualified_name', None)  # type: Optional[str]
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/uniqueAttribute/type/{typeName}/classifications')
    path_format_arguments = {
        'typeName': _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if attr_qualified_name is not None:
        query_parameters['attr:qualifiedName'] = _SERIALIZER.query("attr_qualified_name", attr_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_set_classifications_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Set classifications on entities in bulk.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :keyword json: Atlas entity headers.
    :paramtype json: Any
    :keyword content: Atlas entity headers.
    :paramtype content: Any
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # JSON input template you can fill out and use as your `json` input.
            json = {
                "guidHeaderMap": {
                    "str": {
                        "classificationNames": [
                            "str (optional)"
                        ],
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "displayText": "str (optional)",
                        "guid": "str (optional)",
                        "meaningNames": [
                            "str (optional)"
                        ],
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "status": "str (optional)"
                    }
                }
            }


            # response body for status code(s): 200
            response_body == [
                "str (optional)"
            ]

    """
    content_type = kwargs.pop("content_type", None)
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk/setClassifications')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_entities_by_unique_attributes_request(
    type_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Bulk API to retrieve list of entities identified by its unique attributes.

    In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
    following format

    typeName=\:code:`<typeName>`&attr_1:\:code:`<attrName>`=\:code:`<attrValue>`&attr_2:\:code:`<attrName>`=\:code:`<attrValue>`&attr_3:\:code:`<attrName>`=\:code:`<attrValue>`

    NOTE: The attrName should be an unique attribute for the given entity-type

    The REST request would look something like this

    GET
    /v2/entity/bulk/uniqueAttribute/type/hive_db?attr_0:qualifiedName=db1@cl1&attr_2:qualifiedName=db2@cl1.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param type_name: The name of the type.
    :type type_name: str
    :keyword min_ext_info: Whether to return minimal information for referred entities.
    :paramtype min_ext_info: bool
    :keyword ignore_relationships: Whether to ignore relationship attributes.
    :paramtype ignore_relationships: bool
    :keyword attr_n_qualified_name: Qualified name of an entity. E.g. to find 2 entities you can
     set attrs_0:qualifiedName=db1@cl1&attrs_2:qualifiedName=db2@cl1.
    :paramtype attr_n_qualified_name: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "entities": [
                    {
                        "classifications": [
                            {
                                "entityGuid": "str (optional)",
                                "entityStatus": "str (optional)",
                                "removePropagationsOnEntityDelete": "bool (optional)",
                                "source": "str (optional)",
                                "sourceDetails": {
                                    "str": "object (optional)"
                                },
                                "validityPeriods": [
                                    {
                                        "endTime": "str (optional)",
                                        "startTime": "str (optional)",
                                        "timeZone": "str (optional)"
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str (optional)",
                                    "info": "str (optional)"
                                }
                            ]
                        },
                        "createTime": "float (optional)",
                        "createdBy": "str (optional)",
                        "guid": "str (optional)",
                        "homeId": "str (optional)",
                        "meanings": [
                            {
                                "confidence": "int (optional)",
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "displayText": "str (optional)",
                                "expression": "str (optional)",
                                "relationGuid": "str (optional)",
                                "source": "str (optional)",
                                "status": "str (optional)",
                                "steward": "str (optional)",
                                "termGuid": "str (optional)"
                            }
                        ],
                        "provenanceType": "float (optional)",
                        "proxy": "bool (optional)",
                        "relationshipAttributes": {
                            "str": "object (optional)"
                        },
                        "source": "str (optional)",
                        "sourceDetails": {
                            "str": "object (optional)"
                        },
                        "status": "str (optional)",
                        "updateTime": "float (optional)",
                        "updatedBy": "str (optional)",
                        "version": "float (optional)"
                    }
                ]
            }

    """
    min_ext_info = kwargs.pop('min_ext_info', False)  # type: Optional[bool]
    ignore_relationships = kwargs.pop('ignore_relationships', False)  # type: Optional[bool]
    attr_n_qualified_name = kwargs.pop('attr_n_qualified_name', None)  # type: Optional[str]
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/bulk/uniqueAttribute/type/{typeName}')
    path_format_arguments = {
        'typeName': _SERIALIZER.url("type_name", type_name, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if min_ext_info is not None:
        query_parameters['minExtInfo'] = _SERIALIZER.query("min_ext_info", min_ext_info, 'bool')
    if ignore_relationships is not None:
        query_parameters['ignoreRelationships'] = _SERIALIZER.query("ignore_relationships", ignore_relationships, 'bool')
    if attr_n_qualified_name is not None:
        query_parameters['attr_N:qualifiedName'] = _SERIALIZER.query("attr_n_qualified_name", attr_n_qualified_name, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_header_request(
    guid,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Get entity header given its GUID.

    See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this request builder into your code flow.

    :param guid: The globally unique identifier of the entity.
    :type guid: str
    :return: Returns an :class:`~azure.purview.catalog.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/protocol/quickstart for how to incorporate this response into your code flow.
    :rtype: ~azure.purview.catalog.core.rest.HttpRequest

    Example:
        .. code-block:: python


            # response body for status code(s): 200
            response_body == {
                "classificationNames": [
                    "str (optional)"
                ],
                "classifications": [
                    {
                        "entityGuid": "str (optional)",
                        "entityStatus": "str (optional)",
                        "removePropagationsOnEntityDelete": "bool (optional)",
                        "source": "str (optional)",
                        "sourceDetails": {
                            "str": "object (optional)"
                        },
                        "validityPeriods": [
                            {
                                "endTime": "str (optional)",
                                "startTime": "str (optional)",
                                "timeZone": "str (optional)"
                            }
                        ]
                    }
                ],
                "displayText": "str (optional)",
                "guid": "str (optional)",
                "meaningNames": [
                    "str (optional)"
                ],
                "meanings": [
                    {
                        "confidence": "int (optional)",
                        "createdBy": "str (optional)",
                        "description": "str (optional)",
                        "displayText": "str (optional)",
                        "expression": "str (optional)",
                        "relationGuid": "str (optional)",
                        "source": "str (optional)",
                        "status": "str (optional)",
                        "steward": "str (optional)",
                        "termGuid": "str (optional)"
                    }
                ],
                "status": "str (optional)"
            }

    """
    accept = "application/json"

    # Construct URL
    url = kwargs.pop("template_url", '/atlas/v2/entity/guid/{guid}/header')
    path_format_arguments = {
        'guid': _SERIALIZER.url("guid", guid, 'str', max_length=4096, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )

