from ctypes import c_uint64

BGFX_STATE_RGB_WRITE = c_uint64(0x0000000000000001)
BGFX_STATE_ALPHA_WRITE = c_uint64(0x0000000000000002)
BGFX_STATE_DEPTH_WRITE = c_uint64(0x0000000000000004)

BGFX_STATE_DEPTH_TEST_LESS = c_uint64(0x0000000000000010)
BGFX_STATE_DEPTH_TEST_LEQUAL = c_uint64(0x0000000000000020)
BGFX_STATE_DEPTH_TEST_EQUAL = c_uint64(0x0000000000000030)
BGFX_STATE_DEPTH_TEST_GEQUAL = c_uint64(0x0000000000000040)
BGFX_STATE_DEPTH_TEST_GREATER = c_uint64(0x0000000000000050)
BGFX_STATE_DEPTH_TEST_NOTEQUAL = c_uint64(0x0000000000000060)
BGFX_STATE_DEPTH_TEST_NEVER = c_uint64(0x0000000000000070)
BGFX_STATE_DEPTH_TEST_ALWAYS = c_uint64(0x0000000000000080)
BGFX_STATE_DEPTH_TEST_SHIFT = c_uint64(4)
BGFX_STATE_DEPTH_TEST_MASK = c_uint64(0x00000000000000f0)

BGFX_STATE_BLEND_ZERO = c_uint64(0x0000000000001000)
BGFX_STATE_BLEND_ONE = c_uint64(0x0000000000002000)
BGFX_STATE_BLEND_SRC_COLOR = c_uint64(0x0000000000003000)
BGFX_STATE_BLEND_INV_SRC_COLOR = c_uint64(0x0000000000004000)
BGFX_STATE_BLEND_SRC_ALPHA = c_uint64(0x0000000000005000)
BGFX_STATE_BLEND_INV_SRC_ALPHA = c_uint64(0x0000000000006000)
BGFX_STATE_BLEND_DST_ALPHA = c_uint64(0x0000000000007000)
BGFX_STATE_BLEND_INV_DST_ALPHA = c_uint64(0x0000000000008000)
BGFX_STATE_BLEND_DST_COLOR = c_uint64(0x0000000000009000)
BGFX_STATE_BLEND_INV_DST_COLOR = c_uint64(0x000000000000a000)
BGFX_STATE_BLEND_SRC_ALPHA_SAT = c_uint64(0x000000000000b000)
BGFX_STATE_BLEND_FACTOR = c_uint64(0x000000000000c000)
BGFX_STATE_BLEND_INV_FACTOR = c_uint64(0x000000000000d000)
BGFX_STATE_BLEND_SHIFT = c_uint64(12)
BGFX_STATE_BLEND_MASK = c_uint64(0x000000000ffff000)

BGFX_STATE_BLEND_EQUATION_ADD = c_uint64(0x0000000000000000)
BGFX_STATE_BLEND_EQUATION_SUB = c_uint64(0x0000000010000000)
BGFX_STATE_BLEND_EQUATION_REVSUB = c_uint64(0x0000000020000000)
BGFX_STATE_BLEND_EQUATION_MIN = c_uint64(0x0000000030000000)
BGFX_STATE_BLEND_EQUATION_MAX = c_uint64(0x0000000040000000)
BGFX_STATE_BLEND_EQUATION_SHIFT = c_uint64(28)
BGFX_STATE_BLEND_EQUATION_MASK = c_uint64(0x00000003f0000000)

BGFX_STATE_BLEND_INDEPENDENT = c_uint64(0x0000000400000000)

BGFX_STATE_CULL_CW = c_uint64(0x0000001000000000)
BGFX_STATE_CULL_CCW = c_uint64(0x0000002000000000)
BGFX_STATE_CULL_SHIFT = c_uint64(36)
BGFX_STATE_CULL_MASK = c_uint64(0x0000003000000000)

# See BGFX_STATE_ALPHA_REF(_ref) helper macro.
BGFX_STATE_ALPHA_REF_SHIFT = c_uint64(40)
BGFX_STATE_ALPHA_REF_MASK = c_uint64(0x0000ff0000000000)

BGFX_STATE_PT_TRISTRIP = c_uint64(0x0001000000000000)
BGFX_STATE_PT_LINES = c_uint64(0x0002000000000000)
BGFX_STATE_PT_LINESTRIP = c_uint64(0x0003000000000000)
BGFX_STATE_PT_POINTS = c_uint64(0x0004000000000000)
BGFX_STATE_PT_SHIFT = c_uint64(48)
BGFX_STATE_PT_MASK = c_uint64(0x0007000000000000)

BGFX_STATE_POINT_SIZE_SHIFT = c_uint64(52)
BGFX_STATE_POINT_SIZE_MASK = c_uint64(0x0ff0000000000000)

# Enable MSAA write when writing into MSAA frame buffer. This flag is ignored when not writing into
# MSAA frame buffer.
BGFX_STATE_MSAA = c_uint64(0x1000000000000000)

# See BGFX_STATE_POINT_SIZE(_size) helper macro.
BGFX_STATE_NONE = c_uint64(0x0000000000000000)
BGFX_STATE_MASK = c_uint64(0xffffffffffffffff)

# Default state is write to RGB, alpha, and depth with depth test less enabled, with clockwise
# culling and MSAA (when writing into MSAA frame buffer, otherwise this
# flag is ignored).
BGFX_STATE_DEFAULT = (c_uint64(0x0000000000000000).value
                      | BGFX_STATE_RGB_WRITE.value
                      | BGFX_STATE_ALPHA_WRITE.value
                      | BGFX_STATE_DEPTH_TEST_LESS.value
                      | BGFX_STATE_DEPTH_WRITE.value
                      | BGFX_STATE_CULL_CW.value
                      | BGFX_STATE_MSAA.value)
