# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ApiError(Model):
    """Api error.

    :param details: The Api error details
    :type details: list[~azure.mgmt.compute.v2020_09_30.models.ApiErrorBase]
    :param innererror: The Api inner error
    :type innererror: ~azure.mgmt.compute.v2020_09_30.models.InnerError
    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, details=None, innererror=None, code: str=None, target: str=None, message: str=None, **kwargs) -> None:
        super(ApiError, self).__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, target: str=None, message: str=None, **kwargs) -> None:
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class CloudError(Model):
    """An error response from the Compute service.

    :param error:
    :type error: ~azure.mgmt.compute.v2020_09_30.models.ApiError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class DiskImageEncryption(Model):
    """This is the disk image encryption base class.

    :param disk_encryption_set_id: A relative URI containing the resource ID
     of the disk encryption set.
    :type disk_encryption_set_id: str
    """

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(self, *, disk_encryption_set_id: str=None, **kwargs) -> None:
        super(DiskImageEncryption, self).__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id


class DataDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for a data disk image.

    All required parameters must be populated in order to send to Azure.

    :param disk_encryption_set_id: A relative URI containing the resource ID
     of the disk encryption set.
    :type disk_encryption_set_id: str
    :param lun: Required. This property specifies the logical unit number of
     the data disk. This value is used to identify data disks within the
     Virtual Machine and therefore must be unique for each data disk attached
     to the Virtual Machine.
    :type lun: int
    """

    _validation = {
        'lun': {'required': True},
    }

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(self, *, lun: int, disk_encryption_set_id: str=None, **kwargs) -> None:
        super(DataDiskImageEncryption, self).__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.lun = lun


class Disallowed(Model):
    """Describes the disallowed disk types.

    :param disk_types: A list of disk types.
    :type disk_types: list[str]
    """

    _attribute_map = {
        'disk_types': {'key': 'diskTypes', 'type': '[str]'},
    }

    def __init__(self, *, disk_types=None, **kwargs) -> None:
        super(Disallowed, self).__init__(**kwargs)
        self.disk_types = disk_types


class EncryptionImages(Model):
    """Optional. Allows users to provide customer managed keys for encrypting the
    OS and data disks in the gallery artifact.

    :param os_disk_image:
    :type os_disk_image:
     ~azure.mgmt.compute.v2020_09_30.models.OSDiskImageEncryption
    :param data_disk_images: A list of encryption specifications for data disk
     images.
    :type data_disk_images:
     list[~azure.mgmt.compute.v2020_09_30.models.DataDiskImageEncryption]
    """

    _attribute_map = {
        'os_disk_image': {'key': 'osDiskImage', 'type': 'OSDiskImageEncryption'},
        'data_disk_images': {'key': 'dataDiskImages', 'type': '[DataDiskImageEncryption]'},
    }

    def __init__(self, *, os_disk_image=None, data_disk_images=None, **kwargs) -> None:
        super(EncryptionImages, self).__init__(**kwargs)
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class Resource(Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Gallery(Resource):
    """Specifies information about the Shared Image Gallery that you want to
    create or update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param description: The description of this Shared Image Gallery resource.
     This property is updatable.
    :type description: str
    :param identifier:
    :type identifier: ~azure.mgmt.compute.v2020_09_30.models.GalleryIdentifier
    :ivar provisioning_state: The current state of the gallery. The
     provisioning state, which only appears in the response. Possible values
     include: 'Creating', 'Updating', 'Failed', 'Succeeded', 'Deleting',
     'Migrating'
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.enum
    :param sharing_profile:
    :type sharing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.SharingProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryIdentifier'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sharing_profile': {'key': 'properties.sharingProfile', 'type': 'SharingProfile'},
    }

    def __init__(self, *, location: str, tags=None, description: str=None, identifier=None, sharing_profile=None, **kwargs) -> None:
        super(Gallery, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile


class GalleryApplication(Resource):
    """Specifies information about the gallery Application Definition that you
    want to create or update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param description: The description of this gallery Application Definition
     resource. This property is updatable.
    :type description: str
    :param eula: The Eula agreement for the gallery Application Definition.
    :type eula: str
    :param privacy_statement_uri: The privacy statement uri.
    :type privacy_statement_uri: str
    :param release_note_uri: The release note uri.
    :type release_note_uri: str
    :param end_of_life_date: The end of life date of the gallery Application
     Definition. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    :param supported_os_type: Required. This property allows you to specify
     the supported type of the OS that application is built for. <br><br>
     Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible
     values include: 'Windows', 'Linux'
    :type supported_os_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'supported_os_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'supported_os_type': {'key': 'properties.supportedOSType', 'type': 'OperatingSystemTypes'},
    }

    def __init__(self, *, location: str, supported_os_type, tags=None, description: str=None, eula: str=None, privacy_statement_uri: str=None, release_note_uri: str=None, end_of_life_date=None, **kwargs) -> None:
        super(GalleryApplication, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type


class UpdateResourceDefinition(Model):
    """The Update Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(UpdateResourceDefinition, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags


class GalleryApplicationUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Definition that you
    want to update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param description: The description of this gallery Application Definition
     resource. This property is updatable.
    :type description: str
    :param eula: The Eula agreement for the gallery Application Definition.
    :type eula: str
    :param privacy_statement_uri: The privacy statement uri.
    :type privacy_statement_uri: str
    :param release_note_uri: The release note uri.
    :type release_note_uri: str
    :param end_of_life_date: The end of life date of the gallery Application
     Definition. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    :param supported_os_type: Required. This property allows you to specify
     the supported type of the OS that application is built for. <br><br>
     Possible values are: <br><br> **Windows** <br><br> **Linux**. Possible
     values include: 'Windows', 'Linux'
    :type supported_os_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'supported_os_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'supported_os_type': {'key': 'properties.supportedOSType', 'type': 'OperatingSystemTypes'},
    }

    def __init__(self, *, supported_os_type, tags=None, description: str=None, eula: str=None, privacy_statement_uri: str=None, release_note_uri: str=None, end_of_life_date=None, **kwargs) -> None:
        super(GalleryApplicationUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type


class GalleryApplicationVersion(Resource):
    """Specifies information about the gallery Application Version that you want
    to create or update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param publishing_profile: Required.
    :type publishing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryApplicationVersionPublishingProfile
    :ivar provisioning_state: The current state of the gallery Application
     Version. The provisioning state, which only appears in the response.
     Possible values include: 'Creating', 'Updating', 'Failed', 'Succeeded',
     'Deleting', 'Migrating'
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.enum
    :ivar replication_status:
    :vartype replication_status:
     ~azure.mgmt.compute.v2020_09_30.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'publishing_profile': {'required': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryApplicationVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(self, *, location: str, publishing_profile, tags=None, **kwargs) -> None:
        super(GalleryApplicationVersion, self).__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.replication_status = None


class GalleryArtifactPublishingProfileBase(Model):
    """Describes the basic gallery artifact publishing profile.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param target_regions: The target regions where the Image Version is going
     to be replicated to. This property is updatable.
    :type target_regions:
     list[~azure.mgmt.compute.v2020_09_30.models.TargetRegion]
    :param replica_count: The number of replicas of the Image Version to be
     created per region. This property would take effect for a region when
     regionalReplicaCount is not specified. This property is updatable.
    :type replica_count: int
    :param exclude_from_latest: If set to true, Virtual Machines deployed from
     the latest version of the Image Definition won't use this Image Version.
    :type exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is
     published.
    :vartype published_date: datetime
    :param end_of_life_date: The end of life date of the gallery image
     version. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    :param storage_account_type: Specifies the storage account type to be used
     to store the image. This property is not updatable. Possible values
     include: 'Standard_LRS', 'Standard_ZRS', 'Premium_LRS'
    :type storage_account_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.StorageAccountType
    """

    _validation = {
        'published_date': {'readonly': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(self, *, target_regions=None, replica_count: int=None, exclude_from_latest: bool=None, end_of_life_date=None, storage_account_type=None, **kwargs) -> None:
        super(GalleryArtifactPublishingProfileBase, self).__init__(**kwargs)
        self.target_regions = target_regions
        self.replica_count = replica_count
        self.exclude_from_latest = exclude_from_latest
        self.published_date = None
        self.end_of_life_date = end_of_life_date
        self.storage_account_type = storage_account_type


class GalleryApplicationVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image version.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param target_regions: The target regions where the Image Version is going
     to be replicated to. This property is updatable.
    :type target_regions:
     list[~azure.mgmt.compute.v2020_09_30.models.TargetRegion]
    :param replica_count: The number of replicas of the Image Version to be
     created per region. This property would take effect for a region when
     regionalReplicaCount is not specified. This property is updatable.
    :type replica_count: int
    :param exclude_from_latest: If set to true, Virtual Machines deployed from
     the latest version of the Image Definition won't use this Image Version.
    :type exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is
     published.
    :vartype published_date: datetime
    :param end_of_life_date: The end of life date of the gallery image
     version. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    :param storage_account_type: Specifies the storage account type to be used
     to store the image. This property is not updatable. Possible values
     include: 'Standard_LRS', 'Standard_ZRS', 'Premium_LRS'
    :type storage_account_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.StorageAccountType
    :param source: Required.
    :type source: ~azure.mgmt.compute.v2020_09_30.models.UserArtifactSource
    :param content_type: Optional. May be used to help process this file. The
     type of file contained in the source, e.g. zip, json, etc.
    :type content_type: str
    :param enable_health_check: Optional. Whether or not this application
     reports health.
    :type enable_health_check: bool
    """

    _validation = {
        'published_date': {'readonly': True},
        'source': {'required': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'source': {'key': 'source', 'type': 'UserArtifactSource'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'enable_health_check': {'key': 'enableHealthCheck', 'type': 'bool'},
    }

    def __init__(self, *, source, target_regions=None, replica_count: int=None, exclude_from_latest: bool=None, end_of_life_date=None, storage_account_type=None, content_type: str=None, enable_health_check: bool=None, **kwargs) -> None:
        super(GalleryApplicationVersionPublishingProfile, self).__init__(target_regions=target_regions, replica_count=replica_count, exclude_from_latest=exclude_from_latest, end_of_life_date=end_of_life_date, storage_account_type=storage_account_type, **kwargs)
        self.source = source
        self.content_type = content_type
        self.enable_health_check = enable_health_check


class GalleryApplicationVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Version that you want
    to update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param publishing_profile: Required.
    :type publishing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryApplicationVersionPublishingProfile
    :ivar provisioning_state: The current state of the gallery Application
     Version. The provisioning state, which only appears in the response.
     Possible values include: 'Creating', 'Updating', 'Failed', 'Succeeded',
     'Deleting', 'Migrating'
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.enum
    :ivar replication_status:
    :vartype replication_status:
     ~azure.mgmt.compute.v2020_09_30.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'publishing_profile': {'required': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryApplicationVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(self, *, publishing_profile, tags=None, **kwargs) -> None:
        super(GalleryApplicationVersionUpdate, self).__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.replication_status = None


class GalleryArtifactSource(Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :param managed_image: Required.
    :type managed_image:
     ~azure.mgmt.compute.v2020_09_30.models.ManagedArtifact
    """

    _validation = {
        'managed_image': {'required': True},
    }

    _attribute_map = {
        'managed_image': {'key': 'managedImage', 'type': 'ManagedArtifact'},
    }

    def __init__(self, *, managed_image, **kwargs) -> None:
        super(GalleryArtifactSource, self).__init__(**kwargs)
        self.managed_image = managed_image


class GalleryArtifactVersionSource(Model):
    """The gallery artifact version source.

    :param id: The id of the gallery artifact version source. Can specify a
     disk uri, snapshot uri, user image or storage account resource.
    :type id: str
    :param uri: The uri of the gallery artifact version source. Currently used
     to specify vhd/blob source.
    :type uri: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, uri: str=None, **kwargs) -> None:
        super(GalleryArtifactVersionSource, self).__init__(**kwargs)
        self.id = id
        self.uri = uri


class GalleryDiskImage(Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be
     created.
    :vartype size_in_gb: int
    :param host_caching: The host caching of the disk. Valid values are
     'None', 'ReadOnly', and 'ReadWrite'. Possible values include: 'None',
     'ReadOnly', 'ReadWrite'
    :type host_caching: str or
     ~azure.mgmt.compute.v2020_09_30.models.HostCaching
    :param source:
    :type source:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactVersionSource
    """

    _validation = {
        'size_in_gb': {'readonly': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'HostCaching'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
    }

    def __init__(self, *, host_caching=None, source=None, **kwargs) -> None:
        super(GalleryDiskImage, self).__init__(**kwargs)
        self.size_in_gb = None
        self.host_caching = host_caching
        self.source = source


class GalleryDataDiskImage(GalleryDiskImage):
    """This is the data disk image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar size_in_gb: This property indicates the size of the VHD to be
     created.
    :vartype size_in_gb: int
    :param host_caching: The host caching of the disk. Valid values are
     'None', 'ReadOnly', and 'ReadWrite'. Possible values include: 'None',
     'ReadOnly', 'ReadWrite'
    :type host_caching: str or
     ~azure.mgmt.compute.v2020_09_30.models.HostCaching
    :param source:
    :type source:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactVersionSource
    :param lun: Required. This property specifies the logical unit number of
     the data disk. This value is used to identify data disks within the
     Virtual Machine and therefore must be unique for each data disk attached
     to the Virtual Machine.
    :type lun: int
    """

    _validation = {
        'size_in_gb': {'readonly': True},
        'lun': {'required': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'HostCaching'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(self, *, lun: int, host_caching=None, source=None, **kwargs) -> None:
        super(GalleryDataDiskImage, self).__init__(host_caching=host_caching, source=source, **kwargs)
        self.lun = lun


class GalleryIdentifier(Model):
    """Describes the gallery unique name.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar unique_name: The unique name of the Shared Image Gallery. This name
     is generated automatically by Azure.
    :vartype unique_name: str
    """

    _validation = {
        'unique_name': {'readonly': True},
    }

    _attribute_map = {
        'unique_name': {'key': 'uniqueName', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(GalleryIdentifier, self).__init__(**kwargs)
        self.unique_name = None


class GalleryImage(Resource):
    """Specifies information about the gallery image definition that you want to
    create or update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param description: The description of this gallery image definition
     resource. This property is updatable.
    :type description: str
    :param eula: The Eula agreement for the gallery image definition.
    :type eula: str
    :param privacy_statement_uri: The privacy statement uri.
    :type privacy_statement_uri: str
    :param release_note_uri: The release note uri.
    :type release_note_uri: str
    :param os_type: Required. This property allows you to specify the type of
     the OS that is included in the disk when creating a VM from a managed
     image. <br><br> Possible values are: <br><br> **Windows** <br><br>
     **Linux**. Possible values include: 'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    :param os_state: Required. This property allows the user to specify
     whether the virtual machines created under this image are 'Generalized' or
     'Specialized'. Possible values include: 'Generalized', 'Specialized'
    :type os_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemStateTypes
    :param hyper_vgeneration: The hypervisor generation of the Virtual
     Machine. Applicable to OS disks only. Possible values include: 'V1', 'V2'
    :type hyper_vgeneration: str or
     ~azure.mgmt.compute.v2020_09_30.models.HyperVGeneration
    :param features: A list of gallery image features.
    :type features:
     list[~azure.mgmt.compute.v2020_09_30.models.GalleryImageFeature]
    :param end_of_life_date: The end of life date of the gallery image
     definition. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    :param identifier: Required.
    :type identifier:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageIdentifier
    :param recommended:
    :type recommended:
     ~azure.mgmt.compute.v2020_09_30.models.RecommendedMachineConfiguration
    :param disallowed:
    :type disallowed: ~azure.mgmt.compute.v2020_09_30.models.Disallowed
    :param purchase_plan:
    :type purchase_plan:
     ~azure.mgmt.compute.v2020_09_30.models.ImagePurchasePlan
    :ivar provisioning_state: The current state of the gallery image
     definition. The provisioning state, which only appears in the response.
     Possible values include: 'Creating', 'Updating', 'Failed', 'Succeeded',
     'Deleting', 'Migrating'
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.enum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'os_type': {'required': True},
        'os_state': {'required': True},
        'identifier': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'OperatingSystemTypes'},
        'os_state': {'key': 'properties.osState', 'type': 'OperatingSystemStateTypes'},
        'hyper_vgeneration': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[GalleryImageFeature]'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryImageIdentifier'},
        'recommended': {'key': 'properties.recommended', 'type': 'RecommendedMachineConfiguration'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'Disallowed'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'ImagePurchasePlan'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, location: str, os_type, os_state, identifier, tags=None, description: str=None, eula: str=None, privacy_statement_uri: str=None, release_note_uri: str=None, hyper_vgeneration=None, features=None, end_of_life_date=None, recommended=None, disallowed=None, purchase_plan=None, **kwargs) -> None:
        super(GalleryImage, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_vgeneration = hyper_vgeneration
        self.features = features
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None


class GalleryImageFeature(Model):
    """A feature for gallery image.

    :param name: The name of the gallery image feature.
    :type name: str
    :param value: The value of the gallery image feature.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, value: str=None, **kwargs) -> None:
        super(GalleryImageFeature, self).__init__(**kwargs)
        self.name = name
        self.value = value


class GalleryImageIdentifier(Model):
    """This is the gallery image definition identifier.

    All required parameters must be populated in order to send to Azure.

    :param publisher: Required. The name of the gallery image definition
     publisher.
    :type publisher: str
    :param offer: Required. The name of the gallery image definition offer.
    :type offer: str
    :param sku: Required. The name of the gallery image definition SKU.
    :type sku: str
    """

    _validation = {
        'publisher': {'required': True},
        'offer': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
    }

    def __init__(self, *, publisher: str, offer: str, sku: str, **kwargs) -> None:
        super(GalleryImageIdentifier, self).__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku


class GalleryImageUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image definition that you want to
    update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param description: The description of this gallery image definition
     resource. This property is updatable.
    :type description: str
    :param eula: The Eula agreement for the gallery image definition.
    :type eula: str
    :param privacy_statement_uri: The privacy statement uri.
    :type privacy_statement_uri: str
    :param release_note_uri: The release note uri.
    :type release_note_uri: str
    :param os_type: Required. This property allows you to specify the type of
     the OS that is included in the disk when creating a VM from a managed
     image. <br><br> Possible values are: <br><br> **Windows** <br><br>
     **Linux**. Possible values include: 'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    :param os_state: Required. This property allows the user to specify
     whether the virtual machines created under this image are 'Generalized' or
     'Specialized'. Possible values include: 'Generalized', 'Specialized'
    :type os_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemStateTypes
    :param hyper_vgeneration: The hypervisor generation of the Virtual
     Machine. Applicable to OS disks only. Possible values include: 'V1', 'V2'
    :type hyper_vgeneration: str or
     ~azure.mgmt.compute.v2020_09_30.models.HyperVGeneration
    :param features: A list of gallery image features.
    :type features:
     list[~azure.mgmt.compute.v2020_09_30.models.GalleryImageFeature]
    :param end_of_life_date: The end of life date of the gallery image
     definition. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    :param identifier: Required.
    :type identifier:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageIdentifier
    :param recommended:
    :type recommended:
     ~azure.mgmt.compute.v2020_09_30.models.RecommendedMachineConfiguration
    :param disallowed:
    :type disallowed: ~azure.mgmt.compute.v2020_09_30.models.Disallowed
    :param purchase_plan:
    :type purchase_plan:
     ~azure.mgmt.compute.v2020_09_30.models.ImagePurchasePlan
    :ivar provisioning_state: The current state of the gallery image
     definition. The provisioning state, which only appears in the response.
     Possible values include: 'Creating', 'Updating', 'Failed', 'Succeeded',
     'Deleting', 'Migrating'
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.enum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'os_type': {'required': True},
        'os_state': {'required': True},
        'identifier': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'OperatingSystemTypes'},
        'os_state': {'key': 'properties.osState', 'type': 'OperatingSystemStateTypes'},
        'hyper_vgeneration': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[GalleryImageFeature]'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryImageIdentifier'},
        'recommended': {'key': 'properties.recommended', 'type': 'RecommendedMachineConfiguration'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'Disallowed'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'ImagePurchasePlan'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, os_type, os_state, identifier, tags=None, description: str=None, eula: str=None, privacy_statement_uri: str=None, release_note_uri: str=None, hyper_vgeneration=None, features=None, end_of_life_date=None, recommended=None, disallowed=None, purchase_plan=None, **kwargs) -> None:
        super(GalleryImageUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_vgeneration = hyper_vgeneration
        self.features = features
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None


class GalleryImageVersion(Resource):
    """Specifies information about the gallery image version that you want to
    create or update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param publishing_profile:
    :type publishing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The current state of the gallery image version.
     The provisioning state, which only appears in the response. Possible
     values include: 'Creating', 'Updating', 'Failed', 'Succeeded', 'Deleting',
     'Migrating'
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.enum
    :param storage_profile: Required.
    :type storage_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersionStorageProfile
    :ivar replication_status:
    :vartype replication_status:
     ~azure.mgmt.compute.v2020_09_30.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'storage_profile': {'required': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryImageVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'GalleryImageVersionStorageProfile'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(self, *, location: str, storage_profile, tags=None, publishing_profile=None, **kwargs) -> None:
        super(GalleryImageVersion, self).__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.replication_status = None


class GalleryImageVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image Version.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param target_regions: The target regions where the Image Version is going
     to be replicated to. This property is updatable.
    :type target_regions:
     list[~azure.mgmt.compute.v2020_09_30.models.TargetRegion]
    :param replica_count: The number of replicas of the Image Version to be
     created per region. This property would take effect for a region when
     regionalReplicaCount is not specified. This property is updatable.
    :type replica_count: int
    :param exclude_from_latest: If set to true, Virtual Machines deployed from
     the latest version of the Image Definition won't use this Image Version.
    :type exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is
     published.
    :vartype published_date: datetime
    :param end_of_life_date: The end of life date of the gallery image
     version. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    :param storage_account_type: Specifies the storage account type to be used
     to store the image. This property is not updatable. Possible values
     include: 'Standard_LRS', 'Standard_ZRS', 'Premium_LRS'
    :type storage_account_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.StorageAccountType
    """

    _validation = {
        'published_date': {'readonly': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(self, *, target_regions=None, replica_count: int=None, exclude_from_latest: bool=None, end_of_life_date=None, storage_account_type=None, **kwargs) -> None:
        super(GalleryImageVersionPublishingProfile, self).__init__(target_regions=target_regions, replica_count=replica_count, exclude_from_latest=exclude_from_latest, end_of_life_date=end_of_life_date, storage_account_type=storage_account_type, **kwargs)


class GalleryImageVersionStorageProfile(Model):
    """This is the storage profile of a Gallery Image Version.

    :param source:
    :type source:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactVersionSource
    :param os_disk_image:
    :type os_disk_image:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryOSDiskImage
    :param data_disk_images: A list of data disk images.
    :type data_disk_images:
     list[~azure.mgmt.compute.v2020_09_30.models.GalleryDataDiskImage]
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
        'os_disk_image': {'key': 'osDiskImage', 'type': 'GalleryOSDiskImage'},
        'data_disk_images': {'key': 'dataDiskImages', 'type': '[GalleryDataDiskImage]'},
    }

    def __init__(self, *, source=None, os_disk_image=None, data_disk_images=None, **kwargs) -> None:
        super(GalleryImageVersionStorageProfile, self).__init__(**kwargs)
        self.source = source
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class GalleryImageVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image version that you want to
    update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param publishing_profile:
    :type publishing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The current state of the gallery image version.
     The provisioning state, which only appears in the response. Possible
     values include: 'Creating', 'Updating', 'Failed', 'Succeeded', 'Deleting',
     'Migrating'
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.enum
    :param storage_profile: Required.
    :type storage_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersionStorageProfile
    :ivar replication_status:
    :vartype replication_status:
     ~azure.mgmt.compute.v2020_09_30.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'storage_profile': {'required': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryImageVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'GalleryImageVersionStorageProfile'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(self, *, storage_profile, tags=None, publishing_profile=None, **kwargs) -> None:
        super(GalleryImageVersionUpdate, self).__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.replication_status = None


class GalleryOSDiskImage(GalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be
     created.
    :vartype size_in_gb: int
    :param host_caching: The host caching of the disk. Valid values are
     'None', 'ReadOnly', and 'ReadWrite'. Possible values include: 'None',
     'ReadOnly', 'ReadWrite'
    :type host_caching: str or
     ~azure.mgmt.compute.v2020_09_30.models.HostCaching
    :param source:
    :type source:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactVersionSource
    """

    _validation = {
        'size_in_gb': {'readonly': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'HostCaching'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
    }

    def __init__(self, *, host_caching=None, source=None, **kwargs) -> None:
        super(GalleryOSDiskImage, self).__init__(host_caching=host_caching, source=source, **kwargs)


class GalleryUpdate(UpdateResourceDefinition):
    """Specifies information about the Shared Image Gallery that you want to
    update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param description: The description of this Shared Image Gallery resource.
     This property is updatable.
    :type description: str
    :param identifier:
    :type identifier: ~azure.mgmt.compute.v2020_09_30.models.GalleryIdentifier
    :ivar provisioning_state: The current state of the gallery. The
     provisioning state, which only appears in the response. Possible values
     include: 'Creating', 'Updating', 'Failed', 'Succeeded', 'Deleting',
     'Migrating'
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.enum
    :param sharing_profile:
    :type sharing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.SharingProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryIdentifier'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sharing_profile': {'key': 'properties.sharingProfile', 'type': 'SharingProfile'},
    }

    def __init__(self, *, tags=None, description: str=None, identifier=None, sharing_profile=None, **kwargs) -> None:
        super(GalleryUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile


class ImagePurchasePlan(Model):
    """Describes the gallery image definition purchase plan. This is used by
    marketplace images.

    :param name: The plan ID.
    :type name: str
    :param publisher: The publisher ID.
    :type publisher: str
    :param product: The product ID.
    :type product: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, publisher: str=None, product: str=None, **kwargs) -> None:
        super(ImagePurchasePlan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product


class InnerError(Model):
    """Inner error details.

    :param exceptiontype: The exception type.
    :type exceptiontype: str
    :param errordetail: The internal error message or exception dump.
    :type errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(self, *, exceptiontype: str=None, errordetail: str=None, **kwargs) -> None:
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class ManagedArtifact(Model):
    """The managed artifact.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The managed artifact id.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(ManagedArtifact, self).__init__(**kwargs)
        self.id = id


class OSDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for an OS disk image.

    :param disk_encryption_set_id: A relative URI containing the resource ID
     of the disk encryption set.
    :type disk_encryption_set_id: str
    """

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(self, *, disk_encryption_set_id: str=None, **kwargs) -> None:
        super(OSDiskImageEncryption, self).__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)


class PirResource(Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar location: Resource location
    :vartype location: str
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PirResource, self).__init__(**kwargs)
        self.name = None
        self.location = None


class PirSharedGalleryResource(PirResource):
    """Base information about the shared gallery resource in pir.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar location: Resource location
    :vartype location: str
    :param unique_id: The unique id of this shared gallery.
    :type unique_id: str
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'unique_id': {'key': 'identifier.uniqueId', 'type': 'str'},
    }

    def __init__(self, *, unique_id: str=None, **kwargs) -> None:
        super(PirSharedGalleryResource, self).__init__(**kwargs)
        self.unique_id = unique_id


class RecommendedMachineConfiguration(Model):
    """The properties describe the recommended machine configuration for this
    Image Definition. These properties are updatable.

    :param v_cp_us:
    :type v_cp_us: ~azure.mgmt.compute.v2020_09_30.models.ResourceRange
    :param memory:
    :type memory: ~azure.mgmt.compute.v2020_09_30.models.ResourceRange
    """

    _attribute_map = {
        'v_cp_us': {'key': 'vCPUs', 'type': 'ResourceRange'},
        'memory': {'key': 'memory', 'type': 'ResourceRange'},
    }

    def __init__(self, *, v_cp_us=None, memory=None, **kwargs) -> None:
        super(RecommendedMachineConfiguration, self).__init__(**kwargs)
        self.v_cp_us = v_cp_us
        self.memory = memory


class RegionalReplicationStatus(Model):
    """This is the regional replication status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar region: The region to which the gallery image version is being
     replicated to.
    :vartype region: str
    :ivar state: This is the regional replication state. Possible values
     include: 'Unknown', 'Replicating', 'Completed', 'Failed'
    :vartype state: str or
     ~azure.mgmt.compute.v2020_09_30.models.ReplicationState
    :ivar details: The details of the replication status.
    :vartype details: str
    :ivar progress: It indicates progress of the replication job.
    :vartype progress: int
    """

    _validation = {
        'region': {'readonly': True},
        'state': {'readonly': True},
        'details': {'readonly': True},
        'progress': {'readonly': True},
    }

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'progress': {'key': 'progress', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(RegionalReplicationStatus, self).__init__(**kwargs)
        self.region = None
        self.state = None
        self.details = None
        self.progress = None


class ReplicationStatus(Model):
    """This is the replication status of the gallery image version.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar aggregated_state: This is the aggregated replication status based on
     all the regional replication status flags. Possible values include:
     'Unknown', 'InProgress', 'Completed', 'Failed'
    :vartype aggregated_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.AggregatedReplicationState
    :ivar summary: This is a summary of replication status for each region.
    :vartype summary:
     list[~azure.mgmt.compute.v2020_09_30.models.RegionalReplicationStatus]
    """

    _validation = {
        'aggregated_state': {'readonly': True},
        'summary': {'readonly': True},
    }

    _attribute_map = {
        'aggregated_state': {'key': 'aggregatedState', 'type': 'str'},
        'summary': {'key': 'summary', 'type': '[RegionalReplicationStatus]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ReplicationStatus, self).__init__(**kwargs)
        self.aggregated_state = None
        self.summary = None


class ResourceRange(Model):
    """Describes the resource range.

    :param min: The minimum number of the resource.
    :type min: int
    :param max: The maximum number of the resource.
    :type max: int
    """

    _attribute_map = {
        'min': {'key': 'min', 'type': 'int'},
        'max': {'key': 'max', 'type': 'int'},
    }

    def __init__(self, *, min: int=None, max: int=None, **kwargs) -> None:
        super(ResourceRange, self).__init__(**kwargs)
        self.min = min
        self.max = max


class SharedGallery(PirSharedGalleryResource):
    """Specifies information about the Shared Gallery that you want to create or
    update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar location: Resource location
    :vartype location: str
    :param unique_id: The unique id of this shared gallery.
    :type unique_id: str
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'unique_id': {'key': 'identifier.uniqueId', 'type': 'str'},
    }

    def __init__(self, *, unique_id: str=None, **kwargs) -> None:
        super(SharedGallery, self).__init__(unique_id=unique_id, **kwargs)


class SharedGalleryImage(PirSharedGalleryResource):
    """Specifies information about the gallery image definition that you want to
    create or update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Resource name
    :vartype name: str
    :ivar location: Resource location
    :vartype location: str
    :param unique_id: The unique id of this shared gallery.
    :type unique_id: str
    :param os_type: Required. This property allows you to specify the type of
     the OS that is included in the disk when creating a VM from a managed
     image. <br><br> Possible values are: <br><br> **Windows** <br><br>
     **Linux**. Possible values include: 'Windows', 'Linux'
    :type os_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    :param os_state: Required. This property allows the user to specify
     whether the virtual machines created under this image are 'Generalized' or
     'Specialized'. Possible values include: 'Generalized', 'Specialized'
    :type os_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemStateTypes
    :param end_of_life_date: The end of life date of the gallery image
     definition. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    :param identifier: Required.
    :type identifier:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageIdentifier
    :param recommended:
    :type recommended:
     ~azure.mgmt.compute.v2020_09_30.models.RecommendedMachineConfiguration
    :param disallowed:
    :type disallowed: ~azure.mgmt.compute.v2020_09_30.models.Disallowed
    :param hyper_vgeneration: The hypervisor generation of the Virtual
     Machine. Applicable to OS disks only. Possible values include: 'V1', 'V2'
    :type hyper_vgeneration: str or
     ~azure.mgmt.compute.v2020_09_30.models.HyperVGeneration
    :param features: A list of gallery image features.
    :type features:
     list[~azure.mgmt.compute.v2020_09_30.models.GalleryImageFeature]
    :param purchase_plan:
    :type purchase_plan:
     ~azure.mgmt.compute.v2020_09_30.models.ImagePurchasePlan
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
        'os_type': {'required': True},
        'os_state': {'required': True},
        'identifier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'unique_id': {'key': 'identifier.uniqueId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'OperatingSystemTypes'},
        'os_state': {'key': 'properties.osState', 'type': 'OperatingSystemStateTypes'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryImageIdentifier'},
        'recommended': {'key': 'properties.recommended', 'type': 'RecommendedMachineConfiguration'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'Disallowed'},
        'hyper_vgeneration': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[GalleryImageFeature]'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'ImagePurchasePlan'},
    }

    def __init__(self, *, os_type, os_state, identifier, unique_id: str=None, end_of_life_date=None, recommended=None, disallowed=None, hyper_vgeneration=None, features=None, purchase_plan=None, **kwargs) -> None:
        super(SharedGalleryImage, self).__init__(unique_id=unique_id, **kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.hyper_vgeneration = hyper_vgeneration
        self.features = features
        self.purchase_plan = purchase_plan


class SharedGalleryImageVersion(PirSharedGalleryResource):
    """Specifies information about the gallery image version that you want to
    create or update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name
    :vartype name: str
    :ivar location: Resource location
    :vartype location: str
    :param unique_id: The unique id of this shared gallery.
    :type unique_id: str
    :param published_date: The published date of the gallery image version
     Definition. This property can be used for decommissioning purposes. This
     property is updatable.
    :type published_date: datetime
    :param end_of_life_date: The end of life date of the gallery image version
     Definition. This property can be used for decommissioning purposes. This
     property is updatable.
    :type end_of_life_date: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'unique_id': {'key': 'identifier.uniqueId', 'type': 'str'},
        'published_date': {'key': 'properties.publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
    }

    def __init__(self, *, unique_id: str=None, published_date=None, end_of_life_date=None, **kwargs) -> None:
        super(SharedGalleryImageVersion, self).__init__(unique_id=unique_id, **kwargs)
        self.published_date = published_date
        self.end_of_life_date = end_of_life_date


class SharingProfile(Model):
    """Profile for gallery sharing to subscription or tenant.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param permissions: This property allows you to specify the permission of
     sharing gallery. <br><br> Possible values are: <br><br> **Private**
     <br><br> **Groups**. Possible values include: 'Private', 'Groups'
    :type permissions: str or
     ~azure.mgmt.compute.v2020_09_30.models.GallerySharingPermissionTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups:
     list[~azure.mgmt.compute.v2020_09_30.models.SharingProfileGroup]
    """

    _validation = {
        'groups': {'readonly': True},
    }

    _attribute_map = {
        'permissions': {'key': 'permissions', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[SharingProfileGroup]'},
    }

    def __init__(self, *, permissions=None, **kwargs) -> None:
        super(SharingProfile, self).__init__(**kwargs)
        self.permissions = permissions
        self.groups = None


class SharingProfileGroup(Model):
    """Group of the gallery sharing profile.

    :param type: This property allows you to specify the type of sharing
     group. <br><br> Possible values are: <br><br> **Subscriptions** <br><br>
     **AADTenants**. Possible values include: 'Subscriptions', 'AADTenants'
    :type type: str or
     ~azure.mgmt.compute.v2020_09_30.models.SharingProfileGroupTypes
    :param ids: A list of subscription/tenant ids the gallery is aimed to be
     shared to.
    :type ids: list[str]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'ids': {'key': 'ids', 'type': '[str]'},
    }

    def __init__(self, *, type=None, ids=None, **kwargs) -> None:
        super(SharingProfileGroup, self).__init__(**kwargs)
        self.type = type
        self.ids = ids


class SharingUpdate(Model):
    """Specifies information about the gallery sharing profile update.

    All required parameters must be populated in order to send to Azure.

    :param operation_type: Required. This property allows you to specify the
     operation type of gallery sharing update. <br><br> Possible values are:
     <br><br> **Add** <br><br> **Remove** <br><br> **Reset**. Possible values
     include: 'Add', 'Remove', 'Reset'
    :type operation_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.SharingUpdateOperationTypes
    :param groups: A list of sharing profile groups.
    :type groups:
     list[~azure.mgmt.compute.v2020_09_30.models.SharingProfileGroup]
    """

    _validation = {
        'operation_type': {'required': True},
    }

    _attribute_map = {
        'operation_type': {'key': 'operationType', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[SharingProfileGroup]'},
    }

    def __init__(self, *, operation_type, groups=None, **kwargs) -> None:
        super(SharingUpdate, self).__init__(**kwargs)
        self.operation_type = operation_type
        self.groups = groups


class TargetRegion(Model):
    """Describes the target region information.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the region.
    :type name: str
    :param regional_replica_count: The number of replicas of the Image Version
     to be created per region. This property is updatable.
    :type regional_replica_count: int
    :param storage_account_type: Specifies the storage account type to be used
     to store the image. This property is not updatable. Possible values
     include: 'Standard_LRS', 'Standard_ZRS', 'Premium_LRS'
    :type storage_account_type: str or
     ~azure.mgmt.compute.v2020_09_30.models.StorageAccountType
    :param encryption:
    :type encryption: ~azure.mgmt.compute.v2020_09_30.models.EncryptionImages
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'regional_replica_count': {'key': 'regionalReplicaCount', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'encryption': {'key': 'encryption', 'type': 'EncryptionImages'},
    }

    def __init__(self, *, name: str, regional_replica_count: int=None, storage_account_type=None, encryption=None, **kwargs) -> None:
        super(TargetRegion, self).__init__(**kwargs)
        self.name = name
        self.regional_replica_count = regional_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption


class UserArtifactSource(Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :param file_name: Required. Required. The fileName of the artifact.
    :type file_name: str
    :param media_link: Required. Required. The mediaLink of the artifact, must
     be a readable storage blob.
    :type media_link: str
    """

    _validation = {
        'file_name': {'required': True},
        'media_link': {'required': True},
    }

    _attribute_map = {
        'file_name': {'key': 'fileName', 'type': 'str'},
        'media_link': {'key': 'mediaLink', 'type': 'str'},
    }

    def __init__(self, *, file_name: str, media_link: str, **kwargs) -> None:
        super(UserArtifactSource, self).__init__(**kwargs)
        self.file_name = file_name
        self.media_link = media_link
