; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=knl -mattr=+avx512dq | FileCheck %s --check-prefix=ALL --check-prefix=AVX512 --check-prefix=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=knl -mattr=+avx512bw | FileCheck %s --check-prefix=ALL --check-prefix=AVX512 --check-prefix=AVX512BW
;
; Variable Shifts
;

define <8 x i64> @var_shift_v8i64(<8 x i64> %a, <8 x i64> %b) nounwind {
; ALL-LABEL: var_shift_v8i64:
; ALL:       ## BB#0:
; ALL-NEXT:    vpsravq %zmm1, %zmm0, %zmm0
; ALL-NEXT:    retq
  %shift = ashr <8 x i64> %a, %b
  ret <8 x i64> %shift
}

define <16 x i32> @var_shift_v16i32(<16 x i32> %a, <16 x i32> %b) nounwind {
; ALL-LABEL: var_shift_v16i32:
; ALL:       ## BB#0:
; ALL-NEXT:    vpsravd %zmm1, %zmm0, %zmm0
; ALL-NEXT:    retq
  %shift = ashr <16 x i32> %a, %b
  ret <16 x i32> %shift
}

define <32 x i16> @var_shift_v32i16(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512DQ-LABEL: var_shift_v32i16:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vpxor %ymm4, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} ymm5 = ymm2[4],ymm4[4],ymm2[5],ymm4[5],ymm2[6],ymm4[6],ymm2[7],ymm4[7],ymm2[12],ymm4[12],ymm2[13],ymm4[13],ymm2[14],ymm4[14],ymm2[15],ymm4[15]
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} ymm6 = ymm4[4],ymm0[4],ymm4[5],ymm0[5],ymm4[6],ymm0[6],ymm4[7],ymm0[7],ymm4[12],ymm0[12],ymm4[13],ymm0[13],ymm4[14],ymm0[14],ymm4[15],ymm0[15]
; AVX512DQ-NEXT:    vpsravd %ymm5, %ymm6, %ymm5
; AVX512DQ-NEXT:    vpsrld $16, %ymm5, %ymm5
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} ymm2 = ymm2[0],ymm4[0],ymm2[1],ymm4[1],ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[8],ymm4[8],ymm2[9],ymm4[9],ymm2[10],ymm4[10],ymm2[11],ymm4[11]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm4[0],ymm0[0],ymm4[1],ymm0[1],ymm4[2],ymm0[2],ymm4[3],ymm0[3],ymm4[8],ymm0[8],ymm4[9],ymm0[9],ymm4[10],ymm0[10],ymm4[11],ymm0[11]
; AVX512DQ-NEXT:    vpsravd %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpackusdw %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} ymm2 = ymm3[4],ymm4[4],ymm3[5],ymm4[5],ymm3[6],ymm4[6],ymm3[7],ymm4[7],ymm3[12],ymm4[12],ymm3[13],ymm4[13],ymm3[14],ymm4[14],ymm3[15],ymm4[15]
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} ymm5 = ymm4[4],ymm1[4],ymm4[5],ymm1[5],ymm4[6],ymm1[6],ymm4[7],ymm1[7],ymm4[12],ymm1[12],ymm4[13],ymm1[13],ymm4[14],ymm1[14],ymm4[15],ymm1[15]
; AVX512DQ-NEXT:    vpsravd %ymm2, %ymm5, %ymm2
; AVX512DQ-NEXT:    vpsrld $16, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[8],ymm4[8],ymm3[9],ymm4[9],ymm3[10],ymm4[10],ymm3[11],ymm4[11]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm4[0],ymm1[0],ymm4[1],ymm1[1],ymm4[2],ymm1[2],ymm4[3],ymm1[3],ymm4[8],ymm1[8],ymm4[9],ymm1[9],ymm4[10],ymm1[10],ymm4[11],ymm1[11]
; AVX512DQ-NEXT:    vpsravd %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpackusdw %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: var_shift_v32i16:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsravw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <32 x i16> %a, %b
  ret <32 x i16> %shift
}

define <64 x i8> @var_shift_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512DQ-LABEL: var_shift_v64i8:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vpsllw $5, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8],ymm2[8],ymm0[9],ymm2[9],ymm0[10],ymm2[10],ymm0[11],ymm2[11],ymm0[12],ymm2[12],ymm0[13],ymm2[13],ymm0[14],ymm2[14],ymm0[15],ymm2[15],ymm0[24],ymm2[24],ymm0[25],ymm2[25],ymm0[26],ymm2[26],ymm0[27],ymm2[27],ymm0[28],ymm2[28],ymm0[29],ymm2[29],ymm0[30],ymm2[30],ymm0[31],ymm2[31]
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512DQ-NEXT:    vpsraw $4, %ymm5, %ymm6
; AVX512DQ-NEXT:    vpblendvb %ymm4, %ymm6, %ymm5, %ymm5
; AVX512DQ-NEXT:    vpsraw $2, %ymm5, %ymm6
; AVX512DQ-NEXT:    vpaddw %ymm4, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm4, %ymm6, %ymm5, %ymm5
; AVX512DQ-NEXT:    vpsraw $1, %ymm5, %ymm6
; AVX512DQ-NEXT:    vpaddw %ymm4, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm4, %ymm6, %ymm5, %ymm4
; AVX512DQ-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[4],ymm2[4],ymm0[5],ymm2[5],ymm0[6],ymm2[6],ymm0[7],ymm2[7],ymm0[16],ymm2[16],ymm0[17],ymm2[17],ymm0[18],ymm2[18],ymm0[19],ymm2[19],ymm0[20],ymm2[20],ymm0[21],ymm2[21],ymm0[22],ymm2[22],ymm0[23],ymm2[23]
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512DQ-NEXT:    vpsraw $4, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsraw $2, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsraw $1, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsllw $5, %ymm3, %ymm2
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8],ymm2[8],ymm0[9],ymm2[9],ymm0[10],ymm2[10],ymm0[11],ymm2[11],ymm0[12],ymm2[12],ymm0[13],ymm2[13],ymm0[14],ymm2[14],ymm0[15],ymm2[15],ymm0[24],ymm2[24],ymm0[25],ymm2[25],ymm0[26],ymm2[26],ymm0[27],ymm2[27],ymm0[28],ymm2[28],ymm0[29],ymm2[29],ymm0[30],ymm2[30],ymm0[31],ymm2[31]
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8],ymm1[8],ymm0[9],ymm1[9],ymm0[10],ymm1[10],ymm0[11],ymm1[11],ymm0[12],ymm1[12],ymm0[13],ymm1[13],ymm0[14],ymm1[14],ymm0[15],ymm1[15],ymm0[24],ymm1[24],ymm0[25],ymm1[25],ymm0[26],ymm1[26],ymm0[27],ymm1[27],ymm0[28],ymm1[28],ymm0[29],ymm1[29],ymm0[30],ymm1[30],ymm0[31],ymm1[31]
; AVX512DQ-NEXT:    vpsraw $4, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpsraw $2, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm3, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpsraw $1, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm3, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm3
; AVX512DQ-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[4],ymm2[4],ymm0[5],ymm2[5],ymm0[6],ymm2[6],ymm0[7],ymm2[7],ymm0[16],ymm2[16],ymm0[17],ymm2[17],ymm0[18],ymm2[18],ymm0[19],ymm2[19],ymm0[20],ymm2[20],ymm0[21],ymm2[21],ymm0[22],ymm2[22],ymm0[23],ymm2[23]
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[4],ymm1[4],ymm0[5],ymm1[5],ymm0[6],ymm1[6],ymm0[7],ymm1[7],ymm0[16],ymm1[16],ymm0[17],ymm1[17],ymm0[18],ymm1[18],ymm0[19],ymm1[19],ymm0[20],ymm1[20],ymm0[21],ymm1[21],ymm0[22],ymm1[22],ymm0[23],ymm1[23]
; AVX512DQ-NEXT:    vpsraw $4, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsraw $2, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsraw $1, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpaddw %ymm2, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: var_shift_v64i8:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm1, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm2, %ecx
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm0, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm3, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $0, %xmm3, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %dl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm4
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $2, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $2, %xmm3, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $3, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $3, %xmm3, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $4, %xmm3, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $5, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $5, %xmm3, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $6, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $6, %xmm3, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $7, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $7, %xmm3, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $8, %xmm3, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $9, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $9, %xmm3, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $10, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $10, %xmm3, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $11, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $11, %xmm3, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $12, %xmm3, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $13, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $13, %xmm3, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $14, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $14, %xmm3, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $15, %xmm2, %ecx
; AVX512BW-NEXT:    vpextrb $15, %xmm3, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm4, %xmm2
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm1, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm3, %ecx
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm4
; AVX512BW-NEXT:    vpextrb $1, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $0, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $0, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    movzbl %dl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm5
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $2, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $2, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $3, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $3, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $4, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $4, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $5, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $5, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $6, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $6, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $7, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $7, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $8, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $8, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $9, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $9, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $10, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $10, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $11, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $11, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $12, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $12, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $13, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $13, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $14, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $14, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $15, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $15, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm1, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm3, %ecx
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm0, %xmm4
; AVX512BW-NEXT:    vpextrb $1, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm5, %ymm2
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $0, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpextrb $2, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $2, %xmm4, %esi
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %sil
; AVX512BW-NEXT:    movzbl %dl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm5
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %sil, %eax
; AVX512BW-NEXT:    vpextrb $3, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $3, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $4, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $4, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $5, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $5, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $6, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $6, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $7, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $7, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $8, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $8, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $9, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $9, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $10, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $10, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $11, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $11, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $12, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $12, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $13, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $13, %xmm4, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $14, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $14, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $15, %xmm3, %ecx
; AVX512BW-NEXT:    vpextrb $15, %xmm4, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm5, %xmm3
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $1, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $1, %xmm0, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpextrb $0, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $0, %xmm0, %esi
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %sil
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    movzbl %sil, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm4
; AVX512BW-NEXT:    vpextrb $2, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $2, %xmm0, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $3, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $3, %xmm0, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $4, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $4, %xmm0, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $5, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $5, %xmm0, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $6, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $6, %xmm0, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $7, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $7, %xmm0, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $8, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $9, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $9, %xmm0, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $10, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $10, %xmm0, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $11, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $11, %xmm0, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $12, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $12, %xmm0, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $13, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $13, %xmm0, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $14, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $14, %xmm0, %edx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $15, %xmm1, %ecx
; AVX512BW-NEXT:    vpextrb $15, %xmm0, %eax
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm4, %xmm0
; AVX512BW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <64 x i8> %a, %b
  ret <64 x i8> %shift
}

;
; Uniform Variable Shifts
;

define <8 x i64> @splatvar_shift_v8i64(<8 x i64> %a, <8 x i64> %b) nounwind {
; ALL-LABEL: splatvar_shift_v8i64:
; ALL:       ## BB#0:
; ALL-NEXT:    vpsraq %xmm1, %zmm0, %zmm0
; ALL-NEXT:    retq
  %splat = shufflevector <8 x i64> %b, <8 x i64> undef, <8 x i32> zeroinitializer
  %shift = ashr <8 x i64> %a, %splat
  ret <8 x i64> %shift
}

define <16 x i32> @splatvar_shift_v16i32(<16 x i32> %a, <16 x i32> %b) nounwind {
; ALL-LABEL: splatvar_shift_v16i32:
; ALL:       ## BB#0:
; ALL-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; ALL-NEXT:    vmovss {{.*#+}} xmm1 = xmm1[0],xmm2[1,2,3]
; ALL-NEXT:    vpsrad %xmm1, %zmm0, %zmm0
; ALL-NEXT:    retq
  %splat = shufflevector <16 x i32> %b, <16 x i32> undef, <16 x i32> zeroinitializer
  %shift = ashr <16 x i32> %a, %splat
  ret <16 x i32> %shift
}

define <32 x i16> @splatvar_shift_v32i16(<32 x i16> %a, <32 x i16> %b) nounwind {
; AVX512DQ-LABEL: splatvar_shift_v32i16:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vpextrw $0, %xmm2, %eax
; AVX512DQ-NEXT:    vmovd %eax, %xmm2
; AVX512DQ-NEXT:    vpsraw %xmm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsraw %xmm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_shift_v32i16:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpextrw $0, %xmm1, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm1
; AVX512BW-NEXT:    vpsraw %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %splat = shufflevector <32 x i16> %b, <32 x i16> undef, <32 x i32> zeroinitializer
  %shift = ashr <32 x i16> %a, %splat
  ret <32 x i16> %shift
}

define <64 x i8> @splatvar_shift_v64i8(<64 x i8> %a, <64 x i8> %b) nounwind {
; AVX512DQ-LABEL: splatvar_shift_v64i8:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX512DQ-NEXT:    vpsllw $5, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8],ymm2[8],ymm0[9],ymm2[9],ymm0[10],ymm2[10],ymm0[11],ymm2[11],ymm0[12],ymm2[12],ymm0[13],ymm2[13],ymm0[14],ymm2[14],ymm0[15],ymm2[15],ymm0[24],ymm2[24],ymm0[25],ymm2[25],ymm0[26],ymm2[26],ymm0[27],ymm2[27],ymm0[28],ymm2[28],ymm0[29],ymm2[29],ymm0[30],ymm2[30],ymm0[31],ymm2[31]
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512DQ-NEXT:    vpsraw $4, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpsraw $2, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm3, %ymm3, %ymm6
; AVX512DQ-NEXT:    vpblendvb %ymm6, %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpsraw $1, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm6, %ymm6, %ymm7
; AVX512DQ-NEXT:    vpblendvb %ymm7, %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[4],ymm2[4],ymm0[5],ymm2[5],ymm0[6],ymm2[6],ymm0[7],ymm2[7],ymm0[16],ymm2[16],ymm0[17],ymm2[17],ymm0[18],ymm2[18],ymm0[19],ymm2[19],ymm0[20],ymm2[20],ymm0[21],ymm2[21],ymm0[22],ymm2[22],ymm0[23],ymm2[23]
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512DQ-NEXT:    vpsraw $4, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsraw $2, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm2, %ymm2, %ymm8
; AVX512DQ-NEXT:    vpblendvb %ymm8, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsraw $1, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm8, %ymm8, %ymm9
; AVX512DQ-NEXT:    vpblendvb %ymm9, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8],ymm1[8],ymm0[9],ymm1[9],ymm0[10],ymm1[10],ymm0[11],ymm1[11],ymm0[12],ymm1[12],ymm0[13],ymm1[13],ymm0[14],ymm1[14],ymm0[15],ymm1[15],ymm0[24],ymm1[24],ymm0[25],ymm1[25],ymm0[26],ymm1[26],ymm0[27],ymm1[27],ymm0[28],ymm1[28],ymm0[29],ymm1[29],ymm0[30],ymm1[30],ymm0[31],ymm1[31]
; AVX512DQ-NEXT:    vpsraw $4, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm3
; AVX512DQ-NEXT:    vpsraw $2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpsraw $1, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm7, %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[4],ymm1[4],ymm0[5],ymm1[5],ymm0[6],ymm1[6],ymm0[7],ymm1[7],ymm0[16],ymm1[16],ymm0[17],ymm1[17],ymm0[18],ymm1[18],ymm0[19],ymm1[19],ymm0[20],ymm1[20],ymm0[21],ymm1[21],ymm0[22],ymm1[22],ymm0[23],ymm1[23]
; AVX512DQ-NEXT:    vpsraw $4, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsraw $2, %ymm1, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm8, %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsraw $1, %ymm1, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm9, %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_shift_v64i8:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpbroadcastb %xmm1, %zmm1
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm2, %eax
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm1, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %edx
; AVX512BW-NEXT:    vpextrb $0, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %dl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm4
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $2, %xmm2, %eax
; AVX512BW-NEXT:    vpextrb $2, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $3, %xmm2, %edx
; AVX512BW-NEXT:    vpextrb $3, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %edx
; AVX512BW-NEXT:    vpextrb $4, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $5, %xmm2, %eax
; AVX512BW-NEXT:    vpextrb $5, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $6, %xmm2, %eax
; AVX512BW-NEXT:    vpextrb $6, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $7, %xmm2, %edx
; AVX512BW-NEXT:    vpextrb $7, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %edx
; AVX512BW-NEXT:    vpextrb $8, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $9, %xmm2, %eax
; AVX512BW-NEXT:    vpextrb $9, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $10, %xmm2, %eax
; AVX512BW-NEXT:    vpextrb $10, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $11, %xmm2, %edx
; AVX512BW-NEXT:    vpextrb $11, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %edx
; AVX512BW-NEXT:    vpextrb $12, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $13, %xmm2, %eax
; AVX512BW-NEXT:    vpextrb $13, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $14, %xmm2, %eax
; AVX512BW-NEXT:    vpextrb $14, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $15, %xmm2, %edx
; AVX512BW-NEXT:    vpextrb $15, %xmm3, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm4, %xmm2
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm3, %eax
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm1, %xmm4
; AVX512BW-NEXT:    vpextrb $1, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $0, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $0, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    movzbl %dl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm5
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $2, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $2, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $3, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $3, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $4, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $4, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $5, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $5, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $6, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $6, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $7, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $7, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $8, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $8, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $9, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $9, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $10, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $10, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $11, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $11, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $12, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $12, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $13, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $13, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $14, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $14, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $15, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $15, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm0, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm3, %eax
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm1, %xmm4
; AVX512BW-NEXT:    vpextrb $1, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm5, %ymm2
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpextrb $0, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $0, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpextrb $2, %xmm3, %esi
; AVX512BW-NEXT:    vpextrb $2, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %sil
; AVX512BW-NEXT:    movzbl %dl, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm5
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %sil, %eax
; AVX512BW-NEXT:    vpextrb $3, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $3, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $4, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $4, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $5, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $5, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $6, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $6, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $7, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $7, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $8, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $8, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $9, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $9, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $10, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $10, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $11, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $11, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $12, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $12, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    vpextrb $13, %xmm3, %eax
; AVX512BW-NEXT:    vpextrb $13, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $14, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $14, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm5, %xmm5
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $15, %xmm3, %edx
; AVX512BW-NEXT:    vpextrb $15, %xmm4, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm5, %xmm3
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $1, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $1, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpextrb $0, %xmm0, %esi
; AVX512BW-NEXT:    vpextrb $0, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %sil
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    movzbl %sil, %ecx
; AVX512BW-NEXT:    vmovd %ecx, %xmm4
; AVX512BW-NEXT:    vpextrb $2, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $2, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $3, %xmm0, %eax
; AVX512BW-NEXT:    vpextrb $3, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $4, %xmm0, %eax
; AVX512BW-NEXT:    vpextrb $4, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $5, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $5, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $6, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $6, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $7, %xmm0, %eax
; AVX512BW-NEXT:    vpextrb $7, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BW-NEXT:    vpextrb $8, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $9, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $9, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $10, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $10, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $11, %xmm0, %eax
; AVX512BW-NEXT:    vpextrb $11, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $12, %xmm0, %eax
; AVX512BW-NEXT:    vpextrb $12, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    vpextrb $13, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $13, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpextrb $14, %xmm0, %edx
; AVX512BW-NEXT:    vpextrb $14, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %dl
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    movzbl %dl, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm4, %xmm4
; AVX512BW-NEXT:    vpextrb $15, %xmm0, %eax
; AVX512BW-NEXT:    vpextrb $15, %xmm1, %ecx
; AVX512BW-NEXT:    ## kill: %CL<def> %CL<kill> %ECX<kill>
; AVX512BW-NEXT:    sarb %cl, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm4, %xmm0
; AVX512BW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %splat = shufflevector <64 x i8> %b, <64 x i8> undef, <64 x i32> zeroinitializer
  %shift = ashr <64 x i8> %a, %splat
  ret <64 x i8> %shift
}

;
; Constant Shifts
;

define <8 x i64> @constant_shift_v8i64(<8 x i64> %a) nounwind {
; ALL-LABEL: constant_shift_v8i64:
; ALL:       ## BB#0:
; ALL-NEXT:    vpsravq {{.*}}(%rip), %zmm0, %zmm0
; ALL-NEXT:    retq
  %shift = ashr <8 x i64> %a, <i64 1, i64 7, i64 31, i64 62, i64 1, i64 7, i64 31, i64 62>
  ret <8 x i64> %shift
}

define <16 x i32> @constant_shift_v16i32(<16 x i32> %a) nounwind {
; ALL-LABEL: constant_shift_v16i32:
; ALL:       ## BB#0:
; ALL-NEXT:    vpsravd {{.*}}(%rip), %zmm0, %zmm0
; ALL-NEXT:    retq
  %shift = ashr <16 x i32> %a, <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 8, i32 7, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 8, i32 7>
  ret <16 x i32> %shift
}

define <32 x i16> @constant_shift_v32i16(<32 x i16> %a) nounwind {
; AVX512DQ-LABEL: constant_shift_v32i16:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} ymm4 = ymm3[4],ymm2[4],ymm3[5],ymm2[5],ymm3[6],ymm2[6],ymm3[7],ymm2[7],ymm3[12],ymm2[12],ymm3[13],ymm2[13],ymm3[14],ymm2[14],ymm3[15],ymm2[15]
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} ymm5 = ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15]
; AVX512DQ-NEXT:    vpsravd %ymm4, %ymm5, %ymm5
; AVX512DQ-NEXT:    vpsrld $16, %ymm5, %ymm5
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} ymm3 = ymm3[0],ymm2[0],ymm3[1],ymm2[1],ymm3[2],ymm2[2],ymm3[3],ymm2[3],ymm3[8],ymm2[8],ymm3[9],ymm2[9],ymm3[10],ymm2[10],ymm3[11],ymm2[11]
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} ymm0 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11]
; AVX512DQ-NEXT:    vpsravd %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrld $16, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpackusdw %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpckhwd {{.*#+}} ymm5 = ymm2[4],ymm1[4],ymm2[5],ymm1[5],ymm2[6],ymm1[6],ymm2[7],ymm1[7],ymm2[12],ymm1[12],ymm2[13],ymm1[13],ymm2[14],ymm1[14],ymm2[15],ymm1[15]
; AVX512DQ-NEXT:    vpsravd %ymm4, %ymm5, %ymm4
; AVX512DQ-NEXT:    vpsrld $16, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpunpcklwd {{.*#+}} ymm1 = ymm2[0],ymm1[0],ymm2[1],ymm1[1],ymm2[2],ymm1[2],ymm2[3],ymm1[3],ymm2[8],ymm1[8],ymm2[9],ymm1[9],ymm2[10],ymm1[10],ymm2[11],ymm1[11]
; AVX512DQ-NEXT:    vpsravd %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsrld $16, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpackusdw %ymm4, %ymm1, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: constant_shift_v32i16:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsravw {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <32 x i16> %a, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15, i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  ret <32 x i16> %shift
}

define <64 x i8> @constant_shift_v64i8(<64 x i8> %a) nounwind {
; AVX512DQ-LABEL: constant_shift_v64i8:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,2,3,4,5,6,7,7,6,5,4,3,2,1,0,0,1,2,3,4,5,6,7,7,6,5,4,3,2,1,0]
; AVX512DQ-NEXT:    vpsllw $5, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8],ymm2[8],ymm0[9],ymm2[9],ymm0[10],ymm2[10],ymm0[11],ymm2[11],ymm0[12],ymm2[12],ymm0[13],ymm2[13],ymm0[14],ymm2[14],ymm0[15],ymm2[15],ymm0[24],ymm2[24],ymm0[25],ymm2[25],ymm0[26],ymm2[26],ymm0[27],ymm2[27],ymm0[28],ymm2[28],ymm0[29],ymm2[29],ymm0[30],ymm2[30],ymm0[31],ymm2[31]
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512DQ-NEXT:    vpsraw $4, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpsraw $2, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm3, %ymm3, %ymm6
; AVX512DQ-NEXT:    vpblendvb %ymm6, %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpsraw $1, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm6, %ymm6, %ymm7
; AVX512DQ-NEXT:    vpblendvb %ymm7, %ymm5, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[4],ymm2[4],ymm0[5],ymm2[5],ymm0[6],ymm2[6],ymm0[7],ymm2[7],ymm0[16],ymm2[16],ymm0[17],ymm2[17],ymm0[18],ymm2[18],ymm0[19],ymm2[19],ymm0[20],ymm2[20],ymm0[21],ymm2[21],ymm0[22],ymm2[22],ymm0[23],ymm2[23]
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512DQ-NEXT:    vpsraw $4, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsraw $2, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm2, %ymm2, %ymm8
; AVX512DQ-NEXT:    vpblendvb %ymm8, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsraw $1, %ymm0, %ymm5
; AVX512DQ-NEXT:    vpaddw %ymm8, %ymm8, %ymm9
; AVX512DQ-NEXT:    vpblendvb %ymm9, %ymm5, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8],ymm1[8],ymm0[9],ymm1[9],ymm0[10],ymm1[10],ymm0[11],ymm1[11],ymm0[12],ymm1[12],ymm0[13],ymm1[13],ymm0[14],ymm1[14],ymm0[15],ymm1[15],ymm0[24],ymm1[24],ymm0[25],ymm1[25],ymm0[26],ymm1[26],ymm0[27],ymm1[27],ymm0[28],ymm1[28],ymm0[29],ymm1[29],ymm0[30],ymm1[30],ymm0[31],ymm1[31]
; AVX512DQ-NEXT:    vpsraw $4, %ymm4, %ymm5
; AVX512DQ-NEXT:    vpblendvb %ymm3, %ymm5, %ymm4, %ymm3
; AVX512DQ-NEXT:    vpsraw $2, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpsraw $1, %ymm3, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm7, %ymm4, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512DQ-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[4],ymm1[4],ymm0[5],ymm1[5],ymm0[6],ymm1[6],ymm0[7],ymm1[7],ymm0[16],ymm1[16],ymm0[17],ymm1[17],ymm0[18],ymm1[18],ymm0[19],ymm1[19],ymm0[20],ymm1[20],ymm0[21],ymm1[21],ymm0[22],ymm1[22],ymm0[23],ymm1[23]
; AVX512DQ-NEXT:    vpsraw $4, %ymm1, %ymm4
; AVX512DQ-NEXT:    vpblendvb %ymm2, %ymm4, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsraw $2, %ymm1, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm8, %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsraw $1, %ymm1, %ymm2
; AVX512DQ-NEXT:    vpblendvb %ymm9, %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: constant_shift_v64i8:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; AVX512BW-NEXT:    vpextrb $0, %xmm1, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm2
; AVX512BW-NEXT:    vpextrb $1, %xmm1, %eax
; AVX512BW-NEXT:    sarb %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $2, %xmm1, %eax
; AVX512BW-NEXT:    sarb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $3, %xmm1, %eax
; AVX512BW-NEXT:    sarb $3, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $4, %xmm1, %eax
; AVX512BW-NEXT:    sarb $4, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $5, %xmm1, %eax
; AVX512BW-NEXT:    sarb $5, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $6, %xmm1, %eax
; AVX512BW-NEXT:    sarb $6, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $7, %xmm1, %eax
; AVX512BW-NEXT:    sarb $7, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $8, %xmm1, %eax
; AVX512BW-NEXT:    sarb $7, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $9, %xmm1, %eax
; AVX512BW-NEXT:    sarb $6, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $10, %xmm1, %eax
; AVX512BW-NEXT:    sarb $5, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $11, %xmm1, %eax
; AVX512BW-NEXT:    sarb $4, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $12, %xmm1, %eax
; AVX512BW-NEXT:    sarb $3, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $13, %xmm1, %eax
; AVX512BW-NEXT:    sarb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $14, %xmm1, %eax
; AVX512BW-NEXT:    sarb %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm2, %xmm2
; AVX512BW-NEXT:    vpextrb $15, %xmm1, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm2, %xmm1
; AVX512BW-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm2, %eax
; AVX512BW-NEXT:    sarb %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm2, %eax
; AVX512BW-NEXT:    sarb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm2, %eax
; AVX512BW-NEXT:    sarb $3, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %eax
; AVX512BW-NEXT:    sarb $4, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm2, %eax
; AVX512BW-NEXT:    sarb $5, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm2, %eax
; AVX512BW-NEXT:    sarb $6, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm2, %eax
; AVX512BW-NEXT:    sarb $7, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BW-NEXT:    sarb $7, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm2, %eax
; AVX512BW-NEXT:    sarb $6, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm2, %eax
; AVX512BW-NEXT:    sarb $5, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm2, %eax
; AVX512BW-NEXT:    sarb $4, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %eax
; AVX512BW-NEXT:    sarb $3, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm2, %eax
; AVX512BW-NEXT:    sarb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm2, %eax
; AVX512BW-NEXT:    sarb %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm2
; AVX512BW-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512BW-NEXT:    vextracti32x4 $1, %zmm0, %xmm2
; AVX512BW-NEXT:    vpextrb $0, %xmm2, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm2, %eax
; AVX512BW-NEXT:    sarb %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm2, %eax
; AVX512BW-NEXT:    sarb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm2, %eax
; AVX512BW-NEXT:    sarb $3, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm2, %eax
; AVX512BW-NEXT:    sarb $4, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm2, %eax
; AVX512BW-NEXT:    sarb $5, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm2, %eax
; AVX512BW-NEXT:    sarb $6, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm2, %eax
; AVX512BW-NEXT:    sarb $7, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm2, %eax
; AVX512BW-NEXT:    sarb $7, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm2, %eax
; AVX512BW-NEXT:    sarb $6, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm2, %eax
; AVX512BW-NEXT:    sarb $5, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm2, %eax
; AVX512BW-NEXT:    sarb $4, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm2, %eax
; AVX512BW-NEXT:    sarb $3, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm2, %eax
; AVX512BW-NEXT:    sarb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm2, %eax
; AVX512BW-NEXT:    sarb %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm2, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm2
; AVX512BW-NEXT:    vpextrb $0, %xmm0, %eax
; AVX512BW-NEXT:    vmovd %eax, %xmm3
; AVX512BW-NEXT:    vpextrb $1, %xmm0, %eax
; AVX512BW-NEXT:    sarb %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $1, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $2, %xmm0, %eax
; AVX512BW-NEXT:    sarb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $2, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $3, %xmm0, %eax
; AVX512BW-NEXT:    sarb $3, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $3, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $4, %xmm0, %eax
; AVX512BW-NEXT:    sarb $4, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $4, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $5, %xmm0, %eax
; AVX512BW-NEXT:    sarb $5, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $5, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $6, %xmm0, %eax
; AVX512BW-NEXT:    sarb $6, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $6, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $7, %xmm0, %eax
; AVX512BW-NEXT:    sarb $7, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $7, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $8, %xmm0, %eax
; AVX512BW-NEXT:    sarb $7, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $8, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $9, %xmm0, %eax
; AVX512BW-NEXT:    sarb $6, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $9, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $10, %xmm0, %eax
; AVX512BW-NEXT:    sarb $5, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $10, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $11, %xmm0, %eax
; AVX512BW-NEXT:    sarb $4, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $11, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $12, %xmm0, %eax
; AVX512BW-NEXT:    sarb $3, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $12, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $13, %xmm0, %eax
; AVX512BW-NEXT:    sarb $2, %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $13, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $14, %xmm0, %eax
; AVX512BW-NEXT:    sarb %al
; AVX512BW-NEXT:    movzbl %al, %eax
; AVX512BW-NEXT:    vpinsrb $14, %eax, %xmm3, %xmm3
; AVX512BW-NEXT:    vpextrb $15, %xmm0, %eax
; AVX512BW-NEXT:    vpinsrb $15, %eax, %xmm3, %xmm0
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <64 x i8> %a, <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0>
  ret <64 x i8> %shift
}

;
; Uniform Constant Shifts
;

define <8 x i64> @splatconstant_shift_v8i64(<8 x i64> %a) nounwind {
; ALL-LABEL: splatconstant_shift_v8i64:
; ALL:       ## BB#0:
; ALL-NEXT:    vpsraq $7, %zmm0, %zmm0
; ALL-NEXT:    retq
  %shift = ashr <8 x i64> %a, <i64 7, i64 7, i64 7, i64 7, i64 7, i64 7, i64 7, i64 7>
  ret <8 x i64> %shift
}

define <16 x i32> @splatconstant_shift_v16i32(<16 x i32> %a) nounwind {
; ALL-LABEL: splatconstant_shift_v16i32:
; ALL:       ## BB#0:
; ALL-NEXT:    vpsrad $5, %zmm0, %zmm0
; ALL-NEXT:    retq
  %shift = ashr <16 x i32> %a, <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>
  ret <16 x i32> %shift
}

define <32 x i16> @splatconstant_shift_v32i16(<32 x i16> %a) nounwind {
; AVX512DQ-LABEL: splatconstant_shift_v32i16:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vpsraw $3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsraw $3, %ymm1, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_shift_v32i16:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsraw $3, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <32 x i16> %a, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <32 x i16> %shift
}

define <64 x i8> @splatconstant_shift_v64i8(<64 x i8> %a) nounwind {
; AVX512DQ-LABEL: splatconstant_shift_v64i8:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vpsrlw $3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm2 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; AVX512DQ-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX512DQ-NEXT:    vmovdqa {{.*#+}} ymm3 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512DQ-NEXT:    vpxor %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpsrlw $3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_shift_v64i8:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpsrlw $3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512BW-NEXT:    vpxorq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsubb %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
  %shift = ashr <64 x i8> %a, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  ret <64 x i8> %shift
}

define <64 x i8> @ashr_const7_v64i8(<64 x i8> %a) {
; AVX512DQ-LABEL: ashr_const7_v64i8:
; AVX512DQ:       ## BB#0:
; AVX512DQ-NEXT:    vpxor %ymm2, %ymm2, %ymm2
; AVX512DQ-NEXT:    vpcmpgtb %ymm0, %ymm2, %ymm0
; AVX512DQ-NEXT:    vpcmpgtb %ymm1, %ymm2, %ymm1
; AVX512DQ-NEXT:    retq
;
; AVX512BW-LABEL: ashr_const7_v64i8:
; AVX512BW:       ## BB#0:
; AVX512BW-NEXT:    vpxord %zmm1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpcmpgtb %zmm0, %zmm1, %k0
; AVX512BW-NEXT:    vpmovm2b %k0, %zmm0
; AVX512BW-NEXT:    retq
  %res = ashr <64 x i8> %a, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  ret <64 x i8> %res
}
