# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.policy.v2019_09_01.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.policy.v2019_09_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the resource identity.
    :vartype tenant_id: str
    :ivar type: The identity type. This is the only required field when adding a system assigned
     identity to a resource. Known values are: "SystemAssigned" and "None".
    :vartype type: str or ~azure.mgmt.resource.policy.v2019_09_01.models.ResourceIdentityType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.ResourceIdentityType"]] = None, **kwargs):
        """
        :keyword type: The identity type. This is the only required field when adding a system assigned
         identity to a resource. Known values are: "SystemAssigned" and "None".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2019_09_01.models.ResourceIdentityType
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ParameterDefinitionsValue(_serialization.Model):
    """The definition of a parameter that can be provided to the policy.

    :ivar type: The data type of the parameter. Known values are: "String", "Array", "Object",
     "Boolean", "Integer", "Float", and "DateTime".
    :vartype type: str or ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterType
    :ivar allowed_values: The allowed values for the parameter.
    :vartype allowed_values: list[JSON]
    :ivar default_value: The default value for the parameter if no value is provided.
    :vartype default_value: JSON
    :ivar metadata: General metadata for the parameter.
    :vartype metadata:
     ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterDefinitionsValueMetadata
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "allowed_values": {"key": "allowedValues", "type": "[object]"},
        "default_value": {"key": "defaultValue", "type": "object"},
        "metadata": {"key": "metadata", "type": "ParameterDefinitionsValueMetadata"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ParameterType"]] = None,
        allowed_values: Optional[List[JSON]] = None,
        default_value: Optional[JSON] = None,
        metadata: Optional["_models.ParameterDefinitionsValueMetadata"] = None,
        **kwargs
    ):
        """
        :keyword type: The data type of the parameter. Known values are: "String", "Array", "Object",
         "Boolean", "Integer", "Float", and "DateTime".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterType
        :keyword allowed_values: The allowed values for the parameter.
        :paramtype allowed_values: list[JSON]
        :keyword default_value: The default value for the parameter if no value is provided.
        :paramtype default_value: JSON
        :keyword metadata: General metadata for the parameter.
        :paramtype metadata:
         ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterDefinitionsValueMetadata
        """
        super().__init__(**kwargs)
        self.type = type
        self.allowed_values = allowed_values
        self.default_value = default_value
        self.metadata = metadata


class ParameterDefinitionsValueMetadata(_serialization.Model):
    """General metadata for the parameter.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar display_name: The display name for the parameter.
    :vartype display_name: str
    :ivar description: The description of the parameter.
    :vartype description: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword display_name: The display name for the parameter.
        :paramtype display_name: str
        :keyword description: The description of the parameter.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.display_name = display_name
        self.description = description


class ParameterValuesValue(_serialization.Model):
    """The value of a parameter.

    :ivar value: The value of the parameter.
    :vartype value: JSON
    """

    _attribute_map = {
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, value: Optional[JSON] = None, **kwargs):
        """
        :keyword value: The value of the parameter.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.value = value


class PolicyAssignment(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The policy assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy assignment.
    :vartype id: str
    :ivar type: The type of the policy assignment.
    :vartype type: str
    :ivar name: The name of the policy assignment.
    :vartype name: str
    :ivar sku: The policy sku. This property is optional, obsolete, and will be ignored.
    :vartype sku: ~azure.mgmt.resource.policy.v2019_09_01.models.PolicySku
    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.v2019_09_01.models.Identity
    :ivar display_name: The display name of the policy assignment.
    :vartype display_name: str
    :ivar policy_definition_id: The ID of the policy definition or policy set definition being
     assigned.
    :vartype policy_definition_id: str
    :ivar scope: The scope for the policy assignment.
    :vartype scope: str
    :ivar not_scopes: The policy's excluded scopes.
    :vartype not_scopes: list[str]
    :ivar parameters: The parameter values for the assigned policy rule. The keys are the parameter
     names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterValuesValue]
    :ivar description: This message will be part of response in case of policy violation.
    :vartype description: str
    :ivar metadata: The policy assignment metadata. Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar enforcement_mode: The policy assignment enforcement mode. Possible values are Default and
     DoNotEnforce. Known values are: "Default" and "DoNotEnforce".
    :vartype enforcement_mode: str or
     ~azure.mgmt.resource.policy.v2019_09_01.models.EnforcementMode
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "PolicySku"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "not_scopes": {"key": "properties.notScopes", "type": "[str]"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterValuesValue}"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "enforcement_mode": {"key": "properties.enforcementMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.PolicySku"] = None,
        location: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        display_name: Optional[str] = None,
        policy_definition_id: Optional[str] = None,
        scope: Optional[str] = None,
        not_scopes: Optional[List[str]] = None,
        parameters: Optional[Dict[str, "_models.ParameterValuesValue"]] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        enforcement_mode: Optional[Union[str, "_models.EnforcementMode"]] = None,
        **kwargs
    ):
        """
        :keyword sku: The policy sku. This property is optional, obsolete, and will be ignored.
        :paramtype sku: ~azure.mgmt.resource.policy.v2019_09_01.models.PolicySku
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.v2019_09_01.models.Identity
        :keyword display_name: The display name of the policy assignment.
        :paramtype display_name: str
        :keyword policy_definition_id: The ID of the policy definition or policy set definition being
         assigned.
        :paramtype policy_definition_id: str
        :keyword scope: The scope for the policy assignment.
        :paramtype scope: str
        :keyword not_scopes: The policy's excluded scopes.
        :paramtype not_scopes: list[str]
        :keyword parameters: The parameter values for the assigned policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterValuesValue]
        :keyword description: This message will be part of response in case of policy violation.
        :paramtype description: str
        :keyword metadata: The policy assignment metadata. Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword enforcement_mode: The policy assignment enforcement mode. Possible values are Default
         and DoNotEnforce. Known values are: "Default" and "DoNotEnforce".
        :paramtype enforcement_mode: str or
         ~azure.mgmt.resource.policy.v2019_09_01.models.EnforcementMode
        """
        super().__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.sku = sku
        self.location = location
        self.identity = identity
        self.display_name = display_name
        self.policy_definition_id = policy_definition_id
        self.scope = scope
        self.not_scopes = not_scopes
        self.parameters = parameters
        self.description = description
        self.metadata = metadata
        self.enforcement_mode = enforcement_mode


class PolicyAssignmentListResult(_serialization.Model):
    """List of policy assignments.

    :ivar value: An array of policy assignments.
    :vartype value: list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicyAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PolicyAssignment"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: An array of policy assignments.
        :paramtype value: list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicyAssignment]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyDefinition(_serialization.Model):
    """The policy definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy definition.
    :vartype id: str
    :ivar name: The name of the policy definition.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policyDefinitions).
    :vartype type: str
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.v2019_09_01.models.PolicyType
    :ivar mode: The policy definition mode. Some examples are All, Indexed,
     Microsoft.KeyVault.Data.
    :vartype mode: str
    :ivar display_name: The display name of the policy definition.
    :vartype display_name: str
    :ivar description: The policy definition description.
    :vartype description: str
    :ivar policy_rule: The policy rule.
    :vartype policy_rule: JSON
    :ivar metadata: The policy definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The parameter definitions for parameters used in the policy rule. The keys
     are the parameter names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterDefinitionsValue]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "policy_rule": {"key": "properties.policyRule", "type": "object"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        mode: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        policy_rule: Optional[JSON] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterDefinitionsValue"]] = None,
        **kwargs
    ):
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.v2019_09_01.models.PolicyType
        :keyword mode: The policy definition mode. Some examples are All, Indexed,
         Microsoft.KeyVault.Data.
        :paramtype mode: str
        :keyword display_name: The display name of the policy definition.
        :paramtype display_name: str
        :keyword description: The policy definition description.
        :paramtype description: str
        :keyword policy_rule: The policy rule.
        :paramtype policy_rule: JSON
        :keyword metadata: The policy definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The parameter definitions for parameters used in the policy rule. The keys
         are the parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterDefinitionsValue]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.policy_type = policy_type
        self.mode = mode
        self.display_name = display_name
        self.description = description
        self.policy_rule = policy_rule
        self.metadata = metadata
        self.parameters = parameters


class PolicyDefinitionGroup(_serialization.Model):
    """The policy definition group.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the group. Required.
    :vartype name: str
    :ivar display_name: The group's display name.
    :vartype display_name: str
    :ivar category: The group's category.
    :vartype category: str
    :ivar description: The group's description.
    :vartype description: str
    :ivar additional_metadata_id: A resource ID of a resource that contains additional metadata
     about the group.
    :vartype additional_metadata_id: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "additional_metadata_id": {"key": "additionalMetadataId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        display_name: Optional[str] = None,
        category: Optional[str] = None,
        description: Optional[str] = None,
        additional_metadata_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the group. Required.
        :paramtype name: str
        :keyword display_name: The group's display name.
        :paramtype display_name: str
        :keyword category: The group's category.
        :paramtype category: str
        :keyword description: The group's description.
        :paramtype description: str
        :keyword additional_metadata_id: A resource ID of a resource that contains additional metadata
         about the group.
        :paramtype additional_metadata_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.category = category
        self.description = description
        self.additional_metadata_id = additional_metadata_id


class PolicyDefinitionListResult(_serialization.Model):
    """List of policy definitions.

    :ivar value: An array of policy definitions.
    :vartype value: list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicyDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PolicyDefinition"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: An array of policy definitions.
        :paramtype value: list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicyDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyDefinitionReference(_serialization.Model):
    """The policy definition reference.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_definition_id: The ID of the policy definition or policy set definition. Required.
    :vartype policy_definition_id: str
    :ivar parameters: The parameter values for the referenced policy rule. The keys are the
     parameter names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterValuesValue]
    :ivar policy_definition_reference_id: A unique id (within the policy set definition) for this
     policy definition reference.
    :vartype policy_definition_reference_id: str
    :ivar group_names: The name of the groups that this policy definition reference belongs to.
    :vartype group_names: list[str]
    """

    _validation = {
        "policy_definition_id": {"required": True},
    }

    _attribute_map = {
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterValuesValue}"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
        "group_names": {"key": "groupNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        policy_definition_id: str,
        parameters: Optional[Dict[str, "_models.ParameterValuesValue"]] = None,
        policy_definition_reference_id: Optional[str] = None,
        group_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword policy_definition_id: The ID of the policy definition or policy set definition.
         Required.
        :paramtype policy_definition_id: str
        :keyword parameters: The parameter values for the referenced policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterValuesValue]
        :keyword policy_definition_reference_id: A unique id (within the policy set definition) for
         this policy definition reference.
        :paramtype policy_definition_reference_id: str
        :keyword group_names: The name of the groups that this policy definition reference belongs to.
        :paramtype group_names: list[str]
        """
        super().__init__(**kwargs)
        self.policy_definition_id = policy_definition_id
        self.parameters = parameters
        self.policy_definition_reference_id = policy_definition_reference_id
        self.group_names = group_names


class PolicySetDefinition(_serialization.Model):
    """The policy set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy set definition.
    :vartype id: str
    :ivar name: The name of the policy set definition.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policySetDefinitions).
    :vartype type: str
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.v2019_09_01.models.PolicyType
    :ivar display_name: The display name of the policy set definition.
    :vartype display_name: str
    :ivar description: The policy set definition description.
    :vartype description: str
    :ivar metadata: The policy set definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The policy set definition parameters that can be used in policy definition
     references.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterDefinitionsValue]
    :ivar policy_definitions: An array of policy definition references.
    :vartype policy_definitions:
     list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicyDefinitionReference]
    :ivar policy_definition_groups: The metadata describing groups of policy definition references
     within the policy set definition.
    :vartype policy_definition_groups:
     list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicyDefinitionGroup]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "policy_definitions": {"key": "properties.policyDefinitions", "type": "[PolicyDefinitionReference]"},
        "policy_definition_groups": {"key": "properties.policyDefinitionGroups", "type": "[PolicyDefinitionGroup]"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterDefinitionsValue"]] = None,
        policy_definitions: Optional[List["_models.PolicyDefinitionReference"]] = None,
        policy_definition_groups: Optional[List["_models.PolicyDefinitionGroup"]] = None,
        **kwargs
    ):
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.v2019_09_01.models.PolicyType
        :keyword display_name: The display name of the policy set definition.
        :paramtype display_name: str
        :keyword description: The policy set definition description.
        :paramtype description: str
        :keyword metadata: The policy set definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The policy set definition parameters that can be used in policy definition
         references.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2019_09_01.models.ParameterDefinitionsValue]
        :keyword policy_definitions: An array of policy definition references.
        :paramtype policy_definitions:
         list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicyDefinitionReference]
        :keyword policy_definition_groups: The metadata describing groups of policy definition
         references within the policy set definition.
        :paramtype policy_definition_groups:
         list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicyDefinitionGroup]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.policy_type = policy_type
        self.display_name = display_name
        self.description = description
        self.metadata = metadata
        self.parameters = parameters
        self.policy_definitions = policy_definitions
        self.policy_definition_groups = policy_definition_groups


class PolicySetDefinitionListResult(_serialization.Model):
    """List of policy set definitions.

    :ivar value: An array of policy set definitions.
    :vartype value: list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicySetDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicySetDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PolicySetDefinition"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: An array of policy set definitions.
        :paramtype value: list[~azure.mgmt.resource.policy.v2019_09_01.models.PolicySetDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicySku(_serialization.Model):
    """The policy sku. This property is optional, obsolete, and will be ignored.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the policy sku. Possible values are A0 and A1. Required.
    :vartype name: str
    :ivar tier: The policy sku tier. Possible values are Free and Standard.
    :vartype tier: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: str, tier: Optional[str] = None, **kwargs):
        """
        :keyword name: The name of the policy sku. Possible values are A0 and A1. Required.
        :paramtype name: str
        :keyword tier: The policy sku tier. Possible values are Free and Standard.
        :paramtype tier: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
