# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
from urllib.parse import parse_qs, urljoin, urlparse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._operations import (
    build_management_locks_create_or_update_at_resource_group_level_request,
    build_management_locks_create_or_update_at_resource_level_request,
    build_management_locks_create_or_update_at_subscription_level_request,
    build_management_locks_delete_at_resource_group_level_request,
    build_management_locks_delete_at_resource_level_request,
    build_management_locks_delete_at_subscription_level_request,
    build_management_locks_get_at_resource_group_level_request,
    build_management_locks_get_request,
    build_management_locks_list_at_resource_group_level_request,
    build_management_locks_list_at_resource_level_request,
    build_management_locks_list_at_subscription_level_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ManagementLocksOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.resource.locks.v2015_01_01.aio.ManagementLockClient`'s
        :attr:`management_locks` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_or_update_at_resource_group_level(
        self,
        resource_group_name: str,
        lock_name: str,
        parameters: _models.ManagementLockObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the resource group level.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param lock_name: The lock name. Required.
        :type lock_name: str
        :param parameters: The management lock parameters. Required.
        :type parameters: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_at_resource_group_level(
        self,
        resource_group_name: str,
        lock_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the resource group level.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param lock_name: The lock name. Required.
        :type lock_name: str
        :param parameters: The management lock parameters. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_at_resource_group_level(
        self,
        resource_group_name: str,
        lock_name: str,
        parameters: Union[_models.ManagementLockObject, IO],
        **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the resource group level.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param lock_name: The lock name. Required.
        :type lock_name: str
        :param parameters: The management lock parameters. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ManagementLockObject]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ManagementLockObject")

        request = build_management_locks_create_or_update_at_resource_group_level_request(
            resource_group_name=resource_group_name,
            lock_name=lock_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_at_resource_group_level.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ManagementLockObject", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ManagementLockObject", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_at_resource_group_level.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"}  # type: ignore

    @distributed_trace_async
    async def delete_at_resource_group_level(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, lock_name: str, **kwargs: Any
    ) -> None:
        """Deletes the management lock of a resource group.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_management_locks_delete_at_resource_group_level_request(
            resource_group_name=resource_group_name,
            lock_name=lock_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_at_resource_group_level.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_at_resource_group_level.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"}  # type: ignore

    @distributed_trace_async
    async def get_at_resource_group_level(
        self, resource_group_name: str, lock_name: str, **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Gets a management lock at the resource group level.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param lock_name: The lock name. Required.
        :type lock_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ManagementLockObject]

        request = build_management_locks_get_at_resource_group_level_request(
            resource_group_name=resource_group_name,
            lock_name=lock_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_at_resource_group_level.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ManagementLockObject", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_resource_group_level.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"}  # type: ignore

    @overload
    async def create_or_update_at_resource_level(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        lock_name: str,
        parameters: _models.ManagementLockObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the resource level or any level below resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param resource_provider_namespace: Resource identity. Required.
        :type resource_provider_namespace: str
        :param parent_resource_path: Resource identity. Required.
        :type parent_resource_path: str
        :param resource_type: Resource identity. Required.
        :type resource_type: str
        :param resource_name: Resource identity. Required.
        :type resource_name: str
        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :param parameters: Create or update management lock parameters. Required.
        :type parameters: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_at_resource_level(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        lock_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the resource level or any level below resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param resource_provider_namespace: Resource identity. Required.
        :type resource_provider_namespace: str
        :param parent_resource_path: Resource identity. Required.
        :type parent_resource_path: str
        :param resource_type: Resource identity. Required.
        :type resource_type: str
        :param resource_name: Resource identity. Required.
        :type resource_name: str
        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :param parameters: Create or update management lock parameters. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_at_resource_level(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        lock_name: str,
        parameters: Union[_models.ManagementLockObject, IO],
        **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the resource level or any level below resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param resource_provider_namespace: Resource identity. Required.
        :type resource_provider_namespace: str
        :param parent_resource_path: Resource identity. Required.
        :type parent_resource_path: str
        :param resource_type: Resource identity. Required.
        :type resource_type: str
        :param resource_name: Resource identity. Required.
        :type resource_name: str
        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :param parameters: Create or update management lock parameters. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ManagementLockObject]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ManagementLockObject")

        request = build_management_locks_create_or_update_at_resource_level_request(
            resource_group_name=resource_group_name,
            resource_provider_namespace=resource_provider_namespace,
            parent_resource_path=parent_resource_path,
            resource_type=resource_type,
            resource_name=resource_name,
            lock_name=lock_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_at_resource_level.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ManagementLockObject", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ManagementLockObject", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_at_resource_level.metadata = {"url": "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}"}  # type: ignore

    @distributed_trace_async
    async def delete_at_resource_level(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        lock_name: str,
        **kwargs: Any
    ) -> None:
        """Deletes the management lock of a resource or any level below resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param resource_provider_namespace: Resource identity. Required.
        :type resource_provider_namespace: str
        :param parent_resource_path: Resource identity. Required.
        :type parent_resource_path: str
        :param resource_type: Resource identity. Required.
        :type resource_type: str
        :param resource_name: Resource identity. Required.
        :type resource_name: str
        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_management_locks_delete_at_resource_level_request(
            resource_group_name=resource_group_name,
            resource_provider_namespace=resource_provider_namespace,
            parent_resource_path=parent_resource_path,
            resource_type=resource_type,
            resource_name=resource_name,
            lock_name=lock_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_at_resource_level.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_at_resource_level.metadata = {"url": "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}"}  # type: ignore

    @overload
    async def create_or_update_at_subscription_level(
        self,
        lock_name: str,
        parameters: _models.ManagementLockObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the subscription level.

        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :param parameters: The management lock parameters. Required.
        :type parameters: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_at_subscription_level(
        self, lock_name: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the subscription level.

        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :param parameters: The management lock parameters. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_at_subscription_level(
        self, lock_name: str, parameters: Union[_models.ManagementLockObject, IO], **kwargs: Any
    ) -> _models.ManagementLockObject:
        """Create or update a management lock at the subscription level.

        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :param parameters: The management lock parameters. Is either a model type or a IO type.
         Required.
        :type parameters: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ManagementLockObject]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ManagementLockObject")

        request = build_management_locks_create_or_update_at_subscription_level_request(
            lock_name=lock_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_at_subscription_level.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ManagementLockObject", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ManagementLockObject", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_at_subscription_level.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"}  # type: ignore

    @distributed_trace_async
    async def delete_at_subscription_level(  # pylint: disable=inconsistent-return-statements
        self, lock_name: str, **kwargs: Any
    ) -> None:
        """Deletes the management lock of a subscription.

        :param lock_name: The name of lock. Required.
        :type lock_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_management_locks_delete_at_subscription_level_request(
            lock_name=lock_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_at_subscription_level.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_at_subscription_level.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"}  # type: ignore

    @distributed_trace_async
    async def get(self, lock_name: str, **kwargs: Any) -> _models.ManagementLockObject:
        """Gets the management lock of a scope.

        :param lock_name: Name of the management lock. Required.
        :type lock_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ManagementLockObject or the result of cls(response)
        :rtype: ~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ManagementLockObject]

        request = build_management_locks_get_request(
            lock_name=lock_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ManagementLockObject", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"}  # type: ignore

    @distributed_trace
    def list_at_resource_group_level(
        self, resource_group_name: str, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.ManagementLockObject"]:
        """Gets all the management locks of a resource group.

        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param filter: The filter to apply on the operation. Default value is None.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagementLockObject or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ManagementLockListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_management_locks_list_at_resource_group_level_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    api_version=api_version,
                    template_url=self.list_at_resource_group_level.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagementLockListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_at_resource_group_level.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks"}  # type: ignore

    @distributed_trace
    def list_at_resource_level(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ManagementLockObject"]:
        """Gets all the management locks of a resource or any level below resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_provider_namespace: Resource identity. Required.
        :type resource_provider_namespace: str
        :param parent_resource_path: Resource identity. Required.
        :type parent_resource_path: str
        :param resource_type: Resource identity. Required.
        :type resource_type: str
        :param resource_name: Resource identity. Required.
        :type resource_name: str
        :param filter: The filter to apply on the operation. Default value is None.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagementLockObject or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ManagementLockListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_management_locks_list_at_resource_level_request(
                    resource_group_name=resource_group_name,
                    resource_provider_namespace=resource_provider_namespace,
                    parent_resource_path=parent_resource_path,
                    resource_type=resource_type,
                    resource_name=resource_name,
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    api_version=api_version,
                    template_url=self.list_at_resource_level.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagementLockListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_at_resource_level.metadata = {"url": "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks"}  # type: ignore

    @distributed_trace
    def list_at_subscription_level(
        self, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.ManagementLockObject"]:
        """Gets all the management locks of a subscription.

        :param filter: The filter to apply on the operation. Default value is None.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ManagementLockObject or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.locks.v2015_01_01.models.ManagementLockObject]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2015-01-01"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ManagementLockListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_management_locks_list_at_subscription_level_request(
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    api_version=api_version,
                    template_url=self.list_at_subscription_level.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ManagementLockListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_at_subscription_level.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks"}  # type: ignore
