goog.module('grrUi.hunt.huntInspectorDirective');



/**
 * Controller for HuntInspectorDirective.
 * @unrestricted
 */
const HuntInspectorController = class {
  /**
   * @param {!angular.Scope} $scope
   * @ngInject
   */
  constructor($scope) {
    /** @private {!angular.Scope} */
    this.scope_ = $scope;

    /** @type {string} */
    this.shownHuntId;

    /** @type {string} */
    this.activeTab = '';

    /** @type {Object<string, boolean>} */
    this.tabsShown = {};

    this.scope_.$watchGroup(
        ['huntId', 'activeTab'], this.onDirectiveArgumentsChange_.bind(this));
    this.scope_.$watch('controller.activeTab', this.onTabChange_.bind(this));
  }

  /**
   * Handles huntId and activeTab scope attribute changes.
   *
   * @private
   */
  onDirectiveArgumentsChange_() {
    if (angular.isString(this.scope_['activeTab'])) {
      this.activeTab = this.scope_['activeTab'];
    }

    // Doing this asynchronously so that ng-if clause in the template gets
    // triggered. This ensures that new hunt information gets properly
    // rerendered.
    this.scope_.$evalAsync(function() {
      this.shownHuntId = this.scope_['huntId'];
    }.bind(this));
  }

  /**
   * Handles huntId scope attribute changes.
   *
   * @param {string} newValue
   * @param {string} oldValue
   * @private
   */
  onTabChange_(newValue, oldValue) {
    if (newValue !== oldValue) {
      this.scope_['activeTab'] = newValue;
    }
    this.tabsShown[newValue] = true;
  }
};



/**
 * HuntInspectorDirective definition.

 * @return {angular.Directive} Directive definition object.
 */
exports.HuntInspectorDirective = function() {
  return {
    scope: {huntId: '=', activeTab: '=?'},
    restrict: 'E',
    templateUrl: '/static/angular-components/hunt/hunt-inspector.html',
    controller: HuntInspectorController,
    controllerAs: 'controller'
  };
};


/**
 * Directive's name in Angular.
 *
 * @const
 * @export
 */
exports.HuntInspectorDirective.directive_name = 'grrHuntInspector';
