/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);

    public static void removeDir(File dir) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                FileUtils.removeDir(f);
            }
        }
        try {
            dir.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteRecursively(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static File createTempDirectory(String prefix, String suffix, File directory) throws IOException {
        if (suffix == null) {
            suffix = ".tmpdir";
        }
        int nbTries = 0;
        do {
            File newdir;
            if ((newdir = File.createTempFile(prefix, suffix, directory)).delete()) {
                newdir.mkdir();
                return newdir;
            }
            newdir.deleteOnExit();
        } while (++nbTries < 5);
        throw new IOException("Cannot create temp directory after 5 tries.");
    }

    public static String getExtension(String fileName) {
        String extension = "";
        int extensionStart = fileName.lastIndexOf(46);
        if (extensionStart > 0) {
            extension = fileName.substring(extensionStart + 1);
        }
        return extension;
    }

    public static String getFileNameWithExtension(URL url) {
        int pathEnd;
        String pathSegment = url.getPath();
        String extension = "";
        String filename = "";
        int extensionStart = pathSegment.lastIndexOf(46);
        if (extensionStart > 0) {
            extension = pathSegment.substring(extensionStart + 1);
            int trailingPath = extension.indexOf("/");
            if (trailingPath >= 0) {
                extension = extension.substring(0, trailingPath);
            }
            pathSegment = pathSegment.substring(0, extensionStart);
        }
        if ((pathEnd = pathSegment.lastIndexOf(47)) >= 0) {
            filename = pathSegment.substring(pathEnd + 1);
        }
        if (extension.length() > 0) {
            return filename + "." + extension;
        }
        return filename;
    }

    public static Properties resolvePropertiesFile(String fileNamePath) {
        Properties properties = new Properties();
        logger.debug((Object)("Loading properties from file " + fileNamePath));
        try (FileInputStream stream = new FileInputStream(fileNamePath);){
            properties.load(stream);
        }
        catch (Exception e) {
            logger.warn((Object)("Properties file not found : '" + fileNamePath + "'"), (Throwable)e);
        }
        return properties;
    }
}

