/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.carrotsearch.hppc.ByteArrayList;
import morfologik.stemming.EncoderType;

public final class SequenceEncoders {
    private static final int REMOVE_EVERYTHING = 255;

    private SequenceEncoders() {
    }

    private static int sharedPrefixLength(ByteArrayList a, ByteArrayList b) {
        int i;
        int max = Math.min(a.size(), b.size());
        for (i = 0; i < max && a.get(i) == b.get(i); ++i) {
        }
        return i;
    }

    private static int sharedPrefixLength(ByteArrayList a, int aStart, ByteArrayList b, int bStart) {
        int i = 0;
        while (aStart < a.size() && bStart < b.size() && a.get(aStart++) == b.get(bStart++)) {
            ++i;
        }
        return i;
    }

    public static IEncoder forType(EncoderType encType) {
        switch (encType) {
            case INFIX: {
                return new TrimInfixAndSuffixEncoder();
            }
            case PREFIX: {
                return new TrimPrefixAndSuffixEncoder();
            }
            case SUFFIX: {
                return new TrimSuffixEncoder();
            }
            case NONE: {
                return new CopyEncoder();
            }
        }
        throw new RuntimeException("Unknown encoder: " + (Object)((Object)encType));
    }

    public static class CopyEncoder
    implements IEncoder {
        @Override
        public ByteArrayList encode(ByteArrayList src, ByteArrayList derived, ByteArrayList encodedBuffer) {
            encodedBuffer.add(derived.buffer, 0, derived.size());
            return encodedBuffer;
        }

        @Override
        public ByteArrayList decode(ByteArrayList src, ByteArrayList encoded, ByteArrayList derivedBuffer) {
            derivedBuffer.add(encoded.buffer, 0, encoded.size());
            return derivedBuffer;
        }

        @Override
        public EncoderType type() {
            return EncoderType.NONE;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class TrimInfixAndSuffixEncoder
    implements IEncoder {
        ByteArrayList scratch = new ByteArrayList();

        @Override
        public ByteArrayList encode(ByteArrayList src, ByteArrayList dst, ByteArrayList encoded) {
            int maxInfixIndex = 0;
            int maxSubsequenceLength = SequenceEncoders.sharedPrefixLength(src, dst);
            int maxInfixLength = 0;
            for (int i : new int[]{0, maxSubsequenceLength}) {
                for (int j = 1; j <= src.size() - i; ++j) {
                    this.scratch.clear();
                    this.scratch.add(src.buffer, 0, i);
                    this.scratch.add(src.buffer, i + j, src.size() - (i + j));
                    int sharedPrefix = SequenceEncoders.sharedPrefixLength(this.scratch, dst);
                    if (sharedPrefix <= 0 || sharedPrefix <= maxSubsequenceLength || i >= 255 || j >= 255) continue;
                    maxSubsequenceLength = sharedPrefix;
                    maxInfixIndex = i;
                    maxInfixLength = j;
                }
            }
            int truncateSuffixBytes = src.size() - (maxInfixLength + maxSubsequenceLength);
            if (truncateSuffixBytes == 0 && maxInfixIndex + maxInfixLength == src.size()) {
                truncateSuffixBytes = maxInfixLength;
                maxInfixLength = 0;
                maxInfixIndex = 0;
            }
            if (maxInfixIndex >= 255 || maxInfixLength >= 255 || truncateSuffixBytes >= 255) {
                maxSubsequenceLength = 0;
                maxInfixIndex = 0;
                truncateSuffixBytes = 255;
                maxInfixLength = 255;
            }
            encoded.add((byte)(maxInfixIndex + 65 & 0xFF));
            encoded.add((byte)(maxInfixLength + 65 & 0xFF));
            encoded.add((byte)(truncateSuffixBytes + 65 & 0xFF));
            encoded.add(dst.buffer, maxSubsequenceLength, dst.size() - maxSubsequenceLength);
            return encoded;
        }

        @Override
        public ByteArrayList decode(ByteArrayList src, ByteArrayList encoded, ByteArrayList dst) {
            int infixIndex = encoded.get(0) - 65 & 0xFF;
            int infixLength = encoded.get(1) - 65 & 0xFF;
            int truncateSuffixBytes = encoded.get(2) - 65 & 0xFF;
            if (infixLength == 255 || truncateSuffixBytes == 255) {
                infixIndex = 0;
                infixLength = src.size();
                truncateSuffixBytes = 0;
            }
            dst.add(src.buffer, 0, infixIndex);
            dst.add(src.buffer, infixIndex + infixLength, src.size() - (infixIndex + infixLength + truncateSuffixBytes));
            dst.add(encoded.buffer, 3, encoded.size() - 3);
            return dst;
        }

        @Override
        public EncoderType type() {
            return EncoderType.INFIX;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class TrimPrefixAndSuffixEncoder
    implements IEncoder {
        @Override
        public ByteArrayList encode(ByteArrayList src, ByteArrayList dst, ByteArrayList encoded) {
            int maxSubsequenceLength = 0;
            int maxSubsequenceIndex = 0;
            for (int i = 0; i < src.size(); ++i) {
                int sharedPrefix = SequenceEncoders.sharedPrefixLength(src, i, dst, 0);
                if (sharedPrefix <= maxSubsequenceLength || i >= 255 || src.size() - (i + sharedPrefix) >= 255) continue;
                maxSubsequenceLength = sharedPrefix;
                maxSubsequenceIndex = i;
            }
            int truncatePrefixBytes = maxSubsequenceIndex;
            int truncateSuffixBytes = src.size() - (maxSubsequenceIndex + maxSubsequenceLength);
            if (truncatePrefixBytes >= 255 || truncateSuffixBytes >= 255) {
                maxSubsequenceLength = 0;
                maxSubsequenceIndex = 0;
                truncateSuffixBytes = 255;
                truncatePrefixBytes = 255;
            }
            encoded.add((byte)(truncatePrefixBytes + 65 & 0xFF));
            encoded.add((byte)(truncateSuffixBytes + 65 & 0xFF));
            encoded.add(dst.buffer, maxSubsequenceLength, dst.size() - maxSubsequenceLength);
            return encoded;
        }

        @Override
        public ByteArrayList decode(ByteArrayList src, ByteArrayList encoded, ByteArrayList dst) {
            int truncatePrefixBytes = encoded.get(0) - 65 & 0xFF;
            int truncateSuffixBytes = encoded.get(1) - 65 & 0xFF;
            if (truncatePrefixBytes == 255 || truncateSuffixBytes == 255) {
                truncatePrefixBytes = src.size();
                truncateSuffixBytes = 0;
            }
            dst.add(src.buffer, truncatePrefixBytes, src.size() - (truncateSuffixBytes + truncatePrefixBytes));
            dst.add(encoded.buffer, 2, encoded.size() - 2);
            return dst;
        }

        @Override
        public EncoderType type() {
            return EncoderType.PREFIX;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class TrimSuffixEncoder
    implements IEncoder {
        @Override
        public ByteArrayList encode(ByteArrayList src, ByteArrayList dst, ByteArrayList encoded) {
            int sharedPrefix = SequenceEncoders.sharedPrefixLength(src, dst);
            int truncateBytes = src.size() - sharedPrefix;
            if (truncateBytes >= 255) {
                truncateBytes = 255;
                sharedPrefix = 0;
            }
            byte suffixTrimCode = (byte)(truncateBytes + 65);
            encoded.add(suffixTrimCode);
            encoded.add(dst.buffer, sharedPrefix, dst.size() - sharedPrefix);
            return encoded;
        }

        @Override
        public ByteArrayList decode(ByteArrayList src, ByteArrayList encoded, ByteArrayList dst) {
            byte suffixTrimCode = encoded.get(0);
            int truncateBytes = suffixTrimCode - 65 & 0xFF;
            if (truncateBytes == 255) {
                truncateBytes = src.size();
            }
            dst.add(src.buffer, 0, src.size() - truncateBytes);
            dst.add(encoded.buffer, 1, encoded.size() - 1);
            return dst;
        }

        @Override
        public EncoderType type() {
            return EncoderType.SUFFIX;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static interface IEncoder {
        public ByteArrayList encode(ByteArrayList var1, ByteArrayList var2, ByteArrayList var3);

        public ByteArrayList decode(ByteArrayList var1, ByteArrayList var2, ByteArrayList var3);

        public EncoderType type();
    }
}

