/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import morfologik.fsa.CFSA2Serializer;
import morfologik.fsa.FSA;
import morfologik.fsa.FSA5Serializer;
import morfologik.fsa.FSABuilder;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.FSAInfo;
import morfologik.fsa.FSASerializer;
import morfologik.fsa.FSAUtils;
import morfologik.fsa.IMessageLogger;
import morfologik.fsa.StateVisitor;
import morfologik.tools.SharedOptions;
import morfologik.tools.Tool;
import morfologik.tools.WriterMessageLogger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringEscapeUtils;

public final class FSABuildTool
extends Tool {
    private static final int MB = 0x100000;
    private boolean printProgress;
    private FSASerializer serializer;
    private Format format;
    private boolean crWarning = false;
    private boolean inputSorted;
    private boolean statistics;
    private FSABuilder builder = new FSABuilder();
    private long start = System.currentTimeMillis();
    private IMessageLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void go(CommandLine line) throws Exception {
        String[] args = line.getArgs();
        if (args.length != 0) {
            this.printUsage();
            return;
        }
        this.parseOptions(line);
        this.logger = new WriterMessageLogger(new PrintWriter(System.err));
        this.serializer.withLogger(this.logger);
        BufferedInputStream inputStream = null;
        try {
            inputStream = this.initializeInput(line);
            if (this.inputSorted) {
                this.logger.log("Assuming input is already sorted");
            }
            this.checkUtf8Bom(inputStream);
            final FSA fsa = this.inputSorted ? this.processSortedInput(inputStream) : this.processUnsortedInput(inputStream);
            if (this.crWarning) {
                this.logger.log("Warning: input contained carriage returns?");
            }
            if (this.statistics) {
                this.logger.startPart("Statistics");
                FSAInfo info = new FSAInfo(fsa);
                TreeMap<Integer, Integer> fanout = FSAUtils.calculateFanOuts(fsa, fsa.getRootNode());
                this.logger.endPart();
                final IntIntOpenHashMap numbers = new IntIntOpenHashMap();
                fsa.visitInPostOrder(new StateVisitor(){

                    @Override
                    public boolean accept(int state) {
                        int thisNodeNumber = 0;
                        int arc = fsa.getFirstArc(state);
                        while (arc != 0) {
                            thisNodeNumber += (fsa.isArcFinal(arc) ? 1 : 0) + (fsa.isArcTerminal(arc) ? 0 : numbers.get(fsa.getEndNode(arc)));
                            arc = fsa.getNextArc(arc);
                        }
                        numbers.put(state, thisNodeNumber);
                        return true;
                    }
                });
                int singleRLC = 0;
                for (IntIntCursor intIntCursor : numbers) {
                    if (intIntCursor.value != 1) continue;
                    ++singleRLC;
                }
                this.logger.log("Nodes", info.nodeCount);
                this.logger.log("Arcs", info.arcsCount);
                this.logger.log("Tail nodes", singleRLC);
                this.logger.log("States with the given # of outgoing arcs:");
                for (Map.Entry entry : fanout.entrySet()) {
                    this.logger.log("  #" + entry.getKey(), entry.getValue());
                }
                this.logger.log("FSA builder properties:");
                for (Map.Entry entry : this.builder.getInfo().entrySet()) {
                    this.logger.log(((FSABuilder.InfoEntry)((Object)entry.getKey())).toString(), entry.getValue());
                }
            }
            this.logger.startPart("Serializing " + (Object)((Object)this.format));
            this.serializer.serialize(fsa, FSABuildTool.initializeOutput(line)).close();
            this.logger.endPart();
        }
        catch (OutOfMemoryError e) {
            this.logger.log("Error: Out of memory. Pass -Xmx1024m argument (or more) to java.");
        }
        finally {
            if (inputStream != System.in && inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void checkUtf8Bom(InputStream is) throws IOException {
        if (!is.markSupported()) {
            throw new AssertionError((Object)"Mark should be supported on input stream.");
        }
        is.mark(3);
        if (is.read() == 239 && is.read() == 187 && is.read() == 191) {
            System.err.println("Warning: input starts with UTF-8 BOM bytes which is most likely not what you want. Use header-less UTF-8 file (unless you are encoding plain bytes in which case this message doesn't apply).");
        }
        is.reset();
    }

    private FSA processUnsortedInput(InputStream inputStream) throws IOException {
        this.logger.startPart("Reading input");
        ArrayList<byte[]> input = this.readInput(inputStream);
        this.logger.endPart();
        this.logger.log("Input sequences", input.size());
        this.logger.startPart("Sorting");
        Collections.sort(input, FSABuilder.LEXICAL_ORDERING);
        this.logger.endPart();
        this.logger.startPart("Building FSA");
        for (byte[] bb : input) {
            this.builder.add(bb, 0, bb.length);
        }
        FSA root = this.builder.complete();
        this.logger.endPart();
        return root;
    }

    private FSA processSortedInput(InputStream inputStream) throws IOException {
        int lines = this.forAllLines(inputStream, new LineConsumer(){
            private byte[] current;
            private byte[] previous = null;
            private int previousLen;

            @Override
            public byte[] process(byte[] current, int currentLen) {
                if (this.previous != null && FSABuilder.compare(this.previous, 0, this.previousLen, current, 0, currentLen) > 0) {
                    FSABuildTool.this.logger.log("\n\nERROR: The input is not sorted: \n" + FSABuildTool.this.dumpLine(this.previous, this.previousLen) + "\n" + FSABuildTool.this.dumpLine(current, currentLen));
                    throw new TerminateProgramException("Input is not sorted.");
                }
                FSABuildTool.this.builder.add(current, 0, currentLen);
                this.current = this.previous != null ? this.previous : new byte[current.length];
                this.previous = current;
                this.previousLen = currentLen;
                return this.current;
            }
        });
        this.logger.startPart("Building FSA");
        FSA fsa = this.builder.complete();
        this.logger.endPart();
        this.logger.log("Input sequences", lines);
        return fsa;
    }

    protected String dumpLine(byte[] line, int length) {
        int i;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(String.format("%02x", line[i]));
        }
        builder.append(" | ");
        for (i = 0; i < length; ++i) {
            if (Character.isLetterOrDigit(line[i])) {
                builder.append((char)line[i]);
                continue;
            }
            builder.append(".");
        }
        return builder.toString();
    }

    private void parseOptions(CommandLine line) {
        String chr;
        String opt = SharedOptions.outputFormatOption.getOpt();
        if (line.hasOption(opt)) {
            String formatValue = line.getOptionValue(opt);
            try {
                this.format = Format.valueOf(formatValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new TerminateProgramException("Not a valid format: " + formatValue);
            }
        } else {
            this.format = Format.FSA5;
        }
        this.serializer = this.format.getSerializer();
        Charset defaultCharset = Charset.defaultCharset();
        opt = SharedOptions.fillerCharacterOption.getLongOpt();
        if (line.hasOption(opt) && this.requiredCapability(opt, FSAFlags.SEPARATORS)) {
            chr = StringEscapeUtils.unescapeJava(line.getOptionValue(opt));
            FSABuildTool.checkSingleByte(chr, defaultCharset);
            this.serializer.withFiller(chr.getBytes()[0]);
        }
        if (line.hasOption(opt = SharedOptions.annotationSeparatorCharacterOption.getLongOpt()) && this.requiredCapability(opt, FSAFlags.SEPARATORS)) {
            chr = StringEscapeUtils.unescapeJava(line.getOptionValue(opt));
            FSABuildTool.checkSingleByte(chr, defaultCharset);
            this.serializer.withAnnotationSeparator(chr.getBytes()[0]);
        }
        if (line.hasOption(opt = SharedOptions.withNumbersOption.getOpt()) && this.requiredCapability(opt, FSAFlags.NUMBERS)) {
            this.serializer.withNumbers();
        }
        if (line.hasOption(opt = SharedOptions.progressOption.getLongOpt())) {
            this.printProgress = true;
        }
        if (line.hasOption(opt = SharedOptions.inputSortedOption.getLongOpt())) {
            this.inputSorted = true;
        }
        if (line.hasOption(opt = SharedOptions.statistics.getLongOpt())) {
            this.statistics = true;
        }
    }

    private boolean requiredCapability(String opt, FSAFlags flag) {
        if (!this.serializer.getFlags().contains((Object)flag)) {
            throw new RuntimeException("This serializer does not support option: " + opt);
        }
        return true;
    }

    public static byte checkSingleByte(String chr, Charset charset) {
        byte[] bytes = chr.getBytes(charset);
        if (bytes.length == 1) {
            return bytes[0];
        }
        throw new IllegalArgumentException("Filler and annotation characters must be single-byte values, " + chr + " has " + chr.getBytes().length + " bytes.");
    }

    private ArrayList<byte[]> readInput(InputStream is) throws IOException {
        final ArrayList<byte[]> result = new ArrayList<byte[]>();
        this.forAllLines(is, new LineConsumer(){

            @Override
            public byte[] process(byte[] buffer, int pos) {
                result.add(Arrays.copyOf(buffer, pos));
                return buffer;
            }
        });
        return result;
    }

    private int forAllLines(InputStream is, LineConsumer lineConsumer) throws IOException {
        int b;
        int lines = 0;
        byte[] buffer = new byte[]{};
        int line = 0;
        int pos = 0;
        while ((b = is.read()) != -1) {
            if (b == 13 && !this.crWarning) {
                this.crWarning = true;
            }
            if (b == 10) {
                if (pos > 0) {
                    buffer = lineConsumer.process(buffer, pos);
                    pos = 0;
                    ++lines;
                }
                if (!this.printProgress || line++ <= 0 || line % 1000000 != 0) continue;
                this.logger.log(String.format(Locale.ENGLISH, "%6.2fs, sequences: %d", this.elapsedTime(), line));
                continue;
            }
            if (pos >= buffer.length) {
                buffer = Arrays.copyOf(buffer, buffer.length + 10);
            }
            buffer[pos++] = (byte)b;
        }
        if (pos > 0) {
            lineConsumer.process(buffer, pos);
            ++lines;
        }
        return lines;
    }

    private double elapsedTime() {
        return (double)(System.currentTimeMillis() - this.start) / 1000.0;
    }

    @Override
    protected void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getClass().getName(), this.options, true);
    }

    @Override
    protected void initializeOptions(Options options) {
        options.addOption(SharedOptions.inputFileOption);
        options.addOption(SharedOptions.outputFileOption);
        options.addOption(SharedOptions.outputFormatOption);
        options.addOption(SharedOptions.fillerCharacterOption);
        options.addOption(SharedOptions.annotationSeparatorCharacterOption);
        options.addOption(SharedOptions.withNumbersOption);
        options.addOption(SharedOptions.progressOption);
        options.addOption(SharedOptions.inputSortedOption);
        options.addOption(SharedOptions.statistics);
    }

    private static OutputStream initializeOutput(CommandLine line) throws IOException, ParseException {
        String opt = SharedOptions.outputFileOption.getOpt();
        OutputStream output = line.hasOption(opt) ? new FileOutputStream((File)line.getParsedOptionValue(opt)) : System.out;
        return new BufferedOutputStream(output);
    }

    private BufferedInputStream initializeInput(CommandLine line) throws IOException, ParseException {
        InputStream input;
        String opt = SharedOptions.inputFileOption.getOpt();
        if (line.hasOption(opt)) {
            File inputFile = (File)line.getParsedOptionValue(opt);
            if (!this.inputSorted && inputFile.length() > 0x1400000L) {
                this.logger.log("WARN: The input file is quite large, avoid\n      in-memory sorting by piping pre-sorted\n      input directly to fsa_build. Linux:\n      export LC_ALL=C && \\\n         sort input | \\\n         java -jar morfologik.jar fsa_build --sorted -o dict.fsa");
            }
            input = new FileInputStream(inputFile);
        } else {
            input = System.in;
        }
        return new BufferedInputStream(input);
    }

    public static void main(String ... args) throws Exception {
        FSABuildTool tool = new FSABuildTool();
        tool.go(args);
    }

    private static class TerminateProgramException
    extends RuntimeException {
        public TerminateProgramException(String msg) {
            super(msg);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    private static interface LineConsumer {
        public byte[] process(byte[] var1, int var2);
    }

    public static enum Format {
        FSA5,
        CFSA2;


        public FSASerializer getSerializer() {
            switch (this) {
                case FSA5: {
                    return new FSA5Serializer();
                }
                case CFSA2: {
                    return new CFSA2Serializer();
                }
            }
            throw new RuntimeException();
        }
    }
}

