// **********************************************************************
//
// Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.6.1
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICE_API_EXPORTS
#   define ICE_API_EXPORTS
#endif
#include <Ice/Locator.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ObjectFactory.h>
#include <Ice/Outgoing.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/BasicStream.h>
#include <IceUtil/Iterator.h>
#include <IceUtil/PopDisableWarnings.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 306
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 1
#       error Ice patch level mismatch!
#   endif
#endif

namespace
{

const ::std::string __Ice__Locator__findObjectById_name = "findObjectById";

const ::std::string __Ice__Locator__findAdapterById_name = "findAdapterById";

const ::std::string __Ice__Locator__getRegistry_name = "getRegistry";

const ::std::string __Ice__LocatorRegistry__setAdapterDirectProxy_name = "setAdapterDirectProxy";

const ::std::string __Ice__LocatorRegistry__setReplicatedAdapterDirectProxy_name = "setReplicatedAdapterDirectProxy";

const ::std::string __Ice__LocatorRegistry__setServerProcessProxy_name = "setServerProcessProxy";

const ::std::string __Ice__LocatorFinder__getLocator_name = "getLocator";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::AdapterNotFoundException> __Ice__AdapterNotFoundException_init("::Ice::AdapterNotFoundException");

}

Ice::AdapterNotFoundException::~AdapterNotFoundException() throw()
{
}

::std::string
Ice::AdapterNotFoundException::ice_name() const
{
    return "Ice::AdapterNotFoundException";
}

Ice::AdapterNotFoundException*
Ice::AdapterNotFoundException::ice_clone() const
{
    return new AdapterNotFoundException(*this);
}

void
Ice::AdapterNotFoundException::ice_throw() const
{
    throw *this;
}

void
Ice::AdapterNotFoundException::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice("::Ice::AdapterNotFoundException", -1, true);
    __os->endWriteSlice();
}

void
Ice::AdapterNotFoundException::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::InvalidReplicaGroupIdException> __Ice__InvalidReplicaGroupIdException_init("::Ice::InvalidReplicaGroupIdException");

}

Ice::InvalidReplicaGroupIdException::~InvalidReplicaGroupIdException() throw()
{
}

::std::string
Ice::InvalidReplicaGroupIdException::ice_name() const
{
    return "Ice::InvalidReplicaGroupIdException";
}

Ice::InvalidReplicaGroupIdException*
Ice::InvalidReplicaGroupIdException::ice_clone() const
{
    return new InvalidReplicaGroupIdException(*this);
}

void
Ice::InvalidReplicaGroupIdException::ice_throw() const
{
    throw *this;
}

void
Ice::InvalidReplicaGroupIdException::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice("::Ice::InvalidReplicaGroupIdException", -1, true);
    __os->endWriteSlice();
}

void
Ice::InvalidReplicaGroupIdException::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::AdapterAlreadyActiveException> __Ice__AdapterAlreadyActiveException_init("::Ice::AdapterAlreadyActiveException");

}

Ice::AdapterAlreadyActiveException::~AdapterAlreadyActiveException() throw()
{
}

::std::string
Ice::AdapterAlreadyActiveException::ice_name() const
{
    return "Ice::AdapterAlreadyActiveException";
}

Ice::AdapterAlreadyActiveException*
Ice::AdapterAlreadyActiveException::ice_clone() const
{
    return new AdapterAlreadyActiveException(*this);
}

void
Ice::AdapterAlreadyActiveException::ice_throw() const
{
    throw *this;
}

void
Ice::AdapterAlreadyActiveException::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice("::Ice::AdapterAlreadyActiveException", -1, true);
    __os->endWriteSlice();
}

void
Ice::AdapterAlreadyActiveException::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::ObjectNotFoundException> __Ice__ObjectNotFoundException_init("::Ice::ObjectNotFoundException");

}

Ice::ObjectNotFoundException::~ObjectNotFoundException() throw()
{
}

::std::string
Ice::ObjectNotFoundException::ice_name() const
{
    return "Ice::ObjectNotFoundException";
}

Ice::ObjectNotFoundException*
Ice::ObjectNotFoundException::ice_clone() const
{
    return new ObjectNotFoundException(*this);
}

void
Ice::ObjectNotFoundException::ice_throw() const
{
    throw *this;
}

void
Ice::ObjectNotFoundException::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice("::Ice::ObjectNotFoundException", -1, true);
    __os->endWriteSlice();
}

void
Ice::ObjectNotFoundException::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::Ice::ServerNotFoundException> __Ice__ServerNotFoundException_init("::Ice::ServerNotFoundException");

}

Ice::ServerNotFoundException::~ServerNotFoundException() throw()
{
}

::std::string
Ice::ServerNotFoundException::ice_name() const
{
    return "Ice::ServerNotFoundException";
}

Ice::ServerNotFoundException*
Ice::ServerNotFoundException::ice_clone() const
{
    return new ServerNotFoundException(*this);
}

void
Ice::ServerNotFoundException::ice_throw() const
{
    throw *this;
}

void
Ice::ServerNotFoundException::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice("::Ice::ServerNotFoundException", -1, true);
    __os->endWriteSlice();
}

void
Ice::ServerNotFoundException::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

namespace Ice
{
}

IceAsync::Ice::AMD_Locator_findObjectById::AMD_Locator_findObjectById(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_Locator_findObjectById::ice_response(const ::Ice::ObjectPrx& __ret)
{
    if(__validateResponse(true))
    {
        try
        {
            ::IceInternal::BasicStream* __os = __startWriteParams(::Ice::DefaultFormat);
            __os->write(__ret);
            __endWriteParams(true);
        }
        catch(const ::Ice::Exception& __ex)
        {
            __exception(__ex);
            return;
        }
        __response();
    }
}

void
IceAsync::Ice::AMD_Locator_findObjectById::ice_exception(const ::std::exception& ex)
{
    if(const ::Ice::ObjectNotFoundException* __ex = dynamic_cast<const ::Ice::ObjectNotFoundException*>(&ex))
    {
        if(__validateResponse(false))
        {
            __writeUserException(*__ex, ::Ice::DefaultFormat);
            __response();
        }
    }
    else
    {
        ::IceInternal::IncomingAsync::ice_exception(ex);
    }
}

IceAsync::Ice::AMD_Locator_findAdapterById::AMD_Locator_findAdapterById(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_Locator_findAdapterById::ice_response(const ::Ice::ObjectPrx& __ret)
{
    if(__validateResponse(true))
    {
        try
        {
            ::IceInternal::BasicStream* __os = __startWriteParams(::Ice::DefaultFormat);
            __os->write(__ret);
            __endWriteParams(true);
        }
        catch(const ::Ice::Exception& __ex)
        {
            __exception(__ex);
            return;
        }
        __response();
    }
}

void
IceAsync::Ice::AMD_Locator_findAdapterById::ice_exception(const ::std::exception& ex)
{
    if(const ::Ice::AdapterNotFoundException* __ex = dynamic_cast<const ::Ice::AdapterNotFoundException*>(&ex))
    {
        if(__validateResponse(false))
        {
            __writeUserException(*__ex, ::Ice::DefaultFormat);
            __response();
        }
    }
    else
    {
        ::IceInternal::IncomingAsync::ice_exception(ex);
    }
}

IceAsync::Ice::AMD_LocatorRegistry_setAdapterDirectProxy::AMD_LocatorRegistry_setAdapterDirectProxy(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_LocatorRegistry_setAdapterDirectProxy::ice_response()
{
    if(__validateResponse(true))
    {
        __writeEmptyParams();
        __response();
    }
}

void
IceAsync::Ice::AMD_LocatorRegistry_setAdapterDirectProxy::ice_exception(const ::std::exception& ex)
{
    if(const ::Ice::AdapterAlreadyActiveException* __ex = dynamic_cast<const ::Ice::AdapterAlreadyActiveException*>(&ex))
    {
        if(__validateResponse(false))
        {
            __writeUserException(*__ex, ::Ice::DefaultFormat);
            __response();
        }
    }
    else if(const ::Ice::AdapterNotFoundException* __ex = dynamic_cast<const ::Ice::AdapterNotFoundException*>(&ex))
    {
        if(__validateResponse(false))
        {
            __writeUserException(*__ex, ::Ice::DefaultFormat);
            __response();
        }
    }
    else
    {
        ::IceInternal::IncomingAsync::ice_exception(ex);
    }
}

IceAsync::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy::ice_response()
{
    if(__validateResponse(true))
    {
        __writeEmptyParams();
        __response();
    }
}

void
IceAsync::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy::ice_exception(const ::std::exception& ex)
{
    if(const ::Ice::AdapterAlreadyActiveException* __ex = dynamic_cast<const ::Ice::AdapterAlreadyActiveException*>(&ex))
    {
        if(__validateResponse(false))
        {
            __writeUserException(*__ex, ::Ice::DefaultFormat);
            __response();
        }
    }
    else if(const ::Ice::AdapterNotFoundException* __ex = dynamic_cast<const ::Ice::AdapterNotFoundException*>(&ex))
    {
        if(__validateResponse(false))
        {
            __writeUserException(*__ex, ::Ice::DefaultFormat);
            __response();
        }
    }
    else if(const ::Ice::InvalidReplicaGroupIdException* __ex = dynamic_cast<const ::Ice::InvalidReplicaGroupIdException*>(&ex))
    {
        if(__validateResponse(false))
        {
            __writeUserException(*__ex, ::Ice::DefaultFormat);
            __response();
        }
    }
    else
    {
        ::IceInternal::IncomingAsync::ice_exception(ex);
    }
}

IceAsync::Ice::AMD_LocatorRegistry_setServerProcessProxy::AMD_LocatorRegistry_setServerProcessProxy(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::Ice::AMD_LocatorRegistry_setServerProcessProxy::ice_response()
{
    if(__validateResponse(true))
    {
        __writeEmptyParams();
        __response();
    }
}

void
IceAsync::Ice::AMD_LocatorRegistry_setServerProcessProxy::ice_exception(const ::std::exception& ex)
{
    if(const ::Ice::ServerNotFoundException* __ex = dynamic_cast<const ::Ice::ServerNotFoundException*>(&ex))
    {
        if(__validateResponse(false))
        {
            __writeUserException(*__ex, ::Ice::DefaultFormat);
            __response();
        }
    }
    else
    {
        ::IceInternal::IncomingAsync::ice_exception(ex);
    }
}
#ifdef __SUNPRO_CC
class ICE_API IceProxy::Ice::Locator;
#endif
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(::IceProxy::Ice::Locator* p) { return p; }

void
::IceProxy::Ice::__read(::IceInternal::BasicStream* __is, ::IceInternal::ProxyHandle< ::IceProxy::Ice::Locator>& v)
{
    ::Ice::ObjectPrx proxy;
    __is->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ::IceProxy::Ice::Locator;
        v->__copyFrom(proxy);
    }
}

::Ice::ObjectPrx
IceProxy::Ice::Locator::findObjectById(const ::Ice::Identity& __p_id, const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__Locator__findObjectById_name);
    ::IceInternal::Outgoing __og(this, __Ice__Locator__findObjectById_name, ::Ice::Nonmutating, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_id);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::ObjectNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
    ::Ice::ObjectPrx __ret;
    ::IceInternal::BasicStream* __is = __og.startReadParams();
    __is->read(__ret);
    __og.endReadParams();
    return __ret;
}

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::begin_findObjectById(const ::Ice::Identity& __p_id, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__Locator__findObjectById_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__Locator__findObjectById_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__Locator__findObjectById_name, ::Ice::Nonmutating, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_id);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::__begin_findObjectById(const ::Ice::Identity& __p_id, const ::Ice::Context* __ctx, const ::IceInternal::Function<void (const ::Ice::ObjectPrx&)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void (const ::Ice::ObjectPrx&)>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LocatorPrx __proxy = ::Ice::LocatorPrx::uncheckedCast(__result->getProxy());
            ::Ice::ObjectPrx __ret;
            try
            {
                __ret = __proxy->end_findObjectById(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response(__ret);
            }
        }
    
    private:
        
        ::std::function<void (const ::Ice::ObjectPrx&)> _response;
    };
    return begin_findObjectById(__p_id, __ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

::Ice::ObjectPrx
IceProxy::Ice::Locator::end_findObjectById(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__Locator__findObjectById_name);
    ::Ice::ObjectPrx __ret;
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::ObjectNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    ::IceInternal::BasicStream* __is = __result->__startReadParams();
    __is->read(__ret);
    __result->__endReadParams();
    return __ret;
}

::Ice::ObjectPrx
IceProxy::Ice::Locator::findAdapterById(const ::std::string& __p_id, const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__Locator__findAdapterById_name);
    ::IceInternal::Outgoing __og(this, __Ice__Locator__findAdapterById_name, ::Ice::Nonmutating, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_id);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
    ::Ice::ObjectPrx __ret;
    ::IceInternal::BasicStream* __is = __og.startReadParams();
    __is->read(__ret);
    __og.endReadParams();
    return __ret;
}

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::begin_findAdapterById(const ::std::string& __p_id, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__Locator__findAdapterById_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__Locator__findAdapterById_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__Locator__findAdapterById_name, ::Ice::Nonmutating, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_id);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::__begin_findAdapterById(const ::std::string& __p_id, const ::Ice::Context* __ctx, const ::IceInternal::Function<void (const ::Ice::ObjectPrx&)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void (const ::Ice::ObjectPrx&)>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LocatorPrx __proxy = ::Ice::LocatorPrx::uncheckedCast(__result->getProxy());
            ::Ice::ObjectPrx __ret;
            try
            {
                __ret = __proxy->end_findAdapterById(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response(__ret);
            }
        }
    
    private:
        
        ::std::function<void (const ::Ice::ObjectPrx&)> _response;
    };
    return begin_findAdapterById(__p_id, __ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

::Ice::ObjectPrx
IceProxy::Ice::Locator::end_findAdapterById(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__Locator__findAdapterById_name);
    ::Ice::ObjectPrx __ret;
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    ::IceInternal::BasicStream* __is = __result->__startReadParams();
    __is->read(__ret);
    __result->__endReadParams();
    return __ret;
}

::Ice::LocatorRegistryPrx
IceProxy::Ice::Locator::getRegistry(const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__Locator__getRegistry_name);
    ::IceInternal::Outgoing __og(this, __Ice__Locator__getRegistry_name, ::Ice::Nonmutating, __ctx);
    __og.writeEmptyParams();
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
    ::Ice::LocatorRegistryPrx __ret;
    ::IceInternal::BasicStream* __is = __og.startReadParams();
    __is->read(__ret);
    __og.endReadParams();
    return __ret;
}

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::begin_getRegistry(const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__Locator__getRegistry_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__Locator__getRegistry_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__Locator__getRegistry_name, ::Ice::Nonmutating, __ctx);
        __result->writeEmptyParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::Locator::__begin_getRegistry(const ::Ice::Context* __ctx, const ::IceInternal::Function<void (const ::Ice::LocatorRegistryPrx&)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void (const ::Ice::LocatorRegistryPrx&)>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LocatorPrx __proxy = ::Ice::LocatorPrx::uncheckedCast(__result->getProxy());
            ::Ice::LocatorRegistryPrx __ret;
            try
            {
                __ret = __proxy->end_getRegistry(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response(__ret);
            }
        }
    
    private:
        
        ::std::function<void (const ::Ice::LocatorRegistryPrx&)> _response;
    };
    return begin_getRegistry(__ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

::Ice::LocatorRegistryPrx
IceProxy::Ice::Locator::end_getRegistry(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__Locator__getRegistry_name);
    ::Ice::LocatorRegistryPrx __ret;
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    ::IceInternal::BasicStream* __is = __result->__startReadParams();
    __is->read(__ret);
    __result->__endReadParams();
    return __ret;
}

const ::std::string&
IceProxy::Ice::Locator::ice_staticId()
{
    return ::Ice::Locator::ice_staticId();
}

::IceProxy::Ice::Object*
IceProxy::Ice::Locator::__newInstance() const
{
    return new Locator;
}
#ifdef __SUNPRO_CC
class ICE_API IceProxy::Ice::LocatorRegistry;
#endif
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(::IceProxy::Ice::LocatorRegistry* p) { return p; }

void
::IceProxy::Ice::__read(::IceInternal::BasicStream* __is, ::IceInternal::ProxyHandle< ::IceProxy::Ice::LocatorRegistry>& v)
{
    ::Ice::ObjectPrx proxy;
    __is->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ::IceProxy::Ice::LocatorRegistry;
        v->__copyFrom(proxy);
    }
}

void
IceProxy::Ice::LocatorRegistry::setAdapterDirectProxy(const ::std::string& __p_id, const ::Ice::ObjectPrx& __p_proxy, const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__LocatorRegistry__setAdapterDirectProxy_name);
    ::IceInternal::Outgoing __og(this, __Ice__LocatorRegistry__setAdapterDirectProxy_name, ::Ice::Idempotent, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_id);
        __os->write(__p_proxy);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::AdapterAlreadyActiveException&)
        {
            throw;
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
}

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::begin_setAdapterDirectProxy(const ::std::string& __p_id, const ::Ice::ObjectPrx& __p_proxy, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__LocatorRegistry__setAdapterDirectProxy_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__LocatorRegistry__setAdapterDirectProxy_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__LocatorRegistry__setAdapterDirectProxy_name, ::Ice::Idempotent, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_id);
        __os->write(__p_proxy);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::__begin_setAdapterDirectProxy(const ::std::string& __p_id, const ::Ice::ObjectPrx& __p_proxy, const ::Ice::Context* __ctx, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void ()>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LocatorRegistryPrx __proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(__result->getProxy());
            try
            {
                __proxy->end_setAdapterDirectProxy(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response();
            }
        }
    
    private:
        
        ::std::function<void ()> _response;
    };
    return begin_setAdapterDirectProxy(__p_id, __p_proxy, __ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

void
IceProxy::Ice::LocatorRegistry::end_setAdapterDirectProxy(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__LocatorRegistry__setAdapterDirectProxy_name);
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::AdapterAlreadyActiveException&)
        {
            throw;
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    __result->__readEmptyParams();
}

void
IceProxy::Ice::LocatorRegistry::setReplicatedAdapterDirectProxy(const ::std::string& __p_adapterId, const ::std::string& __p_replicaGroupId, const ::Ice::ObjectPrx& __p_p, const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__LocatorRegistry__setReplicatedAdapterDirectProxy_name);
    ::IceInternal::Outgoing __og(this, __Ice__LocatorRegistry__setReplicatedAdapterDirectProxy_name, ::Ice::Idempotent, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_adapterId);
        __os->write(__p_replicaGroupId);
        __os->write(__p_p);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::AdapterAlreadyActiveException&)
        {
            throw;
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::InvalidReplicaGroupIdException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
}

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::begin_setReplicatedAdapterDirectProxy(const ::std::string& __p_adapterId, const ::std::string& __p_replicaGroupId, const ::Ice::ObjectPrx& __p_p, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__LocatorRegistry__setReplicatedAdapterDirectProxy_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__LocatorRegistry__setReplicatedAdapterDirectProxy_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__LocatorRegistry__setReplicatedAdapterDirectProxy_name, ::Ice::Idempotent, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_adapterId);
        __os->write(__p_replicaGroupId);
        __os->write(__p_p);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::__begin_setReplicatedAdapterDirectProxy(const ::std::string& __p_adapterId, const ::std::string& __p_replicaGroupId, const ::Ice::ObjectPrx& __p_p, const ::Ice::Context* __ctx, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void ()>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LocatorRegistryPrx __proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(__result->getProxy());
            try
            {
                __proxy->end_setReplicatedAdapterDirectProxy(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response();
            }
        }
    
    private:
        
        ::std::function<void ()> _response;
    };
    return begin_setReplicatedAdapterDirectProxy(__p_adapterId, __p_replicaGroupId, __p_p, __ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

void
IceProxy::Ice::LocatorRegistry::end_setReplicatedAdapterDirectProxy(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__LocatorRegistry__setReplicatedAdapterDirectProxy_name);
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::AdapterAlreadyActiveException&)
        {
            throw;
        }
        catch(const ::Ice::AdapterNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::InvalidReplicaGroupIdException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    __result->__readEmptyParams();
}

void
IceProxy::Ice::LocatorRegistry::setServerProcessProxy(const ::std::string& __p_id, const ::Ice::ProcessPrx& __p_proxy, const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__LocatorRegistry__setServerProcessProxy_name);
    ::IceInternal::Outgoing __og(this, __Ice__LocatorRegistry__setServerProcessProxy_name, ::Ice::Idempotent, __ctx);
    try
    {
        ::IceInternal::BasicStream* __os = __og.startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_id);
        __os->write(__p_proxy);
        __og.endWriteParams();
    }
    catch(const ::Ice::LocalException& __ex)
    {
        __og.abort(__ex);
    }
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::ServerNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
}

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::begin_setServerProcessProxy(const ::std::string& __p_id, const ::Ice::ProcessPrx& __p_proxy, const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__LocatorRegistry__setServerProcessProxy_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__LocatorRegistry__setServerProcessProxy_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__LocatorRegistry__setServerProcessProxy_name, ::Ice::Idempotent, __ctx);
        ::IceInternal::BasicStream* __os = __result->startWriteParams(::Ice::DefaultFormat);
        __os->write(__p_id);
        __os->write(__p_proxy);
        __result->endWriteParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorRegistry::__begin_setServerProcessProxy(const ::std::string& __p_id, const ::Ice::ProcessPrx& __p_proxy, const ::Ice::Context* __ctx, const ::IceInternal::Function<void ()>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void ()>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LocatorRegistryPrx __proxy = ::Ice::LocatorRegistryPrx::uncheckedCast(__result->getProxy());
            try
            {
                __proxy->end_setServerProcessProxy(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response();
            }
        }
    
    private:
        
        ::std::function<void ()> _response;
    };
    return begin_setServerProcessProxy(__p_id, __p_proxy, __ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

void
IceProxy::Ice::LocatorRegistry::end_setServerProcessProxy(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__LocatorRegistry__setServerProcessProxy_name);
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::ServerNotFoundException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    __result->__readEmptyParams();
}

const ::std::string&
IceProxy::Ice::LocatorRegistry::ice_staticId()
{
    return ::Ice::LocatorRegistry::ice_staticId();
}

::IceProxy::Ice::Object*
IceProxy::Ice::LocatorRegistry::__newInstance() const
{
    return new LocatorRegistry;
}
#ifdef __SUNPRO_CC
class ICE_API IceProxy::Ice::LocatorFinder;
#endif
ICE_API ::IceProxy::Ice::Object* ::IceProxy::Ice::upCast(::IceProxy::Ice::LocatorFinder* p) { return p; }

void
::IceProxy::Ice::__read(::IceInternal::BasicStream* __is, ::IceInternal::ProxyHandle< ::IceProxy::Ice::LocatorFinder>& v)
{
    ::Ice::ObjectPrx proxy;
    __is->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ::IceProxy::Ice::LocatorFinder;
        v->__copyFrom(proxy);
    }
}

::Ice::LocatorPrx
IceProxy::Ice::LocatorFinder::getLocator(const ::Ice::Context* __ctx)
{
    __checkTwowayOnly(__Ice__LocatorFinder__getLocator_name);
    ::IceInternal::Outgoing __og(this, __Ice__LocatorFinder__getLocator_name, ::Ice::Normal, __ctx);
    __og.writeEmptyParams();
    if(!__og.invoke())
    {
        try
        {
            __og.throwUserException();
        }
        catch(const ::Ice::UserException& __ex)
        {
            ::Ice::UnknownUserException __uue(__FILE__, __LINE__, __ex.ice_name());
            throw __uue;
        }
    }
    ::Ice::LocatorPrx __ret;
    ::IceInternal::BasicStream* __is = __og.startReadParams();
    __is->read(__ret);
    __og.endReadParams();
    return __ret;
}

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorFinder::begin_getLocator(const ::Ice::Context* __ctx, const ::IceInternal::CallbackBasePtr& __del, const ::Ice::LocalObjectPtr& __cookie)
{
    __checkAsyncTwowayOnly(__Ice__LocatorFinder__getLocator_name);
    ::IceInternal::OutgoingAsyncPtr __result = new ::IceInternal::OutgoingAsync(this, __Ice__LocatorFinder__getLocator_name, __del, __cookie);
    try
    {
        __result->prepare(__Ice__LocatorFinder__getLocator_name, ::Ice::Normal, __ctx);
        __result->writeEmptyParams();
        __result->invoke();
    }
    catch(const ::Ice::Exception& __ex)
    {
        __result->abort(__ex);
    }
    return __result;
}

#ifdef ICE_CPP11

::Ice::AsyncResultPtr
IceProxy::Ice::LocatorFinder::__begin_getLocator(const ::Ice::Context* __ctx, const ::IceInternal::Function<void (const ::Ice::LocatorPrx&)>& __response, const ::IceInternal::Function<void (const ::Ice::Exception&)>& __exception, const ::IceInternal::Function<void (bool)>& __sent)
{
    class Cpp11CB : public ::IceInternal::Cpp11FnCallbackNC
    {
    public:

        Cpp11CB(const ::std::function<void (const ::Ice::LocatorPrx&)>& responseFunc, const ::std::function<void (const ::Ice::Exception&)>& exceptionFunc, const ::std::function<void (bool)>& sentFunc) :
            ::IceInternal::Cpp11FnCallbackNC(exceptionFunc, sentFunc),
            _response(responseFunc)
        {
            CallbackBase::checkCallback(true, responseFunc || exceptionFunc != nullptr);
        }

        virtual void completed(const ::Ice::AsyncResultPtr& __result) const
        {
            ::Ice::LocatorFinderPrx __proxy = ::Ice::LocatorFinderPrx::uncheckedCast(__result->getProxy());
            ::Ice::LocatorPrx __ret;
            try
            {
                __ret = __proxy->end_getLocator(__result);
            }
            catch(const ::Ice::Exception& ex)
            {
                Cpp11FnCallbackNC::exception(__result, ex);
                return;
            }
            if(_response != nullptr)
            {
                _response(__ret);
            }
        }
    
    private:
        
        ::std::function<void (const ::Ice::LocatorPrx&)> _response;
    };
    return begin_getLocator(__ctx, new Cpp11CB(__response, __exception, __sent));
}
#endif

::Ice::LocatorPrx
IceProxy::Ice::LocatorFinder::end_getLocator(const ::Ice::AsyncResultPtr& __result)
{
    ::Ice::AsyncResult::__check(__result, this, __Ice__LocatorFinder__getLocator_name);
    ::Ice::LocatorPrx __ret;
    if(!__result->__wait())
    {
        try
        {
            __result->__throwUserException();
        }
        catch(const ::Ice::UserException& __ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, __ex.ice_name());
        }
    }
    ::IceInternal::BasicStream* __is = __result->__startReadParams();
    __is->read(__ret);
    __result->__endReadParams();
    return __ret;
}

const ::std::string&
IceProxy::Ice::LocatorFinder::ice_staticId()
{
    return ::Ice::LocatorFinder::ice_staticId();
}

::IceProxy::Ice::Object*
IceProxy::Ice::LocatorFinder::__newInstance() const
{
    return new LocatorFinder;
}

ICE_API ::Ice::Object* Ice::upCast(::Ice::Locator* p) { return p; }

namespace
{
const ::std::string __Ice__Locator_ids[2] =
{
    "::Ice::Locator",
    "::Ice::Object"
};

}

bool
Ice::Locator::ice_isA(const ::std::string& _s, const ::Ice::Current&) const
{
    return ::std::binary_search(__Ice__Locator_ids, __Ice__Locator_ids + 2, _s);
}

::std::vector< ::std::string>
Ice::Locator::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&__Ice__Locator_ids[0], &__Ice__Locator_ids[2]);
}

const ::std::string&
Ice::Locator::ice_id(const ::Ice::Current&) const
{
    return __Ice__Locator_ids[0];
}

const ::std::string&
Ice::Locator::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::Locator";
    return typeId;
#else
    return __Ice__Locator_ids[0];
#endif
}

::Ice::DispatchStatus
Ice::Locator::___findObjectById(::IceInternal::Incoming& __inS, const ::Ice::Current& __current) const
{
    __checkMode(::Ice::Idempotent, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::Ice::Identity __p_id;
    __is->read(__p_id);
    __inS.endReadParams();
    ::Ice::AMD_Locator_findObjectByIdPtr __cb = new IceAsync::Ice::AMD_Locator_findObjectById(__inS);
    try
    {
        findObjectById_async(__cb, __p_id, __current);
    }
    catch(const ::std::exception& __ex)
    {
        __cb->ice_exception(__ex);
    }
    catch(...)
    {
        __cb->ice_exception();
    }
    return ::Ice::DispatchAsync;
}

::Ice::DispatchStatus
Ice::Locator::___findAdapterById(::IceInternal::Incoming& __inS, const ::Ice::Current& __current) const
{
    __checkMode(::Ice::Idempotent, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::std::string __p_id;
    __is->read(__p_id);
    __inS.endReadParams();
    ::Ice::AMD_Locator_findAdapterByIdPtr __cb = new IceAsync::Ice::AMD_Locator_findAdapterById(__inS);
    try
    {
        findAdapterById_async(__cb, __p_id, __current);
    }
    catch(const ::std::exception& __ex)
    {
        __cb->ice_exception(__ex);
    }
    catch(...)
    {
        __cb->ice_exception();
    }
    return ::Ice::DispatchAsync;
}

::Ice::DispatchStatus
Ice::Locator::___getRegistry(::IceInternal::Incoming& __inS, const ::Ice::Current& __current) const
{
    __checkMode(::Ice::Idempotent, __current.mode);
    __inS.readEmptyParams();
    ::Ice::LocatorRegistryPrx __ret = getRegistry(__current);
    ::IceInternal::BasicStream* __os = __inS.__startWriteParams(::Ice::DefaultFormat);
    __os->write(__ret);
    __inS.__endWriteParams(true);
    return ::Ice::DispatchOK;
}

namespace
{
const ::std::string __Ice__Locator_all[] =
{
    "findAdapterById",
    "findObjectById",
    "getRegistry",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

::Ice::DispatchStatus
Ice::Locator::__dispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair< const ::std::string*, const ::std::string*> r = ::std::equal_range(__Ice__Locator_all, __Ice__Locator_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - __Ice__Locator_all)
    {
        case 0:
        {
            return ___findAdapterById(in, current);
        }
        case 1:
        {
            return ___findObjectById(in, current);
        }
        case 2:
        {
            return ___getRegistry(in, current);
        }
        case 3:
        {
            return ___ice_id(in, current);
        }
        case 4:
        {
            return ___ice_ids(in, current);
        }
        case 5:
        {
            return ___ice_isA(in, current);
        }
        case 6:
        {
            return ___ice_ping(in, current);
        }
    }

    assert(false);
    throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
}

void
Ice::Locator::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice(ice_staticId(), -1, true);
    __os->endWriteSlice();
}

void
Ice::Locator::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

void ICE_API 
Ice::__patch(LocatorPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ::Ice::LocatorPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(::Ice::Locator::ice_staticId(), v);
    }
}

ICE_API ::Ice::Object* Ice::upCast(::Ice::LocatorRegistry* p) { return p; }

namespace
{
const ::std::string __Ice__LocatorRegistry_ids[2] =
{
    "::Ice::LocatorRegistry",
    "::Ice::Object"
};

}

bool
Ice::LocatorRegistry::ice_isA(const ::std::string& _s, const ::Ice::Current&) const
{
    return ::std::binary_search(__Ice__LocatorRegistry_ids, __Ice__LocatorRegistry_ids + 2, _s);
}

::std::vector< ::std::string>
Ice::LocatorRegistry::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&__Ice__LocatorRegistry_ids[0], &__Ice__LocatorRegistry_ids[2]);
}

const ::std::string&
Ice::LocatorRegistry::ice_id(const ::Ice::Current&) const
{
    return __Ice__LocatorRegistry_ids[0];
}

const ::std::string&
Ice::LocatorRegistry::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::LocatorRegistry";
    return typeId;
#else
    return __Ice__LocatorRegistry_ids[0];
#endif
}

::Ice::DispatchStatus
Ice::LocatorRegistry::___setAdapterDirectProxy(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Idempotent, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::std::string __p_id;
    ::Ice::ObjectPrx __p_proxy;
    __is->read(__p_id);
    __is->read(__p_proxy);
    __inS.endReadParams();
    ::Ice::AMD_LocatorRegistry_setAdapterDirectProxyPtr __cb = new IceAsync::Ice::AMD_LocatorRegistry_setAdapterDirectProxy(__inS);
    try
    {
        setAdapterDirectProxy_async(__cb, __p_id, __p_proxy, __current);
    }
    catch(const ::std::exception& __ex)
    {
        __cb->ice_exception(__ex);
    }
    catch(...)
    {
        __cb->ice_exception();
    }
    return ::Ice::DispatchAsync;
}

::Ice::DispatchStatus
Ice::LocatorRegistry::___setReplicatedAdapterDirectProxy(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Idempotent, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::std::string __p_adapterId;
    ::std::string __p_replicaGroupId;
    ::Ice::ObjectPrx __p_p;
    __is->read(__p_adapterId);
    __is->read(__p_replicaGroupId);
    __is->read(__p_p);
    __inS.endReadParams();
    ::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxyPtr __cb = new IceAsync::Ice::AMD_LocatorRegistry_setReplicatedAdapterDirectProxy(__inS);
    try
    {
        setReplicatedAdapterDirectProxy_async(__cb, __p_adapterId, __p_replicaGroupId, __p_p, __current);
    }
    catch(const ::std::exception& __ex)
    {
        __cb->ice_exception(__ex);
    }
    catch(...)
    {
        __cb->ice_exception();
    }
    return ::Ice::DispatchAsync;
}

::Ice::DispatchStatus
Ice::LocatorRegistry::___setServerProcessProxy(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Idempotent, __current.mode);
    ::IceInternal::BasicStream* __is = __inS.startReadParams();
    ::std::string __p_id;
    ::Ice::ProcessPrx __p_proxy;
    __is->read(__p_id);
    __is->read(__p_proxy);
    __inS.endReadParams();
    ::Ice::AMD_LocatorRegistry_setServerProcessProxyPtr __cb = new IceAsync::Ice::AMD_LocatorRegistry_setServerProcessProxy(__inS);
    try
    {
        setServerProcessProxy_async(__cb, __p_id, __p_proxy, __current);
    }
    catch(const ::std::exception& __ex)
    {
        __cb->ice_exception(__ex);
    }
    catch(...)
    {
        __cb->ice_exception();
    }
    return ::Ice::DispatchAsync;
}

namespace
{
const ::std::string __Ice__LocatorRegistry_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "setAdapterDirectProxy",
    "setReplicatedAdapterDirectProxy",
    "setServerProcessProxy"
};

}

::Ice::DispatchStatus
Ice::LocatorRegistry::__dispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair< const ::std::string*, const ::std::string*> r = ::std::equal_range(__Ice__LocatorRegistry_all, __Ice__LocatorRegistry_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - __Ice__LocatorRegistry_all)
    {
        case 0:
        {
            return ___ice_id(in, current);
        }
        case 1:
        {
            return ___ice_ids(in, current);
        }
        case 2:
        {
            return ___ice_isA(in, current);
        }
        case 3:
        {
            return ___ice_ping(in, current);
        }
        case 4:
        {
            return ___setAdapterDirectProxy(in, current);
        }
        case 5:
        {
            return ___setReplicatedAdapterDirectProxy(in, current);
        }
        case 6:
        {
            return ___setServerProcessProxy(in, current);
        }
    }

    assert(false);
    throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
}

void
Ice::LocatorRegistry::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice(ice_staticId(), -1, true);
    __os->endWriteSlice();
}

void
Ice::LocatorRegistry::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

void ICE_API 
Ice::__patch(LocatorRegistryPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ::Ice::LocatorRegistryPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(::Ice::LocatorRegistry::ice_staticId(), v);
    }
}

ICE_API ::Ice::Object* Ice::upCast(::Ice::LocatorFinder* p) { return p; }

namespace
{
const ::std::string __Ice__LocatorFinder_ids[2] =
{
    "::Ice::LocatorFinder",
    "::Ice::Object"
};

}

bool
Ice::LocatorFinder::ice_isA(const ::std::string& _s, const ::Ice::Current&) const
{
    return ::std::binary_search(__Ice__LocatorFinder_ids, __Ice__LocatorFinder_ids + 2, _s);
}

::std::vector< ::std::string>
Ice::LocatorFinder::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&__Ice__LocatorFinder_ids[0], &__Ice__LocatorFinder_ids[2]);
}

const ::std::string&
Ice::LocatorFinder::ice_id(const ::Ice::Current&) const
{
    return __Ice__LocatorFinder_ids[0];
}

const ::std::string&
Ice::LocatorFinder::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::Ice::LocatorFinder";
    return typeId;
#else
    return __Ice__LocatorFinder_ids[0];
#endif
}

::Ice::DispatchStatus
Ice::LocatorFinder::___getLocator(::IceInternal::Incoming& __inS, const ::Ice::Current& __current)
{
    __checkMode(::Ice::Normal, __current.mode);
    __inS.readEmptyParams();
    ::Ice::LocatorPrx __ret = getLocator(__current);
    ::IceInternal::BasicStream* __os = __inS.__startWriteParams(::Ice::DefaultFormat);
    __os->write(__ret);
    __inS.__endWriteParams(true);
    return ::Ice::DispatchOK;
}

namespace
{
const ::std::string __Ice__LocatorFinder_all[] =
{
    "getLocator",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

::Ice::DispatchStatus
Ice::LocatorFinder::__dispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair< const ::std::string*, const ::std::string*> r = ::std::equal_range(__Ice__LocatorFinder_all, __Ice__LocatorFinder_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - __Ice__LocatorFinder_all)
    {
        case 0:
        {
            return ___getLocator(in, current);
        }
        case 1:
        {
            return ___ice_id(in, current);
        }
        case 2:
        {
            return ___ice_ids(in, current);
        }
        case 3:
        {
            return ___ice_isA(in, current);
        }
        case 4:
        {
            return ___ice_ping(in, current);
        }
    }

    assert(false);
    throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
}

void
Ice::LocatorFinder::__writeImpl(::IceInternal::BasicStream* __os) const
{
    __os->startWriteSlice(ice_staticId(), -1, true);
    __os->endWriteSlice();
}

void
Ice::LocatorFinder::__readImpl(::IceInternal::BasicStream* __is)
{
    __is->startReadSlice();
    __is->endReadSlice();
}

void ICE_API 
Ice::__patch(LocatorFinderPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ::Ice::LocatorFinderPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(::Ice::LocatorFinder::ice_staticId(), v);
    }
}
