# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.1
#
# <auto-generated>
#
# Generated from file `Endpoint.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_Version_ice
import Ice_BuiltinSequences_ice
import Ice_EndpointF_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module Ice
__name__ = 'Ice'

_M_Ice.TCPEndpointType = 1

_M_Ice.SSLEndpointType = 2

_M_Ice.UDPEndpointType = 3

_M_Ice.WSEndpointType = 4

_M_Ice.WSSEndpointType = 5

if 'EndpointInfo' not in _M_Ice.__dict__:
    _M_Ice.EndpointInfo = Ice.createTempClass()
    class EndpointInfo(object):
        '''Base class providing access to the endpoint details.'''
        def __init__(self, timeout=0, compress=False):
            if Ice.getType(self) == _M_Ice.EndpointInfo:
                raise RuntimeError('Ice.EndpointInfo is an abstract class')
            self.timeout = timeout
            self.compress = compress

        def type(self):
            '''Returns the type of the endpoint.'''
            pass

        def datagram(self):
            '''Returns true if this endpoint is a datagram endpoint.'''
            pass

        def secure(self):
            '''Returns true if this endpoint is a secure endpoint.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_EndpointInfo)

        __repr__ = __str__

    _M_Ice._t_EndpointInfo = IcePy.defineClass('::Ice::EndpointInfo', EndpointInfo, -1, (), True, False, None, (), (
        ('timeout', (), IcePy._t_int, False, 0),
        ('compress', (), IcePy._t_bool, False, 0)
    ))
    EndpointInfo._ice_type = _M_Ice._t_EndpointInfo

    _M_Ice.EndpointInfo = EndpointInfo
    del EndpointInfo

if 'Endpoint' not in _M_Ice.__dict__:
    _M_Ice.Endpoint = Ice.createTempClass()
    class Endpoint(object):
        '''The user-level interface to an endpoint.'''
        def __init__(self):
            if Ice.getType(self) == _M_Ice.Endpoint:
                raise RuntimeError('Ice.Endpoint is an abstract class')

        def toString(self):
            '''Return a string representation of the endpoint.

Returns:
    The string representation of the endpoint.'''
            pass

        def getInfo(self):
            '''Returns the endpoint information.

Returns:
    The endpoint information class.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_Endpoint)

        __repr__ = __str__

    _M_Ice._t_Endpoint = IcePy.defineClass('::Ice::Endpoint', Endpoint, -1, (), True, False, None, (), ())
    Endpoint._ice_type = _M_Ice._t_Endpoint

    _M_Ice.Endpoint = Endpoint
    del Endpoint

if 'IPEndpointInfo' not in _M_Ice.__dict__:
    _M_Ice.IPEndpointInfo = Ice.createTempClass()
    class IPEndpointInfo(_M_Ice.EndpointInfo):
        '''Provides access to the address details of a IP endpoint.'''
        def __init__(self, timeout=0, compress=False, host='', port=0, sourceAddress=''):
            if Ice.getType(self) == _M_Ice.IPEndpointInfo:
                raise RuntimeError('Ice.IPEndpointInfo is an abstract class')
            _M_Ice.EndpointInfo.__init__(self, timeout, compress)
            self.host = host
            self.port = port
            self.sourceAddress = sourceAddress

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_IPEndpointInfo)

        __repr__ = __str__

    _M_Ice._t_IPEndpointInfo = IcePy.defineClass('::Ice::IPEndpointInfo', IPEndpointInfo, -1, (), True, False, _M_Ice._t_EndpointInfo, (), (
        ('host', (), IcePy._t_string, False, 0),
        ('port', (), IcePy._t_int, False, 0),
        ('sourceAddress', (), IcePy._t_string, False, 0)
    ))
    IPEndpointInfo._ice_type = _M_Ice._t_IPEndpointInfo

    _M_Ice.IPEndpointInfo = IPEndpointInfo
    del IPEndpointInfo

if 'TCPEndpointInfo' not in _M_Ice.__dict__:
    _M_Ice.TCPEndpointInfo = Ice.createTempClass()
    class TCPEndpointInfo(_M_Ice.IPEndpointInfo):
        '''Provides access to a TCP endpoint information.'''
        def __init__(self, timeout=0, compress=False, host='', port=0, sourceAddress=''):
            if Ice.getType(self) == _M_Ice.TCPEndpointInfo:
                raise RuntimeError('Ice.TCPEndpointInfo is an abstract class')
            _M_Ice.IPEndpointInfo.__init__(self, timeout, compress, host, port, sourceAddress)

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_TCPEndpointInfo)

        __repr__ = __str__

    _M_Ice._t_TCPEndpointInfo = IcePy.defineClass('::Ice::TCPEndpointInfo', TCPEndpointInfo, -1, (), True, False, _M_Ice._t_IPEndpointInfo, (), ())
    TCPEndpointInfo._ice_type = _M_Ice._t_TCPEndpointInfo

    _M_Ice.TCPEndpointInfo = TCPEndpointInfo
    del TCPEndpointInfo

if 'UDPEndpointInfo' not in _M_Ice.__dict__:
    _M_Ice.UDPEndpointInfo = Ice.createTempClass()
    class UDPEndpointInfo(_M_Ice.IPEndpointInfo):
        '''Provides access to an UDP endpoint information.'''
        def __init__(self, timeout=0, compress=False, host='', port=0, sourceAddress='', mcastInterface='', mcastTtl=0):
            if Ice.getType(self) == _M_Ice.UDPEndpointInfo:
                raise RuntimeError('Ice.UDPEndpointInfo is an abstract class')
            _M_Ice.IPEndpointInfo.__init__(self, timeout, compress, host, port, sourceAddress)
            self.mcastInterface = mcastInterface
            self.mcastTtl = mcastTtl

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_UDPEndpointInfo)

        __repr__ = __str__

    _M_Ice._t_UDPEndpointInfo = IcePy.defineClass('::Ice::UDPEndpointInfo', UDPEndpointInfo, -1, (), True, False, _M_Ice._t_IPEndpointInfo, (), (
        ('mcastInterface', (), IcePy._t_string, False, 0),
        ('mcastTtl', (), IcePy._t_int, False, 0)
    ))
    UDPEndpointInfo._ice_type = _M_Ice._t_UDPEndpointInfo

    _M_Ice.UDPEndpointInfo = UDPEndpointInfo
    del UDPEndpointInfo

if 'WSEndpointInfo' not in _M_Ice.__dict__:
    _M_Ice.WSEndpointInfo = Ice.createTempClass()
    class WSEndpointInfo(_M_Ice.TCPEndpointInfo):
        '''Provides access to a WebSocket endpoint information.'''
        def __init__(self, timeout=0, compress=False, host='', port=0, sourceAddress='', resource=''):
            if Ice.getType(self) == _M_Ice.WSEndpointInfo:
                raise RuntimeError('Ice.WSEndpointInfo is an abstract class')
            _M_Ice.TCPEndpointInfo.__init__(self, timeout, compress, host, port, sourceAddress)
            self.resource = resource

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_WSEndpointInfo)

        __repr__ = __str__

    _M_Ice._t_WSEndpointInfo = IcePy.defineClass('::Ice::WSEndpointInfo', WSEndpointInfo, -1, (), True, False, _M_Ice._t_TCPEndpointInfo, (), (('resource', (), IcePy._t_string, False, 0),))
    WSEndpointInfo._ice_type = _M_Ice._t_WSEndpointInfo

    _M_Ice.WSEndpointInfo = WSEndpointInfo
    del WSEndpointInfo

if 'OpaqueEndpointInfo' not in _M_Ice.__dict__:
    _M_Ice.OpaqueEndpointInfo = Ice.createTempClass()
    class OpaqueEndpointInfo(_M_Ice.EndpointInfo):
        '''Provides access to the details of an opaque endpoint.'''
        def __init__(self, timeout=0, compress=False, rawEncoding=Ice._struct_marker, rawBytes=None):
            if Ice.getType(self) == _M_Ice.OpaqueEndpointInfo:
                raise RuntimeError('Ice.OpaqueEndpointInfo is an abstract class')
            _M_Ice.EndpointInfo.__init__(self, timeout, compress)
            if rawEncoding is Ice._struct_marker:
                self.rawEncoding = _M_Ice.EncodingVersion()
            else:
                self.rawEncoding = rawEncoding
            self.rawBytes = rawBytes

        def __str__(self):
            return IcePy.stringify(self, _M_Ice._t_OpaqueEndpointInfo)

        __repr__ = __str__

    _M_Ice._t_OpaqueEndpointInfo = IcePy.defineClass('::Ice::OpaqueEndpointInfo', OpaqueEndpointInfo, -1, (), True, False, _M_Ice._t_EndpointInfo, (), (
        ('rawEncoding', (), _M_Ice._t_EncodingVersion, False, 0),
        ('rawBytes', (), _M_Ice._t_ByteSeq, False, 0)
    ))
    OpaqueEndpointInfo._ice_type = _M_Ice._t_OpaqueEndpointInfo

    _M_Ice.OpaqueEndpointInfo = OpaqueEndpointInfo
    del OpaqueEndpointInfo

# End of module Ice
