# **********************************************************************
#
# Copyright (c) 2003-2015 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************
#
# Ice version 3.6.1
#
# <auto-generated>
#
# Generated from file `Query.ice'
#
# Warning: do not edit this file.
#
# </auto-generated>
#

import Ice, IcePy
import Ice_Identity_ice
import Ice_BuiltinSequences_ice
import IceGrid_Exception_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module IceGrid
_M_IceGrid = Ice.openModule('IceGrid')

# Start of module IceGrid
__name__ = 'IceGrid'
_M_IceGrid.__doc__ = '''IceGrid is a server activation and deployment tool. IceGrid,
simplifies the complex task of deploying applications in a
heterogeneous computer network.'''

if 'LoadSample' not in _M_IceGrid.__dict__:
    _M_IceGrid.LoadSample = Ice.createTempClass()
    class LoadSample(Ice.EnumBase):
        '''Determines which load sampling interval to use.'''

        def __init__(self, _n, _v):
            Ice.EnumBase.__init__(self, _n, _v)

        def valueOf(self, _n):
            if _n in self._enumerators:
                return self._enumerators[_n]
            return None
        valueOf = classmethod(valueOf)

    LoadSample.LoadSample1 = LoadSample("LoadSample1", 0)
    LoadSample.LoadSample5 = LoadSample("LoadSample5", 1)
    LoadSample.LoadSample15 = LoadSample("LoadSample15", 2)
    LoadSample._enumerators = { 0:LoadSample.LoadSample1, 1:LoadSample.LoadSample5, 2:LoadSample.LoadSample15 }

    _M_IceGrid._t_LoadSample = IcePy.defineEnum('::IceGrid::LoadSample', LoadSample, (), LoadSample._enumerators)

    _M_IceGrid.LoadSample = LoadSample
    del LoadSample

if 'Query' not in _M_IceGrid.__dict__:
    _M_IceGrid.Query = Ice.createTempClass()
    class Query(Ice.Object):
        '''The IceGrid query interface. This interface is accessible to
Ice clients who wish to look up well-known objects.'''
        def __init__(self):
            if Ice.getType(self) == _M_IceGrid.Query:
                raise RuntimeError('IceGrid.Query is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::Query')

        def ice_id(self, current=None):
            return '::IceGrid::Query'

        def ice_staticId():
            return '::IceGrid::Query'
        ice_staticId = staticmethod(ice_staticId)

        def findObjectById(self, id, current=None):
            '''Find a well-known object by identity.

Arguments:
    id The identity.

Returns:
    The proxy or null if no such object has been found.'''
            pass

        def findObjectByType(self, type, current=None):
            '''Find a well-known object by type. If there are several objects
registered for the given type, the object is randomly
selected.

Arguments:
    type The object type.

Returns:
    The proxy or null, if no such object has been found.'''
            pass

        def findObjectByTypeOnLeastLoadedNode(self, type, sample, current=None):
            '''Find a well-known object by type on the least-loaded node. If
the registry does not know which node hosts the object
(for example, because the object was registered with a direct proxy), the
registry assumes the object is hosted on a node that has a load
average of 1.0.

Arguments:
    type The object type.

    sample The sampling interval.

Returns:
    The proxy or null, if no such object has been found.'''
            pass

        def findAllObjectsByType(self, type, current=None):
            '''Find all the well-known objects with the given type.

Arguments:
    type The object type.

Returns:
    The proxies or an empty sequence, if no such objects
have been found.'''
            pass

        def findAllReplicas(self, proxy, current=None):
            '''Find all the object replicas associated with the given
proxy. If the given proxy is not an indirect proxy from a
replica group, an empty sequence is returned.

Arguments:
    proxy The object proxy.

Returns:
    The proxies of each object replica or an empty sequence,
if the given proxy is not from a replica group.'''
            pass

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_Query)

        __repr__ = __str__

    _M_IceGrid.QueryPrx = Ice.createTempClass()
    class QueryPrx(Ice.ObjectPrx):

        '''Find a well-known object by identity.

Arguments:
    id The identity.

Returns:
    The proxy or null if no such object has been found.'''
        def findObjectById(self, id, _ctx=None):
            return _M_IceGrid.Query._op_findObjectById.invoke(self, ((id, ), _ctx))

        '''Find a well-known object by identity.

Arguments:
    id The identity.

Returns:
    The proxy or null if no such object has been found.'''
        def begin_findObjectById(self, id, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Query._op_findObjectById.begin(self, ((id, ), _response, _ex, _sent, _ctx))

        '''Find a well-known object by identity.

Arguments:
    id The identity.

Returns:
    The proxy or null if no such object has been found.'''
        def end_findObjectById(self, _r):
            return _M_IceGrid.Query._op_findObjectById.end(self, _r)

        '''Find a well-known object by type. If there are several objects
registered for the given type, the object is randomly
selected.

Arguments:
    type The object type.

Returns:
    The proxy or null, if no such object has been found.'''
        def findObjectByType(self, type, _ctx=None):
            return _M_IceGrid.Query._op_findObjectByType.invoke(self, ((type, ), _ctx))

        '''Find a well-known object by type. If there are several objects
registered for the given type, the object is randomly
selected.

Arguments:
    type The object type.

Returns:
    The proxy or null, if no such object has been found.'''
        def begin_findObjectByType(self, type, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Query._op_findObjectByType.begin(self, ((type, ), _response, _ex, _sent, _ctx))

        '''Find a well-known object by type. If there are several objects
registered for the given type, the object is randomly
selected.

Arguments:
    type The object type.

Returns:
    The proxy or null, if no such object has been found.'''
        def end_findObjectByType(self, _r):
            return _M_IceGrid.Query._op_findObjectByType.end(self, _r)

        '''Find a well-known object by type on the least-loaded node. If
the registry does not know which node hosts the object
(for example, because the object was registered with a direct proxy), the
registry assumes the object is hosted on a node that has a load
average of 1.0.

Arguments:
    type The object type.

    sample The sampling interval.

Returns:
    The proxy or null, if no such object has been found.'''
        def findObjectByTypeOnLeastLoadedNode(self, type, sample, _ctx=None):
            return _M_IceGrid.Query._op_findObjectByTypeOnLeastLoadedNode.invoke(self, ((type, sample), _ctx))

        '''Find a well-known object by type on the least-loaded node. If
the registry does not know which node hosts the object
(for example, because the object was registered with a direct proxy), the
registry assumes the object is hosted on a node that has a load
average of 1.0.

Arguments:
    type The object type.

    sample The sampling interval.

Returns:
    The proxy or null, if no such object has been found.'''
        def begin_findObjectByTypeOnLeastLoadedNode(self, type, sample, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Query._op_findObjectByTypeOnLeastLoadedNode.begin(self, ((type, sample), _response, _ex, _sent, _ctx))

        '''Find a well-known object by type on the least-loaded node. If
the registry does not know which node hosts the object
(for example, because the object was registered with a direct proxy), the
registry assumes the object is hosted on a node that has a load
average of 1.0.

Arguments:
    type The object type.

    sample The sampling interval.

Returns:
    The proxy or null, if no such object has been found.'''
        def end_findObjectByTypeOnLeastLoadedNode(self, _r):
            return _M_IceGrid.Query._op_findObjectByTypeOnLeastLoadedNode.end(self, _r)

        '''Find all the well-known objects with the given type.

Arguments:
    type The object type.

Returns:
    The proxies or an empty sequence, if no such objects
have been found.'''
        def findAllObjectsByType(self, type, _ctx=None):
            return _M_IceGrid.Query._op_findAllObjectsByType.invoke(self, ((type, ), _ctx))

        '''Find all the well-known objects with the given type.

Arguments:
    type The object type.

Returns:
    The proxies or an empty sequence, if no such objects
have been found.'''
        def begin_findAllObjectsByType(self, type, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Query._op_findAllObjectsByType.begin(self, ((type, ), _response, _ex, _sent, _ctx))

        '''Find all the well-known objects with the given type.

Arguments:
    type The object type.

Returns:
    The proxies or an empty sequence, if no such objects
have been found.'''
        def end_findAllObjectsByType(self, _r):
            return _M_IceGrid.Query._op_findAllObjectsByType.end(self, _r)

        '''Find all the object replicas associated with the given
proxy. If the given proxy is not an indirect proxy from a
replica group, an empty sequence is returned.

Arguments:
    proxy The object proxy.

Returns:
    The proxies of each object replica or an empty sequence,
if the given proxy is not from a replica group.'''
        def findAllReplicas(self, proxy, _ctx=None):
            return _M_IceGrid.Query._op_findAllReplicas.invoke(self, ((proxy, ), _ctx))

        '''Find all the object replicas associated with the given
proxy. If the given proxy is not an indirect proxy from a
replica group, an empty sequence is returned.

Arguments:
    proxy The object proxy.

Returns:
    The proxies of each object replica or an empty sequence,
if the given proxy is not from a replica group.'''
        def begin_findAllReplicas(self, proxy, _response=None, _ex=None, _sent=None, _ctx=None):
            return _M_IceGrid.Query._op_findAllReplicas.begin(self, ((proxy, ), _response, _ex, _sent, _ctx))

        '''Find all the object replicas associated with the given
proxy. If the given proxy is not an indirect proxy from a
replica group, an empty sequence is returned.

Arguments:
    proxy The object proxy.

Returns:
    The proxies of each object replica or an empty sequence,
if the given proxy is not from a replica group.'''
        def end_findAllReplicas(self, _r):
            return _M_IceGrid.Query._op_findAllReplicas.end(self, _r)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.QueryPrx.ice_checkedCast(proxy, '::IceGrid::Query', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=None):
            return _M_IceGrid.QueryPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

        def ice_staticId():
            return '::IceGrid::Query'
        ice_staticId = staticmethod(ice_staticId)

    _M_IceGrid._t_QueryPrx = IcePy.defineProxy('::IceGrid::Query', QueryPrx)

    _M_IceGrid._t_Query = IcePy.defineClass('::IceGrid::Query', Query, -1, (), True, False, None, (), ())
    Query._ice_type = _M_IceGrid._t_Query

    Query._op_findObjectById = IcePy.Operation('findObjectById', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), _M_Ice._t_Identity, False, 0),), (), ((), IcePy._t_ObjectPrx, False, 0), ())
    Query._op_findObjectByType = IcePy.Operation('findObjectByType', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), IcePy._t_ObjectPrx, False, 0), ())
    Query._op_findObjectByTypeOnLeastLoadedNode = IcePy.Operation('findObjectByTypeOnLeastLoadedNode', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0), ((), _M_IceGrid._t_LoadSample, False, 0)), (), ((), IcePy._t_ObjectPrx, False, 0), ())
    Query._op_findAllObjectsByType = IcePy.Operation('findAllObjectsByType', Ice.OperationMode.Idempotent, Ice.OperationMode.Nonmutating, False, None, (), (((), IcePy._t_string, False, 0),), (), ((), _M_Ice._t_ObjectProxySeq, False, 0), ())
    Query._op_findAllReplicas = IcePy.Operation('findAllReplicas', Ice.OperationMode.Idempotent, Ice.OperationMode.Idempotent, False, None, (), (((), IcePy._t_ObjectPrx, False, 0),), (), ((), _M_Ice._t_ObjectProxySeq, False, 0), ())

    _M_IceGrid.Query = Query
    del Query

    _M_IceGrid.QueryPrx = QueryPrx
    del QueryPrx

# End of module IceGrid

Ice.sliceChecksums["::IceGrid::LoadSample"] = "ec48c06fa099138a5fbbce121a9a290"
Ice.sliceChecksums["::IceGrid::Query"] = "39dbe5f62c19aa42c2e0fbaf220b4f1"
