# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Addon(Resource):
    """An addon resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: The properties of an addon resource
    :type properties: ~azure.mgmt.avs.models.AddonProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AddonProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(Addon, self).__init__(**kwargs)
        self.properties = properties


class AddonProperties(Model):
    """The properties of an addon.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AddonSrmProperties, AddonVrProperties, AddonHcxProperties

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The state of the addon provisioning. Possible
     values include: 'Succeeded', 'Failed', 'Cancelled', 'Building',
     'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.AddonProvisioningState
    :param addon_type: Required. Constant filled by server.
    :type addon_type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'addon_type': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'addon_type': {'key': 'addonType', 'type': 'str'},
    }

    _subtype_map = {
        'addon_type': {'SRM': 'AddonSrmProperties', 'VR': 'AddonVrProperties', 'HCX': 'AddonHcxProperties'}
    }

    def __init__(self, **kwargs) -> None:
        super(AddonProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.addon_type = None


class AddonHcxProperties(AddonProperties):
    """The properties of an HCX addon.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The state of the addon provisioning. Possible
     values include: 'Succeeded', 'Failed', 'Cancelled', 'Building',
     'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.AddonProvisioningState
    :param addon_type: Required. Constant filled by server.
    :type addon_type: str
    :param offer: Required. The HCX offer, example VMware MaaS Cloud Provider
     (Enterprise)
    :type offer: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'addon_type': {'required': True},
        'offer': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'addon_type': {'key': 'addonType', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
    }

    def __init__(self, *, offer: str, **kwargs) -> None:
        super(AddonHcxProperties, self).__init__(**kwargs)
        self.offer = offer
        self.addon_type = 'HCX'


class AddonSrmProperties(AddonProperties):
    """The properties of a Site Recovery Manager (SRM) addon.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The state of the addon provisioning. Possible
     values include: 'Succeeded', 'Failed', 'Cancelled', 'Building',
     'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.AddonProvisioningState
    :param addon_type: Required. Constant filled by server.
    :type addon_type: str
    :param license_key: Required. The Site Recovery Manager (SRM) license
    :type license_key: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'addon_type': {'required': True},
        'license_key': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'addon_type': {'key': 'addonType', 'type': 'str'},
        'license_key': {'key': 'licenseKey', 'type': 'str'},
    }

    def __init__(self, *, license_key: str, **kwargs) -> None:
        super(AddonSrmProperties, self).__init__(**kwargs)
        self.license_key = license_key
        self.addon_type = 'SRM'


class AddonVrProperties(AddonProperties):
    """The properties of a vSphere Replication (VR) addon.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The state of the addon provisioning. Possible
     values include: 'Succeeded', 'Failed', 'Cancelled', 'Building',
     'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.AddonProvisioningState
    :param addon_type: Required. Constant filled by server.
    :type addon_type: str
    :param vrs_count: Required. The vSphere Replication Server (VRS) count
    :type vrs_count: int
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'addon_type': {'required': True},
        'vrs_count': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'addon_type': {'key': 'addonType', 'type': 'str'},
        'vrs_count': {'key': 'vrsCount', 'type': 'int'},
    }

    def __init__(self, *, vrs_count: int, **kwargs) -> None:
        super(AddonVrProperties, self).__init__(**kwargs)
        self.vrs_count = vrs_count
        self.addon_type = 'VR'


class AdminCredentials(Model):
    """Administrative credentials for accessing vCenter and NSX-T.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar nsxt_username: NSX-T Manager username
    :vartype nsxt_username: str
    :ivar nsxt_password: NSX-T Manager password
    :vartype nsxt_password: str
    :ivar vcenter_username: vCenter admin username
    :vartype vcenter_username: str
    :ivar vcenter_password: vCenter admin password
    :vartype vcenter_password: str
    """

    _validation = {
        'nsxt_username': {'readonly': True},
        'nsxt_password': {'readonly': True},
        'vcenter_username': {'readonly': True},
        'vcenter_password': {'readonly': True},
    }

    _attribute_map = {
        'nsxt_username': {'key': 'nsxtUsername', 'type': 'str'},
        'nsxt_password': {'key': 'nsxtPassword', 'type': 'str'},
        'vcenter_username': {'key': 'vcenterUsername', 'type': 'str'},
        'vcenter_password': {'key': 'vcenterPassword', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AdminCredentials, self).__init__(**kwargs)
        self.nsxt_username = None
        self.nsxt_password = None
        self.vcenter_username = None
        self.vcenter_password = None


class Circuit(Model):
    """An ExpressRoute Circuit.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar primary_subnet: CIDR of primary subnet
    :vartype primary_subnet: str
    :ivar secondary_subnet: CIDR of secondary subnet
    :vartype secondary_subnet: str
    :ivar express_route_id: Identifier of the ExpressRoute Circuit (Microsoft
     Colo only)
    :vartype express_route_id: str
    :ivar express_route_private_peering_id: ExpressRoute Circuit private
     peering identifier
    :vartype express_route_private_peering_id: str
    """

    _validation = {
        'primary_subnet': {'readonly': True},
        'secondary_subnet': {'readonly': True},
        'express_route_id': {'readonly': True},
        'express_route_private_peering_id': {'readonly': True},
    }

    _attribute_map = {
        'primary_subnet': {'key': 'primarySubnet', 'type': 'str'},
        'secondary_subnet': {'key': 'secondarySubnet', 'type': 'str'},
        'express_route_id': {'key': 'expressRouteID', 'type': 'str'},
        'express_route_private_peering_id': {'key': 'expressRoutePrivatePeeringID', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Circuit, self).__init__(**kwargs)
        self.primary_subnet = None
        self.secondary_subnet = None
        self.express_route_id = None
        self.express_route_private_peering_id = None


class CloudError(Model):
    """API error response.

    :param error: An error returned by the API
    :type error: ~azure.mgmt.avs.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudLink(Resource):
    """A cloud link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: The state of the cloud link. Possible values include:
     'Active', 'Building', 'Deleting', 'Failed', 'Disconnected'
    :vartype status: str or ~azure.mgmt.avs.models.CloudLinkStatus
    :param linked_cloud: Identifier of the other private cloud participating
     in the link.
    :type linked_cloud: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'linked_cloud': {'key': 'properties.linkedCloud', 'type': 'str'},
    }

    def __init__(self, *, linked_cloud: str=None, **kwargs) -> None:
        super(CloudLink, self).__init__(**kwargs)
        self.status = None
        self.linked_cloud = linked_cloud


class Cluster(Resource):
    """A cluster resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Required. The cluster SKU
    :type sku: ~azure.mgmt.avs.models.Sku
    :param cluster_size: The cluster size
    :type cluster_size: int
    :param provisioning_state: The state of the cluster provisioning. Possible
     values include: 'Succeeded', 'Failed', 'Cancelled', 'Deleting', 'Updating'
    :type provisioning_state: str or
     ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity
    :vartype cluster_id: int
    :ivar hosts: The hosts
    :vartype hosts: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'required': True},
        'cluster_id': {'readonly': True},
        'hosts': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'cluster_size': {'key': 'properties.clusterSize', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'int'},
        'hosts': {'key': 'properties.hosts', 'type': '[str]'},
    }

    def __init__(self, *, sku, cluster_size: int=None, provisioning_state=None, **kwargs) -> None:
        super(Cluster, self).__init__(**kwargs)
        self.sku = sku
        self.cluster_size = cluster_size
        self.provisioning_state = provisioning_state
        self.cluster_id = None
        self.hosts = None


class ClusterUpdate(Model):
    """An update of a cluster resource.

    :param cluster_size: The cluster size
    :type cluster_size: int
    """

    _attribute_map = {
        'cluster_size': {'key': 'properties.clusterSize', 'type': 'int'},
    }

    def __init__(self, *, cluster_size: int=None, **kwargs) -> None:
        super(ClusterUpdate, self).__init__(**kwargs)
        self.cluster_size = cluster_size


class CommonClusterProperties(Model):
    """The common properties of a cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param cluster_size: The cluster size
    :type cluster_size: int
    :param provisioning_state: The state of the cluster provisioning. Possible
     values include: 'Succeeded', 'Failed', 'Cancelled', 'Deleting', 'Updating'
    :type provisioning_state: str or
     ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity
    :vartype cluster_id: int
    :ivar hosts: The hosts
    :vartype hosts: list[str]
    """

    _validation = {
        'cluster_id': {'readonly': True},
        'hosts': {'readonly': True},
    }

    _attribute_map = {
        'cluster_size': {'key': 'clusterSize', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'int'},
        'hosts': {'key': 'hosts', 'type': '[str]'},
    }

    def __init__(self, *, cluster_size: int=None, provisioning_state=None, **kwargs) -> None:
        super(CommonClusterProperties, self).__init__(**kwargs)
        self.cluster_size = cluster_size
        self.provisioning_state = provisioning_state
        self.cluster_id = None
        self.hosts = None


class Datastore(Resource):
    """A datastore resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The state of the datastore provisioning.
     Possible values include: 'Succeeded', 'Failed', 'Cancelled', 'Pending',
     'Creating', 'Updating', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.DatastoreProvisioningState
    :param net_app_volume: An Azure NetApp Files volume
    :type net_app_volume: ~azure.mgmt.avs.models.NetAppVolume
    :param disk_pool_volume: An iSCSI volume
    :type disk_pool_volume: ~azure.mgmt.avs.models.DiskPoolVolume
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'net_app_volume': {'key': 'properties.netAppVolume', 'type': 'NetAppVolume'},
        'disk_pool_volume': {'key': 'properties.diskPoolVolume', 'type': 'DiskPoolVolume'},
    }

    def __init__(self, *, net_app_volume=None, disk_pool_volume=None, **kwargs) -> None:
        super(Datastore, self).__init__(**kwargs)
        self.provisioning_state = None
        self.net_app_volume = net_app_volume
        self.disk_pool_volume = disk_pool_volume


class DiskPoolVolume(Model):
    """An iSCSI volume from Microsoft.StoragePool provider.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param target_id: Required. Azure resource ID of the iSCSI target
    :type target_id: str
    :param lun_name: Required. Name of the LUN to be used for datastore
    :type lun_name: str
    :param mount_option: Mode that describes whether the LUN has to be mounted
     as a datastore or attached as a LUN. Possible values include: 'MOUNT',
     'ATTACH'. Default value: "MOUNT" .
    :type mount_option: str or ~azure.mgmt.avs.models.MountOptionEnum
    :ivar path: Device path
    :vartype path: str
    """

    _validation = {
        'target_id': {'required': True},
        'lun_name': {'required': True},
        'path': {'readonly': True},
    }

    _attribute_map = {
        'target_id': {'key': 'targetId', 'type': 'str'},
        'lun_name': {'key': 'lunName', 'type': 'str'},
        'mount_option': {'key': 'mountOption', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, *, target_id: str, lun_name: str, mount_option="MOUNT", **kwargs) -> None:
        super(DiskPoolVolume, self).__init__(**kwargs)
        self.target_id = target_id
        self.lun_name = lun_name
        self.mount_option = mount_option
        self.path = None


class Endpoints(Model):
    """Endpoint addresses.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar nsxt_manager: Endpoint for the NSX-T Data Center manager
    :vartype nsxt_manager: str
    :ivar vcsa: Endpoint for Virtual Center Server Appliance
    :vartype vcsa: str
    :ivar hcx_cloud_manager: Endpoint for the HCX Cloud Manager
    :vartype hcx_cloud_manager: str
    """

    _validation = {
        'nsxt_manager': {'readonly': True},
        'vcsa': {'readonly': True},
        'hcx_cloud_manager': {'readonly': True},
    }

    _attribute_map = {
        'nsxt_manager': {'key': 'nsxtManager', 'type': 'str'},
        'vcsa': {'key': 'vcsa', 'type': 'str'},
        'hcx_cloud_manager': {'key': 'hcxCloudManager', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Endpoints, self).__init__(**kwargs)
        self.nsxt_manager = None
        self.vcsa = None
        self.hcx_cloud_manager = None


class ErrorAdditionalInfo(Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(Model):
    """Error Response.

    Common error response for all Azure Resource Manager APIs to return error
    details for failed operations. (This also follows the OData error response
    format.).

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.avs.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.avs.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ExpressRouteAuthorization(Resource):
    """ExpressRoute Circuit Authorization.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The state of the  ExpressRoute Circuit
     Authorization provisioning. Possible values include: 'Succeeded',
     'Failed', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.ExpressRouteAuthorizationProvisioningState
    :ivar express_route_authorization_id: The ID of the ExpressRoute Circuit
     Authorization
    :vartype express_route_authorization_id: str
    :ivar express_route_authorization_key: The key of the ExpressRoute Circuit
     Authorization
    :vartype express_route_authorization_key: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'express_route_authorization_id': {'readonly': True},
        'express_route_authorization_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'express_route_authorization_id': {'key': 'properties.expressRouteAuthorizationId', 'type': 'str'},
        'express_route_authorization_key': {'key': 'properties.expressRouteAuthorizationKey', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ExpressRouteAuthorization, self).__init__(**kwargs)
        self.provisioning_state = None
        self.express_route_authorization_id = None
        self.express_route_authorization_key = None


class GlobalReachConnection(Resource):
    """A global reach connection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The state of the  ExpressRoute Circuit
     Authorization provisioning. Possible values include: 'Succeeded',
     'Failed', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.GlobalReachConnectionProvisioningState
    :ivar address_prefix: The network used for global reach carved out from
     the original network block provided for the private cloud
    :vartype address_prefix: str
    :param authorization_key: Authorization key from the peer express route
     used for the global reach connection
    :type authorization_key: str
    :ivar circuit_connection_status: The connection status of the global reach
     connection. Possible values include: 'Connected', 'Connecting',
     'Disconnected'
    :vartype circuit_connection_status: str or
     ~azure.mgmt.avs.models.GlobalReachConnectionStatus
    :param peer_express_route_circuit: Identifier of the ExpressRoute Circuit
     to peer with in the global reach connection
    :type peer_express_route_circuit: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'address_prefix': {'readonly': True},
        'circuit_connection_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'circuit_connection_status': {'key': 'properties.circuitConnectionStatus', 'type': 'str'},
        'peer_express_route_circuit': {'key': 'properties.peerExpressRouteCircuit', 'type': 'str'},
    }

    def __init__(self, *, authorization_key: str=None, peer_express_route_circuit: str=None, **kwargs) -> None:
        super(GlobalReachConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.address_prefix = None
        self.authorization_key = authorization_key
        self.circuit_connection_status = None
        self.peer_express_route_circuit = peer_express_route_circuit


class HcxEnterpriseSite(Resource):
    """An HCX Enterprise Site resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar activation_key: The activation key
    :vartype activation_key: str
    :ivar status: The status of the HCX Enterprise Site. Possible values
     include: 'Available', 'Consumed', 'Deactivated', 'Deleted'
    :vartype status: str or ~azure.mgmt.avs.models.HcxEnterpriseSiteStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'activation_key': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'activation_key': {'key': 'properties.activationKey', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(HcxEnterpriseSite, self).__init__(**kwargs)
        self.activation_key = None
        self.status = None


class IdentitySource(Model):
    """vCenter Single Sign On Identity Source.

    :param name: The name of the identity source
    :type name: str
    :param alias: The domain's NetBIOS name
    :type alias: str
    :param domain: The domain's dns name
    :type domain: str
    :param base_user_dn: The base distinguished name for users
    :type base_user_dn: str
    :param base_group_dn: The base distinguished name for groups
    :type base_group_dn: str
    :param primary_server: Primary server URL
    :type primary_server: str
    :param secondary_server: Secondary server URL
    :type secondary_server: str
    :param ssl: Protect LDAP communication using SSL certificate (LDAPS).
     Possible values include: 'Enabled', 'Disabled'
    :type ssl: str or ~azure.mgmt.avs.models.SslEnum
    :param username: The ID of an Active Directory user with a minimum of
     read-only access to Base DN for users and group
    :type username: str
    :param password: The password of the Active Directory user with a minimum
     of read-only access to Base DN for users and groups.
    :type password: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'alias': {'key': 'alias', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'base_user_dn': {'key': 'baseUserDN', 'type': 'str'},
        'base_group_dn': {'key': 'baseGroupDN', 'type': 'str'},
        'primary_server': {'key': 'primaryServer', 'type': 'str'},
        'secondary_server': {'key': 'secondaryServer', 'type': 'str'},
        'ssl': {'key': 'ssl', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, alias: str=None, domain: str=None, base_user_dn: str=None, base_group_dn: str=None, primary_server: str=None, secondary_server: str=None, ssl=None, username: str=None, password: str=None, **kwargs) -> None:
        super(IdentitySource, self).__init__(**kwargs)
        self.name = name
        self.alias = alias
        self.domain = domain
        self.base_user_dn = base_user_dn
        self.base_group_dn = base_group_dn
        self.primary_server = primary_server
        self.secondary_server = secondary_server
        self.ssl = ssl
        self.username = username
        self.password = password


class LogSpecification(Model):
    """Specifications of the Log for Azure Monitoring.

    :param name: Name of the log
    :type name: str
    :param display_name: Localized friendly display name of the log
    :type display_name: str
    :param blob_duration: Blob duration of the log
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, blob_duration: str=None, **kwargs) -> None:
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagementCluster(CommonClusterProperties):
    """The properties of a management cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param cluster_size: The cluster size
    :type cluster_size: int
    :param provisioning_state: The state of the cluster provisioning. Possible
     values include: 'Succeeded', 'Failed', 'Cancelled', 'Deleting', 'Updating'
    :type provisioning_state: str or
     ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity
    :vartype cluster_id: int
    :ivar hosts: The hosts
    :vartype hosts: list[str]
    """

    _validation = {
        'cluster_id': {'readonly': True},
        'hosts': {'readonly': True},
    }

    _attribute_map = {
        'cluster_size': {'key': 'clusterSize', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'cluster_id': {'key': 'clusterId', 'type': 'int'},
        'hosts': {'key': 'hosts', 'type': '[str]'},
    }

    def __init__(self, *, cluster_size: int=None, provisioning_state=None, **kwargs) -> None:
        super(ManagementCluster, self).__init__(cluster_size=cluster_size, provisioning_state=provisioning_state, **kwargs)


class MetricDimension(Model):
    """Specifications of the Dimension of metrics.

    :param name: Name of the dimension
    :type name: str
    :param display_name: Localized friendly display name of the dimension
    :type display_name: str
    :param internal_name: Name of the dimension as it appears in MDM
    :type internal_name: str
    :param to_be_exported_for_shoebox: A boolean flag indicating whether this
     dimension should be included for the shoebox export scenario
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, internal_name: str=None, to_be_exported_for_shoebox: bool=None, **kwargs) -> None:
        super(MetricDimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricSpecification(Model):
    """Specifications of the Metrics for Azure Monitoring.

    :param name: Name of the metric
    :type name: str
    :param display_name: Localized friendly display name of the metric
    :type display_name: str
    :param display_description: Localized friendly description of the metric
    :type display_description: str
    :param unit: Unit that makes sense for the metric
    :type unit: str
    :param category: Name of the metric category that the metric belongs to. A
     metric can only belong to a single category.
    :type category: str
    :param aggregation_type: Only provide one value for this field. Valid
     values: Average, Minimum, Maximum, Total, Count.
    :type aggregation_type: str
    :param supported_aggregation_types: Supported aggregation types
    :type supported_aggregation_types: list[str]
    :param supported_time_grain_types: Supported time grain types
    :type supported_time_grain_types: list[str]
    :param fill_gap_with_zero: Optional. If set to true, then zero will be
     returned for time duration where no metric is emitted/published.
    :type fill_gap_with_zero: bool
    :param dimensions: Dimensions of the metric
    :type dimensions: list[~azure.mgmt.avs.models.MetricDimension]
    :param enable_regional_mdm_account: Whether or not the service is using
     regional MDM accounts.
    :type enable_regional_mdm_account: str
    :param source_mdm_account: The name of the MDM account.
    :type source_mdm_account: str
    :param source_mdm_namespace: The name of the MDM namespace.
    :type source_mdm_namespace: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'str'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, display_description: str=None, unit: str=None, category: str=None, aggregation_type: str=None, supported_aggregation_types=None, supported_time_grain_types=None, fill_gap_with_zero: bool=None, dimensions=None, enable_regional_mdm_account: str=None, source_mdm_account: str=None, source_mdm_namespace: str=None, **kwargs) -> None:
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.category = category
        self.aggregation_type = aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.fill_gap_with_zero = fill_gap_with_zero
        self.dimensions = dimensions
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace


class NetAppVolume(Model):
    """An Azure NetApp Files volume from Microsoft.NetApp provider.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Azure resource ID of the NetApp volume
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(NetAppVolume, self).__init__(**kwargs)
        self.id = id


class Operation(Model):
    """A REST API operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of the operation being performed on this object
    :vartype name: str
    :ivar display: Contains the localized display information for this
     operation
    :vartype display: ~azure.mgmt.avs.models.OperationDisplay
    :param is_data_action: Gets or sets a value indicating whether the
     operation is a data action or not
    :type is_data_action: bool
    :param origin: Origin of the operation
    :type origin: str
    :param properties: Properties of the operation
    :type properties: ~azure.mgmt.avs.models.OperationProperties
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(self, *, is_data_action: bool=None, origin: str=None, properties=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.is_data_action = is_data_action
        self.origin = origin
        self.properties = properties


class OperationDisplay(Model):
    """Contains the localized display information for this operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Localized friendly form of the resource provider name
    :vartype provider: str
    :ivar resource: Localized friendly form of the resource type related to
     this operation
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation
    :vartype operation: str
    :ivar description: Localized friendly description for the operation
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationProperties(Model):
    """Extra Operation properties.

    :param service_specification: Service specifications of the operation
    :type service_specification: ~azure.mgmt.avs.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, *, service_specification=None, **kwargs) -> None:
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str=None, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class PrivateCloud(TrackedResource):
    """A private cloud resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param sku: Required. The private cloud SKU
    :type sku: ~azure.mgmt.avs.models.Sku
    :param management_cluster: The default cluster used for management
    :type management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :param internet: Connectivity to internet is enabled or disabled. Possible
     values include: 'Enabled', 'Disabled'. Default value: "Disabled" .
    :type internet: str or ~azure.mgmt.avs.models.InternetEnum
    :param identity_sources: vCenter Single Sign On Identity Sources
    :type identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Cancelled', 'Pending', 'Building', 'Deleting',
     'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.PrivateCloudProvisioningState
    :param circuit: An ExpressRoute Circuit
    :type circuit: ~azure.mgmt.avs.models.Circuit
    :ivar endpoints: The endpoints
    :vartype endpoints: ~azure.mgmt.avs.models.Endpoints
    :param network_block: Required. The block of addresses should be unique
     across VNet in your subscription as well as on-premise. Make sure the CIDR
     format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255,
     and X is between 0 and 22
    :type network_block: str
    :ivar management_network: Network used to access vCenter Server and NSX-T
     Manager
    :vartype management_network: str
    :ivar provisioning_network: Used for virtual machine cold migration,
     cloning, and snapshot migration
    :vartype provisioning_network: str
    :ivar vmotion_network: Used for live migration of virtual machines
    :vartype vmotion_network: str
    :param vcenter_password: Optionally, set the vCenter admin password when
     the private cloud is created
    :type vcenter_password: str
    :param nsxt_password: Optionally, set the NSX-T Manager password when the
     private cloud is created
    :type nsxt_password: str
    :ivar vcenter_certificate_thumbprint: Thumbprint of the vCenter Server SSL
     certificate
    :vartype vcenter_certificate_thumbprint: str
    :ivar nsxt_certificate_thumbprint: Thumbprint of the NSX-T Manager SSL
     certificate
    :vartype nsxt_certificate_thumbprint: str
    :ivar external_cloud_links: Array of cloud link IDs from other clouds that
     connect to this one
    :vartype external_cloud_links: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoints': {'readonly': True},
        'network_block': {'required': True},
        'management_network': {'readonly': True},
        'provisioning_network': {'readonly': True},
        'vmotion_network': {'readonly': True},
        'vcenter_certificate_thumbprint': {'readonly': True},
        'nsxt_certificate_thumbprint': {'readonly': True},
        'external_cloud_links': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'management_cluster': {'key': 'properties.managementCluster', 'type': 'ManagementCluster'},
        'internet': {'key': 'properties.internet', 'type': 'str'},
        'identity_sources': {'key': 'properties.identitySources', 'type': '[IdentitySource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'circuit': {'key': 'properties.circuit', 'type': 'Circuit'},
        'endpoints': {'key': 'properties.endpoints', 'type': 'Endpoints'},
        'network_block': {'key': 'properties.networkBlock', 'type': 'str'},
        'management_network': {'key': 'properties.managementNetwork', 'type': 'str'},
        'provisioning_network': {'key': 'properties.provisioningNetwork', 'type': 'str'},
        'vmotion_network': {'key': 'properties.vmotionNetwork', 'type': 'str'},
        'vcenter_password': {'key': 'properties.vcenterPassword', 'type': 'str'},
        'nsxt_password': {'key': 'properties.nsxtPassword', 'type': 'str'},
        'vcenter_certificate_thumbprint': {'key': 'properties.vcenterCertificateThumbprint', 'type': 'str'},
        'nsxt_certificate_thumbprint': {'key': 'properties.nsxtCertificateThumbprint', 'type': 'str'},
        'external_cloud_links': {'key': 'properties.externalCloudLinks', 'type': '[str]'},
    }

    def __init__(self, *, sku, network_block: str, location: str=None, tags=None, management_cluster=None, internet="Disabled", identity_sources=None, circuit=None, vcenter_password: str=None, nsxt_password: str=None, **kwargs) -> None:
        super(PrivateCloud, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.management_cluster = management_cluster
        self.internet = internet
        self.identity_sources = identity_sources
        self.provisioning_state = None
        self.circuit = circuit
        self.endpoints = None
        self.network_block = network_block
        self.management_network = None
        self.provisioning_network = None
        self.vmotion_network = None
        self.vcenter_password = vcenter_password
        self.nsxt_password = nsxt_password
        self.vcenter_certificate_thumbprint = None
        self.nsxt_certificate_thumbprint = None
        self.external_cloud_links = None


class PrivateCloudUpdate(Model):
    """An update to a private cloud resource.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param management_cluster: The default cluster used for management
    :type management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :param internet: Connectivity to internet is enabled or disabled. Possible
     values include: 'Enabled', 'Disabled'. Default value: "Disabled" .
    :type internet: str or ~azure.mgmt.avs.models.InternetEnum
    :param identity_sources: vCenter Single Sign On Identity Sources
    :type identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'management_cluster': {'key': 'properties.managementCluster', 'type': 'ManagementCluster'},
        'internet': {'key': 'properties.internet', 'type': 'str'},
        'identity_sources': {'key': 'properties.identitySources', 'type': '[IdentitySource]'},
    }

    def __init__(self, *, tags=None, management_cluster=None, internet="Disabled", identity_sources=None, **kwargs) -> None:
        super(PrivateCloudUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.management_cluster = management_cluster
        self.internet = internet
        self.identity_sources = identity_sources


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class ScriptExecutionParameter(Model):
    """The arguments passed in to the execution.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ScriptSecureStringExecutionParameter,
    ScriptStringExecutionParameter, PSCredentialExecutionParameter

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name
    :type name: str
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'SecureValue': 'ScriptSecureStringExecutionParameter', 'Value': 'ScriptStringExecutionParameter', 'Credential': 'PSCredentialExecutionParameter'}
    }

    def __init__(self, *, name: str, **kwargs) -> None:
        super(ScriptExecutionParameter, self).__init__(**kwargs)
        self.name = name
        self.type = None


class PSCredentialExecutionParameter(ScriptExecutionParameter):
    """a powershell credential object.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name
    :type name: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param username: username for login
    :type username: str
    :param password: password for login
    :type password: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, *, name: str, username: str=None, password: str=None, **kwargs) -> None:
        super(PSCredentialExecutionParameter, self).__init__(name=name, **kwargs)
        self.username = username
        self.password = password
        self.type = 'Credential'


class Quota(Model):
    """Subscription quotas.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar hosts_remaining: Remaining hosts quota by sku type
    :vartype hosts_remaining: dict[str, int]
    :ivar quota_enabled: Host quota is active for current subscription.
     Possible values include: 'Enabled', 'Disabled'
    :vartype quota_enabled: str or ~azure.mgmt.avs.models.QuotaEnabled
    """

    _validation = {
        'hosts_remaining': {'readonly': True},
        'quota_enabled': {'readonly': True},
    }

    _attribute_map = {
        'hosts_remaining': {'key': 'hostsRemaining', 'type': '{int}'},
        'quota_enabled': {'key': 'quotaEnabled', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Quota, self).__init__(**kwargs)
        self.hosts_remaining = None
        self.quota_enabled = None


class ScriptCmdlet(ProxyResource):
    """A cmdlet available for script execution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the scripts functionality
    :vartype description: str
    :ivar timeout: Recommended time limit for execution
    :vartype timeout: str
    :ivar parameters: Parameters the script will accept
    :vartype parameters: list[~azure.mgmt.avs.models.ScriptParameter]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'timeout': {'readonly': True},
        'parameters': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'timeout': {'key': 'properties.timeout', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[ScriptParameter]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ScriptCmdlet, self).__init__(**kwargs)
        self.description = None
        self.timeout = None
        self.parameters = None


class ScriptExecution(ProxyResource):
    """An instance of a script executed by a user - custom or AVS.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param script_cmdlet_id: A reference to the script cmdlet resource if user
     is running a AVS script
    :type script_cmdlet_id: str
    :param parameters: Parameters the script will accept
    :type parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
    :param hidden_parameters: Parameters that will be hidden/not visible to
     ARM, such as passwords and credentials
    :type hidden_parameters:
     list[~azure.mgmt.avs.models.ScriptExecutionParameter]
    :param failure_reason: Error message if the script was able to run, but if
     the script itself had errors or powershell threw an exception
    :type failure_reason: str
    :param timeout: Required. Time limit for execution
    :type timeout: str
    :param retention: Time to live for the resource. If not provided, will be
     available for 60 days
    :type retention: str
    :ivar submitted_at: Time the script execution was submitted
    :vartype submitted_at: datetime
    :ivar started_at: Time the script execution was started
    :vartype started_at: datetime
    :ivar finished_at: Time the script execution was finished
    :vartype finished_at: datetime
    :ivar provisioning_state: The state of the script execution resource.
     Possible values include: 'Pending', 'Running', 'Succeeded', 'Failed',
     'Cancelling', 'Cancelled', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.ScriptExecutionProvisioningState
    :param output: Standard output stream from the powershell execution
    :type output: list[str]
    :param named_outputs: User-defined dictionary.
    :type named_outputs: dict[str, object]
    :ivar information: Standard information out stream from the powershell
     execution
    :vartype information: list[str]
    :ivar warnings: Standard warning out stream from the powershell execution
    :vartype warnings: list[str]
    :ivar errors: Standard error output stream from the powershell execution
    :vartype errors: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'timeout': {'required': True},
        'submitted_at': {'readonly': True},
        'started_at': {'readonly': True},
        'finished_at': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'information': {'readonly': True},
        'warnings': {'readonly': True},
        'errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'script_cmdlet_id': {'key': 'properties.scriptCmdletId', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[ScriptExecutionParameter]'},
        'hidden_parameters': {'key': 'properties.hiddenParameters', 'type': '[ScriptExecutionParameter]'},
        'failure_reason': {'key': 'properties.failureReason', 'type': 'str'},
        'timeout': {'key': 'properties.timeout', 'type': 'str'},
        'retention': {'key': 'properties.retention', 'type': 'str'},
        'submitted_at': {'key': 'properties.submittedAt', 'type': 'iso-8601'},
        'started_at': {'key': 'properties.startedAt', 'type': 'iso-8601'},
        'finished_at': {'key': 'properties.finishedAt', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'output': {'key': 'properties.output', 'type': '[str]'},
        'named_outputs': {'key': 'properties.namedOutputs', 'type': '{object}'},
        'information': {'key': 'properties.information', 'type': '[str]'},
        'warnings': {'key': 'properties.warnings', 'type': '[str]'},
        'errors': {'key': 'properties.errors', 'type': '[str]'},
    }

    def __init__(self, *, timeout: str, script_cmdlet_id: str=None, parameters=None, hidden_parameters=None, failure_reason: str=None, retention: str=None, output=None, named_outputs=None, **kwargs) -> None:
        super(ScriptExecution, self).__init__(**kwargs)
        self.script_cmdlet_id = script_cmdlet_id
        self.parameters = parameters
        self.hidden_parameters = hidden_parameters
        self.failure_reason = failure_reason
        self.timeout = timeout
        self.retention = retention
        self.submitted_at = None
        self.started_at = None
        self.finished_at = None
        self.provisioning_state = None
        self.output = output
        self.named_outputs = named_outputs
        self.information = None
        self.warnings = None
        self.errors = None


class ScriptPackage(ProxyResource):
    """Script Package resources available for execution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: User friendly description of the package
    :vartype description: str
    :ivar version: Module version
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ScriptPackage, self).__init__(**kwargs)
        self.description = None
        self.version = None


class ScriptParameter(Model):
    """An parameter that the script will accept.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The type of parameter the script is expecting. psCredential is
     a PSCredentialObject. Possible values include: 'String', 'SecureString',
     'Credential', 'Int', 'Bool', 'Float'
    :vartype type: str or ~azure.mgmt.avs.models.ScriptParameterTypes
    :param name: The parameter name that the script will expect a parameter
     value for
    :type name: str
    :ivar description: User friendly description of the parameter
    :vartype description: str
    :ivar visibility: Should this parameter be visible to arm and passed in
     the parameters argument when executing. Possible values include:
     'Visible', 'Hidden'
    :vartype visibility: str or ~azure.mgmt.avs.models.VisibilityParameterEnum
    :ivar optional: Is this parameter required or optional. Possible values
     include: 'Optional', 'Required'
    :vartype optional: str or ~azure.mgmt.avs.models.OptionalParamEnum
    """

    _validation = {
        'type': {'readonly': True},
        'description': {'readonly': True},
        'visibility': {'readonly': True},
        'optional': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': 'str'},
        'optional': {'key': 'optional', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(ScriptParameter, self).__init__(**kwargs)
        self.type = None
        self.name = name
        self.description = None
        self.visibility = None
        self.optional = None


class ScriptSecureStringExecutionParameter(ScriptExecutionParameter):
    """a plain text value execution parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name
    :type name: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param secure_value: A secure value for the passed parameter, not to be
     stored in logs
    :type secure_value: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'secure_value': {'key': 'secureValue', 'type': 'str'},
    }

    def __init__(self, *, name: str, secure_value: str=None, **kwargs) -> None:
        super(ScriptSecureStringExecutionParameter, self).__init__(name=name, **kwargs)
        self.secure_value = secure_value
        self.type = 'SecureValue'


class ScriptStringExecutionParameter(ScriptExecutionParameter):
    """a plain text value execution parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name
    :type name: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param value: The value for the passed parameter
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name: str, value: str=None, **kwargs) -> None:
        super(ScriptStringExecutionParameter, self).__init__(name=name, **kwargs)
        self.value = value
        self.type = 'Value'


class ServiceSpecification(Model):
    """Service specification payload.

    :param log_specifications: Specifications of the Log for Azure Monitoring
    :type log_specifications: list[~azure.mgmt.avs.models.LogSpecification]
    :param metric_specifications: Specifications of the Metrics for Azure
     Monitoring
    :type metric_specifications:
     list[~azure.mgmt.avs.models.MetricSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(self, *, log_specifications=None, metric_specifications=None, **kwargs) -> None:
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class Sku(Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.name = name


class Trial(Model):
    """Subscription trial availability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar status: Trial status. Possible values include: 'TrialAvailable',
     'TrialUsed', 'TrialDisabled'
    :vartype status: str or ~azure.mgmt.avs.models.TrialStatus
    :ivar available_hosts: Number of trial hosts available
    :vartype available_hosts: int
    """

    _validation = {
        'status': {'readonly': True},
        'available_hosts': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'available_hosts': {'key': 'availableHosts', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(Trial, self).__init__(**kwargs)
        self.status = None
        self.available_hosts = None


class WorkloadNetworkDhcp(ProxyResource):
    """NSX DHCP.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: DHCP properties.
    :type properties: ~azure.mgmt.avs.models.WorkloadNetworkDhcpEntity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'WorkloadNetworkDhcpEntity'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(WorkloadNetworkDhcp, self).__init__(**kwargs)
        self.properties = properties


class WorkloadNetworkDhcpEntity(Model):
    """Base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to
    inherit from.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WorkloadNetworkDhcpServer, WorkloadNetworkDhcpRelay

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param display_name: Display name of the DHCP entity.
    :type display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    :param dhcp_type: Required. Constant filled by server.
    :type dhcp_type: str
    """

    _validation = {
        'segments': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'dhcp_type': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'segments': {'key': 'segments', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'long'},
        'dhcp_type': {'key': 'dhcpType', 'type': 'str'},
    }

    _subtype_map = {
        'dhcp_type': {'SERVER': 'WorkloadNetworkDhcpServer', 'RELAY': 'WorkloadNetworkDhcpRelay'}
    }

    def __init__(self, *, display_name: str=None, revision: int=None, **kwargs) -> None:
        super(WorkloadNetworkDhcpEntity, self).__init__(**kwargs)
        self.display_name = display_name
        self.segments = None
        self.provisioning_state = None
        self.revision = revision
        self.dhcp_type = None


class WorkloadNetworkDhcpRelay(WorkloadNetworkDhcpEntity):
    """NSX DHCP Relay.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param display_name: Display name of the DHCP entity.
    :type display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    :param dhcp_type: Required. Constant filled by server.
    :type dhcp_type: str
    :param server_addresses: DHCP Relay Addresses. Max 3.
    :type server_addresses: list[str]
    """

    _validation = {
        'segments': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'dhcp_type': {'required': True},
        'server_addresses': {'max_items': 3, 'min_items': 1},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'segments': {'key': 'segments', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'long'},
        'dhcp_type': {'key': 'dhcpType', 'type': 'str'},
        'server_addresses': {'key': 'serverAddresses', 'type': '[str]'},
    }

    def __init__(self, *, display_name: str=None, revision: int=None, server_addresses=None, **kwargs) -> None:
        super(WorkloadNetworkDhcpRelay, self).__init__(display_name=display_name, revision=revision, **kwargs)
        self.server_addresses = server_addresses
        self.dhcp_type = 'RELAY'


class WorkloadNetworkDhcpServer(WorkloadNetworkDhcpEntity):
    """NSX DHCP Server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param display_name: Display name of the DHCP entity.
    :type display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    :param dhcp_type: Required. Constant filled by server.
    :type dhcp_type: str
    :param server_address: DHCP Server Address.
    :type server_address: str
    :param lease_time: DHCP Server Lease Time.
    :type lease_time: long
    """

    _validation = {
        'segments': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'dhcp_type': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'segments': {'key': 'segments', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'revision': {'key': 'revision', 'type': 'long'},
        'dhcp_type': {'key': 'dhcpType', 'type': 'str'},
        'server_address': {'key': 'serverAddress', 'type': 'str'},
        'lease_time': {'key': 'leaseTime', 'type': 'long'},
    }

    def __init__(self, *, display_name: str=None, revision: int=None, server_address: str=None, lease_time: int=None, **kwargs) -> None:
        super(WorkloadNetworkDhcpServer, self).__init__(display_name=display_name, revision=revision, **kwargs)
        self.server_address = server_address
        self.lease_time = lease_time
        self.dhcp_type = 'SERVER'


class WorkloadNetworkDnsService(ProxyResource):
    """NSX DNS Service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the DNS Service.
    :type display_name: str
    :param dns_service_ip: DNS service IP of the DNS Service.
    :type dns_service_ip: str
    :param default_dns_zone: Default DNS zone of the DNS Service.
    :type default_dns_zone: str
    :param fqdn_zones: FQDN zones of the DNS Service.
    :type fqdn_zones: list[str]
    :param log_level: DNS Service log level. Possible values include: 'DEBUG',
     'INFO', 'WARNING', 'ERROR', 'FATAL'
    :type log_level: str or ~azure.mgmt.avs.models.DnsServiceLogLevelEnum
    :ivar status: DNS Service status. Possible values include: 'SUCCESS',
     'FAILURE'
    :vartype status: str or ~azure.mgmt.avs.models.DnsServiceStatusEnum
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDnsServiceProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'dns_service_ip': {'key': 'properties.dnsServiceIp', 'type': 'str'},
        'default_dns_zone': {'key': 'properties.defaultDnsZone', 'type': 'str'},
        'fqdn_zones': {'key': 'properties.fqdnZones', 'type': '[str]'},
        'log_level': {'key': 'properties.logLevel', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(self, *, display_name: str=None, dns_service_ip: str=None, default_dns_zone: str=None, fqdn_zones=None, log_level=None, revision: int=None, **kwargs) -> None:
        super(WorkloadNetworkDnsService, self).__init__(**kwargs)
        self.display_name = display_name
        self.dns_service_ip = dns_service_ip
        self.default_dns_zone = default_dns_zone
        self.fqdn_zones = fqdn_zones
        self.log_level = log_level
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkDnsZone(ProxyResource):
    """NSX DNS Zone.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the DNS Zone.
    :type display_name: str
    :param domain: Domain names of the DNS Zone.
    :type domain: list[str]
    :param dns_server_ips: DNS Server IP array of the DNS Zone.
    :type dns_server_ips: list[str]
    :param source_ip: Source IP of the DNS Zone.
    :type source_ip: str
    :param dns_services: Number of DNS Services using the DNS zone.
    :type dns_services: long
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDnsZoneProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'domain': {'key': 'properties.domain', 'type': '[str]'},
        'dns_server_ips': {'key': 'properties.dnsServerIps', 'type': '[str]'},
        'source_ip': {'key': 'properties.sourceIp', 'type': 'str'},
        'dns_services': {'key': 'properties.dnsServices', 'type': 'long'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(self, *, display_name: str=None, domain=None, dns_server_ips=None, source_ip: str=None, dns_services: int=None, revision: int=None, **kwargs) -> None:
        super(WorkloadNetworkDnsZone, self).__init__(**kwargs)
        self.display_name = display_name
        self.domain = domain
        self.dns_server_ips = dns_server_ips
        self.source_ip = source_ip
        self.dns_services = dns_services
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkGateway(ProxyResource):
    """NSX Gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the DHCP entity.
    :type display_name: str
    :ivar path: NSX Gateway Path.
    :vartype path: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'path': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
    }

    def __init__(self, *, display_name: str=None, **kwargs) -> None:
        super(WorkloadNetworkGateway, self).__init__(**kwargs)
        self.display_name = display_name
        self.path = None


class WorkloadNetworkPortMirroring(ProxyResource):
    """NSX Port Mirroring.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the port mirroring profile.
    :type display_name: str
    :param direction: Direction of port mirroring profile. Possible values
     include: 'INGRESS, EGRESS, BIDIRECTIONAL'
    :type direction: str or ~azure.mgmt.avs.models.PortMirroringDirectionEnum
    :param source: Source VM Group.
    :type source: str
    :param destination: Destination VM Group.
    :type destination: str
    :ivar status: Port Mirroring Status. Possible values include: 'SUCCESS,
     FAILURE'
    :vartype status: str or ~azure.mgmt.avs.models.PortMirroringStatusEnum
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkPortMirroringProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'destination': {'key': 'properties.destination', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(self, *, display_name: str=None, direction=None, source: str=None, destination: str=None, revision: int=None, **kwargs) -> None:
        super(WorkloadNetworkPortMirroring, self).__init__(**kwargs)
        self.display_name = display_name
        self.direction = direction
        self.source = source
        self.destination = destination
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkPublicIP(ProxyResource):
    """NSX Public IP Block.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the Public IP Block.
    :type display_name: str
    :param number_of_public_ips: Number of Public IPs requested.
    :type number_of_public_ips: long
    :ivar public_ip_block: CIDR Block of the Public IP Block.
    :vartype public_ip_block: str
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkPublicIPProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'public_ip_block': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'number_of_public_ips': {'key': 'properties.numberOfPublicIPs', 'type': 'long'},
        'public_ip_block': {'key': 'properties.publicIPBlock', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, display_name: str=None, number_of_public_ips: int=None, **kwargs) -> None:
        super(WorkloadNetworkPublicIP, self).__init__(**kwargs)
        self.display_name = display_name
        self.number_of_public_ips = number_of_public_ips
        self.public_ip_block = None
        self.provisioning_state = None


class WorkloadNetworkSegment(ProxyResource):
    """NSX Segment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the segment.
    :type display_name: str
    :param connected_gateway: Gateway which to connect segment to.
    :type connected_gateway: str
    :param subnet: Subnet which to connect segment to.
    :type subnet: ~azure.mgmt.avs.models.WorkloadNetworkSegmentSubnet
    :ivar port_vif: Port Vif which segment is associated with.
    :vartype port_vif:
     list[~azure.mgmt.avs.models.WorkloadNetworkSegmentPortVif]
    :ivar status: Segment status. Possible values include: 'SUCCESS, FAILURE'
    :vartype status: str or ~azure.mgmt.avs.models.SegmentStatusEnum
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkSegmentProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'port_vif': {'readonly': True},
        'status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'connected_gateway': {'key': 'properties.connectedGateway', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'WorkloadNetworkSegmentSubnet'},
        'port_vif': {'key': 'properties.portVif', 'type': '[WorkloadNetworkSegmentPortVif]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(self, *, display_name: str=None, connected_gateway: str=None, subnet=None, revision: int=None, **kwargs) -> None:
        super(WorkloadNetworkSegment, self).__init__(**kwargs)
        self.display_name = display_name
        self.connected_gateway = connected_gateway
        self.subnet = subnet
        self.port_vif = None
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkSegmentPortVif(Model):
    """Ports and any VIF attached to segment.

    :param port_name: Name of port or VIF attached to segment.
    :type port_name: str
    """

    _attribute_map = {
        'port_name': {'key': 'portName', 'type': 'str'},
    }

    def __init__(self, *, port_name: str=None, **kwargs) -> None:
        super(WorkloadNetworkSegmentPortVif, self).__init__(**kwargs)
        self.port_name = port_name


class WorkloadNetworkSegmentSubnet(Model):
    """Subnet configuration for segment.

    :param dhcp_ranges: DHCP Range assigned for subnet.
    :type dhcp_ranges: list[str]
    :param gateway_address: Gateway address.
    :type gateway_address: str
    """

    _attribute_map = {
        'dhcp_ranges': {'key': 'dhcpRanges', 'type': '[str]'},
        'gateway_address': {'key': 'gatewayAddress', 'type': 'str'},
    }

    def __init__(self, *, dhcp_ranges=None, gateway_address: str=None, **kwargs) -> None:
        super(WorkloadNetworkSegmentSubnet, self).__init__(**kwargs)
        self.dhcp_ranges = dhcp_ranges
        self.gateway_address = gateway_address


class WorkloadNetworkVirtualMachine(ProxyResource):
    """NSX Virtual Machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the VM.
    :type display_name: str
    :ivar vm_type: Virtual machine type. Possible values include: 'REGULAR,
     EDGE, SERVICE'
    :vartype vm_type: str or ~azure.mgmt.avs.models.VMTypeEnum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'vm_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'vm_type': {'key': 'properties.vmType', 'type': 'str'},
    }

    def __init__(self, *, display_name: str=None, **kwargs) -> None:
        super(WorkloadNetworkVirtualMachine, self).__init__(**kwargs)
        self.display_name = display_name
        self.vm_type = None


class WorkloadNetworkVMGroup(ProxyResource):
    """NSX VM Group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param display_name: Display name of the VM group.
    :type display_name: str
    :param members: Virtual machine members of this group.
    :type members: list[str]
    :ivar status: VM Group status. Possible values include: 'SUCCESS, FAILURE'
    :vartype status: str or ~azure.mgmt.avs.models.VMGroupStatusEnum
    :ivar provisioning_state: The provisioning state. Possible values include:
     'Succeeded', 'Failed', 'Building', 'Deleting', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkVMGroupProvisioningState
    :param revision: NSX revision number.
    :type revision: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'members': {'key': 'properties.members', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'revision': {'key': 'properties.revision', 'type': 'long'},
    }

    def __init__(self, *, display_name: str=None, members=None, revision: int=None, **kwargs) -> None:
        super(WorkloadNetworkVMGroup, self).__init__(**kwargs)
        self.display_name = display_name
        self.members = members
        self.status = None
        self.provisioning_state = None
        self.revision = revision
