# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AsyncOperationResult(Model):
    """Result of a long running operation.

    :param status: current status of a long running operation.
    :type status: str
    :param error: Error message containing code, description and details
    :type error: ~azure.mgmt.iothubprovisioningservices.models.ErrorMesssage
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorMesssage'},
    }

    def __init__(self, **kwargs):
        super(AsyncOperationResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class CertificateBodyDescription(Model):
    """The JSON-serialized X509 Certificate.

    :param certificate: Base-64 representation of the X509 leaf certificate
     .cer file or just .pem file content.
    :type certificate: str
    :param is_verified: True indicates that the certificate will be created in
     verified state and proof of possession will not be required.
    :type is_verified: bool
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(CertificateBodyDescription, self).__init__(**kwargs)
        self.certificate = kwargs.get('certificate', None)
        self.is_verified = kwargs.get('is_verified', None)


class CertificateListDescription(Model):
    """The JSON-serialized array of Certificate objects.

    :param value: The array of Certificate objects.
    :type value:
     list[~azure.mgmt.iothubprovisioningservices.models.CertificateResponse]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CertificateResponse]'},
    }

    def __init__(self, **kwargs):
        super(CertificateListDescription, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class CertificateProperties(Model):
    """The description of an X509 CA Certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar certificate: base-64 representation of X509 certificate .cer file or
     just .pem file content.
    :vartype certificate: bytearray
    :ivar created: The certificate's creation date and time.
    :vartype created: datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: datetime
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'certificate': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(CertificateProperties, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.certificate = None
        self.created = None
        self.updated = None


class CertificateResponse(Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param properties: properties of a certificate
    :type properties:
     ~azure.mgmt.iothubprovisioningservices.models.CertificateProperties
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificateProperties'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CertificateResponse, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ErrorDetails(Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar http_status_code: The HTTP status code.
    :vartype http_status_code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        'code': {'readonly': True},
        'http_status_code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'http_status_code': {'key': 'httpStatusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.http_status_code = None
        self.message = None
        self.details = None


class ErrorDetailsException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorDetails'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorDetailsException, self).__init__(deserialize, response, 'ErrorDetails', *args)


class ErrorMesssage(Model):
    """Error response containing message and code.

    :param code: standard error code
    :type code: str
    :param message: standard error description
    :type message: str
    :param details: detailed summary of error
    :type details: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorMesssage, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class GroupIdInformation(Model):
    """The group information for creating a private endpoint on a provisioning
    service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties: Required. The properties for a group information object
    :type properties:
     ~azure.mgmt.iothubprovisioningservices.models.GroupIdInformationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'GroupIdInformationProperties'},
    }

    def __init__(self, **kwargs):
        super(GroupIdInformation, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = kwargs.get('properties', None)


class GroupIdInformationProperties(Model):
    """The properties for a group information object.

    :param group_id: The group id
    :type group_id: str
    :param required_members: The required members for a specific group id
    :type required_members: list[str]
    :param required_zone_names: The required DNS zones for a specific group id
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(GroupIdInformationProperties, self).__init__(**kwargs)
        self.group_id = kwargs.get('group_id', None)
        self.required_members = kwargs.get('required_members', None)
        self.required_zone_names = kwargs.get('required_zone_names', None)


class IotDpsPropertiesDescription(Model):
    """the service specific properties of a provisioning service, including keys,
    linked iot hubs, current state, and system generated properties such as
    hostname and idScope.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param state: Current state of the provisioning service. Possible values
     include: 'Activating', 'Active', 'Deleting', 'Deleted',
     'ActivationFailed', 'DeletionFailed', 'Transitioning', 'Suspending',
     'Suspended', 'Resuming', 'FailingOver', 'FailoverFailed'
    :type state: str or ~azure.mgmt.iothubprovisioningservices.models.State
    :param public_network_access: Whether requests from Public Network are
     allowed. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.iothubprovisioningservices.models.PublicNetworkAccess
    :param ip_filter_rules: The IP filter rules.
    :type ip_filter_rules:
     list[~azure.mgmt.iothubprovisioningservices.models.IpFilterRule]
    :param private_endpoint_connections: Private endpoint connections created
     on this IotHub
    :type private_endpoint_connections:
     list[~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnection]
    :param provisioning_state: The ARM provisioning state of the provisioning
     service.
    :type provisioning_state: str
    :param iot_hubs: List of IoT hubs associated with this provisioning
     service.
    :type iot_hubs:
     list[~azure.mgmt.iothubprovisioningservices.models.IotHubDefinitionDescription]
    :param allocation_policy: Allocation policy to be used by this
     provisioning service. Possible values include: 'Hashed', 'GeoLatency',
     'Static'
    :type allocation_policy: str or
     ~azure.mgmt.iothubprovisioningservices.models.AllocationPolicy
    :ivar service_operations_host_name: Service endpoint for provisioning
     service.
    :vartype service_operations_host_name: str
    :ivar device_provisioning_host_name: Device endpoint for this provisioning
     service.
    :vartype device_provisioning_host_name: str
    :ivar id_scope: Unique identifier of this provisioning service.
    :vartype id_scope: str
    :param authorization_policies: List of authorization keys for a
     provisioning service.
    :type authorization_policies:
     list[~azure.mgmt.iothubprovisioningservices.models.SharedAccessSignatureAuthorizationRuleAccessRightsDescription]
    """

    _validation = {
        'service_operations_host_name': {'readonly': True},
        'device_provisioning_host_name': {'readonly': True},
        'id_scope': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'ip_filter_rules': {'key': 'ipFilterRules', 'type': '[IpFilterRule]'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'iot_hubs': {'key': 'iotHubs', 'type': '[IotHubDefinitionDescription]'},
        'allocation_policy': {'key': 'allocationPolicy', 'type': 'str'},
        'service_operations_host_name': {'key': 'serviceOperationsHostName', 'type': 'str'},
        'device_provisioning_host_name': {'key': 'deviceProvisioningHostName', 'type': 'str'},
        'id_scope': {'key': 'idScope', 'type': 'str'},
        'authorization_policies': {'key': 'authorizationPolicies', 'type': '[SharedAccessSignatureAuthorizationRuleAccessRightsDescription]'},
    }

    def __init__(self, **kwargs):
        super(IotDpsPropertiesDescription, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.ip_filter_rules = kwargs.get('ip_filter_rules', None)
        self.private_endpoint_connections = kwargs.get('private_endpoint_connections', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.iot_hubs = kwargs.get('iot_hubs', None)
        self.allocation_policy = kwargs.get('allocation_policy', None)
        self.service_operations_host_name = None
        self.device_provisioning_host_name = None
        self.id_scope = None
        self.authorization_policies = kwargs.get('authorization_policies', None)


class IotDpsSkuDefinition(Model):
    """Available SKUs of tier and units.

    :param name: Sku name. Possible values include: 'S1'
    :type name: str or ~azure.mgmt.iothubprovisioningservices.models.IotDpsSku
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IotDpsSkuDefinition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class IotDpsSkuInfo(Model):
    """List of possible provisioning service SKUs.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: Sku name. Possible values include: 'S1'
    :type name: str or ~azure.mgmt.iothubprovisioningservices.models.IotDpsSku
    :ivar tier: Pricing tier name of the provisioning service.
    :vartype tier: str
    :param capacity: The number of units to provision
    :type capacity: long
    """

    _validation = {
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(IotDpsSkuInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = None
        self.capacity = kwargs.get('capacity', None)


class IotHubDefinitionDescription(Model):
    """Description of the IoT hub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param apply_allocation_policy: flag for applying allocationPolicy or not
     for a given iot hub.
    :type apply_allocation_policy: bool
    :param allocation_weight: weight to apply for a given iot h.
    :type allocation_weight: int
    :ivar name: Host name of the IoT hub.
    :vartype name: str
    :param connection_string: Required. Connection string of the IoT hub.
    :type connection_string: str
    :param location: Required. ARM region of the IoT hub.
    :type location: str
    """

    _validation = {
        'name': {'readonly': True},
        'connection_string': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'apply_allocation_policy': {'key': 'applyAllocationPolicy', 'type': 'bool'},
        'allocation_weight': {'key': 'allocationWeight', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IotHubDefinitionDescription, self).__init__(**kwargs)
        self.apply_allocation_policy = kwargs.get('apply_allocation_policy', None)
        self.allocation_weight = kwargs.get('allocation_weight', None)
        self.name = None
        self.connection_string = kwargs.get('connection_string', None)
        self.location = kwargs.get('location', None)


class IpFilterRule(Model):
    """The IP filter rules for a provisioning Service.

    All required parameters must be populated in order to send to Azure.

    :param filter_name: Required. The name of the IP filter rule.
    :type filter_name: str
    :param action: Required. The desired action for requests captured by this
     rule. Possible values include: 'Accept', 'Reject'
    :type action: str or
     ~azure.mgmt.iothubprovisioningservices.models.IpFilterActionType
    :param ip_mask: Required. A string that contains the IP address range in
     CIDR notation for the rule.
    :type ip_mask: str
    :param target: Target for requests captured by this rule. Possible values
     include: 'all', 'serviceApi', 'deviceApi'
    :type target: str or
     ~azure.mgmt.iothubprovisioningservices.models.IpFilterTargetType
    """

    _validation = {
        'filter_name': {'required': True},
        'action': {'required': True},
        'ip_mask': {'required': True},
    }

    _attribute_map = {
        'filter_name': {'key': 'filterName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'IpFilterActionType'},
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'target': {'key': 'target', 'type': 'IpFilterTargetType'},
    }

    def __init__(self, **kwargs):
        super(IpFilterRule, self).__init__(**kwargs)
        self.filter_name = kwargs.get('filter_name', None)
        self.action = kwargs.get('action', None)
        self.ip_mask = kwargs.get('ip_mask', None)
        self.target = kwargs.get('target', None)


class NameAvailabilityInfo(Model):
    """Description of name availability.

    :param name_available: specifies if a name is available or not
    :type name_available: bool
    :param reason: specifies the reason a name is unavailable. Possible values
     include: 'Invalid', 'AlreadyExists'
    :type reason: str or
     ~azure.mgmt.iothubprovisioningservices.models.NameUnavailabilityReason
    :param message: message containing a detailed reason name is unavailable
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameAvailabilityInfo, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class Operation(Model):
    """Provisioning Service REST API operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action |
     delete}
    :vartype name: str
    :param display: The object that represents the operation.
    :type display:
     ~azure.mgmt.iothubprovisioningservices.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Service provider: Microsoft Devices.
    :vartype provider: str
    :ivar resource: Resource Type: ProvisioningServices.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationInputs(Model):
    """Input values for operation results call.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the Provisioning Service to check.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationInputs, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class PrivateEndpoint(Model):
    """The private endpoint property of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Model):
    """The private endpoint connection of a provisioning service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties: Required. The properties of a private endpoint
     connection
    :type properties:
     ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionProperties'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = kwargs.get('properties', None)


class PrivateEndpointConnectionProperties(Model):
    """The properties of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :param private_endpoint: The private endpoint property of a private
     endpoint connection
    :type private_endpoint:
     ~azure.mgmt.iothubprovisioningservices.models.PrivateEndpoint
    :param private_link_service_connection_state: Required. The current state
     of a private endpoint connection
    :type private_link_service_connection_state:
     ~azure.mgmt.iothubprovisioningservices.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'private_link_service_connection_state': {'required': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)


class PrivateLinkResources(Model):
    """The available private link resources for a provisioning service.

    :param value: The list of available private link resources for a
     provisioning service
    :type value:
     list[~azure.mgmt.iothubprovisioningservices.models.GroupIdInformation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GroupIdInformation]'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResources, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(Model):
    """The current state of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of a private endpoint connection.
     Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.iothubprovisioningservices.models.PrivateLinkServiceConnectionStatus
    :param description: Required. The description for the current state of a
     private endpoint connection
    :type description: str
    :param actions_required: Actions required for a private endpoint
     connection
    :type actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class Resource(Model):
    """The common properties of an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class ProvisioningServiceDescription(Resource):
    """The description of the provisioning service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    :param etag: The Etag field is *not* required. If it is provided in the
     response body, it must also be provided as a header per the normal ETag
     convention.
    :type etag: str
    :param properties: Required. Service specific properties for a
     provisioning service
    :type properties:
     ~azure.mgmt.iothubprovisioningservices.models.IotDpsPropertiesDescription
    :param sku: Required. Sku info for a provisioning Service.
    :type sku: ~azure.mgmt.iothubprovisioningservices.models.IotDpsSkuInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IotDpsPropertiesDescription'},
        'sku': {'key': 'sku', 'type': 'IotDpsSkuInfo'},
    }

    def __init__(self, **kwargs):
        super(ProvisioningServiceDescription, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)


class SharedAccessSignatureAuthorizationRuleAccessRightsDescription(Model):
    """Description of the shared access key.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Name of the key.
    :type key_name: str
    :param primary_key: Primary SAS key value.
    :type primary_key: str
    :param secondary_key: Secondary SAS key value.
    :type secondary_key: str
    :param rights: Required. Rights that this key has. Possible values
     include: 'ServiceConfig', 'EnrollmentRead', 'EnrollmentWrite',
     'DeviceConnect', 'RegistrationStatusRead', 'RegistrationStatusWrite'
    :type rights: str or
     ~azure.mgmt.iothubprovisioningservices.models.AccessRightsDescription
    """

    _validation = {
        'key_name': {'required': True},
        'rights': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'rights': {'key': 'rights', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SharedAccessSignatureAuthorizationRuleAccessRightsDescription, self).__init__(**kwargs)
        self.key_name = kwargs.get('key_name', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.rights = kwargs.get('rights', None)


class TagsResource(Model):
    """A container holding only the Tags for a resource, allowing the user to
    update the tags on a Provisioning Service instance.

    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TagsResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class VerificationCodeRequest(Model):
    """The JSON-serialized leaf certificate.

    :param certificate: base-64 representation of X509 certificate .cer file
     or just .pem file content.
    :type certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VerificationCodeRequest, self).__init__(**kwargs)
        self.certificate = kwargs.get('certificate', None)


class VerificationCodeResponse(Model):
    """Description of the response of the verification code.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of certificate.
    :vartype name: str
    :ivar etag: Request etag.
    :vartype etag: str
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties:
    :type properties:
     ~azure.mgmt.iothubprovisioningservices.models.VerificationCodeResponseProperties
    """

    _validation = {
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'VerificationCodeResponseProperties'},
    }

    def __init__(self, **kwargs):
        super(VerificationCodeResponse, self).__init__(**kwargs)
        self.name = None
        self.etag = None
        self.id = None
        self.type = None
        self.properties = kwargs.get('properties', None)


class VerificationCodeResponseProperties(Model):
    """VerificationCodeResponseProperties.

    :param verification_code: Verification code.
    :type verification_code: str
    :param subject: Certificate subject.
    :type subject: str
    :param expiry: Code expiry.
    :type expiry: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param is_verified: Indicate if the certificate is verified by owner of
     private key.
    :type is_verified: bool
    :param certificate: base-64 representation of X509 certificate .cer file
     or just .pem file content.
    :type certificate: bytearray
    :param created: Certificate created time.
    :type created: str
    :param updated: Certificate updated time.
    :type updated: str
    """

    _attribute_map = {
        'verification_code': {'key': 'verificationCode', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'created': {'key': 'created', 'type': 'str'},
        'updated': {'key': 'updated', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VerificationCodeResponseProperties, self).__init__(**kwargs)
        self.verification_code = kwargs.get('verification_code', None)
        self.subject = kwargs.get('subject', None)
        self.expiry = kwargs.get('expiry', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.is_verified = kwargs.get('is_verified', None)
        self.certificate = kwargs.get('certificate', None)
        self.created = kwargs.get('created', None)
        self.updated = kwargs.get('updated', None)
