# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Optional, TypeVar, Union

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._operations import build_deployment_operations_get_at_management_group_scope_request, build_deployment_operations_get_at_scope_request, build_deployment_operations_get_at_subscription_scope_request, build_deployment_operations_get_at_tenant_scope_request, build_deployment_operations_get_request, build_deployment_operations_list_at_management_group_scope_request, build_deployment_operations_list_at_scope_request, build_deployment_operations_list_at_subscription_scope_request, build_deployment_operations_list_at_tenant_scope_request, build_deployment_operations_list_request, build_deployments_calculate_template_hash_request, build_deployments_cancel_at_management_group_scope_request, build_deployments_cancel_at_scope_request, build_deployments_cancel_at_subscription_scope_request, build_deployments_cancel_at_tenant_scope_request, build_deployments_cancel_request, build_deployments_check_existence_at_management_group_scope_request, build_deployments_check_existence_at_scope_request, build_deployments_check_existence_at_subscription_scope_request, build_deployments_check_existence_at_tenant_scope_request, build_deployments_check_existence_request, build_deployments_create_or_update_at_management_group_scope_request_initial, build_deployments_create_or_update_at_scope_request_initial, build_deployments_create_or_update_at_subscription_scope_request_initial, build_deployments_create_or_update_at_tenant_scope_request_initial, build_deployments_create_or_update_request_initial, build_deployments_delete_at_management_group_scope_request_initial, build_deployments_delete_at_scope_request_initial, build_deployments_delete_at_subscription_scope_request_initial, build_deployments_delete_at_tenant_scope_request_initial, build_deployments_delete_request_initial, build_deployments_export_template_at_management_group_scope_request, build_deployments_export_template_at_scope_request, build_deployments_export_template_at_subscription_scope_request, build_deployments_export_template_at_tenant_scope_request, build_deployments_export_template_request, build_deployments_get_at_management_group_scope_request, build_deployments_get_at_scope_request, build_deployments_get_at_subscription_scope_request, build_deployments_get_at_tenant_scope_request, build_deployments_get_request, build_deployments_list_at_management_group_scope_request, build_deployments_list_at_scope_request, build_deployments_list_at_subscription_scope_request, build_deployments_list_at_tenant_scope_request, build_deployments_list_by_resource_group_request, build_deployments_validate_at_management_group_scope_request, build_deployments_validate_at_scope_request, build_deployments_validate_at_subscription_scope_request, build_deployments_validate_at_tenant_scope_request, build_deployments_validate_request, build_deployments_what_if_at_subscription_scope_request_initial, build_deployments_what_if_request_initial, build_operations_list_request, build_providers_get_at_tenant_scope_request, build_providers_get_request, build_providers_list_at_tenant_scope_request, build_providers_list_request, build_providers_register_request, build_providers_unregister_request, build_resource_groups_check_existence_request, build_resource_groups_create_or_update_request, build_resource_groups_delete_request_initial, build_resource_groups_export_template_request_initial, build_resource_groups_get_request, build_resource_groups_list_request, build_resource_groups_update_request, build_resources_check_existence_by_id_request, build_resources_check_existence_request, build_resources_create_or_update_by_id_request_initial, build_resources_create_or_update_request_initial, build_resources_delete_by_id_request_initial, build_resources_delete_request_initial, build_resources_get_by_id_request, build_resources_get_request, build_resources_list_by_resource_group_request, build_resources_list_request, build_resources_move_resources_request_initial, build_resources_update_by_id_request_initial, build_resources_update_request_initial, build_resources_validate_move_resources_request_initial, build_tags_create_or_update_request, build_tags_create_or_update_value_request, build_tags_delete_request, build_tags_delete_value_request, build_tags_list_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class Operations:
    """Operations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.resource.resources.v2019_08_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list(
        self,
        **kwargs: Any
    ) -> AsyncIterable["_models.OperationListResult"]:
        """Lists all of the available Microsoft.Resources REST API operations.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OperationListResult or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.OperationListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.OperationListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_operations_list_request(
                    api_version=api_version,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_operations_list_request(
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("OperationListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/providers/Microsoft.Resources/operations"}  # type: ignore
class DeploymentsOperations:  # pylint: disable=too-many-public-methods
    """DeploymentsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.resource.resources.v2019_08_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def _delete_at_scope_initial(  # pylint: disable=inconsistent-return-statements
        self,
        scope: str,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_delete_at_scope_request_initial(
            scope=scope,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self._delete_at_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_at_scope_initial.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_delete_at_scope(  # pylint: disable=inconsistent-return-statements
        self,
        scope: str,
        deployment_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a deployment from the deployment history.

        A template deployment that is currently running cannot be deleted. Deleting a template
        deployment removes the associated deployment operations. This is an asynchronous operation that
        returns a status of 202 until the template deployment is successfully deleted. The Location
        response header contains the URI that is used to obtain the status of the process. While the
        process is running, a call to the URI in the Location header returns a status of 202. When the
        process finishes, the URI in the Location header returns a status of 204 on success. If the
        asynchronous request failed, the URI in the Location header returns an error-level status code.

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_at_scope_initial(
                scope=scope,
                deployment_name=deployment_name,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def check_existence_at_scope(
        self,
        scope: str,
        deployment_name: str,
        **kwargs: Any
    ) -> bool:
        """Checks whether the deployment exists.

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_check_existence_at_scope_request(
            scope=scope,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.check_existence_at_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    check_existence_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    async def _create_or_update_at_scope_initial(
        self,
        scope: str,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Deployment')

        request = build_deployments_create_or_update_at_scope_request_initial(
            scope=scope,
            deployment_name=deployment_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._create_or_update_at_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_at_scope_initial.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_create_or_update_at_scope(
        self,
        scope: str,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.DeploymentExtended"]:
        """Deploys resources at a given scope.

        You can provide the template and parameters directly in the request or link to JSON files.

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Additional parameters supplied to the operation.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.Deployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either DeploymentExtended or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_or_update_at_scope_initial(
                scope=scope,
                deployment_name=deployment_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def get_at_scope(
        self,
        scope: str,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        """Gets a deployment.

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExtended, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_get_at_scope_request(
            scope=scope,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.get_at_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def cancel_at_scope(  # pylint: disable=inconsistent-return-statements
        self,
        scope: str,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        """Cancels a currently running template deployment.

        You can cancel a deployment only if the provisioningState is Accepted or Running. After the
        deployment is canceled, the provisioningState is set to Canceled. Canceling a template
        deployment stops the currently running template deployment and leaves the resources partially
        deployed.

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_cancel_at_scope_request(
            scope=scope,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.cancel_at_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    cancel_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel"}  # type: ignore


    @distributed_trace_async
    async def validate_at_scope(
        self,
        scope: str,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> "_models.DeploymentValidateResult":
        """Validates whether the specified template is syntactically correct and will be accepted by Azure
        Resource Manager..

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Parameters to validate.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.Deployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentValidateResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentValidateResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentValidateResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Deployment')

        request = build_deployments_validate_at_scope_request(
            scope=scope,
            deployment_name=deployment_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.validate_at_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/validate"}  # type: ignore


    @distributed_trace_async
    async def export_template_at_scope(
        self,
        scope: str,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExportResult":
        """Exports the template used for specified deployment.

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExportResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExportResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExportResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_export_template_at_scope_request(
            scope=scope,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.export_template_at_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExportResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    export_template_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate"}  # type: ignore


    @distributed_trace
    def list_at_scope(
        self,
        scope: str,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentListResult"]:
        """Get all the deployments at the given scope.

        :param scope: The scope of a deployment.
        :type scope: str
        :param filter: The filter to apply on the operation. For example, you can use
         $filter=provisioningState eq '{state}'. Default value is None.
        :type filter: str
        :param top: The number of results to get. If null is passed, returns all deployments. Default
         value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployments_list_at_scope_request(
                    scope=scope,
                    api_version=api_version,
                    filter=filter,
                    top=top,
                    template_url=self.list_at_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployments_list_at_scope_request(
                    scope=scope,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/"}  # type: ignore

    async def _delete_at_tenant_scope_initial(  # pylint: disable=inconsistent-return-statements
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_delete_at_tenant_scope_request_initial(
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self._delete_at_tenant_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_at_tenant_scope_initial.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_delete_at_tenant_scope(  # pylint: disable=inconsistent-return-statements
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a deployment from the deployment history.

        A template deployment that is currently running cannot be deleted. Deleting a template
        deployment removes the associated deployment operations. This is an asynchronous operation that
        returns a status of 202 until the template deployment is successfully deleted. The Location
        response header contains the URI that is used to obtain the status of the process. While the
        process is running, a call to the URI in the Location header returns a status of 202. When the
        process finishes, the URI in the Location header returns a status of 204 on success. If the
        asynchronous request failed, the URI in the Location header returns an error-level status code.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_at_tenant_scope_initial(
                deployment_name=deployment_name,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def check_existence_at_tenant_scope(
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> bool:
        """Checks whether the deployment exists.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_check_existence_at_tenant_scope_request(
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.check_existence_at_tenant_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    check_existence_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    async def _create_or_update_at_tenant_scope_initial(
        self,
        deployment_name: str,
        parameters: "_models.ScopedDeployment",
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ScopedDeployment')

        request = build_deployments_create_or_update_at_tenant_scope_request_initial(
            deployment_name=deployment_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._create_or_update_at_tenant_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_at_tenant_scope_initial.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_create_or_update_at_tenant_scope(
        self,
        deployment_name: str,
        parameters: "_models.ScopedDeployment",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.DeploymentExtended"]:
        """Deploys resources at tenant scope.

        You can provide the template and parameters directly in the request or link to JSON files.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Additional parameters supplied to the operation.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ScopedDeployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either DeploymentExtended or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_or_update_at_tenant_scope_initial(
                deployment_name=deployment_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def get_at_tenant_scope(
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        """Gets a deployment.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExtended, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_get_at_tenant_scope_request(
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.get_at_tenant_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def cancel_at_tenant_scope(  # pylint: disable=inconsistent-return-statements
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        """Cancels a currently running template deployment.

        You can cancel a deployment only if the provisioningState is Accepted or Running. After the
        deployment is canceled, the provisioningState is set to Canceled. Canceling a template
        deployment stops the currently running template deployment and leaves the resources partially
        deployed.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_cancel_at_tenant_scope_request(
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.cancel_at_tenant_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    cancel_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}/cancel"}  # type: ignore


    @distributed_trace_async
    async def validate_at_tenant_scope(
        self,
        deployment_name: str,
        parameters: "_models.ScopedDeployment",
        **kwargs: Any
    ) -> "_models.DeploymentValidateResult":
        """Validates whether the specified template is syntactically correct and will be accepted by Azure
        Resource Manager..

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Parameters to validate.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ScopedDeployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentValidateResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentValidateResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentValidateResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ScopedDeployment')

        request = build_deployments_validate_at_tenant_scope_request(
            deployment_name=deployment_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.validate_at_tenant_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}/validate"}  # type: ignore


    @distributed_trace_async
    async def export_template_at_tenant_scope(
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExportResult":
        """Exports the template used for specified deployment.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExportResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExportResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExportResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_export_template_at_tenant_scope_request(
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.export_template_at_tenant_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExportResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    export_template_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate"}  # type: ignore


    @distributed_trace
    def list_at_tenant_scope(
        self,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentListResult"]:
        """Get all the deployments at the tenant scope.

        :param filter: The filter to apply on the operation. For example, you can use
         $filter=provisioningState eq '{state}'. Default value is None.
        :type filter: str
        :param top: The number of results to get. If null is passed, returns all deployments. Default
         value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployments_list_at_tenant_scope_request(
                    api_version=api_version,
                    filter=filter,
                    top=top,
                    template_url=self.list_at_tenant_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployments_list_at_tenant_scope_request(
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/"}  # type: ignore

    async def _delete_at_management_group_scope_initial(  # pylint: disable=inconsistent-return-statements
        self,
        group_id: str,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_delete_at_management_group_scope_request_initial(
            group_id=group_id,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self._delete_at_management_group_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_at_management_group_scope_initial.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_delete_at_management_group_scope(  # pylint: disable=inconsistent-return-statements
        self,
        group_id: str,
        deployment_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a deployment from the deployment history.

        A template deployment that is currently running cannot be deleted. Deleting a template
        deployment removes the associated deployment operations. This is an asynchronous operation that
        returns a status of 202 until the template deployment is successfully deleted. The Location
        response header contains the URI that is used to obtain the status of the process. While the
        process is running, a call to the URI in the Location header returns a status of 202. When the
        process finishes, the URI in the Location header returns a status of 204 on success. If the
        asynchronous request failed, the URI in the Location header returns an error-level status code.

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_at_management_group_scope_initial(
                group_id=group_id,
                deployment_name=deployment_name,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def check_existence_at_management_group_scope(
        self,
        group_id: str,
        deployment_name: str,
        **kwargs: Any
    ) -> bool:
        """Checks whether the deployment exists.

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_check_existence_at_management_group_scope_request(
            group_id=group_id,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.check_existence_at_management_group_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    check_existence_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    async def _create_or_update_at_management_group_scope_initial(
        self,
        group_id: str,
        deployment_name: str,
        parameters: "_models.ScopedDeployment",
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ScopedDeployment')

        request = build_deployments_create_or_update_at_management_group_scope_request_initial(
            group_id=group_id,
            deployment_name=deployment_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._create_or_update_at_management_group_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_at_management_group_scope_initial.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_create_or_update_at_management_group_scope(
        self,
        group_id: str,
        deployment_name: str,
        parameters: "_models.ScopedDeployment",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.DeploymentExtended"]:
        """Deploys resources at management group scope.

        You can provide the template and parameters directly in the request or link to JSON files.

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Additional parameters supplied to the operation.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ScopedDeployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either DeploymentExtended or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_or_update_at_management_group_scope_initial(
                group_id=group_id,
                deployment_name=deployment_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def get_at_management_group_scope(
        self,
        group_id: str,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        """Gets a deployment.

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExtended, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_get_at_management_group_scope_request(
            group_id=group_id,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.get_at_management_group_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def cancel_at_management_group_scope(  # pylint: disable=inconsistent-return-statements
        self,
        group_id: str,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        """Cancels a currently running template deployment.

        You can cancel a deployment only if the provisioningState is Accepted or Running. After the
        deployment is canceled, the provisioningState is set to Canceled. Canceling a template
        deployment stops the currently running template deployment and leaves the resources partially
        deployed.

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_cancel_at_management_group_scope_request(
            group_id=group_id,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.cancel_at_management_group_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    cancel_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel"}  # type: ignore


    @distributed_trace_async
    async def validate_at_management_group_scope(
        self,
        group_id: str,
        deployment_name: str,
        parameters: "_models.ScopedDeployment",
        **kwargs: Any
    ) -> "_models.DeploymentValidateResult":
        """Validates whether the specified template is syntactically correct and will be accepted by Azure
        Resource Manager..

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Parameters to validate.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ScopedDeployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentValidateResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentValidateResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentValidateResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ScopedDeployment')

        request = build_deployments_validate_at_management_group_scope_request(
            group_id=group_id,
            deployment_name=deployment_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.validate_at_management_group_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate"}  # type: ignore


    @distributed_trace_async
    async def export_template_at_management_group_scope(
        self,
        group_id: str,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExportResult":
        """Exports the template used for specified deployment.

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExportResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExportResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExportResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_export_template_at_management_group_scope_request(
            group_id=group_id,
            deployment_name=deployment_name,
            api_version=api_version,
            template_url=self.export_template_at_management_group_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExportResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    export_template_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate"}  # type: ignore


    @distributed_trace
    def list_at_management_group_scope(
        self,
        group_id: str,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentListResult"]:
        """Get all the deployments for a management group.

        :param group_id: The management group ID.
        :type group_id: str
        :param filter: The filter to apply on the operation. For example, you can use
         $filter=provisioningState eq '{state}'. Default value is None.
        :type filter: str
        :param top: The number of results to get. If null is passed, returns all deployments. Default
         value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployments_list_at_management_group_scope_request(
                    group_id=group_id,
                    api_version=api_version,
                    filter=filter,
                    top=top,
                    template_url=self.list_at_management_group_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployments_list_at_management_group_scope_request(
                    group_id=group_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/"}  # type: ignore

    async def _delete_at_subscription_scope_initial(  # pylint: disable=inconsistent-return-statements
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_delete_at_subscription_scope_request_initial(
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_at_subscription_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_at_subscription_scope_initial.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_delete_at_subscription_scope(  # pylint: disable=inconsistent-return-statements
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a deployment from the deployment history.

        A template deployment that is currently running cannot be deleted. Deleting a template
        deployment removes the associated deployment operations. This is an asynchronous operation that
        returns a status of 202 until the template deployment is successfully deleted. The Location
        response header contains the URI that is used to obtain the status of the process. While the
        process is running, a call to the URI in the Location header returns a status of 202. When the
        process finishes, the URI in the Location header returns a status of 204 on success. If the
        asynchronous request failed, the URI in the Location header returns an error-level status code.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_at_subscription_scope_initial(
                deployment_name=deployment_name,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def check_existence_at_subscription_scope(
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> bool:
        """Checks whether the deployment exists.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_check_existence_at_subscription_scope_request(
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.check_existence_at_subscription_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    check_existence_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    async def _create_or_update_at_subscription_scope_initial(
        self,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Deployment')

        request = build_deployments_create_or_update_at_subscription_scope_request_initial(
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._create_or_update_at_subscription_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_at_subscription_scope_initial.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_create_or_update_at_subscription_scope(
        self,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.DeploymentExtended"]:
        """Deploys resources at subscription scope.

        You can provide the template and parameters directly in the request or link to JSON files.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Additional parameters supplied to the operation.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.Deployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either DeploymentExtended or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_or_update_at_subscription_scope_initial(
                deployment_name=deployment_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def get_at_subscription_scope(
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        """Gets a deployment.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExtended, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_get_at_subscription_scope_request(
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_at_subscription_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def cancel_at_subscription_scope(  # pylint: disable=inconsistent-return-statements
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        """Cancels a currently running template deployment.

        You can cancel a deployment only if the provisioningState is Accepted or Running. After the
        deployment is canceled, the provisioningState is set to Canceled. Canceling a template
        deployment stops the currently running template deployment and leaves the resources partially
        deployed.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_cancel_at_subscription_scope_request(
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.cancel_at_subscription_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    cancel_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel"}  # type: ignore


    @distributed_trace_async
    async def validate_at_subscription_scope(
        self,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> "_models.DeploymentValidateResult":
        """Validates whether the specified template is syntactically correct and will be accepted by Azure
        Resource Manager..

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Parameters to validate.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.Deployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentValidateResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentValidateResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentValidateResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Deployment')

        request = build_deployments_validate_at_subscription_scope_request(
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.validate_at_subscription_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/validate"}  # type: ignore


    async def _what_if_at_subscription_scope_initial(
        self,
        deployment_name: str,
        parameters: "_models.DeploymentWhatIf",
        **kwargs: Any
    ) -> Optional["_models.WhatIfOperationResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.WhatIfOperationResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'DeploymentWhatIf')

        request = build_deployments_what_if_at_subscription_scope_request_initial(
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._what_if_at_subscription_scope_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize('WhatIfOperationResult', pipeline_response)

        if response.status_code == 202:
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))
            response_headers['Retry-After']=self._deserialize('str', response.headers.get('Retry-After'))
            

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    _what_if_at_subscription_scope_initial.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf"}  # type: ignore


    @distributed_trace_async
    async def begin_what_if_at_subscription_scope(
        self,
        deployment_name: str,
        parameters: "_models.DeploymentWhatIf",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.WhatIfOperationResult"]:
        """Returns changes that will be made by the deployment if executed at the scope of the
        subscription.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Parameters to What If.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentWhatIf
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either WhatIfOperationResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.WhatIfOperationResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.WhatIfOperationResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._what_if_at_subscription_scope_initial(
                deployment_name=deployment_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('WhatIfOperationResult', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_what_if_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf"}  # type: ignore

    @distributed_trace_async
    async def export_template_at_subscription_scope(
        self,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExportResult":
        """Exports the template used for specified deployment.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExportResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExportResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExportResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_export_template_at_subscription_scope_request(
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.export_template_at_subscription_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExportResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    export_template_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate"}  # type: ignore


    @distributed_trace
    def list_at_subscription_scope(
        self,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentListResult"]:
        """Get all the deployments for a subscription.

        :param filter: The filter to apply on the operation. For example, you can use
         $filter=provisioningState eq '{state}'. Default value is None.
        :type filter: str
        :param top: The number of results to get. If null is passed, returns all deployments. Default
         value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployments_list_at_subscription_scope_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    filter=filter,
                    top=top,
                    template_url=self.list_at_subscription_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployments_list_at_subscription_scope_request(
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/"}  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_delete_request_initial(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        deployment_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a deployment from the deployment history.

        A template deployment that is currently running cannot be deleted. Deleting a template
        deployment removes the associated deployment operations. Deleting a template deployment does
        not affect the state of the resource group. This is an asynchronous operation that returns a
        status of 202 until the template deployment is successfully deleted. The Location response
        header contains the URI that is used to obtain the status of the process. While the process is
        running, a call to the URI in the Location header returns a status of 202. When the process
        finishes, the URI in the Location header returns a status of 204 on success. If the
        asynchronous request failed, the URI in the Location header returns an error-level status code.

        :param resource_group_name: The name of the resource group with the deployment to delete. The
         name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                deployment_name=deployment_name,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def check_existence(
        self,
        resource_group_name: str,
        deployment_name: str,
        **kwargs: Any
    ) -> bool:
        """Checks whether the deployment exists.

        :param resource_group_name: The name of the resource group with the deployment to check. The
         name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_check_existence_request(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.check_existence.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    check_existence.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Deployment')

        request = build_deployments_create_or_update_request_initial(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._create_or_update_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.DeploymentExtended"]:
        """Deploys resources to a resource group.

        You can provide the template and parameters directly in the request or link to JSON files.

        :param resource_group_name: The name of the resource group to deploy the resources to. The name
         is case insensitive. The resource group must already exist.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Additional parameters supplied to the operation.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.Deployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either DeploymentExtended or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                deployment_name=deployment_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('DeploymentExtended', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExtended":
        """Gets a deployment.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExtended, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExtended
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExtended"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_get_request(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExtended', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}"}  # type: ignore


    @distributed_trace_async
    async def cancel(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        deployment_name: str,
        **kwargs: Any
    ) -> None:
        """Cancels a currently running template deployment.

        You can cancel a deployment only if the provisioningState is Accepted or Running. After the
        deployment is canceled, the provisioningState is set to Canceled. Canceling a template
        deployment stops the currently running template deployment and leaves the resource group
        partially deployed.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_cancel_request(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.cancel.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    cancel.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/cancel"}  # type: ignore


    @distributed_trace_async
    async def validate(
        self,
        resource_group_name: str,
        deployment_name: str,
        parameters: "_models.Deployment",
        **kwargs: Any
    ) -> "_models.DeploymentValidateResult":
        """Validates whether the specified template is syntactically correct and will be accepted by Azure
        Resource Manager..

        :param resource_group_name: The name of the resource group the template will be deployed to.
         The name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Parameters to validate.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.Deployment
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentValidateResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentValidateResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentValidateResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'Deployment')

        request = build_deployments_validate_request(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.validate.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize('DeploymentValidateResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/validate"}  # type: ignore


    async def _what_if_initial(
        self,
        resource_group_name: str,
        deployment_name: str,
        parameters: "_models.DeploymentWhatIf",
        **kwargs: Any
    ) -> Optional["_models.WhatIfOperationResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.WhatIfOperationResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'DeploymentWhatIf')

        request = build_deployments_what_if_request_initial(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._what_if_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize('WhatIfOperationResult', pipeline_response)

        if response.status_code == 202:
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))
            response_headers['Retry-After']=self._deserialize('str', response.headers.get('Retry-After'))
            

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    _what_if_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf"}  # type: ignore


    @distributed_trace_async
    async def begin_what_if(
        self,
        resource_group_name: str,
        deployment_name: str,
        parameters: "_models.DeploymentWhatIf",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.WhatIfOperationResult"]:
        """Returns changes that will be made by the deployment if executed at the scope of the resource
        group.

        :param resource_group_name: The name of the resource group the template will be deployed to.
         The name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param parameters: Parameters to validate.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentWhatIf
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either WhatIfOperationResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.WhatIfOperationResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.WhatIfOperationResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._what_if_initial(
                resource_group_name=resource_group_name,
                deployment_name=deployment_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('WhatIfOperationResult', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_what_if.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/whatIf"}  # type: ignore

    @distributed_trace_async
    async def export_template(
        self,
        resource_group_name: str,
        deployment_name: str,
        **kwargs: Any
    ) -> "_models.DeploymentExportResult":
        """Exports the template used for specified deployment.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentExportResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentExportResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentExportResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployments_export_template_request(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.export_template.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentExportResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    export_template.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}/exportTemplate"}  # type: ignore


    @distributed_trace
    def list_by_resource_group(
        self,
        resource_group_name: str,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentListResult"]:
        """Get all the deployments for a resource group.

        :param resource_group_name: The name of the resource group with the deployments to get. The
         name is case insensitive.
        :type resource_group_name: str
        :param filter: The filter to apply on the operation. For example, you can use
         $filter=provisioningState eq '{state}'. Default value is None.
        :type filter: str
        :param top: The number of results to get. If null is passed, returns all deployments. Default
         value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployments_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    filter=filter,
                    top=top,
                    template_url=self.list_by_resource_group.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployments_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_resource_group.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/"}  # type: ignore

    @distributed_trace_async
    async def calculate_template_hash(
        self,
        template: Any,
        **kwargs: Any
    ) -> "_models.TemplateHashResult":
        """Calculate the hash of the given template.

        :param template: The template provided to calculate hash.
        :type template: any
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TemplateHashResult, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.TemplateHashResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TemplateHashResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(template, 'object')

        request = build_deployments_calculate_template_hash_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.calculate_template_hash.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('TemplateHashResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    calculate_template_hash.metadata = {'url': "/providers/Microsoft.Resources/calculateTemplateHash"}  # type: ignore

class ProvidersOperations:
    """ProvidersOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.resource.resources.v2019_08_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def unregister(
        self,
        resource_provider_namespace: str,
        **kwargs: Any
    ) -> "_models.Provider":
        """Unregisters a subscription from a resource provider.

        :param resource_provider_namespace: The namespace of the resource provider to unregister.
        :type resource_provider_namespace: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Provider, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.Provider
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Provider"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_providers_unregister_request(
            resource_provider_namespace=resource_provider_namespace,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.unregister.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Provider', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    unregister.metadata = {'url': "/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/unregister"}  # type: ignore


    @distributed_trace_async
    async def register(
        self,
        resource_provider_namespace: str,
        **kwargs: Any
    ) -> "_models.Provider":
        """Registers a subscription with a resource provider.

        :param resource_provider_namespace: The namespace of the resource provider to register.
        :type resource_provider_namespace: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Provider, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.Provider
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Provider"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_providers_register_request(
            resource_provider_namespace=resource_provider_namespace,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.register.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Provider', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    register.metadata = {'url': "/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/register"}  # type: ignore


    @distributed_trace
    def list(
        self,
        top: Optional[int] = None,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ProviderListResult"]:
        """Gets all resource providers for a subscription.

        :param top: The number of results to return. If null is passed returns all deployments. Default
         value is None.
        :type top: int
        :param expand: The properties to include in the results. For example, use &$expand=metadata in
         the query string to retrieve resource provider metadata. To include property aliases in
         response, use $expand=resourceTypes/aliases. Default value is None.
        :type expand: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProviderListResult or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.ProviderListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ProviderListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_providers_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    top=top,
                    expand=expand,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_providers_list_request(
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProviderListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/subscriptions/{subscriptionId}/providers"}  # type: ignore

    @distributed_trace
    def list_at_tenant_scope(
        self,
        top: Optional[int] = None,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ProviderListResult"]:
        """Gets all resource providers for the tenant.

        :param top: The number of results to return. If null is passed returns all providers. Default
         value is None.
        :type top: int
        :param expand: The properties to include in the results. For example, use &$expand=metadata in
         the query string to retrieve resource provider metadata. To include property aliases in
         response, use $expand=resourceTypes/aliases. Default value is None.
        :type expand: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProviderListResult or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.ProviderListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ProviderListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_providers_list_at_tenant_scope_request(
                    api_version=api_version,
                    top=top,
                    expand=expand,
                    template_url=self.list_at_tenant_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_providers_list_at_tenant_scope_request(
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProviderListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_tenant_scope.metadata = {'url': "/providers"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_provider_namespace: str,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.Provider":
        """Gets the specified resource provider.

        :param resource_provider_namespace: The namespace of the resource provider.
        :type resource_provider_namespace: str
        :param expand: The $expand query parameter. For example, to include property aliases in
         response, use $expand=resourceTypes/aliases. Default value is None.
        :type expand: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Provider, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.Provider
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Provider"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_providers_get_request(
            resource_provider_namespace=resource_provider_namespace,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            expand=expand,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Provider', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}"}  # type: ignore


    @distributed_trace_async
    async def get_at_tenant_scope(
        self,
        resource_provider_namespace: str,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.Provider":
        """Gets the specified resource provider at the tenant level.

        :param resource_provider_namespace: The namespace of the resource provider.
        :type resource_provider_namespace: str
        :param expand: The $expand query parameter. For example, to include property aliases in
         response, use $expand=resourceTypes/aliases. Default value is None.
        :type expand: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Provider, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.Provider
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Provider"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_providers_get_at_tenant_scope_request(
            resource_provider_namespace=resource_provider_namespace,
            api_version=api_version,
            expand=expand,
            template_url=self.get_at_tenant_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Provider', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_tenant_scope.metadata = {'url': "/providers/{resourceProviderNamespace}"}  # type: ignore

class ResourcesOperations:  # pylint: disable=too-many-public-methods
    """ResourcesOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.resource.resources.v2019_08_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list_by_resource_group(
        self,
        resource_group_name: str,
        filter: Optional[str] = None,
        expand: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ResourceListResult"]:
        """Get all the resources for a resource group.

        :param resource_group_name: The resource group with the resources to get.
        :type resource_group_name: str
        :param filter: The filter to apply on the operation.:code:`<br>`:code:`<br>`The properties you
         can use for eq (equals) or ne (not equals) are: location, resourceType, name, resourceGroup,
         identity, identity/principalId, plan, plan/publisher, plan/product, plan/name, plan/version,
         and plan/promotionCode.:code:`<br>`:code:`<br>`For example, to filter by a resource type, use:
         $filter=resourceType eq 'Microsoft.Network/virtualNetworks':code:`<br>`:code:`<br>`You can use
         substringof(value, property) in the filter. The properties you can use for substring are: name
         and resourceGroup.:code:`<br>`:code:`<br>`For example, to get all resources with 'demo'
         anywhere in the name, use: $filter=substringof('demo', name):code:`<br>`:code:`<br>`You can
         link more than one substringof together by adding and/or operators.:code:`<br>`:code:`<br>`You
         can filter by tag names and values. For example, to filter for a tag name and value, use
         $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
         the tags for each resource are not returned in the results.:code:`<br>`:code:`<br>`You can use
         some properties together when filtering. The combinations you can use are: substringof and/or
         resourceType, plan and plan/publisher and plan/name, identity and identity/principalId. Default
         value is None.
        :type filter: str
        :param expand: Comma-separated list of additional properties to be included in the response.
         Valid values include ``createdTime``\ , ``changedTime`` and ``provisioningState``. For example,
         ``$expand=createdTime,changedTime``. Default value is None.
        :type expand: str
        :param top: The number of results to return. If null is passed, returns all resources. Default
         value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ResourceListResult or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.ResourceListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourceListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_resources_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    filter=filter,
                    expand=expand,
                    top=top,
                    template_url=self.list_by_resource_group.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_resources_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ResourceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_by_resource_group.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/resources"}  # type: ignore

    async def _move_resources_initial(  # pylint: disable=inconsistent-return-statements
        self,
        source_resource_group_name: str,
        parameters: "_models.ResourcesMoveInfo",
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ResourcesMoveInfo')

        request = build_resources_move_resources_request_initial(
            source_resource_group_name=source_resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._move_resources_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _move_resources_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources"}  # type: ignore


    @distributed_trace_async
    async def begin_move_resources(  # pylint: disable=inconsistent-return-statements
        self,
        source_resource_group_name: str,
        parameters: "_models.ResourcesMoveInfo",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Moves resources from one resource group to another resource group.

        The resources to move must be in the same source resource group. The target resource group may
        be in a different subscription. When moving resources, both the source group and the target
        group are locked for the duration of the operation. Write and delete operations are blocked on
        the groups until the move completes.

        :param source_resource_group_name: The name of the resource group containing the resources to
         move.
        :type source_resource_group_name: str
        :param parameters: Parameters for moving resources.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ResourcesMoveInfo
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._move_resources_initial(
                source_resource_group_name=source_resource_group_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_move_resources.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/moveResources"}  # type: ignore

    async def _validate_move_resources_initial(  # pylint: disable=inconsistent-return-statements
        self,
        source_resource_group_name: str,
        parameters: "_models.ResourcesMoveInfo",
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ResourcesMoveInfo')

        request = build_resources_validate_move_resources_request_initial(
            source_resource_group_name=source_resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._validate_move_resources_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _validate_move_resources_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources"}  # type: ignore


    @distributed_trace_async
    async def begin_validate_move_resources(  # pylint: disable=inconsistent-return-statements
        self,
        source_resource_group_name: str,
        parameters: "_models.ResourcesMoveInfo",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates whether resources can be moved from one resource group to another resource group.

        This operation checks whether the specified resources can be moved to the target. The resources
        to move must be in the same source resource group. The target resource group may be in a
        different subscription. If validation succeeds, it returns HTTP response code 204 (no content).
        If validation fails, it returns HTTP response code 409 (Conflict) with an error message.
        Retrieve the URL in the Location header value to check the result of the long-running
        operation.

        :param source_resource_group_name: The name of the resource group containing the resources to
         validate for move.
        :type source_resource_group_name: str
        :param parameters: Parameters for moving resources.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ResourcesMoveInfo
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._validate_move_resources_initial(
                source_resource_group_name=source_resource_group_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_validate_move_resources.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{sourceResourceGroupName}/validateMoveResources"}  # type: ignore

    @distributed_trace
    def list(
        self,
        filter: Optional[str] = None,
        expand: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ResourceListResult"]:
        """Get all the resources in a subscription.

        :param filter: The filter to apply on the operation.:code:`<br>`:code:`<br>`The properties you
         can use for eq (equals) or ne (not equals) are: location, resourceType, name, resourceGroup,
         identity, identity/principalId, plan, plan/publisher, plan/product, plan/name, plan/version,
         and plan/promotionCode.:code:`<br>`:code:`<br>`For example, to filter by a resource type, use:
         $filter=resourceType eq 'Microsoft.Network/virtualNetworks':code:`<br>`:code:`<br>`You can use
         substringof(value, property) in the filter. The properties you can use for substring are: name
         and resourceGroup.:code:`<br>`:code:`<br>`For example, to get all resources with 'demo'
         anywhere in the name, use: $filter=substringof('demo', name):code:`<br>`:code:`<br>`You can
         link more than one substringof together by adding and/or operators.:code:`<br>`:code:`<br>`You
         can filter by tag names and values. For example, to filter for a tag name and value, use
         $filter=tagName eq 'tag1' and tagValue eq 'Value1'. When you filter by a tag name and value,
         the tags for each resource are not returned in the results.:code:`<br>`:code:`<br>`You can use
         some properties together when filtering. The combinations you can use are: substringof and/or
         resourceType, plan and plan/publisher and plan/name, identity and identity/principalId. Default
         value is None.
        :type filter: str
        :param expand: Comma-separated list of additional properties to be included in the response.
         Valid values include ``createdTime``\ , ``changedTime`` and ``provisioningState``. For example,
         ``$expand=createdTime,changedTime``. Default value is None.
        :type expand: str
        :param top: The number of results to return. If null is passed, returns all resources. Default
         value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ResourceListResult or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.ResourceListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourceListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_resources_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    filter=filter,
                    expand=expand,
                    top=top,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_resources_list_request(
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ResourceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/subscriptions/{subscriptionId}/resources"}  # type: ignore

    @distributed_trace_async
    async def check_existence(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        api_version: str,
        **kwargs: Any
    ) -> bool:
        """Checks whether a resource exists.

        :param resource_group_name: The name of the resource group containing the resource to check.
         The name is case insensitive.
        :type resource_group_name: str
        :param resource_provider_namespace: The resource provider of the resource to check.
        :type resource_provider_namespace: str
        :param parent_resource_path: The parent resource identity.
        :type parent_resource_path: str
        :param resource_type: The resource type.
        :type resource_type: str
        :param resource_name: The name of the resource to check whether it exists.
        :type resource_name: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_resources_check_existence_request(
            resource_group_name=resource_group_name,
            resource_provider_namespace=resource_provider_namespace,
            parent_resource_path=parent_resource_path,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.check_existence.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    check_existence.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"}  # type: ignore


    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        api_version: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_resources_delete_request_initial(
            resource_group_name=resource_group_name,
            resource_provider_namespace=resource_provider_namespace,
            parent_resource_path=parent_resource_path,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"}  # type: ignore


    @distributed_trace_async
    async def begin_delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        api_version: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a resource.

        :param resource_group_name: The name of the resource group that contains the resource to
         delete. The name is case insensitive.
        :type resource_group_name: str
        :param resource_provider_namespace: The namespace of the resource provider.
        :type resource_provider_namespace: str
        :param parent_resource_path: The parent resource identity.
        :type parent_resource_path: str
        :param resource_type: The resource type.
        :type resource_type: str
        :param resource_name: The name of the resource to delete.
        :type resource_name: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                resource_provider_namespace=resource_provider_namespace,
                parent_resource_path=parent_resource_path,
                resource_type=resource_type,
                resource_name=resource_name,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"}  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        api_version: str,
        parameters: "_models.GenericResource",
        **kwargs: Any
    ) -> Optional["_models.GenericResource"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.GenericResource"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'GenericResource')

        request = build_resources_create_or_update_request_initial(
            resource_group_name=resource_group_name,
            resource_provider_namespace=resource_provider_namespace,
            parent_resource_path=parent_resource_path,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=api_version,
            json=_json,
            template_url=self._create_or_update_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('GenericResource', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('GenericResource', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"}  # type: ignore


    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        api_version: str,
        parameters: "_models.GenericResource",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.GenericResource"]:
        """Creates a resource.

        :param resource_group_name: The name of the resource group for the resource. The name is case
         insensitive.
        :type resource_group_name: str
        :param resource_provider_namespace: The namespace of the resource provider.
        :type resource_provider_namespace: str
        :param parent_resource_path: The parent resource identity.
        :type parent_resource_path: str
        :param resource_type: The resource type of the resource to create.
        :type resource_type: str
        :param resource_name: The name of the resource to create.
        :type resource_name: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :param parameters: Parameters for creating or updating the resource.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either GenericResource or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.GenericResource"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                resource_provider_namespace=resource_provider_namespace,
                parent_resource_path=parent_resource_path,
                resource_type=resource_type,
                resource_name=resource_name,
                api_version=api_version,
                parameters=parameters,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('GenericResource', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"}  # type: ignore

    async def _update_initial(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        api_version: str,
        parameters: "_models.GenericResource",
        **kwargs: Any
    ) -> Optional["_models.GenericResource"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.GenericResource"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'GenericResource')

        request = build_resources_update_request_initial(
            resource_group_name=resource_group_name,
            resource_provider_namespace=resource_provider_namespace,
            parent_resource_path=parent_resource_path,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=api_version,
            json=_json,
            template_url=self._update_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('GenericResource', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"}  # type: ignore


    @distributed_trace_async
    async def begin_update(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        api_version: str,
        parameters: "_models.GenericResource",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.GenericResource"]:
        """Updates a resource.

        :param resource_group_name: The name of the resource group for the resource. The name is case
         insensitive.
        :type resource_group_name: str
        :param resource_provider_namespace: The namespace of the resource provider.
        :type resource_provider_namespace: str
        :param parent_resource_path: The parent resource identity.
        :type parent_resource_path: str
        :param resource_type: The resource type of the resource to update.
        :type resource_type: str
        :param resource_name: The name of the resource to update.
        :type resource_name: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :param parameters: Parameters for updating the resource.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either GenericResource or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.GenericResource"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                resource_provider_namespace=resource_provider_namespace,
                parent_resource_path=parent_resource_path,
                resource_type=resource_type,
                resource_name=resource_name,
                api_version=api_version,
                parameters=parameters,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('GenericResource', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_update.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        resource_provider_namespace: str,
        parent_resource_path: str,
        resource_type: str,
        resource_name: str,
        api_version: str,
        **kwargs: Any
    ) -> "_models.GenericResource":
        """Gets a resource.

        :param resource_group_name: The name of the resource group containing the resource to get. The
         name is case insensitive.
        :type resource_group_name: str
        :param resource_provider_namespace: The namespace of the resource provider.
        :type resource_provider_namespace: str
        :param parent_resource_path: The parent resource identity.
        :type parent_resource_path: str
        :param resource_type: The resource type of the resource.
        :type resource_type: str
        :param resource_name: The name of the resource to get.
        :type resource_name: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GenericResource, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.GenericResource"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_resources_get_request(
            resource_group_name=resource_group_name,
            resource_provider_namespace=resource_provider_namespace,
            parent_resource_path=parent_resource_path,
            resource_type=resource_type,
            resource_name=resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('GenericResource', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}"}  # type: ignore


    @distributed_trace_async
    async def check_existence_by_id(
        self,
        resource_id: str,
        api_version: str,
        **kwargs: Any
    ) -> bool:
        """Checks by ID whether a resource exists.

        :param resource_id: The fully qualified ID of the resource, including the resource name and
         resource type. Use the format,
         /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
        :type resource_id: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_resources_check_existence_by_id_request(
            resource_id=resource_id,
            api_version=api_version,
            template_url=self.check_existence_by_id.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    check_existence_by_id.metadata = {'url': "/{resourceId}"}  # type: ignore


    async def _delete_by_id_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_id: str,
        api_version: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_resources_delete_by_id_request_initial(
            resource_id=resource_id,
            api_version=api_version,
            template_url=self._delete_by_id_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_by_id_initial.metadata = {'url': "/{resourceId}"}  # type: ignore


    @distributed_trace_async
    async def begin_delete_by_id(  # pylint: disable=inconsistent-return-statements
        self,
        resource_id: str,
        api_version: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a resource by ID.

        :param resource_id: The fully qualified ID of the resource, including the resource name and
         resource type. Use the format,
         /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
        :type resource_id: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_by_id_initial(
                resource_id=resource_id,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete_by_id.metadata = {'url': "/{resourceId}"}  # type: ignore

    async def _create_or_update_by_id_initial(
        self,
        resource_id: str,
        api_version: str,
        parameters: "_models.GenericResource",
        **kwargs: Any
    ) -> Optional["_models.GenericResource"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.GenericResource"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'GenericResource')

        request = build_resources_create_or_update_by_id_request_initial(
            resource_id=resource_id,
            content_type=content_type,
            api_version=api_version,
            json=_json,
            template_url=self._create_or_update_by_id_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('GenericResource', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('GenericResource', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_or_update_by_id_initial.metadata = {'url': "/{resourceId}"}  # type: ignore


    @distributed_trace_async
    async def begin_create_or_update_by_id(
        self,
        resource_id: str,
        api_version: str,
        parameters: "_models.GenericResource",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.GenericResource"]:
        """Create a resource by ID.

        :param resource_id: The fully qualified ID of the resource, including the resource name and
         resource type. Use the format,
         /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
        :type resource_id: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :param parameters: Create or update resource parameters.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either GenericResource or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.GenericResource"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_or_update_by_id_initial(
                resource_id=resource_id,
                api_version=api_version,
                parameters=parameters,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('GenericResource', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create_or_update_by_id.metadata = {'url': "/{resourceId}"}  # type: ignore

    async def _update_by_id_initial(
        self,
        resource_id: str,
        api_version: str,
        parameters: "_models.GenericResource",
        **kwargs: Any
    ) -> Optional["_models.GenericResource"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.GenericResource"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'GenericResource')

        request = build_resources_update_by_id_request_initial(
            resource_id=resource_id,
            content_type=content_type,
            api_version=api_version,
            json=_json,
            template_url=self._update_by_id_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('GenericResource', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _update_by_id_initial.metadata = {'url': "/{resourceId}"}  # type: ignore


    @distributed_trace_async
    async def begin_update_by_id(
        self,
        resource_id: str,
        api_version: str,
        parameters: "_models.GenericResource",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.GenericResource"]:
        """Updates a resource by ID.

        :param resource_id: The fully qualified ID of the resource, including the resource name and
         resource type. Use the format,
         /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
        :type resource_id: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :param parameters: Update resource parameters.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either GenericResource or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.GenericResource"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._update_by_id_initial(
                resource_id=resource_id,
                api_version=api_version,
                parameters=parameters,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('GenericResource', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_update_by_id.metadata = {'url': "/{resourceId}"}  # type: ignore

    @distributed_trace_async
    async def get_by_id(
        self,
        resource_id: str,
        api_version: str,
        **kwargs: Any
    ) -> "_models.GenericResource":
        """Gets a resource by ID.

        :param resource_id: The fully qualified ID of the resource, including the resource name and
         resource type. Use the format,
         /subscriptions/{guid}/resourceGroups/{resource-group-name}/{resource-provider-namespace}/{resource-type}/{resource-name}.
        :type resource_id: str
        :param api_version: The API version to use for the operation.
        :type api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GenericResource, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.GenericResource
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.GenericResource"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_resources_get_by_id_request(
            resource_id=resource_id,
            api_version=api_version,
            template_url=self.get_by_id.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('GenericResource', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_by_id.metadata = {'url': "/{resourceId}"}  # type: ignore

class ResourceGroupsOperations:
    """ResourceGroupsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.resource.resources.v2019_08_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def check_existence(
        self,
        resource_group_name: str,
        **kwargs: Any
    ) -> bool:
        """Checks whether a resource group exists.

        :param resource_group_name: The name of the resource group to check. The name is case
         insensitive.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: bool, or the result of cls(response)
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_resource_groups_check_existence_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.check_existence.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    check_existence.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}"}  # type: ignore


    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        parameters: "_models.ResourceGroup",
        **kwargs: Any
    ) -> "_models.ResourceGroup":
        """Creates or updates a resource group.

        :param resource_group_name: The name of the resource group to create or update. Can include
         alphanumeric, underscore, parentheses, hyphen, period (except at end), and Unicode characters
         that match the allowed characters.
        :type resource_group_name: str
        :param parameters: Parameters supplied to the create or update a resource group.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ResourceGroup
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGroup, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.ResourceGroup
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourceGroup"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ResourceGroup')

        request = build_resource_groups_create_or_update_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.create_or_update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('ResourceGroup', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('ResourceGroup', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}"}  # type: ignore


    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_resource_groups_delete_request_initial(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _delete_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}"}  # type: ignore


    @distributed_trace_async
    async def begin_delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a resource group.

        When you delete a resource group, all of its resources are also deleted. Deleting a resource
        group deletes all of its template deployments and currently stored operations.

        :param resource_group_name: The name of the resource group to delete. The name is case
         insensitive.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        **kwargs: Any
    ) -> "_models.ResourceGroup":
        """Gets a resource group.

        :param resource_group_name: The name of the resource group to get. The name is case
         insensitive.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGroup, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.ResourceGroup
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourceGroup"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_resource_groups_get_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ResourceGroup', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}"}  # type: ignore


    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        parameters: "_models.ResourceGroupPatchable",
        **kwargs: Any
    ) -> "_models.ResourceGroup":
        """Updates a resource group.

        Resource groups can be updated through a simple PATCH operation to a group address. The format
        of the request is the same as that for creating a resource group. If a field is unspecified,
        the current value is retained.

        :param resource_group_name: The name of the resource group to update. The name is case
         insensitive.
        :type resource_group_name: str
        :param parameters: Parameters supplied to update a resource group.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ResourceGroupPatchable
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResourceGroup, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.ResourceGroup
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourceGroup"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ResourceGroupPatchable')

        request = build_resource_groups_update_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ResourceGroup', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}"}  # type: ignore


    async def _export_template_initial(
        self,
        resource_group_name: str,
        parameters: "_models.ExportTemplateRequest",
        **kwargs: Any
    ) -> Optional["_models.ResourceGroupExportResult"]:
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.ResourceGroupExportResult"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'ExportTemplateRequest')

        request = build_resource_groups_export_template_request_initial(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._export_template_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ResourceGroupExportResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _export_template_initial.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/exportTemplate"}  # type: ignore


    @distributed_trace_async
    async def begin_export_template(
        self,
        resource_group_name: str,
        parameters: "_models.ExportTemplateRequest",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.ResourceGroupExportResult"]:
        """Captures the specified resource group as a template.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param parameters: Parameters for exporting the template.
        :type parameters: ~azure.mgmt.resource.resources.v2019_08_01.models.ExportTemplateRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either ResourceGroupExportResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.resource.resources.v2019_08_01.models.ResourceGroupExportResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourceGroupExportResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._export_template_initial(
                resource_group_name=resource_group_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('ResourceGroupExportResult', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        if polling is True: polling_method = AsyncARMPolling(lro_delay, lro_options={'final-state-via': 'location'}, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_export_template.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/exportTemplate"}  # type: ignore

    @distributed_trace
    def list(
        self,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.ResourceGroupListResult"]:
        """Gets all the resource groups for a subscription.

        :param filter: The filter to apply on the operation.:code:`<br>`:code:`<br>`You can filter by
         tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq
         'tag1' and tagValue eq 'Value1'. Default value is None.
        :type filter: str
        :param top: The number of results to return. If null is passed, returns all resource groups.
         Default value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ResourceGroupListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.ResourceGroupListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ResourceGroupListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_resource_groups_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    filter=filter,
                    top=top,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_resource_groups_list_request(
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ResourceGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups"}  # type: ignore
class TagsOperations:
    """TagsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.resource.resources.v2019_08_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def delete_value(  # pylint: disable=inconsistent-return-statements
        self,
        tag_name: str,
        tag_value: str,
        **kwargs: Any
    ) -> None:
        """Deletes a tag value.

        :param tag_name: The name of the tag.
        :type tag_name: str
        :param tag_value: The value of the tag to delete.
        :type tag_value: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_tags_delete_value_request(
            tag_name=tag_name,
            tag_value=tag_value,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_value.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_value.metadata = {'url': "/subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}"}  # type: ignore


    @distributed_trace_async
    async def create_or_update_value(
        self,
        tag_name: str,
        tag_value: str,
        **kwargs: Any
    ) -> "_models.TagValue":
        """Creates a tag value. The name of the tag must already exist.

        :param tag_name: The name of the tag.
        :type tag_name: str
        :param tag_value: The value of the tag to create.
        :type tag_value: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TagValue, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.TagValue
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TagValue"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_tags_create_or_update_value_request(
            tag_name=tag_name,
            tag_value=tag_value,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.create_or_update_value.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('TagValue', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('TagValue', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_value.metadata = {'url': "/subscriptions/{subscriptionId}/tagNames/{tagName}/tagValues/{tagValue}"}  # type: ignore


    @distributed_trace_async
    async def create_or_update(
        self,
        tag_name: str,
        **kwargs: Any
    ) -> "_models.TagDetails":
        """Creates a tag in the subscription.

        The tag name can have a maximum of 512 characters and is case insensitive. Tag names created by
        Azure have prefixes of microsoft, azure, or windows. You cannot create tags with one of these
        prefixes.

        :param tag_name: The name of the tag to create.
        :type tag_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TagDetails, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.TagDetails
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TagDetails"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_tags_create_or_update_request(
            tag_name=tag_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.create_or_update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('TagDetails', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('TagDetails', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {'url': "/subscriptions/{subscriptionId}/tagNames/{tagName}"}  # type: ignore


    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        tag_name: str,
        **kwargs: Any
    ) -> None:
        """Deletes a tag from the subscription.

        You must remove all values from a resource tag before you can delete it.

        :param tag_name: The name of the tag.
        :type tag_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_tags_delete_request(
            tag_name=tag_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': "/subscriptions/{subscriptionId}/tagNames/{tagName}"}  # type: ignore


    @distributed_trace
    def list(
        self,
        **kwargs: Any
    ) -> AsyncIterable["_models.TagsListResult"]:
        """Gets the names and values of all resource tags that are defined in a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either TagsListResult or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.TagsListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TagsListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_tags_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_tags_list_request(
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("TagsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/subscriptions/{subscriptionId}/tagNames"}  # type: ignore
class DeploymentOperationsOperations:
    """DeploymentOperationsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.resource.resources.v2019_08_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def get_at_scope(
        self,
        scope: str,
        deployment_name: str,
        operation_id: str,
        **kwargs: Any
    ) -> "_models.DeploymentOperation":
        """Gets a deployments operation.

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param operation_id: The ID of the operation to get.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentOperation, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployment_operations_get_at_scope_request(
            scope=scope,
            deployment_name=deployment_name,
            operation_id=operation_id,
            api_version=api_version,
            template_url=self.get_at_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}"}  # type: ignore


    @distributed_trace
    def list_at_scope(
        self,
        scope: str,
        deployment_name: str,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentOperationsListResult"]:
        """Gets all deployments operations for a deployment.

        :param scope: The scope of a deployment.
        :type scope: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param top: The number of results to return. Default value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentOperationsListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperationsListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperationsListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployment_operations_list_at_scope_request(
                    scope=scope,
                    deployment_name=deployment_name,
                    api_version=api_version,
                    top=top,
                    template_url=self.list_at_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployment_operations_list_at_scope_request(
                    scope=scope,
                    deployment_name=deployment_name,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentOperationsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_scope.metadata = {'url': "/{scope}/providers/Microsoft.Resources/deployments/{deploymentName}/operations"}  # type: ignore

    @distributed_trace_async
    async def get_at_tenant_scope(
        self,
        deployment_name: str,
        operation_id: str,
        **kwargs: Any
    ) -> "_models.DeploymentOperation":
        """Gets a deployments operation.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param operation_id: The ID of the operation to get.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentOperation, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployment_operations_get_at_tenant_scope_request(
            deployment_name=deployment_name,
            operation_id=operation_id,
            api_version=api_version,
            template_url=self.get_at_tenant_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}"}  # type: ignore


    @distributed_trace
    def list_at_tenant_scope(
        self,
        deployment_name: str,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentOperationsListResult"]:
        """Gets all deployments operations for a deployment.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param top: The number of results to return. Default value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentOperationsListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperationsListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperationsListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployment_operations_list_at_tenant_scope_request(
                    deployment_name=deployment_name,
                    api_version=api_version,
                    top=top,
                    template_url=self.list_at_tenant_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployment_operations_list_at_tenant_scope_request(
                    deployment_name=deployment_name,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentOperationsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_tenant_scope.metadata = {'url': "/providers/Microsoft.Resources/deployments/{deploymentName}/operations"}  # type: ignore

    @distributed_trace_async
    async def get_at_management_group_scope(
        self,
        group_id: str,
        deployment_name: str,
        operation_id: str,
        **kwargs: Any
    ) -> "_models.DeploymentOperation":
        """Gets a deployments operation.

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param operation_id: The ID of the operation to get.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentOperation, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployment_operations_get_at_management_group_scope_request(
            group_id=group_id,
            deployment_name=deployment_name,
            operation_id=operation_id,
            api_version=api_version,
            template_url=self.get_at_management_group_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}"}  # type: ignore


    @distributed_trace
    def list_at_management_group_scope(
        self,
        group_id: str,
        deployment_name: str,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentOperationsListResult"]:
        """Gets all deployments operations for a deployment.

        :param group_id: The management group ID.
        :type group_id: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param top: The number of results to return. Default value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentOperationsListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperationsListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperationsListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployment_operations_list_at_management_group_scope_request(
                    group_id=group_id,
                    deployment_name=deployment_name,
                    api_version=api_version,
                    top=top,
                    template_url=self.list_at_management_group_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployment_operations_list_at_management_group_scope_request(
                    group_id=group_id,
                    deployment_name=deployment_name,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentOperationsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_management_group_scope.metadata = {'url': "/providers/Microsoft.Management/managementGroups/{groupId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations"}  # type: ignore

    @distributed_trace_async
    async def get_at_subscription_scope(
        self,
        deployment_name: str,
        operation_id: str,
        **kwargs: Any
    ) -> "_models.DeploymentOperation":
        """Gets a deployments operation.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param operation_id: The ID of the operation to get.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentOperation, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployment_operations_get_at_subscription_scope_request(
            deployment_name=deployment_name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_at_subscription_scope.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations/{operationId}"}  # type: ignore


    @distributed_trace
    def list_at_subscription_scope(
        self,
        deployment_name: str,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentOperationsListResult"]:
        """Gets all deployments operations for a deployment.

        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param top: The number of results to return. Default value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentOperationsListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperationsListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperationsListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployment_operations_list_at_subscription_scope_request(
                    deployment_name=deployment_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    top=top,
                    template_url=self.list_at_subscription_scope.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployment_operations_list_at_subscription_scope_request(
                    deployment_name=deployment_name,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentOperationsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_at_subscription_scope.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deployments/{deploymentName}/operations"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        deployment_name: str,
        operation_id: str,
        **kwargs: Any
    ) -> "_models.DeploymentOperation":
        """Gets a deployments operation.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param operation_id: The ID of the operation to get.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentOperation, or the result of cls(response)
        :rtype: ~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        
        request = build_deployment_operations_get_request(
            resource_group_name=resource_group_name,
            deployment_name=deployment_name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations/{operationId}"}  # type: ignore


    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        deployment_name: str,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DeploymentOperationsListResult"]:
        """Gets all deployments operations for a deployment.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param top: The number of results to return. Default value is None.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeploymentOperationsListResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.resource.resources.v2019_08_01.models.DeploymentOperationsListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2019-08-01")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentOperationsListResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_deployment_operations_list_request(
                    resource_group_name=resource_group_name,
                    deployment_name=deployment_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    top=top,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_deployment_operations_list_request(
                    resource_group_name=resource_group_name,
                    deployment_name=deployment_name,
                    subscription_id=self._config.subscription_id,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentOperationsListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/deployments/{deploymentName}/operations"}  # type: ignore
