
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def StoragePlacementAction(vim, *args, **kwargs):
    '''Describes a single storage initial placement action for placing a virtual
    machine or a set of virtual disks on a datastore.NOTE: This data object type
    and all of its methods are experimental and subject to change in future
    releases.'''

    obj = vim.client.factory.create('{urn:vim25}StoragePlacementAction')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 3:
        raise IndexError('Expected at least 4 arguments got: %d' % len(args))

    required = [ 'destination', 'relocateSpec', 'type' ]
    optional = [ 'ioLatencyBefore', 'spaceUtilAfter', 'spaceUtilBefore', 'vm', 'target',
        'dynamicProperty', 'dynamicType' ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
