
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def HostConfigInfo(vim, *args, **kwargs):
    '''This data object type encapsulates a typical set of host configuration
    information that is useful for displaying and configuring a host.VirtualCenter
    can retrieve this set of information very efficiently even for a large set of
    hosts.'''

    obj = vim.client.factory.create('{urn:vim25}HostConfigInfo')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 2:
        raise IndexError('Expected at least 3 arguments got: %d' % len(args))

    required = [ 'host', 'product' ]
    optional = [ 'activeDiagnosticPartition', 'adminDisabled', 'authenticationManagerInfo',
        'autoStart', 'cacheConfigurationInfo', 'capabilities', 'certificate',
        'consoleReservation', 'datastoreCapabilities', 'datastorePrincipal',
        'dateTimeInfo', 'featureVersion', 'fileSystemVolume', 'firewall', 'flags',
        'hyperThread', 'ipmi', 'localSwapDatastore', 'multipathState', 'network',
        'offloadCapabilities', 'option', 'optionDef', 'pciPassthruInfo',
        'powerSystemCapability', 'powerSystemInfo', 'service', 'sslThumbprintData',
        'sslThumbprintInfo', 'storageDevice', 'systemFile', 'systemResources',
        'virtualMachineReservation', 'virtualNicManagerInfo', 'vmotion',
        'wakeOnLanCapable', 'dynamicProperty', 'dynamicType' ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
