# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MongoDBCollectionResource(Model):
    """Cosmos DB MongoDB collection resource object.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Name of the Cosmos DB MongoDB collection
    :type id: str
    :param shard_key: A key-value pair of shard keys to be applied for the
     request.
    :type shard_key: dict[str, str]
    :param indexes: List of index keys
    :type indexes: list[~azure.mgmt.cosmosdb.models.MongoIndex]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'shard_key': {'key': 'shardKey', 'type': '{str}'},
        'indexes': {'key': 'indexes', 'type': '[MongoIndex]'},
    }

    def __init__(self, **kwargs):
        super(MongoDBCollectionResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.shard_key = kwargs.get('shard_key', None)
        self.indexes = kwargs.get('indexes', None)
