# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConflictResolutionPolicy(Model):
    """The conflict resolution policy for the container.

    :param mode: Indicates the conflict resolution mode. Possible values
     include: 'LastWriterWins', 'Custom'. Default value: "LastWriterWins" .
    :type mode: str or ~azure.mgmt.cosmosdb.models.ConflictResolutionMode
    :param conflict_resolution_path: The conflict resolution path in the case
     of LastWriterWins mode.
    :type conflict_resolution_path: str
    :param conflict_resolution_procedure: The procedure to resolve conflicts
     in the case of custom mode.
    :type conflict_resolution_procedure: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'conflict_resolution_path': {'key': 'conflictResolutionPath', 'type': 'str'},
        'conflict_resolution_procedure': {'key': 'conflictResolutionProcedure', 'type': 'str'},
    }

    def __init__(self, *, mode="LastWriterWins", conflict_resolution_path: str=None, conflict_resolution_procedure: str=None, **kwargs) -> None:
        super(ConflictResolutionPolicy, self).__init__(**kwargs)
        self.mode = mode
        self.conflict_resolution_path = conflict_resolution_path
        self.conflict_resolution_procedure = conflict_resolution_procedure
