# Copyright 2015 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the"License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import setuptools
REQUIREMENTS = [
    "google-apitools>=0.4.8",
    "httplib2>=0.9",
    "oauth2client>=1.4.12",
    "protorpc>=0.10.0",
]
_PACKAGE = "apitools.clients.bigquery"

setuptools.setup(
    name="google-apitools-bigquery-v2",
    version="0.4.20150731",
    description="Autogenerated apitools library for bigquery",
    url="https://github.com/google/apitools",
    author="Craig Citro",
    author_email="craigcitro@google.com",
    packages=setuptools.find_packages(),
    install_requires=REQUIREMENTS,
    classifiers=[
        "Programming Language :: Python :: 2.7",
        "License :: OSI Approved :: Apache Software License",
    ],
    license="Apache 2.0",
    keywords="apitools apitools-bigquery bigquery",
)
