# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AadAuthenticationParameters(Model):
    """AAD Vpn authentication type related parameters.

    :param aad_tenant: AAD Vpn authentication parameter AAD tenant.
    :type aad_tenant: str
    :param aad_audience: AAD Vpn authentication parameter AAD audience.
    :type aad_audience: str
    :param aad_issuer: AAD Vpn authentication parameter AAD issuer.
    :type aad_issuer: str
    """

    _attribute_map = {
        'aad_tenant': {'key': 'aadTenant', 'type': 'str'},
        'aad_audience': {'key': 'aadAudience', 'type': 'str'},
        'aad_issuer': {'key': 'aadIssuer', 'type': 'str'},
    }

    def __init__(self, *, aad_tenant: str=None, aad_audience: str=None, aad_issuer: str=None, **kwargs) -> None:
        super(AadAuthenticationParameters, self).__init__(**kwargs)
        self.aad_tenant = aad_tenant
        self.aad_audience = aad_audience
        self.aad_issuer = aad_issuer


class AddressSpace(Model):
    """AddressSpace contains an array of IP address ranges that can be used by
    subnets of the virtual network.

    :param address_prefixes: A list of address blocks reserved for this
     virtual network in CIDR notation.
    :type address_prefixes: list[str]
    """

    _attribute_map = {
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
    }

    def __init__(self, *, address_prefixes=None, **kwargs) -> None:
        super(AddressSpace, self).__init__(**kwargs)
        self.address_prefixes = address_prefixes


class Resource(Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationGateway(Resource):
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: SKU of the application gateway resource.
    :type sku: ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySku
    :param ssl_policy: SSL policy of the application gateway resource.
    :type ssl_policy:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslPolicy
    :ivar operational_state: Operational state of the application gateway
     resource. Possible values include: 'Stopped', 'Starting', 'Running',
     'Stopping'
    :vartype operational_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayOperationalState
    :param gateway_ip_configurations: Subnets of the application gateway
     resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type gateway_ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayIPConfiguration]
    :param authentication_certificates: Authentication certificates of the
     application gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type authentication_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayAuthenticationCertificate]
    :param trusted_root_certificates: Trusted Root certificates of the
     application gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type trusted_root_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayTrustedRootCertificate]
    :param ssl_certificates: SSL certificates of the application gateway
     resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type ssl_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslCertificate]
    :param frontend_ip_configurations: Frontend IP addresses of the
     application gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayFrontendIPConfiguration]
    :param frontend_ports: Frontend ports of the application gateway resource.
     For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type frontend_ports:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayFrontendPort]
    :param probes: Probes of the application gateway resource.
    :type probes:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayProbe]
    :param backend_address_pools: Backend address pool of the application
     gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type backend_address_pools:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendAddressPool]
    :param backend_http_settings_collection: Backend http settings of the
     application gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendHttpSettings]
    :param http_listeners: Http listeners of the application gateway resource.
     For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type http_listeners:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayHttpListener]
    :param url_path_maps: URL path map of the application gateway resource.
     For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type url_path_maps:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayUrlPathMap]
    :param request_routing_rules: Request routing rules of the application
     gateway resource.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayRequestRoutingRule]
    :param rewrite_rule_sets: Rewrite rules for the application gateway
     resource.
    :type rewrite_rule_sets:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayRewriteRuleSet]
    :param redirect_configurations: Redirect configurations of the application
     gateway resource. For default limits, see [Application Gateway
     limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
    :type redirect_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayRedirectConfiguration]
    :param web_application_firewall_configuration: Web application firewall
     configuration.
    :type web_application_firewall_configuration:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayWebApplicationFirewallConfiguration
    :param firewall_policy: Reference of the FirewallPolicy resource.
    :type firewall_policy: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param enable_http2: Whether HTTP2 is enabled on the application gateway
     resource.
    :type enable_http2: bool
    :param enable_fips: Whether FIPS is enabled on the application gateway
     resource.
    :type enable_fips: bool
    :param autoscale_configuration: Autoscale Configuration.
    :type autoscale_configuration:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayAutoscaleConfiguration
    :ivar resource_guid: The resource GUID property of the application gateway
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application
     gateway resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param custom_error_configurations: Custom error configurations of the
     application gateway resource.
    :type custom_error_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayCustomError]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param zones: A list of availability zones denoting where the resource
     needs to come from.
    :type zones: list[str]
    :param identity: The identity of the application gateway, if configured.
    :type identity:
     ~azure.mgmt.network.v2019_09_01.models.ManagedServiceIdentity
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operational_state': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'ApplicationGatewaySku'},
        'ssl_policy': {'key': 'properties.sslPolicy', 'type': 'ApplicationGatewaySslPolicy'},
        'operational_state': {'key': 'properties.operationalState', 'type': 'str'},
        'gateway_ip_configurations': {'key': 'properties.gatewayIPConfigurations', 'type': '[ApplicationGatewayIPConfiguration]'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[ApplicationGatewayAuthenticationCertificate]'},
        'trusted_root_certificates': {'key': 'properties.trustedRootCertificates', 'type': '[ApplicationGatewayTrustedRootCertificate]'},
        'ssl_certificates': {'key': 'properties.sslCertificates', 'type': '[ApplicationGatewaySslCertificate]'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[ApplicationGatewayFrontendIPConfiguration]'},
        'frontend_ports': {'key': 'properties.frontendPorts', 'type': '[ApplicationGatewayFrontendPort]'},
        'probes': {'key': 'properties.probes', 'type': '[ApplicationGatewayProbe]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'backend_http_settings_collection': {'key': 'properties.backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHttpSettings]'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[ApplicationGatewayHttpListener]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[ApplicationGatewayUrlPathMap]'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[ApplicationGatewayRequestRoutingRule]'},
        'rewrite_rule_sets': {'key': 'properties.rewriteRuleSets', 'type': '[ApplicationGatewayRewriteRuleSet]'},
        'redirect_configurations': {'key': 'properties.redirectConfigurations', 'type': '[ApplicationGatewayRedirectConfiguration]'},
        'web_application_firewall_configuration': {'key': 'properties.webApplicationFirewallConfiguration', 'type': 'ApplicationGatewayWebApplicationFirewallConfiguration'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
        'enable_http2': {'key': 'properties.enableHttp2', 'type': 'bool'},
        'enable_fips': {'key': 'properties.enableFips', 'type': 'bool'},
        'autoscale_configuration': {'key': 'properties.autoscaleConfiguration', 'type': 'ApplicationGatewayAutoscaleConfiguration'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'custom_error_configurations': {'key': 'properties.customErrorConfigurations', 'type': '[ApplicationGatewayCustomError]'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, sku=None, ssl_policy=None, gateway_ip_configurations=None, authentication_certificates=None, trusted_root_certificates=None, ssl_certificates=None, frontend_ip_configurations=None, frontend_ports=None, probes=None, backend_address_pools=None, backend_http_settings_collection=None, http_listeners=None, url_path_maps=None, request_routing_rules=None, rewrite_rule_sets=None, redirect_configurations=None, web_application_firewall_configuration=None, firewall_policy=None, enable_http2: bool=None, enable_fips: bool=None, autoscale_configuration=None, custom_error_configurations=None, zones=None, identity=None, **kwargs) -> None:
        super(ApplicationGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.ssl_policy = ssl_policy
        self.operational_state = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.http_listeners = http_listeners
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.rewrite_rule_sets = rewrite_rule_sets
        self.redirect_configurations = redirect_configurations
        self.web_application_firewall_configuration = web_application_firewall_configuration
        self.firewall_policy = firewall_policy
        self.enable_http2 = enable_http2
        self.enable_fips = enable_fips
        self.autoscale_configuration = autoscale_configuration
        self.resource_guid = None
        self.provisioning_state = None
        self.custom_error_configurations = custom_error_configurations
        self.etag = None
        self.zones = zones
        self.identity = identity


class SubResource(Model):
    """Reference to another subresource.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class ApplicationGatewayAuthenticationCertificate(SubResource):
    """Authentication certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param data: Certificate public data.
    :type data: str
    :ivar provisioning_state: The provisioning state of the authentication
     certificate resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the authentication certificate that is unique within
     an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, data: str=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayAuthenticationCertificate, self).__init__(id=id, **kwargs)
        self.data = data
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayAutoscaleConfiguration(Model):
    """Application Gateway autoscale configuration.

    All required parameters must be populated in order to send to Azure.

    :param min_capacity: Required. Lower bound on number of Application
     Gateway capacity.
    :type min_capacity: int
    :param max_capacity: Upper bound on number of Application Gateway
     capacity.
    :type max_capacity: int
    """

    _validation = {
        'min_capacity': {'required': True, 'minimum': 0},
        'max_capacity': {'minimum': 2},
    }

    _attribute_map = {
        'min_capacity': {'key': 'minCapacity', 'type': 'int'},
        'max_capacity': {'key': 'maxCapacity', 'type': 'int'},
    }

    def __init__(self, *, min_capacity: int, max_capacity: int=None, **kwargs) -> None:
        super(ApplicationGatewayAutoscaleConfiguration, self).__init__(**kwargs)
        self.min_capacity = min_capacity
        self.max_capacity = max_capacity


class ApplicationGatewayAvailableSslOptions(Resource):
    """Response for ApplicationGatewayAvailableSslOptions API service call.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param predefined_policies: List of available Ssl predefined policy.
    :type predefined_policies:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param default_policy: Name of the Ssl predefined policy applied by
     default to application gateway. Possible values include:
     'AppGwSslPolicy20150501', 'AppGwSslPolicy20170401',
     'AppGwSslPolicy20170401S'
    :type default_policy: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslPolicyName
    :param available_cipher_suites: List of available Ssl cipher suites.
    :type available_cipher_suites: list[str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslCipherSuite]
    :param available_protocols: List of available Ssl protocols.
    :type available_protocols: list[str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslProtocol]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'predefined_policies': {'key': 'properties.predefinedPolicies', 'type': '[SubResource]'},
        'default_policy': {'key': 'properties.defaultPolicy', 'type': 'str'},
        'available_cipher_suites': {'key': 'properties.availableCipherSuites', 'type': '[str]'},
        'available_protocols': {'key': 'properties.availableProtocols', 'type': '[str]'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, predefined_policies=None, default_policy=None, available_cipher_suites=None, available_protocols=None, **kwargs) -> None:
        super(ApplicationGatewayAvailableSslOptions, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.predefined_policies = predefined_policies
        self.default_policy = default_policy
        self.available_cipher_suites = available_cipher_suites
        self.available_protocols = available_protocols


class ApplicationGatewayAvailableWafRuleSetsResult(Model):
    """Response for ApplicationGatewayAvailableWafRuleSets API service call.

    :param value: The list of application gateway rule sets.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayFirewallRuleSet]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGatewayFirewallRuleSet]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(ApplicationGatewayAvailableWafRuleSetsResult, self).__init__(**kwargs)
        self.value = value


class ApplicationGatewayBackendAddress(Model):
    """Backend address of an application gateway.

    :param fqdn: Fully qualified domain name (FQDN).
    :type fqdn: str
    :param ip_address: IP address.
    :type ip_address: str
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(self, *, fqdn: str=None, ip_address: str=None, **kwargs) -> None:
        super(ApplicationGatewayBackendAddress, self).__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_address = ip_address


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar backend_ip_configurations: Collection of references to IPs defined
     in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceIPConfiguration]
    :param backend_addresses: Backend addresses.
    :type backend_addresses:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendAddress]
    :ivar provisioning_state: The provisioning state of the backend address
     pool resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the backend address pool that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'backend_ip_configurations': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'backend_addresses': {'key': 'properties.backendAddresses', 'type': '[ApplicationGatewayBackendAddress]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, backend_addresses=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayBackendAddressPool, self).__init__(id=id, **kwargs)
        self.backend_ip_configurations = None
        self.backend_addresses = backend_addresses
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayBackendHealth(Model):
    """Response for ApplicationGatewayBackendHealth API service call.

    :param backend_address_pools: A list of
     ApplicationGatewayBackendHealthPool resources.
    :type backend_address_pools:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendHealthPool]
    """

    _attribute_map = {
        'backend_address_pools': {'key': 'backendAddressPools', 'type': '[ApplicationGatewayBackendHealthPool]'},
    }

    def __init__(self, *, backend_address_pools=None, **kwargs) -> None:
        super(ApplicationGatewayBackendHealth, self).__init__(**kwargs)
        self.backend_address_pools = backend_address_pools


class ApplicationGatewayBackendHealthHttpSettings(Model):
    """Application gateway BackendHealthHttp settings.

    :param backend_http_settings: Reference of an
     ApplicationGatewayBackendHttpSettings resource.
    :type backend_http_settings:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendHttpSettings
    :param servers: List of ApplicationGatewayBackendHealthServer resources.
    :type servers:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendHealthServer]
    """

    _attribute_map = {
        'backend_http_settings': {'key': 'backendHttpSettings', 'type': 'ApplicationGatewayBackendHttpSettings'},
        'servers': {'key': 'servers', 'type': '[ApplicationGatewayBackendHealthServer]'},
    }

    def __init__(self, *, backend_http_settings=None, servers=None, **kwargs) -> None:
        super(ApplicationGatewayBackendHealthHttpSettings, self).__init__(**kwargs)
        self.backend_http_settings = backend_http_settings
        self.servers = servers


class ApplicationGatewayBackendHealthOnDemand(Model):
    """Result of on demand test probe.

    :param backend_address_pool: Reference of an
     ApplicationGatewayBackendAddressPool resource.
    :type backend_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendAddressPool
    :param backend_health_http_settings: Application gateway BackendHealthHttp
     settings.
    :type backend_health_http_settings:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendHealthHttpSettings
    """

    _attribute_map = {
        'backend_address_pool': {'key': 'backendAddressPool', 'type': 'ApplicationGatewayBackendAddressPool'},
        'backend_health_http_settings': {'key': 'backendHealthHttpSettings', 'type': 'ApplicationGatewayBackendHealthHttpSettings'},
    }

    def __init__(self, *, backend_address_pool=None, backend_health_http_settings=None, **kwargs) -> None:
        super(ApplicationGatewayBackendHealthOnDemand, self).__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_health_http_settings = backend_health_http_settings


class ApplicationGatewayBackendHealthPool(Model):
    """Application gateway BackendHealth pool.

    :param backend_address_pool: Reference of an
     ApplicationGatewayBackendAddressPool resource.
    :type backend_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendAddressPool
    :param backend_http_settings_collection: List of
     ApplicationGatewayBackendHealthHttpSettings resources.
    :type backend_http_settings_collection:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendHealthHttpSettings]
    """

    _attribute_map = {
        'backend_address_pool': {'key': 'backendAddressPool', 'type': 'ApplicationGatewayBackendAddressPool'},
        'backend_http_settings_collection': {'key': 'backendHttpSettingsCollection', 'type': '[ApplicationGatewayBackendHealthHttpSettings]'},
    }

    def __init__(self, *, backend_address_pool=None, backend_http_settings_collection=None, **kwargs) -> None:
        super(ApplicationGatewayBackendHealthPool, self).__init__(**kwargs)
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings_collection = backend_http_settings_collection


class ApplicationGatewayBackendHealthServer(Model):
    """Application gateway backendhealth http settings.

    :param address: IP address or FQDN of backend server.
    :type address: str
    :param ip_configuration: Reference of IP configuration of backend server.
    :type ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceIPConfiguration
    :param health: Health of backend server. Possible values include:
     'Unknown', 'Up', 'Down', 'Partial', 'Draining'
    :type health: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendHealthServerHealth
    :param health_probe_log: Health Probe Log.
    :type health_probe_log: str
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'ip_configuration': {'key': 'ipConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'health': {'key': 'health', 'type': 'str'},
        'health_probe_log': {'key': 'healthProbeLog', 'type': 'str'},
    }

    def __init__(self, *, address: str=None, ip_configuration=None, health=None, health_probe_log: str=None, **kwargs) -> None:
        super(ApplicationGatewayBackendHealthServer, self).__init__(**kwargs)
        self.address = address
        self.ip_configuration = ip_configuration
        self.health = health
        self.health_probe_log = health_probe_log


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param port: The destination port on the backend.
    :type port: int
    :param protocol: The protocol used to communicate with the backend.
     Possible values include: 'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayProtocol
    :param cookie_based_affinity: Cookie based affinity. Possible values
     include: 'Enabled', 'Disabled'
    :type cookie_based_affinity: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayCookieBasedAffinity
    :param request_timeout: Request timeout in seconds. Application Gateway
     will fail the request if response is not received within RequestTimeout.
     Acceptable values are from 1 second to 86400 seconds.
    :type request_timeout: int
    :param probe: Probe resource of an application gateway.
    :type probe: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param authentication_certificates: Array of references to application
     gateway authentication certificates.
    :type authentication_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param trusted_root_certificates: Array of references to application
     gateway trusted root certificates.
    :type trusted_root_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param connection_draining: Connection draining of the backend http
     settings resource.
    :type connection_draining:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayConnectionDraining
    :param host_name: Host header to be sent to the backend servers.
    :type host_name: str
    :param pick_host_name_from_backend_address: Whether to pick host header
     should be picked from the host name of the backend server. Default value
     is false.
    :type pick_host_name_from_backend_address: bool
    :param affinity_cookie_name: Cookie name to use for the affinity cookie.
    :type affinity_cookie_name: str
    :param probe_enabled: Whether the probe is enabled. Default value is
     false.
    :type probe_enabled: bool
    :param path: Path which should be used as a prefix for all HTTP requests.
     Null means no path will be prefixed. Default value is null.
    :type path: str
    :ivar provisioning_state: The provisioning state of the backend HTTP
     settings resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the backend http settings that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'cookie_based_affinity': {'key': 'properties.cookieBasedAffinity', 'type': 'str'},
        'request_timeout': {'key': 'properties.requestTimeout', 'type': 'int'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[SubResource]'},
        'trusted_root_certificates': {'key': 'properties.trustedRootCertificates', 'type': '[SubResource]'},
        'connection_draining': {'key': 'properties.connectionDraining', 'type': 'ApplicationGatewayConnectionDraining'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'pick_host_name_from_backend_address': {'key': 'properties.pickHostNameFromBackendAddress', 'type': 'bool'},
        'affinity_cookie_name': {'key': 'properties.affinityCookieName', 'type': 'str'},
        'probe_enabled': {'key': 'properties.probeEnabled', 'type': 'bool'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, port: int=None, protocol=None, cookie_based_affinity=None, request_timeout: int=None, probe=None, authentication_certificates=None, trusted_root_certificates=None, connection_draining=None, host_name: str=None, pick_host_name_from_backend_address: bool=None, affinity_cookie_name: str=None, probe_enabled: bool=None, path: str=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayBackendHttpSettings, self).__init__(id=id, **kwargs)
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.authentication_certificates = authentication_certificates
        self.trusted_root_certificates = trusted_root_certificates
        self.connection_draining = connection_draining
        self.host_name = host_name
        self.pick_host_name_from_backend_address = pick_host_name_from_backend_address
        self.affinity_cookie_name = affinity_cookie_name
        self.probe_enabled = probe_enabled
        self.path = path
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayConnectionDraining(Model):
    """Connection draining allows open connections to a backend server to be
    active for a specified time after the backend server got removed from the
    configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether connection draining is enabled or not.
    :type enabled: bool
    :param drain_timeout_in_sec: Required. The number of seconds connection
     draining is active. Acceptable values are from 1 second to 3600 seconds.
    :type drain_timeout_in_sec: int
    """

    _validation = {
        'enabled': {'required': True},
        'drain_timeout_in_sec': {'required': True, 'maximum': 3600, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'drain_timeout_in_sec': {'key': 'drainTimeoutInSec', 'type': 'int'},
    }

    def __init__(self, *, enabled: bool, drain_timeout_in_sec: int, **kwargs) -> None:
        super(ApplicationGatewayConnectionDraining, self).__init__(**kwargs)
        self.enabled = enabled
        self.drain_timeout_in_sec = drain_timeout_in_sec


class ApplicationGatewayCustomError(Model):
    """Customer error of an application gateway.

    :param status_code: Status code of the application gateway customer error.
     Possible values include: 'HttpStatus403', 'HttpStatus502'
    :type status_code: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayCustomErrorStatusCode
    :param custom_error_page_url: Error page URL of the application gateway
     customer error.
    :type custom_error_page_url: str
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'custom_error_page_url': {'key': 'customErrorPageUrl', 'type': 'str'},
    }

    def __init__(self, *, status_code=None, custom_error_page_url: str=None, **kwargs) -> None:
        super(ApplicationGatewayCustomError, self).__init__(**kwargs)
        self.status_code = status_code
        self.custom_error_page_url = custom_error_page_url


class ApplicationGatewayFirewallDisabledRuleGroup(Model):
    """Allows to disable rules within a rule group or an entire rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the rule group that will be
     disabled.
    :type rule_group_name: str
    :param rules: The list of rules that will be disabled. If null, all rules
     of the rule group will be disabled.
    :type rules: list[int]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[int]'},
    }

    def __init__(self, *, rule_group_name: str, rules=None, **kwargs) -> None:
        super(ApplicationGatewayFirewallDisabledRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ApplicationGatewayFirewallExclusion(Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. The variable to be excluded.
    :type match_variable: str
    :param selector_match_operator: Required. When matchVariable is a
     collection, operate on the selector to specify which elements in the
     collection this exclusion applies to.
    :type selector_match_operator: str
    :param selector: Required. When matchVariable is a collection, operator
     used to specify which elements in the collection this exclusion applies
     to.
    :type selector: str
    """

    _validation = {
        'match_variable': {'required': True},
        'selector_match_operator': {'required': True},
        'selector': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector_match_operator': {'key': 'selectorMatchOperator', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
    }

    def __init__(self, *, match_variable: str, selector_match_operator: str, selector: str, **kwargs) -> None:
        super(ApplicationGatewayFirewallExclusion, self).__init__(**kwargs)
        self.match_variable = match_variable
        self.selector_match_operator = selector_match_operator
        self.selector = selector


class ApplicationGatewayFirewallRule(Model):
    """A web application firewall rule.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. The identifier of the web application firewall
     rule.
    :type rule_id: int
    :param description: The description of the web application firewall rule.
    :type description: str
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'int'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, rule_id: int, description: str=None, **kwargs) -> None:
        super(ApplicationGatewayFirewallRule, self).__init__(**kwargs)
        self.rule_id = rule_id
        self.description = description


class ApplicationGatewayFirewallRuleGroup(Model):
    """A web application firewall rule group.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. The name of the web application firewall
     rule group.
    :type rule_group_name: str
    :param description: The description of the web application firewall rule
     group.
    :type description: str
    :param rules: Required. The rules of the web application firewall rule
     group.
    :type rules:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayFirewallRule]
    """

    _validation = {
        'rule_group_name': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ApplicationGatewayFirewallRule]'},
    }

    def __init__(self, *, rule_group_name: str, rules, description: str=None, **kwargs) -> None:
        super(ApplicationGatewayFirewallRuleGroup, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.description = description
        self.rules = rules


class ApplicationGatewayFirewallRuleSet(Resource):
    """A web application firewall rule set.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the web application
     firewall rule set. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param rule_set_type: Required. The type of the web application firewall
     rule set.
    :type rule_set_type: str
    :param rule_set_version: Required. The version of the web application
     firewall rule set type.
    :type rule_set_version: str
    :param rule_groups: Required. The rule groups of the web application
     firewall rule set.
    :type rule_groups:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayFirewallRuleGroup]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
        'rule_groups': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ApplicationGatewayFirewallRuleGroup]'},
    }

    def __init__(self, *, rule_set_type: str, rule_set_version: str, rule_groups, id: str=None, location: str=None, tags=None, **kwargs) -> None:
        super(ApplicationGatewayFirewallRuleSet, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_groups = rule_groups


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param private_ip_address: PrivateIPAddress of the network interface IP
     Configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP address allocation
     method. Possible values include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_09_01.models.IPAllocationMethod
    :param subnet: Reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param public_ip_address: Reference of the PublicIP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP
     configuration resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the frontend IP configuration that is unique within
     an Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, private_ip_address: str=None, private_ip_allocation_method=None, subnet=None, public_ip_address=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayFrontendIPConfiguration, self).__init__(id=id, **kwargs)
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param port: Frontend port.
    :type port: int
    :ivar provisioning_state: The provisioning state of the frontend port
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the frontend port that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, port: int=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayFrontendPort, self).__init__(id=id, **kwargs)
        self.port = port
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayHeaderConfiguration(Model):
    """Header configuration of the Actions set in Application Gateway.

    :param header_name: Header name of the header configuration.
    :type header_name: str
    :param header_value: Header value of the header configuration.
    :type header_value: str
    """

    _attribute_map = {
        'header_name': {'key': 'headerName', 'type': 'str'},
        'header_value': {'key': 'headerValue', 'type': 'str'},
    }

    def __init__(self, *, header_name: str=None, header_value: str=None, **kwargs) -> None:
        super(ApplicationGatewayHeaderConfiguration, self).__init__(**kwargs)
        self.header_name = header_name
        self.header_value = header_value


class ApplicationGatewayHttpListener(SubResource):
    """Http listener of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param frontend_ip_configuration: Frontend IP configuration resource of an
     application gateway.
    :type frontend_ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param frontend_port: Frontend port resource of an application gateway.
    :type frontend_port: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param protocol: Protocol of the HTTP listener. Possible values include:
     'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayProtocol
    :param host_name: Host name of HTTP listener.
    :type host_name: str
    :param ssl_certificate: SSL certificate resource of an application
     gateway.
    :type ssl_certificate: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param require_server_name_indication: Applicable only if protocol is
     https. Enables SNI for multi-hosting.
    :type require_server_name_indication: bool
    :ivar provisioning_state: The provisioning state of the HTTP listener
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param custom_error_configurations: Custom error configurations of the
     HTTP listener.
    :type custom_error_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayCustomError]
    :param firewall_policy: Reference to the FirewallPolicy resource.
    :type firewall_policy: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param hostnames: List of Host names for HTTP Listener that allows special
     wildcard characters as well.
    :type hostnames: list[str]
    :param name: Name of the HTTP listener that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'ssl_certificate': {'key': 'properties.sslCertificate', 'type': 'SubResource'},
        'require_server_name_indication': {'key': 'properties.requireServerNameIndication', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'custom_error_configurations': {'key': 'properties.customErrorConfigurations', 'type': '[ApplicationGatewayCustomError]'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
        'hostnames': {'key': 'properties.hostnames', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, frontend_ip_configuration=None, frontend_port=None, protocol=None, host_name: str=None, ssl_certificate=None, require_server_name_indication: bool=None, custom_error_configurations=None, firewall_policy=None, hostnames=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayHttpListener, self).__init__(id=id, **kwargs)
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state = None
        self.custom_error_configurations = custom_error_configurations
        self.firewall_policy = firewall_policy
        self.hostnames = hostnames
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1
    private IP configuration is allowed.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param subnet: Reference of the subnet resource. A subnet from where
     application gateway gets its private address.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the application
     gateway IP configuration resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the IP configuration that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, subnet=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayIPConfiguration, self).__init__(id=id, **kwargs)
        self.subnet = subnet
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayOnDemandProbe(Model):
    """Details of on demand test probe request.

    :param protocol: The protocol used for the probe. Possible values include:
     'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is
     sent to <Protocol>://<host>:<port><path>.
    :type path: str
    :param timeout: The probe timeout in seconds. Probe marked as failed if
     valid response is not received with this timeout period. Acceptable values
     are from 1 second to 86400 seconds.
    :type timeout: int
    :param pick_host_name_from_backend_http_settings: Whether the host header
     should be picked from the backend http settings. Default value is false.
    :type pick_host_name_from_backend_http_settings: bool
    :param match: Criterion for classifying a healthy probe response.
    :type match:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayProbeHealthResponseMatch
    :param backend_address_pool: Reference of backend pool of application
     gateway to which probe request will be sent.
    :type backend_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param backend_http_settings: Reference of backend http setting of
     application gateway to be used for test probe.
    :type backend_http_settings:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'pick_host_name_from_backend_http_settings': {'key': 'pickHostNameFromBackendHttpSettings', 'type': 'bool'},
        'match': {'key': 'match', 'type': 'ApplicationGatewayProbeHealthResponseMatch'},
        'backend_address_pool': {'key': 'backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'backendHttpSettings', 'type': 'SubResource'},
    }

    def __init__(self, *, protocol=None, host: str=None, path: str=None, timeout: int=None, pick_host_name_from_backend_http_settings: bool=None, match=None, backend_address_pool=None, backend_http_settings=None, **kwargs) -> None:
        super(ApplicationGatewayOnDemandProbe, self).__init__(**kwargs)
        self.protocol = protocol
        self.host = host
        self.path = path
        self.timeout = timeout
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.match = match
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param paths: Path rules of URL path map.
    :type paths: list[str]
    :param backend_address_pool: Backend address pool resource of URL path map
     path rule.
    :type backend_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param backend_http_settings: Backend http settings resource of URL path
     map path rule.
    :type backend_http_settings:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param redirect_configuration: Redirect configuration resource of URL path
     map path rule.
    :type redirect_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param rewrite_rule_set: Rewrite rule set resource of URL path map path
     rule.
    :type rewrite_rule_set: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the path rule
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param firewall_policy: Reference to the FirewallPolicy resource.
    :type firewall_policy: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param name: Name of the path rule that is unique within an Application
     Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'paths': {'key': 'properties.paths', 'type': '[str]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'redirect_configuration': {'key': 'properties.redirectConfiguration', 'type': 'SubResource'},
        'rewrite_rule_set': {'key': 'properties.rewriteRuleSet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, paths=None, backend_address_pool=None, backend_http_settings=None, redirect_configuration=None, rewrite_rule_set=None, firewall_policy=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayPathRule, self).__init__(id=id, **kwargs)
        self.paths = paths
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.redirect_configuration = redirect_configuration
        self.rewrite_rule_set = rewrite_rule_set
        self.provisioning_state = None
        self.firewall_policy = firewall_policy
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayProbe(SubResource):
    """Probe of the application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param protocol: The protocol used for the probe. Possible values include:
     'Http', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayProtocol
    :param host: Host name to send the probe to.
    :type host: str
    :param path: Relative path of probe. Valid path starts from '/'. Probe is
     sent to <Protocol>://<host>:<port><path>.
    :type path: str
    :param interval: The probing interval in seconds. This is the time
     interval between two consecutive probes. Acceptable values are from 1
     second to 86400 seconds.
    :type interval: int
    :param timeout: The probe timeout in seconds. Probe marked as failed if
     valid response is not received with this timeout period. Acceptable values
     are from 1 second to 86400 seconds.
    :type timeout: int
    :param unhealthy_threshold: The probe retry count. Backend server is
     marked down after consecutive probe failure count reaches
     UnhealthyThreshold. Acceptable values are from 1 second to 20.
    :type unhealthy_threshold: int
    :param pick_host_name_from_backend_http_settings: Whether the host header
     should be picked from the backend http settings. Default value is false.
    :type pick_host_name_from_backend_http_settings: bool
    :param min_servers: Minimum number of servers that are always marked
     healthy. Default value is 0.
    :type min_servers: int
    :param match: Criterion for classifying a healthy probe response.
    :type match:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayProbeHealthResponseMatch
    :ivar provisioning_state: The provisioning state of the probe resource.
     Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param port: Custom port which will be used for probing the backend
     servers. The valid value ranges from 1 to 65535. In case not set, port
     from http settings will be used. This property is valid for Standard_v2
     and WAF_v2 only.
    :type port: int
    :param name: Name of the probe that is unique within an Application
     Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'port': {'maximum': 65535, 'minimum': 1},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'host': {'key': 'properties.host', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'int'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'unhealthy_threshold': {'key': 'properties.unhealthyThreshold', 'type': 'int'},
        'pick_host_name_from_backend_http_settings': {'key': 'properties.pickHostNameFromBackendHttpSettings', 'type': 'bool'},
        'min_servers': {'key': 'properties.minServers', 'type': 'int'},
        'match': {'key': 'properties.match', 'type': 'ApplicationGatewayProbeHealthResponseMatch'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, protocol=None, host: str=None, path: str=None, interval: int=None, timeout: int=None, unhealthy_threshold: int=None, pick_host_name_from_backend_http_settings: bool=None, min_servers: int=None, match=None, port: int=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayProbe, self).__init__(id=id, **kwargs)
        self.protocol = protocol
        self.host = host
        self.path = path
        self.interval = interval
        self.timeout = timeout
        self.unhealthy_threshold = unhealthy_threshold
        self.pick_host_name_from_backend_http_settings = pick_host_name_from_backend_http_settings
        self.min_servers = min_servers
        self.match = match
        self.provisioning_state = None
        self.port = port
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayProbeHealthResponseMatch(Model):
    """Application gateway probe health response match.

    :param body: Body that must be contained in the health response. Default
     value is empty.
    :type body: str
    :param status_codes: Allowed ranges of healthy status codes. Default range
     of healthy status codes is 200-399.
    :type status_codes: list[str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'str'},
        'status_codes': {'key': 'statusCodes', 'type': '[str]'},
    }

    def __init__(self, *, body: str=None, status_codes=None, **kwargs) -> None:
        super(ApplicationGatewayProbeHealthResponseMatch, self).__init__(**kwargs)
        self.body = body
        self.status_codes = status_codes


class ApplicationGatewayRedirectConfiguration(SubResource):
    """Redirect configuration of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param redirect_type: HTTP redirection type. Possible values include:
     'Permanent', 'Found', 'SeeOther', 'Temporary'
    :type redirect_type: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayRedirectType
    :param target_listener: Reference to a listener to redirect the request
     to.
    :type target_listener: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param target_url: Url to redirect the request to.
    :type target_url: str
    :param include_path: Include path in the redirected url.
    :type include_path: bool
    :param include_query_string: Include query string in the redirected url.
    :type include_query_string: bool
    :param request_routing_rules: Request routing specifying redirect
     configuration.
    :type request_routing_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param url_path_maps: Url path maps specifying default redirect
     configuration.
    :type url_path_maps:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param path_rules: Path rules specifying redirect configuration.
    :type path_rules: list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param name: Name of the redirect configuration that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'redirect_type': {'key': 'properties.redirectType', 'type': 'str'},
        'target_listener': {'key': 'properties.targetListener', 'type': 'SubResource'},
        'target_url': {'key': 'properties.targetUrl', 'type': 'str'},
        'include_path': {'key': 'properties.includePath', 'type': 'bool'},
        'include_query_string': {'key': 'properties.includeQueryString', 'type': 'bool'},
        'request_routing_rules': {'key': 'properties.requestRoutingRules', 'type': '[SubResource]'},
        'url_path_maps': {'key': 'properties.urlPathMaps', 'type': '[SubResource]'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[SubResource]'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, redirect_type=None, target_listener=None, target_url: str=None, include_path: bool=None, include_query_string: bool=None, request_routing_rules=None, url_path_maps=None, path_rules=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayRedirectConfiguration, self).__init__(id=id, **kwargs)
        self.redirect_type = redirect_type
        self.target_listener = target_listener
        self.target_url = target_url
        self.include_path = include_path
        self.include_query_string = include_query_string
        self.request_routing_rules = request_routing_rules
        self.url_path_maps = url_path_maps
        self.path_rules = path_rules
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayRequestRoutingRule(SubResource):
    """Request routing rule of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param rule_type: Rule type. Possible values include: 'Basic',
     'PathBasedRouting'
    :type rule_type: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayRequestRoutingRuleType
    :param priority: Priority of the request routing rule.
    :type priority: int
    :param backend_address_pool: Backend address pool resource of the
     application gateway.
    :type backend_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param backend_http_settings: Backend http settings resource of the
     application gateway.
    :type backend_http_settings:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param http_listener: Http listener resource of the application gateway.
    :type http_listener: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param url_path_map: URL path map resource of the application gateway.
    :type url_path_map: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the
     application gateway.
    :type rewrite_rule_set: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param redirect_configuration: Redirect configuration resource of the
     application gateway.
    :type redirect_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the request routing
     rule resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the request routing rule that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'priority': {'maximum': 20000, 'minimum': 1},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'properties.ruleType', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'backend_http_settings': {'key': 'properties.backendHttpSettings', 'type': 'SubResource'},
        'http_listener': {'key': 'properties.httpListener', 'type': 'SubResource'},
        'url_path_map': {'key': 'properties.urlPathMap', 'type': 'SubResource'},
        'rewrite_rule_set': {'key': 'properties.rewriteRuleSet', 'type': 'SubResource'},
        'redirect_configuration': {'key': 'properties.redirectConfiguration', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, rule_type=None, priority: int=None, backend_address_pool=None, backend_http_settings=None, http_listener=None, url_path_map=None, rewrite_rule_set=None, redirect_configuration=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayRequestRoutingRule, self).__init__(id=id, **kwargs)
        self.rule_type = rule_type
        self.priority = priority
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.rewrite_rule_set = rewrite_rule_set
        self.redirect_configuration = redirect_configuration
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayRewriteRule(Model):
    """Rewrite rule of an application gateway.

    :param name: Name of the rewrite rule that is unique within an Application
     Gateway.
    :type name: str
    :param rule_sequence: Rule Sequence of the rewrite rule that determines
     the order of execution of a particular rule in a RewriteRuleSet.
    :type rule_sequence: int
    :param conditions: Conditions based on which the action set execution will
     be evaluated.
    :type conditions:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayRewriteRuleCondition]
    :param action_set: Set of actions to be done as part of the rewrite Rule.
    :type action_set:
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayRewriteRuleActionSet
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'rule_sequence': {'key': 'ruleSequence', 'type': 'int'},
        'conditions': {'key': 'conditions', 'type': '[ApplicationGatewayRewriteRuleCondition]'},
        'action_set': {'key': 'actionSet', 'type': 'ApplicationGatewayRewriteRuleActionSet'},
    }

    def __init__(self, *, name: str=None, rule_sequence: int=None, conditions=None, action_set=None, **kwargs) -> None:
        super(ApplicationGatewayRewriteRule, self).__init__(**kwargs)
        self.name = name
        self.rule_sequence = rule_sequence
        self.conditions = conditions
        self.action_set = action_set


class ApplicationGatewayRewriteRuleActionSet(Model):
    """Set of actions in the Rewrite Rule in Application Gateway.

    :param request_header_configurations: Request Header Actions in the Action
     Set.
    :type request_header_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayHeaderConfiguration]
    :param response_header_configurations: Response Header Actions in the
     Action Set.
    :type response_header_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayHeaderConfiguration]
    """

    _attribute_map = {
        'request_header_configurations': {'key': 'requestHeaderConfigurations', 'type': '[ApplicationGatewayHeaderConfiguration]'},
        'response_header_configurations': {'key': 'responseHeaderConfigurations', 'type': '[ApplicationGatewayHeaderConfiguration]'},
    }

    def __init__(self, *, request_header_configurations=None, response_header_configurations=None, **kwargs) -> None:
        super(ApplicationGatewayRewriteRuleActionSet, self).__init__(**kwargs)
        self.request_header_configurations = request_header_configurations
        self.response_header_configurations = response_header_configurations


class ApplicationGatewayRewriteRuleCondition(Model):
    """Set of conditions in the Rewrite Rule in Application Gateway.

    :param variable: The condition parameter of the RewriteRuleCondition.
    :type variable: str
    :param pattern: The pattern, either fixed string or regular expression,
     that evaluates the truthfulness of the condition.
    :type pattern: str
    :param ignore_case: Setting this paramter to truth value with force the
     pattern to do a case in-sensitive comparison.
    :type ignore_case: bool
    :param negate: Setting this value as truth will force to check the
     negation of the condition given by the user.
    :type negate: bool
    """

    _attribute_map = {
        'variable': {'key': 'variable', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'negate': {'key': 'negate', 'type': 'bool'},
    }

    def __init__(self, *, variable: str=None, pattern: str=None, ignore_case: bool=None, negate: bool=None, **kwargs) -> None:
        super(ApplicationGatewayRewriteRuleCondition, self).__init__(**kwargs)
        self.variable = variable
        self.pattern = pattern
        self.ignore_case = ignore_case
        self.negate = negate


class ApplicationGatewayRewriteRuleSet(SubResource):
    """Rewrite rule set of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param rewrite_rules: Rewrite rules in the rewrite rule set.
    :type rewrite_rules:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayRewriteRule]
    :ivar provisioning_state: The provisioning state of the rewrite rule set
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the rewrite rule set that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rewrite_rules': {'key': 'properties.rewriteRules', 'type': '[ApplicationGatewayRewriteRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, rewrite_rules=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayRewriteRuleSet, self).__init__(id=id, **kwargs)
        self.rewrite_rules = rewrite_rules
        self.provisioning_state = None
        self.name = name
        self.etag = None


class ApplicationGatewaySku(Model):
    """SKU of an application gateway.

    :param name: Name of an application gateway SKU. Possible values include:
     'Standard_Small', 'Standard_Medium', 'Standard_Large', 'WAF_Medium',
     'WAF_Large', 'Standard_v2', 'WAF_v2'
    :type name: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySkuName
    :param tier: Tier of an application gateway. Possible values include:
     'Standard', 'WAF', 'Standard_v2', 'WAF_v2'
    :type tier: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayTier
    :param capacity: Capacity (instance count) of an application gateway.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, *, name=None, tier=None, capacity: int=None, **kwargs) -> None:
        super(ApplicationGatewaySku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param data: Base-64 encoded pfx certificate. Only applicable in PUT
     Request.
    :type data: str
    :param password: Password for the pfx file specified in data. Only
     applicable in PUT request.
    :type password: str
    :ivar public_cert_data: Base-64 encoded Public cert data corresponding to
     pfx specified in data. Only applicable in GET request.
    :vartype public_cert_data: str
    :param key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx)
     'Secret' or 'Certificate' object stored in KeyVault.
    :type key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the SSL certificate
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the SSL certificate that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'public_cert_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'key_vault_secret_id': {'key': 'properties.keyVaultSecretId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, data: str=None, password: str=None, key_vault_secret_id: str=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewaySslCertificate, self).__init__(id=id, **kwargs)
        self.data = data
        self.password = password
        self.public_cert_data = None
        self.key_vault_secret_id = key_vault_secret_id
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewaySslPolicy(Model):
    """Application Gateway Ssl policy.

    :param disabled_ssl_protocols: Ssl protocols to be disabled on application
     gateway.
    :type disabled_ssl_protocols: list[str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslProtocol]
    :param policy_type: Type of Ssl Policy. Possible values include:
     'Predefined', 'Custom'
    :type policy_type: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslPolicyType
    :param policy_name: Name of Ssl predefined policy. Possible values
     include: 'AppGwSslPolicy20150501', 'AppGwSslPolicy20170401',
     'AppGwSslPolicy20170401S'
    :type policy_name: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslPolicyName
    :param cipher_suites: Ssl cipher suites to be enabled in the specified
     order to application gateway.
    :type cipher_suites: list[str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslCipherSuite]
    :param min_protocol_version: Minimum version of Ssl protocol to be
     supported on application gateway. Possible values include: 'TLSv1_0',
     'TLSv1_1', 'TLSv1_2'
    :type min_protocol_version: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        'disabled_ssl_protocols': {'key': 'disabledSslProtocols', 'type': '[str]'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'cipher_suites': {'key': 'cipherSuites', 'type': '[str]'},
        'min_protocol_version': {'key': 'minProtocolVersion', 'type': 'str'},
    }

    def __init__(self, *, disabled_ssl_protocols=None, policy_type=None, policy_name=None, cipher_suites=None, min_protocol_version=None, **kwargs) -> None:
        super(ApplicationGatewaySslPolicy, self).__init__(**kwargs)
        self.disabled_ssl_protocols = disabled_ssl_protocols
        self.policy_type = policy_type
        self.policy_name = policy_name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewaySslPredefinedPolicy(SubResource):
    """An Ssl predefined policy.

    :param id: Resource ID.
    :type id: str
    :param name: Name of the Ssl predefined policy.
    :type name: str
    :param cipher_suites: Ssl cipher suites to be enabled in the specified
     order for application gateway.
    :type cipher_suites: list[str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslCipherSuite]
    :param min_protocol_version: Minimum version of Ssl protocol to be
     supported on application gateway. Possible values include: 'TLSv1_0',
     'TLSv1_1', 'TLSv1_2'
    :type min_protocol_version: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewaySslProtocol
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'cipher_suites': {'key': 'properties.cipherSuites', 'type': '[str]'},
        'min_protocol_version': {'key': 'properties.minProtocolVersion', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, name: str=None, cipher_suites=None, min_protocol_version=None, **kwargs) -> None:
        super(ApplicationGatewaySslPredefinedPolicy, self).__init__(id=id, **kwargs)
        self.name = name
        self.cipher_suites = cipher_suites
        self.min_protocol_version = min_protocol_version


class ApplicationGatewayTrustedRootCertificate(SubResource):
    """Trusted Root certificates of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param data: Certificate public data.
    :type data: str
    :param key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx)
     'Secret' or 'Certificate' object stored in KeyVault.
    :type key_vault_secret_id: str
    :ivar provisioning_state: The provisioning state of the trusted root
     certificate resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the trusted root certificate that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'key_vault_secret_id': {'key': 'properties.keyVaultSecretId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, data: str=None, key_vault_secret_id: str=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayTrustedRootCertificate, self).__init__(id=id, **kwargs)
        self.data = data
        self.key_vault_secret_id = key_vault_secret_id
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for
    PathBasedRouting.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param default_backend_address_pool: Default backend address pool resource
     of URL path map.
    :type default_backend_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param default_backend_http_settings: Default backend http settings
     resource of URL path map.
    :type default_backend_http_settings:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param default_rewrite_rule_set: Default Rewrite rule set resource of URL
     path map.
    :type default_rewrite_rule_set:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param default_redirect_configuration: Default redirect configuration
     resource of URL path map.
    :type default_redirect_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param path_rules: Path rule of URL path map resource.
    :type path_rules:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayPathRule]
    :ivar provisioning_state: The provisioning state of the URL path map
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the URL path map that is unique within an Application
     Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'default_backend_address_pool': {'key': 'properties.defaultBackendAddressPool', 'type': 'SubResource'},
        'default_backend_http_settings': {'key': 'properties.defaultBackendHttpSettings', 'type': 'SubResource'},
        'default_rewrite_rule_set': {'key': 'properties.defaultRewriteRuleSet', 'type': 'SubResource'},
        'default_redirect_configuration': {'key': 'properties.defaultRedirectConfiguration', 'type': 'SubResource'},
        'path_rules': {'key': 'properties.pathRules', 'type': '[ApplicationGatewayPathRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, default_backend_address_pool=None, default_backend_http_settings=None, default_rewrite_rule_set=None, default_redirect_configuration=None, path_rules=None, name: str=None, **kwargs) -> None:
        super(ApplicationGatewayUrlPathMap, self).__init__(id=id, **kwargs)
        self.default_backend_address_pool = default_backend_address_pool
        self.default_backend_http_settings = default_backend_http_settings
        self.default_rewrite_rule_set = default_rewrite_rule_set
        self.default_redirect_configuration = default_redirect_configuration
        self.path_rules = path_rules
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ApplicationGatewayWebApplicationFirewallConfiguration(Model):
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the web application firewall is enabled
     or not.
    :type enabled: bool
    :param firewall_mode: Required. Web application firewall mode. Possible
     values include: 'Detection', 'Prevention'
    :type firewall_mode: str or
     ~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayFirewallMode
    :param rule_set_type: Required. The type of the web application firewall
     rule set. Possible values are: 'OWASP'.
    :type rule_set_type: str
    :param rule_set_version: Required. The version of the rule set type.
    :type rule_set_version: str
    :param disabled_rule_groups: The disabled rule groups.
    :type disabled_rule_groups:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayFirewallDisabledRuleGroup]
    :param request_body_check: Whether allow WAF to check request Body.
    :type request_body_check: bool
    :param max_request_body_size: Maximum request body size for WAF.
    :type max_request_body_size: int
    :param max_request_body_size_in_kb: Maximum request body size in Kb for
     WAF.
    :type max_request_body_size_in_kb: int
    :param file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
    :type file_upload_limit_in_mb: int
    :param exclusions: The exclusion list.
    :type exclusions:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayFirewallExclusion]
    """

    _validation = {
        'enabled': {'required': True},
        'firewall_mode': {'required': True},
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
        'max_request_body_size': {'maximum': 128, 'minimum': 8},
        'max_request_body_size_in_kb': {'maximum': 128, 'minimum': 8},
        'file_upload_limit_in_mb': {'minimum': 0},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'firewall_mode': {'key': 'firewallMode', 'type': 'str'},
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'disabled_rule_groups': {'key': 'disabledRuleGroups', 'type': '[ApplicationGatewayFirewallDisabledRuleGroup]'},
        'request_body_check': {'key': 'requestBodyCheck', 'type': 'bool'},
        'max_request_body_size': {'key': 'maxRequestBodySize', 'type': 'int'},
        'max_request_body_size_in_kb': {'key': 'maxRequestBodySizeInKb', 'type': 'int'},
        'file_upload_limit_in_mb': {'key': 'fileUploadLimitInMb', 'type': 'int'},
        'exclusions': {'key': 'exclusions', 'type': '[ApplicationGatewayFirewallExclusion]'},
    }

    def __init__(self, *, enabled: bool, firewall_mode, rule_set_type: str, rule_set_version: str, disabled_rule_groups=None, request_body_check: bool=None, max_request_body_size: int=None, max_request_body_size_in_kb: int=None, file_upload_limit_in_mb: int=None, exclusions=None, **kwargs) -> None:
        super(ApplicationGatewayWebApplicationFirewallConfiguration, self).__init__(**kwargs)
        self.enabled = enabled
        self.firewall_mode = firewall_mode
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.disabled_rule_groups = disabled_rule_groups
        self.request_body_check = request_body_check
        self.max_request_body_size = max_request_body_size
        self.max_request_body_size_in_kb = max_request_body_size_in_kb
        self.file_upload_limit_in_mb = file_upload_limit_in_mb
        self.exclusions = exclusions


class FirewallPolicyRuleCondition(Model):
    """Properties of a rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ApplicationRuleCondition, NetworkRuleCondition

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule condition.
    :type name: str
    :param description: Description of the rule condition.
    :type description: str
    :param rule_condition_type: Required. Constant filled by server.
    :type rule_condition_type: str
    """

    _validation = {
        'rule_condition_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rule_condition_type': {'key': 'ruleConditionType', 'type': 'str'},
    }

    _subtype_map = {
        'rule_condition_type': {'ApplicationRuleCondition': 'ApplicationRuleCondition', 'NetworkRuleCondition': 'NetworkRuleCondition'}
    }

    def __init__(self, *, name: str=None, description: str=None, **kwargs) -> None:
        super(FirewallPolicyRuleCondition, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.rule_condition_type = None


class ApplicationRuleCondition(FirewallPolicyRuleCondition):
    """Rule condition of type application.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule condition.
    :type name: str
    :param description: Description of the rule condition.
    :type description: str
    :param rule_condition_type: Required. Constant filled by server.
    :type rule_condition_type: str
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses or Service
     Tags.
    :type destination_addresses: list[str]
    :param protocols: Array of Application Protocols.
    :type protocols:
     list[~azure.mgmt.network.v2019_09_01.models.FirewallPolicyRuleConditionApplicationProtocol]
    :param target_fqdns: List of FQDNs for this rule condition.
    :type target_fqdns: list[str]
    :param fqdn_tags: List of FQDN Tags for this rule condition.
    :type fqdn_tags: list[str]
    """

    _validation = {
        'rule_condition_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rule_condition_type': {'key': 'ruleConditionType', 'type': 'str'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'protocols': {'key': 'protocols', 'type': '[FirewallPolicyRuleConditionApplicationProtocol]'},
        'target_fqdns': {'key': 'targetFqdns', 'type': '[str]'},
        'fqdn_tags': {'key': 'fqdnTags', 'type': '[str]'},
    }

    def __init__(self, *, name: str=None, description: str=None, source_addresses=None, destination_addresses=None, protocols=None, target_fqdns=None, fqdn_tags=None, **kwargs) -> None:
        super(ApplicationRuleCondition, self).__init__(name=name, description=description, **kwargs)
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.protocols = protocols
        self.target_fqdns = target_fqdns
        self.fqdn_tags = fqdn_tags
        self.rule_condition_type = 'ApplicationRuleCondition'


class ApplicationSecurityGroup(Resource):
    """An application security group in a resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar resource_guid: The resource GUID property of the application
     security group resource. It uniquely identifies a resource, even if the
     user changes its name or migrate the resource across subscriptions or
     resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the application
     security group resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, **kwargs) -> None:
        super(ApplicationSecurityGroup, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None


class AutoApprovedPrivateLinkService(Model):
    """The information of an AutoApprovedPrivateLinkService.

    :param private_link_service: The id of the private link service resource.
    :type private_link_service: str
    """

    _attribute_map = {
        'private_link_service': {'key': 'privateLinkService', 'type': 'str'},
    }

    def __init__(self, *, private_link_service: str=None, **kwargs) -> None:
        super(AutoApprovedPrivateLinkService, self).__init__(**kwargs)
        self.private_link_service = private_link_service


class Availability(Model):
    """Availability of the metric.

    :param time_grain: The time grain of the availability.
    :type time_grain: str
    :param retention: The retention of the availability.
    :type retention: str
    :param blob_duration: Duration of the availability blob.
    :type blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, *, time_grain: str=None, retention: str=None, blob_duration: str=None, **kwargs) -> None:
        super(Availability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention
        self.blob_duration = blob_duration


class AvailableDelegation(Model):
    """The serviceName of an AvailableDelegation indicates a possible delegation
    for a subnet.

    :param name: The name of the AvailableDelegation resource.
    :type name: str
    :param id: A unique identifier of the AvailableDelegation resource.
    :type id: str
    :param type: Resource type.
    :type type: str
    :param service_name: The name of the service and resource.
    :type service_name: str
    :param actions: Describes the actions permitted to the service upon
     delegation.
    :type actions: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'actions': {'key': 'actions', 'type': '[str]'},
    }

    def __init__(self, *, name: str=None, id: str=None, type: str=None, service_name: str=None, actions=None, **kwargs) -> None:
        super(AvailableDelegation, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.service_name = service_name
        self.actions = actions


class AvailablePrivateEndpointType(Model):
    """The information of an AvailablePrivateEndpointType.

    :param name: The name of the service and resource.
    :type name: str
    :param id: A unique identifier of the AvailablePrivateEndpoint Type
     resource.
    :type id: str
    :param type: Resource type.
    :type type: str
    :param resource_name: The name of the service and resource.
    :type resource_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, id: str=None, type: str=None, resource_name: str=None, **kwargs) -> None:
        super(AvailablePrivateEndpointType, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.resource_name = resource_name


class AvailableProvidersList(Model):
    """List of available countries with details.

    All required parameters must be populated in order to send to Azure.

    :param countries: Required. List of available countries.
    :type countries:
     list[~azure.mgmt.network.v2019_09_01.models.AvailableProvidersListCountry]
    """

    _validation = {
        'countries': {'required': True},
    }

    _attribute_map = {
        'countries': {'key': 'countries', 'type': '[AvailableProvidersListCountry]'},
    }

    def __init__(self, *, countries, **kwargs) -> None:
        super(AvailableProvidersList, self).__init__(**kwargs)
        self.countries = countries


class AvailableProvidersListCity(Model):
    """City or town details.

    :param city_name: The city or town name.
    :type city_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    """

    _attribute_map = {
        'city_name': {'key': 'cityName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
    }

    def __init__(self, *, city_name: str=None, providers=None, **kwargs) -> None:
        super(AvailableProvidersListCity, self).__init__(**kwargs)
        self.city_name = city_name
        self.providers = providers


class AvailableProvidersListCountry(Model):
    """Country details.

    :param country_name: The country name.
    :type country_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    :param states: List of available states in the country.
    :type states:
     list[~azure.mgmt.network.v2019_09_01.models.AvailableProvidersListState]
    """

    _attribute_map = {
        'country_name': {'key': 'countryName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'states': {'key': 'states', 'type': '[AvailableProvidersListState]'},
    }

    def __init__(self, *, country_name: str=None, providers=None, states=None, **kwargs) -> None:
        super(AvailableProvidersListCountry, self).__init__(**kwargs)
        self.country_name = country_name
        self.providers = providers
        self.states = states


class AvailableProvidersListParameters(Model):
    """Constraints that determine the list of available Internet service
    providers.

    :param azure_locations: A list of Azure regions.
    :type azure_locations: list[str]
    :param country: The country for available providers list.
    :type country: str
    :param state: The state for available providers list.
    :type state: str
    :param city: The city or town for available providers list.
    :type city: str
    """

    _attribute_map = {
        'azure_locations': {'key': 'azureLocations', 'type': '[str]'},
        'country': {'key': 'country', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
    }

    def __init__(self, *, azure_locations=None, country: str=None, state: str=None, city: str=None, **kwargs) -> None:
        super(AvailableProvidersListParameters, self).__init__(**kwargs)
        self.azure_locations = azure_locations
        self.country = country
        self.state = state
        self.city = city


class AvailableProvidersListState(Model):
    """State details.

    :param state_name: The state name.
    :type state_name: str
    :param providers: A list of Internet service providers.
    :type providers: list[str]
    :param cities: List of available cities or towns in the state.
    :type cities:
     list[~azure.mgmt.network.v2019_09_01.models.AvailableProvidersListCity]
    """

    _attribute_map = {
        'state_name': {'key': 'stateName', 'type': 'str'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'cities': {'key': 'cities', 'type': '[AvailableProvidersListCity]'},
    }

    def __init__(self, *, state_name: str=None, providers=None, cities=None, **kwargs) -> None:
        super(AvailableProvidersListState, self).__init__(**kwargs)
        self.state_name = state_name
        self.providers = providers
        self.cities = cities


class AvailableServiceAlias(Model):
    """The available service alias.

    :param name: The name of the service alias.
    :type name: str
    :param id: The ID of the service alias.
    :type id: str
    :param type: The type of the resource.
    :type type: str
    :param resource_name: The resource name of the service alias.
    :type resource_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, id: str=None, type: str=None, resource_name: str=None, **kwargs) -> None:
        super(AvailableServiceAlias, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.resource_name = resource_name


class AzureAsyncOperationResult(Model):
    """The response body contains the status of the specified asynchronous
    operation, indicating whether it has succeeded, is in progress, or has
    failed. Note that this status is distinct from the HTTP status code
    returned for the Get Operation Status operation itself. If the asynchronous
    operation succeeded, the response body includes the HTTP status code for
    the successful request. If the asynchronous operation failed, the response
    body includes the HTTP status code for the failed request and error
    information regarding the failure.

    :param status: Status of the Azure async operation. Possible values
     include: 'InProgress', 'Succeeded', 'Failed'
    :type status: str or
     ~azure.mgmt.network.v2019_09_01.models.NetworkOperationStatus
    :param error: Details of the error occurred during specified asynchronous
     operation.
    :type error: ~azure.mgmt.network.v2019_09_01.models.Error
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(self, *, status=None, error=None, **kwargs) -> None:
        super(AzureAsyncOperationResult, self).__init__(**kwargs)
        self.status = status
        self.error = error


class AzureFirewall(Resource):
    """Azure Firewall resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param application_rule_collections: Collection of application rule
     collections used by Azure Firewall.
    :type application_rule_collections:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallApplicationRuleCollection]
    :param nat_rule_collections: Collection of NAT rule collections used by
     Azure Firewall.
    :type nat_rule_collections:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallNatRuleCollection]
    :param network_rule_collections: Collection of network rule collections
     used by Azure Firewall.
    :type network_rule_collections:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallNetworkRuleCollection]
    :param ip_configurations: IP configuration of the Azure Firewall resource.
    :type ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallIPConfiguration]
    :ivar provisioning_state: The provisioning state of the Azure firewall
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param threat_intel_mode: The operation mode for Threat Intelligence.
     Possible values include: 'Alert', 'Deny', 'Off'
    :type threat_intel_mode: str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallThreatIntelMode
    :param virtual_hub: The virtualHub to which the firewall belongs.
    :type virtual_hub: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param firewall_policy: The firewallPolicy associated with this azure
     firewall.
    :type firewall_policy: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar hub_ip_addresses: IP addresses associated with AzureFirewall.
    :vartype hub_ip_addresses:
     ~azure.mgmt.network.v2019_09_01.models.HubIPAddresses
    :param sku: The Azure Firewall Resource SKU.
    :type sku: ~azure.mgmt.network.v2019_09_01.models.AzureFirewallSku
    :param additional_properties: The additional properties used to further
     config this azure firewall
    :type additional_properties: dict[str, str]
    :param zones: A list of availability zones denoting where the resource
     needs to come from.
    :type zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'hub_ip_addresses': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'application_rule_collections': {'key': 'properties.applicationRuleCollections', 'type': '[AzureFirewallApplicationRuleCollection]'},
        'nat_rule_collections': {'key': 'properties.natRuleCollections', 'type': '[AzureFirewallNatRuleCollection]'},
        'network_rule_collections': {'key': 'properties.networkRuleCollections', 'type': '[AzureFirewallNetworkRuleCollection]'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[AzureFirewallIPConfiguration]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'threat_intel_mode': {'key': 'properties.threatIntelMode', 'type': 'str'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'SubResource'},
        'firewall_policy': {'key': 'properties.firewallPolicy', 'type': 'SubResource'},
        'hub_ip_addresses': {'key': 'properties.hubIpAddresses', 'type': 'HubIPAddresses'},
        'sku': {'key': 'properties.sku', 'type': 'AzureFirewallSku'},
        'additional_properties': {'key': 'properties.additionalProperties', 'type': '{str}'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, application_rule_collections=None, nat_rule_collections=None, network_rule_collections=None, ip_configurations=None, threat_intel_mode=None, virtual_hub=None, firewall_policy=None, sku=None, additional_properties=None, zones=None, **kwargs) -> None:
        super(AzureFirewall, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.application_rule_collections = application_rule_collections
        self.nat_rule_collections = nat_rule_collections
        self.network_rule_collections = network_rule_collections
        self.ip_configurations = ip_configurations
        self.provisioning_state = None
        self.threat_intel_mode = threat_intel_mode
        self.virtual_hub = virtual_hub
        self.firewall_policy = firewall_policy
        self.hub_ip_addresses = None
        self.sku = sku
        self.additional_properties = additional_properties
        self.zones = zones
        self.etag = None


class AzureFirewallApplicationRule(Model):
    """Properties of an application rule.

    :param name: Name of the application rule.
    :type name: str
    :param description: Description of the rule.
    :type description: str
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param protocols: Array of ApplicationRuleProtocols.
    :type protocols:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallApplicationRuleProtocol]
    :param target_fqdns: List of FQDNs for this rule.
    :type target_fqdns: list[str]
    :param fqdn_tags: List of FQDN Tags for this rule.
    :type fqdn_tags: list[str]
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'protocols': {'key': 'protocols', 'type': '[AzureFirewallApplicationRuleProtocol]'},
        'target_fqdns': {'key': 'targetFqdns', 'type': '[str]'},
        'fqdn_tags': {'key': 'fqdnTags', 'type': '[str]'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
    }

    def __init__(self, *, name: str=None, description: str=None, source_addresses=None, protocols=None, target_fqdns=None, fqdn_tags=None, source_ip_groups=None, **kwargs) -> None:
        super(AzureFirewallApplicationRule, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.source_addresses = source_addresses
        self.protocols = protocols
        self.target_fqdns = target_fqdns
        self.fqdn_tags = fqdn_tags
        self.source_ip_groups = source_ip_groups


class AzureFirewallApplicationRuleCollection(SubResource):
    """Application rule collection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param priority: Priority of the application rule collection resource.
    :type priority: int
    :param action: The action type of a rule collection.
    :type action: ~azure.mgmt.network.v2019_09_01.models.AzureFirewallRCAction
    :param rules: Collection of rules used by a application rule collection.
    :type rules:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallApplicationRule]
    :ivar provisioning_state: The provisioning state of the application rule
     collection resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the Azure
     firewall. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'priority': {'maximum': 65000, 'minimum': 100},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'action': {'key': 'properties.action', 'type': 'AzureFirewallRCAction'},
        'rules': {'key': 'properties.rules', 'type': '[AzureFirewallApplicationRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, priority: int=None, action=None, rules=None, name: str=None, **kwargs) -> None:
        super(AzureFirewallApplicationRuleCollection, self).__init__(id=id, **kwargs)
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None
        self.name = name
        self.etag = None


class AzureFirewallApplicationRuleProtocol(Model):
    """Properties of the application rule protocol.

    :param protocol_type: Protocol type. Possible values include: 'Http',
     'Https', 'Mssql'
    :type protocol_type: str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallApplicationRuleProtocolType
    :param port: Port number for the protocol, cannot be greater than 64000.
     This field is optional.
    :type port: int
    """

    _validation = {
        'port': {'maximum': 64000, 'minimum': 0},
    }

    _attribute_map = {
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, *, protocol_type=None, port: int=None, **kwargs) -> None:
        super(AzureFirewallApplicationRuleProtocol, self).__init__(**kwargs)
        self.protocol_type = protocol_type
        self.port = port


class AzureFirewallFqdnTag(Resource):
    """Azure Firewall FQDN Tag Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the Azure firewall
     FQDN tag resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar fqdn_tag_name: The name of this FQDN Tag.
    :vartype fqdn_tag_name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'fqdn_tag_name': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'fqdn_tag_name': {'key': 'properties.fqdnTagName', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, **kwargs) -> None:
        super(AzureFirewallFqdnTag, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.fqdn_tag_name = None
        self.etag = None


class AzureFirewallIPConfiguration(SubResource):
    """IP configuration of an Azure Firewall.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar private_ip_address: The Firewall Internal Load Balancer IP to be
     used as the next hop in User Defined Routes.
    :vartype private_ip_address: str
    :param subnet: Reference of the subnet resource. This resource must be
     named 'AzureFirewallSubnet'.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param public_ip_address: Reference of the PublicIP resource. This field
     is a mandatory input if subnet is not null.
    :type public_ip_address:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the Azure firewall IP
     configuration resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'private_ip_address': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, subnet=None, public_ip_address=None, name: str=None, **kwargs) -> None:
        super(AzureFirewallIPConfiguration, self).__init__(id=id, **kwargs)
        self.private_ip_address = None
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None
        self.name = name
        self.etag = None


class AzureFirewallNatRCAction(Model):
    """AzureFirewall NAT Rule Collection Action.

    :param type: The type of action. Possible values include: 'Snat', 'Dnat'
    :type type: str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallNatRCActionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(AzureFirewallNatRCAction, self).__init__(**kwargs)
        self.type = type


class AzureFirewallNatRule(Model):
    """Properties of a NAT rule.

    :param name: Name of the NAT rule.
    :type name: str
    :param description: Description of the rule.
    :type description: str
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses for this
     rule. Supports IP ranges, prefixes, and service tags.
    :type destination_addresses: list[str]
    :param destination_ports: List of destination ports.
    :type destination_ports: list[str]
    :param protocols: Array of AzureFirewallNetworkRuleProtocols applicable to
     this NAT rule.
    :type protocols: list[str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallNetworkRuleProtocol]
    :param translated_address: The translated address for this NAT rule.
    :type translated_address: str
    :param translated_port: The translated port for this NAT rule.
    :type translated_port: str
    :param translated_fqdn: The translated FQDN for this NAT rule.
    :type translated_fqdn: str
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'destination_ports': {'key': 'destinationPorts', 'type': '[str]'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'translated_address': {'key': 'translatedAddress', 'type': 'str'},
        'translated_port': {'key': 'translatedPort', 'type': 'str'},
        'translated_fqdn': {'key': 'translatedFqdn', 'type': 'str'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
    }

    def __init__(self, *, name: str=None, description: str=None, source_addresses=None, destination_addresses=None, destination_ports=None, protocols=None, translated_address: str=None, translated_port: str=None, translated_fqdn: str=None, source_ip_groups=None, **kwargs) -> None:
        super(AzureFirewallNatRule, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.protocols = protocols
        self.translated_address = translated_address
        self.translated_port = translated_port
        self.translated_fqdn = translated_fqdn
        self.source_ip_groups = source_ip_groups


class AzureFirewallNatRuleCollection(SubResource):
    """NAT rule collection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param priority: Priority of the NAT rule collection resource.
    :type priority: int
    :param action: The action type of a NAT rule collection.
    :type action:
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallNatRCAction
    :param rules: Collection of rules used by a NAT rule collection.
    :type rules:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallNatRule]
    :ivar provisioning_state: The provisioning state of the NAT rule
     collection resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the Azure
     firewall. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'priority': {'maximum': 65000, 'minimum': 100},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'action': {'key': 'properties.action', 'type': 'AzureFirewallNatRCAction'},
        'rules': {'key': 'properties.rules', 'type': '[AzureFirewallNatRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, priority: int=None, action=None, rules=None, name: str=None, **kwargs) -> None:
        super(AzureFirewallNatRuleCollection, self).__init__(id=id, **kwargs)
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None
        self.name = name
        self.etag = None


class AzureFirewallNetworkRule(Model):
    """Properties of the network rule.

    :param name: Name of the network rule.
    :type name: str
    :param description: Description of the rule.
    :type description: str
    :param protocols: Array of AzureFirewallNetworkRuleProtocols.
    :type protocols: list[str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallNetworkRuleProtocol]
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses.
    :type destination_addresses: list[str]
    :param destination_ports: List of destination ports.
    :type destination_ports: list[str]
    :param destination_fqdns: List of destination FQDNs.
    :type destination_fqdns: list[str]
    :param source_ip_groups: List of source IpGroups for this rule.
    :type source_ip_groups: list[str]
    :param destination_ip_groups: List of destination IpGroups for this rule.
    :type destination_ip_groups: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'destination_ports': {'key': 'destinationPorts', 'type': '[str]'},
        'destination_fqdns': {'key': 'destinationFqdns', 'type': '[str]'},
        'source_ip_groups': {'key': 'sourceIpGroups', 'type': '[str]'},
        'destination_ip_groups': {'key': 'destinationIpGroups', 'type': '[str]'},
    }

    def __init__(self, *, name: str=None, description: str=None, protocols=None, source_addresses=None, destination_addresses=None, destination_ports=None, destination_fqdns=None, source_ip_groups=None, destination_ip_groups=None, **kwargs) -> None:
        super(AzureFirewallNetworkRule, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.protocols = protocols
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.destination_fqdns = destination_fqdns
        self.source_ip_groups = source_ip_groups
        self.destination_ip_groups = destination_ip_groups


class AzureFirewallNetworkRuleCollection(SubResource):
    """Network rule collection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param priority: Priority of the network rule collection resource.
    :type priority: int
    :param action: The action type of a rule collection.
    :type action: ~azure.mgmt.network.v2019_09_01.models.AzureFirewallRCAction
    :param rules: Collection of rules used by a network rule collection.
    :type rules:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallNetworkRule]
    :ivar provisioning_state: The provisioning state of the network rule
     collection resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the Azure
     firewall. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'priority': {'maximum': 65000, 'minimum': 100},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'action': {'key': 'properties.action', 'type': 'AzureFirewallRCAction'},
        'rules': {'key': 'properties.rules', 'type': '[AzureFirewallNetworkRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, priority: int=None, action=None, rules=None, name: str=None, **kwargs) -> None:
        super(AzureFirewallNetworkRuleCollection, self).__init__(id=id, **kwargs)
        self.priority = priority
        self.action = action
        self.rules = rules
        self.provisioning_state = None
        self.name = name
        self.etag = None


class AzureFirewallPublicIPAddress(Model):
    """Public IP Address associated with azure firewall.

    :param address: Public IP Address value.
    :type address: str
    """

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
    }

    def __init__(self, *, address: str=None, **kwargs) -> None:
        super(AzureFirewallPublicIPAddress, self).__init__(**kwargs)
        self.address = address


class AzureFirewallRCAction(Model):
    """Properties of the AzureFirewallRCAction.

    :param type: The type of action. Possible values include: 'Allow', 'Deny'
    :type type: str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallRCActionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(AzureFirewallRCAction, self).__init__(**kwargs)
        self.type = type


class AzureFirewallSku(Model):
    """SKU of an Azure Firewall.

    :param name: Name of an Azure Firewall SKU. Possible values include:
     'AZFW_VNet', 'AZFW_Hub'
    :type name: str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallSkuName
    :param tier: Tier of an Azure Firewall. Possible values include:
     'Standard'
    :type tier: str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallSkuTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, *, name=None, tier=None, **kwargs) -> None:
        super(AzureFirewallSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class AzureReachabilityReport(Model):
    """Azure reachability report details.

    All required parameters must be populated in order to send to Azure.

    :param aggregation_level: Required. The aggregation level of Azure
     reachability report. Can be Country, State or City.
    :type aggregation_level: str
    :param provider_location: Required. Parameters that define a geographic
     location.
    :type provider_location:
     ~azure.mgmt.network.v2019_09_01.models.AzureReachabilityReportLocation
    :param reachability_report: Required. List of Azure reachability report
     items.
    :type reachability_report:
     list[~azure.mgmt.network.v2019_09_01.models.AzureReachabilityReportItem]
    """

    _validation = {
        'aggregation_level': {'required': True},
        'provider_location': {'required': True},
        'reachability_report': {'required': True},
    }

    _attribute_map = {
        'aggregation_level': {'key': 'aggregationLevel', 'type': 'str'},
        'provider_location': {'key': 'providerLocation', 'type': 'AzureReachabilityReportLocation'},
        'reachability_report': {'key': 'reachabilityReport', 'type': '[AzureReachabilityReportItem]'},
    }

    def __init__(self, *, aggregation_level: str, provider_location, reachability_report, **kwargs) -> None:
        super(AzureReachabilityReport, self).__init__(**kwargs)
        self.aggregation_level = aggregation_level
        self.provider_location = provider_location
        self.reachability_report = reachability_report


class AzureReachabilityReportItem(Model):
    """Azure reachability report details for a given provider location.

    :param provider: The Internet service provider.
    :type provider: str
    :param azure_location: The Azure region.
    :type azure_location: str
    :param latencies: List of latency details for each of the time series.
    :type latencies:
     list[~azure.mgmt.network.v2019_09_01.models.AzureReachabilityReportLatencyInfo]
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'azure_location': {'key': 'azureLocation', 'type': 'str'},
        'latencies': {'key': 'latencies', 'type': '[AzureReachabilityReportLatencyInfo]'},
    }

    def __init__(self, *, provider: str=None, azure_location: str=None, latencies=None, **kwargs) -> None:
        super(AzureReachabilityReportItem, self).__init__(**kwargs)
        self.provider = provider
        self.azure_location = azure_location
        self.latencies = latencies


class AzureReachabilityReportLatencyInfo(Model):
    """Details on latency for a time series.

    :param time_stamp: The time stamp.
    :type time_stamp: datetime
    :param score: The relative latency score between 1 and 100, higher values
     indicating a faster connection.
    :type score: int
    """

    _validation = {
        'score': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'score': {'key': 'score', 'type': 'int'},
    }

    def __init__(self, *, time_stamp=None, score: int=None, **kwargs) -> None:
        super(AzureReachabilityReportLatencyInfo, self).__init__(**kwargs)
        self.time_stamp = time_stamp
        self.score = score


class AzureReachabilityReportLocation(Model):
    """Parameters that define a geographic location.

    All required parameters must be populated in order to send to Azure.

    :param country: Required. The name of the country.
    :type country: str
    :param state: The name of the state.
    :type state: str
    :param city: The name of the city or town.
    :type city: str
    """

    _validation = {
        'country': {'required': True},
    }

    _attribute_map = {
        'country': {'key': 'country', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
    }

    def __init__(self, *, country: str, state: str=None, city: str=None, **kwargs) -> None:
        super(AzureReachabilityReportLocation, self).__init__(**kwargs)
        self.country = country
        self.state = state
        self.city = city


class AzureReachabilityReportParameters(Model):
    """Geographic and time constraints for Azure reachability report.

    All required parameters must be populated in order to send to Azure.

    :param provider_location: Required. Parameters that define a geographic
     location.
    :type provider_location:
     ~azure.mgmt.network.v2019_09_01.models.AzureReachabilityReportLocation
    :param providers: List of Internet service providers.
    :type providers: list[str]
    :param azure_locations: Optional Azure regions to scope the query to.
    :type azure_locations: list[str]
    :param start_time: Required. The start time for the Azure reachability
     report.
    :type start_time: datetime
    :param end_time: Required. The end time for the Azure reachability report.
    :type end_time: datetime
    """

    _validation = {
        'provider_location': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'provider_location': {'key': 'providerLocation', 'type': 'AzureReachabilityReportLocation'},
        'providers': {'key': 'providers', 'type': '[str]'},
        'azure_locations': {'key': 'azureLocations', 'type': '[str]'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, provider_location, start_time, end_time, providers=None, azure_locations=None, **kwargs) -> None:
        super(AzureReachabilityReportParameters, self).__init__(**kwargs)
        self.provider_location = provider_location
        self.providers = providers
        self.azure_locations = azure_locations
        self.start_time = start_time
        self.end_time = end_time


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar backend_ip_configurations: An array of references to IP addresses
     defined in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: An array of references to load balancing rules
     that use this backend address pool.
    :vartype load_balancing_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar outbound_rule: A reference to an outbound rule that uses this
     backend address pool.
    :vartype outbound_rule: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar outbound_rules: An array of references to outbound rules that use
     this backend address pool.
    :vartype outbound_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the backend address
     pool resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the set of
     backend address pools used by the load balancer. This name can be used to
     access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'backend_ip_configurations': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
        'outbound_rule': {'readonly': True},
        'outbound_rules': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'outbound_rule': {'key': 'properties.outboundRule', 'type': 'SubResource'},
        'outbound_rules': {'key': 'properties.outboundRules', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, name: str=None, **kwargs) -> None:
        super(BackendAddressPool, self).__init__(id=id, **kwargs)
        self.backend_ip_configurations = None
        self.load_balancing_rules = None
        self.outbound_rule = None
        self.outbound_rules = None
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class BastionHost(Resource):
    """Bastion Host resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param ip_configurations: IP configuration of the Bastion Host resource.
    :type ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.BastionHostIPConfiguration]
    :param dns_name: FQDN for the endpoint on which bastion host is
     accessible.
    :type dns_name: str
    :ivar provisioning_state: The provisioning state of the bastion host
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[BastionHostIPConfiguration]'},
        'dns_name': {'key': 'properties.dnsName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, ip_configurations=None, dns_name: str=None, **kwargs) -> None:
        super(BastionHost, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.ip_configurations = ip_configurations
        self.dns_name = dns_name
        self.provisioning_state = None
        self.etag = None


class BastionHostIPConfiguration(SubResource):
    """IP configuration of an Bastion Host.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param subnet: Required. Reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param public_ip_address: Required. Reference of the PublicIP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the bastion host IP
     configuration resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param private_ip_allocation_method: Private IP allocation method.
     Possible values include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_09_01.models.IPAllocationMethod
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Ip configuration type.
    :vartype type: str
    """

    _validation = {
        'subnet': {'required': True},
        'public_ip_address': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, subnet, public_ip_address, id: str=None, private_ip_allocation_method=None, name: str=None, **kwargs) -> None:
        super(BastionHostIPConfiguration, self).__init__(id=id, **kwargs)
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None
        self.private_ip_allocation_method = private_ip_allocation_method
        self.name = name
        self.etag = None
        self.type = None


class BGPCommunity(Model):
    """Contains bgp community information offered in Service Community resources.

    :param service_supported_region: The region which the service support.
     e.g. For O365, region is Global.
    :type service_supported_region: str
    :param community_name: The name of the bgp community. e.g. Skype.
    :type community_name: str
    :param community_value: The value of the bgp community. For more
     information:
     https://docs.microsoft.com/en-us/azure/expressroute/expressroute-routing.
    :type community_value: str
    :param community_prefixes: The prefixes that the bgp community contains.
    :type community_prefixes: list[str]
    :param is_authorized_to_use: Customer is authorized to use bgp community
     or not.
    :type is_authorized_to_use: bool
    :param service_group: The service group of the bgp community contains.
    :type service_group: str
    """

    _attribute_map = {
        'service_supported_region': {'key': 'serviceSupportedRegion', 'type': 'str'},
        'community_name': {'key': 'communityName', 'type': 'str'},
        'community_value': {'key': 'communityValue', 'type': 'str'},
        'community_prefixes': {'key': 'communityPrefixes', 'type': '[str]'},
        'is_authorized_to_use': {'key': 'isAuthorizedToUse', 'type': 'bool'},
        'service_group': {'key': 'serviceGroup', 'type': 'str'},
    }

    def __init__(self, *, service_supported_region: str=None, community_name: str=None, community_value: str=None, community_prefixes=None, is_authorized_to_use: bool=None, service_group: str=None, **kwargs) -> None:
        super(BGPCommunity, self).__init__(**kwargs)
        self.service_supported_region = service_supported_region
        self.community_name = community_name
        self.community_value = community_value
        self.community_prefixes = community_prefixes
        self.is_authorized_to_use = is_authorized_to_use
        self.service_group = service_group


class BgpPeerStatus(Model):
    """BGP peer status details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar local_address: The virtual network gateway's local address.
    :vartype local_address: str
    :ivar neighbor: The remote BGP peer.
    :vartype neighbor: str
    :ivar asn: The autonomous system number of the remote BGP peer.
    :vartype asn: int
    :ivar state: The BGP peer state. Possible values include: 'Unknown',
     'Stopped', 'Idle', 'Connecting', 'Connected'
    :vartype state: str or ~azure.mgmt.network.v2019_09_01.models.BgpPeerState
    :ivar connected_duration: For how long the peering has been up.
    :vartype connected_duration: str
    :ivar routes_received: The number of routes learned from this peer.
    :vartype routes_received: long
    :ivar messages_sent: The number of BGP messages sent.
    :vartype messages_sent: long
    :ivar messages_received: The number of BGP messages received.
    :vartype messages_received: long
    """

    _validation = {
        'local_address': {'readonly': True},
        'neighbor': {'readonly': True},
        'asn': {'readonly': True},
        'state': {'readonly': True},
        'connected_duration': {'readonly': True},
        'routes_received': {'readonly': True},
        'messages_sent': {'readonly': True},
        'messages_received': {'readonly': True},
    }

    _attribute_map = {
        'local_address': {'key': 'localAddress', 'type': 'str'},
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'asn': {'key': 'asn', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'connected_duration': {'key': 'connectedDuration', 'type': 'str'},
        'routes_received': {'key': 'routesReceived', 'type': 'long'},
        'messages_sent': {'key': 'messagesSent', 'type': 'long'},
        'messages_received': {'key': 'messagesReceived', 'type': 'long'},
    }

    def __init__(self, **kwargs) -> None:
        super(BgpPeerStatus, self).__init__(**kwargs)
        self.local_address = None
        self.neighbor = None
        self.asn = None
        self.state = None
        self.connected_duration = None
        self.routes_received = None
        self.messages_sent = None
        self.messages_received = None


class BgpPeerStatusListResult(Model):
    """Response for list BGP peer status API service call.

    :param value: List of BGP peers.
    :type value: list[~azure.mgmt.network.v2019_09_01.models.BgpPeerStatus]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BgpPeerStatus]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(BgpPeerStatusListResult, self).__init__(**kwargs)
        self.value = value


class BgpServiceCommunity(Resource):
    """Service Community Properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param service_name: The name of the bgp community. e.g. Skype.
    :type service_name: str
    :param bgp_communities: A list of bgp communities.
    :type bgp_communities:
     list[~azure.mgmt.network.v2019_09_01.models.BGPCommunity]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_name': {'key': 'properties.serviceName', 'type': 'str'},
        'bgp_communities': {'key': 'properties.bgpCommunities', 'type': '[BGPCommunity]'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, service_name: str=None, bgp_communities=None, **kwargs) -> None:
        super(BgpServiceCommunity, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.service_name = service_name
        self.bgp_communities = bgp_communities


class BgpSettings(Model):
    """BGP settings details.

    :param asn: The BGP speaker's ASN.
    :type asn: long
    :param bgp_peering_address: The BGP peering address and BGP identifier of
     this BGP speaker.
    :type bgp_peering_address: str
    :param peer_weight: The weight added to routes learned from this BGP
     speaker.
    :type peer_weight: int
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'long'},
        'bgp_peering_address': {'key': 'bgpPeeringAddress', 'type': 'str'},
        'peer_weight': {'key': 'peerWeight', 'type': 'int'},
    }

    def __init__(self, *, asn: int=None, bgp_peering_address: str=None, peer_weight: int=None, **kwargs) -> None:
        super(BgpSettings, self).__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address
        self.peer_weight = peer_weight


class CheckPrivateLinkServiceVisibilityRequest(Model):
    """Request body of the CheckPrivateLinkServiceVisibility API service call.

    :param private_link_service_alias: The alias of the private link service.
    :type private_link_service_alias: str
    """

    _attribute_map = {
        'private_link_service_alias': {'key': 'privateLinkServiceAlias', 'type': 'str'},
    }

    def __init__(self, *, private_link_service_alias: str=None, **kwargs) -> None:
        super(CheckPrivateLinkServiceVisibilityRequest, self).__init__(**kwargs)
        self.private_link_service_alias = private_link_service_alias


class CloudError(Model):
    """An error response from the service.

    :param error: Cloud error body.
    :type error: ~azure.mgmt.network.v2019_09_01.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.network.v2019_09_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, details=None, **kwargs) -> None:
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ConnectionMonitor(Model):
    """Parameters that define the operation to create a connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param location: Connection monitor location.
    :type location: str
    :param tags: Connection monitor tags.
    :type tags: dict[str, str]
    :param source: Required. Describes the source of connection monitor.
    :type source:
     ~azure.mgmt.network.v2019_09_01.models.ConnectionMonitorSource
    :param destination: Required. Describes the destination of connection
     monitor.
    :type destination:
     ~azure.mgmt.network.v2019_09_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start
     automatically once created. Default value: True .
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
     Default value: 60 .
    :type monitoring_interval_in_seconds: int
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'properties.destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'properties.autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'properties.monitoringIntervalInSeconds', 'type': 'int'},
    }

    def __init__(self, *, source, destination, location: str=None, tags=None, auto_start: bool=True, monitoring_interval_in_seconds: int=60, **kwargs) -> None:
        super(ConnectionMonitor, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds


class ConnectionMonitorDestination(Model):
    """Describes the destination of connection monitor.

    :param resource_id: The ID of the resource used as the destination by
     connection monitor.
    :type resource_id: str
    :param address: Address of the connection monitor destination (IP or
     domain name).
    :type address: str
    :param port: The destination port used by connection monitor.
    :type port: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, *, resource_id: str=None, address: str=None, port: int=None, **kwargs) -> None:
        super(ConnectionMonitorDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectionMonitorParameters(Model):
    """Parameters that define the operation to create a connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Describes the source of connection monitor.
    :type source:
     ~azure.mgmt.network.v2019_09_01.models.ConnectionMonitorSource
    :param destination: Required. Describes the destination of connection
     monitor.
    :type destination:
     ~azure.mgmt.network.v2019_09_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start
     automatically once created. Default value: True .
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
     Default value: 60 .
    :type monitoring_interval_in_seconds: int
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'monitoringIntervalInSeconds', 'type': 'int'},
    }

    def __init__(self, *, source, destination, auto_start: bool=True, monitoring_interval_in_seconds: int=60, **kwargs) -> None:
        super(ConnectionMonitorParameters, self).__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds


class ConnectionMonitorQueryResult(Model):
    """List of connection states snapshots.

    :param source_status: Status of connection monitor source. Possible values
     include: 'Unknown', 'Active', 'Inactive'
    :type source_status: str or
     ~azure.mgmt.network.v2019_09_01.models.ConnectionMonitorSourceStatus
    :param states: Information about connection states.
    :type states:
     list[~azure.mgmt.network.v2019_09_01.models.ConnectionStateSnapshot]
    """

    _attribute_map = {
        'source_status': {'key': 'sourceStatus', 'type': 'str'},
        'states': {'key': 'states', 'type': '[ConnectionStateSnapshot]'},
    }

    def __init__(self, *, source_status=None, states=None, **kwargs) -> None:
        super(ConnectionMonitorQueryResult, self).__init__(**kwargs)
        self.source_status = source_status
        self.states = states


class ConnectionMonitorResult(Model):
    """Information about the connection monitor.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the connection monitor.
    :vartype name: str
    :ivar id: ID of the connection monitor.
    :vartype id: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated. Default value: "A unique read-only string that changes
     whenever the resource is updated." .
    :type etag: str
    :ivar type: Connection monitor type.
    :vartype type: str
    :param location: Connection monitor location.
    :type location: str
    :param tags: Connection monitor tags.
    :type tags: dict[str, str]
    :param source: Required. Describes the source of connection monitor.
    :type source:
     ~azure.mgmt.network.v2019_09_01.models.ConnectionMonitorSource
    :param destination: Required. Describes the destination of connection
     monitor.
    :type destination:
     ~azure.mgmt.network.v2019_09_01.models.ConnectionMonitorDestination
    :param auto_start: Determines if the connection monitor will start
     automatically once created. Default value: True .
    :type auto_start: bool
    :param monitoring_interval_in_seconds: Monitoring interval in seconds.
     Default value: 60 .
    :type monitoring_interval_in_seconds: int
    :param provisioning_state: The provisioning state of the connection
     monitor. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param start_time: The date and time when the connection monitor was
     started.
    :type start_time: datetime
    :param monitoring_status: The monitoring status of the connection monitor.
    :type monitoring_status: str
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'ConnectionMonitorSource'},
        'destination': {'key': 'properties.destination', 'type': 'ConnectionMonitorDestination'},
        'auto_start': {'key': 'properties.autoStart', 'type': 'bool'},
        'monitoring_interval_in_seconds': {'key': 'properties.monitoringIntervalInSeconds', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'monitoring_status': {'key': 'properties.monitoringStatus', 'type': 'str'},
    }

    def __init__(self, *, source, destination, etag: str="A unique read-only string that changes whenever the resource is updated.", location: str=None, tags=None, auto_start: bool=True, monitoring_interval_in_seconds: int=60, provisioning_state=None, start_time=None, monitoring_status: str=None, **kwargs) -> None:
        super(ConnectionMonitorResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = etag
        self.type = None
        self.location = location
        self.tags = tags
        self.source = source
        self.destination = destination
        self.auto_start = auto_start
        self.monitoring_interval_in_seconds = monitoring_interval_in_seconds
        self.provisioning_state = provisioning_state
        self.start_time = start_time
        self.monitoring_status = monitoring_status


class ConnectionMonitorSource(Model):
    """Describes the source of connection monitor.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The ID of the resource used as the source by
     connection monitor.
    :type resource_id: str
    :param port: The source port used by connection monitor.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, *, resource_id: str, port: int=None, **kwargs) -> None:
        super(ConnectionMonitorSource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class ConnectionResetSharedKey(Model):
    """The virtual network connection reset shared key.

    All required parameters must be populated in order to send to Azure.

    :param key_length: Required. The virtual network connection reset shared
     key length, should between 1 and 128.
    :type key_length: int
    """

    _validation = {
        'key_length': {'required': True, 'maximum': 128, 'minimum': 1},
    }

    _attribute_map = {
        'key_length': {'key': 'keyLength', 'type': 'int'},
    }

    def __init__(self, *, key_length: int, **kwargs) -> None:
        super(ConnectionResetSharedKey, self).__init__(**kwargs)
        self.key_length = key_length


class ConnectionSharedKey(SubResource):
    """Response for GetConnectionSharedKey API service call.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param value: Required. The virtual network connection shared key value.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, value: str, id: str=None, **kwargs) -> None:
        super(ConnectionSharedKey, self).__init__(id=id, **kwargs)
        self.value = value


class ConnectionStateSnapshot(Model):
    """Connection state snapshot.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param connection_state: The connection state. Possible values include:
     'Reachable', 'Unreachable', 'Unknown'
    :type connection_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ConnectionState
    :param start_time: The start time of the connection snapshot.
    :type start_time: datetime
    :param end_time: The end time of the connection snapshot.
    :type end_time: datetime
    :param evaluation_state: Connectivity analysis evaluation state. Possible
     values include: 'NotStarted', 'InProgress', 'Completed'
    :type evaluation_state: str or
     ~azure.mgmt.network.v2019_09_01.models.EvaluationState
    :param avg_latency_in_ms: Average latency in ms.
    :type avg_latency_in_ms: int
    :param min_latency_in_ms: Minimum latency in ms.
    :type min_latency_in_ms: int
    :param max_latency_in_ms: Maximum latency in ms.
    :type max_latency_in_ms: int
    :param probes_sent: The number of sent probes.
    :type probes_sent: int
    :param probes_failed: The number of failed probes.
    :type probes_failed: int
    :ivar hops: List of hops between the source and the destination.
    :vartype hops:
     list[~azure.mgmt.network.v2019_09_01.models.ConnectivityHop]
    """

    _validation = {
        'hops': {'readonly': True},
    }

    _attribute_map = {
        'connection_state': {'key': 'connectionState', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'evaluation_state': {'key': 'evaluationState', 'type': 'str'},
        'avg_latency_in_ms': {'key': 'avgLatencyInMs', 'type': 'int'},
        'min_latency_in_ms': {'key': 'minLatencyInMs', 'type': 'int'},
        'max_latency_in_ms': {'key': 'maxLatencyInMs', 'type': 'int'},
        'probes_sent': {'key': 'probesSent', 'type': 'int'},
        'probes_failed': {'key': 'probesFailed', 'type': 'int'},
        'hops': {'key': 'hops', 'type': '[ConnectivityHop]'},
    }

    def __init__(self, *, connection_state=None, start_time=None, end_time=None, evaluation_state=None, avg_latency_in_ms: int=None, min_latency_in_ms: int=None, max_latency_in_ms: int=None, probes_sent: int=None, probes_failed: int=None, **kwargs) -> None:
        super(ConnectionStateSnapshot, self).__init__(**kwargs)
        self.connection_state = connection_state
        self.start_time = start_time
        self.end_time = end_time
        self.evaluation_state = evaluation_state
        self.avg_latency_in_ms = avg_latency_in_ms
        self.min_latency_in_ms = min_latency_in_ms
        self.max_latency_in_ms = max_latency_in_ms
        self.probes_sent = probes_sent
        self.probes_failed = probes_failed
        self.hops = None


class ConnectivityDestination(Model):
    """Parameters that define destination of connection.

    :param resource_id: The ID of the resource to which a connection attempt
     will be made.
    :type resource_id: str
    :param address: The IP address or URI the resource to which a connection
     attempt will be made.
    :type address: str
    :param port: Port on which check connectivity will be performed.
    :type port: int
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, *, resource_id: str=None, address: str=None, port: int=None, **kwargs) -> None:
        super(ConnectivityDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address
        self.port = port


class ConnectivityHop(Model):
    """Information about a hop between the source and the destination.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The type of the hop.
    :vartype type: str
    :ivar id: The ID of the hop.
    :vartype id: str
    :ivar address: The IP address of the hop.
    :vartype address: str
    :ivar resource_id: The ID of the resource corresponding to this hop.
    :vartype resource_id: str
    :ivar next_hop_ids: List of next hop identifiers.
    :vartype next_hop_ids: list[str]
    :ivar issues: List of issues.
    :vartype issues:
     list[~azure.mgmt.network.v2019_09_01.models.ConnectivityIssue]
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'address': {'readonly': True},
        'resource_id': {'readonly': True},
        'next_hop_ids': {'readonly': True},
        'issues': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'next_hop_ids': {'key': 'nextHopIds', 'type': '[str]'},
        'issues': {'key': 'issues', 'type': '[ConnectivityIssue]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ConnectivityHop, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.address = None
        self.resource_id = None
        self.next_hop_ids = None
        self.issues = None


class ConnectivityInformation(Model):
    """Information on the connectivity status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar hops: List of hops between the source and the destination.
    :vartype hops:
     list[~azure.mgmt.network.v2019_09_01.models.ConnectivityHop]
    :ivar connection_status: The connection status. Possible values include:
     'Unknown', 'Connected', 'Disconnected', 'Degraded'
    :vartype connection_status: str or
     ~azure.mgmt.network.v2019_09_01.models.ConnectionStatus
    :ivar avg_latency_in_ms: Average latency in milliseconds.
    :vartype avg_latency_in_ms: int
    :ivar min_latency_in_ms: Minimum latency in milliseconds.
    :vartype min_latency_in_ms: int
    :ivar max_latency_in_ms: Maximum latency in milliseconds.
    :vartype max_latency_in_ms: int
    :ivar probes_sent: Total number of probes sent.
    :vartype probes_sent: int
    :ivar probes_failed: Number of failed probes.
    :vartype probes_failed: int
    """

    _validation = {
        'hops': {'readonly': True},
        'connection_status': {'readonly': True},
        'avg_latency_in_ms': {'readonly': True},
        'min_latency_in_ms': {'readonly': True},
        'max_latency_in_ms': {'readonly': True},
        'probes_sent': {'readonly': True},
        'probes_failed': {'readonly': True},
    }

    _attribute_map = {
        'hops': {'key': 'hops', 'type': '[ConnectivityHop]'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'avg_latency_in_ms': {'key': 'avgLatencyInMs', 'type': 'int'},
        'min_latency_in_ms': {'key': 'minLatencyInMs', 'type': 'int'},
        'max_latency_in_ms': {'key': 'maxLatencyInMs', 'type': 'int'},
        'probes_sent': {'key': 'probesSent', 'type': 'int'},
        'probes_failed': {'key': 'probesFailed', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(ConnectivityInformation, self).__init__(**kwargs)
        self.hops = None
        self.connection_status = None
        self.avg_latency_in_ms = None
        self.min_latency_in_ms = None
        self.max_latency_in_ms = None
        self.probes_sent = None
        self.probes_failed = None


class ConnectivityIssue(Model):
    """Information about an issue encountered in the process of checking for
    connectivity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar origin: The origin of the issue. Possible values include: 'Local',
     'Inbound', 'Outbound'
    :vartype origin: str or ~azure.mgmt.network.v2019_09_01.models.Origin
    :ivar severity: The severity of the issue. Possible values include:
     'Error', 'Warning'
    :vartype severity: str or ~azure.mgmt.network.v2019_09_01.models.Severity
    :ivar type: The type of issue. Possible values include: 'Unknown',
     'AgentStopped', 'GuestFirewall', 'DnsResolution', 'SocketBind',
     'NetworkSecurityRule', 'UserDefinedRoute', 'PortThrottled', 'Platform'
    :vartype type: str or ~azure.mgmt.network.v2019_09_01.models.IssueType
    :ivar context: Provides additional context on the issue.
    :vartype context: list[dict[str, str]]
    """

    _validation = {
        'origin': {'readonly': True},
        'severity': {'readonly': True},
        'type': {'readonly': True},
        'context': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'context': {'key': 'context', 'type': '[{str}]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ConnectivityIssue, self).__init__(**kwargs)
        self.origin = None
        self.severity = None
        self.type = None
        self.context = None


class ConnectivityParameters(Model):
    """Parameters that determine how the connectivity check will be performed.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Describes the source of the connection.
    :type source: ~azure.mgmt.network.v2019_09_01.models.ConnectivitySource
    :param destination: Required. Describes the destination of connection.
    :type destination:
     ~azure.mgmt.network.v2019_09_01.models.ConnectivityDestination
    :param protocol: Network protocol. Possible values include: 'Tcp', 'Http',
     'Https', 'Icmp'
    :type protocol: str or ~azure.mgmt.network.v2019_09_01.models.Protocol
    :param protocol_configuration: Configuration of the protocol.
    :type protocol_configuration:
     ~azure.mgmt.network.v2019_09_01.models.ProtocolConfiguration
    """

    _validation = {
        'source': {'required': True},
        'destination': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ConnectivitySource'},
        'destination': {'key': 'destination', 'type': 'ConnectivityDestination'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'protocol_configuration': {'key': 'protocolConfiguration', 'type': 'ProtocolConfiguration'},
    }

    def __init__(self, *, source, destination, protocol=None, protocol_configuration=None, **kwargs) -> None:
        super(ConnectivityParameters, self).__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.protocol = protocol
        self.protocol_configuration = protocol_configuration


class ConnectivitySource(Model):
    """Parameters that define the source of the connection.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The ID of the resource from which a
     connectivity check will be initiated.
    :type resource_id: str
    :param port: The source port from which a connectivity check will be
     performed.
    :type port: int
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, *, resource_id: str, port: int=None, **kwargs) -> None:
        super(ConnectivitySource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.port = port


class Container(SubResource):
    """Reference to container resource in remote resource provider.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(Container, self).__init__(id=id, **kwargs)


class ContainerNetworkInterface(SubResource):
    """Container network interface child resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar container_network_interface_configuration: Container network
     interface configuration from which this container network interface is
     created.
    :vartype container_network_interface_configuration:
     ~azure.mgmt.network.v2019_09_01.models.ContainerNetworkInterfaceConfiguration
    :param container: Reference to the container to which this container
     network interface is attached.
    :type container: ~azure.mgmt.network.v2019_09_01.models.Container
    :ivar ip_configurations: Reference to the ip configuration on this
     container nic.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ContainerNetworkInterfaceIpConfiguration]
    :ivar provisioning_state: The provisioning state of the container network
     interface resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource. This name can be used to access the
     resource.
    :type name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'container_network_interface_configuration': {'readonly': True},
        'ip_configurations': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'container_network_interface_configuration': {'key': 'properties.containerNetworkInterfaceConfiguration', 'type': 'ContainerNetworkInterfaceConfiguration'},
        'container': {'key': 'properties.container', 'type': 'Container'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[ContainerNetworkInterfaceIpConfiguration]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, container=None, name: str=None, **kwargs) -> None:
        super(ContainerNetworkInterface, self).__init__(id=id, **kwargs)
        self.container_network_interface_configuration = None
        self.container = container
        self.ip_configurations = None
        self.provisioning_state = None
        self.name = name
        self.type = None
        self.etag = None


class ContainerNetworkInterfaceConfiguration(SubResource):
    """Container network interface configuration child resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param ip_configurations: A list of ip configurations of the container
     network interface configuration.
    :type ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.IPConfigurationProfile]
    :param container_network_interfaces: A list of container network
     interfaces created from this container network interface configuration.
    :type container_network_interfaces:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the container network
     interface configuration resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource. This name can be used to access the
     resource.
    :type name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IPConfigurationProfile]'},
        'container_network_interfaces': {'key': 'properties.containerNetworkInterfaces', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, ip_configurations=None, container_network_interfaces=None, name: str=None, **kwargs) -> None:
        super(ContainerNetworkInterfaceConfiguration, self).__init__(id=id, **kwargs)
        self.ip_configurations = ip_configurations
        self.container_network_interfaces = container_network_interfaces
        self.provisioning_state = None
        self.name = name
        self.type = None
        self.etag = None


class ContainerNetworkInterfaceIpConfiguration(Model):
    """The ip configuration for a container network interface.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provisioning_state: The provisioning state of the container network
     interface IP configuration resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource. This name can be used to access the
     resource.
    :type name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(ContainerNetworkInterfaceIpConfiguration, self).__init__(**kwargs)
        self.provisioning_state = None
        self.name = name
        self.type = None
        self.etag = None


class DdosCustomPolicy(Resource):
    """A DDoS custom policy in a resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar resource_guid: The resource GUID property of the DDoS custom policy
     resource. It uniquely identifies the resource, even if the user changes
     its name or migrate the resource across subscriptions or resource groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS custom policy
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar public_ip_addresses: The list of public IPs associated with the DDoS
     custom policy resource. This list is read-only.
    :vartype public_ip_addresses:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param protocol_custom_settings: The protocol-specific DDoS policy
     customization parameters.
    :type protocol_custom_settings:
     list[~azure.mgmt.network.v2019_09_01.models.ProtocolCustomSettingsFormat]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_ip_addresses': {'key': 'properties.publicIPAddresses', 'type': '[SubResource]'},
        'protocol_custom_settings': {'key': 'properties.protocolCustomSettings', 'type': '[ProtocolCustomSettingsFormat]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, protocol_custom_settings=None, **kwargs) -> None:
        super(DdosCustomPolicy, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.resource_guid = None
        self.provisioning_state = None
        self.public_ip_addresses = None
        self.protocol_custom_settings = protocol_custom_settings
        self.etag = None


class DdosProtectionPlan(Model):
    """A DDoS protection plan in a resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar resource_guid: The resource GUID property of the DDoS protection
     plan resource. It uniquely identifies the resource, even if the user
     changes its name or migrate the resource across subscriptions or resource
     groups.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the DDoS protection
     plan resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar virtual_networks: The list of virtual networks associated with the
     DDoS protection plan resource. This list is read-only.
    :vartype virtual_networks:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'virtual_networks': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'virtual_networks': {'key': 'properties.virtualNetworks', 'type': '[SubResource]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, **kwargs) -> None:
        super(DdosProtectionPlan, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.resource_guid = None
        self.provisioning_state = None
        self.virtual_networks = None
        self.etag = None


class DdosSettings(Model):
    """Contains the DDoS protection settings of the public IP.

    :param ddos_custom_policy: The DDoS custom policy associated with the
     public IP.
    :type ddos_custom_policy:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param protection_coverage: The DDoS protection policy customizability of
     the public IP. Only standard coverage will have the ability to be
     customized. Possible values include: 'Basic', 'Standard'
    :type protection_coverage: str or
     ~azure.mgmt.network.v2019_09_01.models.DdosSettingsProtectionCoverage
    """

    _attribute_map = {
        'ddos_custom_policy': {'key': 'ddosCustomPolicy', 'type': 'SubResource'},
        'protection_coverage': {'key': 'protectionCoverage', 'type': 'str'},
    }

    def __init__(self, *, ddos_custom_policy=None, protection_coverage=None, **kwargs) -> None:
        super(DdosSettings, self).__init__(**kwargs)
        self.ddos_custom_policy = ddos_custom_policy
        self.protection_coverage = protection_coverage


class Delegation(SubResource):
    """Details the service to which the subnet is delegated.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param service_name: The name of the service to whom the subnet should be
     delegated (e.g. Microsoft.Sql/servers).
    :type service_name: str
    :ivar actions: Describes the actions permitted to the service upon
     delegation.
    :vartype actions: list[str]
    :ivar provisioning_state: The provisioning state of the service delegation
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a subnet. This
     name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'actions': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'service_name': {'key': 'properties.serviceName', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, service_name: str=None, name: str=None, **kwargs) -> None:
        super(Delegation, self).__init__(id=id, **kwargs)
        self.service_name = service_name
        self.actions = None
        self.provisioning_state = None
        self.name = name
        self.etag = None


class DeviceProperties(Model):
    """List of properties of the device.

    :param device_vendor: Name of the device Vendor.
    :type device_vendor: str
    :param device_model: Model of the device.
    :type device_model: str
    :param link_speed_in_mbps: Link speed.
    :type link_speed_in_mbps: int
    """

    _attribute_map = {
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_model': {'key': 'deviceModel', 'type': 'str'},
        'link_speed_in_mbps': {'key': 'linkSpeedInMbps', 'type': 'int'},
    }

    def __init__(self, *, device_vendor: str=None, device_model: str=None, link_speed_in_mbps: int=None, **kwargs) -> None:
        super(DeviceProperties, self).__init__(**kwargs)
        self.device_vendor = device_vendor
        self.device_model = device_model
        self.link_speed_in_mbps = link_speed_in_mbps


class DhcpOptions(Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in
    the virtual network. Standard DHCP option for a subnet overrides VNET DHCP
    options.

    :param dns_servers: The list of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(self, *, dns_servers=None, **kwargs) -> None:
        super(DhcpOptions, self).__init__(**kwargs)
        self.dns_servers = dns_servers


class Dimension(Model):
    """Dimension of the metric.

    :param name: The name of the dimension.
    :type name: str
    :param display_name: The display name of the dimension.
    :type display_name: str
    :param internal_name: The internal name of the dimension.
    :type internal_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, internal_name: str=None, **kwargs) -> None:
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name


class DnsNameAvailabilityResult(Model):
    """Response for the CheckDnsNameAvailability API service call.

    :param available: Domain availability (True/False).
    :type available: bool
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
    }

    def __init__(self, *, available: bool=None, **kwargs) -> None:
        super(DnsNameAvailabilityResult, self).__init__(**kwargs)
        self.available = available


class EffectiveNetworkSecurityGroup(Model):
    """Effective network security group.

    :param network_security_group: The ID of network security group that is
     applied.
    :type network_security_group:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param association: Associated resources.
    :type association:
     ~azure.mgmt.network.v2019_09_01.models.EffectiveNetworkSecurityGroupAssociation
    :param effective_security_rules: A collection of effective security rules.
    :type effective_security_rules:
     list[~azure.mgmt.network.v2019_09_01.models.EffectiveNetworkSecurityRule]
    :param tag_map: Mapping of tags to list of IP Addresses included within
     the tag.
    :type tag_map: dict[str, list[str]]
    """

    _attribute_map = {
        'network_security_group': {'key': 'networkSecurityGroup', 'type': 'SubResource'},
        'association': {'key': 'association', 'type': 'EffectiveNetworkSecurityGroupAssociation'},
        'effective_security_rules': {'key': 'effectiveSecurityRules', 'type': '[EffectiveNetworkSecurityRule]'},
        'tag_map': {'key': 'tagMap', 'type': '{[str]}'},
    }

    def __init__(self, *, network_security_group=None, association=None, effective_security_rules=None, tag_map=None, **kwargs) -> None:
        super(EffectiveNetworkSecurityGroup, self).__init__(**kwargs)
        self.network_security_group = network_security_group
        self.association = association
        self.effective_security_rules = effective_security_rules
        self.tag_map = tag_map


class EffectiveNetworkSecurityGroupAssociation(Model):
    """The effective network security group association.

    :param subnet: The ID of the subnet if assigned.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param network_interface: The ID of the network interface if assigned.
    :type network_interface:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    """

    _attribute_map = {
        'subnet': {'key': 'subnet', 'type': 'SubResource'},
        'network_interface': {'key': 'networkInterface', 'type': 'SubResource'},
    }

    def __init__(self, *, subnet=None, network_interface=None, **kwargs) -> None:
        super(EffectiveNetworkSecurityGroupAssociation, self).__init__(**kwargs)
        self.subnet = subnet
        self.network_interface = network_interface


class EffectiveNetworkSecurityGroupListResult(Model):
    """Response for list effective network security groups API service call.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: A list of effective network security groups.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.EffectiveNetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveNetworkSecurityGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(EffectiveNetworkSecurityGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class EffectiveNetworkSecurityRule(Model):
    """Effective network security rules.

    :param name: The name of the security rule specified by the user (if
     created by the user).
    :type name: str
    :param protocol: The network protocol this rule applies to. Possible
     values include: 'Tcp', 'Udp', 'All'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.EffectiveSecurityRuleProtocol
    :param source_port_range: The source port or range.
    :type source_port_range: str
    :param destination_port_range: The destination port or range.
    :type destination_port_range: str
    :param source_port_ranges: The source port ranges. Expected values include
     a single integer between 0 and 65535, a range using '-' as separator (e.g.
     100-400), or an asterisk (*).
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges. Expected
     values include a single integer between 0 and 65535, a range using '-' as
     separator (e.g. 100-400), or an asterisk (*).
    :type destination_port_ranges: list[str]
    :param source_address_prefix: The source address prefix.
    :type source_address_prefix: str
    :param destination_address_prefix: The destination address prefix.
    :type destination_address_prefix: str
    :param source_address_prefixes: The source address prefixes. Expected
     values include CIDR IP ranges, Default Tags (VirtualNetwork,
     AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
    :type source_address_prefixes: list[str]
    :param destination_address_prefixes: The destination address prefixes.
     Expected values include CIDR IP ranges, Default Tags (VirtualNetwork,
     AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
    :type destination_address_prefixes: list[str]
    :param expanded_source_address_prefix: The expanded source address prefix.
    :type expanded_source_address_prefix: list[str]
    :param expanded_destination_address_prefix: Expanded destination address
     prefix.
    :type expanded_destination_address_prefix: list[str]
    :param access: Whether network traffic is allowed or denied. Possible
     values include: 'Allow', 'Deny'
    :type access: str or
     ~azure.mgmt.network.v2019_09_01.models.SecurityRuleAccess
    :param priority: The priority of the rule.
    :type priority: int
    :param direction: The direction of the rule. Possible values include:
     'Inbound', 'Outbound'
    :type direction: str or
     ~azure.mgmt.network.v2019_09_01.models.SecurityRuleDirection
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source_port_range': {'key': 'sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'destinationPortRange', 'type': 'str'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'destinationPortRanges', 'type': '[str]'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'destination_address_prefix': {'key': 'destinationAddressPrefix', 'type': 'str'},
        'source_address_prefixes': {'key': 'sourceAddressPrefixes', 'type': '[str]'},
        'destination_address_prefixes': {'key': 'destinationAddressPrefixes', 'type': '[str]'},
        'expanded_source_address_prefix': {'key': 'expandedSourceAddressPrefix', 'type': '[str]'},
        'expanded_destination_address_prefix': {'key': 'expandedDestinationAddressPrefix', 'type': '[str]'},
        'access': {'key': 'access', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'direction': {'key': 'direction', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, protocol=None, source_port_range: str=None, destination_port_range: str=None, source_port_ranges=None, destination_port_ranges=None, source_address_prefix: str=None, destination_address_prefix: str=None, source_address_prefixes=None, destination_address_prefixes=None, expanded_source_address_prefix=None, expanded_destination_address_prefix=None, access=None, priority: int=None, direction=None, **kwargs) -> None:
        super(EffectiveNetworkSecurityRule, self).__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefixes = destination_address_prefixes
        self.expanded_source_address_prefix = expanded_source_address_prefix
        self.expanded_destination_address_prefix = expanded_destination_address_prefix
        self.access = access
        self.priority = priority
        self.direction = direction


class EffectiveRoute(Model):
    """Effective Route.

    :param name: The name of the user defined route. This is optional.
    :type name: str
    :param disable_bgp_route_propagation: If true, on-premises routes are not
     propagated to the network interfaces in the subnet.
    :type disable_bgp_route_propagation: bool
    :param source: Who created the route. Possible values include: 'Unknown',
     'User', 'VirtualNetworkGateway', 'Default'
    :type source: str or
     ~azure.mgmt.network.v2019_09_01.models.EffectiveRouteSource
    :param state: The value of effective route. Possible values include:
     'Active', 'Invalid'
    :type state: str or
     ~azure.mgmt.network.v2019_09_01.models.EffectiveRouteState
    :param address_prefix: The address prefixes of the effective routes in
     CIDR notation.
    :type address_prefix: list[str]
    :param next_hop_ip_address: The IP address of the next hop of the
     effective route.
    :type next_hop_ip_address: list[str]
    :param next_hop_type: The type of Azure hop the packet should be sent to.
     Possible values include: 'VirtualNetworkGateway', 'VnetLocal', 'Internet',
     'VirtualAppliance', 'None'
    :type next_hop_type: str or
     ~azure.mgmt.network.v2019_09_01.models.RouteNextHopType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disable_bgp_route_propagation': {'key': 'disableBgpRoutePropagation', 'type': 'bool'},
        'source': {'key': 'source', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'address_prefix': {'key': 'addressPrefix', 'type': '[str]'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': '[str]'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, disable_bgp_route_propagation: bool=None, source=None, state=None, address_prefix=None, next_hop_ip_address=None, next_hop_type=None, **kwargs) -> None:
        super(EffectiveRoute, self).__init__(**kwargs)
        self.name = name
        self.disable_bgp_route_propagation = disable_bgp_route_propagation
        self.source = source
        self.state = state
        self.address_prefix = address_prefix
        self.next_hop_ip_address = next_hop_ip_address
        self.next_hop_type = next_hop_type


class EffectiveRouteListResult(Model):
    """Response for list effective route API service call.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: A list of effective routes.
    :type value: list[~azure.mgmt.network.v2019_09_01.models.EffectiveRoute]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EffectiveRoute]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(EffectiveRouteListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class EndpointServiceResult(SubResource):
    """Endpoint service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Name of the endpoint service.
    :vartype name: str
    :ivar type: Type of the endpoint service.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(EndpointServiceResult, self).__init__(id=id, **kwargs)
        self.name = None
        self.type = None


class Error(Model):
    """Common error representation.

    :param code: Error code.
    :type code: str
    :param message: Error message.
    :type message: str
    :param target: Error target.
    :type target: str
    :param details: Error details.
    :type details: list[~azure.mgmt.network.v2019_09_01.models.ErrorDetails]
    :param inner_error: Inner error message.
    :type inner_error: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, details=None, inner_error: str=None, **kwargs) -> None:
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class ErrorException(HttpOperationError):
    """Server responsed with exception of type: 'Error'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorException, self).__init__(deserialize, response, 'Error', *args)


class ErrorDetails(Model):
    """Common error details representation.

    :param code: Error code.
    :type code: str
    :param target: Error target.
    :type target: str
    :param message: Error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, target: str=None, message: str=None, **kwargs) -> None:
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ErrorResponse(Model):
    """The error object.

    :param error: Error. The error details object.
    :type error: ~azure.mgmt.network.v2019_09_01.models.ErrorDetails
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetails'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class EvaluatedNetworkSecurityGroup(Model):
    """Results of network security group evaluation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param network_security_group_id: Network security group ID.
    :type network_security_group_id: str
    :param applied_to: Resource ID of nic or subnet to which network security
     group is applied.
    :type applied_to: str
    :param matched_rule: Matched network security rule.
    :type matched_rule: ~azure.mgmt.network.v2019_09_01.models.MatchedRule
    :ivar rules_evaluation_result: List of network security rules evaluation
     results.
    :vartype rules_evaluation_result:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkSecurityRulesEvaluationResult]
    """

    _validation = {
        'rules_evaluation_result': {'readonly': True},
    }

    _attribute_map = {
        'network_security_group_id': {'key': 'networkSecurityGroupId', 'type': 'str'},
        'applied_to': {'key': 'appliedTo', 'type': 'str'},
        'matched_rule': {'key': 'matchedRule', 'type': 'MatchedRule'},
        'rules_evaluation_result': {'key': 'rulesEvaluationResult', 'type': '[NetworkSecurityRulesEvaluationResult]'},
    }

    def __init__(self, *, network_security_group_id: str=None, applied_to: str=None, matched_rule=None, **kwargs) -> None:
        super(EvaluatedNetworkSecurityGroup, self).__init__(**kwargs)
        self.network_security_group_id = network_security_group_id
        self.applied_to = applied_to
        self.matched_rule = matched_rule
        self.rules_evaluation_result = None


class ExpressRouteCircuit(Resource):
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The SKU.
    :type sku: ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitSku
    :param allow_classic_operations: Allow classic operations.
    :type allow_classic_operations: bool
    :ivar circuit_provisioning_state: The CircuitProvisioningState state of
     the resource.
    :vartype circuit_provisioning_state: str
    :ivar service_provider_provisioning_state: The
     ServiceProviderProvisioningState state of the resource. Possible values
     include: 'NotProvisioned', 'Provisioning', 'Provisioned', 'Deprovisioning'
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ServiceProviderProvisioningState
    :param authorizations: The list of authorizations.
    :type authorizations:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitAuthorization]
    :param peerings: The list of peerings.
    :type peerings:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeering]
    :ivar service_key: The ServiceKey.
    :vartype service_key: str
    :param service_provider_notes: The ServiceProviderNotes.
    :type service_provider_notes: str
    :param service_provider_properties: The ServiceProviderProperties.
    :type service_provider_properties:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitServiceProviderProperties
    :param express_route_port: The reference to the ExpressRoutePort resource
     when the circuit is provisioned on an ExpressRoutePort resource.
    :type express_route_port:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param bandwidth_in_gbps: The bandwidth of the circuit when the circuit is
     provisioned on an ExpressRoutePort resource.
    :type bandwidth_in_gbps: float
    :ivar stag: The identifier of the circuit traffic. Outer tag for QinQ
     encapsulation.
    :vartype stag: int
    :ivar provisioning_state: The provisioning state of the express route
     circuit resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :ivar global_reach_enabled: Flag denoting Global reach status.
    :vartype global_reach_enabled: bool
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'circuit_provisioning_state': {'readonly': True},
        'service_provider_provisioning_state': {'readonly': True},
        'service_key': {'readonly': True},
        'stag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'global_reach_enabled': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ExpressRouteCircuitSku'},
        'allow_classic_operations': {'key': 'properties.allowClassicOperations', 'type': 'bool'},
        'circuit_provisioning_state': {'key': 'properties.circuitProvisioningState', 'type': 'str'},
        'service_provider_provisioning_state': {'key': 'properties.serviceProviderProvisioningState', 'type': 'str'},
        'authorizations': {'key': 'properties.authorizations', 'type': '[ExpressRouteCircuitAuthorization]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'service_key': {'key': 'properties.serviceKey', 'type': 'str'},
        'service_provider_notes': {'key': 'properties.serviceProviderNotes', 'type': 'str'},
        'service_provider_properties': {'key': 'properties.serviceProviderProperties', 'type': 'ExpressRouteCircuitServiceProviderProperties'},
        'express_route_port': {'key': 'properties.expressRoutePort', 'type': 'SubResource'},
        'bandwidth_in_gbps': {'key': 'properties.bandwidthInGbps', 'type': 'float'},
        'stag': {'key': 'properties.stag', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'global_reach_enabled': {'key': 'properties.globalReachEnabled', 'type': 'bool'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, sku=None, allow_classic_operations: bool=None, authorizations=None, peerings=None, service_provider_notes: str=None, service_provider_properties=None, express_route_port=None, bandwidth_in_gbps: float=None, gateway_manager_etag: str=None, **kwargs) -> None:
        super(ExpressRouteCircuit, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.allow_classic_operations = allow_classic_operations
        self.circuit_provisioning_state = None
        self.service_provider_provisioning_state = None
        self.authorizations = authorizations
        self.peerings = peerings
        self.service_key = None
        self.service_provider_notes = service_provider_notes
        self.service_provider_properties = service_provider_properties
        self.express_route_port = express_route_port
        self.bandwidth_in_gbps = bandwidth_in_gbps
        self.stag = None
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.global_reach_enabled = None
        self.etag = None


class ExpressRouteCircuitArpTable(Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :param age: Entry age in minutes.
    :type age: int
    :param interface: Interface address.
    :type interface: str
    :param ip_address: The IP address.
    :type ip_address: str
    :param mac_address: The MAC address.
    :type mac_address: str
    """

    _attribute_map = {
        'age': {'key': 'age', 'type': 'int'},
        'interface': {'key': 'interface', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
    }

    def __init__(self, *, age: int=None, interface: str=None, ip_address: str=None, mac_address: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitArpTable, self).__init__(**kwargs)
        self.age = age
        self.interface = interface
        self.ip_address = ip_address
        self.mac_address = mac_address


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar authorization_use_status: The authorization use status. Possible
     values include: 'Available', 'InUse'
    :vartype authorization_use_status: str or
     ~azure.mgmt.network.v2019_09_01.models.AuthorizationUseStatus
    :ivar provisioning_state: The provisioning state of the authorization
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'authorization_key': {'readonly': True},
        'authorization_use_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'authorization_use_status': {'key': 'properties.authorizationUseStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, name: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitAuthorization, self).__init__(id=id, **kwargs)
        self.authorization_key = None
        self.authorization_use_status = None
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ExpressRouteCircuitConnection(SubResource):
    """Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param express_route_circuit_peering: Reference to Express Route Circuit
     Private Peering Resource of the circuit initiating connection.
    :type express_route_circuit_peering:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param peer_express_route_circuit_peering: Reference to Express Route
     Circuit Private Peering Resource of the peered circuit.
    :type peer_express_route_circuit_peering:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param address_prefix: /29 IP address space to carve out Customer
     addresses for tunnels.
    :type address_prefix: str
    :param authorization_key: The authorization key.
    :type authorization_key: str
    :ivar circuit_connection_status: Express Route Circuit connection state.
     Possible values include: 'Connected', 'Connecting', 'Disconnected'
    :vartype circuit_connection_status: str or
     ~azure.mgmt.network.v2019_09_01.models.CircuitConnectionStatus
    :ivar provisioning_state: The provisioning state of the express route
     circuit connection resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'circuit_connection_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'express_route_circuit_peering': {'key': 'properties.expressRouteCircuitPeering', 'type': 'SubResource'},
        'peer_express_route_circuit_peering': {'key': 'properties.peerExpressRouteCircuitPeering', 'type': 'SubResource'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'circuit_connection_status': {'key': 'properties.circuitConnectionStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, express_route_circuit_peering=None, peer_express_route_circuit_peering=None, address_prefix: str=None, authorization_key: str=None, name: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitConnection, self).__init__(id=id, **kwargs)
        self.express_route_circuit_peering = express_route_circuit_peering
        self.peer_express_route_circuit_peering = peer_express_route_circuit_peering
        self.address_prefix = address_prefix
        self.authorization_key = authorization_key
        self.circuit_connection_status = None
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ExpressRouteCircuitPeering(SubResource):
    """Peering in an ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param peering_type: The peering type. Possible values include:
     'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
    :type peering_type: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRoutePeeringType
    :param state: The peering state. Possible values include: 'Disabled',
     'Enabled'
    :type state: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :param peer_asn: The peer ASN.
    :type peer_asn: long
    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :param shared_key: The shared key.
    :type shared_key: str
    :param vlan_id: The VLAN ID.
    :type vlan_id: int
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeeringConfig
    :param stats: The peering stats of express route circuit.
    :type stats:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitStats
    :ivar provisioning_state: The provisioning state of the express route
     circuit peering resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :param route_filter: The reference of the RouteFilter resource.
    :type route_filter: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param ipv6_peering_config: The IPv6 peering configuration.
    :type ipv6_peering_config:
     ~azure.mgmt.network.v2019_09_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    :param express_route_connection: The ExpressRoute connection.
    :type express_route_connection:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteConnectionId
    :ivar connections: The list of circuit connections associated with Azure
     Private Peering for this circuit.
    :vartype connections:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitConnection]
    :ivar peered_connections: The list of peered circuit connections
     associated with Azure Private Peering for this circuit.
    :vartype peered_connections:
     list[~azure.mgmt.network.v2019_09_01.models.PeerExpressRouteCircuitConnection]
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'azure_asn': {'readonly': True},
        'peer_asn': {'maximum': 4294967295, 'minimum': 1},
        'primary_azure_port': {'readonly': True},
        'secondary_azure_port': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'connections': {'readonly': True},
        'peered_connections': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'peering_type': {'key': 'properties.peeringType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_asn': {'key': 'properties.azureASN', 'type': 'int'},
        'peer_asn': {'key': 'properties.peerASN', 'type': 'long'},
        'primary_peer_address_prefix': {'key': 'properties.primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'properties.secondaryPeerAddressPrefix', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'vlan_id': {'key': 'properties.vlanId', 'type': 'int'},
        'microsoft_peering_config': {'key': 'properties.microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'stats': {'key': 'properties.stats', 'type': 'ExpressRouteCircuitStats'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'route_filter': {'key': 'properties.routeFilter', 'type': 'SubResource'},
        'ipv6_peering_config': {'key': 'properties.ipv6PeeringConfig', 'type': 'Ipv6ExpressRouteCircuitPeeringConfig'},
        'express_route_connection': {'key': 'properties.expressRouteConnection', 'type': 'ExpressRouteConnectionId'},
        'connections': {'key': 'properties.connections', 'type': '[ExpressRouteCircuitConnection]'},
        'peered_connections': {'key': 'properties.peeredConnections', 'type': '[PeerExpressRouteCircuitConnection]'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, peering_type=None, state=None, peer_asn: int=None, primary_peer_address_prefix: str=None, secondary_peer_address_prefix: str=None, shared_key: str=None, vlan_id: int=None, microsoft_peering_config=None, stats=None, gateway_manager_etag: str=None, route_filter=None, ipv6_peering_config=None, express_route_connection=None, name: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitPeering, self).__init__(id=id, **kwargs)
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = None
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.stats = stats
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by = None
        self.route_filter = route_filter
        self.ipv6_peering_config = ipv6_peering_config
        self.express_route_connection = express_route_connection
        self.connections = None
        self.peered_connections = None
        self.name = name
        self.etag = None
        self.type = None


class ExpressRouteCircuitPeeringConfig(Model):
    """Specifies the peering configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param advertised_public_prefixes: The reference of
     AdvertisedPublicPrefixes.
    :type advertised_public_prefixes: list[str]
    :param advertised_communities: The communities of bgp peering. Specified
     for microsoft peering.
    :type advertised_communities: list[str]
    :ivar advertised_public_prefixes_state: The advertised public prefix state
     of the Peering resource. Possible values include: 'NotConfigured',
     'Configuring', 'Configured', 'ValidationNeeded'
    :vartype advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :param legacy_mode: The legacy mode of the peering.
    :type legacy_mode: int
    :param customer_asn: The CustomerASN of the peering.
    :type customer_asn: int
    :param routing_registry_name: The RoutingRegistryName of the
     configuration.
    :type routing_registry_name: str
    """

    _validation = {
        'advertised_public_prefixes_state': {'readonly': True},
    }

    _attribute_map = {
        'advertised_public_prefixes': {'key': 'advertisedPublicPrefixes', 'type': '[str]'},
        'advertised_communities': {'key': 'advertisedCommunities', 'type': '[str]'},
        'advertised_public_prefixes_state': {'key': 'advertisedPublicPrefixesState', 'type': 'str'},
        'legacy_mode': {'key': 'legacyMode', 'type': 'int'},
        'customer_asn': {'key': 'customerASN', 'type': 'int'},
        'routing_registry_name': {'key': 'routingRegistryName', 'type': 'str'},
    }

    def __init__(self, *, advertised_public_prefixes=None, advertised_communities=None, legacy_mode: int=None, customer_asn: int=None, routing_registry_name: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.advertised_public_prefixes = advertised_public_prefixes
        self.advertised_communities = advertised_communities
        self.advertised_public_prefixes_state = None
        self.legacy_mode = legacy_mode
        self.customer_asn = customer_asn
        self.routing_registry_name = routing_registry_name


class ExpressRouteCircuitPeeringId(Model):
    """ExpressRoute circuit peering identifier.

    :param id: The ID of the ExpressRoute circuit peering.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitPeeringId, self).__init__(**kwargs)
        self.id = id


class ExpressRouteCircuitReference(Model):
    """Reference to an express route circuit.

    :param id: Corresponding Express Route Circuit Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitReference, self).__init__(**kwargs)
        self.id = id


class ExpressRouteCircuitRoutesTable(Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param network: IP address of a network entity.
    :type network: str
    :param next_hop: NextHop address.
    :type next_hop: str
    :param loc_prf: Local preference value as set with the set
     local-preference route-map configuration command.
    :type loc_prf: str
    :param weight: Route Weight.
    :type weight: int
    :param path: Autonomous system paths to the destination network.
    :type path: str
    """

    _attribute_map = {
        'network': {'key': 'network', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'loc_prf': {'key': 'locPrf', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, *, network: str=None, next_hop: str=None, loc_prf: str=None, weight: int=None, path: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitRoutesTable, self).__init__(**kwargs)
        self.network = network
        self.next_hop = next_hop
        self.loc_prf = loc_prf
        self.weight = weight
        self.path = path


class ExpressRouteCircuitRoutesTableSummary(Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param neighbor: IP address of the neighbor.
    :type neighbor: str
    :param v: BGP version number spoken to the neighbor.
    :type v: int
    :param as_property: Autonomous system number.
    :type as_property: int
    :param up_down: The length of time that the BGP session has been in the
     Established state, or the current status if not in the Established state.
    :type up_down: str
    :param state_pfx_rcd: Current state of the BGP session, and the number of
     prefixes that have been received from a neighbor or peer group.
    :type state_pfx_rcd: str
    """

    _attribute_map = {
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'v': {'key': 'v', 'type': 'int'},
        'as_property': {'key': 'as', 'type': 'int'},
        'up_down': {'key': 'upDown', 'type': 'str'},
        'state_pfx_rcd': {'key': 'statePfxRcd', 'type': 'str'},
    }

    def __init__(self, *, neighbor: str=None, v: int=None, as_property: int=None, up_down: str=None, state_pfx_rcd: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitRoutesTableSummary, self).__init__(**kwargs)
        self.neighbor = neighbor
        self.v = v
        self.as_property = as_property
        self.up_down = up_down
        self.state_pfx_rcd = state_pfx_rcd


class ExpressRouteCircuitsArpTableListResult(Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :param value: A list of the ARP tables.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitArpTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitArpTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, next_link: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitsArpTableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitServiceProviderProperties(Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :param service_provider_name: The serviceProviderName.
    :type service_provider_name: str
    :param peering_location: The peering location.
    :type peering_location: str
    :param bandwidth_in_mbps: The BandwidthInMbps.
    :type bandwidth_in_mbps: int
    """

    _attribute_map = {
        'service_provider_name': {'key': 'serviceProviderName', 'type': 'str'},
        'peering_location': {'key': 'peeringLocation', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'bandwidthInMbps', 'type': 'int'},
    }

    def __init__(self, *, service_provider_name: str=None, peering_location: str=None, bandwidth_in_mbps: int=None, **kwargs) -> None:
        super(ExpressRouteCircuitServiceProviderProperties, self).__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps


class ExpressRouteCircuitSku(Model):
    """Contains SKU in an ExpressRouteCircuit.

    :param name: The name of the SKU.
    :type name: str
    :param tier: The tier of the SKU. Possible values include: 'Standard',
     'Premium', 'Basic', 'Local'
    :type tier: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitSkuTier
    :param family: The family of the SKU. Possible values include:
     'UnlimitedData', 'MeteredData'
    :type family: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, tier=None, family=None, **kwargs) -> None:
        super(ExpressRouteCircuitSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family


class ExpressRouteCircuitsRoutesTableListResult(Model):
    """Response for ListRoutesTable associated with the Express Route Circuits
    API.

    :param value: The list of routes table.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitRoutesTable]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTable]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, next_link: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitsRoutesTableListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitsRoutesTableSummaryListResult(Model):
    """Response for ListRoutesTable associated with the Express Route Circuits
    API.

    :param value: A list of the routes table.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitRoutesTableSummary]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCircuitRoutesTableSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, next_link: str=None, **kwargs) -> None:
        super(ExpressRouteCircuitsRoutesTableSummaryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitStats(Model):
    """Contains stats associated with the peering.

    :param primarybytes_in: The Primary BytesIn of the peering.
    :type primarybytes_in: long
    :param primarybytes_out: The primary BytesOut of the peering.
    :type primarybytes_out: long
    :param secondarybytes_in: The secondary BytesIn of the peering.
    :type secondarybytes_in: long
    :param secondarybytes_out: The secondary BytesOut of the peering.
    :type secondarybytes_out: long
    """

    _attribute_map = {
        'primarybytes_in': {'key': 'primarybytesIn', 'type': 'long'},
        'primarybytes_out': {'key': 'primarybytesOut', 'type': 'long'},
        'secondarybytes_in': {'key': 'secondarybytesIn', 'type': 'long'},
        'secondarybytes_out': {'key': 'secondarybytesOut', 'type': 'long'},
    }

    def __init__(self, *, primarybytes_in: int=None, primarybytes_out: int=None, secondarybytes_in: int=None, secondarybytes_out: int=None, **kwargs) -> None:
        super(ExpressRouteCircuitStats, self).__init__(**kwargs)
        self.primarybytes_in = primarybytes_in
        self.primarybytes_out = primarybytes_out
        self.secondarybytes_in = secondarybytes_in
        self.secondarybytes_out = secondarybytes_out


class ExpressRouteConnection(SubResource):
    """ExpressRouteConnection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar provisioning_state: The provisioning state of the express route
     connection resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param express_route_circuit_peering: Required. The ExpressRoute circuit
     peering.
    :type express_route_circuit_peering:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeeringId
    :param authorization_key: Authorization key to establish the connection.
    :type authorization_key: str
    :param routing_weight: The routing weight associated to the connection.
    :type routing_weight: int
    :param enable_internet_security: Enable internet security.
    :type enable_internet_security: bool
    :param name: Required. The name of the resource.
    :type name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'express_route_circuit_peering': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'express_route_circuit_peering': {'key': 'properties.expressRouteCircuitPeering', 'type': 'ExpressRouteCircuitPeeringId'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'enable_internet_security': {'key': 'properties.enableInternetSecurity', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, express_route_circuit_peering, name: str, id: str=None, authorization_key: str=None, routing_weight: int=None, enable_internet_security: bool=None, **kwargs) -> None:
        super(ExpressRouteConnection, self).__init__(id=id, **kwargs)
        self.provisioning_state = None
        self.express_route_circuit_peering = express_route_circuit_peering
        self.authorization_key = authorization_key
        self.routing_weight = routing_weight
        self.enable_internet_security = enable_internet_security
        self.name = name


class ExpressRouteConnectionId(Model):
    """The ID of the ExpressRouteConnection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the ExpressRouteConnection.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ExpressRouteConnectionId, self).__init__(**kwargs)
        self.id = None


class ExpressRouteConnectionList(Model):
    """ExpressRouteConnection list.

    :param value: The list of ExpressRoute connections.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteConnection]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(ExpressRouteConnectionList, self).__init__(**kwargs)
        self.value = value


class ExpressRouteCrossConnection(Resource):
    """ExpressRouteCrossConnection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar primary_azure_port: The name of the primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The name of the secondary port.
    :vartype secondary_azure_port: str
    :ivar s_tag: The identifier of the circuit traffic.
    :vartype s_tag: int
    :param peering_location: The peering location of the ExpressRoute circuit.
    :type peering_location: str
    :param bandwidth_in_mbps: The circuit bandwidth In Mbps.
    :type bandwidth_in_mbps: int
    :param express_route_circuit: The ExpressRouteCircuit.
    :type express_route_circuit:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitReference
    :param service_provider_provisioning_state: The provisioning state of the
     circuit in the connectivity provider system. Possible values include:
     'NotProvisioned', 'Provisioning', 'Provisioned', 'Deprovisioning'
    :type service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ServiceProviderProvisioningState
    :param service_provider_notes: Additional read only notes set by the
     connectivity provider.
    :type service_provider_notes: str
    :ivar provisioning_state: The provisioning state of the express route
     cross connection resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param peerings: The list of peerings.
    :type peerings:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCrossConnectionPeering]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'primary_azure_port': {'readonly': True},
        'secondary_azure_port': {'readonly': True},
        's_tag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        's_tag': {'key': 'properties.sTag', 'type': 'int'},
        'peering_location': {'key': 'properties.peeringLocation', 'type': 'str'},
        'bandwidth_in_mbps': {'key': 'properties.bandwidthInMbps', 'type': 'int'},
        'express_route_circuit': {'key': 'properties.expressRouteCircuit', 'type': 'ExpressRouteCircuitReference'},
        'service_provider_provisioning_state': {'key': 'properties.serviceProviderProvisioningState', 'type': 'str'},
        'service_provider_notes': {'key': 'properties.serviceProviderNotes', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCrossConnectionPeering]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, peering_location: str=None, bandwidth_in_mbps: int=None, express_route_circuit=None, service_provider_provisioning_state=None, service_provider_notes: str=None, peerings=None, **kwargs) -> None:
        super(ExpressRouteCrossConnection, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.s_tag = None
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps
        self.express_route_circuit = express_route_circuit
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.service_provider_notes = service_provider_notes
        self.provisioning_state = None
        self.peerings = peerings
        self.etag = None


class ExpressRouteCrossConnectionPeering(SubResource):
    """Peering in an ExpressRoute Cross Connection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param peering_type: The peering type. Possible values include:
     'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
    :type peering_type: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRoutePeeringType
    :param state: The peering state. Possible values include: 'Disabled',
     'Enabled'
    :type state: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRoutePeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :param peer_asn: The peer ASN.
    :type peer_asn: long
    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :param shared_key: The shared key.
    :type shared_key: str
    :param vlan_id: The VLAN ID.
    :type vlan_id: int
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeeringConfig
    :ivar provisioning_state: The provisioning state of the express route
     cross connection peering resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param gateway_manager_etag: The GatewayManager Etag.
    :type gateway_manager_etag: str
    :ivar last_modified_by: Who was the last to modify the peering.
    :vartype last_modified_by: str
    :param ipv6_peering_config: The IPv6 peering configuration.
    :type ipv6_peering_config:
     ~azure.mgmt.network.v2019_09_01.models.Ipv6ExpressRouteCircuitPeeringConfig
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'azure_asn': {'readonly': True},
        'peer_asn': {'maximum': 4294967295, 'minimum': 1},
        'primary_azure_port': {'readonly': True},
        'secondary_azure_port': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'peering_type': {'key': 'properties.peeringType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'azure_asn': {'key': 'properties.azureASN', 'type': 'int'},
        'peer_asn': {'key': 'properties.peerASN', 'type': 'long'},
        'primary_peer_address_prefix': {'key': 'properties.primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'properties.secondaryPeerAddressPrefix', 'type': 'str'},
        'primary_azure_port': {'key': 'properties.primaryAzurePort', 'type': 'str'},
        'secondary_azure_port': {'key': 'properties.secondaryAzurePort', 'type': 'str'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'vlan_id': {'key': 'properties.vlanId', 'type': 'int'},
        'microsoft_peering_config': {'key': 'properties.microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'gateway_manager_etag': {'key': 'properties.gatewayManagerEtag', 'type': 'str'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'ipv6_peering_config': {'key': 'properties.ipv6PeeringConfig', 'type': 'Ipv6ExpressRouteCircuitPeeringConfig'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, peering_type=None, state=None, peer_asn: int=None, primary_peer_address_prefix: str=None, secondary_peer_address_prefix: str=None, shared_key: str=None, vlan_id: int=None, microsoft_peering_config=None, gateway_manager_etag: str=None, ipv6_peering_config=None, name: str=None, **kwargs) -> None:
        super(ExpressRouteCrossConnectionPeering, self).__init__(id=id, **kwargs)
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = None
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = None
        self.secondary_azure_port = None
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.provisioning_state = None
        self.gateway_manager_etag = gateway_manager_etag
        self.last_modified_by = None
        self.ipv6_peering_config = ipv6_peering_config
        self.name = name
        self.etag = None


class ExpressRouteCrossConnectionRoutesTableSummary(Model):
    """The routes table associated with the ExpressRouteCircuit.

    :param neighbor: IP address of Neighbor router.
    :type neighbor: str
    :param asn: Autonomous system number.
    :type asn: int
    :param up_down: The length of time that the BGP session has been in the
     Established state, or the current status if not in the Established state.
    :type up_down: str
    :param state_or_prefixes_received: Current state of the BGP session, and
     the number of prefixes that have been received from a neighbor or peer
     group.
    :type state_or_prefixes_received: str
    """

    _attribute_map = {
        'neighbor': {'key': 'neighbor', 'type': 'str'},
        'asn': {'key': 'asn', 'type': 'int'},
        'up_down': {'key': 'upDown', 'type': 'str'},
        'state_or_prefixes_received': {'key': 'stateOrPrefixesReceived', 'type': 'str'},
    }

    def __init__(self, *, neighbor: str=None, asn: int=None, up_down: str=None, state_or_prefixes_received: str=None, **kwargs) -> None:
        super(ExpressRouteCrossConnectionRoutesTableSummary, self).__init__(**kwargs)
        self.neighbor = neighbor
        self.asn = asn
        self.up_down = up_down
        self.state_or_prefixes_received = state_or_prefixes_received


class ExpressRouteCrossConnectionsRoutesTableSummaryListResult(Model):
    """Response for ListRoutesTable associated with the Express Route Cross
    Connections.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: A list of the routes table.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCrossConnectionRoutesTableSummary]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteCrossConnectionRoutesTableSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(ExpressRouteCrossConnectionsRoutesTableSummaryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ExpressRouteGateway(Resource):
    """ExpressRoute gateway resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param auto_scale_configuration: Configuration for auto scaling.
    :type auto_scale_configuration:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration
    :ivar express_route_connections: List of ExpressRoute connections to the
     ExpressRoute gateway.
    :vartype express_route_connections:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteConnection]
    :ivar provisioning_state: The provisioning state of the express route
     gateway resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param virtual_hub: Required. The Virtual Hub where the ExpressRoute
     gateway is or will be deployed.
    :type virtual_hub: ~azure.mgmt.network.v2019_09_01.models.VirtualHubId
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'express_route_connections': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'virtual_hub': {'required': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_scale_configuration': {'key': 'properties.autoScaleConfiguration', 'type': 'ExpressRouteGatewayPropertiesAutoScaleConfiguration'},
        'express_route_connections': {'key': 'properties.expressRouteConnections', 'type': '[ExpressRouteConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'VirtualHubId'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, virtual_hub, id: str=None, location: str=None, tags=None, auto_scale_configuration=None, **kwargs) -> None:
        super(ExpressRouteGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.auto_scale_configuration = auto_scale_configuration
        self.express_route_connections = None
        self.provisioning_state = None
        self.virtual_hub = virtual_hub
        self.etag = None


class ExpressRouteGatewayList(Model):
    """List of ExpressRoute gateways.

    :param value: List of ExpressRoute gateways.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteGateway]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpressRouteGateway]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(ExpressRouteGatewayList, self).__init__(**kwargs)
        self.value = value


class ExpressRouteGatewayPropertiesAutoScaleConfiguration(Model):
    """Configuration for auto scaling.

    :param bounds: Minimum and maximum number of scale units to deploy.
    :type bounds:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds
    """

    _attribute_map = {
        'bounds': {'key': 'bounds', 'type': 'ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds'},
    }

    def __init__(self, *, bounds=None, **kwargs) -> None:
        super(ExpressRouteGatewayPropertiesAutoScaleConfiguration, self).__init__(**kwargs)
        self.bounds = bounds


class ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds(Model):
    """Minimum and maximum number of scale units to deploy.

    :param min: Minimum number of scale units deployed for ExpressRoute
     gateway.
    :type min: int
    :param max: Maximum number of scale units deployed for ExpressRoute
     gateway.
    :type max: int
    """

    _attribute_map = {
        'min': {'key': 'min', 'type': 'int'},
        'max': {'key': 'max', 'type': 'int'},
    }

    def __init__(self, *, min: int=None, max: int=None, **kwargs) -> None:
        super(ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds, self).__init__(**kwargs)
        self.min = min
        self.max = max


class ExpressRouteLink(SubResource):
    """ExpressRouteLink.

    ExpressRouteLink child resource definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar router_name: Name of Azure router associated with physical port.
    :vartype router_name: str
    :ivar interface_name: Name of Azure router interface.
    :vartype interface_name: str
    :ivar patch_panel_id: Mapping between physical port to patch panel port.
    :vartype patch_panel_id: str
    :ivar rack_id: Mapping of physical patch panel to rack.
    :vartype rack_id: str
    :ivar connector_type: Physical fiber port type. Possible values include:
     'LC', 'SC'
    :vartype connector_type: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteLinkConnectorType
    :param admin_state: Administrative state of the physical port. Possible
     values include: 'Enabled', 'Disabled'
    :type admin_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteLinkAdminState
    :ivar provisioning_state: The provisioning state of the express route link
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param mac_sec_config: MacSec configuration.
    :type mac_sec_config:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteLinkMacSecConfig
    :param name: Name of child port resource that is unique among child port
     resources of the parent.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'router_name': {'readonly': True},
        'interface_name': {'readonly': True},
        'patch_panel_id': {'readonly': True},
        'rack_id': {'readonly': True},
        'connector_type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'router_name': {'key': 'properties.routerName', 'type': 'str'},
        'interface_name': {'key': 'properties.interfaceName', 'type': 'str'},
        'patch_panel_id': {'key': 'properties.patchPanelId', 'type': 'str'},
        'rack_id': {'key': 'properties.rackId', 'type': 'str'},
        'connector_type': {'key': 'properties.connectorType', 'type': 'str'},
        'admin_state': {'key': 'properties.adminState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'mac_sec_config': {'key': 'properties.macSecConfig', 'type': 'ExpressRouteLinkMacSecConfig'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, admin_state=None, mac_sec_config=None, name: str=None, **kwargs) -> None:
        super(ExpressRouteLink, self).__init__(id=id, **kwargs)
        self.router_name = None
        self.interface_name = None
        self.patch_panel_id = None
        self.rack_id = None
        self.connector_type = None
        self.admin_state = admin_state
        self.provisioning_state = None
        self.mac_sec_config = mac_sec_config
        self.name = name
        self.etag = None


class ExpressRouteLinkMacSecConfig(Model):
    """Definition of ExpressRouteLink Mac Security configuration.

    ExpressRouteLink Mac Security Configuration.

    :param ckn_secret_identifier: Keyvault Secret Identifier URL containing
     Mac security CKN key.
    :type ckn_secret_identifier: str
    :param cak_secret_identifier: Keyvault Secret Identifier URL containing
     Mac security CAK key.
    :type cak_secret_identifier: str
    :param cipher: Mac security cipher. Possible values include:
     'gcm-aes-128', 'gcm-aes-256'
    :type cipher: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteLinkMacSecCipher
    """

    _attribute_map = {
        'ckn_secret_identifier': {'key': 'cknSecretIdentifier', 'type': 'str'},
        'cak_secret_identifier': {'key': 'cakSecretIdentifier', 'type': 'str'},
        'cipher': {'key': 'cipher', 'type': 'str'},
    }

    def __init__(self, *, ckn_secret_identifier: str=None, cak_secret_identifier: str=None, cipher=None, **kwargs) -> None:
        super(ExpressRouteLinkMacSecConfig, self).__init__(**kwargs)
        self.ckn_secret_identifier = ckn_secret_identifier
        self.cak_secret_identifier = cak_secret_identifier
        self.cipher = cipher


class ExpressRoutePort(Resource):
    """ExpressRoute Port.

    ExpressRoutePort resource definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param peering_location: The name of the peering location that the
     ExpressRoutePort is mapped to physically.
    :type peering_location: str
    :param bandwidth_in_gbps: Bandwidth of procured ports in Gbps.
    :type bandwidth_in_gbps: int
    :ivar provisioned_bandwidth_in_gbps: Aggregate Gbps of associated circuit
     bandwidths.
    :vartype provisioned_bandwidth_in_gbps: float
    :ivar mtu: Maximum transmission unit of the physical port pair(s).
    :vartype mtu: str
    :param encapsulation: Encapsulation method on physical ports. Possible
     values include: 'Dot1Q', 'QinQ'
    :type encapsulation: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRoutePortsEncapsulation
    :ivar ether_type: Ether type of the physical port.
    :vartype ether_type: str
    :ivar allocation_date: Date of the physical port allocation to be used in
     Letter of Authorization.
    :vartype allocation_date: str
    :param links: ExpressRouteLink Sub-Resources. The set of physical links of
     the ExpressRoutePort resource.
    :type links: list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteLink]
    :ivar circuits: Reference the ExpressRoute circuit(s) that are provisioned
     on this ExpressRoutePort resource.
    :vartype circuits:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the express route port
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar resource_guid: The resource GUID property of the express route port
     resource.
    :vartype resource_guid: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param identity: The identity of ExpressRoutePort, if configured.
    :type identity:
     ~azure.mgmt.network.v2019_09_01.models.ManagedServiceIdentity
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioned_bandwidth_in_gbps': {'readonly': True},
        'mtu': {'readonly': True},
        'ether_type': {'readonly': True},
        'allocation_date': {'readonly': True},
        'circuits': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_guid': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'peering_location': {'key': 'properties.peeringLocation', 'type': 'str'},
        'bandwidth_in_gbps': {'key': 'properties.bandwidthInGbps', 'type': 'int'},
        'provisioned_bandwidth_in_gbps': {'key': 'properties.provisionedBandwidthInGbps', 'type': 'float'},
        'mtu': {'key': 'properties.mtu', 'type': 'str'},
        'encapsulation': {'key': 'properties.encapsulation', 'type': 'str'},
        'ether_type': {'key': 'properties.etherType', 'type': 'str'},
        'allocation_date': {'key': 'properties.allocationDate', 'type': 'str'},
        'links': {'key': 'properties.links', 'type': '[ExpressRouteLink]'},
        'circuits': {'key': 'properties.circuits', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, peering_location: str=None, bandwidth_in_gbps: int=None, encapsulation=None, links=None, identity=None, **kwargs) -> None:
        super(ExpressRoutePort, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_location = peering_location
        self.bandwidth_in_gbps = bandwidth_in_gbps
        self.provisioned_bandwidth_in_gbps = None
        self.mtu = None
        self.encapsulation = encapsulation
        self.ether_type = None
        self.allocation_date = None
        self.links = links
        self.circuits = None
        self.provisioning_state = None
        self.resource_guid = None
        self.etag = None
        self.identity = identity


class ExpressRoutePortsLocation(Resource):
    """ExpressRoutePorts Peering Location.

    Definition of the ExpressRoutePorts peering location resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar address: Address of peering location.
    :vartype address: str
    :ivar contact: Contact details of peering locations.
    :vartype contact: str
    :param available_bandwidths: The inventory of available ExpressRoutePort
     bandwidths.
    :type available_bandwidths:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRoutePortsLocationBandwidths]
    :ivar provisioning_state: The provisioning state of the express route port
     location resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'address': {'readonly': True},
        'contact': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'address': {'key': 'properties.address', 'type': 'str'},
        'contact': {'key': 'properties.contact', 'type': 'str'},
        'available_bandwidths': {'key': 'properties.availableBandwidths', 'type': '[ExpressRoutePortsLocationBandwidths]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, available_bandwidths=None, **kwargs) -> None:
        super(ExpressRoutePortsLocation, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.address = None
        self.contact = None
        self.available_bandwidths = available_bandwidths
        self.provisioning_state = None


class ExpressRoutePortsLocationBandwidths(Model):
    """ExpressRoutePorts Location Bandwidths.

    Real-time inventory of available ExpressRoute port bandwidths.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar offer_name: Bandwidth descriptive name.
    :vartype offer_name: str
    :ivar value_in_gbps: Bandwidth value in Gbps.
    :vartype value_in_gbps: int
    """

    _validation = {
        'offer_name': {'readonly': True},
        'value_in_gbps': {'readonly': True},
    }

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_gbps': {'key': 'valueInGbps', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(ExpressRoutePortsLocationBandwidths, self).__init__(**kwargs)
        self.offer_name = None
        self.value_in_gbps = None


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param peering_locations: A list of peering locations.
    :type peering_locations: list[str]
    :param bandwidths_offered: A list of bandwidths offered.
    :type bandwidths_offered:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteServiceProviderBandwidthsOffered]
    :ivar provisioning_state: The provisioning state of the express route
     service provider resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'peering_locations': {'key': 'properties.peeringLocations', 'type': '[str]'},
        'bandwidths_offered': {'key': 'properties.bandwidthsOffered', 'type': '[ExpressRouteServiceProviderBandwidthsOffered]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, peering_locations=None, bandwidths_offered=None, **kwargs) -> None:
        super(ExpressRouteServiceProvider, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_locations = peering_locations
        self.bandwidths_offered = bandwidths_offered
        self.provisioning_state = None


class ExpressRouteServiceProviderBandwidthsOffered(Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :param offer_name: The OfferName.
    :type offer_name: str
    :param value_in_mbps: The ValueInMbps.
    :type value_in_mbps: int
    """

    _attribute_map = {
        'offer_name': {'key': 'offerName', 'type': 'str'},
        'value_in_mbps': {'key': 'valueInMbps', 'type': 'int'},
    }

    def __init__(self, *, offer_name: str=None, value_in_mbps: int=None, **kwargs) -> None:
        super(ExpressRouteServiceProviderBandwidthsOffered, self).__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps


class FirewallPolicy(Resource):
    """FirewallPolicy Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar rule_groups: List of references to FirewallPolicyRuleGroups.
    :vartype rule_groups:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the firewall policy
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param base_policy: The parent firewall policy from which rules are
     inherited.
    :type base_policy: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar firewalls: List of references to Azure Firewalls that this Firewall
     Policy is associated with.
    :vartype firewalls:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar child_policies: List of references to Child Firewall Policies.
    :vartype child_policies:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param threat_intel_mode: The operation mode for Threat Intelligence.
     Possible values include: 'Alert', 'Deny', 'Off'
    :type threat_intel_mode: str or
     ~azure.mgmt.network.v2019_09_01.models.AzureFirewallThreatIntelMode
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'rule_groups': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'firewalls': {'readonly': True},
        'child_policies': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'base_policy': {'key': 'properties.basePolicy', 'type': 'SubResource'},
        'firewalls': {'key': 'properties.firewalls', 'type': '[SubResource]'},
        'child_policies': {'key': 'properties.childPolicies', 'type': '[SubResource]'},
        'threat_intel_mode': {'key': 'properties.threatIntelMode', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, base_policy=None, threat_intel_mode=None, **kwargs) -> None:
        super(FirewallPolicy, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.rule_groups = None
        self.provisioning_state = None
        self.base_policy = base_policy
        self.firewalls = None
        self.child_policies = None
        self.threat_intel_mode = threat_intel_mode
        self.etag = None


class FirewallPolicyRule(Model):
    """Properties of the rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FirewallPolicyNatRule, FirewallPolicyFilterRule

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the rule.
    :type name: str
    :param priority: Priority of the Firewall Policy Rule resource.
    :type priority: int
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    """

    _validation = {
        'priority': {'maximum': 65000, 'minimum': 100},
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
    }

    _subtype_map = {
        'rule_type': {'FirewallPolicyNatRule': 'FirewallPolicyNatRule', 'FirewallPolicyFilterRule': 'FirewallPolicyFilterRule'}
    }

    def __init__(self, *, name: str=None, priority: int=None, **kwargs) -> None:
        super(FirewallPolicyRule, self).__init__(**kwargs)
        self.name = name
        self.priority = priority
        self.rule_type = None


class FirewallPolicyFilterRule(FirewallPolicyRule):
    """Firewall Policy Filter Rule.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the rule.
    :type name: str
    :param priority: Priority of the Firewall Policy Rule resource.
    :type priority: int
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param action: The action type of a Filter rule.
    :type action:
     ~azure.mgmt.network.v2019_09_01.models.FirewallPolicyFilterRuleAction
    :param rule_conditions: Collection of rule conditions used by a rule.
    :type rule_conditions:
     list[~azure.mgmt.network.v2019_09_01.models.FirewallPolicyRuleCondition]
    """

    _validation = {
        'priority': {'maximum': 65000, 'minimum': 100},
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'action': {'key': 'action', 'type': 'FirewallPolicyFilterRuleAction'},
        'rule_conditions': {'key': 'ruleConditions', 'type': '[FirewallPolicyRuleCondition]'},
    }

    def __init__(self, *, name: str=None, priority: int=None, action=None, rule_conditions=None, **kwargs) -> None:
        super(FirewallPolicyFilterRule, self).__init__(name=name, priority=priority, **kwargs)
        self.action = action
        self.rule_conditions = rule_conditions
        self.rule_type = 'FirewallPolicyFilterRule'


class FirewallPolicyFilterRuleAction(Model):
    """Properties of the FirewallPolicyFilterRuleAction.

    :param type: The type of action. Possible values include: 'Allow', 'Deny'
    :type type: str or
     ~azure.mgmt.network.v2019_09_01.models.FirewallPolicyFilterRuleActionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(FirewallPolicyFilterRuleAction, self).__init__(**kwargs)
        self.type = type


class FirewallPolicyNatRule(FirewallPolicyRule):
    """Firewall Policy NAT Rule.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the rule.
    :type name: str
    :param priority: Priority of the Firewall Policy Rule resource.
    :type priority: int
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param action: The action type of a Nat rule.
    :type action:
     ~azure.mgmt.network.v2019_09_01.models.FirewallPolicyNatRuleAction
    :param translated_address: The translated address for this NAT rule.
    :type translated_address: str
    :param translated_port: The translated port for this NAT rule.
    :type translated_port: str
    :param rule_condition: The match conditions for incoming traffic.
    :type rule_condition:
     ~azure.mgmt.network.v2019_09_01.models.FirewallPolicyRuleCondition
    """

    _validation = {
        'priority': {'maximum': 65000, 'minimum': 100},
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'action': {'key': 'action', 'type': 'FirewallPolicyNatRuleAction'},
        'translated_address': {'key': 'translatedAddress', 'type': 'str'},
        'translated_port': {'key': 'translatedPort', 'type': 'str'},
        'rule_condition': {'key': 'ruleCondition', 'type': 'FirewallPolicyRuleCondition'},
    }

    def __init__(self, *, name: str=None, priority: int=None, action=None, translated_address: str=None, translated_port: str=None, rule_condition=None, **kwargs) -> None:
        super(FirewallPolicyNatRule, self).__init__(name=name, priority=priority, **kwargs)
        self.action = action
        self.translated_address = translated_address
        self.translated_port = translated_port
        self.rule_condition = rule_condition
        self.rule_type = 'FirewallPolicyNatRule'


class FirewallPolicyNatRuleAction(Model):
    """Properties of the FirewallPolicyNatRuleAction.

    :param type: The type of action. Possible values include: 'DNAT'
    :type type: str or
     ~azure.mgmt.network.v2019_09_01.models.FirewallPolicyNatRuleActionType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(FirewallPolicyNatRuleAction, self).__init__(**kwargs)
        self.type = type


class FirewallPolicyRuleConditionApplicationProtocol(Model):
    """Properties of the application rule protocol.

    :param protocol_type: Protocol type. Possible values include: 'Http',
     'Https'
    :type protocol_type: str or
     ~azure.mgmt.network.v2019_09_01.models.FirewallPolicyRuleConditionApplicationProtocolType
    :param port: Port number for the protocol, cannot be greater than 64000.
    :type port: int
    """

    _validation = {
        'port': {'maximum': 64000, 'minimum': 0},
    }

    _attribute_map = {
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, *, protocol_type=None, port: int=None, **kwargs) -> None:
        super(FirewallPolicyRuleConditionApplicationProtocol, self).__init__(**kwargs)
        self.protocol_type = protocol_type
        self.port = port


class FirewallPolicyRuleGroup(SubResource):
    """Rule Group resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param priority: Priority of the Firewall Policy Rule Group resource.
    :type priority: int
    :param rules: Group of Firewall Policy rules.
    :type rules:
     list[~azure.mgmt.network.v2019_09_01.models.FirewallPolicyRule]
    :ivar provisioning_state: The provisioning state of the firewall policy
     rule group resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Rule Group type.
    :vartype type: str
    """

    _validation = {
        'priority': {'maximum': 65000, 'minimum': 100},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'rules': {'key': 'properties.rules', 'type': '[FirewallPolicyRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, priority: int=None, rules=None, name: str=None, **kwargs) -> None:
        super(FirewallPolicyRuleGroup, self).__init__(id=id, **kwargs)
        self.priority = priority
        self.rules = rules
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class FlowLogFormatParameters(Model):
    """Parameters that define the flow log format.

    :param type: The file type of flow log. Possible values include: 'JSON'
    :type type: str or
     ~azure.mgmt.network.v2019_09_01.models.FlowLogFormatType
    :param version: The version (revision) of the flow log. Default value: 0 .
    :type version: int
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'int'},
    }

    def __init__(self, *, type=None, version: int=0, **kwargs) -> None:
        super(FlowLogFormatParameters, self).__init__(**kwargs)
        self.type = type
        self.version = version


class FlowLogInformation(Model):
    """Information on the configuration of flow log and traffic analytics
    (optional) .

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the resource to configure
     for flow log and traffic analytics (optional) .
    :type target_resource_id: str
    :param storage_id: Required. ID of the storage account which is used to
     store the flow log.
    :type storage_id: str
    :param enabled: Required. Flag to enable/disable flow logging.
    :type enabled: bool
    :param retention_policy: Parameters that define the retention policy for
     flow log.
    :type retention_policy:
     ~azure.mgmt.network.v2019_09_01.models.RetentionPolicyParameters
    :param format: Parameters that define the flow log format.
    :type format:
     ~azure.mgmt.network.v2019_09_01.models.FlowLogFormatParameters
    :param flow_analytics_configuration: Parameters that define the
     configuration of traffic analytics.
    :type flow_analytics_configuration:
     ~azure.mgmt.network.v2019_09_01.models.TrafficAnalyticsProperties
    """

    _validation = {
        'target_resource_id': {'required': True},
        'storage_id': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'retention_policy': {'key': 'properties.retentionPolicy', 'type': 'RetentionPolicyParameters'},
        'format': {'key': 'properties.format', 'type': 'FlowLogFormatParameters'},
        'flow_analytics_configuration': {'key': 'flowAnalyticsConfiguration', 'type': 'TrafficAnalyticsProperties'},
    }

    def __init__(self, *, target_resource_id: str, storage_id: str, enabled: bool, retention_policy=None, format=None, flow_analytics_configuration=None, **kwargs) -> None:
        super(FlowLogInformation, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.storage_id = storage_id
        self.enabled = enabled
        self.retention_policy = retention_policy
        self.format = format
        self.flow_analytics_configuration = flow_analytics_configuration


class FlowLogStatusParameters(Model):
    """Parameters that define a resource to query flow log and traffic analytics
    (optional) status.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource where getting the
     flow log and traffic analytics (optional) status.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, *, target_resource_id: str, **kwargs) -> None:
        super(FlowLogStatusParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id


class FrontendIPConfiguration(SubResource):
    """Frontend IP address of the load balancer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar inbound_nat_rules: An array of references to inbound rules that use
     this frontend IP.
    :vartype inbound_nat_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar inbound_nat_pools: An array of references to inbound pools that use
     this frontend IP.
    :vartype inbound_nat_pools:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar outbound_rules: An array of references to outbound rules that use
     this frontend IP.
    :vartype outbound_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar load_balancing_rules: An array of references to load balancing rules
     that use this frontend IP.
    :vartype load_balancing_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The Private IP allocation method.
     Possible values include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_09_01.models.IPAllocationMethod
    :param private_ip_address_version: Whether the specific ipconfiguration is
     IPv4 or IPv6. Default is taken as IPv4. Possible values include: 'IPv4',
     'IPv6'
    :type private_ip_address_version: str or
     ~azure.mgmt.network.v2019_09_01.models.IPVersion
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.Subnet
    :param public_ip_address: The reference of the Public IP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2019_09_01.models.PublicIPAddress
    :param public_ip_prefix: The reference of the Public IP Prefix resource.
    :type public_ip_prefix: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the frontend IP
     configuration resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the set of
     frontend IP configurations used by the load balancer. This name can be
     used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param zones: A list of availability zones denoting the IP allocated for
     the resource needs to come from.
    :type zones: list[str]
    """

    _validation = {
        'inbound_nat_rules': {'readonly': True},
        'inbound_nat_pools': {'readonly': True},
        'outbound_rules': {'readonly': True},
        'load_balancing_rules': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[SubResource]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[SubResource]'},
        'outbound_rules': {'key': 'properties.outboundRules', 'type': '[SubResource]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'public_ip_prefix': {'key': 'properties.publicIPPrefix', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(self, *, id: str=None, private_ip_address: str=None, private_ip_allocation_method=None, private_ip_address_version=None, subnet=None, public_ip_address=None, public_ip_prefix=None, name: str=None, zones=None, **kwargs) -> None:
        super(FrontendIPConfiguration, self).__init__(id=id, **kwargs)
        self.inbound_nat_rules = None
        self.inbound_nat_pools = None
        self.outbound_rules = None
        self.load_balancing_rules = None
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.public_ip_prefix = public_ip_prefix
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None
        self.zones = zones


class GatewayRoute(Model):
    """Gateway routing details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar local_address: The gateway's local address.
    :vartype local_address: str
    :ivar network: The route's network prefix.
    :vartype network: str
    :ivar next_hop: The route's next hop.
    :vartype next_hop: str
    :ivar source_peer: The peer this route was learned from.
    :vartype source_peer: str
    :ivar origin: The source this route was learned from.
    :vartype origin: str
    :ivar as_path: The route's AS path sequence.
    :vartype as_path: str
    :ivar weight: The route's weight.
    :vartype weight: int
    """

    _validation = {
        'local_address': {'readonly': True},
        'network': {'readonly': True},
        'next_hop': {'readonly': True},
        'source_peer': {'readonly': True},
        'origin': {'readonly': True},
        'as_path': {'readonly': True},
        'weight': {'readonly': True},
    }

    _attribute_map = {
        'local_address': {'key': 'localAddress', 'type': 'str'},
        'network': {'key': 'network', 'type': 'str'},
        'next_hop': {'key': 'nextHop', 'type': 'str'},
        'source_peer': {'key': 'sourcePeer', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'as_path': {'key': 'asPath', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(GatewayRoute, self).__init__(**kwargs)
        self.local_address = None
        self.network = None
        self.next_hop = None
        self.source_peer = None
        self.origin = None
        self.as_path = None
        self.weight = None


class GatewayRouteListResult(Model):
    """List of virtual network gateway routes.

    :param value: List of gateway routes.
    :type value: list[~azure.mgmt.network.v2019_09_01.models.GatewayRoute]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayRoute]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(GatewayRouteListResult, self).__init__(**kwargs)
        self.value = value


class GetVpnSitesConfigurationRequest(Model):
    """List of Vpn-Sites.

    All required parameters must be populated in order to send to Azure.

    :param vpn_sites: List of resource-ids of the vpn-sites for which config
     is to be downloaded.
    :type vpn_sites: list[str]
    :param output_blob_sas_url: Required. The sas-url to download the
     configurations for vpn-sites.
    :type output_blob_sas_url: str
    """

    _validation = {
        'output_blob_sas_url': {'required': True},
    }

    _attribute_map = {
        'vpn_sites': {'key': 'vpnSites', 'type': '[str]'},
        'output_blob_sas_url': {'key': 'outputBlobSasUrl', 'type': 'str'},
    }

    def __init__(self, *, output_blob_sas_url: str, vpn_sites=None, **kwargs) -> None:
        super(GetVpnSitesConfigurationRequest, self).__init__(**kwargs)
        self.vpn_sites = vpn_sites
        self.output_blob_sas_url = output_blob_sas_url


class HTTPConfiguration(Model):
    """HTTP configuration of the connectivity check.

    :param method: HTTP method. Possible values include: 'Get'
    :type method: str or ~azure.mgmt.network.v2019_09_01.models.HTTPMethod
    :param headers: List of HTTP headers.
    :type headers: list[~azure.mgmt.network.v2019_09_01.models.HTTPHeader]
    :param valid_status_codes: Valid status codes.
    :type valid_status_codes: list[int]
    """

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '[HTTPHeader]'},
        'valid_status_codes': {'key': 'validStatusCodes', 'type': '[int]'},
    }

    def __init__(self, *, method=None, headers=None, valid_status_codes=None, **kwargs) -> None:
        super(HTTPConfiguration, self).__init__(**kwargs)
        self.method = method
        self.headers = headers
        self.valid_status_codes = valid_status_codes


class HTTPHeader(Model):
    """Describes the HTTP header.

    :param name: The name in HTTP header.
    :type name: str
    :param value: The value in HTTP header.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, value: str=None, **kwargs) -> None:
        super(HTTPHeader, self).__init__(**kwargs)
        self.name = name
        self.value = value


class HubIPAddresses(Model):
    """IP addresses associated with azure firewall.

    :param public_ip_addresses: List of Public IP addresses associated with
     azure firewall.
    :type public_ip_addresses:
     list[~azure.mgmt.network.v2019_09_01.models.AzureFirewallPublicIPAddress]
    :param private_ip_address: Private IP Address associated with azure
     firewall.
    :type private_ip_address: str
    """

    _attribute_map = {
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[AzureFirewallPublicIPAddress]'},
        'private_ip_address': {'key': 'privateIPAddress', 'type': 'str'},
    }

    def __init__(self, *, public_ip_addresses=None, private_ip_address: str=None, **kwargs) -> None:
        super(HubIPAddresses, self).__init__(**kwargs)
        self.public_ip_addresses = public_ip_addresses
        self.private_ip_address = private_ip_address


class HubVirtualNetworkConnection(SubResource):
    """HubVirtualNetworkConnection Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param remote_virtual_network: Reference to the remote virtual network.
    :type remote_virtual_network:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param allow_hub_to_remote_vnet_transit: VirtualHub to RemoteVnet transit
     to enabled or not.
    :type allow_hub_to_remote_vnet_transit: bool
    :param allow_remote_vnet_to_use_hub_vnet_gateways: Allow RemoteVnet to use
     Virtual Hub's gateways.
    :type allow_remote_vnet_to_use_hub_vnet_gateways: bool
    :param enable_internet_security: Enable internet security.
    :type enable_internet_security: bool
    :ivar provisioning_state: The provisioning state of the hub virtual
     network connection resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'remote_virtual_network': {'key': 'properties.remoteVirtualNetwork', 'type': 'SubResource'},
        'allow_hub_to_remote_vnet_transit': {'key': 'properties.allowHubToRemoteVnetTransit', 'type': 'bool'},
        'allow_remote_vnet_to_use_hub_vnet_gateways': {'key': 'properties.allowRemoteVnetToUseHubVnetGateways', 'type': 'bool'},
        'enable_internet_security': {'key': 'properties.enableInternetSecurity', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, remote_virtual_network=None, allow_hub_to_remote_vnet_transit: bool=None, allow_remote_vnet_to_use_hub_vnet_gateways: bool=None, enable_internet_security: bool=None, name: str=None, **kwargs) -> None:
        super(HubVirtualNetworkConnection, self).__init__(id=id, **kwargs)
        self.remote_virtual_network = remote_virtual_network
        self.allow_hub_to_remote_vnet_transit = allow_hub_to_remote_vnet_transit
        self.allow_remote_vnet_to_use_hub_vnet_gateways = allow_remote_vnet_to_use_hub_vnet_gateways
        self.enable_internet_security = enable_internet_security
        self.provisioning_state = None
        self.name = name
        self.etag = None


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param protocol: Required. The reference to the transport protocol used by
     the inbound NAT pool. Possible values include: 'Udp', 'Tcp', 'All'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.TransportProtocol
    :param frontend_port_range_start: Required. The first port number in the
     range of external ports that will be used to provide Inbound Nat to NICs
     associated with a load balancer. Acceptable values range between 1 and
     65534.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: Required. The last port number in the
     range of external ports that will be used to provide Inbound Nat to NICs
     associated with a load balancer. Acceptable values range between 1 and
     65535.
    :type frontend_port_range_end: int
    :param backend_port: Required. The port used for internal connections on
     the endpoint. Acceptable values are between 1 and 65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection.
     The value can be set between 4 and 30 minutes. The default value is 4
     minutes. This element is only used when the protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the
     floating IP capability required to configure a SQL AlwaysOn Availability
     Group. This setting is required when using the SQL AlwaysOn Availability
     Groups in SQL server. This setting can't be changed after you create the
     endpoint.
    :type enable_floating_ip: bool
    :param enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle
     timeout or unexpected connection termination. This element is only used
     when the protocol is set to TCP.
    :type enable_tcp_reset: bool
    :ivar provisioning_state: The provisioning state of the inbound NAT pool
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the set of
     inbound NAT pools used by the load balancer. This name can be used to
     access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'protocol': {'required': True},
        'frontend_port_range_start': {'required': True},
        'frontend_port_range_end': {'required': True},
        'backend_port': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port_range_start': {'key': 'properties.frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'properties.frontendPortRangeEnd', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'enable_tcp_reset': {'key': 'properties.enableTcpReset', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, protocol, frontend_port_range_start: int, frontend_port_range_end: int, backend_port: int, id: str=None, frontend_ip_configuration=None, idle_timeout_in_minutes: int=None, enable_floating_ip: bool=None, enable_tcp_reset: bool=None, name: str=None, **kwargs) -> None:
        super(InboundNatPool, self).__init__(id=id, **kwargs)
        self.frontend_ip_configuration = frontend_ip_configuration
        self.protocol = protocol
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class InboundNatRule(SubResource):
    """Inbound NAT rule of the load balancer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address
     defined on a network interface of a VM. Traffic sent to the frontend port
     of each of the frontend IP configurations is forwarded to the backend IP.
    :vartype backend_ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceIPConfiguration
    :param protocol: The reference to the transport protocol used by the load
     balancing rule. Possible values include: 'Udp', 'Tcp', 'All'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.TransportProtocol
    :param frontend_port: The port for the external endpoint. Port numbers for
     each rule must be unique within the Load Balancer. Acceptable values range
     from 1 to 65534.
    :type frontend_port: int
    :param backend_port: The port used for the internal endpoint. Acceptable
     values range from 1 to 65535.
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection.
     The value can be set between 4 and 30 minutes. The default value is 4
     minutes. This element is only used when the protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the
     floating IP capability required to configure a SQL AlwaysOn Availability
     Group. This setting is required when using the SQL AlwaysOn Availability
     Groups in SQL server. This setting can't be changed after you create the
     endpoint.
    :type enable_floating_ip: bool
    :param enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle
     timeout or unexpected connection termination. This element is only used
     when the protocol is set to TCP.
    :type enable_tcp_reset: bool
    :ivar provisioning_state: The provisioning state of the inbound NAT rule
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the set of
     inbound NAT rules used by the load balancer. This name can be used to
     access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'backend_ip_configuration': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_ip_configuration': {'key': 'properties.backendIPConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'enable_tcp_reset': {'key': 'properties.enableTcpReset', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, frontend_ip_configuration=None, protocol=None, frontend_port: int=None, backend_port: int=None, idle_timeout_in_minutes: int=None, enable_floating_ip: bool=None, enable_tcp_reset: bool=None, name: str=None, **kwargs) -> None:
        super(InboundNatRule, self).__init__(id=id, **kwargs)
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_ip_configuration = None
        self.protocol = protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class IPAddressAvailabilityResult(Model):
    """Response for CheckIPAddressAvailability API service call.

    :param available: Private IP address availability.
    :type available: bool
    :param available_ip_addresses: Contains other available private IP
     addresses if the asked for address is taken.
    :type available_ip_addresses: list[str]
    """

    _attribute_map = {
        'available': {'key': 'available', 'type': 'bool'},
        'available_ip_addresses': {'key': 'availableIPAddresses', 'type': '[str]'},
    }

    def __init__(self, *, available: bool=None, available_ip_addresses=None, **kwargs) -> None:
        super(IPAddressAvailabilityResult, self).__init__(**kwargs)
        self.available = available
        self.available_ip_addresses = available_ip_addresses


class IPConfiguration(SubResource):
    """IP configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP address allocation
     method. Possible values include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_09_01.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.Subnet
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2019_09_01.models.PublicIPAddress
    :ivar provisioning_state: The provisioning state of the IP configuration
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, private_ip_address: str=None, private_ip_allocation_method=None, subnet=None, public_ip_address=None, name: str=None, **kwargs) -> None:
        super(IPConfiguration, self).__init__(id=id, **kwargs)
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None
        self.name = name
        self.etag = None


class IPConfigurationProfile(SubResource):
    """IP configuration profile child resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param subnet: The reference of the subnet resource to create a container
     network interface ip configuration.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.Subnet
    :ivar provisioning_state: The provisioning state of the IP configuration
     profile resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource. This name can be used to access the
     resource.
    :type name: str
    :ivar type: Sub Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, subnet=None, name: str=None, **kwargs) -> None:
        super(IPConfigurationProfile, self).__init__(id=id, **kwargs)
        self.subnet = subnet
        self.provisioning_state = None
        self.name = name
        self.type = None
        self.etag = None


class IpGroup(Resource):
    """The IpGroups resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the IpGroups resource.
     Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param ip_addresses: IpAddresses/IpAddressPrefixes in the IpGroups
     resource.
    :type ip_addresses: list[str]
    :ivar firewalls: List of references to Azure resources that this IpGroups
     is associated with
    :vartype firewalls:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'firewalls': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'ip_addresses': {'key': 'properties.ipAddresses', 'type': '[str]'},
        'firewalls': {'key': 'properties.firewalls', 'type': '[SubResource]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, ip_addresses=None, **kwargs) -> None:
        super(IpGroup, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.ip_addresses = ip_addresses
        self.firewalls = None
        self.etag = None


class IpsecPolicy(Model):
    """An IPSec Policy configuration for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :param sa_life_time_seconds: Required. The IPSec Security Association
     (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to
     site VPN tunnel.
    :type sa_life_time_seconds: int
    :param sa_data_size_kilobytes: Required. The IPSec Security Association
     (also called Quick Mode or Phase 2 SA) payload size in KB for a site to
     site VPN tunnel.
    :type sa_data_size_kilobytes: int
    :param ipsec_encryption: Required. The IPSec encryption algorithm (IKE
     phase 1). Possible values include: 'None', 'DES', 'DES3', 'AES128',
     'AES192', 'AES256', 'GCMAES128', 'GCMAES192', 'GCMAES256'
    :type ipsec_encryption: str or
     ~azure.mgmt.network.v2019_09_01.models.IpsecEncryption
    :param ipsec_integrity: Required. The IPSec integrity algorithm (IKE phase
     1). Possible values include: 'MD5', 'SHA1', 'SHA256', 'GCMAES128',
     'GCMAES192', 'GCMAES256'
    :type ipsec_integrity: str or
     ~azure.mgmt.network.v2019_09_01.models.IpsecIntegrity
    :param ike_encryption: Required. The IKE encryption algorithm (IKE phase
     2). Possible values include: 'DES', 'DES3', 'AES128', 'AES192', 'AES256',
     'GCMAES256', 'GCMAES128'
    :type ike_encryption: str or
     ~azure.mgmt.network.v2019_09_01.models.IkeEncryption
    :param ike_integrity: Required. The IKE integrity algorithm (IKE phase 2).
     Possible values include: 'MD5', 'SHA1', 'SHA256', 'SHA384', 'GCMAES256',
     'GCMAES128'
    :type ike_integrity: str or
     ~azure.mgmt.network.v2019_09_01.models.IkeIntegrity
    :param dh_group: Required. The DH Group used in IKE Phase 1 for initial
     SA. Possible values include: 'None', 'DHGroup1', 'DHGroup2', 'DHGroup14',
     'DHGroup2048', 'ECP256', 'ECP384', 'DHGroup24'
    :type dh_group: str or ~azure.mgmt.network.v2019_09_01.models.DhGroup
    :param pfs_group: Required. The Pfs Group used in IKE Phase 2 for new
     child SA. Possible values include: 'None', 'PFS1', 'PFS2', 'PFS2048',
     'ECP256', 'ECP384', 'PFS24', 'PFS14', 'PFSMM'
    :type pfs_group: str or ~azure.mgmt.network.v2019_09_01.models.PfsGroup
    """

    _validation = {
        'sa_life_time_seconds': {'required': True},
        'sa_data_size_kilobytes': {'required': True},
        'ipsec_encryption': {'required': True},
        'ipsec_integrity': {'required': True},
        'ike_encryption': {'required': True},
        'ike_integrity': {'required': True},
        'dh_group': {'required': True},
        'pfs_group': {'required': True},
    }

    _attribute_map = {
        'sa_life_time_seconds': {'key': 'saLifeTimeSeconds', 'type': 'int'},
        'sa_data_size_kilobytes': {'key': 'saDataSizeKilobytes', 'type': 'int'},
        'ipsec_encryption': {'key': 'ipsecEncryption', 'type': 'str'},
        'ipsec_integrity': {'key': 'ipsecIntegrity', 'type': 'str'},
        'ike_encryption': {'key': 'ikeEncryption', 'type': 'str'},
        'ike_integrity': {'key': 'ikeIntegrity', 'type': 'str'},
        'dh_group': {'key': 'dhGroup', 'type': 'str'},
        'pfs_group': {'key': 'pfsGroup', 'type': 'str'},
    }

    def __init__(self, *, sa_life_time_seconds: int, sa_data_size_kilobytes: int, ipsec_encryption, ipsec_integrity, ike_encryption, ike_integrity, dh_group, pfs_group, **kwargs) -> None:
        super(IpsecPolicy, self).__init__(**kwargs)
        self.sa_life_time_seconds = sa_life_time_seconds
        self.sa_data_size_kilobytes = sa_data_size_kilobytes
        self.ipsec_encryption = ipsec_encryption
        self.ipsec_integrity = ipsec_integrity
        self.ike_encryption = ike_encryption
        self.ike_integrity = ike_integrity
        self.dh_group = dh_group
        self.pfs_group = pfs_group


class IpTag(Model):
    """Contains the IpTag associated with the object.

    :param ip_tag_type: The IP tag type. Example: FirstPartyUsage.
    :type ip_tag_type: str
    :param tag: The value of the IP tag associated with the public IP.
     Example: SQL.
    :type tag: str
    """

    _attribute_map = {
        'ip_tag_type': {'key': 'ipTagType', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(self, *, ip_tag_type: str=None, tag: str=None, **kwargs) -> None:
        super(IpTag, self).__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class Ipv6ExpressRouteCircuitPeeringConfig(Model):
    """Contains IPv6 peering config.

    :param primary_peer_address_prefix: The primary address prefix.
    :type primary_peer_address_prefix: str
    :param secondary_peer_address_prefix: The secondary address prefix.
    :type secondary_peer_address_prefix: str
    :param microsoft_peering_config: The Microsoft peering configuration.
    :type microsoft_peering_config:
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeeringConfig
    :param route_filter: The reference of the RouteFilter resource.
    :type route_filter: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param state: The state of peering. Possible values include: 'Disabled',
     'Enabled'
    :type state: str or
     ~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeeringState
    """

    _attribute_map = {
        'primary_peer_address_prefix': {'key': 'primaryPeerAddressPrefix', 'type': 'str'},
        'secondary_peer_address_prefix': {'key': 'secondaryPeerAddressPrefix', 'type': 'str'},
        'microsoft_peering_config': {'key': 'microsoftPeeringConfig', 'type': 'ExpressRouteCircuitPeeringConfig'},
        'route_filter': {'key': 'routeFilter', 'type': 'SubResource'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(self, *, primary_peer_address_prefix: str=None, secondary_peer_address_prefix: str=None, microsoft_peering_config=None, route_filter=None, state=None, **kwargs) -> None:
        super(Ipv6ExpressRouteCircuitPeeringConfig, self).__init__(**kwargs)
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.microsoft_peering_config = microsoft_peering_config
        self.route_filter = route_filter
        self.state = state


class LoadBalancer(Resource):
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The load balancer SKU.
    :type sku: ~azure.mgmt.network.v2019_09_01.models.LoadBalancerSku
    :param frontend_ip_configurations: Object representing the frontend IPs to
     be used for the load balancer.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.FrontendIPConfiguration]
    :param backend_address_pools: Collection of backend address pools used by
     a load balancer.
    :type backend_address_pools:
     list[~azure.mgmt.network.v2019_09_01.models.BackendAddressPool]
    :param load_balancing_rules: Object collection representing the load
     balancing rules Gets the provisioning.
    :type load_balancing_rules:
     list[~azure.mgmt.network.v2019_09_01.models.LoadBalancingRule]
    :param probes: Collection of probe objects used in the load balancer.
    :type probes: list[~azure.mgmt.network.v2019_09_01.models.Probe]
    :param inbound_nat_rules: Collection of inbound NAT Rules used by a load
     balancer. Defining inbound NAT rules on your load balancer is mutually
     exclusive with defining an inbound NAT pool. Inbound NAT pools are
     referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an Inbound NAT pool. They
     have to reference individual inbound NAT rules.
    :type inbound_nat_rules:
     list[~azure.mgmt.network.v2019_09_01.models.InboundNatRule]
    :param inbound_nat_pools: Defines an external port range for inbound NAT
     to a single backend port on NICs associated with a load balancer. Inbound
     NAT rules are created automatically for each NIC associated with the Load
     Balancer using an external port from this range. Defining an Inbound NAT
     pool on your Load Balancer is mutually exclusive with defining inbound Nat
     rules. Inbound NAT pools are referenced from virtual machine scale sets.
     NICs that are associated with individual virtual machines cannot reference
     an inbound NAT pool. They have to reference individual inbound NAT rules.
    :type inbound_nat_pools:
     list[~azure.mgmt.network.v2019_09_01.models.InboundNatPool]
    :param outbound_rules: The outbound rules.
    :type outbound_rules:
     list[~azure.mgmt.network.v2019_09_01.models.OutboundRule]
    :ivar resource_guid: The resource GUID property of the load balancer
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the load balancer
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'LoadBalancerSku'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[FrontendIPConfiguration]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'probes': {'key': 'properties.probes', 'type': '[Probe]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[InboundNatRule]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[InboundNatPool]'},
        'outbound_rules': {'key': 'properties.outboundRules', 'type': '[OutboundRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, sku=None, frontend_ip_configurations=None, backend_address_pools=None, load_balancing_rules=None, probes=None, inbound_nat_rules=None, inbound_nat_pools=None, outbound_rules=None, **kwargs) -> None:
        super(LoadBalancer, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_rules = outbound_rules
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None


class LoadBalancerSku(Model):
    """SKU of a load balancer.

    :param name: Name of a load balancer SKU. Possible values include:
     'Basic', 'Standard'
    :type name: str or
     ~azure.mgmt.network.v2019_09_01.models.LoadBalancerSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name=None, **kwargs) -> None:
        super(LoadBalancerSku, self).__init__(**kwargs)
        self.name = name


class LoadBalancingRule(SubResource):
    """A load balancing rule for a load balancer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param frontend_ip_configuration: A reference to frontend IP addresses.
    :type frontend_ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param backend_address_pool: A reference to a pool of DIPs. Inbound
     traffic is randomly load balanced across IPs in the backend IPs.
    :type backend_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param probe: The reference of the load balancer probe used by the load
     balancing rule.
    :type probe: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param protocol: Required. The reference to the transport protocol used by
     the load balancing rule. Possible values include: 'Udp', 'Tcp', 'All'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.TransportProtocol
    :param load_distribution: The load distribution policy for this rule.
     Possible values include: 'Default', 'SourceIP', 'SourceIPProtocol'
    :type load_distribution: str or
     ~azure.mgmt.network.v2019_09_01.models.LoadDistribution
    :param frontend_port: Required. The port for the external endpoint. Port
     numbers for each rule must be unique within the Load Balancer. Acceptable
     values are between 0 and 65534. Note that value 0 enables "Any Port".
    :type frontend_port: int
    :param backend_port: The port used for internal connections on the
     endpoint. Acceptable values are between 0 and 65535. Note that value 0
     enables "Any Port".
    :type backend_port: int
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection.
     The value can be set between 4 and 30 minutes. The default value is 4
     minutes. This element is only used when the protocol is set to TCP.
    :type idle_timeout_in_minutes: int
    :param enable_floating_ip: Configures a virtual machine's endpoint for the
     floating IP capability required to configure a SQL AlwaysOn Availability
     Group. This setting is required when using the SQL AlwaysOn Availability
     Groups in SQL server. This setting can't be changed after you create the
     endpoint.
    :type enable_floating_ip: bool
    :param enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle
     timeout or unexpected connection termination. This element is only used
     when the protocol is set to TCP.
    :type enable_tcp_reset: bool
    :param disable_outbound_snat: Configures SNAT for the VMs in the backend
     pool to use the publicIP address specified in the frontend of the load
     balancing rule.
    :type disable_outbound_snat: bool
    :ivar provisioning_state: The provisioning state of the load balancing
     rule resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the set of
     load balancing rules used by the load balancer. This name can be used to
     access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'protocol': {'required': True},
        'frontend_port': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_ip_configuration': {'key': 'properties.frontendIPConfiguration', 'type': 'SubResource'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'load_distribution': {'key': 'properties.loadDistribution', 'type': 'str'},
        'frontend_port': {'key': 'properties.frontendPort', 'type': 'int'},
        'backend_port': {'key': 'properties.backendPort', 'type': 'int'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'enable_floating_ip': {'key': 'properties.enableFloatingIP', 'type': 'bool'},
        'enable_tcp_reset': {'key': 'properties.enableTcpReset', 'type': 'bool'},
        'disable_outbound_snat': {'key': 'properties.disableOutboundSnat', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, protocol, frontend_port: int, id: str=None, frontend_ip_configuration=None, backend_address_pool=None, probe=None, load_distribution=None, backend_port: int=None, idle_timeout_in_minutes: int=None, enable_floating_ip: bool=None, enable_tcp_reset: bool=None, disable_outbound_snat: bool=None, name: str=None, **kwargs) -> None:
        super(LoadBalancingRule, self).__init__(id=id, **kwargs)
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_address_pool = backend_address_pool
        self.probe = probe
        self.protocol = protocol
        self.load_distribution = load_distribution
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.enable_tcp_reset = enable_tcp_reset
        self.disable_outbound_snat = disable_outbound_snat
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class LocalNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param local_network_address_space: Local network site address space.
    :type local_network_address_space:
     ~azure.mgmt.network.v2019_09_01.models.AddressSpace
    :param gateway_ip_address: IP address of local network gateway.
    :type gateway_ip_address: str
    :param bgp_settings: Local network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2019_09_01.models.BgpSettings
    :ivar resource_guid: The resource GUID property of the local network
     gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the local network
     gateway resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'local_network_address_space': {'key': 'properties.localNetworkAddressSpace', 'type': 'AddressSpace'},
        'gateway_ip_address': {'key': 'properties.gatewayIpAddress', 'type': 'str'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, local_network_address_space=None, gateway_ip_address: str=None, bgp_settings=None, **kwargs) -> None:
        super(LocalNetworkGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.local_network_address_space = local_network_address_space
        self.gateway_ip_address = gateway_ip_address
        self.bgp_settings = bgp_settings
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None


class LogSpecification(Model):
    """Description of logging specification.

    :param name: The name of the specification.
    :type name: str
    :param display_name: The display name of the specification.
    :type display_name: str
    :param blob_duration: Duration of the blob.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, blob_duration: str=None, **kwargs) -> None:
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagedRuleGroupOverride(Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. Describes the managed rule group to
     override.
    :type rule_group_name: str
    :param rules: List of rules that will be disabled. If none specified, all
     rules in the group will be disabled.
    :type rules:
     list[~azure.mgmt.network.v2019_09_01.models.ManagedRuleOverride]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleOverride]'},
    }

    def __init__(self, *, rule_group_name: str, rules=None, **kwargs) -> None:
        super(ManagedRuleGroupOverride, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.rules = rules


class ManagedRuleOverride(Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. Identifier for the managed rule.
    :type rule_id: str
    :param state: Describes the state of the managed rule. Defaults to
     Disabled if not specified. Possible values include: 'Disabled'
    :type state: str or
     ~azure.mgmt.network.v2019_09_01.models.ManagedRuleEnabledState
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(self, *, rule_id: str, state=None, **kwargs) -> None:
        super(ManagedRuleOverride, self).__init__(**kwargs)
        self.rule_id = rule_id
        self.state = state


class ManagedRulesDefinition(Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :param exclusions: Describes the Exclusions that are applied on the
     policy.
    :type exclusions:
     list[~azure.mgmt.network.v2019_09_01.models.OwaspCrsExclusionEntry]
    :param managed_rule_sets: Required. Describes the ruleSets that are
     associated with the policy.
    :type managed_rule_sets:
     list[~azure.mgmt.network.v2019_09_01.models.ManagedRuleSet]
    """

    _validation = {
        'managed_rule_sets': {'required': True},
    }

    _attribute_map = {
        'exclusions': {'key': 'exclusions', 'type': '[OwaspCrsExclusionEntry]'},
        'managed_rule_sets': {'key': 'managedRuleSets', 'type': '[ManagedRuleSet]'},
    }

    def __init__(self, *, managed_rule_sets, exclusions=None, **kwargs) -> None:
        super(ManagedRulesDefinition, self).__init__(**kwargs)
        self.exclusions = exclusions
        self.managed_rule_sets = managed_rule_sets


class ManagedRuleSet(Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :param rule_set_type: Required. Defines the rule set type to use.
    :type rule_set_type: str
    :param rule_set_version: Required. Defines the version of the rule set to
     use.
    :type rule_set_version: str
    :param rule_group_overrides: Defines the rule group overrides to apply to
     the rule set.
    :type rule_group_overrides:
     list[~azure.mgmt.network.v2019_09_01.models.ManagedRuleGroupOverride]
    """

    _validation = {
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
    }

    _attribute_map = {
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'rule_group_overrides': {'key': 'ruleGroupOverrides', 'type': '[ManagedRuleGroupOverride]'},
    }

    def __init__(self, *, rule_set_type: str, rule_set_version: str, rule_group_overrides=None, **kwargs) -> None:
        super(ManagedRuleSet, self).__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.rule_group_overrides = rule_group_overrides


class ManagedServiceIdentity(Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of the system assigned identity. This
     property will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity. This
     property will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the resource. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created
     identity and a set of user assigned identities. The type 'None' will
     remove any identities from the virtual machine. Possible values include:
     'SystemAssigned', 'UserAssigned', 'SystemAssigned, UserAssigned', 'None'
    :type type: str or
     ~azure.mgmt.network.v2019_09_01.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated
     with resource. The user identity dictionary key references will be ARM
     resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.network.v2019_09_01.models.ManagedServiceIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ManagedServiceIdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(self, *, type=None, user_assigned_identities=None, **kwargs) -> None:
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ManagedServiceIdentityUserAssignedIdentitiesValue(Model):
    """ManagedServiceIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ManagedServiceIdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class MatchCondition(Model):
    """Define match conditions.

    All required parameters must be populated in order to send to Azure.

    :param match_variables: Required. List of match variables.
    :type match_variables:
     list[~azure.mgmt.network.v2019_09_01.models.MatchVariable]
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'IPMatch', 'Equal', 'Contains', 'LessThan', 'GreaterThan',
     'LessThanOrEqual', 'GreaterThanOrEqual', 'BeginsWith', 'EndsWith',
     'Regex', 'GeoMatch'
    :type operator: str or
     ~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallOperator
    :param negation_conditon: Describes if this is negate condition or not.
    :type negation_conditon: bool
    :param match_values: Required. Match value.
    :type match_values: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or
     ~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallTransform]
    """

    _validation = {
        'match_variables': {'required': True},
        'operator': {'required': True},
        'match_values': {'required': True},
    }

    _attribute_map = {
        'match_variables': {'key': 'matchVariables', 'type': '[MatchVariable]'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negation_conditon': {'key': 'negationConditon', 'type': 'bool'},
        'match_values': {'key': 'matchValues', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    def __init__(self, *, match_variables, operator, match_values, negation_conditon: bool=None, transforms=None, **kwargs) -> None:
        super(MatchCondition, self).__init__(**kwargs)
        self.match_variables = match_variables
        self.operator = operator
        self.negation_conditon = negation_conditon
        self.match_values = match_values
        self.transforms = transforms


class MatchedRule(Model):
    """Matched rule.

    :param rule_name: Name of the matched network security rule.
    :type rule_name: str
    :param action: The network traffic is allowed or denied. Possible values
     are 'Allow' and 'Deny'.
    :type action: str
    """

    _attribute_map = {
        'rule_name': {'key': 'ruleName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(self, *, rule_name: str=None, action: str=None, **kwargs) -> None:
        super(MatchedRule, self).__init__(**kwargs)
        self.rule_name = rule_name
        self.action = action


class MatchVariable(Model):
    """Define match variables.

    All required parameters must be populated in order to send to Azure.

    :param variable_name: Required. Match Variable. Possible values include:
     'RemoteAddr', 'RequestMethod', 'QueryString', 'PostArgs', 'RequestUri',
     'RequestHeaders', 'RequestBody', 'RequestCookies'
    :type variable_name: str or
     ~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallMatchVariable
    :param selector: Describes field of the matchVariable collection.
    :type selector: str
    """

    _validation = {
        'variable_name': {'required': True},
    }

    _attribute_map = {
        'variable_name': {'key': 'variableName', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
    }

    def __init__(self, *, variable_name, selector: str=None, **kwargs) -> None:
        super(MatchVariable, self).__init__(**kwargs)
        self.variable_name = variable_name
        self.selector = selector


class MetricSpecification(Model):
    """Description of metrics specification.

    :param name: The name of the metric.
    :type name: str
    :param display_name: The display name of the metric.
    :type display_name: str
    :param display_description: The description of the metric.
    :type display_description: str
    :param unit: Units the metric to be displayed in.
    :type unit: str
    :param aggregation_type: The aggregation type.
    :type aggregation_type: str
    :param availabilities: List of availability.
    :type availabilities:
     list[~azure.mgmt.network.v2019_09_01.models.Availability]
    :param enable_regional_mdm_account: Whether regional MDM account enabled.
    :type enable_regional_mdm_account: bool
    :param fill_gap_with_zero: Whether gaps would be filled with zeros.
    :type fill_gap_with_zero: bool
    :param metric_filter_pattern: Pattern for the filter of the metric.
    :type metric_filter_pattern: str
    :param dimensions: List of dimensions.
    :type dimensions: list[~azure.mgmt.network.v2019_09_01.models.Dimension]
    :param is_internal: Whether the metric is internal.
    :type is_internal: bool
    :param source_mdm_account: The source MDM account.
    :type source_mdm_account: str
    :param source_mdm_namespace: The source MDM namespace.
    :type source_mdm_namespace: str
    :param resource_id_dimension_name_override: The resource Id dimension name
     override.
    :type resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[Availability]'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display_name: str=None, display_description: str=None, unit: str=None, aggregation_type: str=None, availabilities=None, enable_regional_mdm_account: bool=None, fill_gap_with_zero: bool=None, metric_filter_pattern: str=None, dimensions=None, is_internal: bool=None, source_mdm_account: str=None, source_mdm_namespace: str=None, resource_id_dimension_name_override: str=None, **kwargs) -> None:
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.availabilities = availabilities
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.fill_gap_with_zero = fill_gap_with_zero
        self.metric_filter_pattern = metric_filter_pattern
        self.dimensions = dimensions
        self.is_internal = is_internal
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.resource_id_dimension_name_override = resource_id_dimension_name_override


class NatGateway(Resource):
    """Nat Gateway resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The nat gateway SKU.
    :type sku: ~azure.mgmt.network.v2019_09_01.models.NatGatewaySku
    :param idle_timeout_in_minutes: The idle timeout of the nat gateway.
    :type idle_timeout_in_minutes: int
    :param public_ip_addresses: An array of public ip addresses associated
     with the nat gateway resource.
    :type public_ip_addresses:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param public_ip_prefixes: An array of public ip prefixes associated with
     the nat gateway resource.
    :type public_ip_prefixes:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar subnets: An array of references to the subnets using this nat
     gateway resource.
    :vartype subnets: list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar resource_guid: The resource GUID property of the NAT gateway
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the NAT gateway
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param zones: A list of availability zones denoting the zone in which Nat
     Gateway should be deployed.
    :type zones: list[str]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subnets': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'NatGatewaySku'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'public_ip_addresses': {'key': 'properties.publicIpAddresses', 'type': '[SubResource]'},
        'public_ip_prefixes': {'key': 'properties.publicIpPrefixes', 'type': '[SubResource]'},
        'subnets': {'key': 'properties.subnets', 'type': '[SubResource]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, sku=None, idle_timeout_in_minutes: int=None, public_ip_addresses=None, public_ip_prefixes=None, zones=None, **kwargs) -> None:
        super(NatGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.public_ip_addresses = public_ip_addresses
        self.public_ip_prefixes = public_ip_prefixes
        self.subnets = None
        self.resource_guid = None
        self.provisioning_state = None
        self.zones = zones
        self.etag = None


class NatGatewaySku(Model):
    """SKU of nat gateway.

    :param name: Name of Nat Gateway SKU. Possible values include: 'Standard'
    :type name: str or
     ~azure.mgmt.network.v2019_09_01.models.NatGatewaySkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name=None, **kwargs) -> None:
        super(NatGatewaySku, self).__init__(**kwargs)
        self.name = name


class NetworkConfigurationDiagnosticParameters(Model):
    """Parameters to get network configuration diagnostic.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the target resource to
     perform network configuration diagnostic. Valid options are VM,
     NetworkInterface, VMSS/NetworkInterface and Application Gateway.
    :type target_resource_id: str
    :param verbosity_level: Verbosity level. Possible values include:
     'Normal', 'Minimum', 'Full'
    :type verbosity_level: str or
     ~azure.mgmt.network.v2019_09_01.models.VerbosityLevel
    :param profiles: Required. List of network configuration diagnostic
     profiles.
    :type profiles:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkConfigurationDiagnosticProfile]
    """

    _validation = {
        'target_resource_id': {'required': True},
        'profiles': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'verbosity_level': {'key': 'verbosityLevel', 'type': 'str'},
        'profiles': {'key': 'profiles', 'type': '[NetworkConfigurationDiagnosticProfile]'},
    }

    def __init__(self, *, target_resource_id: str, profiles, verbosity_level=None, **kwargs) -> None:
        super(NetworkConfigurationDiagnosticParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.verbosity_level = verbosity_level
        self.profiles = profiles


class NetworkConfigurationDiagnosticProfile(Model):
    """Parameters to compare with network configuration.

    All required parameters must be populated in order to send to Azure.

    :param direction: Required. The direction of the traffic. Possible values
     include: 'Inbound', 'Outbound'
    :type direction: str or ~azure.mgmt.network.v2019_09_01.models.Direction
    :param protocol: Required. Protocol to be verified on. Accepted values are
     '*', TCP, UDP.
    :type protocol: str
    :param source: Required. Traffic source. Accepted values are '*', IP
     Address/CIDR, Service Tag.
    :type source: str
    :param destination: Required. Traffic destination. Accepted values are:
     '*', IP Address/CIDR, Service Tag.
    :type destination: str
    :param destination_port: Required. Traffic destination port. Accepted
     values are '*' and a single port in the range (0 - 65535).
    :type destination_port: str
    """

    _validation = {
        'direction': {'required': True},
        'protocol': {'required': True},
        'source': {'required': True},
        'destination': {'required': True},
        'destination_port': {'required': True},
    }

    _attribute_map = {
        'direction': {'key': 'direction', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'str'},
        'destination_port': {'key': 'destinationPort', 'type': 'str'},
    }

    def __init__(self, *, direction, protocol: str, source: str, destination: str, destination_port: str, **kwargs) -> None:
        super(NetworkConfigurationDiagnosticProfile, self).__init__(**kwargs)
        self.direction = direction
        self.protocol = protocol
        self.source = source
        self.destination = destination
        self.destination_port = destination_port


class NetworkConfigurationDiagnosticResponse(Model):
    """Results of network configuration diagnostic on the target resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar results: List of network configuration diagnostic results.
    :vartype results:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkConfigurationDiagnosticResult]
    """

    _validation = {
        'results': {'readonly': True},
    }

    _attribute_map = {
        'results': {'key': 'results', 'type': '[NetworkConfigurationDiagnosticResult]'},
    }

    def __init__(self, **kwargs) -> None:
        super(NetworkConfigurationDiagnosticResponse, self).__init__(**kwargs)
        self.results = None


class NetworkConfigurationDiagnosticResult(Model):
    """Network configuration diagnostic result corresponded to provided traffic
    query.

    :param profile: Network configuration diagnostic profile.
    :type profile:
     ~azure.mgmt.network.v2019_09_01.models.NetworkConfigurationDiagnosticProfile
    :param network_security_group_result: Network security group result.
    :type network_security_group_result:
     ~azure.mgmt.network.v2019_09_01.models.NetworkSecurityGroupResult
    """

    _attribute_map = {
        'profile': {'key': 'profile', 'type': 'NetworkConfigurationDiagnosticProfile'},
        'network_security_group_result': {'key': 'networkSecurityGroupResult', 'type': 'NetworkSecurityGroupResult'},
    }

    def __init__(self, *, profile=None, network_security_group_result=None, **kwargs) -> None:
        super(NetworkConfigurationDiagnosticResult, self).__init__(**kwargs)
        self.profile = profile
        self.network_security_group_result = network_security_group_result


class NetworkIntentPolicy(Resource):
    """Network Intent Policy resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, **kwargs) -> None:
        super(NetworkIntentPolicy, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None


class NetworkIntentPolicyConfiguration(Model):
    """Details of NetworkIntentPolicyConfiguration for
    PrepareNetworkPoliciesRequest.

    :param network_intent_policy_name: The name of the Network Intent Policy
     for storing in target subscription.
    :type network_intent_policy_name: str
    :param source_network_intent_policy: Source network intent policy.
    :type source_network_intent_policy:
     ~azure.mgmt.network.v2019_09_01.models.NetworkIntentPolicy
    """

    _attribute_map = {
        'network_intent_policy_name': {'key': 'networkIntentPolicyName', 'type': 'str'},
        'source_network_intent_policy': {'key': 'sourceNetworkIntentPolicy', 'type': 'NetworkIntentPolicy'},
    }

    def __init__(self, *, network_intent_policy_name: str=None, source_network_intent_policy=None, **kwargs) -> None:
        super(NetworkIntentPolicyConfiguration, self).__init__(**kwargs)
        self.network_intent_policy_name = network_intent_policy_name
        self.source_network_intent_policy = source_network_intent_policy


class NetworkInterface(Resource):
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar virtual_machine: The reference of a virtual machine.
    :vartype virtual_machine:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param network_security_group: The reference of the NetworkSecurityGroup
     resource.
    :type network_security_group:
     ~azure.mgmt.network.v2019_09_01.models.NetworkSecurityGroup
    :ivar private_endpoint: A reference to the private endpoint to which the
     network interface is linked.
    :vartype private_endpoint:
     ~azure.mgmt.network.v2019_09_01.models.PrivateEndpoint
    :param ip_configurations: A list of IPConfigurations of the network
     interface.
    :type ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceIPConfiguration]
    :ivar tap_configurations: A list of TapConfigurations of the network
     interface.
    :vartype tap_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceTapConfiguration]
    :param dns_settings: The DNS settings in network interface.
    :type dns_settings:
     ~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceDnsSettings
    :ivar mac_address: The MAC address of the network interface.
    :vartype mac_address: str
    :ivar primary: Whether this is a primary network interface on a virtual
     machine.
    :vartype primary: bool
    :param enable_accelerated_networking: If the network interface is
     accelerated networking enabled.
    :type enable_accelerated_networking: bool
    :param enable_ip_forwarding: Indicates whether IP forwarding is enabled on
     this network interface.
    :type enable_ip_forwarding: bool
    :ivar hosted_workloads: A list of references to linked BareMetal
     resources.
    :vartype hosted_workloads: list[str]
    :ivar resource_guid: The resource GUID property of the network interface
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network interface
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_machine': {'readonly': True},
        'private_endpoint': {'readonly': True},
        'tap_configurations': {'readonly': True},
        'mac_address': {'readonly': True},
        'primary': {'readonly': True},
        'hosted_workloads': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'virtual_machine': {'key': 'properties.virtualMachine', 'type': 'SubResource'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'tap_configurations': {'key': 'properties.tapConfigurations', 'type': '[NetworkInterfaceTapConfiguration]'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'NetworkInterfaceDnsSettings'},
        'mac_address': {'key': 'properties.macAddress', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'hosted_workloads': {'key': 'properties.hostedWorkloads', 'type': '[str]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, network_security_group=None, ip_configurations=None, dns_settings=None, enable_accelerated_networking: bool=None, enable_ip_forwarding: bool=None, **kwargs) -> None:
        super(NetworkInterface, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.virtual_machine = None
        self.network_security_group = network_security_group
        self.private_endpoint = None
        self.ip_configurations = ip_configurations
        self.tap_configurations = None
        self.dns_settings = dns_settings
        self.mac_address = None
        self.primary = None
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_ip_forwarding = enable_ip_forwarding
        self.hosted_workloads = None
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None


class NetworkInterfaceAssociation(Model):
    """Network interface and its custom security rules.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Network interface ID.
    :vartype id: str
    :param security_rules: Collection of custom security rules.
    :type security_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SecurityRule]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[SecurityRule]'},
    }

    def __init__(self, *, security_rules=None, **kwargs) -> None:
        super(NetworkInterfaceAssociation, self).__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules


class NetworkInterfaceDnsSettings(Model):
    """DNS settings of a network interface.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param dns_servers: List of DNS servers IP addresses. Use
     'AzureProvidedDNS' to switch to azure provided DNS resolution.
     'AzureProvidedDNS' value cannot be combined with other IPs, it must be the
     only value in dnsServers collection.
    :type dns_servers: list[str]
    :ivar applied_dns_servers: If the VM that uses this NIC is part of an
     Availability Set, then this list will have the union of all DNS servers
     from all NICs that are part of the Availability Set. This property is what
     is configured on each of those VMs.
    :vartype applied_dns_servers: list[str]
    :param internal_dns_name_label: Relative DNS name for this NIC used for
     internal communications between VMs in the same virtual network.
    :type internal_dns_name_label: str
    :ivar internal_fqdn: Fully qualified DNS name supporting internal
     communications between VMs in the same virtual network.
    :vartype internal_fqdn: str
    :ivar internal_domain_name_suffix: Even if internalDnsNameLabel is not
     specified, a DNS entry is created for the primary NIC of the VM. This DNS
     name can be constructed by concatenating the VM name with the value of
     internalDomainNameSuffix.
    :vartype internal_domain_name_suffix: str
    """

    _validation = {
        'applied_dns_servers': {'readonly': True},
        'internal_fqdn': {'readonly': True},
        'internal_domain_name_suffix': {'readonly': True},
    }

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'applied_dns_servers': {'key': 'appliedDnsServers', 'type': '[str]'},
        'internal_dns_name_label': {'key': 'internalDnsNameLabel', 'type': 'str'},
        'internal_fqdn': {'key': 'internalFqdn', 'type': 'str'},
        'internal_domain_name_suffix': {'key': 'internalDomainNameSuffix', 'type': 'str'},
    }

    def __init__(self, *, dns_servers=None, internal_dns_name_label: str=None, **kwargs) -> None:
        super(NetworkInterfaceDnsSettings, self).__init__(**kwargs)
        self.dns_servers = dns_servers
        self.applied_dns_servers = None
        self.internal_dns_name_label = internal_dns_name_label
        self.internal_fqdn = None
        self.internal_domain_name_suffix = None


class NetworkInterfaceIPConfiguration(SubResource):
    """IPConfiguration in a network interface.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param virtual_network_taps: The reference to Virtual Network Taps.
    :type virtual_network_taps:
     list[~azure.mgmt.network.v2019_09_01.models.VirtualNetworkTap]
    :param application_gateway_backend_address_pools: The reference of
     ApplicationGatewayBackendAddressPool resource.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGatewayBackendAddressPool]
    :param load_balancer_backend_address_pools: The reference of
     LoadBalancerBackendAddressPool resource.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2019_09_01.models.BackendAddressPool]
    :param load_balancer_inbound_nat_rules: A list of references of
     LoadBalancerInboundNatRules.
    :type load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2019_09_01.models.InboundNatRule]
    :param private_ip_address: Private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP address allocation
     method. Possible values include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_09_01.models.IPAllocationMethod
    :param private_ip_address_version: Whether the specific IP configuration
     is IPv4 or IPv6. Default is IPv4. Possible values include: 'IPv4', 'IPv6'
    :type private_ip_address_version: str or
     ~azure.mgmt.network.v2019_09_01.models.IPVersion
    :param subnet: Subnet bound to the IP configuration.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.Subnet
    :param primary: Whether this is a primary customer address on the network
     interface.
    :type primary: bool
    :param public_ip_address: Public IP address bound to the IP configuration.
    :type public_ip_address:
     ~azure.mgmt.network.v2019_09_01.models.PublicIPAddress
    :param application_security_groups: Application security groups in which
     the IP configuration is included.
    :type application_security_groups:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationSecurityGroup]
    :ivar provisioning_state: The provisioning state of the network interface
     IP configuration. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar private_link_connection_properties: PrivateLinkConnection properties
     for the network interface.
    :vartype private_link_connection_properties:
     ~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'private_link_connection_properties': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'virtual_network_taps': {'key': 'properties.virtualNetworkTaps', 'type': '[VirtualNetworkTap]'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[ApplicationGatewayBackendAddressPool]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancer_inbound_nat_rules': {'key': 'properties.loadBalancerInboundNatRules', 'type': '[InboundNatRule]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'application_security_groups': {'key': 'properties.applicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_link_connection_properties': {'key': 'properties.privateLinkConnectionProperties', 'type': 'NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, virtual_network_taps=None, application_gateway_backend_address_pools=None, load_balancer_backend_address_pools=None, load_balancer_inbound_nat_rules=None, private_ip_address: str=None, private_ip_allocation_method=None, private_ip_address_version=None, subnet=None, primary: bool=None, public_ip_address=None, application_security_groups=None, name: str=None, **kwargs) -> None:
        super(NetworkInterfaceIPConfiguration, self).__init__(id=id, **kwargs)
        self.virtual_network_taps = virtual_network_taps
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.private_ip_address_version = private_ip_address_version
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address = public_ip_address
        self.application_security_groups = application_security_groups
        self.provisioning_state = None
        self.private_link_connection_properties = None
        self.name = name
        self.etag = None


class NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties(Model):
    """PrivateLinkConnection properties for the network interface.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar group_id: The group ID for current private link connection.
    :vartype group_id: str
    :ivar required_member_name: The required member name for current private
     link connection.
    :vartype required_member_name: str
    :ivar fqdns: List of FQDNs for current private link connection.
    :vartype fqdns: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_member_name': {'readonly': True},
        'fqdns': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_member_name': {'key': 'requiredMemberName', 'type': 'str'},
        'fqdns': {'key': 'fqdns', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(NetworkInterfaceIPConfigurationPrivateLinkConnectionProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_member_name = None
        self.fqdns = None


class NetworkInterfaceTapConfiguration(SubResource):
    """Tap configuration in a Network Interface.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param virtual_network_tap: The reference of the Virtual Network Tap
     resource.
    :type virtual_network_tap:
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkTap
    :ivar provisioning_state: The provisioning state of the network interface
     tap configuration resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Sub Resource type.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'virtual_network_tap': {'key': 'properties.virtualNetworkTap', 'type': 'VirtualNetworkTap'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, virtual_network_tap=None, name: str=None, **kwargs) -> None:
        super(NetworkInterfaceTapConfiguration, self).__init__(id=id, **kwargs)
        self.virtual_network_tap = virtual_network_tap
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class NetworkProfile(Resource):
    """Network profile resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar container_network_interfaces: List of child container network
     interfaces.
    :vartype container_network_interfaces:
     list[~azure.mgmt.network.v2019_09_01.models.ContainerNetworkInterface]
    :param container_network_interface_configurations: List of chid container
     network interface configurations.
    :type container_network_interface_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.ContainerNetworkInterfaceConfiguration]
    :ivar resource_guid: The resource GUID property of the network profile
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network profile
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'container_network_interfaces': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'container_network_interfaces': {'key': 'properties.containerNetworkInterfaces', 'type': '[ContainerNetworkInterface]'},
        'container_network_interface_configurations': {'key': 'properties.containerNetworkInterfaceConfigurations', 'type': '[ContainerNetworkInterfaceConfiguration]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, container_network_interface_configurations=None, **kwargs) -> None:
        super(NetworkProfile, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.container_network_interfaces = None
        self.container_network_interface_configurations = container_network_interface_configurations
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None


class NetworkRuleCondition(FirewallPolicyRuleCondition):
    """Rule condition of type network.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the rule condition.
    :type name: str
    :param description: Description of the rule condition.
    :type description: str
    :param rule_condition_type: Required. Constant filled by server.
    :type rule_condition_type: str
    :param ip_protocols: Array of FirewallPolicyRuleConditionNetworkProtocols.
    :type ip_protocols: list[str or
     ~azure.mgmt.network.v2019_09_01.models.FirewallPolicyRuleConditionNetworkProtocol]
    :param source_addresses: List of source IP addresses for this rule.
    :type source_addresses: list[str]
    :param destination_addresses: List of destination IP addresses or Service
     Tags.
    :type destination_addresses: list[str]
    :param destination_ports: List of destination ports.
    :type destination_ports: list[str]
    """

    _validation = {
        'rule_condition_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rule_condition_type': {'key': 'ruleConditionType', 'type': 'str'},
        'ip_protocols': {'key': 'ipProtocols', 'type': '[str]'},
        'source_addresses': {'key': 'sourceAddresses', 'type': '[str]'},
        'destination_addresses': {'key': 'destinationAddresses', 'type': '[str]'},
        'destination_ports': {'key': 'destinationPorts', 'type': '[str]'},
    }

    def __init__(self, *, name: str=None, description: str=None, ip_protocols=None, source_addresses=None, destination_addresses=None, destination_ports=None, **kwargs) -> None:
        super(NetworkRuleCondition, self).__init__(name=name, description=description, **kwargs)
        self.ip_protocols = ip_protocols
        self.source_addresses = source_addresses
        self.destination_addresses = destination_addresses
        self.destination_ports = destination_ports
        self.rule_condition_type = 'NetworkRuleCondition'


class NetworkSecurityGroup(Resource):
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param security_rules: A collection of security rules of the network
     security group.
    :type security_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SecurityRule]
    :ivar default_security_rules: The default security rules of network
     security group.
    :vartype default_security_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SecurityRule]
    :ivar network_interfaces: A collection of references to network
     interfaces.
    :vartype network_interfaces:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkInterface]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2019_09_01.models.Subnet]
    :ivar resource_guid: The resource GUID property of the network security
     group resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the network security
     group resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'default_security_rules': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'subnets': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'security_rules': {'key': 'properties.securityRules', 'type': '[SecurityRule]'},
        'default_security_rules': {'key': 'properties.defaultSecurityRules', 'type': '[SecurityRule]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, security_rules=None, **kwargs) -> None:
        super(NetworkSecurityGroup, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.security_rules = security_rules
        self.default_security_rules = None
        self.network_interfaces = None
        self.subnets = None
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None


class NetworkSecurityGroupResult(Model):
    """Network configuration diagnostic result corresponded provided traffic
    query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param security_rule_access_result: The network traffic is allowed or
     denied. Possible values include: 'Allow', 'Deny'
    :type security_rule_access_result: str or
     ~azure.mgmt.network.v2019_09_01.models.SecurityRuleAccess
    :ivar evaluated_network_security_groups: List of results network security
     groups diagnostic.
    :vartype evaluated_network_security_groups:
     list[~azure.mgmt.network.v2019_09_01.models.EvaluatedNetworkSecurityGroup]
    """

    _validation = {
        'evaluated_network_security_groups': {'readonly': True},
    }

    _attribute_map = {
        'security_rule_access_result': {'key': 'securityRuleAccessResult', 'type': 'str'},
        'evaluated_network_security_groups': {'key': 'evaluatedNetworkSecurityGroups', 'type': '[EvaluatedNetworkSecurityGroup]'},
    }

    def __init__(self, *, security_rule_access_result=None, **kwargs) -> None:
        super(NetworkSecurityGroupResult, self).__init__(**kwargs)
        self.security_rule_access_result = security_rule_access_result
        self.evaluated_network_security_groups = None


class NetworkSecurityRulesEvaluationResult(Model):
    """Network security rules evaluation result.

    :param name: Name of the network security rule.
    :type name: str
    :param protocol_matched: Value indicating whether protocol is matched.
    :type protocol_matched: bool
    :param source_matched: Value indicating whether source is matched.
    :type source_matched: bool
    :param source_port_matched: Value indicating whether source port is
     matched.
    :type source_port_matched: bool
    :param destination_matched: Value indicating whether destination is
     matched.
    :type destination_matched: bool
    :param destination_port_matched: Value indicating whether destination port
     is matched.
    :type destination_port_matched: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol_matched': {'key': 'protocolMatched', 'type': 'bool'},
        'source_matched': {'key': 'sourceMatched', 'type': 'bool'},
        'source_port_matched': {'key': 'sourcePortMatched', 'type': 'bool'},
        'destination_matched': {'key': 'destinationMatched', 'type': 'bool'},
        'destination_port_matched': {'key': 'destinationPortMatched', 'type': 'bool'},
    }

    def __init__(self, *, name: str=None, protocol_matched: bool=None, source_matched: bool=None, source_port_matched: bool=None, destination_matched: bool=None, destination_port_matched: bool=None, **kwargs) -> None:
        super(NetworkSecurityRulesEvaluationResult, self).__init__(**kwargs)
        self.name = name
        self.protocol_matched = protocol_matched
        self.source_matched = source_matched
        self.source_port_matched = source_port_matched
        self.destination_matched = destination_matched
        self.destination_port_matched = destination_port_matched


class NetworkWatcher(Resource):
    """Network watcher in a resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar provisioning_state: The provisioning state of the network watcher
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, **kwargs) -> None:
        super(NetworkWatcher, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.provisioning_state = None


class NextHopParameters(Model):
    """Parameters that define the source and destination endpoint.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The resource identifier of the target
     resource against which the action is to be performed.
    :type target_resource_id: str
    :param source_ip_address: Required. The source IP address.
    :type source_ip_address: str
    :param destination_ip_address: Required. The destination IP address.
    :type destination_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP
     forwarding is enabled on any of the nics, then this parameter must be
     specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'source_ip_address': {'required': True},
        'destination_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'source_ip_address': {'key': 'sourceIPAddress', 'type': 'str'},
        'destination_ip_address': {'key': 'destinationIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(self, *, target_resource_id: str, source_ip_address: str, destination_ip_address: str, target_nic_resource_id: str=None, **kwargs) -> None:
        super(NextHopParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.source_ip_address = source_ip_address
        self.destination_ip_address = destination_ip_address
        self.target_nic_resource_id = target_nic_resource_id


class NextHopResult(Model):
    """The information about next hop from the specified VM.

    :param next_hop_type: Next hop type. Possible values include: 'Internet',
     'VirtualAppliance', 'VirtualNetworkGateway', 'VnetLocal',
     'HyperNetGateway', 'None'
    :type next_hop_type: str or
     ~azure.mgmt.network.v2019_09_01.models.NextHopType
    :param next_hop_ip_address: Next hop IP Address.
    :type next_hop_ip_address: str
    :param route_table_id: The resource identifier for the route table
     associated with the route being returned. If the route being returned does
     not correspond to any user created routes then this field will be the
     string 'System Route'.
    :type route_table_id: str
    """

    _attribute_map = {
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': 'str'},
        'route_table_id': {'key': 'routeTableId', 'type': 'str'},
    }

    def __init__(self, *, next_hop_type=None, next_hop_ip_address: str=None, route_table_id: str=None, **kwargs) -> None:
        super(NextHopResult, self).__init__(**kwargs)
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.route_table_id = route_table_id


class Operation(Model):
    """Network REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.network.v2019_09_01.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param service_specification: Specification of the service.
    :type service_specification:
     ~azure.mgmt.network.v2019_09_01.models.OperationPropertiesFormatServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationPropertiesFormatServiceSpecification'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, service_specification=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft Network.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: Type of the operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationPropertiesFormatServiceSpecification(Model):
    """Specification of the service.

    :param metric_specifications: Operation service specification.
    :type metric_specifications:
     list[~azure.mgmt.network.v2019_09_01.models.MetricSpecification]
    :param log_specifications: Operation log specification.
    :type log_specifications:
     list[~azure.mgmt.network.v2019_09_01.models.LogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(self, *, metric_specifications=None, log_specifications=None, **kwargs) -> None:
        super(OperationPropertiesFormatServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class OutboundRule(SubResource):
    """Outbound rule of the load balancer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param allocated_outbound_ports: The number of outbound ports to be used
     for NAT.
    :type allocated_outbound_ports: int
    :param frontend_ip_configurations: Required. The Frontend IP addresses of
     the load balancer.
    :type frontend_ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param backend_address_pool: Required. A reference to a pool of DIPs.
     Outbound traffic is randomly load balanced across IPs in the backend IPs.
    :type backend_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the outbound rule
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param protocol: Required. The protocol for the outbound rule in load
     balancer. Possible values include: 'Tcp', 'Udp', 'All'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.LoadBalancerOutboundRuleProtocol
    :param enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle
     timeout or unexpected connection termination. This element is only used
     when the protocol is set to TCP.
    :type enable_tcp_reset: bool
    :param idle_timeout_in_minutes: The timeout for the TCP idle connection.
    :type idle_timeout_in_minutes: int
    :param name: The name of the resource that is unique within the set of
     outbound rules used by the load balancer. This name can be used to access
     the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'frontend_ip_configurations': {'required': True},
        'backend_address_pool': {'required': True},
        'provisioning_state': {'readonly': True},
        'protocol': {'required': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'allocated_outbound_ports': {'key': 'properties.allocatedOutboundPorts', 'type': 'int'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[SubResource]'},
        'backend_address_pool': {'key': 'properties.backendAddressPool', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'enable_tcp_reset': {'key': 'properties.enableTcpReset', 'type': 'bool'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, frontend_ip_configurations, backend_address_pool, protocol, id: str=None, allocated_outbound_ports: int=None, enable_tcp_reset: bool=None, idle_timeout_in_minutes: int=None, name: str=None, **kwargs) -> None:
        super(OutboundRule, self).__init__(id=id, **kwargs)
        self.allocated_outbound_ports = allocated_outbound_ports
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = None
        self.protocol = protocol
        self.enable_tcp_reset = enable_tcp_reset
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.name = name
        self.etag = None
        self.type = None


class OwaspCrsExclusionEntry(Model):
    """Allow to exclude some variable satisfy the condition for the WAF check.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. The variable to be excluded. Possible
     values include: 'RequestHeaderNames', 'RequestCookieNames',
     'RequestArgNames'
    :type match_variable: str or
     ~azure.mgmt.network.v2019_09_01.models.OwaspCrsExclusionEntryMatchVariable
    :param selector_match_operator: Required. When matchVariable is a
     collection, operate on the selector to specify which elements in the
     collection this exclusion applies to. Possible values include: 'Equals',
     'Contains', 'StartsWith', 'EndsWith', 'EqualsAny'
    :type selector_match_operator: str or
     ~azure.mgmt.network.v2019_09_01.models.OwaspCrsExclusionEntrySelectorMatchOperator
    :param selector: Required. When matchVariable is a collection, operator
     used to specify which elements in the collection this exclusion applies
     to.
    :type selector: str
    """

    _validation = {
        'match_variable': {'required': True},
        'selector_match_operator': {'required': True},
        'selector': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector_match_operator': {'key': 'selectorMatchOperator', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
    }

    def __init__(self, *, match_variable, selector_match_operator, selector: str, **kwargs) -> None:
        super(OwaspCrsExclusionEntry, self).__init__(**kwargs)
        self.match_variable = match_variable
        self.selector_match_operator = selector_match_operator
        self.selector = selector


class P2SConnectionConfiguration(SubResource):
    """P2SConnectionConfiguration Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param vpn_client_address_pool: The reference of the address space
     resource which represents Address space for P2S VpnClient.
    :type vpn_client_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.AddressSpace
    :ivar provisioning_state: The provisioning state of the
     P2SConnectionConfiguration resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vpn_client_address_pool': {'key': 'properties.vpnClientAddressPool', 'type': 'AddressSpace'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, vpn_client_address_pool=None, name: str=None, **kwargs) -> None:
        super(P2SConnectionConfiguration, self).__init__(id=id, **kwargs)
        self.vpn_client_address_pool = vpn_client_address_pool
        self.provisioning_state = None
        self.name = name
        self.etag = None


class P2SVpnConnectionHealth(Model):
    """P2S Vpn connection detailed health written to sas url.

    :param sas_url: Returned sas url of the blob to which the p2s vpn
     connection detailed health will be written.
    :type sas_url: str
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(self, *, sas_url: str=None, **kwargs) -> None:
        super(P2SVpnConnectionHealth, self).__init__(**kwargs)
        self.sas_url = sas_url


class P2SVpnConnectionHealthRequest(Model):
    """List of P2S Vpn connection health request.

    :param vpn_user_names_filter: The list of p2s vpn user names whose p2s vpn
     connection detailed health to retrieve for.
    :type vpn_user_names_filter: list[str]
    :param output_blob_sas_url: The sas-url to download the P2S Vpn connection
     health detail.
    :type output_blob_sas_url: str
    """

    _attribute_map = {
        'vpn_user_names_filter': {'key': 'vpnUserNamesFilter', 'type': '[str]'},
        'output_blob_sas_url': {'key': 'outputBlobSasUrl', 'type': 'str'},
    }

    def __init__(self, *, vpn_user_names_filter=None, output_blob_sas_url: str=None, **kwargs) -> None:
        super(P2SVpnConnectionHealthRequest, self).__init__(**kwargs)
        self.vpn_user_names_filter = vpn_user_names_filter
        self.output_blob_sas_url = output_blob_sas_url


class P2SVpnGateway(Resource):
    """P2SVpnGateway Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param virtual_hub: The VirtualHub to which the gateway belongs.
    :type virtual_hub: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param p2_sconnection_configurations: List of all p2s connection
     configurations of the gateway.
    :type p2_sconnection_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.P2SConnectionConfiguration]
    :ivar provisioning_state: The provisioning state of the P2S VPN gateway
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param vpn_gateway_scale_unit: The scale unit for this p2s vpn gateway.
    :type vpn_gateway_scale_unit: int
    :param vpn_server_configuration: The VpnServerConfiguration to which the
     p2sVpnGateway is attached to.
    :type vpn_server_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar vpn_client_connection_health: All P2S VPN clients' connection health
     status.
    :vartype vpn_client_connection_health:
     ~azure.mgmt.network.v2019_09_01.models.VpnClientConnectionHealth
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'vpn_client_connection_health': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'SubResource'},
        'p2_sconnection_configurations': {'key': 'properties.p2SConnectionConfigurations', 'type': '[P2SConnectionConfiguration]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'vpn_gateway_scale_unit': {'key': 'properties.vpnGatewayScaleUnit', 'type': 'int'},
        'vpn_server_configuration': {'key': 'properties.vpnServerConfiguration', 'type': 'SubResource'},
        'vpn_client_connection_health': {'key': 'properties.vpnClientConnectionHealth', 'type': 'VpnClientConnectionHealth'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, virtual_hub=None, p2_sconnection_configurations=None, vpn_gateway_scale_unit: int=None, vpn_server_configuration=None, **kwargs) -> None:
        super(P2SVpnGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.virtual_hub = virtual_hub
        self.p2_sconnection_configurations = p2_sconnection_configurations
        self.provisioning_state = None
        self.vpn_gateway_scale_unit = vpn_gateway_scale_unit
        self.vpn_server_configuration = vpn_server_configuration
        self.vpn_client_connection_health = None
        self.etag = None


class P2SVpnProfileParameters(Model):
    """Vpn Client Parameters for package generation.

    :param authentication_method: VPN client authentication method. Possible
     values include: 'EAPTLS', 'EAPMSCHAPv2'
    :type authentication_method: str or
     ~azure.mgmt.network.v2019_09_01.models.AuthenticationMethod
    """

    _attribute_map = {
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
    }

    def __init__(self, *, authentication_method=None, **kwargs) -> None:
        super(P2SVpnProfileParameters, self).__init__(**kwargs)
        self.authentication_method = authentication_method


class PacketCapture(Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is
     currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet,
     the remaining bytes are truncated. Default value: 0 .
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
     Default value: 1073741824 .
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in
     seconds. Default value: 18000 .
    :type time_limit_in_seconds: int
    :param storage_location: Required. Describes the storage location for a
     packet capture session.
    :type storage_location:
     ~azure.mgmt.network.v2019_09_01.models.PacketCaptureStorageLocation
    :param filters: A list of packet capture filters.
    :type filters:
     list[~azure.mgmt.network.v2019_09_01.models.PacketCaptureFilter]
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'target': {'key': 'properties.target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'properties.bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'properties.totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'properties.timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'properties.storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'properties.filters', 'type': '[PacketCaptureFilter]'},
    }

    def __init__(self, *, target: str, storage_location, bytes_to_capture_per_packet: int=0, total_bytes_per_session: int=1073741824, time_limit_in_seconds: int=18000, filters=None, **kwargs) -> None:
        super(PacketCapture, self).__init__(**kwargs)
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters


class PacketCaptureFilter(Model):
    """Filter that is applied to packet capture request. Multiple filters can be
    applied.

    :param protocol: Protocol to be filtered on. Possible values include:
     'TCP', 'UDP', 'Any'. Default value: "Any" .
    :type protocol: str or ~azure.mgmt.network.v2019_09_01.models.PcProtocol
    :param local_ip_address: Local IP Address to be filtered on. Notation:
     "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range.
     "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently
     supported. Mixing ranges with multiple entries not currently supported.
     Default = null.
    :type local_ip_address: str
    :param remote_ip_address: Local IP Address to be filtered on. Notation:
     "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range.
     "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently
     supported. Mixing ranges with multiple entries not currently supported.
     Default = null.
    :type remote_ip_address: str
    :param local_port: Local port to be filtered on. Notation: "80" for single
     port entry."80-85" for range. "80;443;" for multiple entries. Multiple
     ranges not currently supported. Mixing ranges with multiple entries not
     currently supported. Default = null.
    :type local_port: str
    :param remote_port: Remote port to be filtered on. Notation: "80" for
     single port entry."80-85" for range. "80;443;" for multiple entries.
     Multiple ranges not currently supported. Mixing ranges with multiple
     entries not currently supported. Default = null.
    :type remote_port: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'local_ip_address': {'key': 'localIPAddress', 'type': 'str'},
        'remote_ip_address': {'key': 'remoteIPAddress', 'type': 'str'},
        'local_port': {'key': 'localPort', 'type': 'str'},
        'remote_port': {'key': 'remotePort', 'type': 'str'},
    }

    def __init__(self, *, protocol="Any", local_ip_address: str=None, remote_ip_address: str=None, local_port: str=None, remote_port: str=None, **kwargs) -> None:
        super(PacketCaptureFilter, self).__init__(**kwargs)
        self.protocol = protocol
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.local_port = local_port
        self.remote_port = remote_port


class PacketCaptureParameters(Model):
    """Parameters that define the create packet capture operation.

    All required parameters must be populated in order to send to Azure.

    :param target: Required. The ID of the targeted resource, only VM is
     currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet,
     the remaining bytes are truncated. Default value: 0 .
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
     Default value: 1073741824 .
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in
     seconds. Default value: 18000 .
    :type time_limit_in_seconds: int
    :param storage_location: Required. Describes the storage location for a
     packet capture session.
    :type storage_location:
     ~azure.mgmt.network.v2019_09_01.models.PacketCaptureStorageLocation
    :param filters: A list of packet capture filters.
    :type filters:
     list[~azure.mgmt.network.v2019_09_01.models.PacketCaptureFilter]
    """

    _validation = {
        'target': {'required': True},
        'storage_location': {'required': True},
    }

    _attribute_map = {
        'target': {'key': 'target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'filters', 'type': '[PacketCaptureFilter]'},
    }

    def __init__(self, *, target: str, storage_location, bytes_to_capture_per_packet: int=0, total_bytes_per_session: int=1073741824, time_limit_in_seconds: int=18000, filters=None, **kwargs) -> None:
        super(PacketCaptureParameters, self).__init__(**kwargs)
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters


class PacketCaptureQueryStatusResult(Model):
    """Status of packet capture session.

    :param name: The name of the packet capture resource.
    :type name: str
    :param id: The ID of the packet capture resource.
    :type id: str
    :param capture_start_time: The start time of the packet capture session.
    :type capture_start_time: datetime
    :param packet_capture_status: The status of the packet capture session.
     Possible values include: 'NotStarted', 'Running', 'Stopped', 'Error',
     'Unknown'
    :type packet_capture_status: str or
     ~azure.mgmt.network.v2019_09_01.models.PcStatus
    :param stop_reason: The reason the current packet capture session was
     stopped.
    :type stop_reason: str
    :param packet_capture_error: List of errors of packet capture session.
    :type packet_capture_error: list[str or
     ~azure.mgmt.network.v2019_09_01.models.PcError]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'capture_start_time': {'key': 'captureStartTime', 'type': 'iso-8601'},
        'packet_capture_status': {'key': 'packetCaptureStatus', 'type': 'str'},
        'stop_reason': {'key': 'stopReason', 'type': 'str'},
        'packet_capture_error': {'key': 'packetCaptureError', 'type': '[str]'},
    }

    def __init__(self, *, name: str=None, id: str=None, capture_start_time=None, packet_capture_status=None, stop_reason: str=None, packet_capture_error=None, **kwargs) -> None:
        super(PacketCaptureQueryStatusResult, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.capture_start_time = capture_start_time
        self.packet_capture_status = packet_capture_status
        self.stop_reason = stop_reason
        self.packet_capture_error = packet_capture_error


class PacketCaptureResult(Model):
    """Information about packet capture session.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the packet capture session.
    :vartype name: str
    :ivar id: ID of the packet capture operation.
    :vartype id: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param target: Required. The ID of the targeted resource, only VM is
     currently supported.
    :type target: str
    :param bytes_to_capture_per_packet: Number of bytes captured per packet,
     the remaining bytes are truncated. Default value: 0 .
    :type bytes_to_capture_per_packet: int
    :param total_bytes_per_session: Maximum size of the capture output.
     Default value: 1073741824 .
    :type total_bytes_per_session: int
    :param time_limit_in_seconds: Maximum duration of the capture session in
     seconds. Default value: 18000 .
    :type time_limit_in_seconds: int
    :param storage_location: Required. Describes the storage location for a
     packet capture session.
    :type storage_location:
     ~azure.mgmt.network.v2019_09_01.models.PacketCaptureStorageLocation
    :param filters: A list of packet capture filters.
    :type filters:
     list[~azure.mgmt.network.v2019_09_01.models.PacketCaptureFilter]
    :ivar provisioning_state: The provisioning state of the packet capture
     session. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'etag': {'readonly': True},
        'target': {'required': True},
        'storage_location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'bytes_to_capture_per_packet': {'key': 'properties.bytesToCapturePerPacket', 'type': 'int'},
        'total_bytes_per_session': {'key': 'properties.totalBytesPerSession', 'type': 'int'},
        'time_limit_in_seconds': {'key': 'properties.timeLimitInSeconds', 'type': 'int'},
        'storage_location': {'key': 'properties.storageLocation', 'type': 'PacketCaptureStorageLocation'},
        'filters': {'key': 'properties.filters', 'type': '[PacketCaptureFilter]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, target: str, storage_location, bytes_to_capture_per_packet: int=0, total_bytes_per_session: int=1073741824, time_limit_in_seconds: int=18000, filters=None, **kwargs) -> None:
        super(PacketCaptureResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.etag = None
        self.target = target
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.storage_location = storage_location
        self.filters = filters
        self.provisioning_state = None


class PacketCaptureStorageLocation(Model):
    """Describes the storage location for a packet capture session.

    :param storage_id: The ID of the storage account to save the packet
     capture session. Required if no local file path is provided.
    :type storage_id: str
    :param storage_path: The URI of the storage path to save the packet
     capture. Must be a well-formed URI describing the location to save the
     packet capture.
    :type storage_path: str
    :param file_path: A valid local path on the targeting VM. Must include the
     name of the capture file (*.cap). For linux virtual machine it must start
     with /var/captures. Required if no storage ID is provided, otherwise
     optional.
    :type file_path: str
    """

    _attribute_map = {
        'storage_id': {'key': 'storageId', 'type': 'str'},
        'storage_path': {'key': 'storagePath', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
    }

    def __init__(self, *, storage_id: str=None, storage_path: str=None, file_path: str=None, **kwargs) -> None:
        super(PacketCaptureStorageLocation, self).__init__(**kwargs)
        self.storage_id = storage_id
        self.storage_path = storage_path
        self.file_path = file_path


class PatchRouteFilter(SubResource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param rules: Collection of RouteFilterRules contained within a route
     filter.
    :type rules: list[~azure.mgmt.network.v2019_09_01.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit
     peerings.
    :vartype peerings:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeering]
    :ivar ipv6_peerings: A collection of references to express route circuit
     ipv6 peerings.
    :vartype ipv6_peerings:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the route filter
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'peerings': {'readonly': True},
        'ipv6_peerings': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rules': {'key': 'properties.rules', 'type': '[RouteFilterRule]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'ipv6_peerings': {'key': 'properties.ipv6Peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, id: str=None, rules=None, tags=None, **kwargs) -> None:
        super(PatchRouteFilter, self).__init__(id=id, **kwargs)
        self.rules = rules
        self.peerings = None
        self.ipv6_peerings = None
        self.provisioning_state = None
        self.name = None
        self.etag = None
        self.type = None
        self.tags = tags


class PatchRouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param access: Required. The access type of the rule. Possible values
     include: 'Allow', 'Deny'
    :type access: str or ~azure.mgmt.network.v2019_09_01.models.Access
    :ivar route_filter_rule_type: Required. The rule type of the rule. Default
     value: "Community" .
    :vartype route_filter_rule_type: str
    :param communities: Required. The collection for bgp community values to
     filter on. e.g. ['12076:5010','12076:5020'].
    :type communities: list[str]
    :ivar provisioning_state: The provisioning state of the route filter rule
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'access': {'required': True},
        'route_filter_rule_type': {'required': True, 'constant': True},
        'communities': {'required': True},
        'provisioning_state': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'route_filter_rule_type': {'key': 'properties.routeFilterRuleType', 'type': 'str'},
        'communities': {'key': 'properties.communities', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    route_filter_rule_type = "Community"

    def __init__(self, *, access, communities, id: str=None, **kwargs) -> None:
        super(PatchRouteFilterRule, self).__init__(id=id, **kwargs)
        self.access = access
        self.communities = communities
        self.provisioning_state = None
        self.name = None
        self.etag = None


class PeerExpressRouteCircuitConnection(SubResource):
    """Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering
    resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param express_route_circuit_peering: Reference to Express Route Circuit
     Private Peering Resource of the circuit.
    :type express_route_circuit_peering:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param peer_express_route_circuit_peering: Reference to Express Route
     Circuit Private Peering Resource of the peered circuit.
    :type peer_express_route_circuit_peering:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param address_prefix: /29 IP address space to carve out Customer
     addresses for tunnels.
    :type address_prefix: str
    :param circuit_connection_status: Express Route Circuit connection state.
     Possible values include: 'Connected', 'Connecting', 'Disconnected'
    :type circuit_connection_status: str or
     ~azure.mgmt.network.v2019_09_01.models.CircuitConnectionStatus
    :param connection_name: The name of the express route circuit connection
     resource.
    :type connection_name: str
    :param auth_resource_guid: The resource guid of the authorization used for
     the express route circuit connection.
    :type auth_resource_guid: str
    :ivar provisioning_state: The provisioning state of the peer express route
     circuit connection resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'express_route_circuit_peering': {'key': 'properties.expressRouteCircuitPeering', 'type': 'SubResource'},
        'peer_express_route_circuit_peering': {'key': 'properties.peerExpressRouteCircuitPeering', 'type': 'SubResource'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'circuit_connection_status': {'key': 'properties.circuitConnectionStatus', 'type': 'str'},
        'connection_name': {'key': 'properties.connectionName', 'type': 'str'},
        'auth_resource_guid': {'key': 'properties.authResourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, express_route_circuit_peering=None, peer_express_route_circuit_peering=None, address_prefix: str=None, circuit_connection_status=None, connection_name: str=None, auth_resource_guid: str=None, name: str=None, **kwargs) -> None:
        super(PeerExpressRouteCircuitConnection, self).__init__(id=id, **kwargs)
        self.express_route_circuit_peering = express_route_circuit_peering
        self.peer_express_route_circuit_peering = peer_express_route_circuit_peering
        self.address_prefix = address_prefix
        self.circuit_connection_status = circuit_connection_status
        self.connection_name = connection_name
        self.auth_resource_guid = auth_resource_guid
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class PolicySettings(Model):
    """Defines contents of a web application firewall global configuration.

    :param state: Describes if the policy is in enabled state or disabled
     state. Possible values include: 'Disabled', 'Enabled'
    :type state: str or
     ~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallEnabledState
    :param mode: Describes if it is in detection mode or prevention mode at
     policy level. Possible values include: 'Prevention', 'Detection'
    :type mode: str or
     ~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallMode
    :param request_body_check: Whether to allow WAF to check request Body.
    :type request_body_check: bool
    :param max_request_body_size_in_kb: Maximum request body size in Kb for
     WAF.
    :type max_request_body_size_in_kb: int
    :param file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
    :type file_upload_limit_in_mb: int
    """

    _validation = {
        'max_request_body_size_in_kb': {'maximum': 128, 'minimum': 8},
        'file_upload_limit_in_mb': {'minimum': 0},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'request_body_check': {'key': 'requestBodyCheck', 'type': 'bool'},
        'max_request_body_size_in_kb': {'key': 'maxRequestBodySizeInKb', 'type': 'int'},
        'file_upload_limit_in_mb': {'key': 'fileUploadLimitInMb', 'type': 'int'},
    }

    def __init__(self, *, state=None, mode=None, request_body_check: bool=None, max_request_body_size_in_kb: int=None, file_upload_limit_in_mb: int=None, **kwargs) -> None:
        super(PolicySettings, self).__init__(**kwargs)
        self.state = state
        self.mode = mode
        self.request_body_check = request_body_check
        self.max_request_body_size_in_kb = max_request_body_size_in_kb
        self.file_upload_limit_in_mb = file_upload_limit_in_mb


class PrepareNetworkPoliciesRequest(Model):
    """Details of PrepareNetworkPolicies for Subnet.

    :param service_name: The name of the service for which subnet is being
     prepared for.
    :type service_name: str
    :param network_intent_policy_configurations: A list of
     NetworkIntentPolicyConfiguration.
    :type network_intent_policy_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkIntentPolicyConfiguration]
    """

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'network_intent_policy_configurations': {'key': 'networkIntentPolicyConfigurations', 'type': '[NetworkIntentPolicyConfiguration]'},
    }

    def __init__(self, *, service_name: str=None, network_intent_policy_configurations=None, **kwargs) -> None:
        super(PrepareNetworkPoliciesRequest, self).__init__(**kwargs)
        self.service_name = service_name
        self.network_intent_policy_configurations = network_intent_policy_configurations


class PrivateEndpoint(Resource):
    """Private endpoint resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param subnet: The ID of the subnet from which the private IP will be
     allocated.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.Subnet
    :ivar network_interfaces: An array of references to the network interfaces
     created for this private endpoint.
    :vartype network_interfaces:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkInterface]
    :ivar provisioning_state: The provisioning state of the private endpoint
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param private_link_service_connections: A grouping of information about
     the connection to the remote resource.
    :type private_link_service_connections:
     list[~azure.mgmt.network.v2019_09_01.models.PrivateLinkServiceConnection]
    :param manual_private_link_service_connections: A grouping of information
     about the connection to the remote resource. Used when the network admin
     does not have access to approve connections to the remote resource.
    :type manual_private_link_service_connections:
     list[~azure.mgmt.network.v2019_09_01.models.PrivateLinkServiceConnection]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_link_service_connections': {'key': 'properties.privateLinkServiceConnections', 'type': '[PrivateLinkServiceConnection]'},
        'manual_private_link_service_connections': {'key': 'properties.manualPrivateLinkServiceConnections', 'type': '[PrivateLinkServiceConnection]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, subnet=None, private_link_service_connections=None, manual_private_link_service_connections=None, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.subnet = subnet
        self.network_interfaces = None
        self.provisioning_state = None
        self.private_link_service_connections = private_link_service_connections
        self.manual_private_link_service_connections = manual_private_link_service_connections
        self.etag = None


class PrivateEndpointConnection(SubResource):
    """PrivateEndpointConnection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint:
     ~azure.mgmt.network.v2019_09_01.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information
     about the state of the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.network.v2019_09_01.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint
     connection resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar link_identifier: The consumer link id.
    :vartype link_identifier: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'private_endpoint': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'link_identifier': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'link_identifier': {'key': 'properties.linkIdentifier', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, private_link_service_connection_state=None, name: str=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(id=id, **kwargs)
        self.private_endpoint = None
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None
        self.link_identifier = None
        self.name = name
        self.type = None
        self.etag = None


class PrivateLinkService(Resource):
    """Private link service resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param load_balancer_frontend_ip_configurations: An array of references to
     the load balancer IP configurations.
    :type load_balancer_frontend_ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.FrontendIPConfiguration]
    :param ip_configurations: An array of private link service IP
     configurations.
    :type ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.PrivateLinkServiceIpConfiguration]
    :ivar network_interfaces: An array of references to the network interfaces
     created for this private link service.
    :vartype network_interfaces:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkInterface]
    :ivar provisioning_state: The provisioning state of the private link
     service resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar private_endpoint_connections: An array of list about connections to
     the private endpoint.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.network.v2019_09_01.models.PrivateEndpointConnection]
    :param visibility: The visibility list of the private link service.
    :type visibility:
     ~azure.mgmt.network.v2019_09_01.models.PrivateLinkServicePropertiesVisibility
    :param auto_approval: The auto-approval list of the private link service.
    :type auto_approval:
     ~azure.mgmt.network.v2019_09_01.models.PrivateLinkServicePropertiesAutoApproval
    :param fqdns: The list of Fqdn.
    :type fqdns: list[str]
    :ivar alias: The alias of the private link service.
    :vartype alias: str
    :param enable_proxy_protocol: Whether the private link service is enabled
     for proxy protocol or not.
    :type enable_proxy_protocol: bool
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'network_interfaces': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'alias': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'load_balancer_frontend_ip_configurations': {'key': 'properties.loadBalancerFrontendIpConfigurations', 'type': '[FrontendIPConfiguration]'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[PrivateLinkServiceIpConfiguration]'},
        'network_interfaces': {'key': 'properties.networkInterfaces', 'type': '[NetworkInterface]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'visibility': {'key': 'properties.visibility', 'type': 'PrivateLinkServicePropertiesVisibility'},
        'auto_approval': {'key': 'properties.autoApproval', 'type': 'PrivateLinkServicePropertiesAutoApproval'},
        'fqdns': {'key': 'properties.fqdns', 'type': '[str]'},
        'alias': {'key': 'properties.alias', 'type': 'str'},
        'enable_proxy_protocol': {'key': 'properties.enableProxyProtocol', 'type': 'bool'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, load_balancer_frontend_ip_configurations=None, ip_configurations=None, visibility=None, auto_approval=None, fqdns=None, enable_proxy_protocol: bool=None, **kwargs) -> None:
        super(PrivateLinkService, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.load_balancer_frontend_ip_configurations = load_balancer_frontend_ip_configurations
        self.ip_configurations = ip_configurations
        self.network_interfaces = None
        self.provisioning_state = None
        self.private_endpoint_connections = None
        self.visibility = visibility
        self.auto_approval = auto_approval
        self.fqdns = fqdns
        self.alias = None
        self.enable_proxy_protocol = enable_proxy_protocol
        self.etag = None


class PrivateLinkServiceConnection(SubResource):
    """PrivateLinkServiceConnection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar provisioning_state: The provisioning state of the private link
     service connection resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param private_link_service_id: The resource id of private link service.
    :type private_link_service_id: str
    :param group_ids: The ID(s) of the group(s) obtained from the remote
     resource that this private endpoint should connect to.
    :type group_ids: list[str]
    :param request_message: A message passed to the owner of the remote
     resource with this connection request. Restricted to 140 chars.
    :type request_message: str
    :param private_link_service_connection_state: A collection of read-only
     information about the state of the connection to the remote resource.
    :type private_link_service_connection_state:
     ~azure.mgmt.network.v2019_09_01.models.PrivateLinkServiceConnectionState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_link_service_id': {'key': 'properties.privateLinkServiceId', 'type': 'str'},
        'group_ids': {'key': 'properties.groupIds', 'type': '[str]'},
        'request_message': {'key': 'properties.requestMessage', 'type': 'str'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, private_link_service_id: str=None, group_ids=None, request_message: str=None, private_link_service_connection_state=None, name: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnection, self).__init__(id=id, **kwargs)
        self.provisioning_state = None
        self.private_link_service_id = private_link_service_id
        self.group_ids = group_ids
        self.request_message = request_message
        self.private_link_service_connection_state = private_link_service_connection_state
        self.name = name
        self.type = None
        self.etag = None


class PrivateLinkServiceConnectionState(Model):
    """A collection of information about the state of the connection between
    service consumer and provider.

    :param status: Indicates whether the connection has been
     Approved/Rejected/Removed by the owner of the service.
    :type status: str
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param action_required: A message indicating if changes on the service
     provider require any updates on the consumer.
    :type action_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'action_required': {'key': 'actionRequired', 'type': 'str'},
    }

    def __init__(self, *, status: str=None, description: str=None, action_required: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = action_required


class PrivateLinkServiceIpConfiguration(SubResource):
    """The private link service ip configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param private_ip_address: The private IP address of the IP configuration.
    :type private_ip_address: str
    :param private_ip_allocation_method: The private IP address allocation
     method. Possible values include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_09_01.models.IPAllocationMethod
    :param subnet: The reference to the subnet resource.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.Subnet
    :param primary: Whether the ip configuration is primary or not.
    :type primary: bool
    :ivar provisioning_state: The provisioning state of the private link
     service IP configuration resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param private_ip_address_version: Whether the specific IP configuration
     is IPv4 or IPv6. Default is IPv4. Possible values include: 'IPv4', 'IPv6'
    :type private_ip_address_version: str or
     ~azure.mgmt.network.v2019_09_01.models.IPVersion
    :param name: The name of private link service ip configuration.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, private_ip_address: str=None, private_ip_allocation_method=None, subnet=None, primary: bool=None, private_ip_address_version=None, name: str=None, **kwargs) -> None:
        super(PrivateLinkServiceIpConfiguration, self).__init__(id=id, **kwargs)
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.primary = primary
        self.provisioning_state = None
        self.private_ip_address_version = private_ip_address_version
        self.name = name
        self.etag = None
        self.type = None


class ResourceSet(Model):
    """The base resource set for visibility and auto-approval.

    :param subscriptions: The list of subscriptions.
    :type subscriptions: list[str]
    """

    _attribute_map = {
        'subscriptions': {'key': 'subscriptions', 'type': '[str]'},
    }

    def __init__(self, *, subscriptions=None, **kwargs) -> None:
        super(ResourceSet, self).__init__(**kwargs)
        self.subscriptions = subscriptions


class PrivateLinkServicePropertiesAutoApproval(ResourceSet):
    """The auto-approval list of the private link service.

    :param subscriptions: The list of subscriptions.
    :type subscriptions: list[str]
    """

    _attribute_map = {
        'subscriptions': {'key': 'subscriptions', 'type': '[str]'},
    }

    def __init__(self, *, subscriptions=None, **kwargs) -> None:
        super(PrivateLinkServicePropertiesAutoApproval, self).__init__(subscriptions=subscriptions, **kwargs)


class PrivateLinkServicePropertiesVisibility(ResourceSet):
    """The visibility list of the private link service.

    :param subscriptions: The list of subscriptions.
    :type subscriptions: list[str]
    """

    _attribute_map = {
        'subscriptions': {'key': 'subscriptions', 'type': '[str]'},
    }

    def __init__(self, *, subscriptions=None, **kwargs) -> None:
        super(PrivateLinkServicePropertiesVisibility, self).__init__(subscriptions=subscriptions, **kwargs)


class PrivateLinkServiceVisibility(Model):
    """Response for the CheckPrivateLinkServiceVisibility API service call.

    :param visible: Private Link Service Visibility (True/False).
    :type visible: bool
    """

    _attribute_map = {
        'visible': {'key': 'visible', 'type': 'bool'},
    }

    def __init__(self, *, visible: bool=None, **kwargs) -> None:
        super(PrivateLinkServiceVisibility, self).__init__(**kwargs)
        self.visible = visible


class Probe(SubResource):
    """A load balancer probe.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar load_balancing_rules: The load balancer rules that use this probe.
    :vartype load_balancing_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param protocol: Required. The protocol of the end point. If 'Tcp' is
     specified, a received ACK is required for the probe to be successful. If
     'Http' or 'Https' is specified, a 200 OK response from the specifies URI
     is required for the probe to be successful. Possible values include:
     'Http', 'Tcp', 'Https'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.ProbeProtocol
    :param port: Required. The port for communicating the probe. Possible
     values range from 1 to 65535, inclusive.
    :type port: int
    :param interval_in_seconds: The interval, in seconds, for how frequently
     to probe the endpoint for health status. Typically, the interval is
     slightly less than half the allocated timeout period (in seconds) which
     allows two full probes before taking the instance out of rotation. The
     default value is 15, the minimum value is 5.
    :type interval_in_seconds: int
    :param number_of_probes: The number of probes where if no response, will
     result in stopping further traffic from being delivered to the endpoint.
     This values allows endpoints to be taken out of rotation faster or slower
     than the typical times used in Azure.
    :type number_of_probes: int
    :param request_path: The URI used for requesting health status from the
     VM. Path is required if a protocol is set to http. Otherwise, it is not
     allowed. There is no default value.
    :type request_path: str
    :ivar provisioning_state: The provisioning state of the probe resource.
     Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within the set of
     probes used by the load balancer. This name can be used to access the
     resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'load_balancing_rules': {'readonly': True},
        'protocol': {'required': True},
        'port': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'interval_in_seconds': {'key': 'properties.intervalInSeconds', 'type': 'int'},
        'number_of_probes': {'key': 'properties.numberOfProbes', 'type': 'int'},
        'request_path': {'key': 'properties.requestPath', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, protocol, port: int, id: str=None, interval_in_seconds: int=None, number_of_probes: int=None, request_path: str=None, name: str=None, **kwargs) -> None:
        super(Probe, self).__init__(id=id, **kwargs)
        self.load_balancing_rules = None
        self.protocol = protocol
        self.port = port
        self.interval_in_seconds = interval_in_seconds
        self.number_of_probes = number_of_probes
        self.request_path = request_path
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ProtocolConfiguration(Model):
    """Configuration of the protocol.

    :param http_configuration: HTTP configuration of the connectivity check.
    :type http_configuration:
     ~azure.mgmt.network.v2019_09_01.models.HTTPConfiguration
    """

    _attribute_map = {
        'http_configuration': {'key': 'HTTPConfiguration', 'type': 'HTTPConfiguration'},
    }

    def __init__(self, *, http_configuration=None, **kwargs) -> None:
        super(ProtocolConfiguration, self).__init__(**kwargs)
        self.http_configuration = http_configuration


class ProtocolCustomSettingsFormat(Model):
    """DDoS custom policy properties.

    :param protocol: The protocol for which the DDoS protection policy is
     being customized. Possible values include: 'Tcp', 'Udp', 'Syn'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.DdosCustomPolicyProtocol
    :param trigger_rate_override: The customized DDoS protection trigger rate.
    :type trigger_rate_override: str
    :param source_rate_override: The customized DDoS protection source rate.
    :type source_rate_override: str
    :param trigger_sensitivity_override: The customized DDoS protection
     trigger rate sensitivity degrees. High: Trigger rate set with most
     sensitivity w.r.t. normal traffic. Default: Trigger rate set with moderate
     sensitivity w.r.t. normal traffic. Low: Trigger rate set with less
     sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least
     sensitivity w.r.t. normal traffic. Possible values include: 'Relaxed',
     'Low', 'Default', 'High'
    :type trigger_sensitivity_override: str or
     ~azure.mgmt.network.v2019_09_01.models.DdosCustomPolicyTriggerSensitivityOverride
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'trigger_rate_override': {'key': 'triggerRateOverride', 'type': 'str'},
        'source_rate_override': {'key': 'sourceRateOverride', 'type': 'str'},
        'trigger_sensitivity_override': {'key': 'triggerSensitivityOverride', 'type': 'str'},
    }

    def __init__(self, *, protocol=None, trigger_rate_override: str=None, source_rate_override: str=None, trigger_sensitivity_override=None, **kwargs) -> None:
        super(ProtocolCustomSettingsFormat, self).__init__(**kwargs)
        self.protocol = protocol
        self.trigger_rate_override = trigger_rate_override
        self.source_rate_override = source_rate_override
        self.trigger_sensitivity_override = trigger_sensitivity_override


class PublicIPAddress(Resource):
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The public IP address SKU.
    :type sku: ~azure.mgmt.network.v2019_09_01.models.PublicIPAddressSku
    :param public_ip_allocation_method: The public IP address allocation
     method. Possible values include: 'Static', 'Dynamic'
    :type public_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_09_01.models.IPAllocationMethod
    :param public_ip_address_version: The public IP address version. Possible
     values include: 'IPv4', 'IPv6'
    :type public_ip_address_version: str or
     ~azure.mgmt.network.v2019_09_01.models.IPVersion
    :ivar ip_configuration: The IP configuration associated with the public IP
     address.
    :vartype ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.IPConfiguration
    :param dns_settings: The FQDN of the DNS record associated with the public
     IP address.
    :type dns_settings:
     ~azure.mgmt.network.v2019_09_01.models.PublicIPAddressDnsSettings
    :param ddos_settings: The DDoS protection custom policy associated with
     the public IP address.
    :type ddos_settings: ~azure.mgmt.network.v2019_09_01.models.DdosSettings
    :param ip_tags: The list of tags associated with the public IP address.
    :type ip_tags: list[~azure.mgmt.network.v2019_09_01.models.IpTag]
    :param ip_address: The IP address associated with the public IP address
     resource.
    :type ip_address: str
    :param public_ip_prefix: The Public IP Prefix this Public IP Address
     should be allocated from.
    :type public_ip_prefix: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :ivar resource_guid: The resource GUID property of the public IP address
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP address
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param zones: A list of availability zones denoting the IP allocated for
     the resource needs to come from.
    :type zones: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'ip_configuration': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'PublicIPAddressSku'},
        'public_ip_allocation_method': {'key': 'properties.publicIPAllocationMethod', 'type': 'str'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
        'ip_configuration': {'key': 'properties.ipConfiguration', 'type': 'IPConfiguration'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'PublicIPAddressDnsSettings'},
        'ddos_settings': {'key': 'properties.ddosSettings', 'type': 'DdosSettings'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[IpTag]'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'public_ip_prefix': {'key': 'properties.publicIPPrefix', 'type': 'SubResource'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, sku=None, public_ip_allocation_method=None, public_ip_address_version=None, dns_settings=None, ddos_settings=None, ip_tags=None, ip_address: str=None, public_ip_prefix=None, idle_timeout_in_minutes: int=None, zones=None, **kwargs) -> None:
        super(PublicIPAddress, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.public_ip_allocation_method = public_ip_allocation_method
        self.public_ip_address_version = public_ip_address_version
        self.ip_configuration = None
        self.dns_settings = dns_settings
        self.ddos_settings = ddos_settings
        self.ip_tags = ip_tags
        self.ip_address = ip_address
        self.public_ip_prefix = public_ip_prefix
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None
        self.zones = zones


class PublicIPAddressDnsSettings(Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :param domain_name_label: The domain name label. The concatenation of the
     domain name label and the regionalized DNS zone make up the fully
     qualified domain name associated with the public IP address. If a domain
     name label is specified, an A DNS record is created for the public IP in
     the Microsoft Azure DNS system.
    :type domain_name_label: str
    :param fqdn: The Fully Qualified Domain Name of the A DNS record
     associated with the public IP. This is the concatenation of the
     domainNameLabel and the regionalized DNS zone.
    :type fqdn: str
    :param reverse_fqdn: The reverse FQDN. A user-visible, fully qualified
     domain name that resolves to this public IP address. If the reverseFqdn is
     specified, then a PTR DNS record is created pointing from the IP address
     in the in-addr.arpa domain to the reverse FQDN.
    :type reverse_fqdn: str
    """

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'reverse_fqdn': {'key': 'reverseFqdn', 'type': 'str'},
    }

    def __init__(self, *, domain_name_label: str=None, fqdn: str=None, reverse_fqdn: str=None, **kwargs) -> None:
        super(PublicIPAddressDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = domain_name_label
        self.fqdn = fqdn
        self.reverse_fqdn = reverse_fqdn


class PublicIPAddressSku(Model):
    """SKU of a public IP address.

    :param name: Name of a public IP address SKU. Possible values include:
     'Basic', 'Standard'
    :type name: str or
     ~azure.mgmt.network.v2019_09_01.models.PublicIPAddressSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name=None, **kwargs) -> None:
        super(PublicIPAddressSku, self).__init__(**kwargs)
        self.name = name


class PublicIPPrefix(Resource):
    """Public IP prefix resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The public IP prefix SKU.
    :type sku: ~azure.mgmt.network.v2019_09_01.models.PublicIPPrefixSku
    :param public_ip_address_version: The public IP address version. Possible
     values include: 'IPv4', 'IPv6'
    :type public_ip_address_version: str or
     ~azure.mgmt.network.v2019_09_01.models.IPVersion
    :param ip_tags: The list of tags associated with the public IP prefix.
    :type ip_tags: list[~azure.mgmt.network.v2019_09_01.models.IpTag]
    :param prefix_length: The Length of the Public IP Prefix.
    :type prefix_length: int
    :ivar ip_prefix: The allocated Prefix.
    :vartype ip_prefix: str
    :ivar public_ip_addresses: The list of all referenced PublicIPAddresses.
    :vartype public_ip_addresses:
     list[~azure.mgmt.network.v2019_09_01.models.ReferencedPublicIpAddress]
    :ivar load_balancer_frontend_ip_configuration: The reference to load
     balancer frontend IP configuration associated with the public IP prefix.
    :vartype load_balancer_frontend_ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar resource_guid: The resource GUID property of the public IP prefix
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP prefix
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param zones: A list of availability zones denoting the IP allocated for
     the resource needs to come from.
    :type zones: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'ip_prefix': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'load_balancer_frontend_ip_configuration': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'PublicIPPrefixSku'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[IpTag]'},
        'prefix_length': {'key': 'properties.prefixLength', 'type': 'int'},
        'ip_prefix': {'key': 'properties.ipPrefix', 'type': 'str'},
        'public_ip_addresses': {'key': 'properties.publicIPAddresses', 'type': '[ReferencedPublicIpAddress]'},
        'load_balancer_frontend_ip_configuration': {'key': 'properties.loadBalancerFrontendIpConfiguration', 'type': 'SubResource'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, sku=None, public_ip_address_version=None, ip_tags=None, prefix_length: int=None, zones=None, **kwargs) -> None:
        super(PublicIPPrefix, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.public_ip_address_version = public_ip_address_version
        self.ip_tags = ip_tags
        self.prefix_length = prefix_length
        self.ip_prefix = None
        self.public_ip_addresses = None
        self.load_balancer_frontend_ip_configuration = None
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None
        self.zones = zones


class PublicIPPrefixSku(Model):
    """SKU of a public IP prefix.

    :param name: Name of a public IP prefix SKU. Possible values include:
     'Standard'
    :type name: str or
     ~azure.mgmt.network.v2019_09_01.models.PublicIPPrefixSkuName
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name=None, **kwargs) -> None:
        super(PublicIPPrefixSku, self).__init__(**kwargs)
        self.name = name


class QueryTroubleshootingParameters(Model):
    """Parameters that define the resource to query the troubleshooting result.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource ID to query the
     troubleshooting result.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, *, target_resource_id: str, **kwargs) -> None:
        super(QueryTroubleshootingParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id


class ReferencedPublicIpAddress(Model):
    """Reference to a public IP address.

    :param id: The PublicIPAddress Reference.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(ReferencedPublicIpAddress, self).__init__(**kwargs)
        self.id = id


class ResourceNavigationLink(SubResource):
    """ResourceNavigationLink resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param linked_resource_type: Resource type of the linked resource.
    :type linked_resource_type: str
    :param link: Link to the external resource.
    :type link: str
    :ivar provisioning_state: The provisioning state of the resource
     navigation link resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'linked_resource_type': {'key': 'properties.linkedResourceType', 'type': 'str'},
        'link': {'key': 'properties.link', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, linked_resource_type: str=None, link: str=None, name: str=None, **kwargs) -> None:
        super(ResourceNavigationLink, self).__init__(id=id, **kwargs)
        self.linked_resource_type = linked_resource_type
        self.link = link
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class ResourceNavigationLinksListResult(Model):
    """Response for ResourceNavigationLinks_List operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: The resource navigation links in a subnet.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ResourceNavigationLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceNavigationLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(ResourceNavigationLinksListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class RetentionPolicyParameters(Model):
    """Parameters that define the retention policy for flow log.

    :param days: Number of days to retain flow log records. Default value: 0 .
    :type days: int
    :param enabled: Flag to enable/disable retention. Default value: False .
    :type enabled: bool
    """

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, *, days: int=0, enabled: bool=False, **kwargs) -> None:
        super(RetentionPolicyParameters, self).__init__(**kwargs)
        self.days = days
        self.enabled = enabled


class Route(SubResource):
    """Route resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param address_prefix: The destination CIDR to which the route applies.
    :type address_prefix: str
    :param next_hop_type: Required. The type of Azure hop the packet should be
     sent to. Possible values include: 'VirtualNetworkGateway', 'VnetLocal',
     'Internet', 'VirtualAppliance', 'None'
    :type next_hop_type: str or
     ~azure.mgmt.network.v2019_09_01.models.RouteNextHopType
    :param next_hop_ip_address: The IP address packets should be forwarded to.
     Next hop values are only allowed in routes where the next hop type is
     VirtualAppliance.
    :type next_hop_ip_address: str
    :ivar provisioning_state: The provisioning state of the route resource.
     Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'next_hop_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'next_hop_type': {'key': 'properties.nextHopType', 'type': 'str'},
        'next_hop_ip_address': {'key': 'properties.nextHopIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, next_hop_type, id: str=None, address_prefix: str=None, next_hop_ip_address: str=None, name: str=None, **kwargs) -> None:
        super(Route, self).__init__(id=id, **kwargs)
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.provisioning_state = None
        self.name = name
        self.etag = None


class RouteFilter(Resource):
    """Route Filter Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param rules: Collection of RouteFilterRules contained within a route
     filter.
    :type rules: list[~azure.mgmt.network.v2019_09_01.models.RouteFilterRule]
    :ivar peerings: A collection of references to express route circuit
     peerings.
    :vartype peerings:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeering]
    :ivar ipv6_peerings: A collection of references to express route circuit
     ipv6 peerings.
    :vartype ipv6_peerings:
     list[~azure.mgmt.network.v2019_09_01.models.ExpressRouteCircuitPeering]
    :ivar provisioning_state: The provisioning state of the route filter
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'peerings': {'readonly': True},
        'ipv6_peerings': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'rules': {'key': 'properties.rules', 'type': '[RouteFilterRule]'},
        'peerings': {'key': 'properties.peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'ipv6_peerings': {'key': 'properties.ipv6Peerings', 'type': '[ExpressRouteCircuitPeering]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, rules=None, **kwargs) -> None:
        super(RouteFilter, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.rules = rules
        self.peerings = None
        self.ipv6_peerings = None
        self.provisioning_state = None
        self.etag = None


class RouteFilterRule(SubResource):
    """Route Filter Rule Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param access: Required. The access type of the rule. Possible values
     include: 'Allow', 'Deny'
    :type access: str or ~azure.mgmt.network.v2019_09_01.models.Access
    :ivar route_filter_rule_type: Required. The rule type of the rule. Default
     value: "Community" .
    :vartype route_filter_rule_type: str
    :param communities: Required. The collection for bgp community values to
     filter on. e.g. ['12076:5010','12076:5020'].
    :type communities: list[str]
    :ivar provisioning_state: The provisioning state of the route filter rule
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param location: Resource location.
    :type location: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'access': {'required': True},
        'route_filter_rule_type': {'required': True, 'constant': True},
        'communities': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'route_filter_rule_type': {'key': 'properties.routeFilterRuleType', 'type': 'str'},
        'communities': {'key': 'properties.communities', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    route_filter_rule_type = "Community"

    def __init__(self, *, access, communities, id: str=None, name: str=None, location: str=None, **kwargs) -> None:
        super(RouteFilterRule, self).__init__(id=id, **kwargs)
        self.access = access
        self.communities = communities
        self.provisioning_state = None
        self.name = name
        self.location = location
        self.etag = None


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param routes: Collection of routes contained within a route table.
    :type routes: list[~azure.mgmt.network.v2019_09_01.models.Route]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2019_09_01.models.Subnet]
    :param disable_bgp_route_propagation: Whether to disable the routes
     learned by BGP on that route table. True means disable.
    :type disable_bgp_route_propagation: bool
    :ivar provisioning_state: The provisioning state of the route table
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subnets': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'routes': {'key': 'properties.routes', 'type': '[Route]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'disable_bgp_route_propagation': {'key': 'properties.disableBgpRoutePropagation', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, routes=None, disable_bgp_route_propagation: bool=None, **kwargs) -> None:
        super(RouteTable, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.routes = routes
        self.subnets = None
        self.disable_bgp_route_propagation = disable_bgp_route_propagation
        self.provisioning_state = None
        self.etag = None


class SecurityGroupNetworkInterface(Model):
    """Network interface and all its associated security rules.

    :param id: ID of the network interface.
    :type id: str
    :param security_rule_associations: All security rules associated with the
     network interface.
    :type security_rule_associations:
     ~azure.mgmt.network.v2019_09_01.models.SecurityRuleAssociations
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rule_associations': {'key': 'securityRuleAssociations', 'type': 'SecurityRuleAssociations'},
    }

    def __init__(self, *, id: str=None, security_rule_associations=None, **kwargs) -> None:
        super(SecurityGroupNetworkInterface, self).__init__(**kwargs)
        self.id = id
        self.security_rule_associations = security_rule_associations


class SecurityGroupViewParameters(Model):
    """Parameters that define the VM to check security groups for.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. ID of the target VM.
    :type target_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(self, *, target_resource_id: str, **kwargs) -> None:
        super(SecurityGroupViewParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id


class SecurityGroupViewResult(Model):
    """The information about security rules applied to the specified VM.

    :param network_interfaces: List of network interfaces on the specified VM.
    :type network_interfaces:
     list[~azure.mgmt.network.v2019_09_01.models.SecurityGroupNetworkInterface]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[SecurityGroupNetworkInterface]'},
    }

    def __init__(self, *, network_interfaces=None, **kwargs) -> None:
        super(SecurityGroupViewResult, self).__init__(**kwargs)
        self.network_interfaces = network_interfaces


class SecurityRule(SubResource):
    """Network security rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param protocol: Required. Network protocol this rule applies to. Possible
     values include: 'Tcp', 'Udp', 'Icmp', 'Esp', '*', 'Ah'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.SecurityRuleProtocol
    :param source_port_range: The source port or range. Integer or range
     between 0 and 65535. Asterisk '*' can also be used to match all ports.
    :type source_port_range: str
    :param destination_port_range: The destination port or range. Integer or
     range between 0 and 65535. Asterisk '*' can also be used to match all
     ports.
    :type destination_port_range: str
    :param source_address_prefix: The CIDR or source IP range. Asterisk '*'
     can also be used to match all source IPs. Default tags such as
     'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If
     this is an ingress rule, specifies where network traffic originates from.
    :type source_address_prefix: str
    :param source_address_prefixes: The CIDR or source IP ranges.
    :type source_address_prefixes: list[str]
    :param source_application_security_groups: The application security group
     specified as source.
    :type source_application_security_groups:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationSecurityGroup]
    :param destination_address_prefix: The destination address prefix. CIDR or
     destination IP range. Asterisk '*' can also be used to match all source
     IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and
     'Internet' can also be used.
    :type destination_address_prefix: str
    :param destination_address_prefixes: The destination address prefixes.
     CIDR or destination IP ranges.
    :type destination_address_prefixes: list[str]
    :param destination_application_security_groups: The application security
     group specified as destination.
    :type destination_application_security_groups:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationSecurityGroup]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param access: Required. The network traffic is allowed or denied.
     Possible values include: 'Allow', 'Deny'
    :type access: str or
     ~azure.mgmt.network.v2019_09_01.models.SecurityRuleAccess
    :param priority: The priority of the rule. The value can be between 100
     and 4096. The priority number must be unique for each rule in the
     collection. The lower the priority number, the higher the priority of the
     rule.
    :type priority: int
    :param direction: Required. The direction of the rule. The direction
     specifies if rule will be evaluated on incoming or outgoing traffic.
     Possible values include: 'Inbound', 'Outbound'
    :type direction: str or
     ~azure.mgmt.network.v2019_09_01.models.SecurityRuleDirection
    :ivar provisioning_state: The provisioning state of the security rule
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'protocol': {'required': True},
        'access': {'required': True},
        'direction': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'source_port_range': {'key': 'properties.sourcePortRange', 'type': 'str'},
        'destination_port_range': {'key': 'properties.destinationPortRange', 'type': 'str'},
        'source_address_prefix': {'key': 'properties.sourceAddressPrefix', 'type': 'str'},
        'source_address_prefixes': {'key': 'properties.sourceAddressPrefixes', 'type': '[str]'},
        'source_application_security_groups': {'key': 'properties.sourceApplicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'destination_address_prefix': {'key': 'properties.destinationAddressPrefix', 'type': 'str'},
        'destination_address_prefixes': {'key': 'properties.destinationAddressPrefixes', 'type': '[str]'},
        'destination_application_security_groups': {'key': 'properties.destinationApplicationSecurityGroups', 'type': '[ApplicationSecurityGroup]'},
        'source_port_ranges': {'key': 'properties.sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'properties.destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'properties.access', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'direction': {'key': 'properties.direction', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, protocol, access, direction, id: str=None, description: str=None, source_port_range: str=None, destination_port_range: str=None, source_address_prefix: str=None, source_address_prefixes=None, source_application_security_groups=None, destination_address_prefix: str=None, destination_address_prefixes=None, destination_application_security_groups=None, source_port_ranges=None, destination_port_ranges=None, priority: int=None, name: str=None, **kwargs) -> None:
        super(SecurityRule, self).__init__(id=id, **kwargs)
        self.description = description
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_address_prefix = source_address_prefix
        self.source_address_prefixes = source_address_prefixes
        self.source_application_security_groups = source_application_security_groups
        self.destination_address_prefix = destination_address_prefix
        self.destination_address_prefixes = destination_address_prefixes
        self.destination_application_security_groups = destination_application_security_groups
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None
        self.name = name
        self.etag = None


class SecurityRuleAssociations(Model):
    """All security rules associated with the network interface.

    :param network_interface_association: Network interface and it's custom
     security rules.
    :type network_interface_association:
     ~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceAssociation
    :param subnet_association: Subnet and it's custom security rules.
    :type subnet_association:
     ~azure.mgmt.network.v2019_09_01.models.SubnetAssociation
    :param default_security_rules: Collection of default security rules of the
     network security group.
    :type default_security_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SecurityRule]
    :param effective_security_rules: Collection of effective security rules.
    :type effective_security_rules:
     list[~azure.mgmt.network.v2019_09_01.models.EffectiveNetworkSecurityRule]
    """

    _attribute_map = {
        'network_interface_association': {'key': 'networkInterfaceAssociation', 'type': 'NetworkInterfaceAssociation'},
        'subnet_association': {'key': 'subnetAssociation', 'type': 'SubnetAssociation'},
        'default_security_rules': {'key': 'defaultSecurityRules', 'type': '[SecurityRule]'},
        'effective_security_rules': {'key': 'effectiveSecurityRules', 'type': '[EffectiveNetworkSecurityRule]'},
    }

    def __init__(self, *, network_interface_association=None, subnet_association=None, default_security_rules=None, effective_security_rules=None, **kwargs) -> None:
        super(SecurityRuleAssociations, self).__init__(**kwargs)
        self.network_interface_association = network_interface_association
        self.subnet_association = subnet_association
        self.default_security_rules = default_security_rules
        self.effective_security_rules = effective_security_rules


class ServiceAssociationLink(SubResource):
    """ServiceAssociationLink resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param linked_resource_type: Resource type of the linked resource.
    :type linked_resource_type: str
    :param link: Link to the external resource.
    :type link: str
    :ivar provisioning_state: The provisioning state of the service
     association link resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param allow_delete: If true, the resource can be deleted.
    :type allow_delete: bool
    :param locations: A list of locations.
    :type locations: list[str]
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'linked_resource_type': {'key': 'properties.linkedResourceType', 'type': 'str'},
        'link': {'key': 'properties.link', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'allow_delete': {'key': 'properties.allowDelete', 'type': 'bool'},
        'locations': {'key': 'properties.locations', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, linked_resource_type: str=None, link: str=None, allow_delete: bool=None, locations=None, name: str=None, **kwargs) -> None:
        super(ServiceAssociationLink, self).__init__(id=id, **kwargs)
        self.linked_resource_type = linked_resource_type
        self.link = link
        self.provisioning_state = None
        self.allow_delete = allow_delete
        self.locations = locations
        self.name = name
        self.etag = None
        self.type = None


class ServiceAssociationLinksListResult(Model):
    """Response for ServiceAssociationLinks_List operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: The service association links in a subnet.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.ServiceAssociationLink]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceAssociationLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(ServiceAssociationLinksListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceEndpointPolicy(Resource):
    """Service End point policy resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param service_endpoint_policy_definitions: A collection of service
     endpoint policy definitions of the service endpoint policy.
    :type service_endpoint_policy_definitions:
     list[~azure.mgmt.network.v2019_09_01.models.ServiceEndpointPolicyDefinition]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2019_09_01.models.Subnet]
    :ivar resource_guid: The resource GUID property of the service endpoint
     policy resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the service endpoint
     policy resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subnets': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_endpoint_policy_definitions': {'key': 'properties.serviceEndpointPolicyDefinitions', 'type': '[ServiceEndpointPolicyDefinition]'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, service_endpoint_policy_definitions=None, **kwargs) -> None:
        super(ServiceEndpointPolicy, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.service_endpoint_policy_definitions = service_endpoint_policy_definitions
        self.subnets = None
        self.resource_guid = None
        self.provisioning_state = None
        self.etag = None


class ServiceEndpointPolicyDefinition(SubResource):
    """Service Endpoint policy definitions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param description: A description for this rule. Restricted to 140 chars.
    :type description: str
    :param service: Service endpoint name.
    :type service: str
    :param service_resources: A list of service resources.
    :type service_resources: list[str]
    :ivar provisioning_state: The provisioning state of the service endpoint
     policy definition resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'service': {'key': 'properties.service', 'type': 'str'},
        'service_resources': {'key': 'properties.serviceResources', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, description: str=None, service: str=None, service_resources=None, name: str=None, **kwargs) -> None:
        super(ServiceEndpointPolicyDefinition, self).__init__(id=id, **kwargs)
        self.description = description
        self.service = service
        self.service_resources = service_resources
        self.provisioning_state = None
        self.name = name
        self.etag = None


class ServiceEndpointPropertiesFormat(Model):
    """The service endpoint properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param service: The type of the endpoint service.
    :type service: str
    :param locations: A list of locations.
    :type locations: list[str]
    :ivar provisioning_state: The provisioning state of the service endpoint
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'service': {'key': 'service', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(self, *, service: str=None, locations=None, **kwargs) -> None:
        super(ServiceEndpointPropertiesFormat, self).__init__(**kwargs)
        self.service = service
        self.locations = locations
        self.provisioning_state = None


class ServiceTagInformation(Model):
    """The service tag information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar properties: Properties of the service tag information.
    :vartype properties:
     ~azure.mgmt.network.v2019_09_01.models.ServiceTagInformationPropertiesFormat
    :ivar name: The name of service tag.
    :vartype name: str
    :ivar id: The ID of service tag.
    :vartype id: str
    """

    _validation = {
        'properties': {'readonly': True},
        'name': {'readonly': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ServiceTagInformationPropertiesFormat'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServiceTagInformation, self).__init__(**kwargs)
        self.properties = None
        self.name = None
        self.id = None


class ServiceTagInformationPropertiesFormat(Model):
    """Properties of the service tag information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar change_number: The iteration number of service tag.
    :vartype change_number: str
    :ivar region: The region of service tag.
    :vartype region: str
    :ivar system_service: The name of system service.
    :vartype system_service: str
    :ivar address_prefixes: The list of IP address prefixes.
    :vartype address_prefixes: list[str]
    """

    _validation = {
        'change_number': {'readonly': True},
        'region': {'readonly': True},
        'system_service': {'readonly': True},
        'address_prefixes': {'readonly': True},
    }

    _attribute_map = {
        'change_number': {'key': 'changeNumber', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'system_service': {'key': 'systemService', 'type': 'str'},
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServiceTagInformationPropertiesFormat, self).__init__(**kwargs)
        self.change_number = None
        self.region = None
        self.system_service = None
        self.address_prefixes = None


class ServiceTagsListResult(Model):
    """Response for the ListServiceTags API service call.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the cloud.
    :vartype name: str
    :ivar id: The ID of the cloud.
    :vartype id: str
    :ivar type: The azure resource type.
    :vartype type: str
    :ivar change_number: The iteration number.
    :vartype change_number: str
    :ivar cloud: The name of the cloud.
    :vartype cloud: str
    :ivar values: The list of service tag information resources.
    :vartype values:
     list[~azure.mgmt.network.v2019_09_01.models.ServiceTagInformation]
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'change_number': {'readonly': True},
        'cloud': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'change_number': {'key': 'changeNumber', 'type': 'str'},
        'cloud': {'key': 'cloud', 'type': 'str'},
        'values': {'key': 'values', 'type': '[ServiceTagInformation]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServiceTagsListResult, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.change_number = None
        self.cloud = None
        self.values = None


class Subnet(SubResource):
    """Subnet in a virtual network resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param address_prefix: The address prefix for the subnet.
    :type address_prefix: str
    :param address_prefixes: List of address prefixes for the subnet.
    :type address_prefixes: list[str]
    :param network_security_group: The reference of the NetworkSecurityGroup
     resource.
    :type network_security_group:
     ~azure.mgmt.network.v2019_09_01.models.NetworkSecurityGroup
    :param route_table: The reference of the RouteTable resource.
    :type route_table: ~azure.mgmt.network.v2019_09_01.models.RouteTable
    :param nat_gateway: Nat gateway associated with this subnet.
    :type nat_gateway: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param service_endpoints: An array of service endpoints.
    :type service_endpoints:
     list[~azure.mgmt.network.v2019_09_01.models.ServiceEndpointPropertiesFormat]
    :param service_endpoint_policies: An array of service endpoint policies.
    :type service_endpoint_policies:
     list[~azure.mgmt.network.v2019_09_01.models.ServiceEndpointPolicy]
    :ivar private_endpoints: An array of references to private endpoints.
    :vartype private_endpoints:
     list[~azure.mgmt.network.v2019_09_01.models.PrivateEndpoint]
    :ivar ip_configurations: An array of references to the network interface
     IP configurations using subnet.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.IPConfiguration]
    :ivar ip_configuration_profiles: Array of IP configuration profiles which
     reference this subnet.
    :vartype ip_configuration_profiles:
     list[~azure.mgmt.network.v2019_09_01.models.IPConfigurationProfile]
    :ivar resource_navigation_links: An array of references to the external
     resources using subnet.
    :vartype resource_navigation_links:
     list[~azure.mgmt.network.v2019_09_01.models.ResourceNavigationLink]
    :ivar service_association_links: An array of references to services
     injecting into this subnet.
    :vartype service_association_links:
     list[~azure.mgmt.network.v2019_09_01.models.ServiceAssociationLink]
    :param delegations: An array of references to the delegations on the
     subnet.
    :type delegations: list[~azure.mgmt.network.v2019_09_01.models.Delegation]
    :ivar purpose: A read-only string identifying the intention of use for
     this subnet based on delegations and other user-defined properties.
    :vartype purpose: str
    :ivar provisioning_state: The provisioning state of the subnet resource.
     Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param private_endpoint_network_policies: Enable or Disable apply network
     policies on private end point in the subnet.
    :type private_endpoint_network_policies: str
    :param private_link_service_network_policies: Enable or Disable apply
     network policies on private link service in the subnet.
    :type private_link_service_network_policies: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'private_endpoints': {'readonly': True},
        'ip_configurations': {'readonly': True},
        'ip_configuration_profiles': {'readonly': True},
        'resource_navigation_links': {'readonly': True},
        'service_association_links': {'readonly': True},
        'purpose': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'address_prefixes': {'key': 'properties.addressPrefixes', 'type': '[str]'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'NetworkSecurityGroup'},
        'route_table': {'key': 'properties.routeTable', 'type': 'RouteTable'},
        'nat_gateway': {'key': 'properties.natGateway', 'type': 'SubResource'},
        'service_endpoints': {'key': 'properties.serviceEndpoints', 'type': '[ServiceEndpointPropertiesFormat]'},
        'service_endpoint_policies': {'key': 'properties.serviceEndpointPolicies', 'type': '[ServiceEndpointPolicy]'},
        'private_endpoints': {'key': 'properties.privateEndpoints', 'type': '[PrivateEndpoint]'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[IPConfiguration]'},
        'ip_configuration_profiles': {'key': 'properties.ipConfigurationProfiles', 'type': '[IPConfigurationProfile]'},
        'resource_navigation_links': {'key': 'properties.resourceNavigationLinks', 'type': '[ResourceNavigationLink]'},
        'service_association_links': {'key': 'properties.serviceAssociationLinks', 'type': '[ServiceAssociationLink]'},
        'delegations': {'key': 'properties.delegations', 'type': '[Delegation]'},
        'purpose': {'key': 'properties.purpose', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_network_policies': {'key': 'properties.privateEndpointNetworkPolicies', 'type': 'str'},
        'private_link_service_network_policies': {'key': 'properties.privateLinkServiceNetworkPolicies', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, address_prefix: str=None, address_prefixes=None, network_security_group=None, route_table=None, nat_gateway=None, service_endpoints=None, service_endpoint_policies=None, delegations=None, private_endpoint_network_policies: str=None, private_link_service_network_policies: str=None, name: str=None, **kwargs) -> None:
        super(Subnet, self).__init__(id=id, **kwargs)
        self.address_prefix = address_prefix
        self.address_prefixes = address_prefixes
        self.network_security_group = network_security_group
        self.route_table = route_table
        self.nat_gateway = nat_gateway
        self.service_endpoints = service_endpoints
        self.service_endpoint_policies = service_endpoint_policies
        self.private_endpoints = None
        self.ip_configurations = None
        self.ip_configuration_profiles = None
        self.resource_navigation_links = None
        self.service_association_links = None
        self.delegations = delegations
        self.purpose = None
        self.provisioning_state = None
        self.private_endpoint_network_policies = private_endpoint_network_policies
        self.private_link_service_network_policies = private_link_service_network_policies
        self.name = name
        self.etag = None


class SubnetAssociation(Model):
    """Subnet and it's custom security rules.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Subnet ID.
    :vartype id: str
    :param security_rules: Collection of custom security rules.
    :type security_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SecurityRule]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'security_rules': {'key': 'securityRules', 'type': '[SecurityRule]'},
    }

    def __init__(self, *, security_rules=None, **kwargs) -> None:
        super(SubnetAssociation, self).__init__(**kwargs)
        self.id = None
        self.security_rules = security_rules


class TagsObject(Model):
    """Tags object for patch operations.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags


class Topology(Model):
    """Topology of the specified resource group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: GUID representing the operation id.
    :vartype id: str
    :ivar created_date_time: The datetime when the topology was initially
     created for the resource group.
    :vartype created_date_time: datetime
    :ivar last_modified: The datetime when the topology was last modified.
    :vartype last_modified: datetime
    :param resources: A list of topology resources.
    :type resources:
     list[~azure.mgmt.network.v2019_09_01.models.TopologyResource]
    """

    _validation = {
        'id': {'readonly': True},
        'created_date_time': {'readonly': True},
        'last_modified': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'resources': {'key': 'resources', 'type': '[TopologyResource]'},
    }

    def __init__(self, *, resources=None, **kwargs) -> None:
        super(Topology, self).__init__(**kwargs)
        self.id = None
        self.created_date_time = None
        self.last_modified = None
        self.resources = resources


class TopologyAssociation(Model):
    """Resources that have an association with the parent resource.

    :param name: The name of the resource that is associated with the parent
     resource.
    :type name: str
    :param resource_id: The ID of the resource that is associated with the
     parent resource.
    :type resource_id: str
    :param association_type: The association type of the child resource to the
     parent resource. Possible values include: 'Associated', 'Contains'
    :type association_type: str or
     ~azure.mgmt.network.v2019_09_01.models.AssociationType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'association_type': {'key': 'associationType', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, resource_id: str=None, association_type=None, **kwargs) -> None:
        super(TopologyAssociation, self).__init__(**kwargs)
        self.name = name
        self.resource_id = resource_id
        self.association_type = association_type


class TopologyParameters(Model):
    """Parameters that define the representation of topology.

    :param target_resource_group_name: The name of the target resource group
     to perform topology on.
    :type target_resource_group_name: str
    :param target_virtual_network: The reference of the Virtual Network
     resource.
    :type target_virtual_network:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param target_subnet: The reference of the Subnet resource.
    :type target_subnet: ~azure.mgmt.network.v2019_09_01.models.SubResource
    """

    _attribute_map = {
        'target_resource_group_name': {'key': 'targetResourceGroupName', 'type': 'str'},
        'target_virtual_network': {'key': 'targetVirtualNetwork', 'type': 'SubResource'},
        'target_subnet': {'key': 'targetSubnet', 'type': 'SubResource'},
    }

    def __init__(self, *, target_resource_group_name: str=None, target_virtual_network=None, target_subnet=None, **kwargs) -> None:
        super(TopologyParameters, self).__init__(**kwargs)
        self.target_resource_group_name = target_resource_group_name
        self.target_virtual_network = target_virtual_network
        self.target_subnet = target_subnet


class TopologyResource(Model):
    """The network resource topology information for the given resource group.

    :param name: Name of the resource.
    :type name: str
    :param id: ID of the resource.
    :type id: str
    :param location: Resource location.
    :type location: str
    :param associations: Holds the associations the resource has with other
     resources in the resource group.
    :type associations:
     list[~azure.mgmt.network.v2019_09_01.models.TopologyAssociation]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'associations': {'key': 'associations', 'type': '[TopologyAssociation]'},
    }

    def __init__(self, *, name: str=None, id: str=None, location: str=None, associations=None, **kwargs) -> None:
        super(TopologyResource, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.location = location
        self.associations = associations


class TrafficAnalyticsConfigurationProperties(Model):
    """Parameters that define the configuration of traffic analytics.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Flag to enable/disable traffic analytics.
    :type enabled: bool
    :param workspace_id: The resource guid of the attached workspace.
    :type workspace_id: str
    :param workspace_region: The location of the attached workspace.
    :type workspace_region: str
    :param workspace_resource_id: Resource Id of the attached workspace.
    :type workspace_resource_id: str
    :param traffic_analytics_interval: The interval in minutes which would
     decide how frequently TA service should do flow analytics.
    :type traffic_analytics_interval: int
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'workspace_region': {'key': 'workspaceRegion', 'type': 'str'},
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': 'str'},
        'traffic_analytics_interval': {'key': 'trafficAnalyticsInterval', 'type': 'int'},
    }

    def __init__(self, *, enabled: bool, workspace_id: str=None, workspace_region: str=None, workspace_resource_id: str=None, traffic_analytics_interval: int=None, **kwargs) -> None:
        super(TrafficAnalyticsConfigurationProperties, self).__init__(**kwargs)
        self.enabled = enabled
        self.workspace_id = workspace_id
        self.workspace_region = workspace_region
        self.workspace_resource_id = workspace_resource_id
        self.traffic_analytics_interval = traffic_analytics_interval


class TrafficAnalyticsProperties(Model):
    """Parameters that define the configuration of traffic analytics.

    All required parameters must be populated in order to send to Azure.

    :param network_watcher_flow_analytics_configuration: Required. Parameters
     that define the configuration of traffic analytics.
    :type network_watcher_flow_analytics_configuration:
     ~azure.mgmt.network.v2019_09_01.models.TrafficAnalyticsConfigurationProperties
    """

    _validation = {
        'network_watcher_flow_analytics_configuration': {'required': True},
    }

    _attribute_map = {
        'network_watcher_flow_analytics_configuration': {'key': 'networkWatcherFlowAnalyticsConfiguration', 'type': 'TrafficAnalyticsConfigurationProperties'},
    }

    def __init__(self, *, network_watcher_flow_analytics_configuration, **kwargs) -> None:
        super(TrafficAnalyticsProperties, self).__init__(**kwargs)
        self.network_watcher_flow_analytics_configuration = network_watcher_flow_analytics_configuration


class TrafficSelectorPolicy(Model):
    """An traffic selector policy for a virtual network gateway connection.

    All required parameters must be populated in order to send to Azure.

    :param local_address_ranges: Required. A collection of local address
     spaces in CIDR format
    :type local_address_ranges: list[str]
    :param remote_address_ranges: Required. A collection of remote address
     spaces in CIDR format
    :type remote_address_ranges: list[str]
    """

    _validation = {
        'local_address_ranges': {'required': True},
        'remote_address_ranges': {'required': True},
    }

    _attribute_map = {
        'local_address_ranges': {'key': 'localAddressRanges', 'type': '[str]'},
        'remote_address_ranges': {'key': 'remoteAddressRanges', 'type': '[str]'},
    }

    def __init__(self, *, local_address_ranges, remote_address_ranges, **kwargs) -> None:
        super(TrafficSelectorPolicy, self).__init__(**kwargs)
        self.local_address_ranges = local_address_ranges
        self.remote_address_ranges = remote_address_ranges


class TroubleshootingDetails(Model):
    """Information gained from troubleshooting of specified resource.

    :param id: The id of the get troubleshoot operation.
    :type id: str
    :param reason_type: Reason type of failure.
    :type reason_type: str
    :param summary: A summary of troubleshooting.
    :type summary: str
    :param detail: Details on troubleshooting results.
    :type detail: str
    :param recommended_actions: List of recommended actions.
    :type recommended_actions:
     list[~azure.mgmt.network.v2019_09_01.models.TroubleshootingRecommendedActions]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'reason_type': {'key': 'reasonType', 'type': 'str'},
        'summary': {'key': 'summary', 'type': 'str'},
        'detail': {'key': 'detail', 'type': 'str'},
        'recommended_actions': {'key': 'recommendedActions', 'type': '[TroubleshootingRecommendedActions]'},
    }

    def __init__(self, *, id: str=None, reason_type: str=None, summary: str=None, detail: str=None, recommended_actions=None, **kwargs) -> None:
        super(TroubleshootingDetails, self).__init__(**kwargs)
        self.id = id
        self.reason_type = reason_type
        self.summary = summary
        self.detail = detail
        self.recommended_actions = recommended_actions


class TroubleshootingParameters(Model):
    """Parameters that define the resource to troubleshoot.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The target resource to troubleshoot.
    :type target_resource_id: str
    :param storage_id: Required. The ID for the storage account to save the
     troubleshoot result.
    :type storage_id: str
    :param storage_path: Required. The path to the blob to save the
     troubleshoot result in.
    :type storage_path: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'storage_id': {'required': True},
        'storage_path': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'storage_id': {'key': 'properties.storageId', 'type': 'str'},
        'storage_path': {'key': 'properties.storagePath', 'type': 'str'},
    }

    def __init__(self, *, target_resource_id: str, storage_id: str, storage_path: str, **kwargs) -> None:
        super(TroubleshootingParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.storage_id = storage_id
        self.storage_path = storage_path


class TroubleshootingRecommendedActions(Model):
    """Recommended actions based on discovered issues.

    :param action_id: ID of the recommended action.
    :type action_id: str
    :param action_text: Description of recommended actions.
    :type action_text: str
    :param action_uri: The uri linking to a documentation for the recommended
     troubleshooting actions.
    :type action_uri: str
    :param action_uri_text: The information from the URI for the recommended
     troubleshooting actions.
    :type action_uri_text: str
    """

    _attribute_map = {
        'action_id': {'key': 'actionId', 'type': 'str'},
        'action_text': {'key': 'actionText', 'type': 'str'},
        'action_uri': {'key': 'actionUri', 'type': 'str'},
        'action_uri_text': {'key': 'actionUriText', 'type': 'str'},
    }

    def __init__(self, *, action_id: str=None, action_text: str=None, action_uri: str=None, action_uri_text: str=None, **kwargs) -> None:
        super(TroubleshootingRecommendedActions, self).__init__(**kwargs)
        self.action_id = action_id
        self.action_text = action_text
        self.action_uri = action_uri
        self.action_uri_text = action_uri_text


class TroubleshootingResult(Model):
    """Troubleshooting information gained from specified resource.

    :param start_time: The start time of the troubleshooting.
    :type start_time: datetime
    :param end_time: The end time of the troubleshooting.
    :type end_time: datetime
    :param code: The result code of the troubleshooting.
    :type code: str
    :param results: Information from troubleshooting.
    :type results:
     list[~azure.mgmt.network.v2019_09_01.models.TroubleshootingDetails]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'code': {'key': 'code', 'type': 'str'},
        'results': {'key': 'results', 'type': '[TroubleshootingDetails]'},
    }

    def __init__(self, *, start_time=None, end_time=None, code: str=None, results=None, **kwargs) -> None:
        super(TroubleshootingResult, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.code = code
        self.results = results


class TunnelConnectionHealth(Model):
    """VirtualNetworkGatewayConnection properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar tunnel: Tunnel name.
    :vartype tunnel: str
    :ivar connection_status: Virtual Network Gateway connection status.
     Possible values include: 'Unknown', 'Connecting', 'Connected',
     'NotConnected'
    :vartype connection_status: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar ingress_bytes_transferred: The Ingress Bytes Transferred in this
     connection.
    :vartype ingress_bytes_transferred: long
    :ivar egress_bytes_transferred: The Egress Bytes Transferred in this
     connection.
    :vartype egress_bytes_transferred: long
    :ivar last_connection_established_utc_time: The time at which connection
     was established in Utc format.
    :vartype last_connection_established_utc_time: str
    """

    _validation = {
        'tunnel': {'readonly': True},
        'connection_status': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'last_connection_established_utc_time': {'readonly': True},
    }

    _attribute_map = {
        'tunnel': {'key': 'tunnel', 'type': 'str'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'ingress_bytes_transferred': {'key': 'ingressBytesTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'egressBytesTransferred', 'type': 'long'},
        'last_connection_established_utc_time': {'key': 'lastConnectionEstablishedUtcTime', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(TunnelConnectionHealth, self).__init__(**kwargs)
        self.tunnel = None
        self.connection_status = None
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.last_connection_established_utc_time = None


class UnprepareNetworkPoliciesRequest(Model):
    """Details of UnprepareNetworkPolicies for Subnet.

    :param service_name: The name of the service for which subnet is being
     unprepared for.
    :type service_name: str
    """

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
    }

    def __init__(self, *, service_name: str=None, **kwargs) -> None:
        super(UnprepareNetworkPoliciesRequest, self).__init__(**kwargs)
        self.service_name = service_name


class Usage(Model):
    """Describes network resource usage.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource identifier.
    :vartype id: str
    :ivar unit: Required. An enum describing the unit of measurement. Default
     value: "Count" .
    :vartype unit: str
    :param current_value: Required. The current value of the usage.
    :type current_value: long
    :param limit: Required. The limit of usage.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.network.v2019_09_01.models.UsageName
    """

    _validation = {
        'id': {'readonly': True},
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(self, *, current_value: int, limit: int, name, **kwargs) -> None:
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(Model):
    """The usage names.

    :param value: A string describing the resource name.
    :type value: str
    :param localized_value: A localized string describing the resource name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, *, value: str=None, localized_value: str=None, **kwargs) -> None:
        super(UsageName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class VerificationIPFlowParameters(Model):
    """Parameters that define the IP flow to be verified.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_id: Required. The ID of the target resource to
     perform next-hop on.
    :type target_resource_id: str
    :param direction: Required. The direction of the packet represented as a
     5-tuple. Possible values include: 'Inbound', 'Outbound'
    :type direction: str or ~azure.mgmt.network.v2019_09_01.models.Direction
    :param protocol: Required. Protocol to be verified on. Possible values
     include: 'TCP', 'UDP'
    :type protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.IpFlowProtocol
    :param local_port: Required. The local port. Acceptable values are a
     single integer in the range (0-65535). Support for * for the source port,
     which depends on the direction.
    :type local_port: str
    :param remote_port: Required. The remote port. Acceptable values are a
     single integer in the range (0-65535). Support for * for the source port,
     which depends on the direction.
    :type remote_port: str
    :param local_ip_address: Required. The local IP address. Acceptable values
     are valid IPv4 addresses.
    :type local_ip_address: str
    :param remote_ip_address: Required. The remote IP address. Acceptable
     values are valid IPv4 addresses.
    :type remote_ip_address: str
    :param target_nic_resource_id: The NIC ID. (If VM has multiple NICs and IP
     forwarding is enabled on any of them, then this parameter must be
     specified. Otherwise optional).
    :type target_nic_resource_id: str
    """

    _validation = {
        'target_resource_id': {'required': True},
        'direction': {'required': True},
        'protocol': {'required': True},
        'local_port': {'required': True},
        'remote_port': {'required': True},
        'local_ip_address': {'required': True},
        'remote_ip_address': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'local_port': {'key': 'localPort', 'type': 'str'},
        'remote_port': {'key': 'remotePort', 'type': 'str'},
        'local_ip_address': {'key': 'localIPAddress', 'type': 'str'},
        'remote_ip_address': {'key': 'remoteIPAddress', 'type': 'str'},
        'target_nic_resource_id': {'key': 'targetNicResourceId', 'type': 'str'},
    }

    def __init__(self, *, target_resource_id: str, direction, protocol, local_port: str, remote_port: str, local_ip_address: str, remote_ip_address: str, target_nic_resource_id: str=None, **kwargs) -> None:
        super(VerificationIPFlowParameters, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.direction = direction
        self.protocol = protocol
        self.local_port = local_port
        self.remote_port = remote_port
        self.local_ip_address = local_ip_address
        self.remote_ip_address = remote_ip_address
        self.target_nic_resource_id = target_nic_resource_id


class VerificationIPFlowResult(Model):
    """Results of IP flow verification on the target resource.

    :param access: Indicates whether the traffic is allowed or denied.
     Possible values include: 'Allow', 'Deny'
    :type access: str or ~azure.mgmt.network.v2019_09_01.models.Access
    :param rule_name: Name of the rule. If input is not matched against any
     security rule, it is not displayed.
    :type rule_name: str
    """

    _attribute_map = {
        'access': {'key': 'access', 'type': 'str'},
        'rule_name': {'key': 'ruleName', 'type': 'str'},
    }

    def __init__(self, *, access=None, rule_name: str=None, **kwargs) -> None:
        super(VerificationIPFlowResult, self).__init__(**kwargs)
        self.access = access
        self.rule_name = rule_name


class VirtualHub(Resource):
    """VirtualHub Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param virtual_wan: The VirtualWAN to which the VirtualHub belongs.
    :type virtual_wan: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param vpn_gateway: The VpnGateway associated with this VirtualHub.
    :type vpn_gateway: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param p2_svpn_gateway: The P2SVpnGateway associated with this VirtualHub.
    :type p2_svpn_gateway: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param express_route_gateway: The expressRouteGateway associated with this
     VirtualHub.
    :type express_route_gateway:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param azure_firewall: The azureFirewall associated with this VirtualHub.
    :type azure_firewall: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param virtual_network_connections: List of all vnet connections with this
     VirtualHub.
    :type virtual_network_connections:
     list[~azure.mgmt.network.v2019_09_01.models.HubVirtualNetworkConnection]
    :param address_prefix: Address-prefix for this VirtualHub.
    :type address_prefix: str
    :param route_table: The routeTable associated with this virtual hub.
    :type route_table:
     ~azure.mgmt.network.v2019_09_01.models.VirtualHubRouteTable
    :ivar provisioning_state: The provisioning state of the virtual hub
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param security_provider_name: The Security Provider name.
    :type security_provider_name: str
    :param virtual_hub_route_table_v2s: List of all virtual hub route table
     v2s associated with this VirtualHub.
    :type virtual_hub_route_table_v2s:
     list[~azure.mgmt.network.v2019_09_01.models.VirtualHubRouteTableV2]
    :param sku: The sku of this VirtualHub.
    :type sku: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'virtual_wan': {'key': 'properties.virtualWan', 'type': 'SubResource'},
        'vpn_gateway': {'key': 'properties.vpnGateway', 'type': 'SubResource'},
        'p2_svpn_gateway': {'key': 'properties.p2SVpnGateway', 'type': 'SubResource'},
        'express_route_gateway': {'key': 'properties.expressRouteGateway', 'type': 'SubResource'},
        'azure_firewall': {'key': 'properties.azureFirewall', 'type': 'SubResource'},
        'virtual_network_connections': {'key': 'properties.virtualNetworkConnections', 'type': '[HubVirtualNetworkConnection]'},
        'address_prefix': {'key': 'properties.addressPrefix', 'type': 'str'},
        'route_table': {'key': 'properties.routeTable', 'type': 'VirtualHubRouteTable'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'security_provider_name': {'key': 'properties.securityProviderName', 'type': 'str'},
        'virtual_hub_route_table_v2s': {'key': 'properties.virtualHubRouteTableV2s', 'type': '[VirtualHubRouteTableV2]'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, virtual_wan=None, vpn_gateway=None, p2_svpn_gateway=None, express_route_gateway=None, azure_firewall=None, virtual_network_connections=None, address_prefix: str=None, route_table=None, security_provider_name: str=None, virtual_hub_route_table_v2s=None, sku: str=None, **kwargs) -> None:
        super(VirtualHub, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.virtual_wan = virtual_wan
        self.vpn_gateway = vpn_gateway
        self.p2_svpn_gateway = p2_svpn_gateway
        self.express_route_gateway = express_route_gateway
        self.azure_firewall = azure_firewall
        self.virtual_network_connections = virtual_network_connections
        self.address_prefix = address_prefix
        self.route_table = route_table
        self.provisioning_state = None
        self.security_provider_name = security_provider_name
        self.virtual_hub_route_table_v2s = virtual_hub_route_table_v2s
        self.sku = sku
        self.etag = None


class VirtualHubId(Model):
    """Virtual Hub identifier.

    :param id: The resource URI for the Virtual Hub where the ExpressRoute
     gateway is or will be deployed. The Virtual Hub resource and the
     ExpressRoute gateway resource reside in the same subscription.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(VirtualHubId, self).__init__(**kwargs)
        self.id = id


class VirtualHubRoute(Model):
    """VirtualHub route.

    :param address_prefixes: List of all addressPrefixes.
    :type address_prefixes: list[str]
    :param next_hop_ip_address: NextHop ip address.
    :type next_hop_ip_address: str
    """

    _attribute_map = {
        'address_prefixes': {'key': 'addressPrefixes', 'type': '[str]'},
        'next_hop_ip_address': {'key': 'nextHopIpAddress', 'type': 'str'},
    }

    def __init__(self, *, address_prefixes=None, next_hop_ip_address: str=None, **kwargs) -> None:
        super(VirtualHubRoute, self).__init__(**kwargs)
        self.address_prefixes = address_prefixes
        self.next_hop_ip_address = next_hop_ip_address


class VirtualHubRouteTable(Model):
    """VirtualHub route table.

    :param routes: List of all routes.
    :type routes: list[~azure.mgmt.network.v2019_09_01.models.VirtualHubRoute]
    """

    _attribute_map = {
        'routes': {'key': 'routes', 'type': '[VirtualHubRoute]'},
    }

    def __init__(self, *, routes=None, **kwargs) -> None:
        super(VirtualHubRouteTable, self).__init__(**kwargs)
        self.routes = routes


class VirtualHubRouteTableV2(SubResource):
    """VirtualHubRouteTableV2 Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param routes: List of all routes.
    :type routes:
     list[~azure.mgmt.network.v2019_09_01.models.VirtualHubRouteV2]
    :param attached_connections: List of all connections attached to this
     route table v2.
    :type attached_connections: list[str]
    :ivar provisioning_state: The provisioning state of the virtual hub route
     table v2 resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[VirtualHubRouteV2]'},
        'attached_connections': {'key': 'properties.attachedConnections', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, routes=None, attached_connections=None, name: str=None, **kwargs) -> None:
        super(VirtualHubRouteTableV2, self).__init__(id=id, **kwargs)
        self.routes = routes
        self.attached_connections = attached_connections
        self.provisioning_state = None
        self.name = name
        self.etag = None


class VirtualHubRouteV2(Model):
    """VirtualHubRouteTableV2 route.

    :param destination_type: The type of destinations
    :type destination_type: str
    :param destinations: List of all destinations.
    :type destinations: list[str]
    :param next_hop_type: The type of next hops
    :type next_hop_type: str
    :param next_hops: NextHops ip address.
    :type next_hops: list[str]
    """

    _attribute_map = {
        'destination_type': {'key': 'destinationType', 'type': 'str'},
        'destinations': {'key': 'destinations', 'type': '[str]'},
        'next_hop_type': {'key': 'nextHopType', 'type': 'str'},
        'next_hops': {'key': 'nextHops', 'type': '[str]'},
    }

    def __init__(self, *, destination_type: str=None, destinations=None, next_hop_type: str=None, next_hops=None, **kwargs) -> None:
        super(VirtualHubRouteV2, self).__init__(**kwargs)
        self.destination_type = destination_type
        self.destinations = destinations
        self.next_hop_type = next_hop_type
        self.next_hops = next_hops


class VirtualNetwork(Resource):
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param address_space: The AddressSpace that contains an array of IP
     address ranges that can be used by subnets.
    :type address_space: ~azure.mgmt.network.v2019_09_01.models.AddressSpace
    :param dhcp_options: The dhcpOptions that contains an array of DNS servers
     available to VMs deployed in the virtual network.
    :type dhcp_options: ~azure.mgmt.network.v2019_09_01.models.DhcpOptions
    :param subnets: A list of subnets in a Virtual Network.
    :type subnets: list[~azure.mgmt.network.v2019_09_01.models.Subnet]
    :param virtual_network_peerings: A list of peerings in a Virtual Network.
    :type virtual_network_peerings:
     list[~azure.mgmt.network.v2019_09_01.models.VirtualNetworkPeering]
    :ivar resource_guid: The resourceGuid property of the Virtual Network
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param enable_ddos_protection: Indicates if DDoS protection is enabled for
     all the protected resources in the virtual network. It requires a DDoS
     protection plan associated with the resource. Default value: False .
    :type enable_ddos_protection: bool
    :param enable_vm_protection: Indicates if VM protection is enabled for all
     the subnets in the virtual network. Default value: False .
    :type enable_vm_protection: bool
    :param ddos_protection_plan: The DDoS protection plan associated with the
     virtual network.
    :type ddos_protection_plan:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param bgp_communities: Bgp Communities sent over ExpressRoute with each
     route corresponding to a prefix in this VNET.
    :type bgp_communities:
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkBgpCommunities
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'address_space': {'key': 'properties.addressSpace', 'type': 'AddressSpace'},
        'dhcp_options': {'key': 'properties.dhcpOptions', 'type': 'DhcpOptions'},
        'subnets': {'key': 'properties.subnets', 'type': '[Subnet]'},
        'virtual_network_peerings': {'key': 'properties.virtualNetworkPeerings', 'type': '[VirtualNetworkPeering]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'enable_ddos_protection': {'key': 'properties.enableDdosProtection', 'type': 'bool'},
        'enable_vm_protection': {'key': 'properties.enableVmProtection', 'type': 'bool'},
        'ddos_protection_plan': {'key': 'properties.ddosProtectionPlan', 'type': 'SubResource'},
        'bgp_communities': {'key': 'properties.bgpCommunities', 'type': 'VirtualNetworkBgpCommunities'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, address_space=None, dhcp_options=None, subnets=None, virtual_network_peerings=None, enable_ddos_protection: bool=False, enable_vm_protection: bool=False, ddos_protection_plan=None, bgp_communities=None, **kwargs) -> None:
        super(VirtualNetwork, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.address_space = address_space
        self.dhcp_options = dhcp_options
        self.subnets = subnets
        self.virtual_network_peerings = virtual_network_peerings
        self.resource_guid = None
        self.provisioning_state = None
        self.enable_ddos_protection = enable_ddos_protection
        self.enable_vm_protection = enable_vm_protection
        self.ddos_protection_plan = ddos_protection_plan
        self.bgp_communities = bgp_communities
        self.etag = None


class VirtualNetworkBgpCommunities(Model):
    """Bgp Communities sent over ExpressRoute with each route corresponding to a
    prefix in this VNET.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param virtual_network_community: Required. The BGP community associated
     with the virtual network
    :type virtual_network_community: str
    :ivar regional_community: The BGP community associated with the region of
     the virtual network
    :vartype regional_community: str
    """

    _validation = {
        'virtual_network_community': {'required': True},
        'regional_community': {'readonly': True},
    }

    _attribute_map = {
        'virtual_network_community': {'key': 'virtualNetworkCommunity', 'type': 'str'},
        'regional_community': {'key': 'regionalCommunity', 'type': 'str'},
    }

    def __init__(self, *, virtual_network_community: str, **kwargs) -> None:
        super(VirtualNetworkBgpCommunities, self).__init__(**kwargs)
        self.virtual_network_community = virtual_network_community
        self.regional_community = None


class VirtualNetworkConnectionGatewayReference(Model):
    """A reference to VirtualNetworkGateway or LocalNetworkGateway resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of VirtualNetworkGateway or
     LocalNetworkGateway resource.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str, **kwargs) -> None:
        super(VirtualNetworkConnectionGatewayReference, self).__init__(**kwargs)
        self.id = id


class VirtualNetworkGateway(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param ip_configurations: IP configurations for virtual network gateway.
    :type ip_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayIPConfiguration]
    :param gateway_type: The type of this virtual network gateway. Possible
     values include: 'Vpn', 'ExpressRoute'
    :type gateway_type: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayType
    :param vpn_type: The type of this virtual network gateway. Possible values
     include: 'PolicyBased', 'RouteBased'
    :type vpn_type: str or ~azure.mgmt.network.v2019_09_01.models.VpnType
    :param vpn_gateway_generation: The generation for this
     VirtualNetworkGateway. Must be None if gatewayType is not VPN. Possible
     values include: 'None', 'Generation1', 'Generation2'
    :type vpn_gateway_generation: str or
     ~azure.mgmt.network.v2019_09_01.models.VpnGatewayGeneration
    :param enable_bgp: Whether BGP is enabled for this virtual network gateway
     or not.
    :type enable_bgp: bool
    :param active_active: ActiveActive flag.
    :type active_active: bool
    :param gateway_default_site: The reference of the LocalNetworkGateway
     resource which represents local network site having default routes. Assign
     Null value in case of removing existing default site setting.
    :type gateway_default_site:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param sku: The reference of the VirtualNetworkGatewaySku resource which
     represents the SKU selected for Virtual network gateway.
    :type sku: ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewaySku
    :param vpn_client_configuration: The reference of the
     VpnClientConfiguration resource which represents the P2S VpnClient
     configurations.
    :type vpn_client_configuration:
     ~azure.mgmt.network.v2019_09_01.models.VpnClientConfiguration
    :param bgp_settings: Virtual network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2019_09_01.models.BgpSettings
    :param custom_routes: The reference of the address space resource which
     represents the custom routes address space specified by the customer for
     virtual network gateway and VpnClient.
    :type custom_routes: ~azure.mgmt.network.v2019_09_01.models.AddressSpace
    :ivar resource_guid: The resource GUID property of the virtual network
     gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network
     gateway resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param enable_dns_forwarding: Whether dns forwarding is enabled or not.
    :type enable_dns_forwarding: bool
    :ivar inbound_dns_forwarding_endpoint: The IP address allocated by the
     gateway to which dns requests can be sent.
    :vartype inbound_dns_forwarding_endpoint: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'inbound_dns_forwarding_endpoint': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualNetworkGatewayIPConfiguration]'},
        'gateway_type': {'key': 'properties.gatewayType', 'type': 'str'},
        'vpn_type': {'key': 'properties.vpnType', 'type': 'str'},
        'vpn_gateway_generation': {'key': 'properties.vpnGatewayGeneration', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'active_active': {'key': 'properties.activeActive', 'type': 'bool'},
        'gateway_default_site': {'key': 'properties.gatewayDefaultSite', 'type': 'SubResource'},
        'sku': {'key': 'properties.sku', 'type': 'VirtualNetworkGatewaySku'},
        'vpn_client_configuration': {'key': 'properties.vpnClientConfiguration', 'type': 'VpnClientConfiguration'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'custom_routes': {'key': 'properties.customRoutes', 'type': 'AddressSpace'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'enable_dns_forwarding': {'key': 'properties.enableDnsForwarding', 'type': 'bool'},
        'inbound_dns_forwarding_endpoint': {'key': 'properties.inboundDnsForwardingEndpoint', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, ip_configurations=None, gateway_type=None, vpn_type=None, vpn_gateway_generation=None, enable_bgp: bool=None, active_active: bool=None, gateway_default_site=None, sku=None, vpn_client_configuration=None, bgp_settings=None, custom_routes=None, enable_dns_forwarding: bool=None, **kwargs) -> None:
        super(VirtualNetworkGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.ip_configurations = ip_configurations
        self.gateway_type = gateway_type
        self.vpn_type = vpn_type
        self.vpn_gateway_generation = vpn_gateway_generation
        self.enable_bgp = enable_bgp
        self.active_active = active_active
        self.gateway_default_site = gateway_default_site
        self.sku = sku
        self.vpn_client_configuration = vpn_client_configuration
        self.bgp_settings = bgp_settings
        self.custom_routes = custom_routes
        self.resource_guid = None
        self.provisioning_state = None
        self.enable_dns_forwarding = enable_dns_forwarding
        self.inbound_dns_forwarding_endpoint = None
        self.etag = None


class VirtualNetworkGatewayConnection(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: Required. The reference to virtual
     network gateway resource.
    :type virtual_network_gateway1:
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGateway
    :param virtual_network_gateway2: The reference to virtual network gateway
     resource.
    :type virtual_network_gateway2:
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGateway
    :param local_network_gateway2: The reference to local network gateway
     resource.
    :type local_network_gateway2:
     ~azure.mgmt.network.v2019_09_01.models.LocalNetworkGateway
    :param connection_type: Required. Gateway connection type. Possible values
     include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
    :type connection_type: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionType
    :param connection_protocol: Connection protocol used for this connection.
     Possible values include: 'IKEv2', 'IKEv1'
    :type connection_protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionProtocol
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :ivar connection_status: Virtual Network Gateway connection status.
     Possible values include: 'Unknown', 'Connecting', 'Connected',
     'NotConnected'
    :vartype connection_status: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection
     health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2019_09_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this
     connection.
    :vartype egress_bytes_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this
     connection.
    :vartype ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic
     selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this
     connection.
    :type ipsec_policies:
     list[~azure.mgmt.network.v2019_09_01.models.IpsecPolicy]
    :param traffic_selector_policies: The Traffic Selector Policies to be
     considered by this connection.
    :type traffic_selector_policies:
     list[~azure.mgmt.network.v2019_09_01.models.TrafficSelectorPolicy]
    :ivar resource_guid: The resource GUID property of the virtual network
     gateway connection resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network
     gateway connection resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param express_route_gateway_bypass: Bypass ExpressRoute Gateway for data
     forwarding.
    :type express_route_gateway_bypass: bool
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_gateway1': {'required': True},
        'connection_type': {'required': True},
        'connection_status': {'readonly': True},
        'tunnel_connection_status': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkGateway'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkGateway'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'LocalNetworkGateway'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'connection_protocol': {'key': 'properties.connectionProtocol', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'tunnel_connection_status': {'key': 'properties.tunnelConnectionStatus', 'type': '[TunnelConnectionHealth]'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'traffic_selector_policies': {'key': 'properties.trafficSelectorPolicies', 'type': '[TrafficSelectorPolicy]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'express_route_gateway_bypass': {'key': 'properties.expressRouteGatewayBypass', 'type': 'bool'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, virtual_network_gateway1, connection_type, id: str=None, location: str=None, tags=None, authorization_key: str=None, virtual_network_gateway2=None, local_network_gateway2=None, connection_protocol=None, routing_weight: int=None, shared_key: str=None, peer=None, enable_bgp: bool=None, use_policy_based_traffic_selectors: bool=None, ipsec_policies=None, traffic_selector_policies=None, express_route_gateway_bypass: bool=None, **kwargs) -> None:
        super(VirtualNetworkGatewayConnection, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.connection_protocol = connection_protocol
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.traffic_selector_policies = traffic_selector_policies
        self.resource_guid = None
        self.provisioning_state = None
        self.express_route_gateway_bypass = express_route_gateway_bypass
        self.etag = None


class VirtualNetworkGatewayConnectionListEntity(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1: Required. The reference to virtual
     network gateway resource.
    :type virtual_network_gateway1:
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkConnectionGatewayReference
    :param virtual_network_gateway2: The reference to virtual network gateway
     resource.
    :type virtual_network_gateway2:
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkConnectionGatewayReference
    :param local_network_gateway2: The reference to local network gateway
     resource.
    :type local_network_gateway2:
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkConnectionGatewayReference
    :param connection_type: Required. Gateway connection type. Possible values
     include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
    :type connection_type: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionType
    :param connection_protocol: Connection protocol used for this connection.
     Possible values include: 'IKEv2', 'IKEv1'
    :type connection_protocol: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionProtocol
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :ivar connection_status: Virtual Network Gateway connection status.
     Possible values include: 'Unknown', 'Connecting', 'Connected',
     'NotConnected'
    :vartype connection_status: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionStatus
    :ivar tunnel_connection_status: Collection of all tunnels' connection
     health status.
    :vartype tunnel_connection_status:
     list[~azure.mgmt.network.v2019_09_01.models.TunnelConnectionHealth]
    :ivar egress_bytes_transferred: The egress bytes transferred in this
     connection.
    :vartype egress_bytes_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this
     connection.
    :vartype ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic
     selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this
     connection.
    :type ipsec_policies:
     list[~azure.mgmt.network.v2019_09_01.models.IpsecPolicy]
    :param traffic_selector_policies: The Traffic Selector Policies to be
     considered by this connection.
    :type traffic_selector_policies:
     list[~azure.mgmt.network.v2019_09_01.models.TrafficSelectorPolicy]
    :ivar resource_guid: The resource GUID property of the virtual network
     gateway connection resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network
     gateway connection resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param express_route_gateway_bypass: Bypass ExpressRoute Gateway for data
     forwarding.
    :type express_route_gateway_bypass: bool
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_gateway1': {'required': True},
        'connection_type': {'required': True},
        'connection_status': {'readonly': True},
        'tunnel_connection_status': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'VirtualNetworkConnectionGatewayReference'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'connection_protocol': {'key': 'properties.connectionProtocol', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'tunnel_connection_status': {'key': 'properties.tunnelConnectionStatus', 'type': '[TunnelConnectionHealth]'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'traffic_selector_policies': {'key': 'properties.trafficSelectorPolicies', 'type': '[TrafficSelectorPolicy]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'express_route_gateway_bypass': {'key': 'properties.expressRouteGatewayBypass', 'type': 'bool'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, virtual_network_gateway1, connection_type, id: str=None, location: str=None, tags=None, authorization_key: str=None, virtual_network_gateway2=None, local_network_gateway2=None, connection_protocol=None, routing_weight: int=None, shared_key: str=None, peer=None, enable_bgp: bool=None, use_policy_based_traffic_selectors: bool=None, ipsec_policies=None, traffic_selector_policies=None, express_route_gateway_bypass: bool=None, **kwargs) -> None:
        super(VirtualNetworkGatewayConnectionListEntity, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.connection_protocol = connection_protocol
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = None
        self.tunnel_connection_status = None
        self.egress_bytes_transferred = None
        self.ingress_bytes_transferred = None
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.traffic_selector_policies = traffic_selector_policies
        self.resource_guid = None
        self.provisioning_state = None
        self.express_route_gateway_bypass = express_route_gateway_bypass
        self.etag = None


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param private_ip_allocation_method: The private IP address allocation
     method. Possible values include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or
     ~azure.mgmt.network.v2019_09_01.models.IPAllocationMethod
    :param subnet: The reference of the subnet resource.
    :type subnet: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param public_ip_address: The reference of the public IP resource.
    :type public_ip_address:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar provisioning_state: The provisioning state of the virtual network
     gateway IP configuration resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, private_ip_allocation_method=None, subnet=None, public_ip_address=None, name: str=None, **kwargs) -> None:
        super(VirtualNetworkGatewayIPConfiguration, self).__init__(id=id, **kwargs)
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = None
        self.name = name
        self.etag = None


class VirtualNetworkGatewaySku(Model):
    """VirtualNetworkGatewaySku details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param name: Gateway SKU name. Possible values include: 'Basic',
     'HighPerformance', 'Standard', 'UltraPerformance', 'VpnGw1', 'VpnGw2',
     'VpnGw3', 'VpnGw4', 'VpnGw5', 'VpnGw1AZ', 'VpnGw2AZ', 'VpnGw3AZ',
     'VpnGw4AZ', 'VpnGw5AZ', 'ErGw1AZ', 'ErGw2AZ', 'ErGw3AZ'
    :type name: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewaySkuName
    :param tier: Gateway SKU tier. Possible values include: 'Basic',
     'HighPerformance', 'Standard', 'UltraPerformance', 'VpnGw1', 'VpnGw2',
     'VpnGw3', 'VpnGw4', 'VpnGw5', 'VpnGw1AZ', 'VpnGw2AZ', 'VpnGw3AZ',
     'VpnGw4AZ', 'VpnGw5AZ', 'ErGw1AZ', 'ErGw2AZ', 'ErGw3AZ'
    :type tier: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewaySkuTier
    :ivar capacity: The capacity.
    :vartype capacity: int
    """

    _validation = {
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, *, name=None, tier=None, **kwargs) -> None:
        super(VirtualNetworkGatewaySku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = None


class VirtualNetworkPeering(SubResource):
    """Peerings in a virtual network resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param allow_virtual_network_access: Whether the VMs in the local virtual
     network space would be able to access the VMs in remote virtual network
     space.
    :type allow_virtual_network_access: bool
    :param allow_forwarded_traffic: Whether the forwarded traffic from the VMs
     in the local virtual network will be allowed/disallowed in remote virtual
     network.
    :type allow_forwarded_traffic: bool
    :param allow_gateway_transit: If gateway links can be used in remote
     virtual networking to link to this virtual network.
    :type allow_gateway_transit: bool
    :param use_remote_gateways: If remote gateways can be used on this virtual
     network. If the flag is set to true, and allowGatewayTransit on remote
     peering is also true, virtual network will use gateways of remote virtual
     network for transit. Only one peering can have this flag set to true. This
     flag cannot be set if virtual network already has a gateway.
    :type use_remote_gateways: bool
    :param remote_virtual_network: The reference of the remote virtual
     network. The remote virtual network can be in the same or different region
     (preview). See here to register for the preview and learn more
     (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
    :type remote_virtual_network:
     ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param remote_address_space: The reference of the remote virtual network
     address space.
    :type remote_address_space:
     ~azure.mgmt.network.v2019_09_01.models.AddressSpace
    :param peering_state: The status of the virtual network peering. Possible
     values include: 'Initiated', 'Connected', 'Disconnected'
    :type peering_state: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkPeeringState
    :ivar provisioning_state: The provisioning state of the virtual network
     peering resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'allow_virtual_network_access': {'key': 'properties.allowVirtualNetworkAccess', 'type': 'bool'},
        'allow_forwarded_traffic': {'key': 'properties.allowForwardedTraffic', 'type': 'bool'},
        'allow_gateway_transit': {'key': 'properties.allowGatewayTransit', 'type': 'bool'},
        'use_remote_gateways': {'key': 'properties.useRemoteGateways', 'type': 'bool'},
        'remote_virtual_network': {'key': 'properties.remoteVirtualNetwork', 'type': 'SubResource'},
        'remote_address_space': {'key': 'properties.remoteAddressSpace', 'type': 'AddressSpace'},
        'peering_state': {'key': 'properties.peeringState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, allow_virtual_network_access: bool=None, allow_forwarded_traffic: bool=None, allow_gateway_transit: bool=None, use_remote_gateways: bool=None, remote_virtual_network=None, remote_address_space=None, peering_state=None, name: str=None, **kwargs) -> None:
        super(VirtualNetworkPeering, self).__init__(id=id, **kwargs)
        self.allow_virtual_network_access = allow_virtual_network_access
        self.allow_forwarded_traffic = allow_forwarded_traffic
        self.allow_gateway_transit = allow_gateway_transit
        self.use_remote_gateways = use_remote_gateways
        self.remote_virtual_network = remote_virtual_network
        self.remote_address_space = remote_address_space
        self.peering_state = peering_state
        self.provisioning_state = None
        self.name = name
        self.etag = None


class VirtualNetworkTap(Resource):
    """Virtual Network Tap resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar network_interface_tap_configurations: Specifies the list of resource
     IDs for the network interface IP configuration that needs to be tapped.
    :vartype network_interface_tap_configurations:
     list[~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceTapConfiguration]
    :ivar resource_guid: The resource GUID property of the virtual network tap
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the virtual network
     tap resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param destination_network_interface_ip_configuration: The reference to
     the private IP Address of the collector nic that will receive the tap.
    :type destination_network_interface_ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.NetworkInterfaceIPConfiguration
    :param destination_load_balancer_front_end_ip_configuration: The reference
     to the private IP address on the internal Load Balancer that will receive
     the tap.
    :type destination_load_balancer_front_end_ip_configuration:
     ~azure.mgmt.network.v2019_09_01.models.FrontendIPConfiguration
    :param destination_port: The VXLAN destination port that will receive the
     tapped traffic.
    :type destination_port: int
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'network_interface_tap_configurations': {'readonly': True},
        'resource_guid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'network_interface_tap_configurations': {'key': 'properties.networkInterfaceTapConfigurations', 'type': '[NetworkInterfaceTapConfiguration]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'destination_network_interface_ip_configuration': {'key': 'properties.destinationNetworkInterfaceIPConfiguration', 'type': 'NetworkInterfaceIPConfiguration'},
        'destination_load_balancer_front_end_ip_configuration': {'key': 'properties.destinationLoadBalancerFrontEndIPConfiguration', 'type': 'FrontendIPConfiguration'},
        'destination_port': {'key': 'properties.destinationPort', 'type': 'int'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, destination_network_interface_ip_configuration=None, destination_load_balancer_front_end_ip_configuration=None, destination_port: int=None, **kwargs) -> None:
        super(VirtualNetworkTap, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.network_interface_tap_configurations = None
        self.resource_guid = None
        self.provisioning_state = None
        self.destination_network_interface_ip_configuration = destination_network_interface_ip_configuration
        self.destination_load_balancer_front_end_ip_configuration = destination_load_balancer_front_end_ip_configuration
        self.destination_port = destination_port
        self.etag = None


class VirtualNetworkUsage(Model):
    """Usage details for subnet.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar current_value: Indicates number of IPs used from the Subnet.
    :vartype current_value: float
    :ivar id: Subnet identifier.
    :vartype id: str
    :ivar limit: Indicates the size of the subnet.
    :vartype limit: float
    :ivar name: The name containing common and localized value for usage.
    :vartype name:
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkUsageName
    :ivar unit: Usage units. Returns 'Count'.
    :vartype unit: str
    """

    _validation = {
        'current_value': {'readonly': True},
        'id': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'id': {'key': 'id', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'float'},
        'name': {'key': 'name', 'type': 'VirtualNetworkUsageName'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(VirtualNetworkUsage, self).__init__(**kwargs)
        self.current_value = None
        self.id = None
        self.limit = None
        self.name = None
        self.unit = None


class VirtualNetworkUsageName(Model):
    """Usage strings container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar localized_value: Localized subnet size and usage string.
    :vartype localized_value: str
    :ivar value: Subnet size and usage string.
    :vartype value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(VirtualNetworkUsageName, self).__init__(**kwargs)
        self.localized_value = None
        self.value = None


class VirtualRouter(Resource):
    """VirtualRouter Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param virtual_router_asn: VirtualRouter ASN.
    :type virtual_router_asn: long
    :param virtual_router_ips: VirtualRouter IPs
    :type virtual_router_ips: list[str]
    :param hosted_subnet: The Subnet on which VirtualRouter is hosted.
    :type hosted_subnet: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param hosted_gateway: The Gateway on which VirtualRouter is hosted.
    :type hosted_gateway: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :ivar peerings: List of references to VirtualRouterPeerings
    :vartype peerings:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar provisioning_state: The provisioning state of the resource. Possible
     values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_router_asn': {'maximum': 4294967295, 'minimum': 0},
        'peerings': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'virtual_router_asn': {'key': 'properties.virtualRouterAsn', 'type': 'long'},
        'virtual_router_ips': {'key': 'properties.virtualRouterIps', 'type': '[str]'},
        'hosted_subnet': {'key': 'properties.hostedSubnet', 'type': 'SubResource'},
        'hosted_gateway': {'key': 'properties.hostedGateway', 'type': 'SubResource'},
        'peerings': {'key': 'properties.peerings', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, virtual_router_asn: int=None, virtual_router_ips=None, hosted_subnet=None, hosted_gateway=None, **kwargs) -> None:
        super(VirtualRouter, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.virtual_router_asn = virtual_router_asn
        self.virtual_router_ips = virtual_router_ips
        self.hosted_subnet = hosted_subnet
        self.hosted_gateway = hosted_gateway
        self.peerings = None
        self.provisioning_state = None
        self.etag = None


class VirtualRouterPeering(SubResource):
    """Virtual Router Peering resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param peer_asn: Peer ASN.
    :type peer_asn: long
    :param peer_ip: Peer IP.
    :type peer_ip: str
    :ivar provisioning_state: The provisioning state of the resource. Possible
     values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: Gets name of the peering unique to VirtualRouter. This name
     can be used to access the resource.
    :type name: str
    :ivar etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :vartype etag: str
    :ivar type: Peering type.
    :vartype type: str
    """

    _validation = {
        'peer_asn': {'maximum': 4294967295, 'minimum': 0},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'peer_asn': {'key': 'properties.peerAsn', 'type': 'long'},
        'peer_ip': {'key': 'properties.peerIp', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, peer_asn: int=None, peer_ip: str=None, name: str=None, **kwargs) -> None:
        super(VirtualRouterPeering, self).__init__(id=id, **kwargs)
        self.peer_asn = peer_asn
        self.peer_ip = peer_ip
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class VirtualWAN(Resource):
    """VirtualWAN Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param disable_vpn_encryption: Vpn encryption to be disabled or not.
    :type disable_vpn_encryption: bool
    :ivar virtual_hubs: List of VirtualHubs in the VirtualWAN.
    :vartype virtual_hubs:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar vpn_sites: List of VpnSites in the VirtualWAN.
    :vartype vpn_sites:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :param allow_branch_to_branch_traffic: True if branch to branch traffic is
     allowed.
    :type allow_branch_to_branch_traffic: bool
    :param allow_vnet_to_vnet_traffic: True if Vnet to Vnet traffic is
     allowed.
    :type allow_vnet_to_vnet_traffic: bool
    :param office365_local_breakout_category: The office local breakout
     category. Possible values include: 'Optimize', 'OptimizeAndAllow', 'All',
     'None'
    :type office365_local_breakout_category: str or
     ~azure.mgmt.network.v2019_09_01.models.OfficeTrafficCategory
    :ivar provisioning_state: The provisioning state of the virtual WAN
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param virtual_wan_type: The type of the VirtualWAN.
    :type virtual_wan_type: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_hubs': {'readonly': True},
        'vpn_sites': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'disable_vpn_encryption': {'key': 'properties.disableVpnEncryption', 'type': 'bool'},
        'virtual_hubs': {'key': 'properties.virtualHubs', 'type': '[SubResource]'},
        'vpn_sites': {'key': 'properties.vpnSites', 'type': '[SubResource]'},
        'allow_branch_to_branch_traffic': {'key': 'properties.allowBranchToBranchTraffic', 'type': 'bool'},
        'allow_vnet_to_vnet_traffic': {'key': 'properties.allowVnetToVnetTraffic', 'type': 'bool'},
        'office365_local_breakout_category': {'key': 'properties.office365LocalBreakoutCategory', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'virtual_wan_type': {'key': 'properties.type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, disable_vpn_encryption: bool=None, allow_branch_to_branch_traffic: bool=None, allow_vnet_to_vnet_traffic: bool=None, office365_local_breakout_category=None, virtual_wan_type: str=None, **kwargs) -> None:
        super(VirtualWAN, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.disable_vpn_encryption = disable_vpn_encryption
        self.virtual_hubs = None
        self.vpn_sites = None
        self.allow_branch_to_branch_traffic = allow_branch_to_branch_traffic
        self.allow_vnet_to_vnet_traffic = allow_vnet_to_vnet_traffic
        self.office365_local_breakout_category = office365_local_breakout_category
        self.provisioning_state = None
        self.virtual_wan_type = virtual_wan_type
        self.etag = None


class VirtualWanSecurityProvider(Model):
    """Collection of SecurityProviders.

    :param name: Name of the security provider.
    :type name: str
    :param url: Url of the security provider.
    :type url: str
    :param type: Name of the security provider. Possible values include:
     'External', 'Native'
    :type type: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualWanSecurityProviderType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, url: str=None, type=None, **kwargs) -> None:
        super(VirtualWanSecurityProvider, self).__init__(**kwargs)
        self.name = name
        self.url = url
        self.type = type


class VirtualWanSecurityProviders(Model):
    """Collection of SecurityProviders.

    :param supported_providers: List of VirtualWAN security providers.
    :type supported_providers:
     list[~azure.mgmt.network.v2019_09_01.models.VirtualWanSecurityProvider]
    """

    _attribute_map = {
        'supported_providers': {'key': 'supportedProviders', 'type': '[VirtualWanSecurityProvider]'},
    }

    def __init__(self, *, supported_providers=None, **kwargs) -> None:
        super(VirtualWanSecurityProviders, self).__init__(**kwargs)
        self.supported_providers = supported_providers


class VirtualWanVpnProfileParameters(Model):
    """Virtual Wan Vpn profile parameters Vpn profile generation.

    :param vpn_server_configuration_resource_id: VpnServerConfiguration
     partial resource uri with which VirtualWan is associated to.
    :type vpn_server_configuration_resource_id: str
    :param authentication_method: VPN client authentication method. Possible
     values include: 'EAPTLS', 'EAPMSCHAPv2'
    :type authentication_method: str or
     ~azure.mgmt.network.v2019_09_01.models.AuthenticationMethod
    """

    _attribute_map = {
        'vpn_server_configuration_resource_id': {'key': 'vpnServerConfigurationResourceId', 'type': 'str'},
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
    }

    def __init__(self, *, vpn_server_configuration_resource_id: str=None, authentication_method=None, **kwargs) -> None:
        super(VirtualWanVpnProfileParameters, self).__init__(**kwargs)
        self.vpn_server_configuration_resource_id = vpn_server_configuration_resource_id
        self.authentication_method = authentication_method


class VpnClientConfiguration(Model):
    """VpnClientConfiguration for P2S client.

    :param vpn_client_address_pool: The reference of the address space
     resource which represents Address space for P2S VpnClient.
    :type vpn_client_address_pool:
     ~azure.mgmt.network.v2019_09_01.models.AddressSpace
    :param vpn_client_root_certificates: VpnClientRootCertificate for virtual
     network gateway.
    :type vpn_client_root_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.VpnClientRootCertificate]
    :param vpn_client_revoked_certificates: VpnClientRevokedCertificate for
     Virtual network gateway.
    :type vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.VpnClientRevokedCertificate]
    :param vpn_client_protocols: VpnClientProtocols for Virtual network
     gateway.
    :type vpn_client_protocols: list[str or
     ~azure.mgmt.network.v2019_09_01.models.VpnClientProtocol]
    :param vpn_client_ipsec_policies: VpnClientIpsecPolicies for virtual
     network gateway P2S client.
    :type vpn_client_ipsec_policies:
     list[~azure.mgmt.network.v2019_09_01.models.IpsecPolicy]
    :param radius_server_address: The radius server address property of the
     VirtualNetworkGateway resource for vpn client connection.
    :type radius_server_address: str
    :param radius_server_secret: The radius secret property of the
     VirtualNetworkGateway resource for vpn client connection.
    :type radius_server_secret: str
    :param aad_tenant: The AADTenant property of the VirtualNetworkGateway
     resource for vpn client connection used for AAD authentication.
    :type aad_tenant: str
    :param aad_audience: The AADAudience property of the VirtualNetworkGateway
     resource for vpn client connection used for AAD authentication.
    :type aad_audience: str
    :param aad_issuer: The AADIssuer property of the VirtualNetworkGateway
     resource for vpn client connection used for AAD authentication.
    :type aad_issuer: str
    """

    _attribute_map = {
        'vpn_client_address_pool': {'key': 'vpnClientAddressPool', 'type': 'AddressSpace'},
        'vpn_client_root_certificates': {'key': 'vpnClientRootCertificates', 'type': '[VpnClientRootCertificate]'},
        'vpn_client_revoked_certificates': {'key': 'vpnClientRevokedCertificates', 'type': '[VpnClientRevokedCertificate]'},
        'vpn_client_protocols': {'key': 'vpnClientProtocols', 'type': '[str]'},
        'vpn_client_ipsec_policies': {'key': 'vpnClientIpsecPolicies', 'type': '[IpsecPolicy]'},
        'radius_server_address': {'key': 'radiusServerAddress', 'type': 'str'},
        'radius_server_secret': {'key': 'radiusServerSecret', 'type': 'str'},
        'aad_tenant': {'key': 'aadTenant', 'type': 'str'},
        'aad_audience': {'key': 'aadAudience', 'type': 'str'},
        'aad_issuer': {'key': 'aadIssuer', 'type': 'str'},
    }

    def __init__(self, *, vpn_client_address_pool=None, vpn_client_root_certificates=None, vpn_client_revoked_certificates=None, vpn_client_protocols=None, vpn_client_ipsec_policies=None, radius_server_address: str=None, radius_server_secret: str=None, aad_tenant: str=None, aad_audience: str=None, aad_issuer: str=None, **kwargs) -> None:
        super(VpnClientConfiguration, self).__init__(**kwargs)
        self.vpn_client_address_pool = vpn_client_address_pool
        self.vpn_client_root_certificates = vpn_client_root_certificates
        self.vpn_client_revoked_certificates = vpn_client_revoked_certificates
        self.vpn_client_protocols = vpn_client_protocols
        self.vpn_client_ipsec_policies = vpn_client_ipsec_policies
        self.radius_server_address = radius_server_address
        self.radius_server_secret = radius_server_secret
        self.aad_tenant = aad_tenant
        self.aad_audience = aad_audience
        self.aad_issuer = aad_issuer


class VpnClientConnectionHealth(Model):
    """VpnClientConnectionHealth properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar total_ingress_bytes_transferred: Total of the Ingress Bytes
     Transferred in this P2S Vpn connection.
    :vartype total_ingress_bytes_transferred: long
    :ivar total_egress_bytes_transferred: Total of the Egress Bytes
     Transferred in this connection.
    :vartype total_egress_bytes_transferred: long
    :param vpn_client_connections_count: The total of p2s vpn clients
     connected at this time to this P2SVpnGateway.
    :type vpn_client_connections_count: int
    :param allocated_ip_addresses: List of allocated ip addresses to the
     connected p2s vpn clients.
    :type allocated_ip_addresses: list[str]
    """

    _validation = {
        'total_ingress_bytes_transferred': {'readonly': True},
        'total_egress_bytes_transferred': {'readonly': True},
    }

    _attribute_map = {
        'total_ingress_bytes_transferred': {'key': 'totalIngressBytesTransferred', 'type': 'long'},
        'total_egress_bytes_transferred': {'key': 'totalEgressBytesTransferred', 'type': 'long'},
        'vpn_client_connections_count': {'key': 'vpnClientConnectionsCount', 'type': 'int'},
        'allocated_ip_addresses': {'key': 'allocatedIpAddresses', 'type': '[str]'},
    }

    def __init__(self, *, vpn_client_connections_count: int=None, allocated_ip_addresses=None, **kwargs) -> None:
        super(VpnClientConnectionHealth, self).__init__(**kwargs)
        self.total_ingress_bytes_transferred = None
        self.total_egress_bytes_transferred = None
        self.vpn_client_connections_count = vpn_client_connections_count
        self.allocated_ip_addresses = allocated_ip_addresses


class VpnClientConnectionHealthDetail(Model):
    """VPN client connection health detail.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar vpn_connection_id: The vpn client Id.
    :vartype vpn_connection_id: str
    :ivar vpn_connection_duration: The duration time of a connected vpn
     client.
    :vartype vpn_connection_duration: long
    :ivar vpn_connection_time: The start time of a connected vpn client.
    :vartype vpn_connection_time: str
    :ivar public_ip_address: The public Ip of a connected vpn client.
    :vartype public_ip_address: str
    :ivar private_ip_address: The assigned private Ip of a connected vpn
     client.
    :vartype private_ip_address: str
    :ivar vpn_user_name: The user name of a connected vpn client.
    :vartype vpn_user_name: str
    :ivar max_bandwidth: The max band width.
    :vartype max_bandwidth: long
    :ivar egress_packets_transferred: The egress packets per second.
    :vartype egress_packets_transferred: long
    :ivar egress_bytes_transferred: The egress bytes per second.
    :vartype egress_bytes_transferred: long
    :ivar ingress_packets_transferred: The ingress packets per second.
    :vartype ingress_packets_transferred: long
    :ivar ingress_bytes_transferred: The ingress bytes per second.
    :vartype ingress_bytes_transferred: long
    :ivar max_packets_per_second: The max packets transferred per second.
    :vartype max_packets_per_second: long
    """

    _validation = {
        'vpn_connection_id': {'readonly': True},
        'vpn_connection_duration': {'readonly': True},
        'vpn_connection_time': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'vpn_user_name': {'readonly': True},
        'max_bandwidth': {'readonly': True},
        'egress_packets_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'ingress_packets_transferred': {'readonly': True},
        'ingress_bytes_transferred': {'readonly': True},
        'max_packets_per_second': {'readonly': True},
    }

    _attribute_map = {
        'vpn_connection_id': {'key': 'vpnConnectionId', 'type': 'str'},
        'vpn_connection_duration': {'key': 'vpnConnectionDuration', 'type': 'long'},
        'vpn_connection_time': {'key': 'vpnConnectionTime', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'vpn_user_name': {'key': 'vpnUserName', 'type': 'str'},
        'max_bandwidth': {'key': 'maxBandwidth', 'type': 'long'},
        'egress_packets_transferred': {'key': 'egressPacketsTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'egressBytesTransferred', 'type': 'long'},
        'ingress_packets_transferred': {'key': 'ingressPacketsTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'ingressBytesTransferred', 'type': 'long'},
        'max_packets_per_second': {'key': 'maxPacketsPerSecond', 'type': 'long'},
    }

    def __init__(self, **kwargs) -> None:
        super(VpnClientConnectionHealthDetail, self).__init__(**kwargs)
        self.vpn_connection_id = None
        self.vpn_connection_duration = None
        self.vpn_connection_time = None
        self.public_ip_address = None
        self.private_ip_address = None
        self.vpn_user_name = None
        self.max_bandwidth = None
        self.egress_packets_transferred = None
        self.egress_bytes_transferred = None
        self.ingress_packets_transferred = None
        self.ingress_bytes_transferred = None
        self.max_packets_per_second = None


class VpnClientConnectionHealthDetailListResult(Model):
    """List of virtual network gateway vpn client connection health.

    :param value: List of vpn client connection health.
    :type value:
     list[~azure.mgmt.network.v2019_09_01.models.VpnClientConnectionHealthDetail]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VpnClientConnectionHealthDetail]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(VpnClientConnectionHealthDetailListResult, self).__init__(**kwargs)
        self.value = value


class VpnClientIPsecParameters(Model):
    """An IPSec parameters for a virtual network gateway P2S connection.

    All required parameters must be populated in order to send to Azure.

    :param sa_life_time_seconds: Required. The IPSec Security Association
     (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client.
    :type sa_life_time_seconds: int
    :param sa_data_size_kilobytes: Required. The IPSec Security Association
     (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client..
    :type sa_data_size_kilobytes: int
    :param ipsec_encryption: Required. The IPSec encryption algorithm (IKE
     phase 1). Possible values include: 'None', 'DES', 'DES3', 'AES128',
     'AES192', 'AES256', 'GCMAES128', 'GCMAES192', 'GCMAES256'
    :type ipsec_encryption: str or
     ~azure.mgmt.network.v2019_09_01.models.IpsecEncryption
    :param ipsec_integrity: Required. The IPSec integrity algorithm (IKE phase
     1). Possible values include: 'MD5', 'SHA1', 'SHA256', 'GCMAES128',
     'GCMAES192', 'GCMAES256'
    :type ipsec_integrity: str or
     ~azure.mgmt.network.v2019_09_01.models.IpsecIntegrity
    :param ike_encryption: Required. The IKE encryption algorithm (IKE phase
     2). Possible values include: 'DES', 'DES3', 'AES128', 'AES192', 'AES256',
     'GCMAES256', 'GCMAES128'
    :type ike_encryption: str or
     ~azure.mgmt.network.v2019_09_01.models.IkeEncryption
    :param ike_integrity: Required. The IKE integrity algorithm (IKE phase 2).
     Possible values include: 'MD5', 'SHA1', 'SHA256', 'SHA384', 'GCMAES256',
     'GCMAES128'
    :type ike_integrity: str or
     ~azure.mgmt.network.v2019_09_01.models.IkeIntegrity
    :param dh_group: Required. The DH Group used in IKE Phase 1 for initial
     SA. Possible values include: 'None', 'DHGroup1', 'DHGroup2', 'DHGroup14',
     'DHGroup2048', 'ECP256', 'ECP384', 'DHGroup24'
    :type dh_group: str or ~azure.mgmt.network.v2019_09_01.models.DhGroup
    :param pfs_group: Required. The Pfs Group used in IKE Phase 2 for new
     child SA. Possible values include: 'None', 'PFS1', 'PFS2', 'PFS2048',
     'ECP256', 'ECP384', 'PFS24', 'PFS14', 'PFSMM'
    :type pfs_group: str or ~azure.mgmt.network.v2019_09_01.models.PfsGroup
    """

    _validation = {
        'sa_life_time_seconds': {'required': True},
        'sa_data_size_kilobytes': {'required': True},
        'ipsec_encryption': {'required': True},
        'ipsec_integrity': {'required': True},
        'ike_encryption': {'required': True},
        'ike_integrity': {'required': True},
        'dh_group': {'required': True},
        'pfs_group': {'required': True},
    }

    _attribute_map = {
        'sa_life_time_seconds': {'key': 'saLifeTimeSeconds', 'type': 'int'},
        'sa_data_size_kilobytes': {'key': 'saDataSizeKilobytes', 'type': 'int'},
        'ipsec_encryption': {'key': 'ipsecEncryption', 'type': 'str'},
        'ipsec_integrity': {'key': 'ipsecIntegrity', 'type': 'str'},
        'ike_encryption': {'key': 'ikeEncryption', 'type': 'str'},
        'ike_integrity': {'key': 'ikeIntegrity', 'type': 'str'},
        'dh_group': {'key': 'dhGroup', 'type': 'str'},
        'pfs_group': {'key': 'pfsGroup', 'type': 'str'},
    }

    def __init__(self, *, sa_life_time_seconds: int, sa_data_size_kilobytes: int, ipsec_encryption, ipsec_integrity, ike_encryption, ike_integrity, dh_group, pfs_group, **kwargs) -> None:
        super(VpnClientIPsecParameters, self).__init__(**kwargs)
        self.sa_life_time_seconds = sa_life_time_seconds
        self.sa_data_size_kilobytes = sa_data_size_kilobytes
        self.ipsec_encryption = ipsec_encryption
        self.ipsec_integrity = ipsec_integrity
        self.ike_encryption = ike_encryption
        self.ike_integrity = ike_integrity
        self.dh_group = dh_group
        self.pfs_group = pfs_group


class VpnClientParameters(Model):
    """Vpn Client Parameters for package generation.

    :param processor_architecture: VPN client Processor Architecture. Possible
     values include: 'Amd64', 'X86'
    :type processor_architecture: str or
     ~azure.mgmt.network.v2019_09_01.models.ProcessorArchitecture
    :param authentication_method: VPN client authentication method. Possible
     values include: 'EAPTLS', 'EAPMSCHAPv2'
    :type authentication_method: str or
     ~azure.mgmt.network.v2019_09_01.models.AuthenticationMethod
    :param radius_server_auth_certificate: The public certificate data for the
     radius server authentication certificate as a Base-64 encoded string.
     Required only if external radius authentication has been configured with
     EAPTLS authentication.
    :type radius_server_auth_certificate: str
    :param client_root_certificates: A list of client root certificates public
     certificate data encoded as Base-64 strings. Optional parameter for
     external radius based authentication with EAPTLS.
    :type client_root_certificates: list[str]
    """

    _attribute_map = {
        'processor_architecture': {'key': 'processorArchitecture', 'type': 'str'},
        'authentication_method': {'key': 'authenticationMethod', 'type': 'str'},
        'radius_server_auth_certificate': {'key': 'radiusServerAuthCertificate', 'type': 'str'},
        'client_root_certificates': {'key': 'clientRootCertificates', 'type': '[str]'},
    }

    def __init__(self, *, processor_architecture=None, authentication_method=None, radius_server_auth_certificate: str=None, client_root_certificates=None, **kwargs) -> None:
        super(VpnClientParameters, self).__init__(**kwargs)
        self.processor_architecture = processor_architecture
        self.authentication_method = authentication_method
        self.radius_server_auth_certificate = radius_server_auth_certificate
        self.client_root_certificates = client_root_certificates


class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param thumbprint: The revoked VPN client certificate thumbprint.
    :type thumbprint: str
    :ivar provisioning_state: The provisioning state of the VPN client revoked
     certificate resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, thumbprint: str=None, name: str=None, **kwargs) -> None:
        super(VpnClientRevokedCertificate, self).__init__(id=id, **kwargs)
        self.thumbprint = thumbprint
        self.provisioning_state = None
        self.name = name
        self.etag = None


class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :param public_cert_data: Required. The certificate public data.
    :type public_cert_data: str
    :ivar provisioning_state: The provisioning state of the VPN client root
     certificate resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'public_cert_data': {'required': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'public_cert_data': {'key': 'properties.publicCertData', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, public_cert_data: str, id: str=None, name: str=None, **kwargs) -> None:
        super(VpnClientRootCertificate, self).__init__(id=id, **kwargs)
        self.public_cert_data = public_cert_data
        self.provisioning_state = None
        self.name = name
        self.etag = None


class VpnConnection(SubResource):
    """VpnConnection Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param remote_vpn_site: Id of the connected vpn site.
    :type remote_vpn_site: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param routing_weight: Routing weight for vpn connection.
    :type routing_weight: int
    :param connection_status: The connection status. Possible values include:
     'Unknown', 'Connecting', 'Connected', 'NotConnected'
    :type connection_status: str or
     ~azure.mgmt.network.v2019_09_01.models.VpnConnectionStatus
    :param vpn_connection_protocol_type: Connection protocol used for this
     connection. Possible values include: 'IKEv2', 'IKEv1'
    :type vpn_connection_protocol_type: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionProtocol
    :ivar ingress_bytes_transferred: Ingress bytes transferred.
    :vartype ingress_bytes_transferred: long
    :ivar egress_bytes_transferred: Egress bytes transferred.
    :vartype egress_bytes_transferred: long
    :param connection_bandwidth: Expected bandwidth in MBPS.
    :type connection_bandwidth: int
    :param shared_key: SharedKey for the vpn connection.
    :type shared_key: str
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic
     selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this
     connection.
    :type ipsec_policies:
     list[~azure.mgmt.network.v2019_09_01.models.IpsecPolicy]
    :param enable_rate_limiting: EnableBgp flag.
    :type enable_rate_limiting: bool
    :param enable_internet_security: Enable internet security.
    :type enable_internet_security: bool
    :param use_local_azure_ip_address: Use local azure ip to initiate
     connection.
    :type use_local_azure_ip_address: bool
    :ivar provisioning_state: The provisioning state of the VPN connection
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param vpn_link_connections: List of all vpn site link connections to the
     gateway.
    :type vpn_link_connections:
     list[~azure.mgmt.network.v2019_09_01.models.VpnSiteLinkConnection]
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'ingress_bytes_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'remote_vpn_site': {'key': 'properties.remoteVpnSite', 'type': 'SubResource'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'vpn_connection_protocol_type': {'key': 'properties.vpnConnectionProtocolType', 'type': 'str'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'connection_bandwidth': {'key': 'properties.connectionBandwidth', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'enable_rate_limiting': {'key': 'properties.enableRateLimiting', 'type': 'bool'},
        'enable_internet_security': {'key': 'properties.enableInternetSecurity', 'type': 'bool'},
        'use_local_azure_ip_address': {'key': 'properties.useLocalAzureIpAddress', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'vpn_link_connections': {'key': 'properties.vpnLinkConnections', 'type': '[VpnSiteLinkConnection]'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, remote_vpn_site=None, routing_weight: int=None, connection_status=None, vpn_connection_protocol_type=None, connection_bandwidth: int=None, shared_key: str=None, enable_bgp: bool=None, use_policy_based_traffic_selectors: bool=None, ipsec_policies=None, enable_rate_limiting: bool=None, enable_internet_security: bool=None, use_local_azure_ip_address: bool=None, vpn_link_connections=None, name: str=None, **kwargs) -> None:
        super(VpnConnection, self).__init__(id=id, **kwargs)
        self.remote_vpn_site = remote_vpn_site
        self.routing_weight = routing_weight
        self.connection_status = connection_status
        self.vpn_connection_protocol_type = vpn_connection_protocol_type
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.connection_bandwidth = connection_bandwidth
        self.shared_key = shared_key
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.enable_rate_limiting = enable_rate_limiting
        self.enable_internet_security = enable_internet_security
        self.use_local_azure_ip_address = use_local_azure_ip_address
        self.provisioning_state = None
        self.vpn_link_connections = vpn_link_connections
        self.name = name
        self.etag = None


class VpnDeviceScriptParameters(Model):
    """Vpn device configuration script generation parameters.

    :param vendor: The vendor for the vpn device.
    :type vendor: str
    :param device_family: The device family for the vpn device.
    :type device_family: str
    :param firmware_version: The firmware version for the vpn device.
    :type firmware_version: str
    """

    _attribute_map = {
        'vendor': {'key': 'vendor', 'type': 'str'},
        'device_family': {'key': 'deviceFamily', 'type': 'str'},
        'firmware_version': {'key': 'firmwareVersion', 'type': 'str'},
    }

    def __init__(self, *, vendor: str=None, device_family: str=None, firmware_version: str=None, **kwargs) -> None:
        super(VpnDeviceScriptParameters, self).__init__(**kwargs)
        self.vendor = vendor
        self.device_family = device_family
        self.firmware_version = firmware_version


class VpnGateway(Resource):
    """VpnGateway Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param virtual_hub: The VirtualHub to which the gateway belongs.
    :type virtual_hub: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param connections: List of all vpn connections to the gateway.
    :type connections:
     list[~azure.mgmt.network.v2019_09_01.models.VpnConnection]
    :param bgp_settings: Local network gateway's BGP speaker settings.
    :type bgp_settings: ~azure.mgmt.network.v2019_09_01.models.BgpSettings
    :ivar provisioning_state: The provisioning state of the VPN gateway
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param vpn_gateway_scale_unit: The scale unit for this vpn gateway.
    :type vpn_gateway_scale_unit: int
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'virtual_hub': {'key': 'properties.virtualHub', 'type': 'SubResource'},
        'connections': {'key': 'properties.connections', 'type': '[VpnConnection]'},
        'bgp_settings': {'key': 'properties.bgpSettings', 'type': 'BgpSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'vpn_gateway_scale_unit': {'key': 'properties.vpnGatewayScaleUnit', 'type': 'int'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, virtual_hub=None, connections=None, bgp_settings=None, vpn_gateway_scale_unit: int=None, **kwargs) -> None:
        super(VpnGateway, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.virtual_hub = virtual_hub
        self.connections = connections
        self.bgp_settings = bgp_settings
        self.provisioning_state = None
        self.vpn_gateway_scale_unit = vpn_gateway_scale_unit
        self.etag = None


class VpnLinkBgpSettings(Model):
    """BGP settings details for a link.

    :param asn: The BGP speaker's ASN.
    :type asn: long
    :param bgp_peering_address: The BGP peering address and BGP identifier of
     this BGP speaker.
    :type bgp_peering_address: str
    """

    _attribute_map = {
        'asn': {'key': 'asn', 'type': 'long'},
        'bgp_peering_address': {'key': 'bgpPeeringAddress', 'type': 'str'},
    }

    def __init__(self, *, asn: int=None, bgp_peering_address: str=None, **kwargs) -> None:
        super(VpnLinkBgpSettings, self).__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address


class VpnLinkProviderProperties(Model):
    """List of properties of a link provider.

    :param link_provider_name: Name of the link provider.
    :type link_provider_name: str
    :param link_speed_in_mbps: Link speed.
    :type link_speed_in_mbps: int
    """

    _attribute_map = {
        'link_provider_name': {'key': 'linkProviderName', 'type': 'str'},
        'link_speed_in_mbps': {'key': 'linkSpeedInMbps', 'type': 'int'},
    }

    def __init__(self, *, link_provider_name: str=None, link_speed_in_mbps: int=None, **kwargs) -> None:
        super(VpnLinkProviderProperties, self).__init__(**kwargs)
        self.link_provider_name = link_provider_name
        self.link_speed_in_mbps = link_speed_in_mbps


class VpnPacketCaptureStartParameters(Model):
    """Start packet capture parameters on virtual network gateway.

    :param filter_data: Start Packet capture parameters.
    :type filter_data: str
    """

    _attribute_map = {
        'filter_data': {'key': 'filterData', 'type': 'str'},
    }

    def __init__(self, *, filter_data: str=None, **kwargs) -> None:
        super(VpnPacketCaptureStartParameters, self).__init__(**kwargs)
        self.filter_data = filter_data


class VpnPacketCaptureStopParameters(Model):
    """Stop packet capture parameters.

    :param sas_url: SAS url for packet capture on virtual network gateway.
    :type sas_url: str
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(self, *, sas_url: str=None, **kwargs) -> None:
        super(VpnPacketCaptureStopParameters, self).__init__(**kwargs)
        self.sas_url = sas_url


class VpnProfileResponse(Model):
    """Vpn Profile Response for package generation.

    :param profile_url: URL to the VPN profile.
    :type profile_url: str
    """

    _attribute_map = {
        'profile_url': {'key': 'profileUrl', 'type': 'str'},
    }

    def __init__(self, *, profile_url: str=None, **kwargs) -> None:
        super(VpnProfileResponse, self).__init__(**kwargs)
        self.profile_url = profile_url


class VpnServerConfigRadiusClientRootCertificate(Model):
    """Properties of the Radius client root certificate of VpnServerConfiguration.

    :param name: The certificate name.
    :type name: str
    :param thumbprint: The Radius client root certificate thumbprint.
    :type thumbprint: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, thumbprint: str=None, **kwargs) -> None:
        super(VpnServerConfigRadiusClientRootCertificate, self).__init__(**kwargs)
        self.name = name
        self.thumbprint = thumbprint


class VpnServerConfigRadiusServerRootCertificate(Model):
    """Properties of Radius Server root certificate of VpnServerConfiguration.

    :param name: The certificate name.
    :type name: str
    :param public_cert_data: The certificate public data.
    :type public_cert_data: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'public_cert_data': {'key': 'publicCertData', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, public_cert_data: str=None, **kwargs) -> None:
        super(VpnServerConfigRadiusServerRootCertificate, self).__init__(**kwargs)
        self.name = name
        self.public_cert_data = public_cert_data


class VpnServerConfiguration(Resource):
    """VpnServerConfiguration Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param vpn_server_configuration_name: The name of the
     VpnServerConfiguration that is unique within a resource group.
    :type vpn_server_configuration_name: str
    :param vpn_protocols: VPN protocols for the VpnServerConfiguration.
    :type vpn_protocols: list[str or
     ~azure.mgmt.network.v2019_09_01.models.VpnGatewayTunnelingProtocol]
    :param vpn_authentication_types: VPN authentication types for the
     VpnServerConfiguration.
    :type vpn_authentication_types: list[str or
     ~azure.mgmt.network.v2019_09_01.models.VpnAuthenticationType]
    :param vpn_client_root_certificates: VPN client root certificate of
     VpnServerConfiguration.
    :type vpn_client_root_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.VpnServerConfigVpnClientRootCertificate]
    :param vpn_client_revoked_certificates: VPN client revoked certificate of
     VpnServerConfiguration.
    :type vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.VpnServerConfigVpnClientRevokedCertificate]
    :param radius_server_root_certificates: Radius Server root certificate of
     VpnServerConfiguration.
    :type radius_server_root_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.VpnServerConfigRadiusServerRootCertificate]
    :param radius_client_root_certificates: Radius client root certificate of
     VpnServerConfiguration.
    :type radius_client_root_certificates:
     list[~azure.mgmt.network.v2019_09_01.models.VpnServerConfigRadiusClientRootCertificate]
    :param vpn_client_ipsec_policies: VpnClientIpsecPolicies for
     VpnServerConfiguration.
    :type vpn_client_ipsec_policies:
     list[~azure.mgmt.network.v2019_09_01.models.IpsecPolicy]
    :param radius_server_address: The radius server address property of the
     VpnServerConfiguration resource for point to site client connection.
    :type radius_server_address: str
    :param radius_server_secret: The radius secret property of the
     VpnServerConfiguration resource for point to site client connection.
    :type radius_server_secret: str
    :param aad_authentication_parameters: The set of aad vpn authentication
     parameters.
    :type aad_authentication_parameters:
     ~azure.mgmt.network.v2019_09_01.models.AadAuthenticationParameters
    :ivar provisioning_state: The provisioning state of the
     VpnServerConfiguration resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :ivar p2_svpn_gateways: List of references to P2SVpnGateways.
    :vartype p2_svpn_gateways:
     list[~azure.mgmt.network.v2019_09_01.models.P2SVpnGateway]
    :ivar vpn_server_configuration_properties_etag: A unique read-only string
     that changes whenever the resource is updated.
    :vartype vpn_server_configuration_properties_etag: str
    :ivar etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'p2_svpn_gateways': {'readonly': True},
        'vpn_server_configuration_properties_etag': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'vpn_server_configuration_name': {'key': 'properties.name', 'type': 'str'},
        'vpn_protocols': {'key': 'properties.vpnProtocols', 'type': '[str]'},
        'vpn_authentication_types': {'key': 'properties.vpnAuthenticationTypes', 'type': '[str]'},
        'vpn_client_root_certificates': {'key': 'properties.vpnClientRootCertificates', 'type': '[VpnServerConfigVpnClientRootCertificate]'},
        'vpn_client_revoked_certificates': {'key': 'properties.vpnClientRevokedCertificates', 'type': '[VpnServerConfigVpnClientRevokedCertificate]'},
        'radius_server_root_certificates': {'key': 'properties.radiusServerRootCertificates', 'type': '[VpnServerConfigRadiusServerRootCertificate]'},
        'radius_client_root_certificates': {'key': 'properties.radiusClientRootCertificates', 'type': '[VpnServerConfigRadiusClientRootCertificate]'},
        'vpn_client_ipsec_policies': {'key': 'properties.vpnClientIpsecPolicies', 'type': '[IpsecPolicy]'},
        'radius_server_address': {'key': 'properties.radiusServerAddress', 'type': 'str'},
        'radius_server_secret': {'key': 'properties.radiusServerSecret', 'type': 'str'},
        'aad_authentication_parameters': {'key': 'properties.aadAuthenticationParameters', 'type': 'AadAuthenticationParameters'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'p2_svpn_gateways': {'key': 'properties.p2SVpnGateways', 'type': '[P2SVpnGateway]'},
        'vpn_server_configuration_properties_etag': {'key': 'properties.etag', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, vpn_server_configuration_name: str=None, vpn_protocols=None, vpn_authentication_types=None, vpn_client_root_certificates=None, vpn_client_revoked_certificates=None, radius_server_root_certificates=None, radius_client_root_certificates=None, vpn_client_ipsec_policies=None, radius_server_address: str=None, radius_server_secret: str=None, aad_authentication_parameters=None, **kwargs) -> None:
        super(VpnServerConfiguration, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.vpn_server_configuration_name = vpn_server_configuration_name
        self.vpn_protocols = vpn_protocols
        self.vpn_authentication_types = vpn_authentication_types
        self.vpn_client_root_certificates = vpn_client_root_certificates
        self.vpn_client_revoked_certificates = vpn_client_revoked_certificates
        self.radius_server_root_certificates = radius_server_root_certificates
        self.radius_client_root_certificates = radius_client_root_certificates
        self.vpn_client_ipsec_policies = vpn_client_ipsec_policies
        self.radius_server_address = radius_server_address
        self.radius_server_secret = radius_server_secret
        self.aad_authentication_parameters = aad_authentication_parameters
        self.provisioning_state = None
        self.p2_svpn_gateways = None
        self.vpn_server_configuration_properties_etag = None
        self.etag = None


class VpnServerConfigurationsResponse(Model):
    """VpnServerConfigurations list associated with VirtualWan Response.

    :param vpn_server_configuration_resource_ids: List of
     VpnServerConfigurations associated with VirtualWan.
    :type vpn_server_configuration_resource_ids: list[str]
    """

    _attribute_map = {
        'vpn_server_configuration_resource_ids': {'key': 'vpnServerConfigurationResourceIds', 'type': '[str]'},
    }

    def __init__(self, *, vpn_server_configuration_resource_ids=None, **kwargs) -> None:
        super(VpnServerConfigurationsResponse, self).__init__(**kwargs)
        self.vpn_server_configuration_resource_ids = vpn_server_configuration_resource_ids


class VpnServerConfigVpnClientRevokedCertificate(Model):
    """Properties of the revoked VPN client certificate of VpnServerConfiguration.

    :param name: The certificate name.
    :type name: str
    :param thumbprint: The revoked VPN client certificate thumbprint.
    :type thumbprint: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, thumbprint: str=None, **kwargs) -> None:
        super(VpnServerConfigVpnClientRevokedCertificate, self).__init__(**kwargs)
        self.name = name
        self.thumbprint = thumbprint


class VpnServerConfigVpnClientRootCertificate(Model):
    """Properties of VPN client root certificate of VpnServerConfiguration.

    :param name: The certificate name.
    :type name: str
    :param public_cert_data: The certificate public data.
    :type public_cert_data: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'public_cert_data': {'key': 'publicCertData', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, public_cert_data: str=None, **kwargs) -> None:
        super(VpnServerConfigVpnClientRootCertificate, self).__init__(**kwargs)
        self.name = name
        self.public_cert_data = public_cert_data


class VpnSite(Resource):
    """VpnSite Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param virtual_wan: The VirtualWAN to which the vpnSite belongs.
    :type virtual_wan: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param device_properties: The device properties.
    :type device_properties:
     ~azure.mgmt.network.v2019_09_01.models.DeviceProperties
    :param ip_address: The ip-address for the vpn-site.
    :type ip_address: str
    :param site_key: The key for vpn-site that can be used for connections.
    :type site_key: str
    :param address_space: The AddressSpace that contains an array of IP
     address ranges.
    :type address_space: ~azure.mgmt.network.v2019_09_01.models.AddressSpace
    :param bgp_properties: The set of bgp properties.
    :type bgp_properties: ~azure.mgmt.network.v2019_09_01.models.BgpSettings
    :ivar provisioning_state: The provisioning state of the VPN site resource.
     Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param is_security_site: IsSecuritySite flag.
    :type is_security_site: bool
    :param vpn_site_links: List of all vpn site links.
    :type vpn_site_links:
     list[~azure.mgmt.network.v2019_09_01.models.VpnSiteLink]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'virtual_wan': {'key': 'properties.virtualWan', 'type': 'SubResource'},
        'device_properties': {'key': 'properties.deviceProperties', 'type': 'DeviceProperties'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'site_key': {'key': 'properties.siteKey', 'type': 'str'},
        'address_space': {'key': 'properties.addressSpace', 'type': 'AddressSpace'},
        'bgp_properties': {'key': 'properties.bgpProperties', 'type': 'BgpSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_security_site': {'key': 'properties.isSecuritySite', 'type': 'bool'},
        'vpn_site_links': {'key': 'properties.vpnSiteLinks', 'type': '[VpnSiteLink]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, location: str=None, tags=None, virtual_wan=None, device_properties=None, ip_address: str=None, site_key: str=None, address_space=None, bgp_properties=None, is_security_site: bool=None, vpn_site_links=None, **kwargs) -> None:
        super(VpnSite, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.virtual_wan = virtual_wan
        self.device_properties = device_properties
        self.ip_address = ip_address
        self.site_key = site_key
        self.address_space = address_space
        self.bgp_properties = bgp_properties
        self.provisioning_state = None
        self.is_security_site = is_security_site
        self.vpn_site_links = vpn_site_links
        self.etag = None


class VpnSiteId(Model):
    """VpnSite Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar vpn_site: The resource-uri of the vpn-site for which config is to be
     fetched.
    :vartype vpn_site: str
    """

    _validation = {
        'vpn_site': {'readonly': True},
    }

    _attribute_map = {
        'vpn_site': {'key': 'vpnSite', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(VpnSiteId, self).__init__(**kwargs)
        self.vpn_site = None


class VpnSiteLink(SubResource):
    """VpnSiteLink Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param link_properties: The link provider properties.
    :type link_properties:
     ~azure.mgmt.network.v2019_09_01.models.VpnLinkProviderProperties
    :param ip_address: The ip-address for the vpn-site-link.
    :type ip_address: str
    :param bgp_properties: The set of bgp properties.
    :type bgp_properties:
     ~azure.mgmt.network.v2019_09_01.models.VpnLinkBgpSettings
    :ivar provisioning_state: The provisioning state of the VPN site link
     resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'link_properties': {'key': 'properties.linkProperties', 'type': 'VpnLinkProviderProperties'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'bgp_properties': {'key': 'properties.bgpProperties', 'type': 'VpnLinkBgpSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, link_properties=None, ip_address: str=None, bgp_properties=None, name: str=None, **kwargs) -> None:
        super(VpnSiteLink, self).__init__(id=id, **kwargs)
        self.link_properties = link_properties
        self.ip_address = ip_address
        self.bgp_properties = bgp_properties
        self.provisioning_state = None
        self.etag = None
        self.name = name
        self.type = None


class VpnSiteLinkConnection(SubResource):
    """VpnSiteLinkConnection Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param vpn_site_link: Id of the connected vpn site link.
    :type vpn_site_link: ~azure.mgmt.network.v2019_09_01.models.SubResource
    :param routing_weight: Routing weight for vpn connection.
    :type routing_weight: int
    :param connection_status: The connection status. Possible values include:
     'Unknown', 'Connecting', 'Connected', 'NotConnected'
    :type connection_status: str or
     ~azure.mgmt.network.v2019_09_01.models.VpnConnectionStatus
    :param vpn_connection_protocol_type: Connection protocol used for this
     connection. Possible values include: 'IKEv2', 'IKEv1'
    :type vpn_connection_protocol_type: str or
     ~azure.mgmt.network.v2019_09_01.models.VirtualNetworkGatewayConnectionProtocol
    :ivar ingress_bytes_transferred: Ingress bytes transferred.
    :vartype ingress_bytes_transferred: long
    :ivar egress_bytes_transferred: Egress bytes transferred.
    :vartype egress_bytes_transferred: long
    :param connection_bandwidth: Expected bandwidth in MBPS.
    :type connection_bandwidth: int
    :param shared_key: SharedKey for the vpn connection.
    :type shared_key: str
    :param enable_bgp: EnableBgp flag.
    :type enable_bgp: bool
    :param use_policy_based_traffic_selectors: Enable policy-based traffic
     selectors.
    :type use_policy_based_traffic_selectors: bool
    :param ipsec_policies: The IPSec Policies to be considered by this
     connection.
    :type ipsec_policies:
     list[~azure.mgmt.network.v2019_09_01.models.IpsecPolicy]
    :param enable_rate_limiting: EnableBgp flag.
    :type enable_rate_limiting: bool
    :param use_local_azure_ip_address: Use local azure ip to initiate
     connection.
    :type use_local_azure_ip_address: bool
    :ivar provisioning_state: The provisioning state of the VPN site link
     connection resource. Possible values include: 'Succeeded', 'Updating',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'ingress_bytes_transferred': {'readonly': True},
        'egress_bytes_transferred': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'vpn_site_link': {'key': 'properties.vpnSiteLink', 'type': 'SubResource'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'vpn_connection_protocol_type': {'key': 'properties.vpnConnectionProtocolType', 'type': 'str'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'connection_bandwidth': {'key': 'properties.connectionBandwidth', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'use_policy_based_traffic_selectors': {'key': 'properties.usePolicyBasedTrafficSelectors', 'type': 'bool'},
        'ipsec_policies': {'key': 'properties.ipsecPolicies', 'type': '[IpsecPolicy]'},
        'enable_rate_limiting': {'key': 'properties.enableRateLimiting', 'type': 'bool'},
        'use_local_azure_ip_address': {'key': 'properties.useLocalAzureIpAddress', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, vpn_site_link=None, routing_weight: int=None, connection_status=None, vpn_connection_protocol_type=None, connection_bandwidth: int=None, shared_key: str=None, enable_bgp: bool=None, use_policy_based_traffic_selectors: bool=None, ipsec_policies=None, enable_rate_limiting: bool=None, use_local_azure_ip_address: bool=None, name: str=None, **kwargs) -> None:
        super(VpnSiteLinkConnection, self).__init__(id=id, **kwargs)
        self.vpn_site_link = vpn_site_link
        self.routing_weight = routing_weight
        self.connection_status = connection_status
        self.vpn_connection_protocol_type = vpn_connection_protocol_type
        self.ingress_bytes_transferred = None
        self.egress_bytes_transferred = None
        self.connection_bandwidth = connection_bandwidth
        self.shared_key = shared_key
        self.enable_bgp = enable_bgp
        self.use_policy_based_traffic_selectors = use_policy_based_traffic_selectors
        self.ipsec_policies = ipsec_policies
        self.enable_rate_limiting = enable_rate_limiting
        self.use_local_azure_ip_address = use_local_azure_ip_address
        self.provisioning_state = None
        self.name = name
        self.etag = None
        self.type = None


class WebApplicationFirewallCustomRule(Model):
    """Defines contents of a web application rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the resource that is unique within a policy. This
     name can be used to access the resource.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    :param priority: Required. Describes priority of the rule. Rules with a
     lower value will be evaluated before rules with a higher value.
    :type priority: int
    :param rule_type: Required. Describes type of rule. Possible values
     include: 'MatchRule', 'Invalid'
    :type rule_type: str or
     ~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallRuleType
    :param match_conditions: Required. List of match conditions.
    :type match_conditions:
     list[~azure.mgmt.network.v2019_09_01.models.MatchCondition]
    :param action: Required. Type of Actions. Possible values include:
     'Allow', 'Block', 'Log'
    :type action: str or
     ~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallAction
    """

    _validation = {
        'name': {'max_length': 128},
        'etag': {'readonly': True},
        'priority': {'required': True},
        'rule_type': {'required': True},
        'match_conditions': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(self, *, priority: int, rule_type, match_conditions, action, name: str=None, **kwargs) -> None:
        super(WebApplicationFirewallCustomRule, self).__init__(**kwargs)
        self.name = name
        self.etag = None
        self.priority = priority
        self.rule_type = rule_type
        self.match_conditions = match_conditions
        self.action = action


class WebApplicationFirewallPolicy(Resource):
    """Defines web application firewall policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource ID.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param policy_settings: Describes policySettings for policy.
    :type policy_settings:
     ~azure.mgmt.network.v2019_09_01.models.PolicySettings
    :param custom_rules: Describes custom rules inside the policy.
    :type custom_rules:
     list[~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallCustomRule]
    :ivar application_gateways: A collection of references to application
     gateways.
    :vartype application_gateways:
     list[~azure.mgmt.network.v2019_09_01.models.ApplicationGateway]
    :ivar provisioning_state: The provisioning state of the web application
     firewall policy resource. Possible values include: 'Succeeded',
     'Updating', 'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2019_09_01.models.ProvisioningState
    :ivar resource_state: Resource status of the policy. Resource status of
     the policy. Possible values include: 'Creating', 'Enabling', 'Enabled',
     'Disabling', 'Disabled', 'Deleting'
    :vartype resource_state: str or
     ~azure.mgmt.network.v2019_09_01.models.WebApplicationFirewallPolicyResourceState
    :param managed_rules: Required. Describes the managedRules structure
    :type managed_rules:
     ~azure.mgmt.network.v2019_09_01.models.ManagedRulesDefinition
    :ivar http_listeners: A collection of references to application gateway
     http listeners.
    :vartype http_listeners:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar path_based_rules: A collection of references to application gateway
     path rules.
    :vartype path_based_rules:
     list[~azure.mgmt.network.v2019_09_01.models.SubResource]
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'application_gateways': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
        'managed_rules': {'required': True},
        'http_listeners': {'readonly': True},
        'path_based_rules': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'policy_settings': {'key': 'properties.policySettings', 'type': 'PolicySettings'},
        'custom_rules': {'key': 'properties.customRules', 'type': '[WebApplicationFirewallCustomRule]'},
        'application_gateways': {'key': 'properties.applicationGateways', 'type': '[ApplicationGateway]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'managed_rules': {'key': 'properties.managedRules', 'type': 'ManagedRulesDefinition'},
        'http_listeners': {'key': 'properties.httpListeners', 'type': '[SubResource]'},
        'path_based_rules': {'key': 'properties.pathBasedRules', 'type': '[SubResource]'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, managed_rules, id: str=None, location: str=None, tags=None, policy_settings=None, custom_rules=None, **kwargs) -> None:
        super(WebApplicationFirewallPolicy, self).__init__(id=id, location=location, tags=tags, **kwargs)
        self.policy_settings = policy_settings
        self.custom_rules = custom_rules
        self.application_gateways = None
        self.provisioning_state = None
        self.resource_state = None
        self.managed_rules = managed_rules
        self.http_listeners = None
        self.path_based_rules = None
        self.etag = None
