from setuptools import setup, find_packages
import pathlib
import re

here = pathlib.Path(__file__).parent.resolve()
long_description = (here / "README.rst").read_text(encoding="utf-8")
version = re.search(
    r'__version__ = "(.+?)"', (here / "pyrsktools" / "__init__.py").read_text("utf8")
).group(1)

setup(
    name="pyRSKtools",
    version=version,
    packages=find_packages(exclude=["env", "contrib", "docs", "tests"]),
    python_requires=">=3.8.0",
    install_requires=["numpy", "scipy", "gsw", "matplotlib", "cmocean"],
    extras_require={
        "dev": ["build", "twine", "black", "mypy", "sphinx", "sphinx-toolbox", "sphinx-paramlinks"],
    },
    include_package_data=True,
    author="RBR",
    author_email="support@rbr-global.com",
    # Metadata
    description="A simple Python toolbox to open RSK SQLite files generated by RBR instruments.",
    long_description=long_description,
    long_description_content_type="text/x-rst",
    license="APLv2",
    classifiers=[
        "Intended Audience :: Science/Research",
        "Topic :: Scientific/Engineering",
        "License :: OSI Approved :: Apache Software License",
        "Programming Language :: Python :: 3",
    ],
    keywords="oceanography rbr rsk ocean",
    project_urls={
        "Bug Reports": "https://rbr-global.com/support/",
        "Wiki": "https://docs.rbr-global.com/pyrsktools",
        "Source": "https://bitbucket.org/rbr/pyrsktools",
    },
)
