# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION


class NetworkManagementClientConfiguration(AzureConfiguration):
    """Configuration for NetworkManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription credentials which uniquely
     identify the Microsoft Azure subscription. The subscription ID forms part
     of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(NetworkManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('networkmanagementclient/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class NetworkManagementClient(object):
    """Network Client

    This ready contains multiple API versions, to help you deal with all Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, uses latest API version available on public Azure.
    For production, you should stick a particular api-version and/or profile.
    The profile sets a mapping between the operation group and an API version.
    The api-version parameter sets the default API version if the operation 
    group is not described in the profile.

    :ivar config: Configuration for client.
    :vartype config: NetworkManagementClientConfiguration

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str api_version: API version to use if no profile is provided, or if
     missing in profile.
    :param str base_url: Service URL
    :param profile: A dict using operation group name to API version.
    :type profile: dict[str, str]
    """

    DEFAULT_API_VERSION='2017-10-01'
    DEFAULT_PROFILE = None

    def __init__(self, credentials, subscription_id, api_version=DEFAULT_API_VERSION, base_url=None, profile=DEFAULT_PROFILE):

        self.config = NetworkManagementClientConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in self.models(api_version).__dict__.items() if isinstance(v, type)}
        self.api_version = api_version
        self.profile = dict(profile) if profile is not None else {}

    def check_dns_name_availability(
            self, location, domain_name_label, custom_headers=None, raw=False, **operation_config):
        """Checks whether a domain name in the cloudapp.azure.com zone is
        available for use.

        :param location: The location of the domain name.
        :type location: str
        :param domain_name_label: The domain name to be verified. It must
         conform to the following regular expression:
         ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
        :type domain_name_label: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: :class:`DnsNameAvailabilityResult
         <azure.mgmt.network.v2017_10_01.models.DnsNameAvailabilityResult>` or
         :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>` if
         raw=true
        :rtype: :class:`DnsNameAvailabilityResult
         <azure.mgmt.network.v2017_10_01.models.DnsNameAvailabilityResult>` or
         :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        """
        if self.api_version == '2017-10-01':
            from .v2017_10_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2017-09-01':
            from .v2017_09_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2017-08-01':
            from .v2017_08_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2017-06-01':
            from .v2017_06_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2017-03-01':
            from .v2017_03_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2016-12-01':
            from .v2016_12_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2016-09-01':
            from .v2016_09_01 import NetworkManagementClient as ClientClass
        elif self.api_version == '2015-06-15':
            from .v2015_06_15 import NetworkManagementClient as ClientClass
        localclient = ClientClass(self.config.credentials,
                                  self.config.subscription_id,
                                  self.config.base_url)
        return localclient.check_dns_name_availability(location,
                                                       domain_name_label,
                                                       custom_headers,
                                                       raw,
                                                       **operation_config)

############ Generated from here ############

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2015-06-15: :mod:`v2015_06_15.models<azure.mgmt.network.v2015_06_15.models>`
           * 2016-09-01: :mod:`v2016_09_01.models<azure.mgmt.network.v2016_09_01.models>`
           * 2016-12-01: :mod:`v2016_12_01.models<azure.mgmt.network.v2016_12_01.models>`
           * 2017-03-01: :mod:`v2017_03_01.models<azure.mgmt.network.v2017_03_01.models>`
           * 2017-06-01: :mod:`v2017_06_01.models<azure.mgmt.network.v2017_06_01.models>`
           * 2017-08-01: :mod:`v2017_08_01.models<azure.mgmt.network.v2017_08_01.models>`
           * 2017-09-01: :mod:`v2017_09_01.models<azure.mgmt.network.v2017_09_01.models>`
           * 2017-10-01: :mod:`v2017_10_01.models<azure.mgmt.network.v2017_10_01.models>`
        """
        if api_version == '2015-06-15':
            from .v2015_06_15 import models
            return models
        elif api_version == '2016-09-01':
            from .v2016_09_01 import models
            return models
        elif api_version == '2016-12-01':
            from .v2016_12_01 import models
            return models
        elif api_version == '2017-03-01':
            from .v2017_03_01 import models
            return models
        elif api_version == '2017-06-01':
            from .v2017_06_01 import models
            return models
        elif api_version == '2017-08-01':
            from .v2017_08_01 import models
            return models
        elif api_version == '2017-09-01':
            from .v2017_09_01 import models
            return models
        elif api_version == '2017-10-01':
            from .v2017_10_01 import models
            return models
        raise NotImplementedError("APIVersion {} is not available".format(api_version))
    
    @property
    def application_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.ApplicationGatewaysOperations>`
           * 2016-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.ApplicationGatewaysOperations>`
           * 2016-12-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.ApplicationGatewaysOperations>`
           * 2017-03-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.ApplicationGatewaysOperations>`
           * 2017-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.ApplicationGatewaysOperations>`
           * 2017-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.ApplicationGatewaysOperations>`
           * 2017-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_09_01.operations.ApplicationGatewaysOperations>`
           * 2017-10-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_10_01.operations.ApplicationGatewaysOperations>`
        """
        api_version = self.profile.get('application_gateways', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ApplicationGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def application_security_groups(self):
        """Instance depends on the API version:

           * 2017-09-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2017_09_01.operations.ApplicationSecurityGroupsOperations>`
           * 2017-10-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2017_10_01.operations.ApplicationSecurityGroupsOperations>`
        """
        api_version = self.profile.get('application_security_groups', self.api_version)
        if api_version == '2017-09-01':
            from .v2017_09_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ApplicationSecurityGroupsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_endpoint_services(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_06_01.operations.AvailableEndpointServicesOperations>`
           * 2017-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_08_01.operations.AvailableEndpointServicesOperations>`
           * 2017-09-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_09_01.operations.AvailableEndpointServicesOperations>`
           * 2017-10-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_10_01.operations.AvailableEndpointServicesOperations>`
        """
        api_version = self.profile.get('available_endpoint_services', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import AvailableEndpointServicesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def bgp_service_communities(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2016_12_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-03-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_03_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_06_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_08_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-09-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_09_01.operations.BgpServiceCommunitiesOperations>`
           * 2017-10-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_10_01.operations.BgpServiceCommunitiesOperations>`
        """
        api_version = self.profile.get('bgp_service_communities', self.api_version)
        if api_version == '2016-12-01':
            from .v2016_12_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import BgpServiceCommunitiesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def default_security_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_06_01.operations.DefaultSecurityRulesOperations>`
           * 2017-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_08_01.operations.DefaultSecurityRulesOperations>`
           * 2017-09-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_09_01.operations.DefaultSecurityRulesOperations>`
           * 2017-10-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_10_01.operations.DefaultSecurityRulesOperations>`
        """
        api_version = self.profile.get('default_security_rules', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import DefaultSecurityRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuit_authorizations(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_09_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_10_01.operations.ExpressRouteCircuitAuthorizationsOperations>`
        """
        api_version = self.profile.get('express_route_circuit_authorizations', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuit_peerings(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_09_01.operations.ExpressRouteCircuitPeeringsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_10_01.operations.ExpressRouteCircuitPeeringsOperations>`
        """
        api_version = self.profile.get('express_route_circuit_peerings', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ExpressRouteCircuitPeeringsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuits(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteCircuitsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteCircuitsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_09_01.operations.ExpressRouteCircuitsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_10_01.operations.ExpressRouteCircuitsOperations>`
        """
        api_version = self.profile.get('express_route_circuits', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ExpressRouteCircuitsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_service_providers(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2015_06_15.operations.ExpressRouteServiceProvidersOperations>`
           * 2016-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2016_09_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2016-12-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2016_12_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-03-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_03_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_06_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_08_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_09_01.operations.ExpressRouteServiceProvidersOperations>`
           * 2017-10-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_10_01.operations.ExpressRouteServiceProvidersOperations>`
        """
        api_version = self.profile.get('express_route_service_providers', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import ExpressRouteServiceProvidersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def inbound_nat_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_06_01.operations.InboundNatRulesOperations>`
           * 2017-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_08_01.operations.InboundNatRulesOperations>`
           * 2017-09-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_09_01.operations.InboundNatRulesOperations>`
           * 2017-10-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_10_01.operations.InboundNatRulesOperations>`
        """
        api_version = self.profile.get('inbound_nat_rules', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import InboundNatRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_backend_address_pools(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-09-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-10-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerBackendAddressPoolsOperations>`
        """
        api_version = self.profile.get('load_balancer_backend_address_pools', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerBackendAddressPoolsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_frontend_ip_configurations(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-09-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-10-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerFrontendIPConfigurationsOperations>`
        """
        api_version = self.profile.get('load_balancer_frontend_ip_configurations', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_load_balancing_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-09-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-10-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerLoadBalancingRulesOperations>`
        """
        api_version = self.profile.get('load_balancer_load_balancing_rules', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerLoadBalancingRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_network_interfaces(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2017-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2017-09-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerNetworkInterfacesOperations>`
           * 2017-10-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerNetworkInterfacesOperations>`
        """
        api_version = self.profile.get('load_balancer_network_interfaces', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerNetworkInterfacesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_probes(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancerProbesOperations>`
           * 2017-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancerProbesOperations>`
           * 2017-09-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancerProbesOperations>`
           * 2017-10-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancerProbesOperations>`
        """
        api_version = self.profile.get('load_balancer_probes', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancerProbesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancers(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`LoadBalancersOperations<azure.mgmt.network.v2015_06_15.operations.LoadBalancersOperations>`
           * 2016-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2016_09_01.operations.LoadBalancersOperations>`
           * 2016-12-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2016_12_01.operations.LoadBalancersOperations>`
           * 2017-03-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_03_01.operations.LoadBalancersOperations>`
           * 2017-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_06_01.operations.LoadBalancersOperations>`
           * 2017-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_08_01.operations.LoadBalancersOperations>`
           * 2017-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_09_01.operations.LoadBalancersOperations>`
           * 2017-10-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_10_01.operations.LoadBalancersOperations>`
        """
        api_version = self.profile.get('load_balancers', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LoadBalancersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LoadBalancersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def local_network_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.LocalNetworkGatewaysOperations>`
           * 2016-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.LocalNetworkGatewaysOperations>`
           * 2016-12-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-03-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_09_01.operations.LocalNetworkGatewaysOperations>`
           * 2017-10-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_10_01.operations.LocalNetworkGatewaysOperations>`
        """
        api_version = self.profile.get('local_network_gateways', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import LocalNetworkGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interface_ip_configurations(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-09-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_09_01.operations.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-10-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_10_01.operations.NetworkInterfaceIPConfigurationsOperations>`
        """
        api_version = self.profile.get('network_interface_ip_configurations', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkInterfaceIPConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interface_load_balancers(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2017-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2017-09-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_09_01.operations.NetworkInterfaceLoadBalancersOperations>`
           * 2017-10-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_10_01.operations.NetworkInterfaceLoadBalancersOperations>`
        """
        api_version = self.profile.get('network_interface_load_balancers', self.api_version)
        if api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkInterfaceLoadBalancersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interfaces(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2015_06_15.operations.NetworkInterfacesOperations>`
           * 2016-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2016_09_01.operations.NetworkInterfacesOperations>`
           * 2016-12-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2016_12_01.operations.NetworkInterfacesOperations>`
           * 2017-03-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_03_01.operations.NetworkInterfacesOperations>`
           * 2017-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_06_01.operations.NetworkInterfacesOperations>`
           * 2017-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_08_01.operations.NetworkInterfacesOperations>`
           * 2017-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_09_01.operations.NetworkInterfacesOperations>`
           * 2017-10-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_10_01.operations.NetworkInterfacesOperations>`
        """
        api_version = self.profile.get('network_interfaces', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkInterfacesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_security_groups(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2015_06_15.operations.NetworkSecurityGroupsOperations>`
           * 2016-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2016_09_01.operations.NetworkSecurityGroupsOperations>`
           * 2016-12-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2016_12_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-03-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_03_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_06_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_08_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_09_01.operations.NetworkSecurityGroupsOperations>`
           * 2017-10-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_10_01.operations.NetworkSecurityGroupsOperations>`
        """
        api_version = self.profile.get('network_security_groups', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkSecurityGroupsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_watchers(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2016_09_01.operations.NetworkWatchersOperations>`
           * 2016-12-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2016_12_01.operations.NetworkWatchersOperations>`
           * 2017-03-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_03_01.operations.NetworkWatchersOperations>`
           * 2017-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_06_01.operations.NetworkWatchersOperations>`
           * 2017-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_08_01.operations.NetworkWatchersOperations>`
           * 2017-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_09_01.operations.NetworkWatchersOperations>`
           * 2017-10-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_10_01.operations.NetworkWatchersOperations>`
        """
        api_version = self.profile.get('network_watchers', self.api_version)
        if api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkWatchersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2017-09-01: :class:`Operations<azure.mgmt.network.v2017_09_01.operations.Operations>`
           * 2017-10-01: :class:`Operations<azure.mgmt.network.v2017_10_01.operations.Operations>`
        """
        api_version = self.profile.get('operations', self.api_version)
        if api_version == '2017-09-01':
            from .v2017_09_01.operations import Operations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import Operations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def packet_captures(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2016_09_01.operations.PacketCapturesOperations>`
           * 2016-12-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2016_12_01.operations.PacketCapturesOperations>`
           * 2017-03-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_03_01.operations.PacketCapturesOperations>`
           * 2017-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_06_01.operations.PacketCapturesOperations>`
           * 2017-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_08_01.operations.PacketCapturesOperations>`
           * 2017-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_09_01.operations.PacketCapturesOperations>`
           * 2017-10-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_10_01.operations.PacketCapturesOperations>`
        """
        api_version = self.profile.get('packet_captures', self.api_version)
        if api_version == '2016-09-01':
            from .v2016_09_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import PacketCapturesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import PacketCapturesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def public_ip_addresses(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2015_06_15.operations.PublicIPAddressesOperations>`
           * 2016-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2016_09_01.operations.PublicIPAddressesOperations>`
           * 2016-12-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2016_12_01.operations.PublicIPAddressesOperations>`
           * 2017-03-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_03_01.operations.PublicIPAddressesOperations>`
           * 2017-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_06_01.operations.PublicIPAddressesOperations>`
           * 2017-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_08_01.operations.PublicIPAddressesOperations>`
           * 2017-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_09_01.operations.PublicIPAddressesOperations>`
           * 2017-10-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_10_01.operations.PublicIPAddressesOperations>`
        """
        api_version = self.profile.get('public_ip_addresses', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import PublicIPAddressesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_filter_rules(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2016_12_01.operations.RouteFilterRulesOperations>`
           * 2017-03-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_03_01.operations.RouteFilterRulesOperations>`
           * 2017-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_06_01.operations.RouteFilterRulesOperations>`
           * 2017-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_08_01.operations.RouteFilterRulesOperations>`
           * 2017-09-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_09_01.operations.RouteFilterRulesOperations>`
           * 2017-10-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_10_01.operations.RouteFilterRulesOperations>`
        """
        api_version = self.profile.get('route_filter_rules', self.api_version)
        if api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import RouteFilterRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_filters(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2016_12_01.operations.RouteFiltersOperations>`
           * 2017-03-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_03_01.operations.RouteFiltersOperations>`
           * 2017-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_06_01.operations.RouteFiltersOperations>`
           * 2017-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_08_01.operations.RouteFiltersOperations>`
           * 2017-09-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_09_01.operations.RouteFiltersOperations>`
           * 2017-10-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_10_01.operations.RouteFiltersOperations>`
        """
        api_version = self.profile.get('route_filters', self.api_version)
        if api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import RouteFiltersOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import RouteFiltersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_tables(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`RouteTablesOperations<azure.mgmt.network.v2015_06_15.operations.RouteTablesOperations>`
           * 2016-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2016_09_01.operations.RouteTablesOperations>`
           * 2016-12-01: :class:`RouteTablesOperations<azure.mgmt.network.v2016_12_01.operations.RouteTablesOperations>`
           * 2017-03-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_03_01.operations.RouteTablesOperations>`
           * 2017-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_06_01.operations.RouteTablesOperations>`
           * 2017-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_08_01.operations.RouteTablesOperations>`
           * 2017-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_09_01.operations.RouteTablesOperations>`
           * 2017-10-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_10_01.operations.RouteTablesOperations>`
        """
        api_version = self.profile.get('route_tables', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import RouteTablesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import RouteTablesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import RouteTablesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def routes(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`RoutesOperations<azure.mgmt.network.v2015_06_15.operations.RoutesOperations>`
           * 2016-09-01: :class:`RoutesOperations<azure.mgmt.network.v2016_09_01.operations.RoutesOperations>`
           * 2016-12-01: :class:`RoutesOperations<azure.mgmt.network.v2016_12_01.operations.RoutesOperations>`
           * 2017-03-01: :class:`RoutesOperations<azure.mgmt.network.v2017_03_01.operations.RoutesOperations>`
           * 2017-06-01: :class:`RoutesOperations<azure.mgmt.network.v2017_06_01.operations.RoutesOperations>`
           * 2017-08-01: :class:`RoutesOperations<azure.mgmt.network.v2017_08_01.operations.RoutesOperations>`
           * 2017-09-01: :class:`RoutesOperations<azure.mgmt.network.v2017_09_01.operations.RoutesOperations>`
           * 2017-10-01: :class:`RoutesOperations<azure.mgmt.network.v2017_10_01.operations.RoutesOperations>`
        """
        api_version = self.profile.get('routes', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import RoutesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import RoutesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import RoutesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import RoutesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_rules(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`SecurityRulesOperations<azure.mgmt.network.v2015_06_15.operations.SecurityRulesOperations>`
           * 2016-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2016_09_01.operations.SecurityRulesOperations>`
           * 2016-12-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2016_12_01.operations.SecurityRulesOperations>`
           * 2017-03-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_03_01.operations.SecurityRulesOperations>`
           * 2017-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_06_01.operations.SecurityRulesOperations>`
           * 2017-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_08_01.operations.SecurityRulesOperations>`
           * 2017-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_09_01.operations.SecurityRulesOperations>`
           * 2017-10-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_10_01.operations.SecurityRulesOperations>`
        """
        api_version = self.profile.get('security_rules', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import SecurityRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import SecurityRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def subnets(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`SubnetsOperations<azure.mgmt.network.v2015_06_15.operations.SubnetsOperations>`
           * 2016-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2016_09_01.operations.SubnetsOperations>`
           * 2016-12-01: :class:`SubnetsOperations<azure.mgmt.network.v2016_12_01.operations.SubnetsOperations>`
           * 2017-03-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_03_01.operations.SubnetsOperations>`
           * 2017-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_06_01.operations.SubnetsOperations>`
           * 2017-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_08_01.operations.SubnetsOperations>`
           * 2017-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_09_01.operations.SubnetsOperations>`
           * 2017-10-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_10_01.operations.SubnetsOperations>`
        """
        api_version = self.profile.get('subnets', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import SubnetsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import SubnetsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import SubnetsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def usages(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`UsagesOperations<azure.mgmt.network.v2015_06_15.operations.UsagesOperations>`
           * 2016-09-01: :class:`UsagesOperations<azure.mgmt.network.v2016_09_01.operations.UsagesOperations>`
           * 2016-12-01: :class:`UsagesOperations<azure.mgmt.network.v2016_12_01.operations.UsagesOperations>`
           * 2017-03-01: :class:`UsagesOperations<azure.mgmt.network.v2017_03_01.operations.UsagesOperations>`
           * 2017-06-01: :class:`UsagesOperations<azure.mgmt.network.v2017_06_01.operations.UsagesOperations>`
           * 2017-08-01: :class:`UsagesOperations<azure.mgmt.network.v2017_08_01.operations.UsagesOperations>`
           * 2017-09-01: :class:`UsagesOperations<azure.mgmt.network.v2017_09_01.operations.UsagesOperations>`
           * 2017-10-01: :class:`UsagesOperations<azure.mgmt.network.v2017_10_01.operations.UsagesOperations>`
        """
        api_version = self.profile.get('usages', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import UsagesOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import UsagesOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import UsagesOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import UsagesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_gateway_connections(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2016-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2016-12-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-03-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_09_01.operations.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-10-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_10_01.operations.VirtualNetworkGatewayConnectionsOperations>`
        """
        api_version = self.profile.get('virtual_network_gateway_connections', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import VirtualNetworkGatewayConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworkGatewaysOperations>`
           * 2016-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkGatewaysOperations>`
           * 2016-12-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-03-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_09_01.operations.VirtualNetworkGatewaysOperations>`
           * 2017-10-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_10_01.operations.VirtualNetworkGatewaysOperations>`
        """
        api_version = self.profile.get('virtual_network_gateways', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import VirtualNetworkGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_peerings(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworkPeeringsOperations>`
           * 2016-12-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-03-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_09_01.operations.VirtualNetworkPeeringsOperations>`
           * 2017-10-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_10_01.operations.VirtualNetworkPeeringsOperations>`
        """
        api_version = self.profile.get('virtual_network_peerings', self.api_version)
        if api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import VirtualNetworkPeeringsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_networks(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworksOperations<azure.mgmt.network.v2015_06_15.operations.VirtualNetworksOperations>`
           * 2016-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2016_09_01.operations.VirtualNetworksOperations>`
           * 2016-12-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2016_12_01.operations.VirtualNetworksOperations>`
           * 2017-03-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_03_01.operations.VirtualNetworksOperations>`
           * 2017-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_06_01.operations.VirtualNetworksOperations>`
           * 2017-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_08_01.operations.VirtualNetworksOperations>`
           * 2017-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_09_01.operations.VirtualNetworksOperations>`
           * 2017-10-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_10_01.operations.VirtualNetworksOperations>`
        """
        api_version = self.profile.get('virtual_networks', self.api_version)
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import VirtualNetworksOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self.config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))
